/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.job;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.ExaminatInfomationUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiPhyexamTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiPhyexamTaskLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="scheduling", name={"enabled"}, havingValue="true")
public class ExaminatInfomationJob {
    private static final Logger log = LoggerFactory.getLogger(ExaminatInfomationJob.class);
    @Autowired
    ApisBusiPhyexamTaskLogMapper apisBusiPhyexamTaskLogMapper;
    @Autowired
    ExaminatInfomationUtil examinatInfomationUtil;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private ApisBusiTaskLogService apisBusiTaskLogService;
    public static final String HEALTH_PASS = "1";
    public static final String UP_GRADE = "2";
    public static final String HEALTH_EXAMINAT_INFOMATION = "3";
    public static final String HEALTH_EXAMINAT_COMPLETE = "4";
    public static final String HEALTH_EXAMINAT_FAIL = "5";
    public static final String HEALTH_EXAMINAT_UPLOAD_IMG_FAIL = "6";
    public static final String BUSS_TYPE_E = "E";
    public static final String BUSS_TYPE_P = "P";
    public static final String HEALTH_EXAMINAT_MQ_FAIL = "7";
    private static final String HEALTH_EXAMINAT_INFOMATION_KEY = "healthExaminatInfomationKey";
    private static final String HEALTH_EXAMINAT_INFOMATION_EMAIL_KEY = "healthExaminatInfomationEmailKey";
    private static final String EXAMINAT_HEALTH_INFO = "examinatHealthInfo";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0/30 * * * ?")
    public void start() {
        if (this.lock(HEALTH_EXAMINAT_INFOMATION_KEY)) {
            try {
                log.warn(" \u9632\u764c\u9669\u5347\u7ea7\u767e\u4e07\u533b\u7597job\u8fdb\u5165");
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.notIn((Object)"status", new Object[]{HEALTH_EXAMINAT_COMPLETE, UP_GRADE, HEALTH_PASS});
                queryWrapper.lt((Object)"retry_count", (Object)5);
                ((QueryWrapper)queryWrapper.isNotNull((Object)"phyexam_reportUrl")).isNotNull((Object)"health_information");
                List apisBusiPhyexamTaskLogs = this.apisBusiPhyexamTaskLogMapper.selectList((Wrapper)queryWrapper);
                if (apisBusiPhyexamTaskLogs == null || apisBusiPhyexamTaskLogs.size() <= 0) {
                    return;
                }
                LocalDateTime start = LocalDateTime.now();
                log.warn("\u9632\u764c\u9669\u5347\u7ea7\u767e\u4e07\u533b\u7597\u5b9a\u65f6\u8c03\u5ea6\u5f00\u59cb");
                ApisBusiTaskLog apisBusiTaskLog = null;
                ApisBusiTaskLog apisBusiTaskLogQuery = null;
                for (ApisBusiPhyexamTaskLog apisBusiPhyexamTaskLog : apisBusiPhyexamTaskLogs) {
                    String applyNo;
                    String proposalNo;
                    String userCode;
                    String policyNo;
                    String phyexamReporturl;
                    String healthInformation;
                    String phyExamResult;
                    block23: {
                        apisBusiTaskLogQuery = new ApisBusiTaskLog();
                        apisBusiTaskLogQuery.setBusinessKey(apisBusiPhyexamTaskLog.getPolicyNo());
                        QueryWrapper qwApisBusiTaskLog = new QueryWrapper((Object)apisBusiTaskLogQuery);
                        apisBusiTaskLog = (ApisBusiTaskLog)this.apisBusiTaskLogService.getOne((Wrapper)qwApisBusiTaskLog);
                        if (ObjectUtil.isNotEmpty((Object)apisBusiTaskLog) && ObjectUtil.isNotEmpty((Object)apisBusiTaskLog.getBusinessKey())) {
                            apisBusiTaskLog.setPushStep(Integer.valueOf(apisBusiTaskLog.getPushStep() + 1));
                        } else {
                            apisBusiTaskLog = new ApisBusiTaskLog();
                            apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.PAY_NOTIFY_CALLBACK.getValue());
                            apisBusiTaskLog.setBusinessKey(apisBusiPhyexamTaskLog.getPolicyNo());
                            apisBusiTaskLog.setRemark("\u4fdd\u5355\u53f7\uff1a" + apisBusiPhyexamTaskLog.getPolicyNo());
                            apisBusiTaskLog.setPushStep(Integer.valueOf(1));
                        }
                        apisBusiTaskLog.setLastPushTime(LocalDateTime.now());
                        apisBusiTaskLog.setPushType(EXAMINAT_HEALTH_INFO);
                        apisBusiTaskLog.setCreator(apisBusiPhyexamTaskLog.getCreator());
                        Integer retryCount = apisBusiPhyexamTaskLog.getRetryCount();
                        apisBusiPhyexamTaskLog.setRetryCount(Integer.valueOf(retryCount + 1));
                        phyExamResult = apisBusiPhyexamTaskLog.getPhyexamResult();
                        healthInformation = apisBusiPhyexamTaskLog.getHealthInformation();
                        phyexamReporturl = apisBusiPhyexamTaskLog.getPhyexamReporturl();
                        policyNo = apisBusiPhyexamTaskLog.getPolicyNo();
                        userCode = apisBusiPhyexamTaskLog.getCreator();
                        proposalNo = "";
                        applyNo = "";
                        try {
                            if (!HEALTH_EXAMINAT_MQ_FAIL.equals(apisBusiPhyexamTaskLog.getStatus()) && !HEALTH_EXAMINAT_INFOMATION.equals(apisBusiPhyexamTaskLog.getStatus()) || UP_GRADE.equals(phyExamResult) && HEALTH_PASS.equals(healthInformation)) break block23;
                            this.examinatInfomationUtil.sendMessage(apisBusiPhyexamTaskLog);
                        }
                        catch (ApisBusinessException e) {
                            log.error("\u4fdd\u5355\u53f7\uff1a{}\u5347\u7ea7\u767e\u4e07\u533b\u7597\u53d1\u9001mq\u51fa\u9519\uff1a{}", (Object)apisBusiPhyexamTaskLog.getPolicyNo(), (Object)e.getMessage());
                            apisBusiPhyexamTaskLog.setStatus(HEALTH_EXAMINAT_MQ_FAIL);
                            apisBusiPhyexamTaskLog.setRemark(e.getMessage());
                            this.apisBusiPhyexamTaskLogMapper.updateById((Object)apisBusiPhyexamTaskLog);
                            apisBusiTaskLog.setErrMsg(e.getMessage());
                            this.apisBusiTaskLogService.saveOrUpdate((Object)apisBusiTaskLog);
                            continue;
                        }
                        catch (Exception e) {
                            log.error("\u4fdd\u5355\u53f7{}\u5347\u7ea7\u767e\u4e07\u533b\u7597\u53d1\u9001mq\u51fa\u9519\uff1a", (Object)apisBusiPhyexamTaskLog.getPolicyNo(), (Object)e);
                            apisBusiPhyexamTaskLog.setStatus(HEALTH_EXAMINAT_MQ_FAIL);
                            this.apisBusiPhyexamTaskLogMapper.updateById((Object)apisBusiPhyexamTaskLog);
                            apisBusiTaskLog.setErrMsg(e.getMessage());
                            this.apisBusiTaskLogService.saveOrUpdate((Object)apisBusiTaskLog);
                            continue;
                        }
                    }
                    try {
                        StanderRequest request = StanderRequest.builder().header(StanderHeader.builder().userCode(userCode).build()).build();
                        PolicyDetailResponseDTO policyDetailResponseDTO = this.examinatInfomationUtil.verifPolicy(request, policyNo, userCode);
                        proposalNo = policyDetailResponseDTO.getPolicy().getMain().getProposalNo();
                        if (UP_GRADE.equals(phyExamResult) && HEALTH_PASS.equals(healthInformation)) {
                            applyNo = this.examinatInfomationUtil.examinatEndor(policyNo, userCode, policyDetailResponseDTO, apisBusiPhyexamTaskLog);
                            apisBusiPhyexamTaskLog.setApplyNo(applyNo);
                        }
                        apisBusiPhyexamTaskLog.setStatus(HEALTH_EXAMINAT_COMPLETE);
                        this.apisBusiPhyexamTaskLogMapper.updateById((Object)apisBusiPhyexamTaskLog);
                    }
                    catch (ApisBusinessException e) {
                        log.error("\u4fdd\u5355\u53f7\uff1a{}\u5347\u7ea7\u767e\u4e07\u533b\u7597\u6279\u6539\u51fa\u9519\uff1a", (Object)apisBusiPhyexamTaskLog.getPolicyNo(), (Object)e.getMessage());
                        apisBusiPhyexamTaskLog.setStatus(HEALTH_EXAMINAT_FAIL);
                        apisBusiPhyexamTaskLog.setRemark(e.getMessage());
                        if ("\u8ba1\u5212\u4e0d\u652f\u6301\u5347\u7ea7".equals(e.getMessage())) {
                            this.examinatInfomationUtil.sendMessage(apisBusiPhyexamTaskLog);
                        }
                        this.apisBusiPhyexamTaskLogMapper.updateById((Object)apisBusiPhyexamTaskLog);
                        apisBusiTaskLog.setErrMsg(e.getMessage());
                        this.apisBusiTaskLogService.saveOrUpdate((Object)apisBusiTaskLog);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("\u4fdd\u5355\u53f7{}\u5347\u7ea7\u767e\u4e07\u533b\u7597\u6279\u6539\u51fa\u9519\uff1a", (Object)apisBusiPhyexamTaskLog.getPolicyNo(), (Object)e);
                        apisBusiPhyexamTaskLog.setStatus(HEALTH_EXAMINAT_FAIL);
                        this.apisBusiPhyexamTaskLogMapper.updateById((Object)apisBusiPhyexamTaskLog);
                        apisBusiTaskLog.setErrMsg(e.getMessage());
                        this.apisBusiTaskLogService.saveOrUpdate((Object)apisBusiTaskLog);
                        continue;
                    }
                    try {
                        if (UP_GRADE.equals(phyExamResult) && HEALTH_PASS.equals(healthInformation) && StringUtils.isNotBlank((CharSequence)applyNo)) {
                            this.examinatInfomationUtil.syncUpload(phyexamReporturl, applyNo, userCode, BUSS_TYPE_E);
                            continue;
                        }
                        this.examinatInfomationUtil.syncUpload(phyexamReporturl, proposalNo, userCode, BUSS_TYPE_P);
                    }
                    catch (ApisBusinessException e) {
                        log.error("\u4fdd\u5355\u53f7\uff1a{}\u5347\u7ea7\u767e\u4e07\u533b\u7597\u4e0a\u4f20\u5f71\u50cf\u51fa\u9519\uff1a", (Object)apisBusiPhyexamTaskLog.getPolicyNo(), (Object)e.getMessage());
                        apisBusiPhyexamTaskLog.setRemark(e.getMessage());
                        apisBusiPhyexamTaskLog.setStatus(HEALTH_EXAMINAT_UPLOAD_IMG_FAIL);
                        this.apisBusiPhyexamTaskLogMapper.updateById((Object)apisBusiPhyexamTaskLog);
                        apisBusiTaskLog.setErrMsg(e.getMessage());
                        this.apisBusiTaskLogService.saveOrUpdate((Object)apisBusiTaskLog);
                    }
                    catch (Exception e) {
                        log.error("\u4fdd\u5355\u53f7{}\u5347\u7ea7\u767e\u4e07\u533b\u7597\u4e0a\u4f20\u5f71\u50cf\u51fa\u9519\uff1a", (Object)apisBusiPhyexamTaskLog.getPolicyNo(), (Object)e);
                        apisBusiPhyexamTaskLog.setStatus(HEALTH_EXAMINAT_UPLOAD_IMG_FAIL);
                        this.apisBusiPhyexamTaskLogMapper.updateById((Object)apisBusiPhyexamTaskLog);
                        apisBusiTaskLog.setErrMsg(e.getMessage());
                        this.apisBusiTaskLogService.saveOrUpdate((Object)apisBusiTaskLog);
                    }
                }
                LocalDateTime end = LocalDateTime.now();
                Duration duration = Duration.between(start, end);
                log.warn("\u9632\u764c\u9669\u5347\u7ea7\u767e\u4e07\u533b\u7597\u5b9a\u65f6\u8c03\u5ea6\u7ed3\u675f\uff0c\u8c03\u5ea6\u65f6\u95f4\uff1a{}/\u6beb\u79d2", (Object)duration.toMillis());
            }
            catch (Exception e) {
                log.error("\u9632\u764c\u9669\u5347\u7ea7\u767e\u4e07\u533b\u7597\u5b9a\u65f6\u8c03\u5ea6\u9519\u8bef\uff1a", (Throwable)e);
            }
            finally {
                this.deleteByKey(HEALTH_EXAMINAT_INFOMATION_KEY);
            }
        }
    }

    @Scheduled(cron="0 0 10 * * ?")
    public void sendEmatilStart() {
        if (this.lock(HEALTH_EXAMINAT_INFOMATION_EMAIL_KEY)) {
            try {
                LocalDateTime todayStart = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
                LocalDateTime todayEnd = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
                this.examinatInfomationUtil.sendEmail(todayStart.plusDays(-1L), todayEnd.plusDays(-1L));
            }
            catch (Exception e) {
                log.error("\u9632\u764c\u9669\u5347\u7ea7\u767e\u4e07\u533b\u7597\u5b9a\u65f6\u53d1\u90ae\u4ef6\u9519\u8bef\uff1a", (Throwable)e);
            }
        }
    }

    public boolean lock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)key, 10L, TimeUnit.MINUTES);
    }

    public void deleteByKey(String key) {
        this.redisTemplate.delete((Object)key);
    }
}

