/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.job;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.ApisBusiLitigationPushLogService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.CoreGuaranteeApi;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.LitigationCoreGuaranteeApi;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.WarnSendService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.EmailCommonUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.InsureCancelAutoDeductionPushUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.LitigationUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.SaveInstallmentPayRecordAndPushUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.TaskUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.BaseResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUwResultMsgDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.CommentNotifyResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.InstallmentPayRecordSaveRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelInstallmentOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiGuaranteeOffLineOrderLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiGuaranteeUnderwriteResultLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiLitigationPushLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiEmailSendLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiLitigationPushLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelInstallmentOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiGuaranteeOffLineOrderLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiGuaranteeUnderwriteResultLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="scheduling", name={"enabled"}, havingValue="true")
public class Task {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    @Autowired
    LitigationUtils litigationUtils;
    @Autowired
    ApisBusiGuaranteeOffLineOrderLogService apisBusiGuaranteeOffLineOrderLogService;
    @Autowired
    private ApisBusiLitigationPushLogService apisBusiLitigationPushLogService;
    @Autowired
    private ApisBusiGuaranteeUnderwriteResultLogService apisBusiGuaranteeUnderwriteResultLogService;
    @Autowired
    private CoreGuaranteeApi coreGuaranteeApi;
    @Autowired
    private ApisBusiLitigationPushLogMapper apisBusiLitigationPushLogMapper;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    @Autowired
    ApisBusiChannelInstallmentOrderService apisBusiChannelInstallmentOrderService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    private ApisBusiEmailSendLogMapper emailSendLogMapper;
    @Autowired
    private EmailCommonUtil emailCommonUtil;
    @Autowired
    private LitigationCoreGuaranteeApi litigationCoreGuaranteeApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    SaveInstallmentPayRecordAndPushUtil saveInstallmentPayRecordAndPushUtil;
    @Autowired
    InsureCancelAutoDeductionPushUtil insureCancelAutoDeductionPushUtil;
    @Autowired
    TaskUtil taskUtil;
    @Autowired
    WarnSendService warnSendService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    private static final String LITIGATION_PUSH_LOG_TASK_KEY = "litigationPushLogTaskKey";
    private static final String PUSH_POLICY_TO_HIGH_COURT_KEY = "pushPolicyToHighCourtKey";
    private static final String PUSH_UW_RESULT_AND_PAY_KEY = "pushUwResultAndPayKey";
    private static final String LITIGATION_EMAIL_SEND_KEY = "litigationEmailSendKey";
    private static final String EXAMINAT_HEALTH_INFO = "examinatHealthInfo";
    private static final String GROUP_NOTIFY = "group_notify";
    @Value(value="${PushInstallmentPayRecordToAgent.max_push_times}")
    private Integer maxPushTimes = 3;
    @Value(value="${PolicyCancelAsyncConfirm.maxPushTimes}")
    private Integer maxPolicyCancelPushTimes = 30;
    private static List<String> defaultPlanCode = Arrays.asList("ZR-SSBQ-FY-2C");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0/5 * * * ?")
    public void pushPolicyToHighCourt() {
        if (this.lock(PUSH_POLICY_TO_HIGH_COURT_KEY)) {
            log.warn("\u5b9a\u65f6\u4efb\u52a1\u63a8\u9001\u7ebf\u4e0b\u6295\u4fdd\u5230\u9ad8\u9662======");
            try {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.ne((Object)"push_status", (Object)"1");
                queryWrapper.le((Object)"push_step", (Object)BusinessConstants.LITIGATION_CONSTANTS.OFF_LINE_POLICY_MAX_PUSH_TIME);
                List list = this.apisBusiGuaranteeOffLineOrderLogService.list((Wrapper)queryWrapper);
                for (ApisBusiGuaranteeOffLineOrderLog offLineOrder : list) {
                    log.warn("\u63a8\u9001\u7ebf\u4e0b\u6295\u4fdd\u5230\u9ad8\u9662>>\u4fdd\u5355\u53f7\uff1a{}", (Object)offLineOrder.getPolicyNo());
                    this.litigationUtils.pushPolicyToHighCourt(offLineOrder);
                }
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u7ebf\u4e0b\u6295\u4fdd\u5230\u9ad8\u9662error:", (Throwable)e);
            }
            finally {
                this.deleteByKey(PUSH_POLICY_TO_HIGH_COURT_KEY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0/2 * * * ?")
    public void pushUwResultAndPayUrl() {
        if (this.lock(PUSH_UW_RESULT_AND_PAY_KEY)) {
            log.warn("\u5b9a\u65f6\u4efb\u52a1\u63a8\u9001\u6838\u4fdd\u7ed3\u679c\u4e0e\u7f34\u8d39\u94fe\u63a5======");
            try {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.ne((Object)"push_status", (Object)"1");
                queryWrapper.le((Object)"push_step", (Object)BusinessConstants.LITIGATION_CONSTANTS.UW_PAYURL_BD_BH_MAX_PUSH_TIME);
                List list = this.apisBusiGuaranteeUnderwriteResultLogService.list((Wrapper)queryWrapper);
                for (ApisBusiGuaranteeUnderwriteResultLog result : list) {
                    this.litigationUtils.pushUwResultAndPayUrl(result);
                }
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u6838\u4fdd\u7ed3\u679c\u4e0e\u7f34\u8d39\u94fe\u63a5error:", (Throwable)e);
            }
            finally {
                this.deleteByKey(PUSH_UW_RESULT_AND_PAY_KEY);
            }
        }
    }

    @Scheduled(cron="0 */2 * * * ?")
    public void litigationPushLogTask() {
        if (this.lock(LITIGATION_PUSH_LOG_TASK_KEY)) {
            log.warn("\u63a8\u9001\u4fdd\u5355\u4fdd\u51fd\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u3002\u3002\u3002");
            try {
                List pushLogList = this.apisBusiLitigationPushLogService.getAllNeedPush();
                pushLogList.forEach(p -> {
                    Boolean success = true;
                    String errMsg = "";
                    CommentNotifyResponseDTO request = new CommentNotifyResponseDTO(p.getAgencyCode(), p.getPolicyRef(), p.getPaymentMethod(), p.getPayTime());
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"policy_no", (Object)request.getPolicyRef());
                    ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
                    BaseResponse response = null;
                    try {
                        response = defaultPlanCode.contains(order.getPlanCode()) ? this.coreGuaranteeApi.litigationPushPayGuarantee(request) : this.litigationCoreGuaranteeApi.litigationPushPayGuarantee(request);
                        if (!"200".equals(response.getCode())) {
                            success = false;
                            errMsg = response.getMsg();
                            p.setPushStatus("4");
                        }
                    }
                    catch (Exception e) {
                        success = false;
                        errMsg = e.getMessage();
                        p.setPushStatus("4");
                    }
                    if (success.booleanValue()) {
                        p.setPushStatus("1");
                        if (defaultPlanCode.contains(order.getPlanCode())) {
                            this.emailCommonUtil.saveLitigationBdbhEmailSendLog(p.getPolicyRef());
                        }
                    } else if ((p.getPushStep() + 1) % 10 == 0) {
                        this.warnSendService.convertSaveWarnSendEmail("/litigationPushPayGuarantee", order, ObjectUtil.isNotEmpty((Object)response) ? response.getCode() : "", errMsg);
                    }
                    p.setPushStep(Integer.valueOf(p.getPushStep() + 1));
                    p.setLastPushTime(new Date());
                    p.setUpdateTime(new Date());
                    this.apisBusiLitigationPushLogMapper.updateById(p);
                    ApisBusiTaskLog paramLog = new ApisBusiTaskLog();
                    BeanUtil.copyProperties((Object)p, (Object)paramLog, (String[])new String[0]);
                    paramLog.setErrMsg(errMsg);
                    paramLog.setBusinessKey(p.getPolicyRef());
                    paramLog.setPushType(ApisAutoTaskConstantsEnum.BD_BH_TO_GY.getValue());
                    this.litigationUtils.handlerTaskLog(paramLog, BusinessConstants.LITIGATION_CONSTANTS.BD_BH_MAX_PUSH_TIME);
                });
            }
            catch (Exception e) {
                log.error("\u4fdd\u5355\u4fdd\u51fd\u63a8\u9001\u9ad8\u9662\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.deleteByKey(LITIGATION_PUSH_LOG_TASK_KEY);
            }
        }
    }

    @Scheduled(cron="0 */60 * * * ?")
    public void debitNoteToSalesTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.DEBITNOTE_TO_SALES.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushData(ApisAutoTaskConstantsEnum.DEBITNOTE_TO_SALES.getValue());
                log.warn("\u5206\u671f\u4ed8\u6b3e\u901a\u77e5\u9500\u7ba1\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb==" + taskList.size());
                taskList.forEach(t -> {
                    try {
                        t.setPushStep(Integer.valueOf(t.getPushStep() + 1));
                        int idx = t.getBusinessKey().lastIndexOf("-");
                        String policyNo = t.getBusinessKey().substring(0, idx);
                        String payNo = t.getBusinessKey().substring(idx + 1, t.getBusinessKey().length());
                        QueryWrapper queryWrapper = new QueryWrapper();
                        ((QueryWrapper)queryWrapper.eq((Object)"policy_no", (Object)policyNo)).eq((Object)"current_pay_no", (Object)payNo);
                        ApisBusiChannelInstallmentOrder apisBusiChannelInstallmentOrder = (ApisBusiChannelInstallmentOrder)this.apisBusiChannelInstallmentOrderService.getOne((Wrapper)queryWrapper);
                        this.taskUtil.payNotifyToSales(apisBusiChannelInstallmentOrder);
                        t.setPushStatus("1");
                    }
                    catch (ApisBusinessException e) {
                        t.setPushStatus("4");
                        t.setErrMsg(e.getMessage());
                    }
                    catch (Exception e) {
                        t.setPushStatus("4");
                        t.setErrMsg(e.getMessage());
                        log.error("\u5206\u671f\u4ed8\u6b3e\u901a\u77e5\u9500\u7ba1\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519\uff1a{}", (Throwable)e);
                    }
                    finally {
                        if ("1".equals(t.getPushStatus())) {
                            t.setErrMsg("");
                        }
                        t.setLastPushTime(LocalDateTime.now());
                        this.apisBusiTaskLogService.updateById(t);
                    }
                });
            }
            catch (Exception e) {
                log.error("\u5206\u671f\u4ed8\u6b3e\u901a\u77e5\u9500\u7ba1\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.DEBITNOTE_TO_SALES.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 */1 * * * ?")
    public void litigationEmailPushLogTask() {
        if (this.emailCommonUtil.getLitigationEmailOpen().equals("0")) {
            log.warn("\u672a\u5f00\u542f\u90ae\u4ef6\u53d1\u9001\u529f\u80fd\uff0c\u4e0d\u6267\u884c\u5b9a\u65f6\u4efb\u52a1");
            return;
        }
        if (this.lock(LITIGATION_EMAIL_SEND_KEY)) {
            log.warn("\u90ae\u4ef6\u63a8\u9001\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u3002\u3002\u3002");
            try {
                QueryWrapper emailSendLogQueryWrapper = new QueryWrapper();
                emailSendLogQueryWrapper.eq((Object)"send_status", (Object)"0");
                Calendar cal = Calendar.getInstance();
                cal.add(5, -1);
                emailSendLogQueryWrapper.gt((Object)"create_time", (Object)cal.getTime());
                List pushLogList = this.emailSendLogMapper.selectList((Wrapper)emailSendLogQueryWrapper);
                pushLogList.forEach(p -> {
                    boolean success = this.emailCommonUtil.sendEmail(p.getSubject(), p.getContent(), p.getEmailTo(), p.getEmailCc());
                    if (success) {
                        p.setSendStatus("1");
                        p.setSendTime(new Date());
                    }
                    p.setSendStep(Integer.valueOf(p.getSendStep() + 1));
                    p.setLastSendTime(new Date());
                    p.setUpdateTime(new Date());
                    this.emailSendLogMapper.updateById(p);
                });
            }
            finally {
                this.deleteByKey(LITIGATION_EMAIL_SEND_KEY);
            }
        }
    }

    public boolean lock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)key, 10L, TimeUnit.MINUTES);
    }

    public void deleteByKey(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Scheduled(cron="0 */10 * * * ?")
    public void pushInstallmentPayRecoredToAgentTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.INSTALLMENT_PAY_RECORED_TO_AGENT.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.INSTALLMENT_PAY_RECORED_TO_AGENT.getValue(), this.maxPushTimes);
                log.warn("\u63a8\u9001\u671f\u7f34\u6263\u6b3e\u7ed3\u679c\u7ed9\u6e20\u9053\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> {
                    ApisBusiChannelInstallmentOrder apisBusiChannelInstallmentOrder = new ApisBusiChannelInstallmentOrder();
                    apisBusiChannelInstallmentOrder.setOrderNo(t.getBusinessKey());
                    QueryWrapper qw = new QueryWrapper((Object)apisBusiChannelInstallmentOrder);
                    ApisBusiChannelInstallmentOrder busiChannelInstallmentOrder = (ApisBusiChannelInstallmentOrder)this.apisBusiChannelInstallmentOrderService.getOne((Wrapper)qw);
                    if (ObjectUtil.isNotEmpty((Object)busiChannelInstallmentOrder)) {
                        InstallmentPayRecordSaveRequestDTO installmentPayRecordSaveRequestDTO = InstallmentPayRecordSaveRequestDTO.builder().build();
                        BeanUtils.copyProperties((Object)busiChannelInstallmentOrder, (Object)installmentPayRecordSaveRequestDTO);
                        installmentPayRecordSaveRequestDTO.setPayAmount(busiChannelInstallmentOrder.getCurrentPremium());
                        installmentPayRecordSaveRequestDTO.setPayNo(busiChannelInstallmentOrder.getCurrentPayNo());
                        installmentPayRecordSaveRequestDTO.setUserCode(busiChannelInstallmentOrder.getCreator());
                        installmentPayRecordSaveRequestDTO.setPayTime(Date.from(busiChannelInstallmentOrder.getPayTime().atZone(ZoneId.systemDefault()).toInstant()));
                        installmentPayRecordSaveRequestDTO.setDueDate(Date.from(busiChannelInstallmentOrder.getDueDate().atZone(ZoneId.systemDefault()).toInstant()));
                        this.saveInstallmentPayRecordAndPushUtil.pushInstallmentPayRecordToAgent(installmentPayRecordSaveRequestDTO, t);
                    } else {
                        log.error("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4ea4\u6613\u6263\u6b3e\u8bb0\u5f55\uff0c\u4ea4\u6613\u8ba2\u5355\u53f7\uff1a" + t.getBusinessKey());
                    }
                });
            }
            catch (Exception e) {
                log.error("pushInstallmentPayRecoredToAgentTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.INSTALLMENT_PAY_RECORED_TO_AGENT.getKey());
            }
        }
    }

    @Scheduled(cron="0 */2 * * * ?")
    public void pushLitigationPolicySurrenderTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.LITIGATION_NOTIFY_CALLBACK.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.LITIGATION_NOTIFY_CALLBACK.getValue(), BusinessConstants.LITIGATION_CONSTANTS.MAX_TIME);
                log.warn("\u9ad8\u9662\u901a\u77e5\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb== {}", (Object)taskList.size());
                taskList.forEach(t -> this.litigationUtils.pushContentToLitigation(t));
            }
            catch (Exception e) {
                log.error("pushLitigationPolicySurrenderTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.LITIGATION_NOTIFY_CALLBACK.getKey());
            }
        }
    }

    @Scheduled(cron="30 */2 * * * ?")
    public void pushLitigationOnlineGeneralTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.ON_LINE_GENERAL_CORRECT_TO_GY.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.ON_LINE_GENERAL_CORRECT_TO_GY.getValue(), BusinessConstants.LITIGATION_CONSTANTS.MAX_TIME);
                log.warn("\u9ad8\u9662\u901a\u77e5\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb== {}", (Object)taskList.size());
                taskList.forEach(t -> this.litigationUtils.pushOnlineGeneralTask(t));
            }
            catch (Exception e) {
                log.error("pushLitigationPolicySurrenderTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.ON_LINE_GENERAL_CORRECT_TO_GY.getKey());
            }
        }
    }

    @Scheduled(cron="40 */2 * * * ?")
    public void pushLitigationOnlineUwGeneralTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.ON_LINE_UW_GENERAL_CORRECT_TO_GY.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.ON_LINE_UW_GENERAL_CORRECT_TO_GY.getValue(), BusinessConstants.LITIGATION_CONSTANTS.MAX_TIME);
                log.warn("\u9ad8\u9662\u901a\u77e5\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb== {}", (Object)taskList.size());
                taskList.forEach(t -> this.litigationUtils.generalUwResultNotify((LitigationUwResultMsgDTO)JSON.parseObject((String)t.getPushContent(), LitigationUwResultMsgDTO.class), t));
            }
            catch (Exception e) {
                log.error("pushLitigationPolicySurrenderTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.ON_LINE_UW_GENERAL_CORRECT_TO_GY.getKey());
            }
        }
    }

    @Scheduled(cron="30 */1 * * * ?")
    public void pushDeclarationVoucherReturnToUserTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.DECLARATION_VOUCHER_NOTIFY.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.DECLARATION_VOUCHER_NOTIFY.getValue(), this.maxPushTimes);
                log.warn("\u7533\u62a5\u51ed\u8bc1\u5f02\u6b65\u901a\u77e5\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.taskUtil.pushContentToUrl(t));
            }
            catch (Exception e) {
                log.error("pushDeclarationVoucherReturnToUserTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.DECLARATION_VOUCHER_NOTIFY.getKey());
            }
        }
    }

    @Scheduled(cron="0 */5 * * * ?")
    public void pushPaymentNotifyToAgentTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.PAY_NOTIFY_CALLBACK.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.PAY_NOTIFY_CALLBACK.getValue(), this.maxPushTimes);
                log.warn("\u63a8\u9001\u652f\u4ed8\u7ed3\u679c\u7ed9\u6e20\u9053\uff08PaymentGateway\u5f02\u6b65\uff09\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.taskUtil.pushFormContentToUrl(t, ApisAutoTaskConstantsEnum.PAY_NOTIFY_CALLBACK.getValue()));
            }
            catch (Exception e) {
                log.error("pushPaymentNotifyToAgentTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.PAY_NOTIFY_CALLBACK.getKey());
            }
        }
    }

    @Scheduled(cron="0 */5 * * * ?")
    public void pushExaminatHealthInfo() {
        if (this.lock(EXAMINAT_HEALTH_INFO)) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(EXAMINAT_HEALTH_INFO, this.maxPushTimes);
                log.warn("\u4e8c\u6b21\u5065\u544a\u5347\u7ea7\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.taskUtil.pushExaminatHealthInfo(t, EXAMINAT_HEALTH_INFO));
            }
            catch (Exception e) {
                log.error("\u4e8c\u6b21\u5065\u544a\u5347\u7ea7\u5904\u7406\u5b9a\u65f6\u4efb\u52a1 error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(EXAMINAT_HEALTH_INFO);
            }
        }
    }

    @Scheduled(cron="0 */5 * * * ?")
    public void pushGroupPolicyNotifyToAgentTask() {
        if (this.lock(GROUP_NOTIFY)) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(GROUP_NOTIFY, this.maxPushTimes);
                log.warn("\u56e2\u9669\u63a8\u9001\u5ba1\u6838\u7ed3\u679c\uff0c\u51fa\u5355\u7ed3\u679c\u7ed9\u6e20\u9053 \u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.taskUtil.pushJsonToUrl(t));
            }
            catch (Exception e) {
                log.error("pushGroupPolicyNotifyToAgentTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(GROUP_NOTIFY);
            }
        }
    }

    @Scheduled(cron="25 */2 * * * ?")
    public void pushUwResultAndPayUrlToGy() {
        if (this.lock(ApisAutoTaskConstantsEnum.UWRESULT_PAYURL_TO_GY.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.UWRESULT_PAYURL_TO_GY.getValue(), this.maxPushTimes);
                log.warn("\u63a8\u9001\u6838\u4fdd\u7ed3\u679c\u548c\u7f34\u8d39\u94fe\u63a5\u7ed9\u9ad8\u9662(\u66f4\u65b0\u63a8\u9001\u72b6\u6001\uff0c\u91cd\u65b0\u89e6\u53d1\u5b9a\u65f6\u4efb\u52a1)\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> {
                    t.setPushStatus("2");
                    this.apisBusiTaskLogService.updateById(t);
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"proposalNo", (Object)t.getBusinessKey());
                    ApisBusiGuaranteeUnderwriteResultLog log = (ApisBusiGuaranteeUnderwriteResultLog)this.apisBusiGuaranteeUnderwriteResultLogService.getOne((Wrapper)queryWrapper);
                    log.setPushStatus("0");
                    log.setPushStep(Integer.valueOf(0));
                    this.apisBusiGuaranteeUnderwriteResultLogService.updateById((Object)log);
                });
            }
            catch (Exception e) {
                log.error("pushUwResultAndPayUrlToGy error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.UWRESULT_PAYURL_TO_GY.getKey());
            }
        }
    }

    @Scheduled(cron="10 */3 * * * ?")
    public void pushBdBhToGy() {
        if (this.lock(ApisAutoTaskConstantsEnum.BD_BH_TO_GY.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.BD_BH_TO_GY.getValue(), this.maxPushTimes);
                log.warn("\u63a8\u9001\u4fdd\u5355\u4fdd\u51fd\u7ed9\u9ad8\u9662(\u66f4\u65b0\u63a8\u9001\u72b6\u6001\uff0c\u91cd\u65b0\u89e6\u53d1\u5b9a\u65f6\u4efb\u52a1)\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> {
                    t.setPushStatus("2");
                    this.apisBusiTaskLogService.updateById(t);
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"policy_ref", (Object)t.getBusinessKey());
                    ApisBusiLitigationPushLog log = (ApisBusiLitigationPushLog)this.apisBusiLitigationPushLogService.getOne((Wrapper)queryWrapper);
                    log.setPushStatus("0");
                    log.setPushStep(Integer.valueOf(0));
                    this.apisBusiLitigationPushLogService.updateById((Object)log);
                });
            }
            catch (Exception e) {
                log.error("pushBdBhToGy error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.BD_BH_TO_GY.getKey());
            }
        }
    }

    @Scheduled(cron="15 */5 * * * ?")
    public void offLinePolicyToGy() {
        if (this.lock(ApisAutoTaskConstantsEnum.OFFLINE_POLICY_TO_GY.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.OFFLINE_POLICY_TO_GY.getValue(), this.maxPushTimes);
                log.warn("\u7ebf\u4e0b\u6295\u4fdd\u4fdd\u5355\u7ed9\u9ad8\u9662(\u66f4\u65b0\u63a8\u9001\u72b6\u6001\uff0c\u91cd\u65b0\u89e6\u53d1\u5b9a\u65f6\u4efb\u52a1)\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> {
                    t.setPushStatus("2");
                    this.apisBusiTaskLogService.updateById(t);
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"policy_no", (Object)t.getBusinessKey());
                    ApisBusiGuaranteeOffLineOrderLog log = (ApisBusiGuaranteeOffLineOrderLog)this.apisBusiGuaranteeOffLineOrderLogService.getOne((Wrapper)queryWrapper);
                    log.setPushStatus("0");
                    log.setPushStep(Integer.valueOf(0));
                    this.apisBusiGuaranteeOffLineOrderLogService.updateById((Object)log);
                });
            }
            catch (Exception e) {
                log.error("offLinePolicyToGy error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.OFFLINE_POLICY_TO_GY.getKey());
            }
        }
    }

    @Scheduled(cron="40 */2 * * * ?")
    public void pushPolicyCancelAsyncConfirmTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.POLICY_CANCEL_ASYNC_CONFIRM.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.POLICY_CANCEL_ASYNC_CONFIRM.getValue(), this.maxPolicyCancelPushTimes);
                log.warn("\u5f02\u6b65\u9000\u4fdd\u786e\u8ba4\u5931\u8d25\u91cd\u8bd5\uff0c\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.taskUtil.doPolicyCancelAsyncConfirmExecute(t));
            }
            catch (Exception e) {
                log.error("pushPolicyCancelAsyncConfirmTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.POLICY_CANCEL_ASYNC_CONFIRM.getKey());
            }
        }
    }

    @Scheduled(cron="20 */2 * * * ?")
    public void pushPolicyCancelAsyncEndorsePriceTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.POLICY_CANCEL_ASYNC_ENDORSE_PRICE.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.POLICY_CANCEL_ASYNC_ENDORSE_PRICE.getValue(), this.maxPolicyCancelPushTimes);
                log.warn("\u5f02\u6b65\u9000\u4fdd\u8bd5\u7b97\u5931\u8d25\u91cd\u8bd5\uff0c\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.taskUtil.doPolicyCancelAsyncEndorsePriceExecute(t));
            }
            catch (Exception e) {
                log.error("pushPolicyCancelAsyncEndorsePriceTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.POLICY_CANCEL_ASYNC_ENDORSE_PRICE.getKey());
            }
        }
    }

    @Scheduled(cron="0 */5 * * * ?")
    public void pushPolicyStatusToIyunBao() {
        if (this.lock(ApisAutoTaskConstantsEnum.IYUNBAO_EMPLOYEE_NOTIFY_CALLBACK.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.IYUNBAO_EMPLOYEE_NOTIFY_CALLBACK.getValue(), this.maxPushTimes);
                log.warn("\u4fdd\u6279\u5355\u751f\u6548\u901a\u77e5i\u4e91\u4fdd\u5931\u8d25\u91cd\u8bd5\uff0c\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.taskUtil.pushPolicyStatusIyunBao(t));
            }
            catch (Exception e) {
                log.error("pushPolicyStatusToIyunBaoTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.IYUNBAO_EMPLOYEE_NOTIFY_CALLBACK.getKey());
            }
        }
    }

    @Scheduled(cron="0 */5 * * * ?")
    public void pushBudgetResultToAgentBao() {
        if (this.lock(ApisAutoTaskConstantsEnum.CORRECT_BUDGET_NOTIFY_CALLBACK.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.CORRECT_BUDGET_NOTIFY_CALLBACK.getValue(), this.maxPushTimes);
                log.warn("\u6279\u6539\u9884\u8bd5\u7b97\u7ed3\u679c\u63a8\u9001\u6e20\u9053\u5931\u8d25\u91cd\u8bd5\uff0c\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.taskUtil.pushBudgetResultToAgent(t));
            }
            catch (Exception e) {
                log.error("pushBudgetResultToAgentBao error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.CORRECT_BUDGET_NOTIFY_CALLBACK.getKey());
            }
        }
    }

    @Scheduled(cron="0 */10 * * * ?")
    public void pushCancelAutoDeductionToAgentTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.CANCEL_AUTO_DEDUCTION_TO_AGENT.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.CANCEL_AUTO_DEDUCTION_TO_AGENT.getValue(), this.maxPushTimes);
                log.warn("\u63a8\u9001\u6295\u4fdd\u672a\u7b7e\u7ea6\u6216\u89e3\u7ea6\u81ea\u52a8\u6263\u8d39\u6d88\u606f\u7ed9\u6e20\u9053\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb== {}", (Object)taskList.size());
                taskList.forEach(t -> this.insureCancelAutoDeductionPushUtil.pushCancelAutoDeductionTask(t));
            }
            catch (Exception e) {
                log.error("pushCancelAutoDeductionToAgentTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.CANCEL_AUTO_DEDUCTION_TO_AGENT.getKey());
            }
        }
    }

    @Scheduled(cron="45 */2 * * * ?")
    public void endorsePaymentAsyncReturnEndorseNo() {
        if (this.lock(ApisAutoTaskConstantsEnum.ENDORSE_PAYMENT_ASYNC_RETURN_NO.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.ENDORSE_PAYMENT_ASYNC_RETURN_NO.getValue(), this.maxPushTimes);
                log.warn("\u6279\u5355\u652f\u4ed8\u5f02\u6b65\u56de\u8c03\uff08\u8c03\u7528\u6838\u4fdd\u72b6\u6001\u67e5\u8be2\u63a5\u53e3\uff0c\u8fd4\u56de\u6279\u5355\u53f7\uff09\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb== {}", (Object)taskList.size());
                taskList.forEach(t -> this.taskUtil.doEndorsePaymentAsyncReturnEndorseNo(t, this.maxPushTimes.intValue()));
            }
            catch (Exception e) {
                log.error("endorsePaymentAsyncReturnEndorseNo error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.ENDORSE_PAYMENT_ASYNC_RETURN_NO.getKey());
            }
        }
    }

    @Scheduled(cron="0 0 2 10,24,28 * ?")
    public void createTableTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.CREATE_TABLE_TASK.getKey())) {
            try {
                String currentMonth = DateUtil.format((Date)DateUtil.nextMonth(), (String)"yyyyM");
                String createTableSql = "CREATE TABLE IF NOT EXISTS `apis_busi_access_log_###` (\n\tid bigint(20) NOT NULL, \n\tcreate_time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n\ttransaction_no varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '\u4ea4\u6613\u6d41\u6c34\u53f7',\n\tbusiness_key varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '\u552f\u4e00\u4e1a\u52a1\u53f7',\n\tchannel_code varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '\u6e20\u9053\u4ee3\u7801',\n\tuser_code varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '\u7528\u6237\u4ee3\u7801',\n\trequest_type varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '\u539f\u4e1a\u52a1\u7c7b\u578b\u4ee3\u7801',\n\tbusiness_code varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '\u7ffb\u8bd1\u540e\u7684\u4e1a\u52a1\u7c7b\u578b\u4ee3\u7801',\n\trequest_url varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '\u8bf7\u6c42\u8def\u5f84',\n\trequest_time timestamp NULL DEFAULT NULL,\n\tresponse_time timestamp NULL DEFAULT NULL,\n\tPRIMARY KEY pk_apisBusiAccessLog###_id(id) USING BTREE,\n\tkey idx_userCode(user_code) USING BTREE,\n\tkey idx_requestUrl(request_url) USING BTREE,\n\tkey idx_businessCode(business_code) USING BTREE\n)ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='\u63a5\u53e3\u8bbf\u95ee\u65e5\u5fd7\u8868'";
                createTableSql = createTableSql.replaceAll("###", currentMonth);
                this.jdbcTemplate.execute(createTableSql);
            }
            catch (Exception e) {
                log.error("createTableTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.CREATE_TABLE_TASK.getKey());
            }
        }
    }

    public void taskLogFailEmail() {
        if (this.lock(ApisAutoTaskConstantsEnum.TASK_FAIL_EMAIL_NOTIFY.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedSendFailEmail();
                List analysisList = this.apisBusiAnalysisTaskLogService.getNeedSendFailEmail();
                taskList.addAll(analysisList);
                log.warn("\u63a8\u9001\u4efb\u52a1\u8865\u507f\u540e\u4ecd\u5931\u8d25\u7684\u90ae\u4ef6\u544a\u8b66 \u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb== {}", (Object)taskList.size());
                this.taskUtil.doTaskLogFailEmail(taskList);
            }
            catch (Exception e) {
                log.error("taskLogFailEmail error: ", (Throwable)e);
            }
        }
    }

    @Scheduled(cron="10 */3 * * * ?")
    public void pushPolicyInfoToTianYuanTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.PUSH_POLICY_INFO_TO_TIAN_YUAN_AGENCY_AFTER_PAYMENT.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.PUSH_POLICY_INFO_TO_TIAN_YUAN_AGENCY_AFTER_PAYMENT.getValue(), this.maxPushTimes);
                log.warn("\u63a8\u9001\u4fdd\u5355\u4fe1\u606f\u7ed9\u5929\u6e90\u6e20\u9053\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb== {}", (Object)taskList.size());
                taskList.forEach(t -> this.taskUtil.pushPolicyInfoToTianYuanAfterPayment(t, this.maxPushTimes.intValue()));
            }
            catch (Exception e) {
                log.error("pushPolicyInfoToTianYuanTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.PUSH_POLICY_INFO_TO_TIAN_YUAN_AGENCY_AFTER_PAYMENT.getKey());
            }
        }
    }

    @Scheduled(cron="40 */3 * * * ?")
    public void pushDownloadUrlToTianYuanTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.PUSH_POLICY_DOWNLOAD_URL_TO_TIAN_YUAN_AGENCY_AFTER_PAYMENT.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.PUSH_POLICY_DOWNLOAD_URL_TO_TIAN_YUAN_AGENCY_AFTER_PAYMENT.getValue(), this.maxPushTimes);
                log.warn("\u63a8\u9001\u7535\u5b50\u4fdd\u5355\u4e0b\u8f7d\u5730\u5740\u7ed9\u5929\u6e90\u6e20\u9053\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb== {}", (Object)taskList.size());
                taskList.forEach(t -> this.taskUtil.pushDownloadUrlToTianYuanAfterPayment(t, this.maxPushTimes.intValue()));
            }
            catch (Exception e) {
                log.error("pushPolicyInfoToTianYuanTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.PUSH_POLICY_DOWNLOAD_URL_TO_TIAN_YUAN_AGENCY_AFTER_PAYMENT.getKey());
            }
        }
    }

    @Scheduled(cron="0 */2 * * * ?")
    public void pushEcoCaseStatusTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.CLAIM_CASE_STATUS_NOTIFY_YI_YAO_BAO.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.CLAIM_CASE_STATUS_NOTIFY_YI_YAO_BAO.getValue(), this.maxPushTimes);
                log.warn("\u836f\u8054\uff0c\u6848\u4ef6\u72b6\u6001\u4fe1\u606f\u63a8\u9001\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.taskUtil.pushContentToUrl(t));
            }
            catch (Exception e) {
                log.error("pushEcoCaseStatusTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.CLAIM_CASE_STATUS_NOTIFY_YI_YAO_BAO.getKey());
            }
        }
    }

    @Scheduled(cron="0 */3 * * * ?")
    public void pushGeneralCorrectToGy() {
        if (this.lock(ApisAutoTaskConstantsEnum.OFF_LINE_GENERAL_CORRECT_TO_GY.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.OFF_LINE_GENERAL_CORRECT_TO_GY.getValue(), this.maxPushTimes);
                log.warn("\u7ebf\u4e0b\u6279\u6539\u8865\u507f\u7ed9\u9ad8\u9662\u63a8\u9001\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.litigationUtils.pushGeneralCorrect(null, t));
            }
            catch (Exception e) {
                log.error("pushGeneralCorrectToGy error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.OFF_LINE_GENERAL_CORRECT_TO_GY.getKey());
            }
        }
    }
}

