/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.CoreGuaranteeApi;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.CoreGuaranteeService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.LitigationPushPayGuaranteeUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.BaseResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationChangeGuaOfflineDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationOffLinePolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationOfflineSurrenderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationOnlineGerneralRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationOnlineSurrenderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationOnlineSurrenderUWRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUpdateClerkRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUwGeneralRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUwRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.PayResultAndGuaranteeDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.CommentNotifyResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiPayLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiPayLogMapper;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CoreGuaranteeApiImpl
implements CoreGuaranteeApi {
    private static Logger log = LoggerFactory.getLogger(CoreGuaranteeApiImpl.class);
    @Autowired
    CoreGuaranteeService coreGuaranteeService;
    @Autowired
    ApisBusiPayLogMapper apisBusiPayLogMapper;
    @Autowired
    private ApisBusiChannelOrderMapper apisBusiChannelOrderMapper;
    @Autowired
    private LitigationPushPayGuaranteeUtil litigationPushPayGuaranteeUtil;
    @Value(value="${litigation.pushUwResultUrl}")
    private String pushUwResultUrl;
    @Value(value="${litigation.pushUwResultAndPayUrl}")
    private String pushUwResultAndPayUrl;
    @Value(value="${litigation.pushPayResultAndGuaranteeUrl}")
    private String pushPayResultAndGuaranteeUrl;
    @Value(value="${litigation.pushPolicyToHighCourtUrl}")
    private String pushPolicyToHighCourtUrl;
    @Value(value="${litigation.updateClerkUrl}")
    private String updateClerkUrl;
    @Value(value="${litigation.pushUwOnlineSurrender}")
    private String pushUwOnlineSurrenderUrl;
    @Value(value="${litigation.pushOnlineSurrender}")
    private String pushOnlineSurrenderUrl;
    @Value(value="${litigation.pushOfflineSurrender}")
    private String pushOfflineSurrenderUrl;
    @Value(value="${litigation.pushOfflineGeneralCorrect}")
    private String pushOfflineGeneralCorrectUrl;
    @Value(value="${litigation.pushOnlineUwGeneralCorrect}")
    private String pushOnlineUwGeneralCorrectUrl;
    @Value(value="${litigation.pushOnlineGeneralCorrect}")
    private String pushOnlineGeneralCorrectUrl;

    public BaseResponse pushUwOnlineSurrender(LitigationOnlineSurrenderUWRequest request) {
        BaseResponse response = (BaseResponse)this.coreGuaranteeService.litigationConvertAndSend(this.pushUwOnlineSurrenderUrl, "pushUwOnlineSurrender", "pushUwOnlineSurrender", (Object)request, BaseResponse.class);
        return response;
    }

    public BaseResponse pushOnlineSurrender(LitigationOnlineSurrenderRequest request) {
        BaseResponse response = (BaseResponse)this.coreGuaranteeService.litigationConvertAndSend(this.pushOnlineSurrenderUrl, "pushOnlineSurrender", "pushOnlineSurrender", (Object)request, BaseResponse.class);
        return response;
    }

    public BaseResponse pushOfflineSurrender(LitigationOfflineSurrenderRequest request) {
        BaseResponse response = (BaseResponse)this.coreGuaranteeService.litigationConvertAndSend(this.pushOfflineSurrenderUrl, "pushOfflineSurrender", "pushOfflineSurrender", (Object)request, BaseResponse.class);
        return response;
    }

    public BaseResponse pushUwResult(LitigationUwRequest uwRequest) {
        BaseResponse response = (BaseResponse)this.coreGuaranteeService.litigationConvertAndSend(this.pushUwResultUrl, "pushUwResult", "pushUwResult", (Object)uwRequest, BaseResponse.class);
        return response;
    }

    public BaseResponse pushUwResultAndPayUrl(LitigationUwRequest uwRequest) {
        BaseResponse response = (BaseResponse)this.coreGuaranteeService.litigationConvertAndSend(this.pushUwResultAndPayUrl, "pushUwResultAndPayUrl", "pushUwResultAndPayUrl", (Object)uwRequest, BaseResponse.class);
        return response;
    }

    public BaseResponse pushPayResultAndGuarantee(PayResultAndGuaranteeDTO payResultAndGuaranteeDTO) {
        BaseResponse response = (BaseResponse)this.coreGuaranteeService.litigationConvertAndSend(this.pushPayResultAndGuaranteeUrl, "pushPayResultAndGuarantee", "pushPayResultAndGuarantee", (Object)payResultAndGuaranteeDTO, BaseResponse.class);
        return response;
    }

    public BaseResponse pushPolicyToHighCourt(LitigationOffLinePolicyDTO litigationOffLinePolicyDTO) {
        BaseResponse response = (BaseResponse)this.coreGuaranteeService.litigationConvertAndSend(this.pushPolicyToHighCourtUrl, "pushPolicyToHighCourt", "pushPolicyToHighCourt", (Object)litigationOffLinePolicyDTO, BaseResponse.class);
        return response;
    }

    public BaseResponse litigationPushPayGuarantee(CommentNotifyResponseDTO request) throws ApisBusinessException {
        log.warn("\u9ad8\u9662\u4fdd\u5355\u4fdd\u51fd\u63a5\u53e3\u5f00\u59cb\uff0crequest = {}", (Object)request);
        if (StringUtils.isEmpty((CharSequence)request.getPolicyRef())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N14001.getValue(), ErrorNullValueCodeEnum.ERR_N14001.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)request.getPaymentMethod())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N14002.getValue(), ErrorNullValueCodeEnum.ERR_N14002.getKey());
        }
        QueryWrapper logWarpper = new QueryWrapper();
        logWarpper.eq((Object)"business_no", (Object)request.getPolicyRef());
        logWarpper.eq((Object)"deleted", (Object)0);
        ApisBusiPayLog apisBusiPayLog = (ApisBusiPayLog)this.apisBusiPayLogMapper.selectOne((Wrapper)logWarpper);
        if (apisBusiPayLog == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N14003.getValue(), ErrorNullValueCodeEnum.ERR_N14003.getKey());
        }
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.eq((Object)"policy_no", (Object)request.getPolicyRef());
        orderQueryWrapper.eq((Object)"deleted", (Object)0);
        ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusiChannelOrderMapper.selectOne((Wrapper)orderQueryWrapper);
        if (order == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N14004.getValue(), ErrorNullValueCodeEnum.ERR_N14004.getKey());
        }
        return this.litigationPushPayGuaranteeUtil.litigationPushPayGuaranteeAsync(new PayResultAndGuaranteeDTO(), request, apisBusiPayLog, order, this.pushPayResultAndGuaranteeUrl, "pushPayResultAndGuarantee", true);
    }

    public BaseResponse litigationUpdateClerk(LitigationUpdateClerkRequest request) throws ApisBusinessException {
        BaseResponse response = (BaseResponse)this.coreGuaranteeService.litigationConvertAndSend(this.updateClerkUrl, "updateClerk", "updateClerk", (Object)request, BaseResponse.class);
        return response;
    }

    public BaseResponse pushOfflineGeneralCorrect(LitigationChangeGuaOfflineDTO changeGuaOfflineDto) throws ApisBusinessException {
        BaseResponse response = (BaseResponse)this.coreGuaranteeService.litigationConvertAndSend(this.pushOfflineGeneralCorrectUrl, "pushOfflineGeneralCorrect", "pushOfflineGeneralCorrect", (Object)changeGuaOfflineDto, BaseResponse.class);
        return response;
    }

    public BaseResponse pushOnlineUwGeneralCorrect(LitigationUwGeneralRequest uwRequest) throws ApisBusinessException {
        BaseResponse response = (BaseResponse)this.coreGuaranteeService.litigationConvertAndSend(this.pushOnlineUwGeneralCorrectUrl, "pushOnlineUwGeneralCorrect", "pushOnlineUwGeneralCorrect", (Object)uwRequest, BaseResponse.class);
        return response;
    }

    public BaseResponse pushOnlineGeneralCorrect(LitigationOnlineGerneralRequest request) throws ApisBusinessException {
        BaseResponse response = (BaseResponse)this.coreGuaranteeService.litigationConvertAndSend(this.pushOnlineGeneralCorrectUrl, "pushOnlineGeneralCorrect", "pushOnlineGeneralCorrect", (Object)request, BaseResponse.class);
        return response;
    }
}

