/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.FxqCustomerCheckService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.WarnSendService;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.fxq.request.FxqReqDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.fxq.resp.FxqLoginResDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.fxq.resp.FxqResDTO;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.FxqCustomerScenesEnum;
import com.jdaz.sinosoftgz.apis.log.api.ApisLog;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class FxqCustomerCheckServiceImpl
implements FxqCustomerCheckService {
    private static Logger log = LoggerFactory.getLogger(FxqCustomerCheckServiceImpl.class);
    @Value(value="${fxqCustomer.loginUrl}")
    private String loginUrl;
    @Value(value="${fxqCustomer.customerurl}")
    private String fxqUrl;
    @Value(value="${fxqCustomer.userName}")
    private String userName;
    @Value(value="${fxqCustomer.passWord}")
    private String passWord;
    @Autowired
    WarnSendService warnSendService;
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_JSON = "application/json;charset=utf-8";
    public static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    static OkHttpClient client = new OkHttpClient.Builder().connectTimeout(400L, TimeUnit.SECONDS).readTimeout(400L, TimeUnit.SECONDS).build();
    @Autowired
    RedisTemplate redisTemplate;

    public FxqResDTO checkCustomerRisk(FxqReqDTO fxqReqDTO) throws ApisBusinessException {
        Date startDate = new Date();
        byte[] requestBodyBytes = new byte[]{};
        byte[] responseBodyBytes = new byte[]{};
        Boolean errorFlag = false;
        String errorMessage = null;
        String token = null;
        Object obj = this.redisTemplate.opsForValue().get((Object)FxqCustomerScenesEnum.FXQTOKEN.getCode());
        if (obj instanceof String) {
            token = (String)obj;
        }
        try {
            if (StringUtils.isBlank((CharSequence)token)) {
                this.login();
                obj = this.redisTemplate.opsForValue().get((Object)FxqCustomerScenesEnum.FXQTOKEN.getCode());
                if (obj instanceof String) {
                    token = (String)obj;
                }
            }
            String json = JSON.toJSONString((Object)fxqReqDTO);
            RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)json);
            Request request = new Request.Builder().header("Content-Type", CONTENT_TYPE_JSON).header("AUTHORIZATION", token).url(this.fxqUrl).post(body).build();
            Call call = client.newCall(request);
            try {
                Response response = call.execute();
                String responseBodyStr = response.body().string();
                FxqResDTO resp = (FxqResDTO)JSON.parseObject((String)responseBodyStr, FxqResDTO.class);
                if (resp != null && FxqCustomerScenesEnum.ERROR_CODE.getCode().equals(resp.getCode())) {
                    this.login();
                    this.checkCustomerRisk(fxqReqDTO);
                }
                FxqResDTO fxqResDTO = resp;
                return fxqResDTO;
            }
            catch (IOException e) {
                try {
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                    String uid = UUID.randomUUID().toString().replaceAll("-", "");
                    log.error("\u53cd\u6d17\u94b1\u5f02\u5e38UUID\u4e3a\uff1a{}", (Object)uid);
                    this.warnSendService.convertSaveWarnSendEmail("/COMM_RULE_001", null, "-1", "\u53cd\u6d17\u94b1\u5f02\u5e38", "\u53cd\u6d17\u94b1\u8c03\u7528\u5f02\u5e38" + uid);
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10600.getValue(), ChannelErrorCodeEnum.ERR_C10600.getKey());
                }
                catch (Exception e2) {
                    log.error("=============call api error :{}", (Object)this.fxqUrl);
                    errorFlag = true;
                    errorMessage = e2.getMessage();
                    String uid = UUID.randomUUID().toString().replaceAll("-", "");
                    log.error("\u53cd\u6d17\u94b1\u5f02\u5e38UUID\u4e3a\uff1a{}", (Object)uid);
                    this.warnSendService.convertSaveWarnSendEmail("/COMM_RULE_001", null, "-1", "\u53cd\u6d17\u94b1\u5f02\u5e38", "\u53cd\u6d17\u94b1\u8c03\u7528\u5f02\u5e38" + uid);
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10600.getValue(), ChannelErrorCodeEnum.ERR_C10600.getKey());
                }
            }
        }
        finally {
            log.warn("\u8c03\u7528\u53cd\u6d17\u94b1\u6821\u9a8c\u4f20\u2f0a\u5ba2\u6237\u662f\u5426\u5728\u5236\u88c1\u540d\u5355\u4e2d\u63a5\u53e3\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            this.sendLog(startDate, requestBodyBytes, responseBodyBytes, errorFlag, errorMessage);
        }
    }

    public void login() throws Exception {
        Date startDate = new Date();
        FormBody formBody = new FormBody.Builder().add("username", this.userName).add("password", this.passWord).build();
        try {
            Request request = new Request.Builder().header("Content-Type", CONTENT_TYPE).url(this.loginUrl).post((RequestBody)formBody).build();
            Call call = client.newCall(request);
            try {
                Response response = call.execute();
                String responseBodyStr = response.body().string();
                FxqLoginResDTO resp = (FxqLoginResDTO)JSON.parseObject((String)responseBodyStr, FxqLoginResDTO.class);
                if (resp != null && FxqCustomerScenesEnum.LOGINGSUCCESS.getCode().equals(resp.getCode())) {
                    this.redisTemplate.opsForValue().set((Object)FxqCustomerScenesEnum.FXQTOKEN.getCode(), (Object)resp.getObjectData());
                }
            }
            catch (IOException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            log.error("=============call api error :{}", (Object)this.loginUrl);
            throw e;
        }
        finally {
            log.warn("\u8c03\u7528\u53cd\u6d17\u94b1\u767b\u5f55\u63a5\u53e3\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLog(Date startDate, byte[] requestBodyBytes, byte[] responseBodyBytes, Boolean errorFlag, String errorMessage) {
        try {
            String uid = null;
            if (ApisLog.getRequest() != null) {
                uid = ApisLog.getRequest().toString();
            }
            if (uid == null) {
                uid = UUID.randomUUID().toString().replaceAll("-", "");
            }
            ApisLog.create((String)uid).setContent(new String(requestBodyBytes, "utf-8")).setBusinessNode("api:call:in").setStartTime(startDate).setLevel("info").sendAndEnd();
            ApisLog.create((String)uid).setContent(new String(responseBodyBytes, "utf-8")).setBusinessNode("api:call:out").setStartTime(new Date()).setLevel("info").sendAndEnd();
            if (errorFlag.booleanValue()) {
                ApisLog.create((String)uid).setContent(errorMessage).setBusinessNode("api:call:error").setStartTime(new Date()).setLevel("error").sendAndEnd();
            }
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u65e5\u5fd7\u65f6\u51fa\u9519:{}", (Object)e.getLocalizedMessage(), (Object)e);
        }
    }
}

