/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.LitigationCoreGuaranteeApi;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.LitigationCoreGuaranteeService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.LitigationPushPayGuaranteeUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.BaseResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUwRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.PayResultAndGuaranteeDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.CommentNotifyResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiPayLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiPayLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelUserMapper;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LitigationCoreGuaranteeApiImpl
implements LitigationCoreGuaranteeApi {
    private static Logger log = LoggerFactory.getLogger(LitigationCoreGuaranteeApiImpl.class);
    @Autowired
    LitigationCoreGuaranteeService litigationCoreGuaranteeService;
    @Autowired
    ApisBusiPayLogMapper apisBusiPayLogMapper;
    @Autowired
    private ApisBusiChannelOrderMapper apisBusiChannelOrderMapper;
    @Autowired
    private ApisChannelUserMapper apisChannelUserMapper;
    @Autowired
    private LitigationPushPayGuaranteeUtil litigationPushPayGuaranteeUtil;
    @Value(value="${liabilityInsurance.pushUwResultUrl}")
    private String pushUwResultUrl;
    @Value(value="${liabilityInsurance.pushUwResultAndPayUrl}")
    private String pushUwResultAndPayUrl;
    @Value(value="${liabilityInsurance.pushPayResultAndGuaranteeUrl}")
    private String pushPayResultAndGuaranteeUrl;

    public BaseResponse pushUwResult(LitigationUwRequest uwRequest, ApisBusiChannelOrder order) {
        String userCode = order.getCreator();
        String pwd = this.apisChannelUserMapper.queryPwdByCode(userCode);
        BaseResponse response = (BaseResponse)this.litigationCoreGuaranteeService.litigationConvertAndSend(this.pushUwResultUrl, "pushUwResult", userCode, pwd, (Object)uwRequest, BaseResponse.class);
        return response;
    }

    public BaseResponse pushUwResultAndPayUrl(LitigationUwRequest uwRequest, ApisBusiChannelOrder order) {
        String userCode = order.getCreator();
        String pwd = this.apisChannelUserMapper.queryPwdByCode(userCode);
        BaseResponse response = (BaseResponse)this.litigationCoreGuaranteeService.litigationConvertAndSend(this.pushUwResultAndPayUrl, "pushUwResultAndPayUrl", userCode, pwd, (Object)uwRequest, BaseResponse.class);
        return response;
    }

    public BaseResponse pushPayResultAndGuarantee(PayResultAndGuaranteeDTO payResultAndGuaranteeDTO, ApisBusiChannelOrder order) {
        String userCode = order.getCreator();
        String pwd = this.apisChannelUserMapper.queryPwdByCode(userCode);
        BaseResponse response = (BaseResponse)this.litigationCoreGuaranteeService.litigationConvertAndSend(this.pushPayResultAndGuaranteeUrl, "pushPayResultAndGuarantee", userCode, pwd, (Object)payResultAndGuaranteeDTO, BaseResponse.class);
        return response;
    }

    public BaseResponse litigationPushPayGuarantee(CommentNotifyResponseDTO request) throws ApisBusinessException {
        log.warn("\u901a\u7528\u8bc9\u8d23\u9669\u4fdd\u5355\u4fdd\u51fd\u63a5\u53e3\u5f00\u59cb\uff0crequest = {}", (Object)request);
        if (StringUtils.isEmpty((CharSequence)request.getPolicyRef())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N14001.getKey(), ErrorNullValueCodeEnum.ERR_N14001.getValue());
        }
        if (StringUtils.isEmpty((CharSequence)request.getPaymentMethod())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N14002.getKey(), ErrorNullValueCodeEnum.ERR_N14002.getValue());
        }
        QueryWrapper logWarpper = new QueryWrapper();
        logWarpper.eq((Object)"business_no", (Object)request.getPolicyRef());
        logWarpper.eq((Object)"deleted", (Object)0);
        ApisBusiPayLog apisBusiPayLog = (ApisBusiPayLog)this.apisBusiPayLogMapper.selectOne((Wrapper)logWarpper);
        if (apisBusiPayLog == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N14003.getKey(), ErrorNullValueCodeEnum.ERR_N14003.getValue());
        }
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.eq((Object)"policy_no", (Object)request.getPolicyRef());
        orderQueryWrapper.eq((Object)"deleted", (Object)0);
        ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusiChannelOrderMapper.selectOne((Wrapper)orderQueryWrapper);
        if (order == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N14004.getKey(), ErrorNullValueCodeEnum.ERR_N14004.getValue());
        }
        return this.litigationPushPayGuaranteeUtil.litigationPushPayGuaranteeAsync(new PayResultAndGuaranteeDTO(), request, apisBusiPayLog, order, this.pushPayResultAndGuaranteeUrl, "pushPayResultAndGuarantee", false);
    }
}

