/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.ManUnderwriteService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.request.ZhizhenReqHead;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.request.ZhizhenRequest;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.response.ZhizhenResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.DesUtils;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.ManUnderwriteUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ManUnderwriteFileInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ManUnderwriteInsured;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ManUnderwriteItemKind;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ManUnderwriteQuestionAndAnswer;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ManUnderwriteSubmitRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ManUnderwriteSupplyInsured;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ManUnderwriteSupplyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.AgentResultResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.ManUnderwriteCancelToZzRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.ManUnderwriteCancelToZzResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.ManUnderwriteResultFromZzRequest;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwAttachment;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwInsured;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwKind;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwQuestion;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwResult;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwSupport;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwAttachmentService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwInsuredService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwKindService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwQuestionService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwSupportService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.commons.utils.OtherUtils;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ZzErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ManUnderwriteServiceImpl
implements ManUnderwriteService {
    private static final Logger log = LoggerFactory.getLogger(ManUnderwriteServiceImpl.class);
    private static final String LITTLE = "<";
    @Autowired
    ApisBusiUwOrderService apisBusiUwOrderService;
    @Autowired
    ApisBusiUwInsuredService apisBusiUwInsuredService;
    @Autowired
    ApisPfpRationMainService apisPfpRationMainService;
    @Autowired
    ApisBusiUwKindService apisBusiUwKindService;
    @Autowired
    ApisBusiUwQuestionService apisBusiUwQuestionService;
    @Autowired
    ApisBusiUwAttachmentService apisBusiUwAttachmentService;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisChannelUserService apisChannelUserService;
    @Autowired
    ApisBusiUwSupportService apisBusiUwSupportService;
    @Autowired
    HttpRequestService httpRequestService;

    @Transactional(rollbackFor={Exception.class})
    public boolean saveWholeOrder(StanderRequest request) throws ApisBusinessException {
        ManUnderwriteSubmitRequest submitRequest = request.getManUnderwriteSubmitRequest();
        ApisBusiUwOrder order = new ApisBusiUwOrder();
        order.setAgencyOrderNo(submitRequest.getAgencyPolicyRef());
        order.setOrderNo(request.getHeader().getUserCode() + submitRequest.getAgencyPolicyRef());
        order.setChannelCode(submitRequest.getAgencyCode());
        order.setAgentCode(request.getHeader().getUserCode());
        order.setRequestTime(LocalDateTime.now());
        order.setStatus("1");
        order.setNotifyUrl(submitRequest.getNotifyUrl());
        order.setSupportCode(submitRequest.getSupportCode());
        order.setCreator(request.getHeader().getUserCode());
        boolean success = this.apisBusiUwOrderService.save((Object)order);
        if (success && ObjectUtils.isNotEmpty((Object)submitRequest.getInsuredList())) {
            List planCodeList = request.getManUnderwriteSubmitRequest().getInsuredList().stream().map(ManUnderwriteInsured::getPlanCode).collect(Collectors.toList());
            List rationKindList = this.apisPfpRationMainService.listMainKinds(planCodeList);
            ArrayList<ApisBusiUwInsured> insuredList = new ArrayList<ApisBusiUwInsured>();
            ArrayList kindList = new ArrayList();
            ArrayList questionList = new ArrayList();
            ArrayList attachmentList = new ArrayList();
            for (ManUnderwriteInsured insured : submitRequest.getInsuredList()) {
                String uwId = UUID.randomUUID((boolean)true).toString().replaceAll("-", "");
                ApisBusiUwInsured apisBusiUwInsured = this.convertInsured(uwId, order, insured);
                insuredList.add(apisBusiUwInsured);
                List apisBusiUwKinds = this.convertKinds(uwId, order, insured, rationKindList);
                kindList.addAll(apisBusiUwKinds);
                List apisBusiUwQuestions = this.convertQuestions(uwId, order, insured.getQuestionAndAnswerList());
                questionList.addAll(apisBusiUwQuestions);
                List apisBusiUwAttachments = this.convertAttachments(uwId, order, insured.getAttachmentList());
                attachmentList.addAll(apisBusiUwAttachments);
                ApisBusiTaskLog taskLog = new ApisBusiTaskLog();
                taskLog.setPushType(ApisAutoTaskConstantsEnum.MAN_UNDERWRITE_ATTACHMENTS_UPLOAD.getValue());
                taskLog.setBusinessKey(uwId);
                taskLog.setRemark(order.getOrderNo());
                this.apisBusiTaskLogService.saveTaskInfo(taskLog);
            }
            boolean successInsured = this.apisBusiUwInsuredService.saveBatch(insuredList);
            boolean successKind = this.apisBusiUwKindService.saveBatch(kindList);
            this.apisBusiUwQuestionService.saveBatch(questionList);
            this.apisBusiUwAttachmentService.saveBatch(attachmentList);
            boolean bl = success = successInsured && successKind;
        }
        if (!success) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
        ApisBusiTaskLog taskLog = new ApisBusiTaskLog();
        taskLog.setPushType(ApisAutoTaskConstantsEnum.MAN_UNDERWRITE_PUSH_ZZ.getValue());
        taskLog.setBusinessKey(order.getOrderNo());
        this.apisBusiTaskLogService.saveTaskInfo(taskLog);
        return success;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveSupply(StanderRequest request) {
        ManUnderwriteSupplyRequest supplyRequest = request.getManUnderwriteSupplyRequest();
        String orderNo = request.getHeader().getUserCode() + supplyRequest.getAgencyPolicyRef();
        boolean success = true;
        if (ObjectUtils.isNotEmpty((Object)supplyRequest.getInsuredList())) {
            ArrayList<ApisBusiUwInsured> insuredList = new ArrayList<ApisBusiUwInsured>();
            ArrayList attachmentList = new ArrayList();
            for (ManUnderwriteSupplyInsured supplyInsured : supplyRequest.getInsuredList()) {
                ApisBusiUwInsured insured = new ApisBusiUwInsured();
                insured.setAddInfo(supplyInsured.getAddInfo());
                insured.setUwId(supplyInsured.getInsuredUwId());
                insured.setStatus("6");
                insuredList.add(insured);
                List attachments = this.convertAttachments(supplyInsured.getInsuredUwId(), request.getHeader().getUserCode(), supplyInsured.getAttachmentList(), "3");
                attachmentList.addAll(attachments);
                if (!ObjectUtils.isNotEmpty(attachmentList)) continue;
                ApisBusiTaskLog taskLog = new ApisBusiTaskLog();
                taskLog.setPushType(ApisAutoTaskConstantsEnum.MAN_UNDERWRITE_ATTACHMENTS_UPLOAD.getValue());
                taskLog.setBusinessKey(supplyInsured.getInsuredUwId());
                taskLog.setRemark(orderNo);
                this.apisBusiTaskLogService.saveTaskInfo(taskLog);
            }
            boolean successInsured = this.apisBusiUwInsuredService.updateBatchAddInfoAndStatus(insuredList);
            boolean successAttachment = this.apisBusiUwAttachmentService.saveBatch(attachmentList);
            boolean bl = success = successInsured && successAttachment;
        }
        if (success) {
            this.apisBusiUwOrderService.updateStatus(orderNo, "6");
            ApisBusiTaskLog taskLog = new ApisBusiTaskLog();
            taskLog.setPushType(ApisAutoTaskConstantsEnum.MAN_UNDERWRITE_SUPPLY_PUSH_ZZ.getValue());
            taskLog.setBusinessKey(orderNo);
            this.apisBusiTaskLogService.saveTaskInfo(taskLog);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="manUnderwriteExecutor")
    public void convertAndPushAgent(StanderRequest request, List<ApisBusiUwResult> results) {
        String orderNo = ((ManUnderwriteResultFromZzRequest)request.getZzResultRequest().getBody()).getReqOrderNo();
        ApisBusiUwOrder order = this.apisBusiUwOrderService.getByOrderNo(orderNo);
        String xmlContent = this.convert(request, results, order);
        ApisBusiTaskLog taskLog = new ApisBusiTaskLog();
        taskLog.setPushType(ApisAutoTaskConstantsEnum.MAN_UNDERWRITE_RESULT_PUSH_AGENT.getValue());
        taskLog.setBusinessKey(orderNo);
        taskLog.setPushContent(xmlContent);
        try {
            log.warn("\u6e20\u9053\u7ed3\u679c\u901a\u77e5\u8bf7\u6c42\u62a5\u6587: {}", (Object)xmlContent);
            if (StringUtils.isNotBlank((CharSequence)order.getNotifyUrl())) {
                taskLog.setPushTargetUrl(order.getNotifyUrl());
                taskLog.setPushStep(Integer.valueOf(1));
                taskLog.setLastPushTime(LocalDateTime.now());
                String responseXml = OkHttpUtils.postXml((String)order.getNotifyUrl(), (String)xmlContent);
                log.warn("\u6e20\u9053\u7ed3\u679c\u901a\u77e5\u54cd\u5e94\u7ed3\u679c: {}", (Object)responseXml);
                if (ObjectUtils.isEmpty((Object)responseXml)) {
                    taskLog.setPushStatus("4");
                    taskLog.setErrMsg("\u4eba\u5de5\u6838\u4fdd\u7ed3\u679c\u63a8\u9001\u6e20\u9053\u672a\u8fd4\u56de\u5185\u5bb9");
                } else if (!responseXml.startsWith(LITTLE)) {
                    taskLog.setPushStatus("4");
                    taskLog.setErrMsg("\u4eba\u5de5\u6838\u4fdd\u7ed3\u679c\u63a8\u9001\u6e20\u9053\u8fd4\u56de\u683c\u5f0f\u9519\u8bef:" + responseXml);
                } else {
                    Map resultMap = XmlUtil.xmlToMap((String)responseXml);
                    String mapString = JSON.toJSONString((Object)resultMap);
                    AgentResultResponse response = (AgentResultResponse)JSON.parseObject((String)mapString, AgentResultResponse.class);
                    if (ChannelErrorCodeEnum.ERR_C10002.getKey().equals(response.getHead().getErrorCode())) {
                        taskLog.setPushStatus("1");
                    } else {
                        taskLog.setPushStatus("4");
                        log.error("\u4eba\u5de5\u6838\u4fdd\u7ed3\u679c\u63a8\u9001\u6e20\u9053,\u8fd4\u56de\u5185\u5bb9:{}", (Object)responseXml);
                    }
                    taskLog.setErrMsg(responseXml);
                }
            } else {
                taskLog.setErrMsg("\u672a\u80fd\u83b7\u53d6\u63a8\u9001Url");
            }
        }
        catch (Exception e) {
            log.error("\u4eba\u5de5\u6838\u4fdd\u6e20\u9053\u7ed3\u679c\u63a8\u9001\u5931\u8d25 error:", (Throwable)e);
            taskLog.setPushStatus("4");
            if (StringUtils.isNotBlank((CharSequence)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT) {
                taskLog.setErrMsg(e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT));
            } else {
                taskLog.setErrMsg(e.getMessage());
            }
        }
        finally {
            this.apisBusiTaskLogService.saveTaskInfo(taskLog);
        }
    }

    public boolean cancelPush(String orderNo) {
        ApisBusiUwSupport support = this.apisBusiUwSupportService.getSupportByOrderNo(orderNo);
        if (ObjectUtils.isEmpty((Object)support)) {
            log.error("\u8ba2\u5355\u53f7:{},\u65e0\u6cd5\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f", (Object)orderNo);
            return false;
        }
        String msg = ManUnderwriteUtil.checkSupport((ApisBusiUwSupport)support, (String)support.getSupportCode(), (String)"uw_cannel_url");
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            log.error(msg);
            return false;
        }
        support.setCurrentUrl(support.getUwCannelUrl());
        ManUnderwriteCancelToZzRequest zzRequest = ManUnderwriteCancelToZzRequest.builder().reqOrderNo(orderNo).build();
        ZhizhenResponse response = this.convertAndSendZz(support, (Object)zzRequest, "1003", ManUnderwriteCancelToZzResponse.class);
        if (ObjectUtils.isEmpty((Object)response) || ObjectUtils.isEmpty((Object)response.getState())) {
            log.error("\u4eba\u5de5\u6838\u4fdd\u64a4\u9500\u8ba2\u5355\u63a8\u9001\u4f9b\u5e94\u5546\u672a\u8fd4\u56de\u5185\u5bb9");
            return false;
        }
        log.warn("\u4eba\u5de5\u6838\u4fdd\u64a4\u9500\u8ba2\u5355\u63a8\u9001\u4f9b\u5e94\u5546,\u8fd4\u56de\u5185\u5bb9:{}", (Object)JSON.toJSONString((Object)response));
        return ZzErrorCodeEnum.STAT_SUCCESS.getKey().equals(response.getState()) && "1".equals(((ManUnderwriteCancelToZzResponse)response.getResult()).getState());
    }

    public <T> ZhizhenResponse<T> convertAndSendZz(ApisBusiUwSupport support, Object requestData, String businessType, Class<T> clazz) {
        ZhizhenReqHead head = new ZhizhenReqHead();
        head.setAccount(support.getAccount());
        head.setReqTime(LocalDateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss"));
        head.setKey(SecureUtil.md5((String)(support.getAccount() + support.getPassword() + head.getReqTime())));
        head.setBusinessType(businessType);
        head.setVersion("v1");
        String sourceBody = JSON.toJSONString((Object)requestData);
        log.warn("\u8bf7\u6c42\u5934\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)head));
        log.warn("\u52a0\u5bc6\u524d\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)sourceBody);
        DesUtils utils = new DesUtils(support.getSecret());
        String encodeBody = utils.encrypt(sourceBody);
        ZhizhenRequest request = new ZhizhenRequest();
        request.setHead(head);
        request.setBody((Object)encodeBody);
        ZhizhenResponse response = (ZhizhenResponse)this.httpRequestService.convertAndSendForAgent(support.getCurrentUrl(), (Object)request, ZhizhenResponse.class, businessType);
        if (ObjectUtil.isNotEmpty((Object)response.getResult())) {
            Object uploadRiskResData = JSON.parseObject((String)response.getResult().toString(), clazz);
            response.setResult(uploadRiskResData);
        }
        return response;
    }

    private String convert(StanderRequest request, List<ApisBusiUwResult> results, ApisBusiUwOrder order) {
        String requestId = UUID.randomUUID((boolean)true).toString().replaceAll("-", "");
        String userCode = request.getHeader().getUserCode();
        ApisChannelUser user = this.apisChannelUserService.getUserByUserCode(userCode);
        String password = user.getPwd();
        String agencyPolicyRef = order.getAgencyOrderNo();
        String insureStr = results.stream().filter(result -> "1".equals(result.getMain())).map(r -> {
            String uwResultList = results.stream().filter(item -> r.getUwId().equals(item.getUwId())).map(uwResult -> "                   <UwRsCode>" + uwResult.getUwRsCode() + "</UwRsCode>\n").collect(Collectors.joining());
            return "            <Insured>\n                <InsuredName>" + r.getName() + "</InsuredName>\n                <IdType>" + r.getIdType() + "</IdType>\n                <IdNumber>" + r.getIdNo() + "</IdNumber>\n                <InsuredUwId>" + r.getUwId() + "</InsuredUwId>\n                <PsRs>" + OtherUtils.nullToEmptyStr((String)r.getPsRs()) + "</PsRs>\n                <UwRsReason>" + OtherUtils.nullToEmptyStr((String)r.getUwRsReason()) + "</UwRsReason>\n                <ExceptReason>" + OtherUtils.nullToEmptyStr((String)r.getExceptReason()) + "</ExceptReason>\n                <LimitReason>" + OtherUtils.nullToEmptyStr((String)r.getLimitReason()) + "</LimitReason>\n                <AddFeeRate>" + r.getAddFeeRate() + "</AddFeeRate>\n                <UwExpireTime>" + LocalDateTimeUtil.format((LocalDateTime)r.getUwExpireTime(), (String)"yyyyMMddHHmmss") + "</UwExpireTime>\n                <UwResultList>\n" + uwResultList + "                </UwResultList>\n            </Insured>\n";
        }).collect(Collectors.joining());
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Packet type=\"REQUEST\" version=\"1.0\">\n    <Head>\n        <RequestID>" + requestId + "</RequestID>\n        <RequestType>UW4MRS</RequestType>\n        <User>" + userCode + "</User>\n        <Password>" + password + "</Password>\n    </Head>\n    <Body>\n        <Policy>\n            <AgencyPolicyRef>" + agencyPolicyRef + "</AgencyPolicyRef>\n        </Policy>\n        <InsuredList>\n" + insureStr + "        </InsuredList>\n    </Body>\n</Packet>";
    }

    private List<ApisBusiUwAttachment> convertAttachments(String uwId, ApisBusiUwOrder order, List<ManUnderwriteFileInfo> fileInfoList) {
        return this.convertAttachments(uwId, order.getCreator(), fileInfoList, "1");
    }

    private List<ApisBusiUwAttachment> convertAttachments(String uwId, String creator, List<ManUnderwriteFileInfo> fileInfoList, String status) {
        ArrayList<ApisBusiUwAttachment> attachmentList = new ArrayList<ApisBusiUwAttachment>();
        if (ObjectUtils.isNotEmpty(fileInfoList)) {
            for (ManUnderwriteFileInfo fileInfo : fileInfoList) {
                ApisBusiUwAttachment attachment = new ApisBusiUwAttachment();
                attachment.setUwId(uwId);
                attachment.setAttaType(fileInfo.getFileType());
                attachment.setAttaName(fileInfo.getFileName());
                attachment.setAttaPath(fileInfo.getFileUrl());
                attachment.setCreator(creator);
                attachment.setStatus(status);
                attachmentList.add(attachment);
            }
        }
        return attachmentList;
    }

    private List<ApisBusiUwQuestion> convertQuestions(String uwId, ApisBusiUwOrder order, List<ManUnderwriteQuestionAndAnswer> questionAndAnswerList) {
        ArrayList<ApisBusiUwQuestion> questionList = new ArrayList<ApisBusiUwQuestion>();
        if (ObjectUtils.isNotEmpty(questionAndAnswerList)) {
            for (ManUnderwriteQuestionAndAnswer questionAndAnswer : questionAndAnswerList) {
                ApisBusiUwQuestion question = new ApisBusiUwQuestion();
                question.setUwId(uwId);
                question.setQuestion(questionAndAnswer.getQuestionContent());
                question.setAnswer(questionAndAnswer.getAnswer());
                question.setCreator(order.getCreator());
                questionList.add(question);
            }
        }
        return questionList;
    }

    private List<ApisBusiUwKind> convertKinds(String uwId, ApisBusiUwOrder order, ManUnderwriteInsured insured, List<ApisPfpRationKindDTO> rationKindList) {
        List itemKindList = insured.getItemKindList();
        ArrayList<ApisBusiUwKind> kindList = new ArrayList<ApisBusiUwKind>();
        if (ObjectUtils.isNotEmpty((Object)itemKindList)) {
            for (ManUnderwriteItemKind itemKind : itemKindList) {
                ApisBusiUwKind kind = new ApisBusiUwKind();
                kind.setUwId(uwId);
                kind.setRationCode(insured.getPlanCode());
                kind.setClauseCode(itemKind.getClauseCode());
                kind.setKindCode(itemKind.getKindCode());
                String kindName = rationKindList.stream().filter(rationKind -> rationKind.getKindCode().equals(itemKind.getKindCode())).map(ApisPfpRationKindDTO::getKindName).findFirst().orElse(null);
                kind.setKindName(kindName);
                kind.setAmount(itemKind.getSumInsured());
                kind.setCreator(order.getCreator());
                kindList.add(kind);
            }
        }
        return kindList;
    }

    private ApisBusiUwInsured convertInsured(String uwId, ApisBusiUwOrder order, ManUnderwriteInsured insured) {
        ApisPfpRationMain planMain = this.apisPfpRationMainService.getPlanMain(insured.getPlanCode());
        ApisBusiUwInsured apisBusiUwInsured = new ApisBusiUwInsured();
        apisBusiUwInsured.setOrderNo(order.getOrderNo());
        apisBusiUwInsured.setUwId(uwId);
        apisBusiUwInsured.setName(insured.getInsuredName());
        apisBusiUwInsured.setIdType(insured.getIdType());
        apisBusiUwInsured.setIdNo(insured.getIdNumber());
        apisBusiUwInsured.setHeight(insured.getHeight());
        apisBusiUwInsured.setWeight(insured.getWeight());
        apisBusiUwInsured.setIncludeExpHosp(insured.getIncludeExpHosp());
        apisBusiUwInsured.setDeductibleHosp(insured.getDeductibleHosp());
        apisBusiUwInsured.setOccupationCode(insured.getOccupationCode());
        apisBusiUwInsured.setOccupationName(insured.getOccupationName());
        apisBusiUwInsured.setPremium(insured.getPremium());
        apisBusiUwInsured.setAmount(insured.getSumInsured());
        apisBusiUwInsured.setRationCode(insured.getPlanCode());
        apisBusiUwInsured.setRationName(planMain.getRationName());
        apisBusiUwInsured.setStatus(order.getStatus());
        apisBusiUwInsured.setAddInfo(insured.getAddInfo());
        apisBusiUwInsured.setCreator(order.getCreator());
        return apisBusiUwInsured;
    }
}

