/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.PaymentService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.PaymentGatewaySHAUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.PaymentGatewayUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ApplyInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorseQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorseQueryServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentGatewayChannelDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentGatewayRequestBodyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentGatewayRequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentGatewayServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.UnderWriteQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.UnderWriteQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationPaymentUrlRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.ApisChannelUserDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.InsuredInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.NoticeDetailDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PaymentNotifyMessageDetailDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PaymentNotifyMessageRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PaymentNotifyToAgentDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PaymentNotifyToAgentPolicyInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PolicyInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.SignContractNotifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.SignContractNotifyToAgentDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.MainEndorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PaymentGatewayResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.UnderWriteQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelInstallmentOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiCorrectOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiPayContract;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiPayLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelInstallmentOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiCorrectOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiPayLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiPayContractService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.validation.ValidationRequestParamsResult;
import com.jdaz.sinosoftgz.apis.commons.utils.OtherUtils;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import com.jdaz.sinosoftgz.coreapi.payment.PaymentGatewayApi;
import com.sinosoft.epay.sdk.EpaySign;
import groovy.json.StringEscapeUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PaymentServiceImpl
implements PaymentService {
    private static Logger log = LoggerFactory.getLogger(PaymentServiceImpl.class);
    private static Integer PAYMENT_DELAY_TIME_SETTING = 12;
    @Autowired
    PaymentGatewayApi paymentGatewayApi;
    @Autowired
    ApisBusiChannelOrderMapper apisBusinessChannelOrderMapper;
    @Autowired
    ApisBusiChannelInstallmentOrderMapper apisBusiChannelInstallmentOrderMapper;
    @Autowired
    ApisBusiPayLogMapper apisPayLogMapper;
    @Autowired
    ApisBusiCorrectOrderMapper apisBusiCorrectOrderMapper;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Value(value="${payment.callBack.returnUrl}")
    private String returnCallBack;
    @Value(value="${payment.callBack.notifyUrl}")
    private String notifyCallBack;
    @Value(value="${payment.signConstant}")
    private String signConstant;
    @Value(value="${payment.privateKey}")
    private String privateKey;
    @Value(value="${payment.epayPublicKey}")
    private String epayPublicKey;
    @Value(value="${payment.executeUrl}")
    private String paymentExecuteUrl;
    @Value(value="${payment.callBack.signContractNotifyUrl}")
    private String signContractNotifyUrl;
    @Autowired
    private HttpRequestService httpRequestService;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Value(value="${spring.datasource.password}")
    private String dataSourcePassword;
    @Value(value="${payment.successPaySignConstant}")
    private String successPaySignConstant;
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    private CoreInsureApi coreInsureApi;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    private ApisBusiPayContractService apisBusiPayContractService;
    private static String PAYMENT_VALIDATE_SIGN_FLAG = "payment_validate_sign_flag";
    private static String PAYMENT_RED_CENT_FLAG = "payment_red_cent_flag";
    private static String WX_APP_FLAG = "WXA01";
    private static String RETURN_PARAM_ENDORSEMENT_NO = "endorsementNo";
    @Value(value="${tianYuan.pushPolicyInfo.url}")
    private String tianYuanPolicyInfoPushUrl;
    @Value(value="${tianYuan.pushDownloadUrl.url}")
    private String tianYuanDownloadUrlPushUrl;
    private String formPolicyRefName = "policyList[%d].policyRef";
    private String formPreimumName = "policyList[%d].premium";
    private static final String[] RENEWAL_PAY_METHODS = new String[]{"A01", "W03", "W04", "W05", "JD01"};
    @Value(value="${payment.corePayApplyOpenUrl}")
    private String corePayApplyOpenUrl;
    @Value(value="${litigation.litigationPaymentReturnBackUrl}")
    private String litigationPaymentReturnBackUrl;
    @Value(value="${litigation.litigationPaymentNotifyBackUrl}")
    private String litigationPaymentNotifyBackUrl;
    public static Map<String, String> mobilePaymentCodeMap = new HashMap();
    public static Map<String, String> pcPaymentCodeMap = new HashMap();
    public static Map<String, Boolean> isMobileMap = new HashMap();
    public static Map<String, String> peyMethodMap = new HashMap();
    public static HashMap<String, String> identifytypeMap;

    public void paymentGateway(PaymentGatewayChannelDTO channelDTO, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            boolean envFlag;
            ValidationRequestParamsResult validResult = this.validateRequestParams(channelDTO);
            String payRealPremium = request.getParameter("prp");
            Boolean validFlag = validResult.getFlag();
            if (!validFlag.booleanValue()) {
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/json;charset=UTF-8");
                PrintWriter out = response.getWriter();
                out.print(JSON.toJSONString((Object)validResult));
                out.flush();
                return;
            }
            boolean bl = envFlag = "Fchx201911".equals(this.dataSourcePassword) || "Fchx202001".equals(this.dataSourcePassword);
            if (this.getValidateSignFlag(channelDTO).booleanValue()) {
                this.validateSign(channelDTO);
            }
            this.validateInstallment(channelDTO);
            boolean isBatchPayment = "BatchPayment".equals(channelDTO.getPolicyRef());
            String[] policyRefArr = null;
            if (isBatchPayment) {
                boolean repeatPaymentFlag = this.repeatBatchPayment(channelDTO, response);
                if (repeatPaymentFlag) {
                    return;
                }
                List<String> policyRefList = channelDTO.getPolicyList().stream().map(pol -> pol.getPolicyRef()).collect(Collectors.toList());
                policyRefArr = policyRefList.toArray(new String[policyRefList.size()]);
            } else {
                Boolean repeatPaymentFlag = this.repeatPayment(channelDTO, response);
                if (repeatPaymentFlag.booleanValue()) {
                    return;
                }
                policyRefArr = new String[]{channelDTO.getPolicyRef()};
            }
            boolean isEndorsePay = "Y".equals(channelDTO.getEndorsePayFlag());
            if (isEndorsePay) {
                this.validateEndorseNos(policyRefArr);
            }
            log.warn("\u73af\u5883\u5224\u65ad\u4f9d\u636e\uff1a{}", (Object)this.dataSourcePassword);
            if (envFlag && ObjectUtil.isEmpty((Object)payRealPremium) && this.getRedCentOpen().booleanValue()) {
                channelDTO.setTotalPremium(BigDecimal.valueOf(0.01).multiply(BigDecimal.valueOf(policyRefArr.length)));
            }
            String ua = request.getHeader("User-Agent");
            log.warn("\u652f\u4ed8\u7f51\u5173\u8bf7\u6c42\u7684User-Agent\uff1a{}", (Object)ua);
            boolean isMobile = PaymentServiceImpl.isMobile((PaymentGatewayChannelDTO)channelDTO);
            log.warn("\u652f\u4ed8\u7f51\u5173\u8bf7\u6c42\u7684\u5ba2\u6237\u7aef\u662f\u5426\u662fpc\u7aef\uff1a{}", (Object)isMobile);
            channelDTO.setIsMobile(Boolean.valueOf(isMobile));
            if ("definePC".equals(channelDTO.getPaymentMethod())) {
                channelDTO.setPaymentMethod("");
            }
            log.warn("\u8bf7\u6c42\u53c2\u6570\u6e20\u9053\u652f\u4ed8\u65b9\u5f0f\uff1a{}", (Object)channelDTO.getPaymentMethod());
            log.warn("\u652f\u4ed8\u91d1\u989d\uff1a{}", (Object)channelDTO.getTotalPremium());
            log.warn("\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)channelDTO));
            PaymentGatewayServiceRequest req = this.convertParams(channelDTO, payRealPremium);
            StanderRequest sr = StanderRequest.builder().paymentGateWayServiceRequest(req).build();
            PaymentGatewayResponse resp = null;
            try {
                resp = this.paymentGatewayApi.paymentNoApply(sr);
                log.warn("\u8c03\u7528\u6838\u5fc3\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)resp));
            }
            catch (Exception e) {
                log.error("\u652f\u4ed8\u7f51\u5173\uff0c\u8c03\u7528\u6838\u5fc3\u652f\u4ed8\u7533\u8bf7\u63a5\u53e3\u62a5\u9519\uff0c\u4e1a\u52a1\u53f7{}", (Object)channelDTO.getPolicyRef());
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40002.getValue(), ErrorBisCodeEnum.ERR_B40002.getKey());
            }
            if (resp != null && 0L != resp.getHead().getCode()) {
                log.error("\u652f\u4ed8\u7f51\u5173\uff0c\u8c03\u7528\u6838\u5fc3\u652f\u4ed8\u7533\u8bf7\u63a5\u53e3\u62a5\u9519\uff0c\u4e1a\u52a1\u53f7{},\u9519\u8bef\u4fe1\u606f:{}", (Object)channelDTO.getPolicyRef(), (Object)resp.getHead().getMessage());
                String message = ErrorBisCodeEnum.ERR_B40002.getValue();
                if (StrUtil.isNotEmpty((CharSequence)resp.getHead().getMessage())) {
                    message = resp.getHead().getMessage();
                }
                throw new ApisBusinessException(message, ErrorBisCodeEnum.ERR_B40002.getKey());
            }
            String payApplyNo = resp.getBody().getPayApplyNo();
            String url = resp.getBody().getUrl();
            String mobileUrl = resp.getBody().getMobilePayUrl();
            String checkNo = resp.getBody().getCheckNo();
            if (isBatchPayment) {
                this.batchInsertPayLog(payApplyNo, channelDTO, isMobile, checkNo, isEndorsePay);
            } else {
                this.insertPayLog(payApplyNo, channelDTO, isMobile, checkNo, isEndorsePay);
                if ("1".equals(channelDTO.getRenewalPayFlag())) {
                    this.insertPayContractRecord(channelDTO, payApplyNo);
                }
            }
            try {
                this.redirect(checkNo, payApplyNo, mobileUrl, url, isMobile, response);
            }
            catch (Exception e) {
                log.error("\u652f\u4ed8\u7f51\u5173\uff0c\u9875\u9762\u8df3\u8f6c\u5f02\u5e38\uff0c\u4e1a\u52a1\u53f7{}", (Object)channelDTO.getPolicyRef());
                log.error(e.getMessage());
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40003.getValue(), ErrorBisCodeEnum.ERR_B40003.getKey());
            }
        }
        catch (ApisBusinessException e) {
            log.error("error: ", (Throwable)e);
            ValidationRequestParamsResult result = new ValidationRequestParamsResult(e.getMessage(), e.getErrorCode());
            this.failReturnCallBack(channelDTO, result, response);
        }
        catch (Exception e) {
            log.error("error: ", (Throwable)e);
            ValidationRequestParamsResult result = new ValidationRequestParamsResult(ErrorBisCodeEnum.ERR_B10001.getValue(), ErrorBisCodeEnum.ERR_B10001.getKey());
            this.failReturnCallBack(channelDTO, result, response);
        }
    }

    private void insertPayContractRecord(PaymentGatewayChannelDTO channelDTO, String payApplyNo) {
        ApisBusiPayContract apisBusiPayContract = new ApisBusiPayContract();
        apisBusiPayContract.setAgencyCode(channelDTO.getAgencyCode());
        apisBusiPayContract.setBusinessNo(channelDTO.getPolicyRef());
        apisBusiPayContract.setPaymentMethod(channelDTO.getPaymentMethod());
        apisBusiPayContract.setIsMobile(channelDTO.getIsMobile() != false ? "1" : "0");
        apisBusiPayContract.setBusinessType("NC");
        apisBusiPayContract.setContractCode(payApplyNo);
        apisBusiPayContract.setContractNotifyUrl(channelDTO.getContractNotifyUrl());
        apisBusiPayContract.setContractReturnUrl(channelDTO.getReturnUrl());
        this.apisBusiPayContractService.save((Object)apisBusiPayContract);
    }

    private ApisBusiPayLog insertPayLog(String payApplyNo, PaymentGatewayChannelDTO channelDTO, boolean isMobile, String checkNo, boolean isNotUpdateOrder) {
        String policyNo = channelDTO.getPolicyRef();
        if (!isNotUpdateOrder) {
            QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
            apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)policyNo);
            ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusinessChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
            order.setPayNo(payApplyNo);
            this.apisBusinessChannelOrderMapper.updatePayNoById(order);
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"pay_no", (Object)payApplyNo);
        this.apisPayLogMapper.delete((Wrapper)updateWrapper);
        ApisBusiPayLog history = new ApisBusiPayLog();
        history.setAgencyCode(channelDTO.getAgencyCode());
        history.setBusinessNo(policyNo);
        history.setPaymentMethod(channelDTO.getPaymentMethod());
        history.setTotalPremium(channelDTO.getTotalPremium());
        history.setNotifyUrl(channelDTO.getNotifyUrl());
        history.setReturnUrl(channelDTO.getReturnUrl());
        history.setSign(channelDTO.getSign());
        history.setIsMobile(String.valueOf(isMobile));
        history.setOrderNo(channelDTO.getOrderNo());
        history.setPayNo(payApplyNo);
        history.setCheckNo(checkNo);
        if (ObjectUtil.isNotEmpty((Object)channelDTO.getNotifyUrl())) {
            history.setNotifyDomain(OtherUtils.getDomainFromUrl((String)channelDTO.getNotifyUrl()));
        }
        this.apisPayLogMapper.insert((Object)history);
        return history;
    }

    public void batchInsertPayLog(String payApplyNo, PaymentGatewayChannelDTO channelDTO, boolean isMobile, String checkNo, boolean isEndorse) {
        ApisBusiPayLog mainPayLog = this.insertPayLog(payApplyNo, channelDTO, isMobile, checkNo, true);
        for (PolicyInfoDTO policyInfoDTO : channelDTO.getPolicyList()) {
            String policyNo = policyInfoDTO.getPolicyRef();
            if (!isEndorse) {
                QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
                apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)policyNo);
                ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusinessChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
                order.setPayNo(payApplyNo);
                this.apisBusinessChannelOrderMapper.updatePayNoById(order);
            }
            ApisBusiPayLog history = new ApisBusiPayLog();
            history.setAgencyCode(channelDTO.getAgencyCode());
            history.setBusinessNo(policyNo);
            history.setPaymentMethod(channelDTO.getPaymentMethod());
            history.setTotalPremium(policyInfoDTO.getPremium());
            history.setNotifyUrl(channelDTO.getNotifyUrl());
            history.setReturnUrl(channelDTO.getReturnUrl());
            history.setSign(channelDTO.getSign());
            history.setIsMobile(String.valueOf(isMobile));
            history.setOrderNo(channelDTO.getOrderNo());
            history.setPayNo(payApplyNo);
            history.setCheckNo(checkNo);
            history.setPayLogId(mainPayLog.getId());
            if (ObjectUtil.isNotEmpty((Object)channelDTO.getNotifyUrl())) {
                history.setNotifyDomain(OtherUtils.getDomainFromUrl((String)channelDTO.getNotifyUrl()));
            }
            this.apisPayLogMapper.insert((Object)history);
        }
    }

    private PaymentGatewayServiceRequest convertParams(PaymentGatewayChannelDTO channelDTO, String payRealPremium) throws ApisBusinessException {
        PaymentGatewayServiceRequest req = PaymentGatewayServiceRequest.builder().build();
        PaymentGatewayRequestHeadDTO head = PaymentGatewayRequestHeadDTO.builder().build();
        head.setMsgtype("payNoApply");
        head.setVersion("1.0");
        head.setSystemCode("03");
        head.setTimestamp(String.valueOf(DateUtil.current()));
        head.setSign(channelDTO.getSign());
        PaymentGatewayRequestBodyDTO body = PaymentGatewayRequestBodyDTO.builder().build();
        String paymentMethod = channelDTO.getPaymentMethod();
        log.warn("convertParams\u4e2d\u6e20\u9053\u652f\u4ed8\u65b9\u5f0f\uff1a{}", (Object)paymentMethod);
        String paymentCode = PaymentServiceImpl.getPaymentCode((PaymentGatewayChannelDTO)channelDTO);
        if ("1".equals(channelDTO.getRenewalPayFlag()) && !channelDTO.getIsMobile().booleanValue() && !Arrays.asList(RENEWAL_PAY_METHODS).contains(paymentCode)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10702.getValue().replace("##", paymentCode), ChannelErrorCodeEnum.ERR_C10702.getKey());
        }
        body.setEntrustPayFlag(channelDTO.getEntrustPayFlag());
        body.setPayMethod(paymentCode);
        if ("JD01".equals(paymentCode)) {
            body.setPayeType("1");
        }
        if ("JD02".equals(paymentCode)) {
            body.setPayeType("2");
        }
        body.setOperateType("0");
        body.setAppletFlag(channelDTO.getAppletFlag());
        body.setSumFee(channelDTO.getTotalPremium().toString());
        body.setPcUrl(this.returnCallBack);
        body.setMoveUrl(this.returnCallBack);
        body.setThirdFlag("01");
        body.setThirdCallUrl(this.notifyCallBack);
        body.setRenewalPayFlag(StringUtils.isNotEmpty((CharSequence)channelDTO.getRenewalPayFlag()) ? channelDTO.getRenewalPayFlag() : "0");
        body.setThirdContractCallUrl(this.signContractNotifyUrl);
        String policyRef = channelDTO.getPolicyRef();
        boolean isBatchPayment = "BatchPayment".equals(policyRef);
        String[] policyRefArr = null;
        if (isBatchPayment) {
            List<String> policyRefList = channelDTO.getPolicyList().stream().map(pol -> pol.getPolicyRef()).collect(Collectors.toList());
            policyRefArr = policyRefList.toArray(new String[policyRefList.size()]);
        } else {
            policyRefArr = new String[]{policyRef};
        }
        ApplyInfoDTO applyInfoDTO = null;
        ArrayList<ApplyInfoDTO> list = new ArrayList<ApplyInfoDTO>();
        boolean envFlag = this.dataSourcePassword.equals("Fchx201911") || this.dataSourcePassword.equals("Fchx202001");
        int i = 1;
        int ind = 0;
        boolean isEndorsePay = "Y".equals(channelDTO.getEndorsePayFlag());
        for (String policyRefStr : policyRefArr) {
            String productCode = null;
            String planName = null;
            String giftType = null;
            Integer payNumber = null;
            LocalDateTime oStartDate = null;
            LocalDateTime oEndDate = null;
            String creator = null;
            String endorseComCode = null;
            String proposalNo = null;
            BigDecimal premium = null;
            String goodsCode = null;
            String goodsName = null;
            if (isEndorsePay) {
                StanderResponse endorseQueryResponse = this.endorseProcess(policyRefStr);
                MainEndorResponseDTO endorseMain = endorseQueryResponse.getEndorseQueryResponse().getResponseBody().getMain();
                QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
                String curPolicyNo = endorseMain.getPolicyNo();
                apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)curPolicyNo);
                ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusinessChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
                if (BeanUtil.isEmpty((Object)order, (String[])new String[0])) {
                    log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38,\u4e1a\u52a1\u53f7\uff1a{}", (Object)curPolicyNo);
                    throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40004.getValue(), ErrorBisCodeEnum.ERR_B40004.getKey());
                }
                productCode = endorseMain.getRiskCode();
                planName = order.getPlanName();
                giftType = order.getGiftType();
                payNumber = order.getPayNumbers();
                if (ObjectUtil.isNotEmpty((Object)endorseMain.getStartDate())) {
                    oStartDate = LocalDateTime.ofInstant(endorseMain.getStartDate().toInstant(), ZoneId.systemDefault());
                }
                if (ObjectUtil.isNotEmpty((Object)endorseMain.getEndDate())) {
                    oEndDate = LocalDateTime.ofInstant(endorseMain.getEndDate().toInstant(), ZoneId.systemDefault());
                }
                endorseComCode = endorseMain.getComCode();
                creator = order.getCreator();
                proposalNo = policyRefStr;
                if (null != endorseMain.getChgSumPremium() && (premium = BigDecimal.valueOf(endorseMain.getChgSumPremium())).compareTo(BigDecimal.ZERO) < 0) {
                    log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u6279\u5355\u4fdd\u8d39\u53d8\u5316\u91cf\u5c0f\u4e8e0\uff0c\u65e0\u9700\u652f\u4ed8\uff0c\u4e1a\u52a1\u53f7\uff1a{}", (Object)policyRefStr);
                    throw new ApisBusinessException("\u6279\u5355\u4fdd\u8d39\u53d8\u5316\u91cf\u5c0f\u4e8e0\uff0c\u65e0\u9700\u652f\u4ed8", ErrorBisCodeEnum.ERR_B40005.getKey());
                }
            } else {
                QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
                apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)policyRefStr);
                ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusinessChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
                if (BeanUtil.isEmpty((Object)order, (String[])new String[0])) {
                    log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38,\u4e1a\u52a1\u53f7\uff1a{}", (Object)policyRefStr);
                    throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40004.getValue(), ErrorBisCodeEnum.ERR_B40004.getKey());
                }
                productCode = order.getProductCode();
                planName = order.getPlanName();
                giftType = order.getGiftType();
                payNumber = order.getPayNumbers();
                oStartDate = order.getStartDate();
                oEndDate = order.getEndDate();
                creator = order.getCreator();
                proposalNo = order.getProposalNo();
                premium = order.getPremium();
                goodsCode = order.getPlanCode();
                goodsName = order.getPlanName();
            }
            log.warn("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f,productCode:{},planName:{},giftType:{},payNumber:{}", new Object[]{productCode, planName, giftType, payNumber});
            if (BeanUtil.isEmpty((Object)productCode, (String[])new String[0])) {
                log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f,productCode\u7a7a\u6307\u9488\u5f02\u5e38,\u4e1a\u52a1\u53f7\uff1a{}", (Object)policyRefStr);
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40001.getValue(), ErrorBisCodeEnum.ERR_B40001.getKey());
            }
            if (BeanUtil.isEmpty((Object)planName, (String[])new String[0])) {
                log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0cplanName\u7a7a\u6307\u9488\u5f02\u5e38\uff0c\u4e1a\u52a1\u53f7\uff1a{}", (Object)policyRefStr);
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40005.getValue(), ErrorBisCodeEnum.ERR_B40005.getKey());
            }
            if (BeanUtil.isNotEmpty((Object)giftType, (String[])new String[0]) && "_1_2".contains(giftType)) {
                log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c\u8d60\u9669\u4fdd\u5355\u4e0d\u8d70\u652f\u4ed8\u6d41\u7a0b\uff0c\u4e1a\u52a1\u53f7\uff1a{}", (Object)policyRefStr);
                throw new ApisBusinessException("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c\u8d60\u9669\u4fdd\u5355\u4e0d\u8d70\u652f\u4ed8\u6d41\u7a0b\uff0c\u4e1a\u52a1\u53f7\uff1a" + policyRef, ErrorBisCodeEnum.ERR_B40005.getKey());
            }
            if (BeanUtil.isNotEmpty((Object)payNumber, (String[])new String[0]) && payNumber > 1 && (BeanUtil.isEmpty((Object)channelDTO.getEntrustPayFlag(), (String[])new String[0]) || !"1".equals(channelDTO.getEntrustPayFlag()))) {
                log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c\u5206\u671f\u4fdd\u5355\u5206\u671f\u6807\u5fd7\u53ca\u88ab\u4fdd\u9669\u4eba\u540d\u79f0\u3001\u8bc1\u4ef6\u53f7\u3001\u8bc1\u4ef6\u7c7b\u578b\u5fc5\u4f20\uff0c\u4e1a\u52a1\u53f7\uff1a{}", (Object)policyRef);
                throw new ApisBusinessException("\u5206\u671f\u4fdd\u5355\u5206\u671f\u6807\u5fd7\u53ca\u88ab\u4fdd\u9669\u4eba\u540d\u79f0\u3001\u8bc1\u4ef6\u53f7\u3001\u8bc1\u4ef6\u7c7b\u578b\u5fc5\u4f20,\u4e1a\u52a1\u53f7\uff1a" + policyRef, ErrorBisCodeEnum.ERR_B40005.getKey());
            }
            if ("2".equals(channelDTO.getEntrustPayFlag())) {
                boolean isOneYear = false;
                if (ObjectUtil.isNotEmpty((Object)oStartDate) && ObjectUtil.isNotEmpty((Object)oEndDate)) {
                    isOneYear = DataCompletionUtil.isOutOneYear((LocalDateTime)oStartDate, (LocalDateTime)oEndDate, (boolean)true);
                }
                if (!isOneYear) {
                    log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c\u5206\u671f\u4fdd\u5355\u5206\u671f\u6807\u5fd7\u53d6\u503c\u9519\u8bef\uff0c\u4e1a\u52a1\u53f7\uff1a{}\uff0centrustPayFlag\uff1a{}", (Object)policyRef, (Object)channelDTO.getEntrustPayFlag());
                    throw new ApisBusinessException("\u5206\u671f\u4fdd\u5355\u5206\u671f\u6807\u5fd7\u53d6\u503c\u9519\u8bef", ErrorBisCodeEnum.ERR_B40005.getKey());
                }
            }
            String comCode = "";
            if (StrUtil.isBlank((CharSequence)endorseComCode)) {
                ApisChannelUserDTO channelUserDTO = this.apisBusinessChannelOrderMapper.selectChannelUserInfo(creator);
                comCode = channelUserDTO.getComCode();
            } else {
                comCode = endorseComCode;
            }
            if (StrUtil.isEmpty((CharSequence)comCode)) {
                log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0ccomCode\u83b7\u53d6\u5f02\u5e38\uff0c\u4e1a\u52a1\u53f7\uff1a{}", (Object)policyRefStr);
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40005.getValue(), "ERR_B40006");
            }
            body.setProductName(planName);
            body.setRouteCode(StrUtil.sub((CharSequence)comCode, (int)0, (int)4));
            applyInfoDTO = new ApplyInfoDTO();
            applyInfoDTO.setBusinessNo(proposalNo);
            applyInfoDTO.setComCode(comCode);
            applyInfoDTO.setRiskCode(productCode);
            if (StrUtil.isNotBlank((CharSequence)goodsCode)) {
                applyInfoDTO.setGoodsCode(goodsCode);
            }
            if (StrUtil.isNotBlank((CharSequence)goodsName)) {
                applyInfoDTO.setGoodsName(goodsName);
            }
            if (isBatchPayment) {
                applyInfoDTO.setAmount(((PolicyInfoDTO)channelDTO.getPolicyList().get(ind)).getPremium().toString());
            } else if (premium == null || premium.compareTo(BigDecimal.ZERO) == 0) {
                applyInfoDTO.setAmount(channelDTO.getTotalPremium().toString());
            } else {
                applyInfoDTO.setAmount(premium.toString());
            }
            if (policyRefArr.length == 1) {
                applyInfoDTO.setAmount(channelDTO.getTotalPremium().toString());
            }
            if (envFlag && StringUtils.isEmpty((CharSequence)payRealPremium) && this.getRedCentOpen().booleanValue()) {
                applyInfoDTO.setAmount("0.01");
            }
            Date startDate = Date.from(oStartDate.atZone(ZoneId.systemDefault()).toInstant());
            applyInfoDTO.setEffectDate(DateUtil.format((Date)startDate, (String)"yyyy-MM-dd"));
            applyInfoDTO.setSerialNo(i + "");
            if ("1".equals(channelDTO.getEntrustPayFlag()) || "1".equals(channelDTO.getRenewalPayFlag())) {
                ArrayList<InsuredInfoDTO> insuredInfos = new ArrayList<InsuredInfoDTO>();
                List insuredInfoDTOS = null;
                insuredInfoDTOS = isBatchPayment ? ((PolicyInfoDTO)channelDTO.getPolicyList().get(ind)).getInsuredInfos() : channelDTO.getInsuredInfos();
                if (BeanUtil.isEmpty((Object)insuredInfoDTOS, (String[])new String[0])) {
                    throw new ApisBusinessException("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c\u5206\u671f\u4fdd\u5355\u88ab\u4fdd\u9669\u4eba\u540d\u79f0\u3001\u8bc1\u4ef6\u53f7\u3001\u8bc1\u4ef6\u7c7b\u578b\u5fc5\u4f20\uff0c\u4e1a\u52a1\u53f7\uff1a" + policyRef, ErrorBisCodeEnum.ERR_B40005.getKey());
                }
                for (InsuredInfoDTO item : insuredInfoDTOS) {
                    String name = item.getName();
                    String identifyNo = item.getIdentifyNo();
                    String identifyType = PaymentServiceImpl.getIdentifyType((String)item.getIdentifyType());
                    if (StrUtil.isEmpty((CharSequence)name) || StrUtil.isEmpty((CharSequence)identifyNo) || StrUtil.isEmpty((CharSequence)identifyType)) {
                        throw new ApisBusinessException("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c\u5206\u671f\u4fdd\u5355\u88ab\u4fdd\u9669\u4eba\u540d\u79f0\u3001\u8bc1\u4ef6\u53f7\u3001\u8bc1\u4ef6\u7c7b\u578b\u5fc5\u4f20\uff0c\u4e1a\u52a1\u53f7\uff1a" + policyRef, ErrorBisCodeEnum.ERR_B40005.getKey());
                    }
                    InsuredInfoDTO insuredInfoDTO = new InsuredInfoDTO();
                    insuredInfoDTO.setName(name);
                    insuredInfoDTO.setIdentifyNo(identifyNo);
                    insuredInfoDTO.setIdentifyType(identifyType);
                    insuredInfos.add(insuredInfoDTO);
                }
                if (insuredInfos.size() > 0) {
                    applyInfoDTO.setInsuredDtos(insuredInfos);
                }
            }
            ++i;
            ++ind;
            list.add(applyInfoDTO);
        }
        body.setApplyInfoDTO(list);
        JSONObject headMap = JSON.parseObject((String)JSON.toJSONString((Object)head));
        JSONObject bodyMap = JSON.parseObject((String)JSON.toJSONString((Object)body));
        EpaySign epaySignClient = EpaySign.newInstance(null, (String)this.privateKey, (Boolean)false);
        String content = epaySignClient.requestSign((Map)headMap, (Map)bodyMap);
        log.warn("\u652f\u4ed8\u7f51\u5173\uff0c\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c \u8bf7\u6c42\u53c2\u6570sign\uff1a{}", (Object)content);
        head.setSign(content);
        req.setHead(head);
        req.setBody(body);
        return req;
    }

    private void redirect(String checkNo, String payNo, String mobileUrl, String url, boolean isMobile, HttpServletResponse response) throws Exception {
        response.setContentType("text/html; charset=UTF-8");
        String timestamp = DateUtil.current() + "";
        String content = "checkCode=" + checkNo + "&payNo=" + payNo + "&timeStamp=" + timestamp;
        String sign = PaymentGatewaySHAUtil.sha1((String)content);
        String payUrl = "";
        String payClient = "";
        if (isMobile) {
            payUrl = StrUtil.isNotEmpty((CharSequence)mobileUrl) ? mobileUrl : this.corePayApplyOpenUrl;
            payClient = "weixin";
        } else {
            payUrl = this.corePayApplyOpenUrl;
        }
        payUrl = payUrl + "?random=" + Math.random();
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<!DOCTYPE html>");
        htmlBuilder.append("<html>");
        htmlBuilder.append("<head>");
        htmlBuilder.append("<title>\u652f\u4ed8\u8df3\u8f6c\u9875\u9762</title>");
        htmlBuilder.append("</head>");
        htmlBuilder.append("<body>");
        htmlBuilder.append("<form id=\"returnForm\" method=\"post\" action=\"" + payUrl + "\">");
        htmlBuilder.append("<input type=\"hidden\" name=\"");
        htmlBuilder.append("payNo");
        htmlBuilder.append("\" value=\"");
        htmlBuilder.append(payNo);
        htmlBuilder.append("\">");
        htmlBuilder.append("<input type=\"hidden\" name=\"");
        htmlBuilder.append("timeStamp");
        htmlBuilder.append("\" value=\"");
        htmlBuilder.append(timestamp);
        htmlBuilder.append("\">");
        if (isMobile) {
            htmlBuilder.append("<input type=\"hidden\" name=\"");
            htmlBuilder.append("payClient");
            htmlBuilder.append("\" value=\"");
            htmlBuilder.append(payClient);
            htmlBuilder.append("\">");
        }
        htmlBuilder.append("<input type=\"hidden\" name=\"");
        htmlBuilder.append("sign");
        htmlBuilder.append("\" value=\"");
        htmlBuilder.append(sign);
        htmlBuilder.append("\">");
        htmlBuilder.append("</form>");
        htmlBuilder.append("<script>function addRefreshListener() {\n          var isPageHide = false;\n            window.addEventListener('pageshow', function () {\n              if (isPageHide) {\n                window.history.go(-1);\n              }\n            });\n            window.addEventListener('pagehide', function () {\n              isPageHide = true;\n            });\n        }\n");
        htmlBuilder.append("addRefreshListener();document.getElementById('returnForm').submit();</script>");
        htmlBuilder.append("</body>");
        htmlBuilder.append("</html>");
        PrintWriter out = response.getWriter();
        out.println(htmlBuilder.toString());
        out.close();
    }

    public void payReturnCallBack(String payAppNo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List policyPayLogList;
        log.warn("\u652f\u4ed8\u7f51\u5173\uff0c\u540c\u6b65\u56de\u8c03\u5f00\u59cb\uff0c\u652f\u4ed8\u53f7\uff1a{}", (Object)payAppNo);
        if (StrUtil.isEmpty((CharSequence)payAppNo)) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u652f\u4ed8\u53f7\u7f3a\u5931");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pay_no", (Object)payAppNo);
        List apisBusiPayLogs = this.apisPayLogMapper.selectList((Wrapper)queryWrapper);
        QueryWrapper apisBusiChannelOrderQueryWrapper = null;
        ApisBusiChannelOrder updateEntity = null;
        UpdateWrapper wrapper = null;
        ApisBusiPayLog updatePayLog = null;
        QueryWrapper installmentOrderUpdateWrapper = null;
        List apisBusiChannelInstallmentOrders = null;
        String orderNo = "";
        String status = "";
        String agentCode = "";
        DateTime dateTime = DateUtil.date((Date)new Date());
        ApisBusiPayLog apisBusiPayLog = new ApisBusiPayLog();
        LocalDateTime localDateTime = dateTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        boolean isBatchPayment = false;
        for (ApisBusiPayLog apisBusiPayLogBusi : apisBusiPayLogs) {
            if ("BatchPayment".equals(apisBusiPayLogBusi.getBusinessNo())) {
                isBatchPayment = true;
            } else {
                apisBusiChannelOrderQueryWrapper = new QueryWrapper();
                apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)apisBusiPayLogBusi.getBusinessNo());
                ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusinessChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
                if (ObjectUtil.isNotEmpty((Object)order)) {
                    orderNo = order.getOrderNo();
                    UpdateWrapper orderUpdateWrapper = new UpdateWrapper();
                    orderUpdateWrapper.eq((Object)"id", (Object)order.getId());
                    updateEntity = new ApisBusiChannelOrder();
                    updateEntity.setStatus("04");
                    updateEntity.setPayTime(localDateTime);
                    updateEntity.setPolicyTime(localDateTime);
                    this.apisBusinessChannelOrderMapper.update((Object)updateEntity, (Wrapper)orderUpdateWrapper);
                } else {
                    QueryWrapper apisBusiCorrectOrderQueryWrapper = new QueryWrapper();
                    apisBusiCorrectOrderQueryWrapper.eq((Object)"apply_no", (Object)apisBusiPayLogBusi.getBusinessNo());
                    ApisBusiCorrectOrder correctOrder = (ApisBusiCorrectOrder)this.apisBusiCorrectOrderMapper.selectOne((Wrapper)apisBusiCorrectOrderQueryWrapper);
                    orderNo = correctOrder.getBusinessKey();
                }
            }
            status = "wxpayH5".equals(apisBusiPayLogBusi.getPaymentMethod()) ? "PROCESSING" : "SUCCESS";
            wrapper = new UpdateWrapper();
            updatePayLog = new ApisBusiPayLog();
            updatePayLog.setPayTime(new Date());
            updatePayLog.setTradeStatus(status);
            updatePayLog.setMsg("\u8bf7\u6c42\u6210\u529f");
            wrapper.eq((Object)"id", (Object)apisBusiPayLogBusi.getId());
            this.apisPayLogMapper.update((Object)updatePayLog, (Wrapper)wrapper);
            if (!"BatchPayment".equals(apisBusiPayLogBusi.getBusinessNo())) {
                installmentOrderUpdateWrapper = new QueryWrapper();
                installmentOrderUpdateWrapper.eq((Object)"policy_no", (Object)apisBusiPayLogBusi.getBusinessNo());
                installmentOrderUpdateWrapper.eq((Object)"current_pay_no", (Object)1);
                apisBusiChannelInstallmentOrders = this.apisBusiChannelInstallmentOrderMapper.selectList((Wrapper)installmentOrderUpdateWrapper);
                if (ObjectUtils.isNotEmpty((Object)apisBusiChannelInstallmentOrders) && apisBusiChannelInstallmentOrders.size() > 0) {
                    for (ApisBusiChannelInstallmentOrder apisBusiChannelInstallmentOrder : apisBusiChannelInstallmentOrders) {
                        apisBusiChannelInstallmentOrder.setPayTime(localDateTime);
                        apisBusiChannelInstallmentOrder.setUpdateTime(new Date());
                        this.apisBusiChannelInstallmentOrderMapper.updateById((Object)apisBusiChannelInstallmentOrder);
                    }
                }
            }
            apisBusiPayLogBusi.setMsg(updatePayLog.getMsg());
            apisBusiPayLogBusi.setPayTime(updatePayLog.getPayTime());
            apisBusiPayLogBusi.setTradeStatus(updatePayLog.getTradeStatus());
            apisBusiPayLog = apisBusiPayLogBusi;
        }
        if (isBatchPayment) {
            List mainPayLogList = apisBusiPayLogs.stream().filter(payLog -> "BatchPayment".equals(payLog.getBusinessNo())).collect(Collectors.toList());
            apisBusiPayLog = (ApisBusiPayLog)mainPayLogList.get(0);
        } else if (apisBusiPayLogs.size() > 1) {
            String policyRef = "";
            for (int i = 0; i < apisBusiPayLogs.size(); ++i) {
                policyRef = i == apisBusiPayLogs.size() - 1 ? policyRef + ((ApisBusiPayLog)apisBusiPayLogs.get(i)).getBusinessNo() : policyRef + ((ApisBusiPayLog)apisBusiPayLogs.get(i)).getBusinessNo() + ",";
            }
            apisBusiPayLog.setBusinessNo(policyRef);
        }
        String sign = this.getSign(apisBusiPayLog, orderNo, status);
        response.setContentType("text/html; charset=UTF-8");
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<!DOCTYPE html>");
        htmlBuilder.append("<html>");
        htmlBuilder.append("<head>");
        htmlBuilder.append("<title>\u652f\u4ed8\u56de\u8c03\u9875\u9762</title>");
        htmlBuilder.append("</head>");
        htmlBuilder.append("<body>");
        htmlBuilder.append("<form id=\"returnForm\" method=\"post\" action=\"" + StrUtil.nullToEmpty((CharSequence)apisBusiPayLog.getReturnUrl()) + "\">");
        htmlBuilder.append("<input name=\"agencyCode\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)apisBusiPayLog.getAgencyCode()) + "\"/>");
        htmlBuilder.append("<input name=\"policyRef\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)apisBusiPayLog.getBusinessNo()) + "\"/>");
        htmlBuilder.append("<input name=\"totalPremium\" type=\"hidden\" value=\"" + (apisBusiPayLog.getTotalPremium() == null ? "" : apisBusiPayLog.getTotalPremium().toString()) + "\"/>");
        htmlBuilder.append("<input name=\"paymentMethod\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)apisBusiPayLog.getPaymentMethod()) + "\"/>");
        htmlBuilder.append("<input name=\"notifyUrl\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)apisBusiPayLog.getNotifyUrl()) + "\"/>");
        htmlBuilder.append("<input name=\"returnUrl\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)apisBusiPayLog.getReturnUrl()) + "\"/>");
        htmlBuilder.append("<input name=\"paymentGatewaySn\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)orderNo) + "\"/>");
        htmlBuilder.append("<input name=\"payTime\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)DateUtil.format((Date)updatePayLog.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss")) + "\"/>");
        htmlBuilder.append("<input name=\"tradeStatus\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)status) + "\"/>");
        htmlBuilder.append("<input name=\"msg\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)updatePayLog.getMsg()) + "\"/>");
        htmlBuilder.append("<input name=\"sign\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)sign) + "\"/>");
        htmlBuilder.append("<input name=\"orderNo\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)apisBusiPayLog.getOrderNo()) + "\"/>");
        if (isBatchPayment && ObjectUtil.isNotEmpty(policyPayLogList = apisBusiPayLogs.stream().filter(payLog -> !"BatchPayment".equals(payLog.getBusinessNo())).collect(Collectors.toList()))) {
            int ind = 0;
            for (ApisBusiPayLog payLog2 : policyPayLogList) {
                htmlBuilder.append("<input name=\"").append(String.format(this.formPolicyRefName, ind)).append("\" type=\"hidden\" value=\"").append(payLog2.getBusinessNo()).append("\"/>");
                htmlBuilder.append("<input name=\"").append(String.format(this.formPreimumName, ind)).append("\" type=\"hidden\" value=\"").append(payLog2.getTotalPremium()).append("\"/>");
                ++ind;
            }
        }
        htmlBuilder.append("</form>");
        htmlBuilder.append("<script>function addRefreshListener() {\n          var isPageHide = false;\n            window.addEventListener('pageshow', function () {\n              if (isPageHide) {\n                window.history.go(-1);\n              }\n            });\n            window.addEventListener('pagehide', function () {\n              isPageHide = true;\n            });\n        }\n");
        htmlBuilder.append("addRefreshListener();document.getElementById('returnForm').submit();</script>");
        htmlBuilder.append("</body>");
        htmlBuilder.append("</html>");
        log.warn(htmlBuilder.toString());
        PrintWriter out = response.getWriter();
        out.println(htmlBuilder.toString());
        out.close();
        log.warn("\u652f\u4ed8\u7f51\u5173\uff0c\u540c\u6b65\u56de\u8c03\u7ed3\u675f\uff0c\u652f\u4ed8\u53f7\uff1a{}", (Object)payAppNo);
    }

    public Object payNotifyCallBack(@RequestBody PaymentNotifyMessageRequestDTO paymentNotifyMessageRequestDTO, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.payNotifyCallBackCore(paymentNotifyMessageRequestDTO, false, false);
    }

    public Object endorsePayNotifyCallBack(PaymentNotifyMessageRequestDTO paymentNotifyMessageRequestDTO) throws Exception {
        return this.payNotifyCallBackCore(paymentNotifyMessageRequestDTO, true, true);
    }

    private Object payNotifyCallBackCore(PaymentNotifyMessageRequestDTO paymentNotifyMessageRequestDTO, boolean isEndorsement, boolean isTask) throws Exception {
        List policyPayList;
        ApisBusiPayLog apisBusiPayLog2;
        String payAppNo;
        try {
            payAppNo = ((PaymentNotifyMessageDetailDTO)paymentNotifyMessageRequestDTO.getBody().getNoticeDetailDTO().get(0)).getPayApplyNo();
        }
        catch (Exception e) {
            throw new RuntimeException("\u672a\u83b7\u53d6\u652f\u4ed8\u7533\u8bf7\u53f7\u62a5\u9519");
        }
        log.warn("\u652f\u4ed8\u7f51\u5173\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0c\u652f\u4ed8\u53f7\uff1a{}", (Object)payAppNo);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pay_no", (Object)payAppNo);
        List apisBusiPayLogs = this.apisPayLogMapper.selectList((Wrapper)queryWrapper);
        DateTime dateTime = DateUtil.date((Date)new Date());
        BigDecimal totalPremiumBig = BigDecimal.ZERO;
        String orderNo = "";
        UpdateWrapper orderUpdateWrapper = null;
        ApisBusiChannelOrder updateEntity = null;
        QueryWrapper apisBusiChannelOrderQueryWrapper = null;
        ApisBusiPayLog updatePayLog = null;
        QueryWrapper installmentOrderUpdateWrapper = null;
        LocalDateTime localDateTime = dateTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        ArrayList<ApisBusiCorrectOrder> correctOrderList = new ArrayList<ApisBusiCorrectOrder>();
        boolean isBatchPayment = false;
        for (ApisBusiPayLog apisBusiPayLog2 : apisBusiPayLogs) {
            if ("BatchPayment".equals(apisBusiPayLog2.getBusinessNo())) {
                isBatchPayment = true;
            }
            totalPremiumBig = apisBusiPayLog2.getTotalPremium();
            String status = "";
            boolean isEndorse = isEndorsement;
            if (!"BatchPayment".equals(apisBusiPayLog2.getBusinessNo())) {
                if (!isEndorse) {
                    apisBusiChannelOrderQueryWrapper = new QueryWrapper();
                    apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)apisBusiPayLog2.getBusinessNo());
                    ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusinessChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
                    if (ObjectUtil.isNotEmpty((Object)order)) {
                        orderUpdateWrapper = new UpdateWrapper();
                        orderUpdateWrapper.eq((Object)"id", (Object)order.getId());
                        updateEntity = new ApisBusiChannelOrder();
                        updateEntity.setStatus("04");
                        updateEntity.setPayTime(localDateTime);
                        updateEntity.setPolicyTime(localDateTime);
                        this.apisBusinessChannelOrderMapper.update((Object)updateEntity, (Wrapper)orderUpdateWrapper);
                        orderNo = order.getOrderNo();
                        this.addToTianYuanPolicyCallbackTask(order, apisBusiPayLog2);
                    } else {
                        isEndorse = true;
                    }
                }
                if (isEndorse) {
                    QueryWrapper apisBusiCorrectOrderQueryWrapper = new QueryWrapper();
                    apisBusiCorrectOrderQueryWrapper.eq((Object)"apply_no", (Object)apisBusiPayLog2.getBusinessNo());
                    ApisBusiCorrectOrder correctOrder = (ApisBusiCorrectOrder)this.apisBusiCorrectOrderMapper.selectOne((Wrapper)apisBusiCorrectOrderQueryWrapper);
                    orderNo = correctOrder.getBusinessKey();
                    String applyNo = correctOrder.getApplyNo();
                    UnderWriteQueryRequest uwQueryRequest = UnderWriteQueryRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(UnderWriteQueryRequestDTO.builder().applyNo(applyNo).build()).build();
                    String endorseNo = null;
                    UnderWriteQueryResponse underWriteQueryResponse = null;
                    try {
                        underWriteQueryResponse = this.dataCompletionUtil.underWriteQuery(uwQueryRequest);
                        endorseNo = underWriteQueryResponse.getResponseBody().getEndorseNo();
                    }
                    catch (ApisBusinessException e) {
                        log.error("\u8c03\u7528\u6838\u4fdd\u72b6\u6001\u67e5\u8be2\uff1a", (Throwable)e);
                    }
                    if (StrUtil.isNotBlank(endorseNo)) {
                        correctOrder.setEndorseNo(endorseNo);
                        correctOrderList.add(correctOrder);
                        ApisBusiCorrectOrder apisBusiCorrectOrderForUpdate = new ApisBusiCorrectOrder();
                        apisBusiCorrectOrderForUpdate.setEndorseNo(endorseNo);
                        UpdateWrapper correctOrderUpdateWrapper = new UpdateWrapper();
                        correctOrderUpdateWrapper.eq((Object)"id", (Object)correctOrder.getId());
                        this.apisBusiCorrectOrderMapper.update((Object)apisBusiCorrectOrderForUpdate, (Wrapper)correctOrderUpdateWrapper);
                    } else {
                        if (!isTask) {
                            this.apisBusiTaskLogService.insertTaskInfo(ApisAutoTaskConstantsEnum.ENDORSE_PAYMENT_ASYNC_RETURN_NO.getValue(), payAppNo, null, JSONObject.toJSONString((Object)paymentNotifyMessageRequestDTO));
                            return this.returnResult(payAppNo, "\u901a\u77e5\u6210\u529f");
                        }
                        throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40008.getValue(), ErrorBisCodeEnum.ERR_B40008.getKey());
                    }
                }
            }
            status = "SUCCESS";
            UpdateWrapper wrapper = new UpdateWrapper();
            updatePayLog = new ApisBusiPayLog();
            updatePayLog.setPayTime(new Date());
            updatePayLog.setTradeStatus(status);
            updatePayLog.setMsg("\u8bf7\u6c42\u6210\u529f");
            String updateMethod = null;
            try {
                updateMethod = ((PaymentNotifyMessageDetailDTO)paymentNotifyMessageRequestDTO.getBody().getNoticeDetailDTO().get(0)).getPayMethod();
                String exChangePayMethod = (String)peyMethodMap.get(updateMethod);
                if (StringUtils.isNotEmpty((CharSequence)exChangePayMethod)) {
                    updateMethod = exChangePayMethod;
                }
            }
            catch (Exception e) {
                updateMethod = null;
            }
            if (StringUtils.isNotEmpty(updateMethod)) {
                updatePayLog.setPaymentMethod(updateMethod);
                apisBusiPayLog2.setPaymentMethod(updateMethod);
            }
            wrapper.eq((Object)"id", (Object)apisBusiPayLog2.getId());
            this.apisPayLogMapper.update((Object)updatePayLog, (Wrapper)wrapper);
            if ("BatchPayment".equals(apisBusiPayLog2.getBusinessNo())) continue;
            installmentOrderUpdateWrapper = new QueryWrapper();
            installmentOrderUpdateWrapper.eq((Object)"policy_no", (Object)apisBusiPayLog2.getBusinessNo());
            installmentOrderUpdateWrapper.eq((Object)"current_pay_no", (Object)1);
            List apisBusiChannelInstallmentOrders = this.apisBusiChannelInstallmentOrderMapper.selectList((Wrapper)installmentOrderUpdateWrapper);
            if (!ObjectUtils.isNotEmpty((Object)apisBusiChannelInstallmentOrders) || apisBusiChannelInstallmentOrders.size() <= 0) continue;
            for (ApisBusiChannelInstallmentOrder apisBusiChannelInstallmentOrder : apisBusiChannelInstallmentOrders) {
                apisBusiChannelInstallmentOrder.setPayTime(localDateTime);
                apisBusiChannelInstallmentOrder.setUpdateTime(new Date());
                this.apisBusiChannelInstallmentOrderMapper.updateById((Object)apisBusiChannelInstallmentOrder);
            }
        }
        String status = "SUCCESS";
        apisBusiPayLog2 = null;
        if (isBatchPayment) {
            List mainPolicyPayList = apisBusiPayLogs.stream().filter(payLog -> "BatchPayment".equals(payLog.getBusinessNo())).collect(Collectors.toList());
            apisBusiPayLog2 = (ApisBusiPayLog)mainPolicyPayList.get(0);
            totalPremiumBig = apisBusiPayLog2.getTotalPremium();
            orderNo = apisBusiPayLog2.getOrderNo();
        } else {
            apisBusiPayLog2 = (ApisBusiPayLog)apisBusiPayLogs.get(0);
        }
        OkHttpClient client = OkHttpUtils.getSslHttpsClient();
        String url = apisBusiPayLog2.getNotifyUrl();
        String agencyCode = apisBusiPayLog2.getAgencyCode();
        String policyRef = apisBusiPayLog2.getBusinessNo();
        String totalPremium = totalPremiumBig.toString();
        String paymentMethod = apisBusiPayLog2.getPaymentMethod();
        String notifyUrl = apisBusiPayLog2.getNotifyUrl();
        String returnUrl = apisBusiPayLog2.getReturnUrl();
        String paymentGatewaySn = orderNo;
        String payTime = DateUtil.format((LocalDateTime)localDateTime, (String)"yyyy-MM-dd HH:mm:ss");
        String tradeStatus = status;
        String msg = "\u8bf7\u6c42\u6210\u529f";
        String endorseNo = null;
        if (!isBatchPayment && apisBusiPayLogs.size() > 1) {
            policyRef = "";
            for (int i = 0; i < apisBusiPayLogs.size(); ++i) {
                policyRef = i == apisBusiPayLogs.size() - 1 ? policyRef + ((ApisBusiPayLog)apisBusiPayLogs.get(i)).getBusinessNo() : policyRef + ((ApisBusiPayLog)apisBusiPayLogs.get(i)).getBusinessNo() + ",";
            }
        }
        if (ObjectUtil.isNotEmpty(correctOrderList)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < correctOrderList.size(); ++i) {
                if (i == correctOrderList.size() - 1) {
                    stringBuilder.append(((ApisBusiCorrectOrder)correctOrderList.get(i)).getEndorseNo());
                    continue;
                }
                stringBuilder.append(correctOrderList.get(i) + ",");
            }
            endorseNo = stringBuilder.toString();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policyRef", policyRef);
        params.put("agencyCode", agencyCode);
        params.put("totalPremium", totalPremium);
        params.put("paymentMethod", paymentMethod);
        params.put("notifyUrl", notifyUrl);
        params.put("returnUrl", returnUrl);
        params.put("paymentGatewaySn", paymentGatewaySn);
        params.put("payTime", payTime);
        params.put("tradeStatus", tradeStatus);
        params.put("msg", msg);
        String sign = PaymentServiceImpl.getOldSign(params, (String)this.successPaySignConstant);
        log.warn("=======callback======\u652f\u4ed8\u6210\u529f\u5f02\u6b65\u56de\u8c03\uff0c\u9a8c\u7b7e\uff1a{}", (Object)sign);
        FormBody.Builder builder = new FormBody.Builder();
        PaymentNotifyToAgentDTO.PaymentNotifyToAgentDTOBuilder agentDTOBuilder = PaymentNotifyToAgentDTO.builder();
        if (ObjectUtil.isNotEmpty((Object)endorseNo)) {
            builder.add(RETURN_PARAM_ENDORSEMENT_NO, endorseNo);
            agentDTOBuilder.endorsementNo(endorseNo);
        }
        if (isBatchPayment && ObjectUtil.isNotEmpty(policyPayList = apisBusiPayLogs.stream().filter(payLog -> !"BatchPayment".equals(payLog.getBusinessNo())).collect(Collectors.toList()))) {
            ArrayList<PaymentNotifyToAgentPolicyInfoDTO> policyInfoList = new ArrayList<PaymentNotifyToAgentPolicyInfoDTO>();
            int ind = 0;
            for (ApisBusiPayLog payLog2 : policyPayList) {
                builder.add(String.format(this.formPolicyRefName, ind), payLog2.getBusinessNo());
                if (ObjectUtil.isNotEmpty((Object)payLog2.getTotalPremium())) {
                    builder.add(String.format(this.formPreimumName, ind), payLog2.getTotalPremium().toString());
                }
                PaymentNotifyToAgentPolicyInfoDTO policyInfoDTO = new PaymentNotifyToAgentPolicyInfoDTO();
                policyInfoDTO.setPolicyRef(payLog2.getBusinessNo());
                policyInfoDTO.setPremium(payLog2.getTotalPremium());
                policyInfoList.add(policyInfoDTO);
                ++ind;
            }
            agentDTOBuilder.policyList(policyInfoList);
        }
        if (ObjectUtil.isNotEmpty((Object)((ApisBusiPayLog)apisBusiPayLogs.get(0)).getOrderNo())) {
            builder.add("orderNo", ((ApisBusiPayLog)apisBusiPayLogs.get(0)).getOrderNo());
        }
        FormBody requestBody = builder.add("policyRef", policyRef).add("agencyCode", agencyCode).add("totalPremium", totalPremium).add("paymentMethod", paymentMethod).add("notifyUrl", notifyUrl).add("returnUrl", returnUrl).add("paymentGatewaySn", paymentGatewaySn).add("payTime", payTime).add("tradeStatus", tradeStatus).add("msg", msg).add("sign", sign).build();
        PaymentNotifyToAgentDTO paymentNotifyToAgentDTO = agentDTOBuilder.policyRef(policyRef).agencyCode(agencyCode).totalPremium(totalPremium).paymentMethod(paymentMethod).notifyUrl(notifyUrl).returnUrl(returnUrl).paymentGatewaySn(paymentGatewaySn).payTime(payTime).tradeStatus(tradeStatus).msg(msg).orderNo(((ApisBusiPayLog)apisBusiPayLogs.get(0)).getOrderNo()).sign(sign).build();
        String requestString = JSON.toJSONString((Object)paymentNotifyToAgentDTO);
        ApisBusiTaskLog apisBusiTaskLogQuery = new ApisBusiTaskLog();
        apisBusiTaskLogQuery.setPushType(ApisAutoTaskConstantsEnum.PAY_NOTIFY_CALLBACK.getValue());
        apisBusiTaskLogQuery.setBusinessKey(payAppNo);
        QueryWrapper qwApisBusiTaskLog = new QueryWrapper((Object)apisBusiTaskLogQuery);
        ApisBusiTaskLog apisBusiTaskLog = (ApisBusiTaskLog)this.apisBusiTaskLogService.getOne((Wrapper)qwApisBusiTaskLog);
        if (ObjectUtil.isNotEmpty((Object)apisBusiTaskLog) && ObjectUtil.isNotEmpty((Object)apisBusiTaskLog.getBusinessKey())) {
            if ("1".equals(apisBusiTaskLog.getPushStatus())) {
                return this.returnResult(payAppNo, "\u91cd\u590d\u901a\u77e5\u4e86");
            }
            apisBusiTaskLog.setPushStep(Integer.valueOf(apisBusiTaskLog.getPushStep() + 1));
        } else {
            apisBusiTaskLog = new ApisBusiTaskLog();
            apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.PAY_NOTIFY_CALLBACK.getValue());
            apisBusiTaskLog.setBusinessKey(payAppNo);
            apisBusiTaskLog.setRemark("\u4fdd\u5355\u53f7\uff1a" + policyRef);
            apisBusiTaskLog.setPushStep(Integer.valueOf(1));
        }
        apisBusiTaskLog.setPushContent(requestString);
        apisBusiTaskLog.setPushTargetUrl(url);
        apisBusiTaskLog.setLastPushTime(LocalDateTime.now());
        Request req = new Request.Builder().url(url).post((okhttp3.RequestBody)requestBody).build();
        log.warn("\u652f\u4ed8\u5f02\u6b65\u56de\u8c03\u8bf7\u6c42\uff1a{}", (Object)requestString);
        try {
            Response resp = client.newCall(req).execute();
            log.warn("\u652f\u4ed8\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\uff1a{}", (Object)resp.toString());
            apisBusiTaskLog.setErrMsg(resp.toString());
            if (resp != null && resp.isSuccessful()) {
                log.warn("notify\u56de\u8c03\u6267\u884c\u6210\u529f");
                apisBusiTaskLog.setPushStatus("1");
            } else {
                log.warn("notify\u56de\u8c03\u6267\u884c\u5931\u8d25");
                apisBusiTaskLog.setPushStatus("4");
            }
        }
        catch (Exception e) {
            log.warn("notify\u56de\u8c03\u6267\u884c\u5931\u8d25");
            apisBusiTaskLog.setPushStatus("4");
            apisBusiTaskLog.setErrMsg(e.getMessage());
        }
        this.apisBusiTaskLogService.saveOrUpdate((Object)apisBusiTaskLog);
        return this.returnResult(payAppNo, "\u901a\u77e5\u6210\u529f");
    }

    private HashMap<String, Object> returnResult(String businessNo, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timestamp", System.currentTimeMillis());
        map.put("message", message);
        map.put("code", "0");
        EpaySign epaySignClient = EpaySign.newInstance(null, (String)this.privateKey, (Boolean)false);
        String content = epaySignClient.getSignCheckCotent(map, new HashMap());
        String resultSign = epaySignClient.requestSign(content);
        map.put("sign", resultSign);
        log.warn("\u5f02\u6b65\u56de\u8c03\u54cd\u5e94sign\u4e3a,{}", (Object)resultSign);
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        respMap.put("head", map);
        log.warn("\u652f\u4ed8\u7f51\u5173\uff0c\u5f02\u6b65\u56de\u8c03\u7ed3\u675f\uff0c\u4e1a\u52a1\u53f7\uff1a{}", (Object)businessNo);
        return respMap;
    }

    private String getSign(ApisBusiPayLog apisBusiPayLog, String orderNo, String status) {
        String agencyCode = apisBusiPayLog.getAgencyCode();
        String msg = apisBusiPayLog.getMsg();
        String notifyUrl = apisBusiPayLog.getNotifyUrl();
        String payTime = DateUtil.format((Date)apisBusiPayLog.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss");
        String paymentGatewaySn = orderNo;
        String paymentMethod = apisBusiPayLog.getPaymentMethod();
        String policyRef = apisBusiPayLog.getBusinessNo();
        String returnUrl = apisBusiPayLog.getReturnUrl();
        String totalPremium = apisBusiPayLog.getTotalPremium().toString();
        String tradeStatus = status;
        String signConstant = this.successPaySignConstant;
        String content = "agencyCode=" + agencyCode + "&msg=" + msg + "&notifyUrl=" + notifyUrl + "&payTime=" + payTime + "&paymentGatewaySn=" + paymentGatewaySn + "&paymentMethod=" + paymentMethod + "&policyRef=" + policyRef + "&returnUrl=" + returnUrl + "&totalPremium=" + totalPremium + "&tradeStatus=" + tradeStatus + signConstant;
        log.warn("\u540c\u6b65\u56de\u8c03\u52a0\u5bc6sign\uff0c\u62fc\u63a5\u5b57\u7b26\u4e32\uff1a{}", (Object)content);
        String sign = SecureUtil.md5((String)content);
        log.warn("\u540c\u6b65\u56de\u8c03\u52a0\u5bc6sign\uff1a{}", (Object)sign);
        return sign;
    }

    public ValidationRequestParamsResult validateRequestParams(PaymentGatewayChannelDTO channelDTO) {
        if (BeanUtil.isEmpty((Object)channelDTO, (String[])new String[0])) {
            return new ValidationRequestParamsResult(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey(), Boolean.valueOf(false));
        }
        if (StrUtil.isEmpty((CharSequence)channelDTO.getAgencyCode())) {
            return new ValidationRequestParamsResult(ErrorNullValueCodeEnum.ERR_N40001.getValue(), ErrorNullValueCodeEnum.ERR_N40001.getKey(), Boolean.valueOf(false));
        }
        if (StrUtil.isEmpty((CharSequence)channelDTO.getPolicyRef())) {
            return new ValidationRequestParamsResult(ErrorNullValueCodeEnum.ERR_N40002.getValue(), ErrorNullValueCodeEnum.ERR_N40002.getKey(), Boolean.valueOf(false));
        }
        if ("BatchPayment".equals(channelDTO.getPolicyRef())) {
            if (ObjectUtil.isNotEmpty((Object)channelDTO.getPolicyList())) {
                for (PolicyInfoDTO policyInfoDTO : channelDTO.getPolicyList()) {
                    if (StrUtil.isEmpty((CharSequence)policyInfoDTO.getPolicyRef())) {
                        return new ValidationRequestParamsResult(ErrorNullValueCodeEnum.ERR_N40002.getValue(), ErrorNullValueCodeEnum.ERR_N40002.getKey(), Boolean.valueOf(false));
                    }
                    if (!ObjectUtil.isEmpty((Object)policyInfoDTO.getPremium())) continue;
                    return new ValidationRequestParamsResult(ErrorNullValueCodeEnum.ERR_N40003.getValue(), ErrorNullValueCodeEnum.ERR_N40003.getKey(), Boolean.valueOf(false));
                }
            } else {
                return new ValidationRequestParamsResult(ErrorNullValueCodeEnum.ERR_N40009.getValue(), ErrorNullValueCodeEnum.ERR_N40009.getKey(), Boolean.valueOf(false));
            }
        }
        if (BeanUtil.isEmpty((Object)channelDTO.getTotalPremium(), (String[])new String[0])) {
            return new ValidationRequestParamsResult(ErrorNullValueCodeEnum.ERR_N40003.getValue(), ErrorNullValueCodeEnum.ERR_N40003.getKey(), Boolean.valueOf(false));
        }
        if (BeanUtil.isEmpty((Object)channelDTO.getPaymentMethod(), (String[])new String[0])) {
            channelDTO.setPaymentMethod("");
        }
        if (BeanUtil.isEmpty((Object)channelDTO.getNotifyUrl(), (String[])new String[0])) {
            return new ValidationRequestParamsResult(ErrorNullValueCodeEnum.ERR_N40005.getValue(), ErrorNullValueCodeEnum.ERR_N40005.getKey(), Boolean.valueOf(false));
        }
        if (BeanUtil.isEmpty((Object)channelDTO.getReturnUrl(), (String[])new String[0])) {
            return new ValidationRequestParamsResult(ErrorNullValueCodeEnum.ERR_N40006.getValue(), ErrorNullValueCodeEnum.ERR_N40006.getKey(), Boolean.valueOf(false));
        }
        if (BeanUtil.isEmpty((Object)channelDTO.getSign(), (String[])new String[0])) {
            return new ValidationRequestParamsResult(ErrorNullValueCodeEnum.ERR_N40007.getValue(), ErrorNullValueCodeEnum.ERR_N40007.getKey(), Boolean.valueOf(false));
        }
        if ("1".equals(channelDTO.getRenewalPayFlag()) && StringUtils.isEmpty((CharSequence)channelDTO.getContractNotifyUrl())) {
            return new ValidationRequestParamsResult(ErrorNullValueCodeEnum.ERR_N40008.getValue(), ErrorNullValueCodeEnum.ERR_N40008.getKey(), Boolean.valueOf(false));
        }
        return new ValidationRequestParamsResult(ErrorNullValueCodeEnum.ERR_N00000.getValue(), ErrorNullValueCodeEnum.ERR_N00000.getKey(), Boolean.valueOf(true));
    }

    public WebResponse wrapPaymentUrl(PaymentGatewayChannelDTO channelDTO, HttpServletRequest request, HttpServletResponse response) {
        String url = this.getPaymentUrl(channelDTO);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", url);
        WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(true)).message("\u6210\u529f").code("0").result(map).build();
        return webResponse;
    }

    public String getPaymentUrl(PaymentGatewayChannelDTO channelDTO) {
        String jsonStr = JSON.toJSONString((Object)channelDTO);
        String encodeStr = HexUtil.encodeHexStr((String)jsonStr);
        return this.paymentExecuteUrl + "/" + encodeStr;
    }

    public WebResponse wrapPaymentUrl(StanderRequest request) {
        WebResponse webResponse = null;
        log.warn("\u9ad8\u9662\u83b7\u53d6\u7f34\u8d39\u94fe\u63a5\u63a5\u53e3\u540c\u6b65\u56de\u8c03\u5730\u5740\uff1a{}", (Object)this.litigationPaymentReturnBackUrl);
        log.warn("\u9ad8\u9662\u83b7\u53d6\u7f34\u8d39\u94fe\u63a5\u63a5\u53e3\u5f02\u6b65\u56de\u8c03\u5730\u5740\uff1a{}", (Object)this.litigationPaymentNotifyBackUrl);
        LitigationPaymentUrlRequest litigationPaymentUrlRequest = request.getLitigationPaymentUrlRequest();
        String orderNo = litigationPaymentUrlRequest.getRequestBody().getOrderNo();
        if (StrUtil.isEmpty((CharSequence)orderNo)) {
            webResponse = WebResponse.builder().success(Boolean.valueOf(false)).code("-1").message("\u7a7a\u53c2\u6570\u5f02\u5e38").build();
            return webResponse;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)orderNo);
        List apisBusiChannelOrderList = this.apisBusinessChannelOrderMapper.selectList((Wrapper)queryWrapper);
        ApisBusiChannelOrder apisBusiChannelOrder = null;
        apisBusiChannelOrderList = apisBusiChannelOrderList.stream().filter(item -> "04".equals(item.getStatus()) || "05".equals(item.getStatus())).collect(Collectors.toList());
        if (BeanUtil.isEmpty((Object)(apisBusiChannelOrderList.size() == 0 ? 1 : 0), (String[])new String[0])) {
            webResponse = WebResponse.builder().success(Boolean.valueOf(false)).code("-1").message("\u8ba2\u5355\u4e0d\u5b58\u5728").build();
            return webResponse;
        }
        apisBusiChannelOrder = (ApisBusiChannelOrder)apisBusiChannelOrderList.get(0);
        PaymentGatewayChannelDTO paymentGatewayChannelDTO = new PaymentGatewayChannelDTO();
        paymentGatewayChannelDTO.setPolicyRef(apisBusiChannelOrder.getPolicyNo());
        paymentGatewayChannelDTO.setTotalPremium(apisBusiChannelOrder.getPremium());
        paymentGatewayChannelDTO.setAgencyCode(apisBusiChannelOrder.getAgentCode());
        paymentGatewayChannelDTO.setPaymentMethod("definePC");
        paymentGatewayChannelDTO.setNotifyUrl(this.litigationPaymentNotifyBackUrl);
        paymentGatewayChannelDTO.setReturnUrl(this.litigationPaymentReturnBackUrl);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("agencyCode", paymentGatewayChannelDTO.getAgencyCode());
        map.put("notifyUrl", paymentGatewayChannelDTO.getNotifyUrl());
        map.put("paymentMethod", paymentGatewayChannelDTO.getPaymentMethod());
        map.put("policyRef", paymentGatewayChannelDTO.getPolicyRef());
        map.put("returnUrl", paymentGatewayChannelDTO.getReturnUrl());
        map.put("totalPremium", paymentGatewayChannelDTO.getTotalPremium().toString());
        String content = PaymentGatewayUtil.createLinkString(map) + this.successPaySignConstant;
        String md5 = SecureUtil.md5((String)content);
        paymentGatewayChannelDTO.setSign(md5);
        Date now = new Date();
        DateTime expireDate = DateUtil.offsetHour((Date)now, (int)PAYMENT_DELAY_TIME_SETTING);
        paymentGatewayChannelDTO.setExpireTime((Date)expireDate);
        log.warn("\u9ad8\u9662\u83b7\u53d6\u7f34\u8d39\u94fe\u63a5\u63a5\u53e3,\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)paymentGatewayChannelDTO));
        String paymentUrl = this.getPaymentUrl(paymentGatewayChannelDTO);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("cPoint", litigationPaymentUrlRequest.getRequestBody().getCPoint());
        data.put("payUrl", paymentUrl);
        data.put("expire", (String)expireDate);
        return WebResponse.builder().success(Boolean.valueOf(true)).code("0000").message("\u6210\u529f").result(data).build();
    }

    public WebResponse wrapPaymentUrlInterface(StanderRequest request) throws ApisBusinessException {
        WebResponse webResponse = null;
        log.warn("\u9ad8\u9662\u83b7\u53d6\u7f34\u8d39\u94fe\u63a5\u63a5\u53e3\u540c\u6b65\u56de\u8c03\u5730\u5740\uff1a{}", (Object)this.litigationPaymentReturnBackUrl);
        log.warn("\u9ad8\u9662\u83b7\u53d6\u7f34\u8d39\u94fe\u63a5\u63a5\u53e3\u5f02\u6b65\u56de\u8c03\u5730\u5740\uff1a{}", (Object)this.litigationPaymentNotifyBackUrl);
        LitigationPaymentUrlRequest litigationPaymentUrlRequest = request.getLitigationPaymentUrlRequest();
        String orderNo = litigationPaymentUrlRequest.getRequestBody().getOrderNo();
        if (StrUtil.isEmpty((CharSequence)orderNo)) {
            webResponse = WebResponse.builder().success(Boolean.valueOf(false)).code("-1").message("\u7a7a\u53c2\u6570\u5f02\u5e38").build();
            return webResponse;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)orderNo);
        List apisBusiChannelOrderList = this.apisBusinessChannelOrderMapper.selectList((Wrapper)queryWrapper);
        ApisBusiChannelOrder apisBusiChannelOrder = null;
        apisBusiChannelOrderList = apisBusiChannelOrderList.stream().filter(item -> "04".equals(item.getStatus()) || "05".equals(item.getStatus())).collect(Collectors.toList());
        if (BeanUtil.isEmpty((Object)(apisBusiChannelOrderList.size() == 0 ? 1 : 0), (String[])new String[0])) {
            webResponse = WebResponse.builder().success(Boolean.valueOf(false)).code("-1").message("\u8ba2\u5355\u4e0d\u5b58\u5728").build();
            return webResponse;
        }
        apisBusiChannelOrder = (ApisBusiChannelOrder)apisBusiChannelOrderList.get(0);
        PaymentGatewayChannelDTO paymentGatewayChannelDTO = new PaymentGatewayChannelDTO();
        paymentGatewayChannelDTO.setPolicyRef(apisBusiChannelOrder.getPolicyNo());
        paymentGatewayChannelDTO.setTotalPremium(apisBusiChannelOrder.getPremium());
        paymentGatewayChannelDTO.setAgencyCode(apisBusiChannelOrder.getAgentCode());
        paymentGatewayChannelDTO.setPaymentMethod("alipay");
        paymentGatewayChannelDTO.setNotifyUrl(this.litigationPaymentNotifyBackUrl);
        paymentGatewayChannelDTO.setReturnUrl(this.litigationPaymentReturnBackUrl);
        boolean envFlag = this.dataSourcePassword.equals("Fchx201911") || this.dataSourcePassword.equals("Fchx202001");
        log.warn("\u73af\u5883\u5224\u65ad\u4f9d\u636e\uff1a{}", (Object)this.dataSourcePassword);
        if (envFlag && this.getRedCentOpen().booleanValue()) {
            paymentGatewayChannelDTO.setTotalPremium(BigDecimal.valueOf(0.01));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("agencyCode", paymentGatewayChannelDTO.getAgencyCode());
        map.put("notifyUrl", paymentGatewayChannelDTO.getNotifyUrl());
        map.put("paymentMethod", paymentGatewayChannelDTO.getPaymentMethod());
        map.put("policyRef", paymentGatewayChannelDTO.getPolicyRef());
        map.put("returnUrl", paymentGatewayChannelDTO.getReturnUrl());
        map.put("totalPremium", paymentGatewayChannelDTO.getTotalPremium().toString());
        String content = PaymentGatewayUtil.createLinkString(map) + this.successPaySignConstant;
        String md5 = SecureUtil.md5((String)content);
        paymentGatewayChannelDTO.setSign(md5);
        Date now = new Date();
        DateTime expireDate = DateUtil.offsetHour((Date)now, (int)PAYMENT_DELAY_TIME_SETTING);
        paymentGatewayChannelDTO.setExpireTime((Date)expireDate);
        log.warn("\u9ad8\u9662\u83b7\u53d6\u7f34\u8d39\u94fe\u63a5\u63a5\u53e3,\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)paymentGatewayChannelDTO));
        String paymentUrl = this.getPaymentUrl(paymentGatewayChannelDTO);
        if ("2".equals(litigationPaymentUrlRequest.getRequestBody().getCPoint())) {
            paymentGatewayChannelDTO.setPaymentMethod("wxMiniProg");
            boolean isMobile = PaymentServiceImpl.isMobile((PaymentGatewayChannelDTO)paymentGatewayChannelDTO);
            paymentGatewayChannelDTO.setIsMobile(Boolean.valueOf(isMobile));
            paymentGatewayChannelDTO.setAppletFlag(WX_APP_FLAG);
            PaymentGatewayServiceRequest req = this.convertParams(paymentGatewayChannelDTO, null);
            StanderRequest sr = StanderRequest.builder().paymentGateWayServiceRequest(req).build();
            PaymentGatewayResponse resp = null;
            try {
                resp = this.paymentGatewayApi.paymentNoApply(sr);
                log.warn("\u8c03\u7528\u6838\u5fc3\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)resp));
            }
            catch (Exception e) {
                log.error("\u652f\u4ed8\u7f51\u5173\uff0c\u8c03\u7528\u6838\u5fc3\u652f\u4ed8\u7533\u8bf7\u63a5\u53e3\u62a5\u9519\uff0c\u4e1a\u52a1\u53f7{}", (Object)paymentGatewayChannelDTO.getPolicyRef());
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40002.getValue(), ErrorBisCodeEnum.ERR_B40002.getKey());
            }
            if (resp != null && 0L != resp.getHead().getCode()) {
                log.error("\u652f\u4ed8\u7f51\u5173\uff0c\u8c03\u7528\u6838\u5fc3\u652f\u4ed8\u7533\u8bf7\u63a5\u53e3\u62a5\u9519\uff0c\u4e1a\u52a1\u53f7{},\u9519\u8bef\u4fe1\u606f:{}", (Object)paymentGatewayChannelDTO.getPolicyRef(), (Object)resp.getHead().getMessage());
                String message = ErrorBisCodeEnum.ERR_B40002.getValue();
                if (StrUtil.isNotEmpty((CharSequence)resp.getHead().getMessage())) {
                    message = resp.getHead().getMessage();
                }
                throw new ApisBusinessException(message, ErrorBisCodeEnum.ERR_B40002.getKey());
            }
            String payApplyNo = resp.getBody().getPayApplyNo();
            String checkNo = resp.getBody().getCheckNo();
            QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
            apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)paymentGatewayChannelDTO.getPolicyRef());
            ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusinessChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
            order.setPayNo(payApplyNo);
            this.apisBusinessChannelOrderMapper.updatePayNoById(order);
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"pay_no", (Object)payApplyNo);
            this.apisPayLogMapper.delete((Wrapper)updateWrapper);
            ApisBusiPayLog history = new ApisBusiPayLog();
            history.setAgencyCode(paymentGatewayChannelDTO.getAgencyCode());
            history.setBusinessNo(paymentGatewayChannelDTO.getPolicyRef());
            history.setPaymentMethod(paymentGatewayChannelDTO.getPaymentMethod());
            history.setTotalPremium(paymentGatewayChannelDTO.getTotalPremium());
            history.setNotifyUrl(paymentGatewayChannelDTO.getNotifyUrl());
            history.setReturnUrl(paymentGatewayChannelDTO.getReturnUrl());
            history.setSign(paymentGatewayChannelDTO.getSign());
            history.setIsMobile(String.valueOf(isMobile));
            history.setPayNo(payApplyNo);
            history.setCheckNo(checkNo);
            if (ObjectUtil.isNotEmpty((Object)paymentGatewayChannelDTO.getNotifyUrl())) {
                history.setNotifyDomain(OtherUtils.getDomainFromUrl((String)paymentGatewayChannelDTO.getNotifyUrl()));
            }
            this.apisPayLogMapper.insert((Object)history);
            if (StringUtils.isNotBlank((CharSequence)resp.getBody().getAppletData())) {
                paymentUrl = StringEscapeUtils.escapeJava((String)resp.getBody().getAppletData());
            }
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("cPoint", litigationPaymentUrlRequest.getRequestBody().getCPoint());
        data.put("payUrl", paymentUrl);
        data.put("expire", (String)expireDate);
        return WebResponse.builder().success(Boolean.valueOf(true)).code("0000").message("\u6210\u529f").result(data).build();
    }

    public void executePayment(String encryptString, HttpServletRequest req, HttpServletResponse resp) throws Exception {
        log.warn("============\u7f34\u8d39\u94fe\u63a5\u6267\u884c\u5f00\u59cb\uff1a==============");
        WebResponse webResponse = WebResponse.builder().code("-1").success(Boolean.valueOf(false)).message("\u5931\u8d25").build();
        String decodeStr = HexUtil.decodeHexStr((String)encryptString);
        PaymentGatewayChannelDTO channelDTO = (PaymentGatewayChannelDTO)JSON.parseObject((String)decodeStr, PaymentGatewayChannelDTO.class);
        Date expireTime = channelDTO.getExpireTime();
        Date now = new Date();
        if (expireTime != null && now.after(expireTime)) {
            resp.setCharacterEncoding("UTF-8");
            PrintWriter out = resp.getWriter();
            webResponse.setMessage("\u652f\u4ed8\u65f6\u95f4\u5df2\u8fc7\u671f");
            out.print(JSON.toJSONString((Object)webResponse));
        }
        this.paymentGateway(channelDTO, req, resp);
    }

    public static String getOldSign(Map params, String key) {
        log.warn("================================================");
        log.warn("======sign:{}", (Object)key);
        log.warn("================================================");
        Map map = PaymentGatewayUtil.paraFilter((Map)params);
        String contentStr = PaymentGatewayUtil.createLinkString((Map)map);
        String sign = PaymentGatewayUtil.sign((String)contentStr, (String)key, (String)"utf-8");
        return sign;
    }

    public static String getPaymentCode(PaymentGatewayChannelDTO channelDTO) {
        String paymentCode;
        boolean isMobile = channelDTO.getIsMobile();
        String paymentMethod = channelDTO.getPaymentMethod();
        log.warn("\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f\u4ee3\u7801\uff0cisMobile\uff1a{}", (Object)isMobile);
        log.warn("\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f\u4ee3\u7801\uff0cpaymentMethod\uff1a{}", (Object)paymentMethod);
        if (isMobile) {
            paymentCode = (String)mobilePaymentCodeMap.get(paymentMethod.toLowerCase());
            log.warn("\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f\u4ee3\u7801\uff0cpaymentCode\uff1a{}", (Object)paymentCode);
        } else {
            paymentCode = (String)pcPaymentCodeMap.get(paymentMethod.toLowerCase());
            log.warn("\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f\u4ee3\u7801\uff0cpaymentCode\uff1a{}", (Object)paymentCode);
        }
        log.warn("\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f\u4ee3\u7801\uff0c\u6700\u7ec8paymentCode\uff1a{}", (Object)paymentCode);
        return paymentCode;
    }

    public static Boolean isMobile(PaymentGatewayChannelDTO channelDTO) {
        String paymentMethod = channelDTO.getPaymentMethod();
        if (StrUtil.isEmpty((CharSequence)paymentMethod)) {
            paymentMethod = "";
        }
        Boolean isMobile = (Boolean)isMobileMap.get(paymentMethod.toLowerCase());
        log.warn("\u652f\u4ed8\u7f51\u5173,\u5224\u65ad\u652f\u4ed8\u65b9\u5f0f\u662f\u5426\u662f\u624b\u673a\u7aef\uff1a{}", (Object)isMobile);
        if (BeanUtil.isEmpty((Object)isMobile, (String[])new String[0])) {
            isMobile = true;
        }
        log.warn("\u652f\u4ed8\u7f51\u5173,\u6700\u7ec8\u5224\u65ad\u652f\u4ed8\u65b9\u5f0f\u662f\u5426\u662f\u624b\u673a\u7aef\uff1a{}", (Object)isMobile);
        return isMobile;
    }

    public boolean repeatPayment(PaymentGatewayChannelDTO channelDTO, HttpServletResponse response) throws Exception {
        Boolean payFlag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_no", (Object)channelDTO.getPolicyRef());
        ApisBusiPayLog historyApisBusiPayLog = (ApisBusiPayLog)this.apisPayLogMapper.selectOne((Wrapper)queryWrapper);
        if (BeanUtil.isNotEmpty((Object)historyApisBusiPayLog, (String[])new String[0]) && StrUtil.isNotEmpty((CharSequence)historyApisBusiPayLog.getCheckNo()) && StrUtil.isNotEmpty((CharSequence)historyApisBusiPayLog.getPayNo())) {
            log.warn("\u652f\u4ed8\u7f51\u5173\uff0c\u91cd\u590d\u652f\u4ed8\u6d41\u7a0b\uff0c\u67e5\u8be2\u652f\u4ed8\u65e5\u5fd7\u652f\u4ed8\u5355\u53f7\uff1a{},\u652f\u4ed8\u54cd\u5e94\u9a8c\u7b7e\uff1a{},\u624b\u673a\u7aef\uff1a{}", new Object[]{historyApisBusiPayLog.getBusinessNo(), historyApisBusiPayLog.getCheckNo(), historyApisBusiPayLog.getIsMobile()});
            String checkNo = historyApisBusiPayLog.getCheckNo();
            String payNo = historyApisBusiPayLog.getPayNo();
            String isMobile = historyApisBusiPayLog.getIsMobile();
            this.redirect(checkNo, payNo, null, null, Boolean.parseBoolean(isMobile), response);
            payFlag = true;
        }
        return payFlag;
    }

    public boolean repeatBatchPayment(PaymentGatewayChannelDTO channelDTO, HttpServletResponse response) throws Exception {
        Boolean payFlag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)channelDTO.getOrderNo());
        queryWrapper.eq((Object)"business_no", (Object)"BatchPayment");
        ApisBusiPayLog historyApisBusiPayLog = (ApisBusiPayLog)this.apisPayLogMapper.selectOne((Wrapper)queryWrapper);
        if (BeanUtil.isNotEmpty((Object)historyApisBusiPayLog, (String[])new String[0]) && StrUtil.isNotEmpty((CharSequence)historyApisBusiPayLog.getCheckNo()) && StrUtil.isNotEmpty((CharSequence)historyApisBusiPayLog.getPayNo())) {
            log.warn("\u652f\u4ed8\u7f51\u5173\uff0c\u91cd\u590d\u652f\u4ed8\u6d41\u7a0b\uff0c\u67e5\u8be2\u652f\u4ed8\u65e5\u5fd7\u652f\u4ed8\u5355\u53f7\uff1a{},\u652f\u4ed8\u54cd\u5e94\u9a8c\u7b7e\uff1a{},\u624b\u673a\u7aef\uff1a{}", new Object[]{historyApisBusiPayLog.getBusinessNo(), historyApisBusiPayLog.getCheckNo(), historyApisBusiPayLog.getIsMobile()});
            String checkNo = historyApisBusiPayLog.getCheckNo();
            String payNo = historyApisBusiPayLog.getPayNo();
            String isMobile = historyApisBusiPayLog.getIsMobile();
            this.redirect(checkNo, payNo, null, null, Boolean.parseBoolean(isMobile), response);
            payFlag = true;
        }
        return payFlag;
    }

    public static String getIdentifyType(String type) {
        if (StrUtil.isEmpty((CharSequence)type)) {
            return null;
        }
        String identifyType = (String)identifytypeMap.get(type);
        if (identifyType == null) {
            identifyType = "99";
        }
        return identifyType;
    }

    public void validateSign(PaymentGatewayChannelDTO channelDTO) throws ApisBusinessException {
        String sign = channelDTO.getSign();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("agencyCode", channelDTO.getAgencyCode());
        map.put("notifyUrl", channelDTO.getNotifyUrl());
        map.put("paymentMethod", channelDTO.getPaymentMethod());
        map.put("policyRef", channelDTO.getPolicyRef());
        map.put("returnUrl", channelDTO.getReturnUrl());
        map.put("totalPremium", channelDTO.getTotalPremium().toString());
        String content = PaymentGatewayUtil.createLinkString(map) + this.successPaySignConstant;
        String md5 = SecureUtil.md5((String)content);
        log.warn("validateSign\u65b9\u6cd5\uff0cmd5\uff1a{}", (Object)md5);
        if (StrUtil.isNotEmpty((CharSequence)sign) && sign.equals(md5)) {
            return;
        }
        log.warn("\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u539f\u59cb\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)channelDTO));
        throw new ApisBusinessException("\u652f\u4ed8\u7f51\u5173\u8bf7\u6c42\u5165\u53c2sign\uff0cAPIS\u6821\u9a8c\u4e0d\u901a\u8fc7", ErrorBisCodeEnum.ERR_B40005.getKey());
    }

    public Boolean getValidateSignFlag(PaymentGatewayChannelDTO channelDTO) {
        Boolean flag = false;
        try {
            String agencyCode = channelDTO.getAgencyCode();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"config_code", (Object)PAYMENT_VALIDATE_SIGN_FLAG);
            ApisChannelConfigs apisChannelConfigs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
            if (apisChannelConfigs != null && "1".equals(apisChannelConfigs.getConfigValue()) && apisChannelConfigs.getRemark() != null && !apisChannelConfigs.getRemark().contains(agencyCode)) {
                flag = true;
            }
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public void validateInstallment(PaymentGatewayChannelDTO channelDTO) throws ApisBusinessException {
        String paymentMethod = channelDTO.getPaymentMethod();
        String entrustPayFlag = channelDTO.getEntrustPayFlag();
        if ("1".equals(entrustPayFlag) && !paymentMethod.contains("wx")) {
            throw new ApisBusinessException("\u652f\u4ed8\u7f51\u5173\u6821\u9a8c\u652f\u4ed8\u65b9\u5f0f\uff0c\u5206\u671f\u4ed8\u6b3e\u53ea\u80fd\u4f7f\u7528\u5fae\u4fe1\u652f\u4ed8\u6216\u5fae\u4fe1\u626b\u7801\u652f\u4ed8", ErrorBisCodeEnum.ERR_B40005.getKey());
        }
    }

    public void validateEndorseNos(String[] policyRefArr) throws ApisBusinessException {
        StringBuilder notEndorseNoStr = new StringBuilder();
        for (String endorseNo : policyRefArr) {
            QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
            apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)endorseNo);
            ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusinessChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
            if (null == order || null == order.getPolicyNo()) continue;
            notEndorseNoStr.append(order.getPolicyNo());
            notEndorseNoStr.append(",");
        }
        if (notEndorseNoStr.length() > 0) {
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40006.getValue().replaceFirst("##", notEndorseNoStr.substring(0, notEndorseNoStr.length() - 1)), ErrorBisCodeEnum.ERR_B40006.getKey());
        }
    }

    public void failReturnCallBack(PaymentGatewayChannelDTO channelDTO, ValidationRequestParamsResult validResult, HttpServletResponse response) throws Exception {
        List policyInfoList;
        String tradeStatus = validResult.getCode();
        String paymentMethod = channelDTO.getPaymentMethod();
        String msg = validResult.getMessage();
        String returnUrl = channelDTO.getReturnUrl();
        String agencyCode = channelDTO.getAgencyCode();
        String policyRef = channelDTO.getPolicyRef();
        String notifyUrl = channelDTO.getNotifyUrl();
        String totalPremium = channelDTO.getTotalPremium().toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tradeStatus", tradeStatus);
        params.put("paymentMethod", paymentMethod);
        params.put("msg", msg);
        params.put("returnUrl", returnUrl);
        params.put("agencyCode", agencyCode);
        params.put("policyRef", policyRef);
        params.put("notifyUrl", notifyUrl);
        params.put("totalPremium", totalPremium);
        Map filterMap = PaymentGatewayUtil.paraFilter(params);
        String filterStr = PaymentGatewayUtil.createLinkString((Map)filterMap);
        String sign = PaymentGatewayUtil.sign((String)filterStr, (String)this.successPaySignConstant, (String)"utf-8");
        params.put("sign", sign);
        response.setContentType("text/html; charset=UTF-8");
        StringBuffer sb = new StringBuffer();
        sb.append("<form id=\"returnForm\" method=\"post\" action=\"");
        sb.append((String)params.get("returnUrl"));
        sb.append("\">");
        for (String name : params.keySet()) {
            String value = (String)params.get(name);
            if (!StrUtil.isNotEmpty((CharSequence)value)) continue;
            sb.append("<input type=\"hidden\" name=\"");
            sb.append(name);
            sb.append("\" value=\"");
            sb.append(value);
            sb.append("\">");
        }
        if (StrUtil.isNotBlank((CharSequence)channelDTO.getOrderNo())) {
            sb.append("<input type=\"hidden\" name=\"orderNo\" value=\"");
            sb.append(channelDTO.getOrderNo());
            sb.append("\">");
        }
        if ("BatchPayment".equalsIgnoreCase(policyRef) && ObjectUtil.isNotEmpty((Object)(policyInfoList = channelDTO.getPolicyList()))) {
            int ind = 0;
            for (PolicyInfoDTO policyInfo : policyInfoList) {
                sb.append("<input name=\"").append(String.format(this.formPolicyRefName, ind)).append("\" type=\"hidden\" value=\"").append(policyInfo.getPolicyRef()).append("\"/>");
                sb.append("<input name=\"").append(String.format(this.formPreimumName, ind)).append("\" type=\"hidden\" value=\"").append(policyInfo.getPremium()).append("\"/>");
                ++ind;
            }
        }
        sb.append("</form><script>document.getElementById('returnForm').submit();</script>");
        log.warn("\u652f\u4ed8\u5f02\u5e38\u65f6\uff0c\u9519\u8bef\u56de\u8c03\u9875\u9762\uff1a{}", (Object)sb.toString());
        PrintWriter out = response.getWriter();
        out.println(sb.toString());
        out.flush();
        out.close();
    }

    public Boolean getRedCentOpen() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)PAYMENT_RED_CENT_FLAG);
        ApisChannelConfigs configs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
        if (configs == null) {
            return false;
        }
        if ("1".equals(configs.getConfigValue())) {
            return true;
        }
        return false;
    }

    private StanderResponse endorseProcess(String applyNo) {
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            return null;
        }
        StanderRequest request = StanderRequest.builder().build();
        EndorseQueryServiceRequest endorseQueryServiceRequest = EndorseQueryServiceRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(EndorseQueryRequestDTO.builder().applyNo(applyNo).build()).build();
        request.setEndorseQueryServiceRequest(endorseQueryServiceRequest);
        try {
            StanderResponse response = this.coreCorrectApi.correctQuery(request);
            if (ObjectUtil.isEmpty((Object)response) || ObjectUtil.isEmpty((Object)response.getEndorseQueryResponse()) || ObjectUtil.isEmpty((Object)response.getEndorseQueryResponse().getResponseBody()) || ObjectUtil.isEmpty((Object)response.getEndorseQueryResponse().getResponseBody().getMain())) {
                log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u6279\u5355\u4fe1\u606f\u5f02\u5e38,\u6279\u5355\u7533\u8bf7\u53f7\uff1a{}", (Object)applyNo);
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40004.getValue(), ErrorBisCodeEnum.ERR_B40004.getKey());
            }
            return response;
        }
        catch (Exception e) {
            log.error("\u6279\u5355\u7533\u8bf7\u53f7\uff1a{}\uff0c\u8c03\u7528\u6279\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3 \u62a5\u9519\uff1a", (Object)applyNo, (Object)e);
            return null;
        }
    }

    private void addToTianYuanPolicyCallbackTask(ApisBusiChannelOrder order, ApisBusiPayLog apisBusiPayLog) {
        if (this.dataCompletionUtil.isTianYuanAgency(order.getRequestUser(), order.getChannelCode())) {
            log.warn("\u5929\u6e90\u6e20\u9053\uff0c\u6dfb\u52a0\u4fdd\u5355\u56de\u4f20\u5b9a\u65f6\u4efb\u52a1\u3002\u4fdd\u5355\u53f7\uff1a{}\uff0c\u8bf7\u6c42\u7528\u6237\uff1a{}", (Object)order.getPolicyNo(), (Object)order.getRequestUser());
            ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
            apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.PUSH_POLICY_INFO_TO_TIAN_YUAN_AGENCY_AFTER_PAYMENT.getValue());
            apisBusiTaskLog.setBusinessKey(order.getPolicyNo());
            apisBusiTaskLog.setPushTargetUrl(this.tianYuanPolicyInfoPushUrl);
            apisBusiTaskLog.setPushStep(Integer.valueOf(0));
            apisBusiTaskLog.setPushStatus("0");
            StringBuilder sb = new StringBuilder();
            sb.append(order.getPolicyNo()).append(",").append(order.getRequestUser());
            apisBusiTaskLog.setRemark(sb.toString());
            apisBusiTaskLog.setRelatedId(apisBusiPayLog.getId());
            this.apisBusiTaskLogService.saveTaskInfo(apisBusiTaskLog);
            log.warn("\u5929\u6e90\u6e20\u9053\uff0c\u6dfb\u52a0\u7535\u5b50\u4fdd\u5355\u4e0b\u8f7d\u5730\u5740\u56de\u4f20\u5b9a\u65f6\u4efb\u52a1\u3002\u4fdd\u5355\u53f7\uff1a{}\uff0c\u8bf7\u6c42\u7528\u6237\uff1a{}", (Object)order.getPolicyNo(), (Object)order.getRequestUser());
            ApisBusiTaskLog taskLog = new ApisBusiTaskLog();
            taskLog.setPushType(ApisAutoTaskConstantsEnum.PUSH_POLICY_DOWNLOAD_URL_TO_TIAN_YUAN_AGENCY_AFTER_PAYMENT.getValue());
            taskLog.setBusinessKey(order.getPolicyNo());
            taskLog.setPushTargetUrl(this.tianYuanDownloadUrlPushUrl);
            taskLog.setPushStep(Integer.valueOf(0));
            taskLog.setPushStatus("0");
            StringBuilder sb1 = new StringBuilder();
            sb1.append(order.getPolicyNo()).append(",").append(order.getRequestUser());
            taskLog.setRemark(sb1.toString());
            taskLog.setRelatedId(apisBusiPayLog.getId());
            this.apisBusiTaskLogService.saveTaskInfo(taskLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object signContractNotify(SignContractNotifyRequest signContractNotifyRequest, HttpServletRequest request, HttpServletResponse response) {
        NoticeDetailDTO noticeDetailDTO = (NoticeDetailDTO)signContractNotifyRequest.getBody().getNoticeDetailDTO().get(0);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_code", (Object)noticeDetailDTO.getContractCode());
        ApisBusiPayContract apisBusiPayContract = (ApisBusiPayContract)this.apisBusiPayContractService.getOne((Wrapper)queryWrapper);
        if (ObjectUtil.isEmpty((Object)apisBusiPayContract)) {
            return null;
        }
        List apisBusiTaskLogs = this.apisBusiTaskLogService.getTaskInfo(ApisAutoTaskConstantsEnum.SIGN_CONTRACT_NOTIFY_TO_AGENT.getKey(), apisBusiPayContract.getContractCode());
        ApisBusiTaskLog taskLog = new ApisBusiTaskLog();
        if (ObjectUtil.isNotEmpty((Object)apisBusiTaskLogs)) {
            taskLog = (ApisBusiTaskLog)apisBusiTaskLogs.get(0);
            taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
        } else {
            taskLog = new ApisBusiTaskLog();
            taskLog.setBusinessKey(noticeDetailDTO.getContractCode());
            taskLog.setPushType(ApisAutoTaskConstantsEnum.SIGN_CONTRACT_NOTIFY_TO_AGENT.getKey());
            taskLog.setPushStep(Integer.valueOf(1));
            taskLog.setPushTargetUrl(apisBusiPayContract.getContractNotifyUrl());
        }
        apisBusiPayContract.setContractMethod(noticeDetailDTO.getContractMethod());
        apisBusiPayContract.setContractStatus(noticeDetailDTO.getStatus());
        apisBusiPayContract.setContractTime(DateUtil.toLocalDateTime((Date)DateUtil.parse((CharSequence)noticeDetailDTO.getContractTime(), (String)"yyyyMMddHHmmss")));
        apisBusiPayContract.setContractCode(noticeDetailDTO.getContractCode());
        SignContractNotifyToAgentDTO signContractNotifyToAgent = SignContractNotifyToAgentDTO.builder().contractMethod(noticeDetailDTO.getContractMethod()).contractStatus(noticeDetailDTO.getStatus()).contractTime((Date)DateUtil.parse((CharSequence)noticeDetailDTO.getContractTime(), (String)"yyyyMMddHHmmss")).agencyCode(apisBusiPayContract.getAgencyCode()).policyRef(noticeDetailDTO.getPolicyNo()).build();
        taskLog.setPushContent(JSON.toJSONString((Object)signContractNotifyToAgent));
        FormBody.Builder builder = new FormBody.Builder();
        FormBody requestBody = builder.add("policyRef", apisBusiPayContract.getBusinessNo()).add("agencyCode", apisBusiPayContract.getAgencyCode()).add("contractMethod", noticeDetailDTO.getContractMethod()).add("contractStatus", noticeDetailDTO.getStatus()).add("contractTime", noticeDetailDTO.getContractTime()).build();
        try {
            OkHttpClient client = OkHttpUtils.getSslHttpsClient();
            Request req = new Request.Builder().url(apisBusiPayContract.getContractNotifyUrl()).post((okhttp3.RequestBody)requestBody).build();
            log.warn("\u652f\u4ed8\u7b7e\u7ea6\u5f02\u6b65\u56de\u8c03\u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)signContractNotifyToAgent));
            Response resp = client.newCall(req).execute();
            log.warn("\u652f\u4ed8\u7b7e\u7ea6\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\uff1a{}", (Object)resp.toString());
            taskLog.setPushStatus(resp.isSuccessful() ? "1" : "4");
            apisBusiPayContract.setContractTradeStatus(resp.isSuccessful() ? "SUCCESS" : "FAIL");
        }
        catch (IOException e) {
            log.error("\u7b7e\u7ea6\u7ed3\u679c\u901a\u77e5\u6e20\u9053\u4fdd\u9519\uff0c\u4e1a\u52a1\u53f7\uff1a{},{}", (Object)apisBusiPayContract.getBusinessNo(), (Object)e);
            taskLog.setPushStatus("4");
            apisBusiPayContract.setContractTradeStatus("FAIL");
        }
        finally {
            taskLog.setLastPushTime(LocalDateTime.now());
            this.apisBusiTaskLogService.saveOrUpdate((Object)taskLog);
            this.apisBusiPayContractService.updateById((Object)apisBusiPayContract);
        }
        return this.returnResult(apisBusiPayContract.getBusinessNo(), "\u901a\u77e5\u6210\u529f");
    }

    public static void main(String[] args) {
        String s = "{\"agencyCode\":\"AC600001\",\"deleted\":0,\"isMobile\":false,\"notifyUrl\":\"http://47.92.107.201:8080/pay/jdal/payCallback\",\"paymentMethod\":\"wxpay\",\"policyRef\":\"P4400C02007000200030578\",\"returnUrl\":\"http://pre.junbaob2b.com/dist/#/productdetailhealthfromyy/JDAL101312010100156?orderNo=\",\"sign\":\"8b7e76d6855b2aa2228789c02fb2ad01\",\"totalPremium\":275.00}";
        s = "{\n\t\"agencyCode\": \"AC600001\",\n\t\"notifyUrl\": \"http://ccib.top:8860/api/songyazhou/NotifyUrl\",\n\t\"paymentMethod\": \"wxpay\",\n\t\"policyRef\": \"BatchPayment\",\n\t\"returnUrl\": \"http://ccib.top:8860/api/songyazhou/NotifyUrl\",\n\t\"sign\": \"a54547296a474cb7610d6316a2850c93\",\n\t\"totalPremium\": 2638.0,\n\t\"orderNo\": \"ON20210602172712378920001\",\n\t\"policyList\": [{\n\t\t\"policyRef\": \"P4400C02107000200182677\",\n\t\t\"premium\": 1319,\n\t\t\"insuredInfos\": [{\n\t\t\t\"name\": \"\u963f\u8428\u6cd5\",\n\t\t\t\"identifyType\": \"10\",\n\t\t\t\"identifyNo\": \"E02938832\"\n\t\t}]\n\t},{\n\t\t\"policyRef\": \"P4400C02107000200182678\",\n\t\t\"premium\": 1319,\n\t\t\"insuredInfos\": [{\n\t\t\t\"name\": \"\u6c99\u5f25\",\n\t\t\t\"identifyType\": \"10\",\n\t\t\t\"identifyNo\": \"E23894735\"\n\t\t}]\n\t}]\n}";
        PaymentGatewayChannelDTO channelDTO = (PaymentGatewayChannelDTO)JSON.parseObject((String)s, PaymentGatewayChannelDTO.class);
        String sign = channelDTO.getSign();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("agencyCode", channelDTO.getAgencyCode());
        map.put("notifyUrl", channelDTO.getNotifyUrl());
        map.put("paymentMethod", channelDTO.getPaymentMethod());
        map.put("policyRef", channelDTO.getPolicyRef());
        map.put("returnUrl", channelDTO.getReturnUrl());
        map.put("totalPremium", channelDTO.getTotalPremium().toString());
        String content = PaymentGatewayUtil.createLinkString(map) + "828f7f755bd7de957175f8e8b5301ccc";
        String md5 = SecureUtil.md5((String)content);
        String url = "http://127.0.0.1/paymentgateway_tls_test/payment";
        OkHttpClient client = OkHttpUtils.getSslHttpsClient();
        FormBody.Builder builder = new FormBody.Builder();
        if (ObjectUtil.isNotEmpty((Object)channelDTO.getPolicyList())) {
            int ind = 0;
            for (PolicyInfoDTO policyInfoDTO : channelDTO.getPolicyList()) {
                builder.add("policyList[" + ind + "].policyRef", policyInfoDTO.getPolicyRef());
                builder.add("policyList[" + ind + "].premium", policyInfoDTO.getPremium().toString());
                if (ObjectUtil.isNotEmpty((Object)policyInfoDTO.getInsuredInfos())) {
                    int insInd = 0;
                    for (InsuredInfoDTO insuredInfoDTO : policyInfoDTO.getInsuredInfos()) {
                        builder.add("policyList[" + ind + "].insuredInfos[" + insInd + "].name", insuredInfoDTO.getName());
                        builder.add("policyList[" + ind + "].insuredInfos[" + insInd + "].identifyType", insuredInfoDTO.getIdentifyType());
                        builder.add("policyList[" + ind + "].insuredInfos[" + insInd + "].identifyNo", insuredInfoDTO.getIdentifyNo());
                        ++insInd;
                    }
                }
                ++ind;
            }
        }
        if (ObjectUtil.isNotEmpty((Object)channelDTO.getOrderNo())) {
            builder.add("orderNo", channelDTO.getOrderNo());
        }
        FormBody requestBody = builder.add("policyRef", channelDTO.getPolicyRef()).add("agencyCode", channelDTO.getAgencyCode()).add("totalPremium", channelDTO.getTotalPremium().toString()).add("paymentMethod", channelDTO.getPaymentMethod()).add("notifyUrl", channelDTO.getNotifyUrl()).add("returnUrl", channelDTO.getReturnUrl()).add("sign", "91bc6fee462a730dcbb90032f862c0f8").build();
        Request req = new Request.Builder().url(url).post((okhttp3.RequestBody)requestBody).build();
        try {
            Response resp = client.newCall(req).execute();
            log.warn(resp.body().string());
        }
        catch (IOException e) {
            log.error("error: ", (Throwable)e);
        }
    }

    static {
        mobilePaymentCodeMap.put("wxpay", "W03");
        mobilePaymentCodeMap.put("wxpayh5", "W04");
        mobilePaymentCodeMap.put("wapalipay", "A02");
        mobilePaymentCodeMap.put("99bill", "K02");
        mobilePaymentCodeMap.put("wxminiprog", "W05");
        mobilePaymentCodeMap.put("jdpayh501", "JD01");
        mobilePaymentCodeMap.put("envmobile", null);
        pcPaymentCodeMap.put("alipay", "A01");
        pcPaymentCodeMap.put("wxpaypc", "W02");
        pcPaymentCodeMap.put("jdpaypc02", "JD02");
        pcPaymentCodeMap.put("envpc", null);
        isMobileMap.put("jdpayh501", true);
        isMobileMap.put("jdpaypc02", false);
        isMobileMap.put("wxpay", true);
        isMobileMap.put("wxpayh5", true);
        isMobileMap.put("wapalipay", true);
        isMobileMap.put("alipay", false);
        isMobileMap.put("99bill", true);
        isMobileMap.put("wxpaypc", false);
        isMobileMap.put("wxminiprog", true);
        isMobileMap.put("envpc", false);
        isMobileMap.put("envmobile", true);
        isMobileMap.put("definepc", false);
        peyMethodMap.put("W03", "wxpay");
        peyMethodMap.put("W04", "wxpayh5");
        peyMethodMap.put("A02", "wapalipay");
        peyMethodMap.put("K02", "99bill");
        peyMethodMap.put("W05", "wxminiprog");
        peyMethodMap.put("JD01", "jdpayh501");
        peyMethodMap.put("A01", "alipay");
        peyMethodMap.put("W02", "wxpaypc");
        peyMethodMap.put("JD02", "jdpaypc02");
        identifytypeMap = new HashMap();
        identifytypeMap.put("1", "01");
        identifytypeMap.put("2", "03");
        identifytypeMap.put("3", "99");
        identifytypeMap.put("01", "01");
        identifytypeMap.put("03", "03");
        identifytypeMap.put("05", "05");
        identifytypeMap.put("99", "99");
    }
}

