/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.RiskManagementService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.WarnSendService;
import com.jdaz.sinosoftgz.apis.log.api.ApisLog;
import com.jdaz.sinosoftgz.coreapi.common.service.impl.HttpRequestServiceImpl;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RiskManagementServiceImpl
implements RiskManagementService {
    @Autowired
    WarnSendService warnSendService;
    public static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestServiceImpl.class);
    static OkHttpClient client = new OkHttpClient.Builder().connectTimeout(4L, TimeUnit.SECONDS).readTimeout(4L, TimeUnit.SECONDS).build();

    public <T> T riskManagementSend(String url, Object body, Class<T> respType) {
        block9: {
            Date startDate = new Date();
            byte[] requestBodyBytes = new byte[]{};
            byte[] responseBodyBytes = new byte[]{};
            Boolean errorFlag = false;
            String errorMessage = null;
            try {
                Object object;
                String bodyStr = JSON.toJSONString((Object)body);
                RequestBody requestBody = RequestBody.create((MediaType)JSON_TYPE, (String)bodyStr);
                requestBodyBytes = bodyStr.getBytes();
                Request request = new Request.Builder().url(url).post(requestBody).addHeader("Connection", "close").build();
                Call call = client.newCall(request);
                try {
                    Object resp;
                    Response response = call.execute();
                    String responseBodyStr = response.body().string();
                    if (responseBodyStr.contains("<html>")) {
                        logger.warn("\u98ce\u63a7\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u54cd\u5e94\uff1ahtml\uff0cresponse = {}", (Object)response.toString());
                        String uid = UUID.randomUUID().toString().replaceAll("-", "");
                        logger.warn("\u98ce\u63a7\u5f02\u5e38UUID\u4e3a\uff1a{}", (Object)uid);
                        this.warnSendService.convertSaveWarnSendEmail("/COMM_RULE_001", null, "-2", "\u98ce\u63a7\u8fd4\u56de\u7684\u662f\u4e00\u4e2a\u9875\u9762", "\u98ce\u63a7\u8c03\u7528\u5f02\u5e38" + uid);
                    }
                    responseBodyBytes = responseBodyStr.getBytes();
                    logger.warn("riskManagementSend\u8c03\u7528\u76f8\u5e94\u62a5\u6587\uff1a{}", (Object)responseBodyStr);
                    object = resp = JSON.parseObject((String)responseBodyStr, respType);
                }
                catch (IOException e) {
                    try {
                        logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    catch (Exception e2) {
                        logger.error("=============call api error :{}", (Object)url);
                        errorFlag = true;
                        errorMessage = e2.getMessage();
                        throw new RuntimeException(e2);
                    }
                    logger.warn("\u98ce\u63a7\u63a5\u53e3\u8c03\u7528\u7528\u65f6:{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
                    this.sendLog(startDate, requestBodyBytes, responseBodyBytes, errorFlag, errorMessage);
                    break block9;
                }
                return (T)object;
            }
            finally {
                logger.warn("\u98ce\u63a7\u63a5\u53e3\u8c03\u7528\u7528\u65f6:{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
                this.sendLog(startDate, requestBodyBytes, responseBodyBytes, errorFlag, errorMessage);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLog(Date startDate, byte[] requestBodyBytes, byte[] responseBodyBytes, Boolean errorFlag, String errorMessage) {
        try {
            String uid = null;
            if (ApisLog.getRequest() != null) {
                uid = ApisLog.getRequest().toString();
            }
            if (uid == null) {
                uid = UUID.randomUUID().toString().replaceAll("-", "");
            }
            ApisLog.create((String)uid).setContent(new String(requestBodyBytes, "utf-8")).setBusinessNode("api:call:in").setStartTime(startDate).setLevel("info").sendAndEnd();
            ApisLog.create((String)uid).setContent(new String(responseBodyBytes, "utf-8")).setBusinessNode("api:call:out").setStartTime(new Date()).setLevel("info").sendAndEnd();
            if (errorFlag.booleanValue()) {
                ApisLog.create((String)uid).setContent(errorMessage).setBusinessNode("api:call:error").setStartTime(new Date()).setLevel("error").sendAndEnd();
            }
        }
        catch (Exception e) {
            logger.error("\u8bb0\u5f55\u65e5\u5fd7\u65f6\u51fa\u9519:" + e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

