/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CoverageDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemFamilyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.JdUserVerify.JdUserVerifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.JdUserVerify.JdUserVerifyResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.UwInfoQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.BeneficiaryDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.UwInfoQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationClauseKindFactoryMapper;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.GeneralRegxs;
import com.jdaz.sinosoftgz.apis.constants.ApisCommonConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import sinosoftgz.utils.data.DateUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AsyncQuotePriceValidate {
    private static Logger log = LoggerFactory.getLogger(AsyncQuotePriceValidate.class);
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    ApisPfpRationClauseKindFactoryMapper apisPfpRationClauseKindFactoryMapper;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    private static String[] PLAN_YEAR_ARRAY = new String[]{"4", "7", "8", "10", "11"};
    @Value(value="${system.backSignSwitch}")
    private String backSignSwitch;

    public void validateRequest(StanderRequest standerRequest) throws ApisBusinessException {
        String planCode = ((ItemMainDTO)standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsCode();
        ApisPfpRationMain apisPfpRationMain = this.dataCompletionUtil.getApisPfpRationMainInfo(planCode, "2");
        this.commonVerify(standerRequest, apisPfpRationMain);
        if (RiskCodeEnum.getType((String)apisPfpRationMain.getProductCode()) == 1) {
            this.verifyAccidentHealth(standerRequest, apisPfpRationMain);
        } else if (RiskCodeEnum.getType((String)apisPfpRationMain.getProductCode()) == 2) {
            this.verifyHomeEstate(standerRequest, apisPfpRationMain);
        } else if (RiskCodeEnum.getType((String)apisPfpRationMain.getProductCode()) == 3) {
            this.verifyLiab(standerRequest, apisPfpRationMain);
        }
    }

    private void commonVerify(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        this.commonVerifyNull(standerRequest, apisPfpRationMain);
        this.commonVerifyFormat(standerRequest, apisPfpRationMain);
        this.commonVerifyProduct(standerRequest, apisPfpRationMain);
    }

    public void verifyHomeEstate(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        this.validPetData(standerRequest, apisPfpRationMain);
        this.verifyHomeEstateNull(standerRequest, apisPfpRationMain);
        this.verifyHomeEstateFormat(standerRequest, apisPfpRationMain);
    }

    private void verifyLiab(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        this.verifyLiabNull(standerRequest, apisPfpRationMain);
        this.verifyLiabRule(standerRequest, apisPfpRationMain);
    }

    private void verifyLiabRule(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        if ("01".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) && quotePriceDTO.getRiskInfo().getSiteArea().compareTo(new BigDecimal(10000)) == 1) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10610.getValue(), ChannelErrorCodeEnum.ERR_C10610.getKey());
        }
        if ("02".equals(quotePriceDTO.getRiskInfo().getUnderwritingType())) {
            if (quotePriceDTO.getRiskInfo().getSiteArea().compareTo(new BigDecimal(10000)) == 1) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10610.getValue(), ChannelErrorCodeEnum.ERR_C10610.getKey());
            }
            if (Integer.parseInt(quotePriceDTO.getRiskInfo().getPeopleNumber()) > 2000) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10611.getValue(), ChannelErrorCodeEnum.ERR_C10611.getKey());
            }
            long days = DateUtils.getDays((String)DateUtils.dateToStr((Date)quotePriceDTO.getMain().getEndDate()), (String)DateUtils.dateToStr((Date)quotePriceDTO.getMain().getStartDate()));
            SimpleDateFormat formatter = new SimpleDateFormat("HHmmss");
            Integer endHm = Integer.parseInt(formatter.format(quotePriceDTO.getMain().getEndDate()));
            if (endHm >= 235900) {
                ++days;
            }
            if (days > 30L) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10612.getValue(), ChannelErrorCodeEnum.ERR_C10612.getKey());
            }
        }
        if ("03".equals(quotePriceDTO.getRiskInfo().getUnderwritingType())) {
            if (quotePriceDTO.getRiskInfo().getPoolArea().compareTo(new BigDecimal(1500)) == 1) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10613.getValue(), ChannelErrorCodeEnum.ERR_C10613.getKey());
            }
            if (quotePriceDTO.getRiskInfo().getWaterDepth().compareTo(new BigDecimal(2)) == 1) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10614.getValue(), ChannelErrorCodeEnum.ERR_C10614.getKey());
            }
        }
    }

    private void verifyLiabNull(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        if (StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getUnderwritingType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "UnderwritingType"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getIsIndoor())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "IsIndoor"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if ("01".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) && StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getVenueType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "IsIndoor"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (("01".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) || "02".equals(quotePriceDTO.getRiskInfo().getUnderwritingType())) && StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getPeopleNumber())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "PeopleNumber"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (("01".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) || "02".equals(quotePriceDTO.getRiskInfo().getUnderwritingType())) && ObjectUtil.isEmpty((Object)quotePriceDTO.getRiskInfo().getSiteArea())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "SiteArea"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if ("02".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) && StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getActivityType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "PeopleNumber"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if ("03".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) && StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getSwimmingPoolType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "SwimmingPoolType"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if ("03".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) && ObjectUtil.isEmpty((Object)quotePriceDTO.getRiskInfo().getPoolArea())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "PoolArea"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if ("03".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) && ObjectUtil.isEmpty((Object)quotePriceDTO.getRiskInfo().getWaterDepth())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "WaterDepth"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)quotePriceDTO.getRiskInfo().getEachAndTotalLimit())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "EachAndTotalLimit"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)quotePriceDTO.getRiskInfo().getEachLimit())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "EachLimit"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)quotePriceDTO.getRiskInfo().getEachPeopleLimit())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "EachPeopleLimit"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    private void verifyHomeEstateFormat(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List insuredList = quotePriceDTO.getInsuredList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (InsuredDTO insuredDTO : insuredList) {
            String birthDay;
            String birthDateStr;
            if ("1".equals(insuredDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_PERSONAL).contains(insuredDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("2".equals(insuredDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_COMPANY).contains(insuredDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("01".equals(insuredDTO.getIdentifyType()) && !(birthDateStr = insuredDTO.getIdentifyNumber().substring(6, 14)).equals(birthDay = DateUtils.dateToStr((Date)insuredDTO.getBirthday(), (String)"yyyyMMdd"))) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10267.getValue(), ChannelErrorCodeEnum.ERR_C10267.getKey());
            }
            if (map.containsKey(insuredDTO.getInsuredIDCache())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10221.getValue().replace("##", insuredDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10221.getKey());
            }
            map.put(insuredDTO.getInsuredIDCache(), insuredDTO.getInsuredName());
            if (idMap.containsKey(insuredDTO.getIdentifyNumber())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10404.getValue(), ChannelErrorCodeEnum.ERR_C10404.getKey());
            }
            idMap.put(insuredDTO.getIdentifyNumber(), insuredDTO.getInsuredName());
            if (RiskCodeEnum.getType((String)mainDTO.getRiskCode()) == 1 && StringUtils.isNotEmpty((CharSequence)insuredDTO.getInsuredName()) && !insuredDTO.getInsuredName().trim().replace(" ", "").matches(GeneralRegxs.Name_2)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10477.getValue().replaceFirst("##", insuredDTO.getInsuredName()).replace("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10477.getKey());
            }
            if ("01".equals(insuredDTO.getIdentifyType())) {
                if (StringUtils.isNotBlank((CharSequence)insuredDTO.getIdentifyNumber()) && !IdcardUtil.isValidCard((String)insuredDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10118.getValue().replace("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10118.getKey());
                }
                birthDateStr = insuredDTO.getIdentifyNumber().substring(6, 14);
                if (!birthDateStr.equals(DateUtils.dateToStr((Date)insuredDTO.getBirthday(), (String)"yyyyMMdd"))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10119.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredDTO.getSex())) {
                    insuredDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredDTO.getIdentifyNumber()) == 1 ? 1 : 2));
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)insuredDTO.getEmail()) || insuredDTO.getEmail().matches(GeneralRegxs.Email)) continue;
            throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u3010" + insuredDTO.getInsuredName() + "\u3011\u3010\u8bc1\u4ef6\u53f7" + insuredDTO.getIdentifyNumber() + "\u3011\u90ae\u7bb1\u3010" + insuredDTO.getEmail() + "\u3011\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4!", ChannelErrorCodeEnum.ERR_C10133.getKey());
        }
    }

    private void verifyHomeEstateNull(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredList = quotePriceDTO.getInsuredList();
        for (AppliClientDTO appliClientDTO : appliClientList) {
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10082.getValue(), ChannelErrorCodeEnum.ERR_C10082.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyNumber())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10083.getValue(), ChannelErrorCodeEnum.ERR_C10083.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getReqFaPiao()) && "1".equals(appliClientDTO.getReqFaPiao())) {
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getMailType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10070.getValue(), ChannelErrorCodeEnum.ERR_C10070.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getPhAddress())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10072.getValue(), ChannelErrorCodeEnum.ERR_C10072.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInvoiceTitle())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10071.getValue(), ChannelErrorCodeEnum.ERR_C10071.getKey());
                }
            }
            if (!"1".equals(appliClientDTO.getInsuredType()) || !ObjectUtil.isEmpty((Object)appliClientDTO.getBirthday())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10079.getValue(), ChannelErrorCodeEnum.ERR_C10079.getKey());
        }
        for (InsuredDTO insuredDTO : insuredList) {
            if (StringUtils.isEmpty((CharSequence)insuredDTO.getInsuredType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10077.getValue(), ChannelErrorCodeEnum.ERR_C10077.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)insuredDTO.getInsuredName())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10074.getValue(), ChannelErrorCodeEnum.ERR_C10074.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)insuredDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10075.getValue(), ChannelErrorCodeEnum.ERR_C10075.getKey());
            }
            if (!StringUtils.isEmpty((CharSequence)insuredDTO.getIdentifyNumber())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10076.getValue(), ChannelErrorCodeEnum.ERR_C10076.getKey());
        }
    }

    public void verifyAccidentHealth(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        this.verifyAccidentHealthNull(standerRequest, apisPfpRationMain);
        this.verifyAccidentHealthFormat(standerRequest, apisPfpRationMain);
        this.verifyAccidentHealthBusiRule(standerRequest, apisPfpRationMain);
        this.validJdAddr(standerRequest, apisPfpRationMain);
        this.validJdUser(standerRequest, apisPfpRationMain);
    }

    private void verifyAccidentHealthBusiRule(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredIdvDTOList = quotePriceDTO.getCoverage().getInsuredIdvList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setConfigCode("OCCUPATION_NULL");
        apisChannelConfigsCondition.setChannelCode(standerRequest.getHeader().getChannelCode());
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        String phInsuredType = ((AppliClientDTO)appliClientList.get(0)).getInsuredType();
        long lessFifty = 0L;
        int parentCount = 0;
        int childCount = 0;
        int myCount = 0;
        int spouseCount = 0;
        int juveniles = 0;
        int adult = 0;
        String caclMethod = "";
        for (AppliClientDTO appliClientDTO : appliClientList) {
            long year;
            if (!"1".equals(appliClientDTO.getInsuredType())) continue;
            ApisChannelConfigs configs = new ApisChannelConfigs();
            configs.setConfigCode("MINOR_INSURE_PLANS");
            configs.setUserCode(standerRequest.getHeader().getUserCode());
            configs.setRationCode(apisPfpRationMain.getRationCode());
            ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(configs);
            if (!ObjectUtil.isEmpty((Object)channelConfigs) || !ObjectUtil.isNotEmpty((Object)appliClientDTO.getBirthday()) || (year = (long)this.dataCompletionUtil.calculateAge(mainDTO.getStartDate(), appliClientDTO.getBirthday())) >= 18L) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10124.getValue(), ChannelErrorCodeEnum.ERR_C10124.getKey());
        }
        ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("ONE_INSURED");
        channelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
        ApisChannelConfigs configsOneInsured = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)configsOneInsured) && insuredIdvDTOList.size() > 1) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10269.getValue(), ChannelErrorCodeEnum.ERR_C10269.getKey());
        }
        caclMethod = this.dataCompletionUtil.queryCalcType(apisPfpRationMain.getRationCode());
        for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
            long year;
            String alipayFlag;
            String[] arr;
            ApisChannelConfigs relationToAppntConfig = new ApisChannelConfigs();
            relationToAppntConfig.setConfigCode("INSURED_RELATION_NULL");
            relationToAppntConfig.setChannelCode(standerRequest.getHeader().getChannelCode());
            ApisChannelConfigs apisChannelConfigs3 = this.apisChannelConfigsService.getChannelConfig(relationToAppntConfig);
            if ("2".equals(insuredIdvDTO.getBenefitModeCode()) && "1".equals(insuredIdvDTO.getBenefitOrder())) {
                BigDecimal sumShare = new BigDecimal(0);
                if (ObjectUtil.isNotEmpty((Object)insuredIdvDTO.getBeneficiary()) && insuredIdvDTO.getBeneficiary().size() > 0) {
                    for (BeneficiaryDTO beneficiaryDTO : insuredIdvDTO.getBeneficiary()) {
                        BigDecimal share = new BigDecimal(StringUtils.isEmpty((CharSequence)beneficiaryDTO.getShare()) ? "0" : beneficiaryDTO.getShare());
                        sumShare = sumShare.add(share);
                    }
                    if (sumShare.compareTo(new BigDecimal(100)) != 0) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10038.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10038.getKey());
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getAppliRelation().trim()) && ObjectUtil.isEmpty((Object)apisChannelConfigs3)) {
                if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getRelationToAppnt())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "PolicyholderInsuredRelation"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                arr = apisPfpRationMain.getAppliRelation().trim().split(",");
                if (!Arrays.asList(arr).contains(insuredIdvDTO.getRelationToAppnt())) {
                    if ("underwrit".equals(standerRequest.getHeader().getBussinessType())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10195.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10195.getKey());
                    }
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10135.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10135.getKey());
                }
            }
            if ("1".equals(phInsuredType) && StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getRelationToAppnt()) && ("06".equals(insuredIdvDTO.getRelationToAppnt()) || "07".equals(insuredIdvDTO.getRelationToAppnt()))) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10136.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10136.getKey());
            }
            if ("2".equals(phInsuredType) && StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getRelationToAppnt()) && !Arrays.asList(arr = new String[]{"06", "07", "99"}).contains(insuredIdvDTO.getRelationToAppnt())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10137.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10137.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getRelationToAppnt()) && "01".equals(insuredIdvDTO.getRelationToAppnt()) && (!insuredIdvDTO.getInsuredName().contains(((AppliClientDTO)appliClientList.get(0)).getInsuredName()) || !insuredIdvDTO.getIdentifyNumber().equals(((AppliClientDTO)appliClientList.get(0)).getIdentifyNumber()))) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10138.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10138.getKey());
            }
            ApisChannelConfigs apisChannelConfigs1 = new ApisChannelConfigs();
            apisChannelConfigs1.setConfigCode("OCCUPATION_NOT_NULL");
            apisChannelConfigs1.setProductCode(mainDTO.getRiskCode());
            ApisChannelConfigs apisChannelConfigs2 = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs1);
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs2) && ObjectUtil.isNotEmpty((Object)apisChannelConfigs2.getProductCode())) {
                String[] occArr;
                boolean aFlag;
                if (ObjectUtil.isEmpty((Object)apisChannelConfigs) && StringUtils.isEmpty((CharSequence)insuredIdvDTO.getOccupationCode()) && StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getInsuredOccupation()) && !(aFlag = Arrays.asList(occArr = apisPfpRationMain.getInsuredOccupation().split(",")).contains("7"))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10120.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10120.getKey());
                }
                if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getOccupationLevel()) && StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getInsuredOccupation()) && !"Z02001".equals(insuredIdvDTO.getOccupationCode())) {
                    String[] arr2 = apisPfpRationMain.getInsuredOccupation().split(",");
                    if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getOccupationLevel()) && !Arrays.asList(arr2).contains(insuredIdvDTO.getOccupationLevel()) && !Arrays.asList(arr2).contains("7")) {
                        QueryWrapper queryWrapper = new QueryWrapper();
                        queryWrapper.eq((Object)"config_code", (Object)"OCCUPATION_CONTROL_SPECIAL_ONE");
                        queryWrapper.eq((Object)"config_value", (Object)apisPfpRationMain.getRelateRationCode());
                        queryWrapper.like((Object)"remark", (Object)insuredIdvDTO.getOccupationCode());
                        ApisChannelConfigs occConfig = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
                        if (ObjectUtil.isEmpty((Object)occConfig)) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10121.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10121.getKey());
                        }
                    }
                }
            }
            boolean flag = false;
            Integer ageMin = null;
            Integer ageMax = null;
            int renewableMaxAge = 0;
            if (StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getAgeMax()) && StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getAgeMin())) {
                flag = true;
                ageMin = Integer.parseInt(apisPfpRationMain.getAgeMin());
                ageMax = Integer.parseInt(apisPfpRationMain.getAgeMax());
                int n = renewableMaxAge = ObjectUtil.isNotEmpty((Object)apisPfpRationMain.getRenewableMaxAge()) ? apisPfpRationMain.getRenewableMaxAge() : 0;
            }
            if ("1".equals(alipayFlag = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getAlipayFlag())) {
                Date inputDate = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getInputDate();
                year = this.dataCompletionUtil.calculateAge(inputDate, insuredIdvDTO.getBirthday());
            } else {
                year = this.dataCompletionUtil.calculateAge(mainDTO.getStartDate(), insuredIdvDTO.getBirthday());
            }
            if (flag) {
                if (renewableMaxAge != 0) {
                    ageMax = renewableMaxAge;
                }
                if (StringUtils.isNotEmpty((CharSequence)mainDTO.getTurnInsureType())) {
                    if (year > (long)ageMax.intValue()) {
                        throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u59d3\u540d\u3010" + insuredIdvDTO.getInsuredName() + "\u3011\u8bc1\u4ef6\u53f7\u3010" + insuredIdvDTO.getIdentifyNumber() + "\u3011\u5e74\u9f84\u8d85\u51fa\u4e86\u8ba1\u5212\u7684\u7eed\u4fdd\u5e74\u9f84\u9650\u5236\u3010" + ageMin + "\u3011-\u3010" + ageMax + "\u3011!", ChannelErrorCodeEnum.ERR_C10264.getKey());
                    }
                } else if (year < (long)ageMin.intValue() || year > (long)ageMax.intValue()) {
                    throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u59d3\u540d\u3010" + insuredIdvDTO.getInsuredName() + "\u3011\u8bc1\u4ef6\u53f7\u3010" + insuredIdvDTO.getIdentifyNumber() + "\u3011\u5e74\u9f84\u8d85\u51fa\u8ba1\u5212\u7684\u5e74\u9f84\u9650\u5236\u3010" + ageMin + "\u3011-\u3010" + ageMax + "\u3011!", ChannelErrorCodeEnum.ERR_C10366.getKey());
                }
            }
            if (year < 50L) {
                ++lessFifty;
            }
            if (year < 18L) {
                ++juveniles;
            } else {
                ++adult;
            }
            if (Arrays.asList(PLAN_YEAR_ARRAY).contains(caclMethod) && !AsyncQuotePriceValidate.isOutOneYear((Date)mainDTO.getStartDate(), (Date)mainDTO.getEndDate(), (boolean)true)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10043.getValue(), ChannelErrorCodeEnum.ERR_C10043.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getRelationToAppnt())) {
                if ("04".equals(insuredIdvDTO.getRelationToAppnt())) {
                    ++childCount;
                }
                if ("03".equals(insuredIdvDTO.getRelationToAppnt())) {
                    ++parentCount;
                }
                if ("01".equals(insuredIdvDTO.getRelationToAppnt())) {
                    ++myCount;
                }
                if ("02".equals(insuredIdvDTO.getRelationToAppnt())) {
                    ++spouseCount;
                }
            }
            if ("3".equals(mainDTO.getCalcType()) && "P070002".equals(mainDTO.getRiskCode()) && StringUtils.isEmpty((CharSequence)insuredIdvDTO.getSocialSecurityFlag())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10351.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10351.getKey());
            }
            if (ObjectUtil.isNotEmpty((Object)insuredIdvDTO.getStartDate()) && "02".equals(quotePriceDTO.getMain().getPolicyType())) {
                if (!DateUtils.dateToStr((Date)insuredIdvDTO.getStartDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "startDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
                }
                if (insuredIdvDTO.getStartDate().before(quotePriceDTO.getMain().getStartDate()) || insuredIdvDTO.getStartDate().after(quotePriceDTO.getMain().getEndDate())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10459.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10459.getKey());
                }
            }
            if (!ObjectUtil.isNotEmpty((Object)insuredIdvDTO.getEndDate()) || !"02".equals(quotePriceDTO.getMain().getPolicyType())) continue;
            if (!DateUtils.dateToStr((Date)insuredIdvDTO.getEndDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "endDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
            }
            if (!insuredIdvDTO.getEndDate().before(quotePriceDTO.getMain().getStartDate()) && !insuredIdvDTO.getEndDate().after(quotePriceDTO.getMain().getEndDate())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10460.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10460.getKey());
        }
        if ("3".equals(mainDTO.getCalcType()) && RiskCodeEnum.getType((String)mainDTO.getRiskCode()) == 1) {
            if ("P070002".equals(mainDTO.getRiskCode()) || "P090002".equals(mainDTO.getRiskCode())) {
                ApisChannelConfigs fityfAgeConfig = new ApisChannelConfigs();
                fityfAgeConfig.setConfigCode("doubleBelowFiftyAge");
                fityfAgeConfig.setRationCode(apisPfpRationMain.getRelateRationCode());
                ApisChannelConfigs acConfigs = this.apisChannelConfigsService.getChannelConfig(fityfAgeConfig);
                if (!(!"P070002P154".equals(apisPfpRationMain.getRelateRationCode()) && !ObjectUtil.isNotEmpty((Object)acConfigs) || "1".equals(mainDTO.getRenewalFlag()) || "underwrit".equals(standerRequest.getHeader().getBussinessType()) && StringUtils.isNotBlank((CharSequence)mainDTO.getRenewalPolicyNo()) || lessFifty >= 2L)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10353.getValue().replaceFirst("##", "2").replace("##", "50"), ChannelErrorCodeEnum.ERR_C10353.getKey());
                }
                if (quotePriceDTO.getCoverage().getInsuredIdvList().size() < 2 || quotePriceDTO.getCoverage().getInsuredIdvList().size() > 8) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10352.getValue().replaceFirst("##", "2").replace("##", "8"), ChannelErrorCodeEnum.ERR_C10352.getKey());
                }
                if (myCount > 1 || spouseCount > 1) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10356.getValue(), ChannelErrorCodeEnum.ERR_C10356.getKey());
                }
            }
            if ("P070006".equals(mainDTO.getRiskCode()) && ("11".equals(caclMethod) || "12".equals(caclMethod))) {
                if (childCount > 2) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10360.getValue(), ChannelErrorCodeEnum.ERR_C10360.getKey());
                }
                if (parentCount > 2) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10358.getValue(), ChannelErrorCodeEnum.ERR_C10358.getKey());
                }
                if (myCount > 1 || spouseCount > 1) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10356.getValue(), ChannelErrorCodeEnum.ERR_C10356.getKey());
                }
                if (myCount == 0) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10357.getValue(), ChannelErrorCodeEnum.ERR_C10357.getKey());
                }
            }
            ApisChannelConfigs juvenileConfig = new ApisChannelConfigs();
            juvenileConfig.setConfigCode("juveniles_not_proposal");
            juvenileConfig.setRationCode(apisPfpRationMain.getRelateRationCode());
            ApisChannelConfigs juvenilesChannelConfigs = this.apisChannelConfigsService.getChannelConfig(juvenileConfig);
            if (ObjectUtil.isNotEmpty((Object)juvenilesChannelConfigs) && juveniles > 0 && adult == 0) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10282.getValue(), ChannelErrorCodeEnum.ERR_C10282.getKey());
            }
        }
        this.validateIsRepeatDate(insuredIdvDTOList);
    }

    private void verifyAccidentHealthFormat(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredIdvDTOList = quotePriceDTO.getCoverage().getInsuredIdvList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        for (AppliClientDTO appliClientDTO : appliClientList) {
            if (!StringUtils.isNotEmpty((CharSequence)appliClientDTO.getInsuredName()) || appliClientDTO.getInsuredName().trim().replace(" ", "").matches(GeneralRegxs.Name_2)) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10477.getValue().replaceFirst("##", appliClientDTO.getInsuredName()).replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10477.getKey());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> idMap = new HashMap<String, String>();
        if (mainDTO.getSumQuantity().intValue() != insuredIdvDTOList.size()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10036.getValue(), ChannelErrorCodeEnum.ERR_C10036.getKey());
        }
        for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
            String birthDay;
            String birthDateStr;
            if ("01".equals(insuredIdvDTO.getIdentifyType()) && !(birthDateStr = insuredIdvDTO.getIdentifyNumber().substring(6, 14)).equals(birthDay = DateUtils.dateToStr((Date)insuredIdvDTO.getBirthday(), (String)"yyyyMMdd"))) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10267.getValue(), ChannelErrorCodeEnum.ERR_C10267.getKey());
            }
            if (map.containsKey(insuredIdvDTO.getInsuredIDCache())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10221.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10221.getKey());
            }
            map.put(insuredIdvDTO.getInsuredIDCache(), insuredIdvDTO.getInsuredName());
            if (idMap.containsKey(insuredIdvDTO.getIdentifyNumber()) && "01".equals(mainDTO.getPolicyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10404.getValue(), ChannelErrorCodeEnum.ERR_C10404.getKey());
            }
            idMap.put(insuredIdvDTO.getIdentifyNumber(), insuredIdvDTO.getInsuredName());
            if (RiskCodeEnum.getType((String)mainDTO.getRiskCode()) == 1 && StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getInsuredName()) && !insuredIdvDTO.getInsuredName().trim().replace(" ", "").matches(GeneralRegxs.Name_2)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10477.getValue().replaceFirst("##", insuredIdvDTO.getInsuredName()).replace("##", insuredIdvDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10477.getKey());
            }
            if ("01".equals(insuredIdvDTO.getIdentifyType())) {
                if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getIdentifyNumber()) && !IdcardUtil.isValidCard((String)insuredIdvDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10266.getValue().replaceFirst("##", insuredIdvDTO.getInsuredName()).replace("##", insuredIdvDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10266.getKey());
                }
                birthDateStr = insuredIdvDTO.getIdentifyNumber().substring(6, 14);
                if (!birthDateStr.equals(DateUtils.dateToStr((Date)insuredIdvDTO.getBirthday(), (String)"yyyyMMdd"))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", insuredIdvDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10119.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getSex())) {
                    insuredIdvDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredIdvDTO.getIdentifyNumber()) == 1 ? 1 : 2));
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getEmail()) || insuredIdvDTO.getEmail().matches(GeneralRegxs.Email)) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10144.getValue(), ChannelErrorCodeEnum.ERR_C10144.getKey());
        }
    }

    private void verifyAccidentHealthNull(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredIdvDTOList = quotePriceDTO.getCoverage().getInsuredIdvList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        for (AppliClientDTO appliClientDTO : appliClientList) {
            if (!"1".equals(appliClientDTO.getInsuredType())) continue;
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10385.getValue(), ChannelErrorCodeEnum.ERR_C10385.getKey());
            }
            if (!StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyNumber())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10386.getValue(), ChannelErrorCodeEnum.ERR_C10386.getKey());
        }
        ApisChannelConfigs configsCondition = new ApisChannelConfigs();
        configsCondition.setUserCode(standerRequest.getHeader().getUserCode());
        configsCondition.setRationCode(apisPfpRationMain.getRationCode());
        configsCondition.setConfigCode("endcase_plan_code");
        ApisChannelConfigs endcaseConfigs = this.apisChannelConfigsService.getChannelConfig(configsCondition);
        for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
            if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getInsuredType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10077.getValue(), ChannelErrorCodeEnum.ERR_C10077.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getInsuredName())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10074.getValue(), ChannelErrorCodeEnum.ERR_C10074.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10075.getValue(), ChannelErrorCodeEnum.ERR_C10075.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getIdentifyNumber())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10076.getValue(), ChannelErrorCodeEnum.ERR_C10076.getKey());
            }
            if ("1".equals(insuredIdvDTO.getInsuredType()) && ObjectUtil.isEmpty((Object)insuredIdvDTO.getBirthday())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10080.getValue(), ChannelErrorCodeEnum.ERR_C10080.getKey());
            }
            if (!ObjectUtil.isNotEmpty((Object)endcaseConfigs)) continue;
            if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getLinkerName())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10091.getValue(), ChannelErrorCodeEnum.ERR_C10091.getKey());
            }
            if (!StringUtils.isEmpty((CharSequence)insuredIdvDTO.getLinkerPhone())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10092.getValue(), ChannelErrorCodeEnum.ERR_C10092.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)endcaseConfigs)) {
            if (StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getOriginAirport())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10093.getValue(), ChannelErrorCodeEnum.ERR_C10093.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getDestAirport())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10094.getValue(), ChannelErrorCodeEnum.ERR_C10094.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getFlightDate())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10095.getValue(), ChannelErrorCodeEnum.ERR_C10095.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getReturnFlightDate())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10096.getValue(), ChannelErrorCodeEnum.ERR_C10096.getKey());
            }
            try {
                if (DateUtils.parseToDate((String)quotePriceDTO.getRiskInfo().getFlightDate(), (String)"yyyy-MM-dd HH:mm:ss").before(mainDTO.getStartDate())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10097.getValue(), ChannelErrorCodeEnum.ERR_C10097.getKey());
                }
            }
            catch (ParseException e) {
                log.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void validJdAddr(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO;
        List insuredIdvDTOList;
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
        apisChannelConfigsCondition.setConfigCode("JD_ADDR_VERIFICATION");
        apisChannelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs) && ObjectUtil.isNotEmpty((Object)(insuredIdvDTOList = (quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice()).getCoverage().getInsuredIdvList())) && insuredIdvDTOList.size() > 0) {
            ApisPfpRationMain apisPfpRationMainP = this.dataCompletionUtil.getApisPfpRationMainInfo(apisPfpRationMain.getRationCode(), "1");
            for (InsuredIdvDTO insuredDTO : insuredIdvDTOList) {
                if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getResideAddressId())) {
                    UwInfoQueryRequest jdAddrVerifyRequest = UwInfoQueryRequest.builder().build();
                    jdAddrVerifyRequest.setSerialNumber(UUID.randomUUID().toString());
                    jdAddrVerifyRequest.setRequestType("UW02");
                    jdAddrVerifyRequest.setAgencyCode(standerRequest.getHeader().getChannelCode());
                    jdAddrVerifyRequest.setResideAddressId(insuredDTO.getResideAddressId());
                    jdAddrVerifyRequest.setProductName(apisPfpRationMainP.getRationName());
                    UwInfoQueryResponse uwInfoQueryResponse = this.coreInsureApi.uwInfoQuery(jdAddrVerifyRequest, "uwInfoQueryXmlService");
                    if (ObjectUtil.isEmpty((Object)uwInfoQueryResponse)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10480.getValue(), ChannelErrorCodeEnum.ERR_C10480.getKey());
                    }
                    if ("N".equals(uwInfoQueryResponse.getResult().getIsAddressRulePass())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10306.getValue(), ChannelErrorCodeEnum.ERR_C10306.getKey());
                    }
                    insuredDTO.setInsuredAddress(uwInfoQueryResponse.getResult().getResideFullAddress() + "," + insuredDTO.getInsuredAddress());
                    continue;
                }
                if (!"0".equals(quotePriceDTO.getMain().getRenewalFlag()) || "underwrit".equals(standerRequest.getHeader().getBussinessType()) || !StringUtils.isEmpty((CharSequence)quotePriceDTO.getMain().getRenewalPolicyNo())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10303.getValue(), ChannelErrorCodeEnum.ERR_C10303.getKey());
            }
        }
    }

    private void validJdUser(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setConfigCode("verifyJdUser");
        apisChannelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        MainDTO mainDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        boolean flag = "underwrit".equals(standerRequest.getHeader().getBussinessType());
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs)) {
            QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
            List insuredList = quotePriceDTO.getInsuredList();
            List insuredIdvDTOList = quotePriceDTO.getCoverage().getInsuredIdvList();
            if (ObjectUtil.isNotEmpty((Object)insuredIdvDTOList) && insuredIdvDTOList.size() > 0) {
                for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
                    JdUserVerifyRequest jdUserVerifyRequest = JdUserVerifyRequest.builder().idNumber(insuredIdvDTO.getIdentifyNumber()).authDays("90").build();
                    JdUserVerifyResponse jdUserVerifyResponse = this.coreInsureApi.verifyJdUser(jdUserVerifyRequest);
                    if (ObjectUtil.isEmpty((Object)jdUserVerifyResponse)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10362.getValue(), ChannelErrorCodeEnum.ERR_C10362.getKey());
                    }
                    if ("N".equals(jdUserVerifyResponse.getResult().getStrategyResult())) {
                        if (flag) {
                            mainDTO.setJdUserVerifyFlag("0");
                            insuredIdvDTO.setPinFlag("N");
                            continue;
                        }
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10363.getValue(), ChannelErrorCodeEnum.ERR_C10363.getKey());
                    }
                    if (flag) {
                        mainDTO.setJdUserVerifyFlag("1");
                    }
                    insuredIdvDTO.setPinFlag("Y");
                }
            }
        }
    }

    private void validGive(StanderRequest standerRequest) throws ApisBusinessException {
        String giftType = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getGiftType();
        log.warn("=======\u8d60\u9669\u6821\u9a8c\u5f00\u59cb\uff0cgiftType = {}", (Object)giftType);
        if (StringUtils.isNotEmpty((CharSequence)giftType) && (giftType.equals("1") || giftType.equals("2"))) {
            String renewalFlag = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getRenewalFlag();
            if (StringUtils.isNotEmpty((CharSequence)renewalFlag) && renewalFlag.equals("1")) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10504.getValue(), ChannelErrorCodeEnum.ERR_C10504.getKey());
            }
            Date inputDate = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getInputDate();
            if (inputDate == null) {
                inputDate = new Date();
            }
            log.warn("\u8d60\u9669\u6295\u4fdd\u65f6\u95f4\u4e3a\uff1a{}", (Object)inputDate.getTime());
            Date giveStartTime = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getGiveStartTime();
            Date giveEndTime = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getGiveEndTime();
            if (inputDate.getTime() < giveStartTime.getTime() || inputDate.getTime() > giveEndTime.getTime()) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10505.getValue(), ChannelErrorCodeEnum.ERR_C10505.getKey());
            }
        }
    }

    private void validPetUnderWritingArea(StanderRequest standerRequest) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        MainDTO mainDTO = quotePriceDTO.getMain();
        if (ObjectUtil.isNotEmpty((Object)mainDTO) && "1".equals(mainDTO.getUnderWritingArea()) && StrUtil.isBlank((CharSequence)mainDTO.getField10())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10644.getValue(), ChannelErrorCodeEnum.ERR_C10644.getKey());
        }
    }

    private void validPetData(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        if ("P010989".equals(apisPfpRationMain.getProductCode())) {
            this.validPetUnderWritingArea(standerRequest);
            this.validPetLiabilityData(standerRequest);
        } else if ("P010998".equals(apisPfpRationMain.getProductCode())) {
            this.validPetUnderWritingArea(standerRequest);
            this.validPetMedicalData(standerRequest);
        }
    }

    private void validPetMedicalData(StanderRequest request) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        CoverageDTO coverage = quotePriceDTO.getCoverage();
        if (ObjectUtil.isEmpty((Object)coverage) || ObjectUtil.isEmpty((Object)coverage.getItemList()) || ObjectUtil.isEmpty((Object)((ItemMainDTO)coverage.getItemList().get(0)).getItemFamily()) || ObjectUtil.isEmpty(((ItemMainDTO)coverage.getItemList().get(0)).getItemFamily().get(0))) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10448.getValue(), ChannelErrorCodeEnum.ERR_C10448.getKey());
        }
        ItemFamilyDTO itemFamily = (ItemFamilyDTO)((ItemMainDTO)coverage.getItemList().get(0)).getItemFamily().get(0);
        if (StringUtils.isBlank((CharSequence)itemFamily.getPetType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u5ba0\u7269\u7c7b\u578b\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)itemFamily.getPetBirth())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10256.getValue(), ChannelErrorCodeEnum.ERR_C10256.getKey());
        }
        if (StringUtils.isBlank((CharSequence)itemFamily.getPetSex())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10257.getValue(), ChannelErrorCodeEnum.ERR_C10257.getKey());
        }
        if (StringUtils.isBlank((CharSequence)itemFamily.getChipNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10258.getValue(), ChannelErrorCodeEnum.ERR_C10258.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getImgBatchUploadServiceRequest()) && ObjectUtil.isNotEmpty((Object)request.getImgBatchUploadServiceRequest().getRequestBody()) && ObjectUtil.isNotEmpty((Object)request.getImgBatchUploadServiceRequest().getRequestBody().getImgList())) {
            List petPicList = request.getImgBatchUploadServiceRequest().getRequestBody().getImgList();
            if (petPicList.size() > 3) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10213.getValue().replace("##", "3"), ChannelErrorCodeEnum.ERR_C10213.getKey());
            }
            for (ImgMetaDTO p : petPicList) {
                if ("URL-IMG".equals(p.getPetImgType())) continue;
                if (StringUtils.isBlank((CharSequence)p.getExtendName()) || !p.getExtendName().matches(GeneralRegxs.PictureFormat)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10216.getValue().replace("##", p.getFileName() + "." + p.getExtendName()), ChannelErrorCodeEnum.ERR_C10216.getKey());
                }
                if (ObjectUtil.isNotEmpty((Object)p.getFileContentWithBase64Encode())) {
                    float imageSize = this.imageSize(p.getFileContentWithBase64Encode());
                    if (!(imageSize > 3072.0f)) continue;
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10214.getValue().replaceFirst("##", p.getFileName() + "." + p.getExtendName()).replaceFirst("##", "3072"), ChannelErrorCodeEnum.ERR_C10214.getKey());
                }
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u56fe\u7247\u5185\u5bb9\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        }
    }

    public float imageSize(String imageBase64Str) {
        Integer equalIndex = imageBase64Str.indexOf("=");
        if (imageBase64Str.indexOf("=") > 0) {
            imageBase64Str = imageBase64Str.substring(0, equalIndex);
        }
        Integer strLength = imageBase64Str.length();
        Integer size = strLength - strLength / 8 * 2;
        BigDecimal fileSize = new BigDecimal(size);
        BigDecimal kilobyte = new BigDecimal(1024);
        return fileSize.divide(kilobyte, 1, 1).floatValue();
    }

    private void validPetLiabilityData(StanderRequest request) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        CoverageDTO coverage = quotePriceDTO.getCoverage();
        if (ObjectUtil.isEmpty((Object)coverage) || ObjectUtil.isEmpty((Object)coverage.getItemList()) || ObjectUtil.isEmpty((Object)((ItemMainDTO)coverage.getItemList().get(0)).getItemFamily())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10212.getValue(), ChannelErrorCodeEnum.ERR_C10212.getKey());
        }
        ItemFamilyDTO itemFamily = (ItemFamilyDTO)((ItemMainDTO)coverage.getItemList().get(0)).getItemFamily().get(0);
        if (StringUtils.isBlank((CharSequence)itemFamily.getPetType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u5ba0\u7269\u7c7b\u578b\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getImgBatchUploadServiceRequest()) && ObjectUtil.isNotEmpty((Object)request.getImgBatchUploadServiceRequest().getRequestBody()) && ObjectUtil.isNotEmpty((Object)request.getImgBatchUploadServiceRequest().getRequestBody().getImgList())) {
            List petPicList = request.getImgBatchUploadServiceRequest().getRequestBody().getImgList();
            for (ImgMetaDTO p : petPicList) {
                if (!StringUtils.isBlank((CharSequence)p.getExtendName()) && p.getExtendName().matches(GeneralRegxs.PictureFormat)) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10216.getValue().replace("##", p.getFileName() + "." + p.getExtendName()), ChannelErrorCodeEnum.ERR_C10216.getKey());
            }
        } else {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10212.getValue(), ChannelErrorCodeEnum.ERR_C10212.getKey());
        }
    }

    public void commonVerifyProduct(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        StanderHeader standerHeader = standerRequest.getHeader();
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        MainDTO mainDTO = quotePriceDTO.getMain();
        Date startDate = mainDTO.getStartDate();
        if (startDate.after(mainDTO.getEndDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10067.getValue(), ChannelErrorCodeEnum.ERR_C10067.getKey());
        }
        ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("backSign");
        channelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
        ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (ObjectUtil.isEmpty((Object)channelConfigs) && startDate.before(new Date()) && "1".equals(this.backSignSwitch)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10035.getValue(), ChannelErrorCodeEnum.ERR_C10035.getKey());
        }
        if (!AsyncQuotePriceValidate.isOutOneYear((Date)startDate, (Date)mainDTO.getEndDate(), (boolean)false)) {
            if (RiskCodeEnum.getType((String)mainDTO.getRiskCode()) == 1) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10040.getValue(), ChannelErrorCodeEnum.ERR_C10040.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10068.getValue(), ChannelErrorCodeEnum.ERR_C10068.getKey());
        }
        channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
        channelConfigsCondition.setConfigCode("ONE_STEP_ISSUE_CODE");
        ApisChannelConfigs apisChannelConfigsO = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (StringUtils.isNotEmpty((CharSequence)mainDTO.getOutPaymentType())) {
            if ("0".equals(mainDTO.getJFeeFlag())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10471.getValue(), ChannelErrorCodeEnum.ERR_C10471.getKey());
            }
            if (ObjectUtil.isEmpty((Object)apisChannelConfigsO)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10443.getValue(), ChannelErrorCodeEnum.ERR_C10443.getKey());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigsO) && "1".equals(mainDTO.getStepFlag()) && (StringUtils.isEmpty((CharSequence)mainDTO.getOutPaymentType()) || StringUtils.isEmpty((CharSequence)mainDTO.getAccountCode())) && "1".equals(mainDTO.getRenewalFlag()) && ObjectUtil.isNotEmpty((Object)standerRequest.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform()) && !standerRequest.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform().booleanValue()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10470.getValue(), ChannelErrorCodeEnum.ERR_C10470.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPayPlanList()) && quotePriceDTO.getPayPlanList().size() > 1 && StringUtils.isEmpty((CharSequence)quotePriceDTO.getMain().getTurnInsureType())) {
            long b;
            long a;
            Calendar calendar = Calendar.getInstance();
            ApisChannelConfigs installmentConfig = new ApisChannelConfigs();
            installmentConfig.setConfigCode("Installment_back");
            installmentConfig.setUserCode(standerHeader.getUserCode());
            ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(installmentConfig);
            calendar.setTime(new Date());
            if (ObjectUtil.isEmpty((Object)apisChannelConfigs)) {
                calendar.add(5, 1);
            }
            if ((a = Long.parseLong(DateUtils.dateToStr((Date)quotePriceDTO.getMain().getStartDate(), (String)"yyyyMMddHHmmss"))) < (b = Long.parseLong(DateUtils.dateToStr((Date)calendar.getTime(), (String)"yyyyMMdd") + "000000"))) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10452.getValue(), ChannelErrorCodeEnum.ERR_C10452.getKey());
            }
        }
        if ("1".equals(mainDTO.getRenewalFlag())) {
            this.dataCompletionUtil.policyVerify(standerRequest, quotePriceDTO.getPolicyDTO(), "1002");
            if (!"07".equals(apisPfpRationMain.getClassCode()) && !"09".equals(apisPfpRationMain.getClassCode())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10458.getValue(), ChannelErrorCodeEnum.ERR_C10458.getKey());
            }
        }
        this.validGive(standerRequest);
    }

    public static boolean isOutOneYear(Date start, Date end, boolean yearFlag) {
        long yearDays = 365L;
        if (start.after(end)) {
            return false;
        }
        Calendar startDay = Calendar.getInstance();
        Calendar endDay = Calendar.getInstance();
        startDay.setTime(start);
        endDay.setTime(end);
        long month = startDay.get(2) + 1;
        int year = month < 3L ? startDay.get(1) : endDay.get(1);
        if (DateUtil.isLeapYear((int)year)) {
            yearDays = 366L;
        }
        endDay.add(12, 1);
        long time = endDay.getTimeInMillis() - startDay.getTimeInMillis();
        long yearTime = DateUnit.DAY.getMillis() * yearDays + DateUnit.MINUTE.getMillis();
        if (time > yearTime) {
            return false;
        }
        return !yearFlag || yearTime - time <= DateUnit.MINUTE.getMillis();
    }

    public void commonVerifyFormat(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        MainDTO mainDTO = quotePriceDTO.getMain();
        if (!DateUtils.dateToStr((Date)mainDTO.getStartDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "startDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
        }
        if (!DateUtils.dateToStr((Date)mainDTO.getEndDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "endDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
        }
        boolean autoRenewalFlag = true;
        ApisPfpRationMain pfpRationMain = this.dataCompletionUtil.getApisPfpRationMainInfo(apisPfpRationMain.getRationCode(), "1");
        if (ObjectUtil.isNotEmpty((Object)pfpRationMain) && "N".equals(pfpRationMain.getIsAutoRenew()) && ObjectUtil.isNotEmpty((Object)quotePriceDTO.getRenewal()) && StringUtils.isNotEmpty((CharSequence)quotePriceDTO.getRenewal().getAccountName())) {
            autoRenewalFlag = false;
        }
        if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPayPlanList()) && quotePriceDTO.getPayPlanList().size() > 1 && ObjectUtil.isNotEmpty((Object)quotePriceDTO.getRenewal()) && StringUtils.isNotEmpty((CharSequence)quotePriceDTO.getRenewal().getAccountName())) {
            autoRenewalFlag = false;
        }
        if (!autoRenewalFlag) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10320.getValue(), ChannelErrorCodeEnum.ERR_C10320.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getRenewal()) && StringUtils.isNotEmpty((CharSequence)quotePriceDTO.getRenewal().getAccountName())) {
            ApisChannelCode channelCode = new ApisChannelCode();
            channelCode.setDeleted(Integer.valueOf(0));
            channelCode.setCode("auto_renewal_bank");
            QueryWrapper queryWrapper = new QueryWrapper((Object)channelCode);
            List configsList = this.apisChannelCodeService.list((Wrapper)queryWrapper);
            boolean flag = false;
            for (ApisChannelCode temp : configsList) {
                if (!temp.getChannelValue().equals(quotePriceDTO.getRenewal().getBankName())) continue;
                quotePriceDTO.getRenewal().setBankType(temp.getValue());
                flag = true;
                break;
            }
            if (!flag) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10190.getValue(), ChannelErrorCodeEnum.ERR_C10190.getKey());
            }
        }
        for (AppliClientDTO appliClientDTO : appliClientList) {
            if ("1".equals(appliClientDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_PERSONAL).contains(appliClientDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("2".equals(appliClientDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_COMPANY).contains(appliClientDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("01".equals(appliClientDTO.getIdentifyType())) {
                if (StringUtils.isNotBlank((CharSequence)appliClientDTO.getIdentifyNumber()) && !IdcardUtil.isValidCard((String)appliClientDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10073.getValue().replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10073.getKey());
                }
                String birthDateStr = appliClientDTO.getIdentifyNumber().substring(6, 14);
                if (ObjectUtil.isNotEmpty((Object)appliClientDTO.getBirthday())) {
                    String birthDay = DateUtils.dateToStr((Date)appliClientDTO.getBirthday(), (String)"yyyyMMdd");
                    if (!birthDateStr.equals(birthDay)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10240.getValue().replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10240.getKey());
                    }
                } else {
                    try {
                        appliClientDTO.setBirthday(DateUtils.parseToDate((String)birthDateStr, (String)"yyyyMMdd"));
                    }
                    catch (Exception e) {
                        log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getSex())) {
                    appliClientDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)appliClientDTO.getIdentifyNumber()) == 1 ? 1 : 2));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getEmail()) && !appliClientDTO.getEmail().matches(GeneralRegxs.Email)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10132.getValue(), ChannelErrorCodeEnum.ERR_C10132.getKey());
            }
            if (!StringUtils.isNotEmpty((CharSequence)appliClientDTO.getTaxPayerId()) || appliClientDTO.getTaxPayerId().matches(GeneralRegxs.TaxpayerId)) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10478.getValue(), ChannelErrorCodeEnum.ERR_C10478.getKey());
        }
    }

    private void validateIsRepeatDate(List<InsuredIdvDTO> insuredIdvDTOList) throws ApisBusinessException {
        for (int i = 0; i < insuredIdvDTOList.size(); ++i) {
            InsuredIdvDTO insuredIdvDTO = insuredIdvDTOList.get(i);
            for (int j = i + 1; j < insuredIdvDTOList.size(); ++j) {
                InsuredIdvDTO idvDTO = insuredIdvDTOList.get(j);
                if (insuredIdvDTO.getItemNo() != idvDTO.getItemNo() && insuredIdvDTO.getIdentifyNumber().equals(idvDTO.getIdentifyNumber()) && insuredIdvDTO.getEndDate().after(idvDTO.getStartDate())) {
                    throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u3010" + insuredIdvDTO.getInsuredName() + "\u3011\u6709\u91cd\u590d\u4fdd\u9669\u533a\u95f4", ChannelErrorCodeEnum.ERR_C10111.getKey());
                }
                if (insuredIdvDTO.getItemNo() != idvDTO.getItemNo() || !insuredIdvDTO.getIdentifyNumber().equals(idvDTO.getIdentifyNumber())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10420.getValue(), ChannelErrorCodeEnum.ERR_C10420.getKey());
            }
        }
    }

    private void commonVerifyNull(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        StanderHeader standerHeader = standerRequest.getHeader();
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        MainDTO mainDTO = quotePriceDTO.getMain();
        for (AppliClientDTO appliClientDTO : appliClientList) {
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInsuredType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10384.getValue(), ChannelErrorCodeEnum.ERR_C10384.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInsuredName())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10387.getValue(), ChannelErrorCodeEnum.ERR_C10387.getKey());
            }
            if ("1".equals(appliClientDTO.getReqElecFaPiao()) && StringUtils.isEmpty((CharSequence)appliClientDTO.getEmail()) && StringUtils.isEmpty((CharSequence)appliClientDTO.getMobile())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10130.getValue(), ChannelErrorCodeEnum.ERR_C10130.getKey());
            }
            ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
            apisChannelConfigsCondition.setUserCode(standerHeader.getUserCode());
            apisChannelConfigsCondition.setConfigCode("PHONE_NOT_NULL");
            apisChannelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
            ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
            if (!ObjectUtil.isNotEmpty((Object)apisChannelConfigs) || !StringUtils.isEmpty((CharSequence)appliClientDTO.getMobile())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10129.getValue(), ChannelErrorCodeEnum.ERR_C10129.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getOrderNo())) {
            throw new ApisBusinessException("\u7b2c\u4e09\u65b9\u6e20\u9053\u516c\u53f8\u4fdd\u5355\u53f7\u7801\u6216\u8005\u7b2c\u4e09\u65b9\u6e20\u9053\u516c\u53f8\u8ba2\u5355\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getStartDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10066.getValue(), ChannelErrorCodeEnum.ERR_C10066.getKey());
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getEndDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10066.getValue(), ChannelErrorCodeEnum.ERR_C10066.getKey());
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getInputDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10391.getValue(), ChannelErrorCodeEnum.ERR_C10391.getKey());
        }
        if ("1".equals(mainDTO.getRenewalFlag())) {
            if (StringUtils.isEmpty((CharSequence)mainDTO.getRenewalPolicyNo())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10242.getValue(), ChannelErrorCodeEnum.ERR_C10242.getKey());
            }
            if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getRenewal()) && "1".equals(quotePriceDTO.getRenewal().getAutoTransRenewFlag())) {
                if (ObjectUtil.isEmpty((Object)quotePriceDTO.getRenewal().getAccount()) || ObjectUtil.isEmpty((Object)quotePriceDTO.getRenewal().getBankName())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10455.getValue(), ChannelErrorCodeEnum.ERR_C10455.getKey());
                }
                log.warn("1002\u7eed\u4fdd\u4f20\u5165\u7684\u94f6\u884c\u8d26\u53f7\uff1a{}", (Object)quotePriceDTO.getRenewal().getAccount());
                log.warn("1002\u7eed\u4fdd\u4f20\u5165\u7684\u94f6\u884c\u540d\u79f0\uff1a{}", (Object)quotePriceDTO.getRenewal().getBankName());
                if (ObjectUtil.isEmpty((Object)quotePriceDTO.getRenewal().getAccount())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10499.getValue(), ChannelErrorCodeEnum.ERR_C10499.getKey());
                }
                if (ObjectUtil.isEmpty((Object)quotePriceDTO.getRenewal().getBankName())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10500.getValue(), ChannelErrorCodeEnum.ERR_C10500.getKey());
                }
                quotePriceDTO.getRenewal().setAccountName(((AppliClientDTO)quotePriceDTO.getAppliClient().get(0)).getInsuredName());
            }
        }
    }

    private <T> void patternVaild(T t) throws ApisBusinessException {
        String identifyType = String.valueOf(this.getFieldValue("getIdentifyType", t));
        String identifyNumber = String.valueOf(this.getFieldValue("getIdentifyNumber", t));
        String insuredName = String.valueOf(this.getFieldValue("getInsuredName", t));
        Object birthObj = this.getFieldValue("getBirthday", t);
        Date birthday = null;
        if (birthObj instanceof Date) {
            birthday = (Date)birthObj;
        }
        String sex = String.valueOf(this.getFieldValue("getSex", t));
        String email = String.valueOf(this.getFieldValue("getEmail", t));
        if (ApisCommonConstantsEnum.CARD_PERSON_TYPE_ID.getKey().equals(identifyType)) {
            if (StringUtils.isNotEmpty((CharSequence)identifyNumber) && !IdcardUtil.isValidCard((String)identifyNumber)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10266.getValue().replaceFirst("##", insuredName).replace("##", identifyNumber), ChannelErrorCodeEnum.ERR_C10266.getKey());
            }
            String birthDateStr = identifyNumber.substring(6, 14);
            if (!birthDateStr.equals(DateUtils.dateToStr((Date)birthday, (String)"yyyyMMdd"))) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", identifyNumber), ChannelErrorCodeEnum.ERR_C10119.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)sex)) {
                this.setFieldValue("sex", t, String.valueOf(IdcardUtil.getGenderByIdCard((String)identifyNumber) == 1 ? 1 : 2));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)email) && !email.matches(GeneralRegxs.Email)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10144.getValue(), ChannelErrorCodeEnum.ERR_C10144.getKey());
        }
    }

    private <T> Object getFieldValue(String valueName, T t) throws ApisBusinessException {
        Object object = null;
        try {
            object = t.getClass().getMethod(valueName, new Class[0]).invoke(t, new Object[0]);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue() + "\u53cd\u5c04\u8f6c\u6362\u9519\u8bef", ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
        return object;
    }

    private <T> void setFieldValue(String valueName, T t, String value) throws ApisBusinessException {
        try {
            Field f = t.getClass().getDeclaredField(valueName);
            f.setAccessible(true);
            f.set(t, value);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue() + "\u53cd\u5c04\u8f6c\u6362\u9519\u8bef", ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
    }
}

