/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiSerialNumberLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiSerialNumberLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicInteger;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Component;

@Component
public class BusinessUtils {
    private static final Logger log = LoggerFactory.getLogger(BusinessUtils.class);
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiSerialNumberLogService apisBusiSerialNumberLogService;
    @Autowired
    RedisTemplate<String, String> redisTemplate;
    private static final String POLICY_NO_TYPE = "P";
    private static final String LOG_TYPE_POLICY_NO = "POLICY_NO";
    private static final int INIT_INCREMENT = 1;

    public String getBusinessNo(StanderRequest request) throws ApisBusinessException {
        long in = System.currentTimeMillis();
        QuotePriceDTO quotePrice = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        String comCode = quotePrice.getMain().getComCode();
        String riskCode = quotePrice.getMain().getRiskCode();
        String channelCode = quotePrice.getSales().getAgentCode();
        String businessNo = this.getBusinessNo(comCode, riskCode, channelCode);
        long out = System.currentTimeMillis();
        log.warn("\u751f\u6210\u4fdd\u5355\u53f7\uff1a{}\uff0c\u7528\u65f6\uff1a{}", (Object)businessNo, (Object)(out - in));
        return businessNo;
    }

    public String getBusinessNo(String comCode, String riskCode, String channelCode) throws ApisBusinessException {
        String channelBusinessFlag = this.getChannelBusinessFlag(channelCode);
        String year = String.valueOf(Calendar.getInstance().get(1));
        StringBuffer key = new StringBuffer().append(POLICY_NO_TYPE).append(comCode.substring(0, 4)).append(channelBusinessFlag.substring(0, 2)).append(year.substring(2)).append(riskCode.substring(1));
        String serialNo = String.format("%08d", this.getSerialNo(key.toString()));
        String businessNo = key.append(serialNo).toString();
        return businessNo;
    }

    private String getChannelBusinessFlag(String channelCode) throws ApisBusinessException {
        String configCode = "channel_business_flag";
        String key = new StringBuffer(channelCode).append(":").append("configCode").toString();
        String channelBusinessFlag = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isEmpty((CharSequence)channelBusinessFlag)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"deleted", (Object)"0");
            queryWrapper.eq((Object)"config_code", (Object)configCode);
            queryWrapper.eq((Object)"channel_code", (Object)channelCode);
            ApisChannelConfigs channelConfigs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
            if (ObjectUtil.isEmpty((Object)channelConfigs) || StringUtils.isEmpty((CharSequence)channelConfigs.getConfigValue())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10512.getValue().replace("##", channelCode), ChannelErrorCodeEnum.ERR_C10512.getKey());
            }
            channelBusinessFlag = channelConfigs.getConfigValue();
            this.redisTemplate.opsForValue().set((Object)key, (Object)channelBusinessFlag);
        }
        return channelBusinessFlag;
    }

    public Integer getSerialNo(String key) {
        Integer serialNo = this.getIncr(key);
        if (serialNo == 1) {
            serialNo = this.initSerialNo(key);
        } else {
            this.insertSerialNumberLog(LOG_TYPE_POLICY_NO, key, serialNo);
        }
        return serialNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer initSerialNo(String key) {
        String lockKey = "setIncr:" + key;
        int serialNo = 1;
        if (this.lock(lockKey)) {
            try {
                Integer maxSerialNo = this.apisBusiSerialNumberLogService.getMaxSerialNoByCacheKey(key);
                if (ObjectUtil.isNotEmpty((Object)maxSerialNo)) {
                    serialNo = maxSerialNo + 1;
                    this.setIncr(key, serialNo);
                }
                ApisBusiSerialNumberLog apisBusiSerialNumberLog = new ApisBusiSerialNumberLog();
                apisBusiSerialNumberLog.setType(LOG_TYPE_POLICY_NO);
                apisBusiSerialNumberLog.setCacheKey(key);
                apisBusiSerialNumberLog.setCacheValue(Integer.valueOf(serialNo));
                this.apisBusiSerialNumberLogService.save((Object)apisBusiSerialNumberLog);
            }
            finally {
                this.unlock(lockKey);
            }
        }
        return serialNo;
    }

    public void insertSerialNumberLog(String type, String cacheKey, Integer cacheValue) {
        ApisBusiSerialNumberLog apisBusiSerialNumberLog = new ApisBusiSerialNumberLog();
        apisBusiSerialNumberLog.setType(type);
        apisBusiSerialNumberLog.setCacheKey(cacheKey);
        apisBusiSerialNumberLog.setCacheValue(cacheValue);
        this.apisBusiSerialNumberLogService.asyncSaveOrUpdate(apisBusiSerialNumberLog);
    }

    public Integer getIncr(String key) {
        RedisAtomicInteger entityIdCounter = new RedisAtomicInteger(key, this.redisTemplate.getConnectionFactory());
        Integer increment = entityIdCounter.incrementAndGet();
        return increment;
    }

    public void setIncr(String key, int value) {
        RedisAtomicLong counter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        counter.set((long)value);
    }

    public boolean lock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)key, 5L, TimeUnit.SECONDS);
    }

    public void unlock(String key) {
        this.redisTemplate.delete((Object)key);
    }
}

