/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.EPolicyDownServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ImgNode;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.EPolicyDownRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.EPolicyDownServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUploadAttachment;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUploadAttachmentService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class CfDrugsUtil {
    private static final Logger log = LoggerFactory.getLogger(CfDrugsUtil.class);
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    EPolicyDownServiceImpl ePolicyDownService;
    @Autowired
    QuotePriceValidate quotePriceValidate;
    @Autowired
    ApisBusiUploadAttachmentService apisBusiUploadAttachmentService;
    @Autowired
    MediaUploadUtil mediaUploadUtil;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Value(value="${cfDrugs.secretKey}")
    String secretKey;

    public void verifyMd5Value(StanderRequest request) throws ApisBusinessException {
        String md5Value;
        MainDTO main = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        String paramMd5Value = main.getField10();
        if (!paramMd5Value.equals(md5Value = this.getMd5Value(request.getHeader().getBusinessKey(), new BigDecimal(main.getSumPremium()).setScale(2, 4)))) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10710.getValue(), ChannelErrorCodeEnum.ERR_C10710.getKey());
        }
    }

    private String getMd5Value(String businessKey, BigDecimal sumPremium) {
        return SecureUtil.md5((String)(businessKey + sumPremium.toString() + this.secretKey));
    }

    public String getPolicyQueryUrl() {
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode("policy_query_url");
        apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs) && StringUtils.isNotEmpty((CharSequence)apisChannelConfigs.getConfigValue())) {
            return apisChannelConfigs.getConfigValue();
        }
        return "";
    }

    public String getPolicyDownUrl(StanderRequest request, String policyNo) {
        EPolicyDownRequestDTO ePolicyDownRequestDTO = EPolicyDownRequestDTO.builder().businessNo(policyNo).build();
        EPolicyDownServiceRequest ePolicyDownServiceRequest = EPolicyDownServiceRequest.builder().requestBody(ePolicyDownRequestDTO).build();
        request.setEPolicyDownServiceRequest(ePolicyDownServiceRequest);
        WebResponse response = this.ePolicyDownService.down(request, null, null);
        if (ObjectUtil.isNotEmpty((Object)response) && ObjectUtil.isNotEmpty((Object)response.getResult()) && response.getResult() instanceof HashMap) {
            HashMap result = (HashMap)response.getResult();
            return (String)result.get("url");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="imgBatchUploadExecutor")
    public void syncUploadCfDrugs(StanderRequest request) throws ApisBusinessException {
        log.warn("\u5f02\u6b65\u4e0a\u4f20\u836f\u8054\u6295\u4fdd\u8d44\u6599");
        String flag = "3";
        ClaimMediaCommitResult response = ClaimMediaCommitResult.builder().build();
        ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
        apisBusiTaskLog.setPushStatus("0");
        apisBusiTaskLog.setPushStep(Integer.valueOf(1));
        apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.INSURE_ATTACHMENTS_UPLOAD_YAO_LIAN.getKey());
        try {
            BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"imgBatchUploadServiceRequest");
            ImgBatchUploadServiceRequest imgBatchUploadServiceRequest = request.getImgBatchUploadServiceRequest();
            if (ObjectUtil.isEmpty((Object)imgBatchUploadServiceRequest.getRequestBody()) || ObjectUtil.isEmpty((Object)imgBatchUploadServiceRequest.getRequestBody().getLinkNo()) || ObjectUtil.isEmpty((Object)imgBatchUploadServiceRequest.getRequestBody().getOrderNo())) {
                log.error("\u5f02\u6b65\u4e0a\u4f20\u836f\u8054\u6295\u4fdd\u8d44\u6599\u5f02\u5e38-\u300b\u53c2\u6570\u5f02\u5e38");
                throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N50001.getValue(), ErrorNullValueCodeEnum.ERR_N50001.getKey());
            }
            apisBusiTaskLog.setBusinessKey(imgBatchUploadServiceRequest.getRequestBody().getLinkNo());
            ImgMetaDTO imgMetaDto = (ImgMetaDTO)imgBatchUploadServiceRequest.getRequestBody().getImgList().get(0);
            String base64Str = OkHttpUtils.getBase64EncodeByUrl((String)imgMetaDto.getFileUrl());
            if (StringUtils.isEmpty((CharSequence)base64Str)) {
                log.error("\u4e0b\u8f7d\u836f\u8054\u6295\u4fdd\u8d44\u6599\u5931\u8d25,url:" + imgMetaDto.getFileUrl());
                flag = "4";
            } else {
                imgMetaDto.setFileContentWithBase64Encode(base64Str);
                imgMetaDto.setFileOrgName(UUID.randomUUID().toString() + System.currentTimeMillis() + ".csv");
                response = this.mediaUploadUtil.imgBatchUpload(request);
                if (ObjectUtil.isNotEmpty((Object)response) && ModelConstants.INT_VALUE_NO.intValue() == response.getHeadDto().getStatus()) {
                    apisBusiTaskLog.setPushStatus("1");
                } else {
                    apisBusiTaskLog.setPushStatus("4");
                    flag = "4";
                }
                apisBusiTaskLog.setErrMsg(JSON.toJSONString((Object)response));
                apisBusiTaskLog.setLastPushTime(LocalDateTime.now());
            }
        }
        catch (Exception e) {
            flag = "4";
            log.error("\u4e0b\u8f7d\u836f\u8054\u6295\u4fdd\u8d44\u6599\u5931\u8d25: ", (Throwable)e);
        }
        finally {
            this.saveCfDrugsMaterial(request, flag, response);
            this.apisBusiTaskLogService.saveOrUpdate((Object)apisBusiTaskLog);
        }
    }

    private void saveCfDrugsMaterial(StanderRequest request, String flag, ClaimMediaCommitResult response) {
        ImgBatchUploadServiceRequest imgBatchUploadServiceRequest = request.getImgBatchUploadServiceRequest();
        String businessNo = imgBatchUploadServiceRequest.getRequestBody().getLinkNo();
        List apisBusiUploadAttachments = this.apisBusiUploadAttachmentService.getByBusinessNo(businessNo, "I");
        ImgMetaDTO imgMetaDto = (ImgMetaDTO)imgBatchUploadServiceRequest.getRequestBody().getImgList().get(0);
        ApisBusiUploadAttachment apisBusiUploadAttachment = new ApisBusiUploadAttachment();
        if (ObjectUtil.isNotEmpty((Object)apisBusiUploadAttachments)) {
            apisBusiUploadAttachment = (ApisBusiUploadAttachment)apisBusiUploadAttachments.get(0);
        }
        apisBusiUploadAttachment.setBusinessNo(imgBatchUploadServiceRequest.getRequestBody().getLinkNo());
        apisBusiUploadAttachment.setBusinessType("I");
        apisBusiUploadAttachment.setAttaName(imgMetaDto.getFileOrgName());
        apisBusiUploadAttachment.setAttaThirdPath(imgMetaDto.getFileUrl());
        if (ObjectUtil.isNotEmpty((Object)response) && ObjectUtil.isNotEmpty((Object)response.getImgNodes())) {
            apisBusiUploadAttachment.setAttaImgPath(((ImgNode)response.getImgNodes().get(0)).getImgUrl());
        }
        apisBusiUploadAttachment.setStatus(flag);
        float imageSize = 0.0f;
        if (StringUtils.isNotEmpty((CharSequence)imgMetaDto.getFileContentWithBase64Encode())) {
            imageSize = this.quotePriceValidate.imageSize(imgMetaDto.getFileContentWithBase64Encode());
        }
        apisBusiUploadAttachment.setAttaSize(Integer.valueOf((int)imageSize));
        this.apisBusiUploadAttachmentService.saveOrUpdate((Object)apisBusiUploadAttachment);
    }
}

