/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiEmailSendLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiEmailSendLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelConfigsMapper;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class EmailCommonUtil {
    private static final Logger log = LoggerFactory.getLogger(EmailCommonUtil.class);
    private final JavaMailSender mailSender;
    private static final String LITIGATION_APPLY_TITLE = "\u901a\u8fc7\u6700\u9ad8\u9662\u201c\u4eba\u6c11\u6cd5\u9662\u7f51\u4e0a\u4fdd\u5168\u7cfb\u7edf\u201d\u7533\u8bf7\u4fdd\u5168\u90ae\u4ef6\u63d0\u793a";
    private static final String LITIGATION_BDBH_TITLE = "\u4eac\u4e1c\u5b89\u8054\u51fa\u5177\u7684\u4fdd\u5168\u4e1a\u52a1\uff0c\u4fdd\u5355\u3001\u4fdd\u51fd\u81ea\u52a8\u4f20\u8f93\u81f3\u6700\u9ad8\u9662\u7cfb\u7edf\uff0c\u4f20\u9001\u56de\u6267\u90ae\u4ef6\u63d0\u793a";
    private static final Map<String, String> PLANCODE_TO_APPLY_TITLE = new HashMap();
    private static final Map<String, String> PLANCODE_TO_APPLY_CONTENT = new HashMap();
    private static final Map<String, String> PLANCODE_TO_CODE = new HashMap();
    @Value(value="${email.form}")
    private String form;
    @Value(value="${email.isTest}")
    private String isTest;
    private static final String CONFIG_CODE = "litigation_email_send_";
    @Autowired
    private ApisBusiEmailSendLogMapper emailSendLogMapper;
    @Autowired
    private ApisChannelConfigsMapper apisChannelConfigsMapper;

    public EmailCommonUtil(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void saveEmailSendLog(String subject, String content, List<String> emailTo, List<String> emailCc) throws ApisBusinessException {
        if (emailTo == null || emailTo.size() == 0) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10508.getValue(), ChannelErrorCodeEnum.ERR_C10508.getKey());
        }
        ApisBusiEmailSendLog apisBusiEmailSendLog = new ApisBusiEmailSendLog(subject, content, this.appendString(emailTo), this.appendString(emailCc));
        this.emailSendLogMapper.insert((Object)apisBusiEmailSendLog);
    }

    public String appendString(List<String> request) {
        String result = "";
        for (String s : request) {
            result = result + s;
            result = result + ",";
        }
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public List<List<String>> getSendPerson(String planCode, String appType) {
        QueryWrapper apisChannelConfigsQueryWrapper = new QueryWrapper();
        String valuePrefix = CONFIG_CODE;
        valuePrefix = PLANCODE_TO_CODE.getOrDefault(planCode, valuePrefix);
        apisChannelConfigsQueryWrapper.eq((Object)"config_code", (Object)(valuePrefix + appType));
        List emailConfigList = this.apisChannelConfigsMapper.selectList((Wrapper)apisChannelConfigsQueryWrapper);
        List toList = emailConfigList.stream().filter(f -> "to".equals(f.getValueType())).map(ApisChannelConfigs::getConfigValue).collect(Collectors.toList());
        List ccList = emailConfigList.stream().filter(f -> "cc".equals(f.getValueType())).map(ApisChannelConfigs::getConfigValue).collect(Collectors.toList());
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        result.add(toList);
        result.add(ccList);
        return result;
    }

    public boolean sendEmail(String subject, String content, String emailTo, String emailCc) {
        try {
            SimpleMailMessage mail = new SimpleMailMessage();
            mail.setFrom(this.form);
            log.warn("\u53d1\u4ef6\u4eba\uff1a{}", (Object)this.form);
            String[] to = emailTo.split(",");
            mail.setTo(to);
            if (StringUtils.isNotEmpty((CharSequence)emailCc)) {
                String[] cc = emailCc.split(",");
                mail.setCc(cc);
            }
            mail.setSubject(subject);
            mail.setText(content);
            this.mailSender.send(mail);
        }
        catch (Exception e) {
            log.warn("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u6807\u9898\uff1a{}\uff0c\u6b63\u6587\uff1a{}\u3002\u9519\u8bef\u4fe1\u606f\uff1a", new Object[]{subject, content, e});
            return false;
        }
        return true;
    }

    public boolean sendEmailHtml(String subject, String content, String emailTo, String emailCc) {
        try {
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            messageHelper.setFrom(this.form);
            log.warn("\u53d1\u4ef6\u4eba\uff1a{}", (Object)this.form);
            String[] to = emailTo.split(";");
            messageHelper.setTo(to);
            if (StringUtils.isNotEmpty((CharSequence)emailCc)) {
                String[] cc = emailCc.split(";");
                messageHelper.setCc(cc);
            }
            messageHelper.setSubject(subject);
            messageHelper.setText(content, true);
            this.mailSender.send(mimeMessage);
        }
        catch (Exception e) {
            log.warn("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u6807\u9898\uff1a{}\uff0c\u6b63\u6587\uff1a{}\u3002\u9519\u8bef\u4fe1\u606f\uff1a", new Object[]{subject, content, e});
            return false;
        }
        return true;
    }

    public void saveLitigationSurrenderEmailSend(String policyNo, String insureName, String insurePhone) throws ApisBusinessException {
        String content = "\u60a8\u597d\uff1a\n\u9000\u4fdd\u5df2\u5ba1\u6838\uff0c\u56e0\u5ba2\u6237\u6d89\u53ca\u6279\u589e/\u51cf\u4fdd\u8d39\uff0c\u8bf7\u81f4\u7535\u5ba2\u6237\u63d0\u4ea4\u6279\u6539\u9000\u7533\u8bf7\u4e66\uff0c\u786e\u8ba4\u9000\u4fdd\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u6ce8\u610f\u9700\u9000\u4fdd\u81f3\u6295\u4fdd\u4eba\u8d26\u6237\uff0c\u5e76\u8bf7\u5ba2\u6237\u5c3d\u91cf\u63d0\u4ea4\u6295\u4fdd\u65f6\u7684\u6253\u6b3e\u51ed\u8bc1\uff0c\u5ba2\u6237\u63d0\u4ea4\u540e\u8bf7\u8f6c\u81f3LS\u4fa7\u8ddf\u8fdb\u5904\u7406\uff0c\u8c22\u8c22\uff01\n\u4fdd\u5355\u53f7\uff1aXXX\n\u5ba2\u6237\u8054\u7cfb\u65b9\u5f0f\uff1aXXX\n\u5ba2\u6237\u540d\u79f0\uff1aDDD";
        content = content.replaceFirst("XXX", policyNo);
        content = content.replaceAll("XXX", insurePhone);
        content = content.replaceFirst("DDD", insureName);
        List person = this.getSendPerson("", "notRefund");
        String subject = "\u3010\u9700\u5904\u7406\u3011\u5ba2\u6237\u9000\u4fdd\u8d26\u6237\u786e\u8ba4";
        if ("Y".equals(this.isTest)) {
            subject = subject + "\uff08\u6d4b\u8bd5\uff09";
        }
        this.saveEmailSendLog(subject, content, (List)person.get(0), (List)person.get(1));
    }

    public void saveLitigationApplyEmailSend(String planCode, String userName, String proposalNo, String orderNo) throws ApisBusinessException {
        String content = "\u7533\u8bf7\u4ebaXXX\u901a\u8fc7\u6700\u9ad8\u9662\u201c\u4eba\u6c11\u6cd5\u9662\u7f51\u4e0a\u4fdd\u5168\u7cfb\u7edf\u201d\u63d0\u4ea4\u4e86\u65b0\u7684\u8bc9\u8bbc\u7533\u8bf7\u6750\u6599\uff0c\u4e1a\u52a1\u53f7\u4e3a\uff1aXXX\uff0c\u62c5\u4fddid\u4e3a\uff1aDDD\uff0c\u8bf7\u60a8\u5c3d\u5feb\u5ba1\u6838\uff01";
        content = PLANCODE_TO_APPLY_CONTENT.getOrDefault(planCode, content);
        content = content.replaceFirst("XXX", userName);
        content = content.replaceAll("XXX", proposalNo);
        content = content.replaceFirst("DDD", orderNo);
        List person = this.getSendPerson(planCode, "apply");
        String subject = LITIGATION_APPLY_TITLE;
        subject = PLANCODE_TO_APPLY_TITLE.getOrDefault(planCode, subject);
        if ("Y".equals(this.isTest)) {
            subject = subject + "\uff08\u6d4b\u8bd5\uff09";
        }
        this.saveEmailSendLog(subject, content, (List)person.get(0), (List)person.get(1));
    }

    public void saveLitigationBdbhEmailSendLog(String policyRef) {
        String content = "\u4fdd\u5355\u53f7\u4e3aXXX\u7684\u4fdd\u51fd\u3001\u4fdd\u5355\u5df2\u4f20\u8f93\u81f3\u6700\u9ad8\u9662\u201c\u4eba\u6c11\u6cd5\u9662\u7f51\u4e0a\u4fdd\u5168\u7cfb\u7edf\u201d\uff0c\u4f20\u8f93\u72b6\u6001\uff1aXXX";
        content = content.replaceFirst("XXX", policyRef);
        content = content.replaceAll("XXX", "\u6210\u529f");
        List person = this.getSendPerson("", "bdbh");
        try {
            String subject = LITIGATION_BDBH_TITLE;
            if ("Y".equals(this.isTest)) {
                subject = subject + "\uff08\u6d4b\u8bd5\uff09";
            }
            this.saveEmailSendLog(subject, content, (List)person.get(0), (List)person.get(1));
        }
        catch (ApisBusinessException e) {
            log.error("\u5355\u4fdd\u51fd\u63a8\u9001\u6210\u529f\u540e\u6dfb\u52a0\u5230\u90ae\u4ef6\u53d1\u9001\u8868\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public String getLitigationEmailOpen() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)"litigation_email_send_open");
        ApisChannelConfigs configs = (ApisChannelConfigs)this.apisChannelConfigsMapper.selectOne((Wrapper)queryWrapper);
        log.warn("\u90ae\u4ef6\u53d1\u9001\u5f00\u5173 = {}", (Object)configs);
        if (configs == null) {
            return "0";
        }
        return configs.getConfigValue();
    }

    public static String templateReplace(String template, Map<String, Object> map) {
        String regEx = "((?<=\\{)(\\w+)(?=\\}))";
        Matcher matcher = Pattern.compile(regEx).matcher(template);
        while (matcher.find()) {
            String key = matcher.group();
            String value = map.get(key) != null ? map.get(key) + "" : "\u65e0";
            template = template.replaceAll("\\{" + key + "\\}", value);
        }
        return template;
    }

    static {
        PLANCODE_TO_APPLY_TITLE.put("ZR-SSBQ-CDFY-XY-2C", "\u6838\u4fdd\u901a\u77e5-\u7cbe\u53cb\u8bc9\u8d23");
        PLANCODE_TO_APPLY_CONTENT.put("ZR-SSBQ-CDFY-XY-2C", "\u7533\u8bf7\u4ebaXXX\u901a\u8fc7\u7cbe\u53cb\u8bc9\u8d23\u5e73\u53f0\u63d0\u4ea4\u4e86\u65b0\u7684\u8bc9\u8bbc\u7533\u8bf7\u6750\u6599\uff0c\u4e1a\u52a1\u53f7\u4e3a\uff1aXXX\uff0c\u62c5\u4fddid\u4e3a\uff1aDDD\uff0c\u8bf7\u60a8\u5c3d\u5feb\u5ba1\u6838\uff01");
        PLANCODE_TO_CODE.put("ZR-SSBQ-CDFY-XY-2C", "jingyou_email_send_");
    }
}

