/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderCalculateHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.IdNumberUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RedisTemplateUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.BaseCodeConvertUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ImgNode;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.BeneficiaryDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CommissionDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CoverageDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgFileDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemEmployeeDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemPropertyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.JdUserVerify.JdUserVerifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.JdUserVerify.JdUserVerifyResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.LimitDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.SalesDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.UwInfoQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.UwInfoQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.CommissionQueryDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.resp.AgentQueryResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.resp.SaleResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiReqmsgLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiReqmsgLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationKind;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationLimit;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationClauseKindFactoryMapper;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationKindMapper;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationLimitMapper;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.GeneralRegxs;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.constants.ApisCommonConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiProperties;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiServProperties;
import com.jdaz.sinosoftgz.coreapi.common.factory.CoreDtoConverterFactory;
import com.jdaz.sinosoftgz.coreapi.common.handler.CoreDtoConverter;
import com.jdaz.sinosoftgz.coreapi.h5img.MediaUploadApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import com.sinosoft.image.client.dto.ImgBatchUploadMetaDTO;
import com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO;
import com.sinosoft.image.client.dto.ImgBusiDTO;
import com.sinosoft.image.client.dto.RequestHeadDTO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import sinosoftgz.utils.data.DateUtils;
import sun.misc.BASE64Encoder;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class EmployeeImageUploadUtil {
    private Logger log = LoggerFactory.getLogger(EmployeeImageUploadUtil.class);
    @Autowired
    CoreApiProperties coreApiProperties;
    @Autowired
    CoreDtoConverterFactory coreDtoConverterFactory;
    @Autowired
    MediaUploadUtil mediaUploadUtil;
    @Autowired
    ApisBusiReqmsgLogService apisBusiReqmsgLogService;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisPfpRationMainService apisPfpRationMainService;
    @Autowired
    ApisPfpRationKindMapper apisPfpRationKindMapper;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    private ApisPfpRationLimitMapper apisPfpRationLimitMapper;
    @Autowired
    StanderCalculateHandler standerCalculateHandler;
    @Autowired
    ApisPfpRationClauseKindFactoryMapper apisPfpRationClauseKindFactoryMapper;
    @Autowired
    BaseCodeConvertUtils baseCodeConvertUtils;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private ApisBusinessService apisBusinessService;
    @Autowired
    private RedisTemplateUtil redisTemplateUtil;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    private IdNumberUtil idNumberUtil;
    @Autowired
    MediaUploadApi mediaUploadApi;
    @Value(value="${system.backSignSwitch}")
    private String backSignSwitch;
    private static String[] PLAN_YEAR_ARRAY = new String[]{"4", "7", "8", "10", "11"};
    public static String empClaseCode = "C00066";
    public static String empClaseCode65 = "C00065";
    public static String medicalLiab = "0041";
    public static String stopWorkCompensation = "0047";
    public static String hospitAllwance = "0050";
    public static String deathLiab = "0036";
    public static String injuryLiab = "0044";
    public static String HOUR_KIND_CODE_LIAB = "0411";
    public static String HOUR_KIND_CODE_CODE = "C00377";
    public static Map<String, String> imgTypeNameMap = new HashMap();

    public void dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (StringUtils.isEmpty((CharSequence)request.getHeader().getBusinessKey())) {
            request.getHeader().setBusinessKey(UUID.fastUUID().toString().replaceAll("-", ""));
        }
        ApisChannelConfigs apisChannelConfigs = this.dataCompletionUtil.getConfigByChannelCode(request.getHeader().getChannelCode(), "employee_not_valid_agent");
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List itemMainDTOS = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList();
        if (ObjectUtils.isEmpty((Object)itemMainDTOS) && apisChannelConfigs == null) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "planList"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtils.isEmpty((Object)itemMainDTOS)) {
            this.settleCoverageInfo(request);
        } else {
            this.settleCoverageInfoItemMain(request);
        }
        TimeInterval timer = DateUtil.timer();
        String planCode = ((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        ApisPfpRationMain apisPfpRationMain = this.getApisPfpRationMainInfo(planCode, "2");
        this.log.warn("\u83b7\u53d6\u5546\u54c1\u4fe1\u606f\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.log.warn("\u7eed\u4fdd\u524d\u7f6e\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        List saleResponseDTOList = this.dataCompletionMainDTO(quotePriceDTO, request, apisPfpRationMain);
        this.log.warn("\u8865\u5168\u6295\u4fdd\u516c\u5171\u4fe1\u606f\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.dataCompletionAppliClientDTO(quotePriceDTO);
        this.log.warn("\u8865\u5168\u6295\u4fdd\u4eba\u4fe1\u606f\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getInsuredList())) {
            this.dataCompletionInsuredDTO(quotePriceDTO);
            this.log.warn("\u8865\u5168\u88ab\u4fdd\u4eba\u4fe1\u606f\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        }
        this.dataCompletionSalesDTO(request, saleResponseDTOList);
        this.log.warn("\u8865\u5168\u9500\u552e\u4fe1\u606f\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.dataCompletionCoverageDTO(request);
        this.log.warn("\u8865\u5168\u4fdd\u5355\u4fdd\u969c\u4fe1\u606f\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.dataCompletionLimitInfo(request, apisPfpRationMain);
        this.log.warn("\u8865\u5168\u5206\u671f\u4fe1\u606f\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
    }

    public void settleCoverageInfo(StanderRequest request) throws ApisBusinessException {
        ArrayList<ItemMainDTO> itemMainDTOList = new ArrayList<ItemMainDTO>();
        CoverageDTO coverageDTO = CoverageDTO.builder().build();
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation().setIsExistImgId(ApisCommonConstantsEnum.MASTER_POLICY_FALSE.getKey());
        List itemEmployeeDTOS = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation().getEmployeeInformationList();
        HashSet<Integer> setList = new HashSet<Integer>();
        for (ItemEmployeeDTO itemEmployeeDTO : itemEmployeeDTOS) {
            if (itemEmployeeDTO.getItemNo() == null) {
                itemEmployeeDTO.setItemNo(Integer.valueOf(1));
            }
            setList.add(itemEmployeeDTO.getItemNo());
        }
        BigDecimal totalPremium = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Integer itemNo : setList) {
            int insuredCount = 0;
            BigDecimal sumAmount = BigDecimal.ZERO;
            BigDecimal sumPremium = BigDecimal.ZERO;
            ItemMainDTO itemMainDTO = ItemMainDTO.builder().build();
            itemMainDTO.setItemNo(itemNo);
            for (ItemEmployeeDTO itemEmployeeDTO : itemEmployeeDTOS) {
                if (itemEmployeeDTO.getItemNo() != itemNo) continue;
                itemMainDTO.setGoodsCode(itemEmployeeDTO.getPlanCode());
                if (ObjectUtils.isNotEmpty((Object)itemEmployeeDTO.getLimits())) {
                    sumAmount = sumAmount.add(itemEmployeeDTO.getLimits());
                    totalAmount = totalAmount.add(itemEmployeeDTO.getLimits());
                    if (ObjectUtils.isNotEmpty((Object)itemEmployeeDTO.getBasePremium())) {
                        totalPremium = totalPremium.add(itemEmployeeDTO.getBasePremium());
                        itemMainDTO.setUnitPremium(Double.valueOf(itemEmployeeDTO.getBasePremium().doubleValue()));
                    }
                    itemMainDTO.setUnitAmount(Double.valueOf(itemEmployeeDTO.getLimits().doubleValue()));
                }
                ++insuredCount;
            }
            itemMainDTO.setSumPremium(Double.valueOf(sumPremium.doubleValue()));
            itemMainDTO.setSumInsured(Double.valueOf(sumAmount.doubleValue()));
            itemMainDTOList.add(itemMainDTO);
        }
        if (request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getSumAmount() == null || request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getSumAmount() == 0.0) {
            request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setSumAmount(Double.valueOf(totalAmount.doubleValue()));
        }
        if (request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getSumPremium() == null || request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getSumPremium() == 0.0) {
            // empty if block
        }
        coverageDTO.setItemList(itemMainDTOList);
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().setCoverage(coverageDTO);
    }

    public void settleCoverageInfoItemMain(StanderRequest request) throws ApisBusinessException {
        ArrayList<ItemMainDTO> itemMainDTOList = new ArrayList<ItemMainDTO>();
        CoverageDTO coverageDTO = CoverageDTO.builder().build();
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation().setIsExistImgId(ApisCommonConstantsEnum.MASTER_POLICY_FALSE.getKey());
        List itemEmployeeDTOS = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation().getEmployeeInformationList();
        List itemMainDTOS = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList();
        BigDecimal totalPremium = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (ItemMainDTO itemMainDTO : itemMainDTOS) {
            BigDecimal sumAmount = BigDecimal.ZERO;
            BigDecimal sumPremium = BigDecimal.ZERO;
            for (ItemEmployeeDTO itemEmployeeDTO : itemEmployeeDTOS) {
                if (itemEmployeeDTO.getItemNo() != itemMainDTO.getItemNo() || !ObjectUtils.isNotEmpty((Object)itemEmployeeDTO.getLimits())) continue;
                sumAmount = sumAmount.add(itemEmployeeDTO.getLimits());
                totalAmount = totalAmount.add(itemEmployeeDTO.getLimits());
                if (ObjectUtils.isNotEmpty((Object)itemEmployeeDTO.getBasePremium())) {
                    totalPremium = totalPremium.add(itemEmployeeDTO.getBasePremium());
                    itemMainDTO.setUnitPremium(Double.valueOf(itemEmployeeDTO.getBasePremium().doubleValue()));
                }
                itemMainDTO.setUnitAmount(Double.valueOf(itemEmployeeDTO.getLimits().doubleValue()));
            }
            itemMainDTO.setSumPremium(Double.valueOf(sumPremium.doubleValue()));
            itemMainDTO.setSumInsured(Double.valueOf(sumAmount.doubleValue()));
            itemMainDTOList.add(itemMainDTO);
        }
        if (request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getSumAmount() == null || request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getSumAmount() == 0.0) {
            request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setSumAmount(Double.valueOf(totalAmount.doubleValue()));
        }
        if (request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getSumPremium() == null || request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getSumPremium() == 0.0) {
            // empty if block
        }
        coverageDTO.setItemList(itemMainDTOList);
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().setCoverage(coverageDTO);
    }

    public void validateRquest(StanderRequest standerRequest) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        String planCode = ((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        ApisPfpRationMain apisPfpRationMain = this.getApisPfpRationMainInfo(planCode, "2");
        ArrayList<ApisPfpRationMain> apisPfpRationMainList = new ArrayList<ApisPfpRationMain>();
        for (ItemMainDTO item : quotePriceDTO.getCoverage().getItemList()) {
            ApisPfpRationMain apm = this.getApisPfpRationMainInfo(item.getGoodsCode(), "2");
            apisPfpRationMainList.add(apm);
        }
        this.validNull(standerRequest, apisPfpRationMain);
        this.validFormat(standerRequest, apisPfpRationMain);
        this.validProduct(standerRequest, apisPfpRationMainList);
        for (ApisPfpRationMain apm : apisPfpRationMainList) {
            this.validJdUser(standerRequest, apm);
            this.validJdAddr(standerRequest, apisPfpRationMain);
        }
    }

    private void validJdAddr(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO;
        List insuredIdvDTOList;
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
        apisChannelConfigsCondition.setConfigCode("JD_ADDR_VERIFICATION");
        apisChannelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs) && ObjectUtil.isNotEmpty((Object)(insuredIdvDTOList = (quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice()).getCoverage().getInsuredIdvList())) && insuredIdvDTOList.size() > 0) {
            ApisPfpRationMain apisPfpRationMainP = this.getApisPfpRationMainInfo(apisPfpRationMain.getRationCode(), "1");
            for (InsuredIdvDTO insuredDTO : insuredIdvDTOList) {
                if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getResideAddressId())) {
                    UwInfoQueryRequest jdAddrVerifyRequest = UwInfoQueryRequest.builder().build();
                    jdAddrVerifyRequest.setSerialNumber(java.util.UUID.randomUUID().toString());
                    jdAddrVerifyRequest.setRequestType("UW02");
                    jdAddrVerifyRequest.setAgencyCode(standerRequest.getHeader().getChannelCode());
                    jdAddrVerifyRequest.setResideAddressId(insuredDTO.getResideAddressId());
                    jdAddrVerifyRequest.setProductName(apisPfpRationMainP.getRationName());
                    UwInfoQueryResponse uwInfoQueryResponse = this.coreInsureApi.uwInfoQuery(jdAddrVerifyRequest, "uwInfoQueryXmlService");
                    if (ObjectUtil.isEmpty((Object)uwInfoQueryResponse)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10480.getValue(), ChannelErrorCodeEnum.ERR_C10480.getKey());
                    }
                    if ("N".equals(uwInfoQueryResponse.getResult().getIsAddressRulePass())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10306.getValue(), ChannelErrorCodeEnum.ERR_C10306.getKey());
                    }
                    insuredDTO.setInsuredAddress(uwInfoQueryResponse.getResult().getResideFullAddress() + "," + insuredDTO.getInsuredAddress());
                    continue;
                }
                if (!"0".equals(quotePriceDTO.getMain().getRenewalFlag()) || "underwrit".equals(standerRequest.getHeader().getBussinessType()) || !StringUtils.isEmpty((CharSequence)quotePriceDTO.getMain().getRenewalPolicyNo())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10303.getValue(), ChannelErrorCodeEnum.ERR_C10303.getKey());
            }
        }
    }

    private void validJdUser(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO;
        List insuredIdvDTOList;
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setConfigCode("verifyJdUser");
        apisChannelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        MainDTO mainDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        boolean flag = "underwrit".equals(standerRequest.getHeader().getBussinessType());
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs) && ObjectUtil.isNotEmpty((Object)(insuredIdvDTOList = (quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice()).getCoverage().getInsuredIdvList())) && insuredIdvDTOList.size() > 0) {
            for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
                JdUserVerifyRequest jdUserVerifyRequest = JdUserVerifyRequest.builder().idNumber(insuredIdvDTO.getIdentifyNumber()).authDays("90").build();
                JdUserVerifyResponse jdUserVerifyResponse = this.coreInsureApi.verifyJdUser(jdUserVerifyRequest);
                if (ObjectUtil.isEmpty((Object)jdUserVerifyResponse)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10362.getValue(), ChannelErrorCodeEnum.ERR_C10362.getKey());
                }
                if ("N".equals(jdUserVerifyResponse.getResult().getStrategyResult())) {
                    if (flag) {
                        mainDTO.setJdUserVerifyFlag("0");
                        insuredIdvDTO.setPinFlag("N");
                        continue;
                    }
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10363.getValue(), ChannelErrorCodeEnum.ERR_C10363.getKey());
                }
                if (flag) {
                    mainDTO.setJdUserVerifyFlag("1");
                }
                insuredIdvDTO.setPinFlag("Y");
            }
        }
    }

    public void validProduct(StanderRequest standerRequest, List<ApisPfpRationMain> apisPfpRationMainList) throws ApisBusinessException {
        ApisPfpRationMain apisPfpRationMain = apisPfpRationMainList.get(0);
        StanderHeader standerHeader = standerRequest.getHeader();
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredList = quotePriceDTO.getInsuredList();
        List insuredIdvDTOList = quotePriceDTO.getCoverage().getInsuredIdvList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        Date startDate = mainDTO.getStartDate();
        long lessFifty = 0L;
        boolean parentCount = false;
        boolean childCount = false;
        boolean myCount = false;
        boolean spouseCount = false;
        boolean juveniles = false;
        boolean adult = false;
        String caclMethod = "";
        if (!"03".equals(apisPfpRationMain.getRationRateType())) {
            caclMethod = this.queryCalcType(apisPfpRationMain.getRationCode());
        }
        if (startDate.after(mainDTO.getEndDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10067.getValue(), ChannelErrorCodeEnum.ERR_C10067.getKey());
        }
        List employeeInformationList = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation().getEmployeeInformationList();
        List itemMainDTOS = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList();
        HashSet<Integer> setList = new HashSet<Integer>();
        for (ItemEmployeeDTO itemEmployeeDTO : employeeInformationList) {
            setList.add(itemEmployeeDTO.getItemNo());
        }
        if (itemMainDTOS.size() != setList.size()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10688.getValue(), ChannelErrorCodeEnum.ERR_C10688.getKey());
        }
        ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("backSign");
        channelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
        ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (ObjectUtil.isEmpty((Object)channelConfigs) && startDate.before(new Date()) && "1".equals(this.backSignSwitch)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10035.getValue(), ChannelErrorCodeEnum.ERR_C10035.getKey());
        }
        if (!EmployeeImageUploadUtil.isOutOneYear((Date)startDate, (Date)mainDTO.getEndDate(), (boolean)false)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10068.getValue(), ChannelErrorCodeEnum.ERR_C10068.getKey());
        }
        for (AppliClientDTO appliClientDTO : appliClientList) {
            if ("1".equals(appliClientDTO.getInsuredType())) {
                long year;
                ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
                apisChannelConfigsCondition.setConfigCode("MINOR_INSURE_PLANS");
                apisChannelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
                apisChannelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
                ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
                if (ObjectUtil.isEmpty((Object)apisChannelConfigs) && ObjectUtil.isNotEmpty((Object)appliClientDTO.getBirthday()) && (year = (long)this.calculateAge(startDate, appliClientDTO.getBirthday())) < 18L) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10124.getValue(), ChannelErrorCodeEnum.ERR_C10124.getKey());
                }
            }
            if (appliClientDTO.getInsuredName().indexOf("\u62c6") <= 0 && appliClientDTO.getInsuredName().indexOf("\u758f\u6d5a") <= 0 && appliClientDTO.getInsuredName().indexOf("\u5371\u9669\u54c1") <= 0 && appliClientDTO.getInsuredName().indexOf("\u77f3\u6cb9") <= 0 && appliClientDTO.getInsuredName().indexOf("\u7535\u68af") <= 0 && appliClientDTO.getInsuredName().indexOf("\u94c1\u5854") <= 0) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10677.getValue(), ChannelErrorCodeEnum.ERR_C10677.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)insuredList) && insuredList.size() > 0) {
            for (InsuredDTO insuredDTO : insuredList) {
                String[] arr;
                String birthDay;
                String birthDateStr;
                if ("01".equals(insuredDTO.getIdentifyType()) && !(birthDateStr = IdcardUtil.getBirth((String)insuredDTO.getIdentifyNumber())).equals(birthDay = DateUtils.dateToStr((Date)insuredDTO.getBirthday(), (String)"yyyyMMdd"))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10267.getValue(), ChannelErrorCodeEnum.ERR_C10267.getKey());
                }
                if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getRelationToAppnt()) && StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getAppliRelation().trim()) && !Arrays.asList(arr = apisPfpRationMain.getAppliRelation().trim().split(",")).contains(insuredDTO.getRelationToAppnt())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10135.getValue().replace("##", apisPfpRationMain.getRationCode()), ChannelErrorCodeEnum.ERR_C10135.getKey());
                }
                if (!Arrays.asList(PLAN_YEAR_ARRAY).contains(caclMethod) || EmployeeImageUploadUtil.isOutOneYear((Date)startDate, (Date)mainDTO.getEndDate(), (boolean)true) || !"01".equals(apisPfpRationMain.getPaymentType())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10043.getValue(), ChannelErrorCodeEnum.ERR_C10043.getKey());
            }
        }
        channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
        channelConfigsCondition.setConfigCode("ONE_STEP_ISSUE_CODE");
        ApisChannelConfigs apisChannelConfigsO = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (StringUtils.isNotEmpty((CharSequence)mainDTO.getOutPaymentType())) {
            if ("0".equals(mainDTO.getJFeeFlag())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10471.getValue(), ChannelErrorCodeEnum.ERR_C10471.getKey());
            }
            if (ObjectUtil.isEmpty((Object)apisChannelConfigsO)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10443.getValue(), ChannelErrorCodeEnum.ERR_C10443.getKey());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigsO) && "1".equals(mainDTO.getStepFlag()) && (StringUtils.isEmpty((CharSequence)mainDTO.getOutPaymentType()) || StringUtils.isEmpty((CharSequence)mainDTO.getAccountCode())) && "1".equals(mainDTO.getRenewalFlag()) && ObjectUtil.isNotEmpty((Object)standerRequest.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform()) && !standerRequest.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform().booleanValue()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10470.getValue(), ChannelErrorCodeEnum.ERR_C10470.getKey());
        }
    }

    public static boolean isOutOneYear(Date start, Date end, boolean yearFlag) {
        long yearDays = 365L;
        if (start.after(end)) {
            return false;
        }
        Calendar startDay = Calendar.getInstance();
        Calendar endDay = Calendar.getInstance();
        startDay.setTime(start);
        endDay.setTime(end);
        long month = startDay.get(2) + 1;
        int year = month < 3L ? startDay.get(1) : endDay.get(1);
        if (DateUtil.isLeapYear((int)year)) {
            yearDays = 366L;
        }
        endDay.add(12, 1);
        long time = endDay.getTimeInMillis() - startDay.getTimeInMillis();
        long yearTime = DateUnit.DAY.getMillis() * yearDays + DateUnit.MINUTE.getMillis();
        if (time > yearTime) {
            return false;
        }
        return !yearFlag || yearTime - time <= DateUnit.MINUTE.getMillis();
    }

    public void validFormat(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        String regexEnName;
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        StanderHeader header = standerRequest.getHeader();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredList = quotePriceDTO.getInsuredList();
        List insuredIdvDTOList = quotePriceDTO.getCoverage().getInsuredIdvList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        if (!DateUtils.dateToStr((Date)mainDTO.getStartDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "startDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
        }
        if (!DateUtils.dateToStr((Date)mainDTO.getEndDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "endDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
        }
        String regexName = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_NAME", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        if (StringUtils.isBlank((CharSequence)regexName) || "NoData".equalsIgnoreCase(regexName)) {
            regexName = GeneralRegxs.Name_2;
        }
        if (StringUtils.isBlank((CharSequence)(regexEnName = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_NAME_EN", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code))) || "NoData".equalsIgnoreCase(regexEnName)) {
            regexEnName = GeneralRegxs.Ename;
        }
        boolean isValidEname = StringUtils.isNotBlank((CharSequence)regexEnName) && !"NoCheck".equals(regexEnName);
        String regexContactInfo = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_CONTACT_INFO", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        String regexMobileNo = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_MOBILE_NO", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        String regexContactPhone = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_CONTACT_PHONE", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        boolean isValidContactInfoFormat = StringUtils.isNotBlank((CharSequence)regexContactInfo) && !"NoData".equalsIgnoreCase(regexContactInfo) && !"NoCheck".equalsIgnoreCase(regexContactInfo);
        boolean isValidMobileNoFormat = StringUtils.isNotBlank((CharSequence)regexMobileNo) && !"NoData".equalsIgnoreCase(regexMobileNo) && !"NoCheck".equalsIgnoreCase(regexMobileNo);
        boolean isValidContactPhone = StringUtils.isNotBlank((CharSequence)regexContactPhone) && !"NoData".equalsIgnoreCase(regexContactPhone) && !"NoCheck".equalsIgnoreCase(regexContactPhone);
        for (AppliClientDTO appliClientDTO : appliClientList) {
            if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getInsuredEname()) && isValidEname && !appliClientDTO.getInsuredEname().trim().matches(regexEnName)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10619.getValue().replaceFirst("##", appliClientDTO.getInsuredEname()), ChannelErrorCodeEnum.ERR_C10619.getKey());
            }
            if ("1".equals(appliClientDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_PERSONAL).contains(appliClientDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("2".equals(appliClientDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_COMPANY).contains(appliClientDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("01".equals(appliClientDTO.getIdentifyType()) || "13".equals(appliClientDTO.getIdentifyType())) {
                if (StringUtils.isNotBlank((CharSequence)appliClientDTO.getIdentifyNumber()) && !IdcardUtil.isValidCard((String)appliClientDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10073.getValue().replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10073.getKey());
                }
                String birthDateStr = IdcardUtil.getBirth((String)appliClientDTO.getIdentifyNumber());
                if (ObjectUtil.isNotEmpty((Object)appliClientDTO.getBirthday())) {
                    String birthDay = DateUtils.dateToStr((Date)appliClientDTO.getBirthday(), (String)"yyyyMMdd");
                    if (!birthDateStr.equals(birthDay)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10240.getValue().replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10240.getKey());
                    }
                } else {
                    try {
                        appliClientDTO.setBirthday(DateUtils.parseToDate((String)birthDateStr, (String)"yyyyMMdd"));
                    }
                    catch (Exception e) {
                        this.log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getSex())) {
                    appliClientDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)appliClientDTO.getIdentifyNumber()) == 1 ? 1 : 2));
                } else if (!appliClientDTO.getSex().equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)appliClientDTO.getIdentifyNumber()) == 1 ? 1 : 2))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10616.getValue(), ChannelErrorCodeEnum.ERR_C10616.getKey());
                }
            } else {
                IdNumberUtil.ClientType clientType = null;
                if ("1".equals(appliClientDTO.getInsuredType())) {
                    clientType = IdNumberUtil.ClientType.PERSONAL;
                } else if ("2".equals(appliClientDTO.getInsuredType())) {
                    clientType = IdNumberUtil.ClientType.CLIENT;
                }
                ApisChannelConfigs apisChannelConfigs = this.getConfigByChannelCode(standerRequest.getHeader().getChannelCode(), "employee_not_valid_agent");
                if (apisChannelConfigs == null) {
                    this.validateIdNumberByIdType(appliClientDTO.getIdentifyType(), appliClientDTO.getIdentifyNumber(), mainDTO.getRiskCode(), IdNumberUtil.PersonnelType.HOLDER, clientType, header.getChannelCode(), header.getUserCode());
                }
            }
            if (isValidContactInfoFormat) {
                if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getMobile()) && !appliClientDTO.getMobile().matches(regexContactInfo)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", appliClientDTO.getMobile()), ChannelErrorCodeEnum.ERR_C10618.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getContactPhone()) && isValidMobileNoFormat && StringUtils.isNotEmpty((CharSequence)appliClientDTO.getMobile()) && !appliClientDTO.getMobile().matches(regexMobileNo)) {
                    appliClientDTO.setContactPhone(appliClientDTO.getMobile());
                    appliClientDTO.setMobile(null);
                }
            }
            if (isValidContactPhone && StringUtils.isNotEmpty((CharSequence)appliClientDTO.getContactPhone()) && !appliClientDTO.getContactPhone().matches(regexContactPhone)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", appliClientDTO.getContactPhone()), ChannelErrorCodeEnum.ERR_C10618.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getEmail()) && !appliClientDTO.getEmail().matches(GeneralRegxs.Email)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10132.getValue(), ChannelErrorCodeEnum.ERR_C10132.getKey());
            }
            if (!StringUtils.isNotEmpty((CharSequence)appliClientDTO.getTaxPayerId()) || appliClientDTO.getTaxPayerId().matches(GeneralRegxs.TaxpayerId)) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10478.getValue(), ChannelErrorCodeEnum.ERR_C10478.getKey());
        }
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setConfigCode("OCCUPATION_NULL");
        apisChannelConfigsCondition.setChannelCode(standerRequest.getHeader().getChannelCode());
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (InsuredDTO insuredDTO : insuredList) {
            if ("1".equals(insuredDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_PERSONAL).contains(insuredDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("2".equals(insuredDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_COMPANY).contains(insuredDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if (map.containsKey(insuredDTO.getInsuredIDCache())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10221.getValue().replace("##", insuredDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10221.getKey());
            }
            map.put(insuredDTO.getInsuredIDCache(), insuredDTO.getInsuredName());
            if (idMap.containsKey(insuredDTO.getIdentifyNumber())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10404.getValue(), ChannelErrorCodeEnum.ERR_C10404.getKey());
            }
            idMap.put(insuredDTO.getIdentifyNumber(), insuredDTO.getInsuredName());
            if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getInsuredEname()) && isValidEname && !insuredDTO.getInsuredEname().trim().matches(regexEnName)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10619.getValue().replaceFirst("##", insuredDTO.getInsuredEname()), ChannelErrorCodeEnum.ERR_C10619.getKey());
            }
            if ("01".equals(insuredDTO.getIdentifyType()) || "13".equals(insuredDTO.getIdentifyType())) {
                if (StringUtils.isNotBlank((CharSequence)insuredDTO.getIdentifyNumber()) && !IdcardUtil.isValidCard((String)insuredDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10118.getValue().replace("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10118.getKey());
                }
                String birthDateStr = IdcardUtil.getBirth((String)insuredDTO.getIdentifyNumber());
                if (!birthDateStr.equals(DateUtils.dateToStr((Date)insuredDTO.getBirthday(), (String)"yyyyMMdd"))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10119.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredDTO.getSex())) {
                    insuredDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredDTO.getIdentifyNumber()) == 1 ? 1 : 2));
                } else if (!insuredDTO.getSex().equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredDTO.getIdentifyNumber()) == 1 ? 1 : 2))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10617.getValue(), ChannelErrorCodeEnum.ERR_C10617.getKey());
                }
            } else {
                IdNumberUtil.ClientType clientType = null;
                if ("1".equals(insuredDTO.getInsuredType())) {
                    clientType = IdNumberUtil.ClientType.PERSONAL;
                } else if ("2".equals(insuredDTO.getInsuredType())) {
                    clientType = IdNumberUtil.ClientType.CLIENT;
                }
                this.validateIdNumberByIdType(insuredDTO.getIdentifyType(), insuredDTO.getIdentifyNumber(), mainDTO.getRiskCode(), IdNumberUtil.PersonnelType.INSURE, clientType, header.getChannelCode(), header.getUserCode());
            }
            if (isValidContactInfoFormat && StringUtils.isNotEmpty((CharSequence)insuredDTO.getMobile()) && !insuredDTO.getMobile().matches(regexContactInfo)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", insuredDTO.getMobile()), ChannelErrorCodeEnum.ERR_C10618.getKey());
            }
            if (isValidContactPhone && StringUtils.isNotEmpty((CharSequence)insuredDTO.getContactPhone()) && !insuredDTO.getContactPhone().matches(regexContactPhone)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", insuredDTO.getContactPhone()), ChannelErrorCodeEnum.ERR_C10618.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getEmail()) && !insuredDTO.getEmail().matches(GeneralRegxs.Email)) {
                throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u3010" + insuredDTO.getInsuredName() + "\u3011\u3010\u8bc1\u4ef6\u53f7" + insuredDTO.getIdentifyNumber() + "\u3011\u90ae\u7bb1\u3010" + insuredDTO.getEmail() + "\u3011\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4!", ChannelErrorCodeEnum.ERR_C10133.getKey());
            }
            if ("2".equals(insuredDTO.getBenefitModeCode()) && "1".equals(insuredDTO.getBenefitOrder())) {
                int sumShare = 0;
                for (BeneficiaryDTO beneficiaryDTO : insuredDTO.getBeneficiary()) {
                    int share = Integer.valueOf(beneficiaryDTO.getShare());
                    sumShare += share;
                }
                if (sumShare != 100) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10038.getValue().replace("##", insuredDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10038.getKey());
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)insuredDTO.getRelationToAppnt()) || !"01".equals(insuredDTO.getRelationToAppnt()) || insuredDTO.getInsuredName().contains(((AppliClientDTO)appliClientList.get(0)).getInsuredName()) && insuredDTO.getIdentifyNumber().equals(((AppliClientDTO)appliClientList.get(0)).getIdentifyNumber())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10138.getValue().replace("##", insuredDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10138.getKey());
        }
    }

    public void validateIdNumberByIdType(String idType, String idCard, String riskCode, IdNumberUtil.PersonnelType personType, IdNumberUtil.ClientType clientType, String channelCode, String userCode) throws ApisBusinessException {
        if (!this.idNumberUtil.whetherAllowUsingOtherDocument(idType, riskCode, personType, clientType, channelCode, userCode)) {
            String idTypeDesc = (String)BusinessConstants.idTypeDescMap.get(idType);
            if (StrUtil.isBlank((CharSequence)idTypeDesc)) {
                idTypeDesc = idType;
            }
            if (IdNumberUtil.ClientType.CLIENT == clientType) {
                if (IdNumberUtil.PersonnelType.HOLDER == personType) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10646.getValue().replaceFirst("##", idTypeDesc), ChannelErrorCodeEnum.ERR_C10646.getKey());
                }
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10645.getValue().replaceFirst("##", idTypeDesc), ChannelErrorCodeEnum.ERR_C10645.getKey());
            }
            if (IdNumberUtil.PersonnelType.HOLDER == personType) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10636.getValue().replaceFirst("##", idTypeDesc), ChannelErrorCodeEnum.ERR_C10636.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10635.getValue().replaceFirst("##", idTypeDesc), ChannelErrorCodeEnum.ERR_C10635.getKey());
        }
        if (!this.idNumberUtil.validateIdNumberByIdType(idType, idCard)) {
            if (IdNumberUtil.PersonnelType.HOLDER == personType) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10073.getValue().replaceFirst("##", idCard), ChannelErrorCodeEnum.ERR_C10073.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10078.getValue().replaceFirst("##", idCard), ChannelErrorCodeEnum.ERR_C10078.getKey());
        }
    }

    public void validNull(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        StanderHeader standerHeader = standerRequest.getHeader();
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredList = quotePriceDTO.getInsuredList();
        List insuredIdvDTOList = quotePriceDTO.getCoverage().getInsuredIdvList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        for (AppliClientDTO appliClientDTO : appliClientList) {
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInsuredType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10384.getValue(), ChannelErrorCodeEnum.ERR_C10384.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInsuredName())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10387.getValue(), ChannelErrorCodeEnum.ERR_C10387.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10082.getValue(), ChannelErrorCodeEnum.ERR_C10082.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyNumber())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10083.getValue(), ChannelErrorCodeEnum.ERR_C10083.getKey());
            }
            if ("1".equals(appliClientDTO.getReqElecFaPiao()) && StringUtils.isEmpty((CharSequence)appliClientDTO.getEmail()) && StringUtils.isEmpty((CharSequence)appliClientDTO.getMobile())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10130.getValue(), ChannelErrorCodeEnum.ERR_C10130.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getReqFaPiao()) && "1".equals(appliClientDTO.getReqFaPiao())) {
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getMailType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10070.getValue(), ChannelErrorCodeEnum.ERR_C10070.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getPhAddress())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10072.getValue(), ChannelErrorCodeEnum.ERR_C10072.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInvoiceTitle())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10071.getValue(), ChannelErrorCodeEnum.ERR_C10071.getKey());
                }
            }
            ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
            apisChannelConfigsCondition.setUserCode(standerHeader.getUserCode());
            apisChannelConfigsCondition.setConfigCode("PHONE_NOT_NULL");
            apisChannelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
            ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
            if (!ObjectUtil.isNotEmpty((Object)apisChannelConfigs) || !StringUtils.isEmpty((CharSequence)appliClientDTO.getMobile())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10129.getValue(), ChannelErrorCodeEnum.ERR_C10129.getKey());
        }
        ApisChannelConfigs configsCondition = new ApisChannelConfigs();
        configsCondition.setUserCode(standerHeader.getUserCode());
        configsCondition.setRationCode(apisPfpRationMain.getRationCode());
        configsCondition.setConfigCode("endcase_plan_code");
        if ("07".equals(apisPfpRationMain.getClassCode()) || "09".equals(apisPfpRationMain.getClassCode())) {
            for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
                if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getInsuredType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10077.getValue(), ChannelErrorCodeEnum.ERR_C10077.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getInsuredName())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10074.getValue(), ChannelErrorCodeEnum.ERR_C10074.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getIdentifyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10075.getValue(), ChannelErrorCodeEnum.ERR_C10075.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10076.getValue(), ChannelErrorCodeEnum.ERR_C10076.getKey());
                }
                if (!"1".equals(insuredIdvDTO.getInsuredType()) || !ObjectUtil.isEmpty((Object)insuredIdvDTO.getBirthday())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10080.getValue(), ChannelErrorCodeEnum.ERR_C10080.getKey());
            }
        } else {
            for (InsuredDTO insuredDTO : insuredList) {
                if (StringUtils.isEmpty((CharSequence)insuredDTO.getInsuredType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10077.getValue(), ChannelErrorCodeEnum.ERR_C10077.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredDTO.getInsuredName())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10074.getValue(), ChannelErrorCodeEnum.ERR_C10074.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredDTO.getIdentifyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10075.getValue(), ChannelErrorCodeEnum.ERR_C10075.getKey());
                }
                if (!StringUtils.isEmpty((CharSequence)insuredDTO.getIdentifyNumber())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10076.getValue(), ChannelErrorCodeEnum.ERR_C10076.getKey());
            }
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getOrderNo())) {
            throw new ApisBusinessException("\u7b2c\u4e09\u65b9\u6e20\u9053\u516c\u53f8\u4fdd\u5355\u53f7\u7801\u6216\u8005\u7b2c\u4e09\u65b9\u6e20\u9053\u516c\u53f8\u8ba2\u5355\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getStartDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10066.getValue(), ChannelErrorCodeEnum.ERR_C10066.getKey());
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getEndDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10066.getValue(), ChannelErrorCodeEnum.ERR_C10066.getKey());
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getInputDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10391.getValue(), ChannelErrorCodeEnum.ERR_C10391.getKey());
        }
    }

    public List<SaleResponseDTO> commissionQuery(QuotePriceDTO quotePriceDTO, ApisPfpRationMain apisPfpRationMain, Map userMap, StanderRequest request) throws ApisBusinessException {
        ArrayList<SaleResponseDTO> saleResponseDTOList = new ArrayList<SaleResponseDTO>();
        String bdCode = null;
        String obj = (String)DataCompletionUtil.castToClass(String.class, userMap.get("handler_code"));
        if (StringUtils.isNotEmpty((CharSequence)quotePriceDTO.getMain().getHandlerCode())) {
            bdCode = quotePriceDTO.getMain().getHandlerCode();
        } else if (StringUtils.isNotEmpty((CharSequence)obj)) {
            bdCode = obj;
        }
        CommissionQueryDTO commissionQueryDTO = new CommissionQueryDTO();
        commissionQueryDTO.setAgentCode(quotePriceDTO.getSales().getAgentCode());
        List itemMainDTOList = quotePriceDTO.getCoverage().getItemList();
        if (StringUtils.isNotEmpty((CharSequence)bdCode)) {
            commissionQueryDTO.setBdCode(bdCode);
        }
        this.giveDataCompletion(request, quotePriceDTO, commissionQueryDTO);
        commissionQueryDTO.setPlanCode(((ItemMainDTO)itemMainDTOList.get(0)).getGoodsCode());
        if (itemMainDTOList.size() > 1) {
            ApisPfpRationMain apisPfpRationMainC = this.getApisPfpRationMainInfo(((ItemMainDTO)itemMainDTOList.get(0)).getGoodsCode(), "2");
            commissionQueryDTO.setProductCode(apisPfpRationMainC.getRelateRationCode());
            commissionQueryDTO.setRiskCode(apisPfpRationMainC.getProductCode());
        } else {
            commissionQueryDTO.setProductCode(apisPfpRationMain.getRelateRationCode());
            commissionQueryDTO.setRiskCode(apisPfpRationMain.getProductCode());
        }
        AgentQueryResponseDTO commissionQueryResponseDTO = this.coreInsureApi.commissionQuery(commissionQueryDTO);
        if (!(ObjectUtil.isNotEmpty((Object)commissionQueryResponseDTO) && "0000".equals(commissionQueryResponseDTO.getHead().getAppCode()) && ObjectUtils.isNotEmpty((Object)commissionQueryResponseDTO.getData()))) {
            if (ObjectUtil.isNotEmpty((Object)commissionQueryResponseDTO) && ObjectUtils.isNotEmpty((Object)commissionQueryResponseDTO.getHead())) {
                this.log.error("\u8c03\u7528\u9500\u7ba1\u63a5\u53e3\u51fa\u9519\uff1a{}", (Object)commissionQueryResponseDTO.getHead().getAppMessage());
                throw ApisDataCompletionException.builder().errorCode(commissionQueryResponseDTO.getHead().getAppCode()).message(commissionQueryResponseDTO.getHead().getAppMessage()).build();
            }
            this.log.error("\u8c03\u7528\u9500\u7ba1\u63a5\u53e3\u51fa\u9519\uff1a{}", (Object)ErrorNullValueCodeEnum.ERR_N10002.getValue());
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10022.getKey()).message(ChannelErrorCodeEnum.ERR_C10022.getValue()).build();
        }
        List saleResponseDTOS = commissionQueryResponseDTO.getData();
        saleResponseDTOList.addAll(saleResponseDTOS);
        this.giveSetData(quotePriceDTO.getMain(), commissionQueryResponseDTO);
        return saleResponseDTOList;
    }

    private void giveDataCompletion(StanderRequest request, QuotePriceDTO quotePriceDTO, CommissionQueryDTO commissionQueryDTO) throws ApisBusinessException {
        if (StringUtils.isNotEmpty((CharSequence)quotePriceDTO.getMain().getMainPolicyNo())) {
            this.log.warn("\u8d60\u9669\u6709\u7ed1\u5b9a\u4fdd\u5355\u53f7\uff0c\u4e3a\uff1a{}", (Object)quotePriceDTO.getMain().getMainPolicyNo());
            PolicyDTO policyDTO = this.getPolicyDetail(request, quotePriceDTO.getMain().getMainPolicyNo(), true);
            if (StringUtils.isNotEmpty((CharSequence)policyDTO.getMain().getPolicyStatus()) && !policyDTO.getMain().getPolicyStatus().equals("1")) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10503.getValue(), ChannelErrorCodeEnum.ERR_C10503.getKey());
            }
            this.log.warn("\u4fdd\u5355\u8be6\u60c5policyDTO.main = {}", (Object)policyDTO.getMain());
            if (StringUtils.isNotEmpty((CharSequence)((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode())) {
                commissionQueryDTO.setMainInsureType("3");
                commissionQueryDTO.setMainInsureCode(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode());
            } else if (StringUtils.isNotEmpty((CharSequence)((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getPlanCode())) {
                commissionQueryDTO.setMainInsureType("2");
                commissionQueryDTO.setMainInsureCode(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getPlanCode());
            } else {
                commissionQueryDTO.setMainInsureType("1");
                commissionQueryDTO.setMainInsureCode(policyDTO.getMain().getRiskCode());
            }
        }
    }

    public int calculateAge(Date startDate, Date birthDay) throws ApisDataCompletionException {
        if (ObjectUtil.isEmpty((Object)birthDay)) {
            this.log.error("\u88ab\u4fdd\u9669\u4eba\u51fa\u751f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10401.getValue(), ChannelErrorCodeEnum.ERR_C10401.getKey());
        }
        if (ObjectUtil.isEmpty((Object)startDate)) {
            this.log.error("\u8d77\u4fdd\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N30003.getValue(), ErrorNullValueCodeEnum.ERR_N30003.getKey());
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        if (cal.before(birthDay)) {
            this.log.error("\u51fa\u751f\u65e5\u671f\u665a\u4e8e\u8d77\u4fdd\u65e5\u671f\uff0c\u65e0\u6cd5\u8ba1\u7b97\u5e74\u9f84");
            throw new ApisDataCompletionException(ErrorBisCodeEnum.ERR_B30004.getValue(), ErrorBisCodeEnum.ERR_B30004.getKey());
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public PolicyDTO getPolicyDetail(StanderRequest request, String policyNo, boolean power) throws ApisBusinessException {
        String userCode = null;
        if (power) {
            userCode = this.getPolicyQueryRange();
        }
        if (ObjectUtil.isEmpty(userCode)) {
            userCode = request.getHeader().getUserCode();
        }
        PolicyDetailRequestDTO policyDetailRequestDTO = PolicyDetailRequestDTO.builder().policyNo(policyNo).businessNature2("all").operateCode(userCode).build();
        PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().requestHead(com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO.initRequestHead()).requestBody(policyDetailRequestDTO).build();
        request.setPolicyDetailServiceRequest(policyDetailServiceRequest);
        StanderResponse standerResponse = this.apisBusinessService.execute("policyDetail", request);
        BaseApisParamUtil.verificationResponse((StanderResponse)standerResponse, (String)"policyDetailResponse");
        PolicyDetailResponse policyDetailResponse = standerResponse.getPolicyDetailResponse();
        if (1 != policyDetailResponse.getResponseHead().getStatus() || ObjectUtil.isEmpty((Object)policyDetailResponse.getResponseBody().getPolicy())) {
            String appCode = policyDetailResponse.getResponseHead().getAppCode();
            String appMessage = policyDetailResponse.getResponseHead().getAppMessage();
            this.log.error("\u83b7\u53d6\u4fdd\u5355\u8be6\u60c5\u63a5\u53e3\u5931\u8d25\uff1a{},\u9519\u8bef\u4ee3\u7801\uff1a{}", (Object)appMessage, (Object)appCode);
            throw new ApisBusinessException(appMessage, appCode);
        }
        return policyDetailResponse.getResponseBody().getPolicy();
    }

    private String getPolicyQueryRange() {
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode("policy_query_range");
        apisChannelConfigs.setDeleted(Integer.valueOf(0));
        ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        if (ObjectUtil.isNotEmpty((Object)channelConfigs) && ObjectUtil.isNotEmpty((Object)channelConfigs.getUserCode())) {
            return channelConfigs.getUserCode();
        }
        return null;
    }

    private void giveSetData(MainDTO main, AgentQueryResponseDTO responseDTO) {
        String[] dateTime;
        main.setGiftType(((SaleResponseDTO)responseDTO.getData().get(0)).getGiveType());
        if (((SaleResponseDTO)responseDTO.getData().get(0)).getGiveType().equals("1") || ((SaleResponseDTO)responseDTO.getData().get(0)).getGiveType().equals("2")) {
            if (StringUtils.isNotEmpty((CharSequence)main.getMainPolicyNo())) {
                main.setGiftWay("1");
            } else {
                main.setGiftWay("2");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)((SaleResponseDTO)responseDTO.getData().get(0)).getGiveDate()) && (dateTime = ((SaleResponseDTO)responseDTO.getData().get(0)).getGiveDate().split("-")).length > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
            String startTime = dateTime[0] + " 00:00:00";
            String endTime = dateTime[1] + " 23:59:59";
            try {
                main.setGiveStartTime(sdf.parse(startTime));
                main.setGiveEndTime(sdf.parse(endTime));
                this.log.warn("startTime = {}", (Object)main.getGiveStartTime().getTime());
                this.log.warn("endTime = {}", (Object)main.getGiveEndTime().getTime());
            }
            catch (ParseException e) {
                this.log.error("\u9500\u7ba1\u8d60\u9001\u65f6\u95f4\u533a\u95f4\u8f6c\u6362\u65e5\u671f\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    public List<SaleResponseDTO> dataCompletionMainDTO(QuotePriceDTO quotePriceDTO, StanderRequest request, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        MainDTO mainDTO = quotePriceDTO.getMain();
        String planCode = ((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        if (ObjectUtils.isNotEmpty((Object)apisPfpRationMain)) {
            ((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).setGoodsName(apisPfpRationMain.getRationName());
            if (StringUtils.isEmpty((CharSequence)mainDTO.getRiskCode())) {
                mainDTO.setRiskCode(apisPfpRationMain.getProductCode());
                mainDTO.setRiskName(apisPfpRationMain.getProductName());
            }
            request.getQuotePriceServiceRequest().getRequestHead().setClassCode(apisPfpRationMain.getClassCode());
            request.getQuotePriceServiceRequest().getRequestHead().setRiskCode(mainDTO.getRiskCode());
            if (ObjectUtil.isNotEmpty((Object)apisPfpRationMain.getCustomerType()) && apisPfpRationMain.getCustomerType() == 2) {
                mainDTO.setPolicyType("02");
            } else {
                mainDTO.setPolicyType("01");
            }
        } else {
            this.log.error("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f\uff0c\u5546\u54c1\u4ee3\u7801:{}", (Object)planCode);
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10024.getKey()).message(ChannelErrorCodeEnum.ERR_C10024.getValue()).build();
        }
        if (ObjectUtils.isNotEmpty((Object)quotePriceDTO.getCoverage().getInsuredIdvList()) && quotePriceDTO.getCoverage().getInsuredIdvList().size() > 0) {
            if (ObjectUtil.isEmpty((Object)mainDTO.getSumQuantity())) {
                mainDTO.setSumQuantity(Integer.valueOf(quotePriceDTO.getCoverage().getInsuredIdvList().size()));
            }
        } else if (ObjectUtils.isNotEmpty((Object)quotePriceDTO.getInsuredList()) && quotePriceDTO.getInsuredList().size() > 0 && ObjectUtil.isEmpty((Object)mainDTO.getSumQuantity())) {
            mainDTO.setSumQuantity(Integer.valueOf(quotePriceDTO.getInsuredList().size()));
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getBusinessAttrubute())) {
            mainDTO.setBusinessAttribute("Apis");
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getNationFlag())) {
            mainDTO.setNationFlag("0");
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getArgueSolution())) {
            mainDTO.setArgueSolution("1");
        }
        Map userMap = this.getChannelUserInfo(request);
        List saleResponseDTOList = this.commissionQuery(quotePriceDTO, apisPfpRationMain, userMap, request);
        SaleResponseDTO saleResponseDTO = (SaleResponseDTO)saleResponseDTOList.get(0);
        if (StringUtils.isEmpty((CharSequence)mainDTO.getHandlerCode())) {
            mainDTO.setHandlerCode(saleResponseDTO.getBdInfo().getBdCode());
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getHandlerName())) {
            mainDTO.setHandlerName(saleResponseDTO.getBdInfo().getBdName());
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getCenterCode())) {
            mainDTO.setCenterCode(saleResponseDTO.getBdInfo().getBdProfitCode());
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getCenterName())) {
            mainDTO.setCenterName(saleResponseDTO.getBdInfo().getBdProfitName());
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getBusinessNature())) {
            String businessNature = this.convertCode("businessNature", saleResponseDTO.getSubAgentType());
            mainDTO.setBusinessNature(businessNature);
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getCalcType())) {
            mainDTO.setCalcType("1");
        }
        if ("3".equals(mainDTO.getCalcType()) && "01".equals(mainDTO.getPolicyType()) && Arrays.asList(BusinessConstants.ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode())) {
            mainDTO.setIsSupportFamily("Y");
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getInputDate())) {
            mainDTO.setInputDate(new Date());
        } else {
            int regInputDate = Integer.parseInt(DateUtil.format((Date)DateUtil.offsetDay((Date)new Date(), (int)-1), (String)"yyyyMMdd"));
            int inputDate = Integer.parseInt(DateUtil.format((Date)mainDTO.getInputDate(), (String)"yyyyMMdd"));
            if (!this.issueDateControl(request) && inputDate < regInputDate) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10637.getValue(), ChannelErrorCodeEnum.ERR_C10637.getKey());
            }
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getRenewalFlag())) {
            if (StringUtils.isEmpty((CharSequence)mainDTO.getRenewalPolicyNo())) {
                mainDTO.setRenewalFlag("0");
            } else if (!"underwrit".equals(request.getHeader().getBussinessType())) {
                mainDTO.setRenewalFlag("1");
            } else {
                mainDTO.setRenewalFlag("0");
            }
        }
        if (ObjectUtils.isEmpty((Object)mainDTO.getStartHour())) {
            mainDTO.setStartHour(Integer.valueOf(0));
        }
        if (ObjectUtils.isEmpty((Object)mainDTO.getEndHour())) {
            mainDTO.setEndHour(Integer.valueOf(24));
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getJudicalScope())) {
            mainDTO.setJudicalScope("1");
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getCurrency())) {
            mainDTO.setCurrency("RMB");
        }
        if (ObjectUtils.isEmpty((Object)mainDTO.getTotalDiscount())) {
            mainDTO.setTotalDiscount(Double.valueOf(100.0));
        }
        if (ObjectUtils.isEmpty((Object)mainDTO.getSumDisCount())) {
            mainDTO.setSumDisCount(Double.valueOf(0.0));
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getOperateCode())) {
            mainDTO.setOperateCode((String)DataCompletionUtil.castToClass(String.class, userMap.get("operate_code")));
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getOperateName())) {
            mainDTO.setOperateName((String)DataCompletionUtil.castToClass(String.class, userMap.get("user_name")));
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getComCode())) {
            mainDTO.setComCode((String)DataCompletionUtil.castToClass(String.class, userMap.get("com_code")));
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getMakeCom())) {
            mainDTO.setMakeCom(mainDTO.getComCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)mainDTO.getSystemSource()) && "1".equals(mainDTO.getSystemSource())) {
            mainDTO.setBusinessNature2("PP");
        }
        Date startDate = new Date();
        if (ObjectUtil.isNotEmpty((Object)mainDTO.getRenewalFlag()) && "1".equals(mainDTO.getRenewalFlag()) && ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform()) && request.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform().booleanValue()) {
            mainDTO.setJFeeFlag("1");
            mainDTO.setStepFlag("1");
        } else {
            ApisChannelConfigs channelConfigs = this.getConfig(request, "channel_jfeeFlag");
            this.log.warn("\u83b7\u53d6\u89c1\u8d39\u6807\u8bc6\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            if (ObjectUtil.isNotEmpty((Object)channelConfigs)) {
                mainDTO.setJFeeFlag(channelConfigs.getConfigValue());
                mainDTO.setStepFlag(channelConfigs.getValueType());
            }
        }
        String giftType = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getGiftType();
        if (StringUtils.isNotEmpty((CharSequence)giftType) && giftType.equals("2")) {
            this.log.warn("======\u4eac\u4e1c\u5b89\u8054\u8d60\u9669\u51fa\u5355\uff0c\u8bbe\u7f6e\u4e3a\u975e\u89c1\u8d39");
            mainDTO.setJFeeFlag("0");
            mainDTO.setStepFlag("1");
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getMarineType()) && "06".equals(apisPfpRationMain.getClassCode())) {
            mainDTO.setMarineType("13");
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getClassCode())) {
            mainDTO.setClassCode(apisPfpRationMain.getClassCode());
        }
        long alipayConfigTime = System.currentTimeMillis();
        ApisChannelConfigs alipayConfig = this.getConfig(request.getHeader().getUserCode(), "alipay_issueDate");
        this.log.warn("\u83b7\u53d6\u652f\u4ed8\u5b9d\u7279\u6b8a\u573a\u666f\u6807\u5fd7\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - alipayConfigTime));
        if (ObjectUtil.isNotEmpty((Object)alipayConfig)) {
            mainDTO.setAlipayFlag("1");
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getPaymentType()) && "1".equals(mainDTO.getJFeeFlag()) && ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPayPlanList()) && quotePriceDTO.getPayPlanList().size() > 1) {
            mainDTO.setPlanPayType("01");
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getLargeBusiRisk())) {
            mainDTO.setLargeBusiRisk("0");
        }
        return saleResponseDTOList;
    }

    private boolean issueDateControl(StanderRequest request) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_code", (Object)request.getHeader().getUserCode());
        queryWrapper.eq((Object)"config_code", (Object)"issueDate_control");
        ApisChannelConfigs channelConfigs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
        return ObjectUtil.isNotEmpty((Object)channelConfigs);
    }

    public void dataCompletionAppliClientDTO(QuotePriceDTO quotePriceDTO) throws ApisDataCompletionException {
        List appliClientDTOList = quotePriceDTO.getAppliClient();
        Integer serialNo = 1;
        for (AppliClientDTO appliClientDTO : appliClientDTOList) {
            String occupationCode;
            if (ObjectUtils.isEmpty((Object)appliClientDTO.getSerialNo())) {
                appliClientDTO.setSerialNo(serialNo);
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInsuredFlag())) {
                appliClientDTO.setInsuredFlag("1");
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInsuredType())) {
                appliClientDTO.setInsuredType("1");
            }
            if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPlanList())) {
                if ("2".equals(appliClientDTO.getInsuredType())) {
                    appliClientDTO.setTaxPayerType("05");
                    if ("004".equals(appliClientDTO.getInvoiceType())) {
                        appliClientDTO.setIdentifyType("72");
                        appliClientDTO.setIdentifyNumber(quotePriceDTO.getCompanyInfo().getVatNumber());
                    } else if (StringUtils.isNotEmpty((CharSequence)quotePriceDTO.getCompanyInfo().getRegNumber())) {
                        appliClientDTO.setIdentifyType("74");
                        appliClientDTO.setIdentifyNumber(quotePriceDTO.getCompanyInfo().getRegNumber());
                    } else {
                        appliClientDTO.setIdentifyType("99");
                        appliClientDTO.setIdentifyNumber(quotePriceDTO.getCompanyInfo().getSocialSecurityNo());
                    }
                } else {
                    if (StringUtils.isEmpty((CharSequence)appliClientDTO.getTaxPayerType())) {
                        appliClientDTO.setTaxPayerType("04");
                    }
                    if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInvoiceType())) {
                        if ("1".equals(appliClientDTO.getReqElecFaPiao())) {
                            appliClientDTO.setInvoiceType("026");
                        } else {
                            appliClientDTO.setInvoiceType("007");
                        }
                    }
                }
            } else if ("2".equals(appliClientDTO.getInsuredType())) {
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getTaxPayerType())) {
                    appliClientDTO.setTaxPayerType("05");
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInvoiceType())) {
                    if ("1".equals(appliClientDTO.getReqElecFaPiao())) {
                        appliClientDTO.setInvoiceType("026");
                    } else {
                        appliClientDTO.setInvoiceType("007");
                    }
                }
            } else {
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getTaxPayerType())) {
                    appliClientDTO.setTaxPayerType("04");
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInvoiceType())) {
                    if ("1".equals(appliClientDTO.getReqElecFaPiao())) {
                        appliClientDTO.setInvoiceType("026");
                    } else {
                        appliClientDTO.setInvoiceType("007");
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getOccupationCode()) && StringUtils.isNotEmpty((CharSequence)(occupationCode = this.convertCode("SmallClassProfession", appliClientDTO.getOccupationCode())))) {
                appliClientDTO.setOccupationCode(occupationCode);
                appliClientDTO.setOccupationGrade(occupationCode.substring(0, 1));
                appliClientDTO.setOccupationType(occupationCode.substring(0, 3));
                appliClientDTO.setOccupationLevel(this.convertCode("occupationLevel", appliClientDTO.getOccupationCode()));
            }
            if (ObjectUtil.isEmpty((Object)appliClientDTO.getInsuredId())) {
                appliClientDTO.setInsuredId(String.valueOf(System.currentTimeMillis()));
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyType())) {
                appliClientDTO.setIdentifyType("99");
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyNumber())) {
                appliClientDTO.setIdentifyNumber(appliClientDTO.getInsuredName());
            }
            Integer n = serialNo;
            Integer n2 = serialNo = Integer.valueOf(serialNo + 1);
        }
    }

    public void dataCompletionInsuredDTO(QuotePriceDTO quotePriceDTO) throws ApisDataCompletionException {
        List insuredDTOList = quotePriceDTO.getInsuredList();
        AppliClientDTO appliClientDTO = (AppliClientDTO)quotePriceDTO.getAppliClient().get(0);
        Integer serialNo = 1;
        for (InsuredDTO insuredDTO : insuredDTOList) {
            if (ObjectUtils.isEmpty((Object)insuredDTO.getSerialNo())) {
                insuredDTO.setSerialNo(serialNo);
            }
            if (ObjectUtils.isEmpty((Object)insuredDTO.getBenefitModeCode())) {
                insuredDTO.setBenefitModeCode("1");
            }
            if (StringUtils.isEmpty((CharSequence)insuredDTO.getInsuredFlag())) {
                insuredDTO.setInsuredFlag("2");
            }
            if (StringUtils.isEmpty((CharSequence)insuredDTO.getTaxPayerType())) {
                if ("1".equals(insuredDTO.getInsuredType())) {
                    insuredDTO.setTaxPayerType("04");
                } else {
                    insuredDTO.setTaxPayerType("05");
                }
            }
            if ("1".equals(appliClientDTO.getReqElecFaPiao())) {
                insuredDTO.setInvoiceType("026");
            } else {
                insuredDTO.setInvoiceType("026");
            }
            if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getOccupationCode())) {
                String occupationCode = this.convertCode("SmallClassProfession", insuredDTO.getOccupationCode());
                if (StringUtils.isNotEmpty((CharSequence)occupationCode)) {
                    insuredDTO.setOccupationCode(occupationCode);
                }
                if (insuredDTO.getOccupationCode().trim().length() > 3) {
                    insuredDTO.setOccupationGrade(insuredDTO.getOccupationCode().substring(0, 1));
                    insuredDTO.setOccupationType(insuredDTO.getOccupationCode().substring(0, 3));
                }
                insuredDTO.setOccupationLevel(this.convertCode("occupationLevel", insuredDTO.getOccupationCode()));
            }
            if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getInsuredIDCache())) {
                insuredDTO.setInsuredId(insuredDTO.getInsuredIDCache());
            }
            if (ObjectUtil.isEmpty((Object)insuredDTO.getInsuredId())) {
                insuredDTO.setInsuredId(String.valueOf(System.currentTimeMillis()));
            }
            Integer n = serialNo;
            Integer n2 = serialNo = Integer.valueOf(serialNo + 1);
        }
    }

    public void dataCompletionSalesDTO(StanderRequest request, List<SaleResponseDTO> saleResponseDTOList) {
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        SalesDTO salesDTO = quotePriceDTO.getSales();
        SaleResponseDTO saleResponseDTO = saleResponseDTOList.get(0);
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgentName()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgentName(saleResponseDTO.getAgentName());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgreementNo()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgreementNo(saleResponseDTO.getAgreementCode());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgreementName()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgreementName(saleResponseDTO.getAgreementName());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgentType()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgentType(saleResponseDTO.getAgentType());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgentDetailType()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgentDetailType(saleResponseDTO.getSubAgentType());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getHandlerCode()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setHandlerCode(saleResponseDTO.getBdInfo().getBdCode());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getHandlerName()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setHandlerName(saleResponseDTO.getBdInfo().getBdName());
        }
        salesDTO.setHandlerTeamCode(saleResponseDTO.getBdInfo().getBdTeamCode());
        salesDTO.setHandlerTeamName(saleResponseDTO.getBdInfo().getBdTeamName());
        ArrayList<CommissionDTO> list = new ArrayList<CommissionDTO>();
        CommissionDTO commissionDTO = null;
        for (SaleResponseDTO dto : saleResponseDTOList) {
            commissionDTO = CommissionDTO.builder().build();
            commissionDTO.setRoleAgentCode(dto.getAgentCode());
            commissionDTO.setAgentFlag(dto.getAgentFlag());
            commissionDTO.setCostType(dto.getFeeType());
            commissionDTO.setCostRateUpper(Double.valueOf(dto.getAgreementLimitRate()));
            commissionDTO.setCostRate(Double.valueOf(dto.getCommRate()));
            list.add(commissionDTO);
        }
        salesDTO.setCommissionList(list);
        if ("1".equals(quotePriceDTO.getMain().getRenewalFlag())) {
            if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform()) && request.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform().booleanValue()) {
                salesDTO.setRenewalType("2");
            } else {
                salesDTO.setRenewalType("1");
            }
        }
    }

    public void dataCompletionCoverageDTO(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        CoverageDTO coverageDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage();
        List insuredDTOList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getInsuredList();
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        String classCode = request.getQuotePriceServiceRequest().getRequestHead().getClassCode();
        ApisChannelConfigs apisChannelConfigs = this.getConfigByChannelCode(request.getHeader().getChannelCode(), "employee_not_valid_agent");
        if (ObjectUtils.isNotEmpty((Object)coverageDTO.getItemList()) && coverageDTO.getItemList().size() > 0) {
            ApisChannelConfigs notSetSumAmountAgent = this.getConfigByChannelCode(request.getHeader().getChannelCode(), "employ_not_set_sum_amount_agent");
            int itemNo = 1;
            for (ItemMainDTO itemMainDTO : coverageDTO.getItemList()) {
                ApisPfpRationMain apisPfpRationMainFlag = this.getApisPfpRationMainInfo(itemMainDTO.getGoodsCode(), "2");
                if (ObjectUtils.isEmpty((Object)itemMainDTO.getItemNo())) {
                    itemMainDTO.setItemNo(Integer.valueOf(itemNo));
                }
                if (ObjectUtils.isEmpty((Object)itemMainDTO.getInsuredCount())) {
                    if ("07".equals(classCode) || "09".equals(classCode)) {
                        itemMainDTO.setInsuredCount(Integer.valueOf(ObjectUtil.isNotEmpty((Object)coverageDTO.getInsuredIdvList()) ? coverageDTO.getInsuredIdvList().size() : 1));
                    } else {
                        itemMainDTO.setInsuredCount(Integer.valueOf(insuredDTOList.size()));
                    }
                }
                if (ObjectUtils.isEmpty((Object)itemMainDTO.getRationCount())) {
                    itemMainDTO.setRationCount(Integer.valueOf(1));
                }
                itemMainDTO.setGoodsName(apisPfpRationMainFlag.getRationName());
                ApisPfpRationMain apisPfpRationMain = this.getApisPfpRationMainInfo(itemMainDTO.getGoodsCode(), "1");
                this.log.warn("\u83b7\u53d6\u4fdd\u969c\u65b9\u6848\u4ee3\u7801\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
                if (ObjectUtil.isNotEmpty((Object)apisPfpRationMain)) {
                    itemMainDTO.setPlanCode(apisPfpRationMain.getRationCode() == null ? "" : apisPfpRationMain.getRationCode());
                    itemMainDTO.setPlanName(apisPfpRationMain.getRationName() == null ? "" : apisPfpRationMain.getRationName());
                    itemMainDTO.setPlanType(apisPfpRationMain.getRationType() == null ? "" : apisPfpRationMain.getRationType());
                }
                ArrayList<ItemKindDTO> itemKindDTOList = new ArrayList<ItemKindDTO>();
                List apisPfpRationKinds = this.apisPfpRationKindMapper.getApisPfpRationKindList(apisPfpRationMainFlag.getId().longValue());
                this.log.warn("\u83b7\u53d6\u9669\u522b\u4fe1\u606f\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
                if (ObjectUtil.isNotEmpty((Object)apisPfpRationKinds) && apisPfpRationKinds.size() > 0) {
                    int itemKindNo = 1;
                    for (ApisPfpRationKind pfpRationKind1 : apisPfpRationKinds) {
                        ItemKindDTO kindDTO = ItemKindDTO.builder().build();
                        kindDTO.setItemNo(itemMainDTO.getItemNo());
                        kindDTO.setItemkindNo(Integer.valueOf(itemKindNo));
                        kindDTO.setKindCode(pfpRationKind1.getKindCode());
                        kindDTO.setKindName(pfpRationKind1.getKindName());
                        if (null == notSetSumAmountAgent && (empClaseCode.equals(pfpRationKind1.getClauseCode()) || empClaseCode65.equals(pfpRationKind1.getClauseCode()))) {
                            if (deathLiab.equals(pfpRationKind1.getKindCode()) || injuryLiab.equals(pfpRationKind1.getKindCode())) {
                                kindDTO.setSumInsured(BigDecimal.valueOf(itemMainDTO.getUnitAmount()));
                            } else if (stopWorkCompensation.equals(pfpRationKind1.getKindCode())) {
                                kindDTO.setSumInsured(BigDecimal.valueOf(100L));
                            } else if (hospitAllwance.equals(pfpRationKind1.getKindCode())) {
                                kindDTO.setSumInsured(BigDecimal.valueOf(50L));
                            } else if (medicalLiab.equals(pfpRationKind1.getKindCode())) {
                                kindDTO.setSumInsured(BigDecimal.valueOf(itemMainDTO.getUnitAmount()).divide(BigDecimal.valueOf(10L)));
                            }
                        }
                        kindDTO.setClauseCode(pfpRationKind1.getClauseCode());
                        kindDTO.setCalculateInd(String.valueOf(pfpRationKind1.getCalculateInd() == null ? "" : pfpRationKind1.getCalculateInd()));
                        kindDTO.setStartDate(mainDTO.getStartDate());
                        kindDTO.setEndDate(mainDTO.getEndDate());
                        kindDTO.setKindInd(pfpRationKind1.getClauseType());
                        kindDTO.setClauseName(pfpRationKind1.getClauseName());
                        kindDTO.setIsOptional(pfpRationKind1.getIsOptional());
                        if (ObjectUtils.isNotEmpty((Object)pfpRationKind1.getAmount())) {
                            kindDTO.setSumInsured(pfpRationKind1.getAmount());
                        }
                        if (ObjectUtils.isNotEmpty((Object)pfpRationKind1.getPremium())) {
                            kindDTO.setGrossPremium(Double.valueOf(pfpRationKind1.getPremium().doubleValue()));
                        }
                        if (ObjectUtils.isEmpty((Object)kindDTO.getSumInsured())) {
                            kindDTO.setSumInsured(BigDecimal.ZERO);
                        }
                        if (ObjectUtils.isEmpty((Object)kindDTO.getGrossPremium())) {
                            kindDTO.setGrossPremium(Double.valueOf(BigDecimal.ZERO.doubleValue()));
                        }
                        ++itemKindNo;
                        itemKindDTOList.add(kindDTO);
                    }
                    if (apisChannelConfigs == null) {
                        itemMainDTO.setItemKind(this.matchUpdataList(itemKindDTOList, itemMainDTO.getItemKind(), itemMainDTO));
                    } else {
                        itemMainDTO.setItemKind(itemKindDTOList);
                    }
                } else {
                    this.log.error("\u7f3a\u5c11\u914d\u7f6e\u5bf9\u5e94\u7684\u6761\u6b3e\u8d23\u4efb\u4fe1\u606f\uff0c\u5546\u54c1\u4ee3\u7801:{}", (Object)itemMainDTO.getGoodsCode());
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10017.getValue(), ChannelErrorCodeEnum.ERR_C10017.getKey());
                }
                RiskInfoDTO riskInfoDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getRiskInfo();
                ArrayList<ItemPropertyDTO> itemProperty = itemMainDTO.getItemProperty();
                if (ObjectUtils.isNotEmpty((Object)riskInfoDTO)) {
                    ItemPropertyDTO itemPropertyDTO = ItemPropertyDTO.builder().build();
                    itemPropertyDTO.setItemNo(itemNo);
                    itemPropertyDTO.setIndustryCode(riskInfoDTO.getIndustryCode());
                    itemPropertyDTO.setExtendDays(riskInfoDTO.getExtendDays());
                    if (ObjectUtils.isEmpty((Object)itemProperty)) {
                        itemProperty = new ArrayList<ItemPropertyDTO>();
                        itemProperty.add(itemPropertyDTO);
                        itemMainDTO.setItemProperty(itemProperty);
                    } else {
                        itemMainDTO.getItemProperty().add(itemPropertyDTO);
                    }
                }
                ++itemNo;
            }
        }
    }

    private List<ItemKindDTO> matchUpdataList(List<ItemKindDTO> itemKindDTOList, List<ItemKindDTO> requestItemKindDTOList, ItemMainDTO itemMainDTO) throws ApisBusinessException {
        itemMainDTO.setContainsTwentyFourHoursClauseFlag("N");
        ArrayList<ItemKindDTO> newItemKindDTOList = new ArrayList<ItemKindDTO>();
        block0: for (ItemKindDTO kind : itemKindDTOList) {
            if (ObjectUtil.isEmpty(requestItemKindDTOList)) {
                if (HOUR_KIND_CODE_CODE.equals(kind.getClauseCode())) continue;
                newItemKindDTOList.add(kind);
                continue;
            }
            boolean flag = false;
            if (kind.getIsOptional() == 1) {
                newItemKindDTOList.add(kind);
            }
            for (ItemKindDTO requestKind : requestItemKindDTOList) {
                if (ObjectUtils.isEmpty((Object)requestKind.getSumInsured())) {
                    requestKind.setSumInsured(BigDecimal.ZERO);
                }
                if (HOUR_KIND_CODE_LIAB.equals(requestKind.getKindCode()) && HOUR_KIND_CODE_CODE.equals(requestKind.getClauseCode()) && kind.getKindCode().equals(requestKind.getKindCode()) && kind.getClauseCode().equals(requestKind.getClauseCode())) {
                    newItemKindDTOList.add(kind);
                    itemMainDTO.setContainsTwentyFourHoursClauseFlag("Y");
                }
                if (!kind.getKindCode().equals(requestKind.getKindCode()) || !kind.getClauseCode().equals(requestKind.getClauseCode())) continue;
                kind.setSumInsured(requestKind.getSumInsured());
                continue block0;
            }
        }
        return newItemKindDTOList;
    }

    public ApisChannelConfigs getConfig(String userCode, String configCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_code", (Object)userCode);
        queryWrapper.eq((Object)"config_code", (Object)configCode);
        queryWrapper.eq((Object)"deleted", (Object)"0");
        return (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
    }

    public ApisChannelConfigs getConfig(StanderRequest request, String configCode) {
        String userCode = request.getHeader().getUserCode();
        String productCode = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getRiskCode();
        String rationCode = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"deleted", (Object)"0");
        queryWrapper.eq((Object)"user_code", (Object)userCode);
        queryWrapper.eq((Object)"config_code", (Object)configCode);
        if ("ebActivity".equals(configCode)) {
            queryWrapper.eq((Object)"ration_code", (Object)rationCode);
        } else {
            queryWrapper.like((Object)"product_code", (Object)productCode);
        }
        List list = this.apisChannelConfigsService.list((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)list) && list.size() > 0) {
            return (ApisChannelConfigs)list.get(0);
        }
        return null;
    }

    public ApisChannelConfigs getConfig(String userCode, String configCode, String rationCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_code", (Object)userCode);
        queryWrapper.eq((Object)"config_code", (Object)configCode);
        queryWrapper.eq((Object)"ration_code", (Object)rationCode);
        queryWrapper.eq((Object)"deleted", (Object)"0");
        return (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryCalcType(String planCode) throws ApisDataCompletionException {
        String calTypeByConfig;
        block5: {
            calTypeByConfig = null;
            try {
                calTypeByConfig = this.apisPfpRationClauseKindFactoryMapper.verifyCalculateMethod(planCode);
            }
            catch (Exception e) {
                this.log.error("\n\u4fdd\u8d39\u8ba1\u7b97\u8d39\u7387\u8868\u914d\u7f6e\u9519\u8bef", (Throwable)e);
            }
            finally {
                if (!StringUtils.isEmpty((CharSequence)calTypeByConfig) || "HY-GN- LAND-7D-WBHW-2C".equals(planCode)) break block5;
                this.log.error("\n>>>\u4fdd\u8d39\u8ba1\u7b97\u65b9\u5f0f\u914d\u7f6e\u6709\u8bef \u5546\u54c1\u4ee3\u7801\uff1a{}", (Object)planCode);
                throw ApisDataCompletionException.builder().message(ChannelErrorCodeEnum.ERR_C10472.getValue().replace("##", planCode)).errorCode(ChannelErrorCodeEnum.ERR_C10472.getKey()).build();
            }
        }
        return calTypeByConfig;
    }

    public Map getChannelUserInfo(StanderRequest request) throws ApisDataCompletionException {
        Map userMap = this.baseCodeConvertUtils.getCodeData("channel:user:" + request.getHeader().getUserCode());
        if (ObjectUtils.isEmpty((Object)userMap) || userMap.size() == 0) {
            this.log.error("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8d26\u53f7\u4fe1\u606f\uff0c\u8d26\u53f7\uff1a{}", (Object)request.getHeader().getUserCode());
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10173.getKey()).message(ChannelErrorCodeEnum.ERR_C10173.getValue()).build();
        }
        return userMap;
    }

    public ApisPfpRationMain getApisPfpRationMainInfo(String planCode, String rationFlag) {
        ApisPfpRationMain apisPfpRationMain = new ApisPfpRationMain();
        apisPfpRationMain.setRationCode(planCode);
        if ("1".equals(rationFlag)) {
            apisPfpRationMain.setRationFlag("2");
        } else {
            apisPfpRationMain.setRationFlag(rationFlag);
        }
        apisPfpRationMain.setDeleted(Integer.valueOf(0));
        apisPfpRationMain.setValidStatus(Integer.valueOf(1));
        QueryWrapper queryWrapper = new QueryWrapper((Object)apisPfpRationMain);
        List rationMainList = new ArrayList();
        rationMainList = this.apisPfpRationMainService.list((Wrapper)queryWrapper);
        if ("1".equals(rationFlag) && ObjectUtil.isNotEmpty(rationMainList) && rationMainList.size() > 0) {
            QueryWrapper queryWrapperT = new QueryWrapper();
            queryWrapperT.eq((Object)"ration_flag", (Object)rationFlag);
            queryWrapperT.eq((Object)"ration_code", (Object)((ApisPfpRationMain)rationMainList.get(0)).getRelateRationCode());
            queryWrapperT.eq((Object)"deleted", (Object)0);
            queryWrapperT.eq((Object)"valid_status", (Object)1);
            rationMainList = this.apisPfpRationMainService.list((Wrapper)queryWrapperT);
        }
        if (ObjectUtil.isNotEmpty(rationMainList) && rationMainList.size() > 0) {
            return (ApisPfpRationMain)rationMainList.get(0);
        }
        return null;
    }

    public String convertCode(String code, String channelValue) throws ApisDataCompletionException {
        String value = "";
        Map map = this.baseCodeConvertUtils.getCodeData("channel:code:/:" + code);
        if (ObjectUtil.isNotEmpty((Object)map) && map.size() > 0) {
            value = (String)map.get(channelValue);
        } else {
            ApisChannelCode apisChannelCode = new ApisChannelCode();
            apisChannelCode.setCode(code);
            apisChannelCode.setChannelValue(channelValue);
            apisChannelCode.setDeleted(Integer.valueOf(0));
            QueryWrapper queryWrapper = new QueryWrapper((Object)apisChannelCode);
            List apisChannelCodeResult = this.apisChannelCodeService.list((Wrapper)queryWrapper);
            if (ObjectUtils.isNotEmpty((Object)apisChannelCodeResult) && apisChannelCodeResult.size() > 0) {
                value = ((ApisChannelCode)apisChannelCodeResult.get(0)).getValue();
            }
        }
        return value;
    }

    private void dataCompletionLimitInfo(StanderRequest request, ApisPfpRationMain apisPfpRationMain) {
        ArrayList<LimitDTO> limitDTOList = new ArrayList<LimitDTO>();
        List itemMainDTOS = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList();
        List apisPfpRationLimits = this.apisPfpRationLimitMapper.getRationLimitList(apisPfpRationMain.getId().longValue());
        ArrayList<ApisPfpRationLimit> apisPfpRationLimitsBak = new ArrayList<ApisPfpRationLimit>();
        for (ApisPfpRationLimit apisPfpRationLimit : apisPfpRationLimits) {
            if (apisPfpRationLimit.getLimitLevel() == 3) {
                apisPfpRationLimitsBak.add(apisPfpRationLimit);
                continue;
            }
            LimitDTO limitDTO = LimitDTO.builder().build();
            limitDTO.setLimitCode(apisPfpRationLimit.getLimitCode());
            limitDTO.setLimitLevel(String.valueOf(apisPfpRationLimit.getLimitLevel()));
            limitDTO.setLimitType(apisPfpRationLimit.getLimitType());
            if (ObjectUtil.isNotEmpty((Object)apisPfpRationLimit.getLimitValue())) {
                limitDTO.setLimits(Double.valueOf(apisPfpRationLimit.getLimitValue().doubleValue()));
            } else {
                limitDTO.setLimits(Double.valueOf(0.0));
            }
            limitDTO.setLimitsTo(apisPfpRationLimit.getLimitsTo());
            limitDTO.setLimitCode1(apisPfpRationLimit.getLimitCode1());
            if (ObjectUtil.isNotEmpty((Object)apisPfpRationLimit.getLimitValue1())) {
                limitDTO.setLimits1(Double.valueOf(apisPfpRationLimit.getLimitValue1().doubleValue()));
            }
            limitDTO.setLimitFlag1(apisPfpRationLimit.getLimitUnit1());
            limitDTO.setLimitFlag(apisPfpRationLimit.getLimitUnit());
            limitDTO.setRemark(apisPfpRationLimit.getRemark());
            limitDTO.setLimitName(apisPfpRationLimit.getLimitName());
            limitDTOList.add(limitDTO);
        }
        ApisChannelConfigs notSetSumAmountAgent = this.getConfigByChannelCode(request.getHeader().getChannelCode(), "employ_not_set_sum_amount_agent");
        for (ItemMainDTO itemMainDTO : itemMainDTOS) {
            if (ObjectUtils.isEmpty(apisPfpRationLimitsBak)) continue;
            for (ApisPfpRationLimit apisPfpRationLimit : apisPfpRationLimitsBak) {
                LimitDTO limitDTO = LimitDTO.builder().build();
                limitDTO.setLimitCode(apisPfpRationLimit.getLimitCode());
                limitDTO.setLimitLevel(String.valueOf(apisPfpRationLimit.getLimitLevel()));
                limitDTO.setClauseCode(apisPfpRationLimit.getClauseCode());
                limitDTO.setKindCode(apisPfpRationLimit.getKindCode());
                limitDTO.setItemNo(itemMainDTO.getItemNo());
                limitDTO.setLimitType(apisPfpRationLimit.getLimitType());
                if (ObjectUtil.isNotEmpty((Object)apisPfpRationLimit.getLimitValue())) {
                    limitDTO.setLimits(Double.valueOf(apisPfpRationLimit.getLimitValue().doubleValue()));
                } else if (null == notSetSumAmountAgent && (empClaseCode.equals(apisPfpRationLimit.getClauseCode()) || empClaseCode65.equals(apisPfpRationLimit.getClauseCode()))) {
                    if (deathLiab.equals(apisPfpRationLimit.getKindCode()) || injuryLiab.equals(apisPfpRationLimit.getKindCode())) {
                        limitDTO.setLimits(itemMainDTO.getUnitAmount());
                    } else if (stopWorkCompensation.equals(apisPfpRationLimit.getKindCode())) {
                        limitDTO.setLimits(Double.valueOf(100.0));
                    } else if (hospitAllwance.equals(apisPfpRationLimit.getKindCode())) {
                        limitDTO.setLimits(Double.valueOf(50.0));
                    } else if (medicalLiab.equals(apisPfpRationLimit.getKindCode())) {
                        limitDTO.setLimits(Double.valueOf(itemMainDTO.getUnitAmount() / 10.0));
                    } else {
                        limitDTO.setLimits(Double.valueOf(0.0));
                    }
                }
                limitDTO.setLimitsTo(apisPfpRationLimit.getLimitsTo());
                limitDTO.setLimitCode1(apisPfpRationLimit.getLimitCode1());
                if (ObjectUtil.isNotEmpty((Object)apisPfpRationLimit.getLimitValue1())) {
                    limitDTO.setLimits1(Double.valueOf(apisPfpRationLimit.getLimitValue1().doubleValue()));
                }
                limitDTO.setLimitFlag1(apisPfpRationLimit.getLimitUnit1());
                limitDTO.setLimitFlag(apisPfpRationLimit.getLimitUnit());
                limitDTO.setRemark(apisPfpRationLimit.getRemark());
                limitDTO.setLimitName(apisPfpRationLimit.getLimitName());
                limitDTOList.add(limitDTO);
            }
        }
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().setLimitList(limitDTOList);
    }

    @Async(value="imgBatchUploadExecutor")
    public void syncUpload(List<ImgFileDTO> imgFileDTOS, String userCode, String bussNo) throws ApisBusinessException {
        try {
            Optional properties = this.coreApiProperties.getServProperties("batchUploadFile");
            ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = null;
            RequestHeadDTO requestHeadDTO = new RequestHeadDTO();
            requestHeadDTO.setSeqNo(UUID.randomUUID().toString().replace("-", ""));
            requestHeadDTO.setRequestTime(new Date());
            requestHeadDTO.setOptComCode("apis");
            requestHeadDTO.setOptUserCode("apis");
            requestHeadDTO.setOptUserName("apis");
            requestHeadDTO.setConsumerID(((CoreApiServProperties)properties.get()).getUser());
            requestHeadDTO.setConsumerPWD(((CoreApiServProperties)properties.get()).getUserPwd());
            ImgBusiDTO imgBusiDTO = new ImgBusiDTO();
            imgBusiDTO.setAppCode("UW");
            imgBusiDTO.setClassCode("UWA");
            imgBusiDTO.setBusinessNo(bussNo);
            imgBusiDTO.setBusiComCode("apis");
            List imgBatchUploadMetaDTOS = null;
            imgBatchUploadRequestDTO = new ImgBatchUploadRequestDTO();
            imgBatchUploadRequestDTO.setHeadDto(requestHeadDTO);
            imgBatchUploadRequestDTO.setBusiDto(imgBusiDTO);
            imgBatchUploadMetaDTOS = this.compensateImgBatchUploadMeta(imgFileDTOS);
            if (imgBatchUploadMetaDTOS == null) {
                this.log.warn("\u96c7\u4e3b\u8d23\u4efb\u9669\u4e0b\u8f7d\u5931\u8d25\uff01");
                return;
            }
            imgBatchUploadRequestDTO.setUploadMetas(imgBatchUploadMetaDTOS);
            this.imgBatchUpload(imgBatchUploadRequestDTO, ((CoreApiServProperties)properties.get()).getUrl(), bussNo, userCode);
        }
        catch (ApisBusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApisDataCompletionException("\u5f71\u50cf\u4e0a\u4f20\u5931\u8d25,\u8bf7\u68c0\u67e5pdf\u94fe\u63a5\u662f\u5426\u6b63\u786e", ChannelErrorCodeEnum.ERR_C10479.getKey());
        }
    }

    public List<ImgBatchUploadMetaDTO> compensateImgBatchUploadMeta(List<ImgFileDTO> imgFileDTOs) throws ApisBusinessException {
        ArrayList<ImgBatchUploadMetaDTO> uploadMetaDTOList = new ArrayList<ImgBatchUploadMetaDTO>();
        ImgBatchUploadMetaDTO imgBatchUploadMetaDTO = null;
        for (ImgFileDTO imgFileDTO : imgFileDTOs) {
            imgBatchUploadMetaDTO = new ImgBatchUploadMetaDTO();
            Map map = EmployeeImageUploadUtil.netImageToBase64((String)imgFileDTO.getFileUrl());
            imgBatchUploadMetaDTO.setBase64FileContent((String)map.get("base64"));
            imgBatchUploadMetaDTO.setFileOrgName(imgFileDTO.getFileName() + "." + (String)map.get("imageType"));
            String imgTypeSub = imgFileDTO.getFileType().substring(0, 5);
            String imgType = "|" + imgTypeSub + "|" + imgFileDTO.getFileType() + "|";
            imgBatchUploadMetaDTO.setImgType(imgType);
            imgBatchUploadMetaDTO.setImgTypeName("|" + (String)imgTypeNameMap.get(imgTypeSub) + "|" + (String)imgTypeNameMap.get(imgFileDTO.getFileType()) + "|");
            uploadMetaDTOList.add(imgBatchUploadMetaDTO);
        }
        return uploadMetaDTOList;
    }

    private void imgBatchUpload(ImgBatchUploadRequestDTO imgBatchUploadRequestDTO, String url, String oderCode, String userCode) {
        try {
            ClaimMediaCommitResult responseDTO = this.mediaUploadApi.batchUpload(url, imgBatchUploadRequestDTO, null);
            if (ObjectUtil.isEmpty((Object)responseDTO) || ObjectUtil.isEmpty((Object)responseDTO.getHeadDto())) {
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B80002.getValue(), ErrorBisCodeEnum.ERR_B80002.getKey());
            }
            if (responseDTO.getHeadDto().getStatus() < 0) {
                this.log.warn("\u4e0a\u4f20\u96c7\u4e3b\u8d23\u4efb\u9669\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u5931\u8d25\uff1a{}", (Object)responseDTO.getHeadDto().getErrorMessage());
                return;
            }
            this.log.warn("\u4e0a\u4f20\u96c7\u4e3b\u8d23\u4efb\u9669\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u6210\u529f\uff0c\u54cd\u5e94\u62a5\u6587:{}", (Object)responseDTO.toString());
            this.insertImgBatchUploadLog(userCode, oderCode, responseDTO);
        }
        catch (Exception e) {
            this.log.error("error: ", (Throwable)e);
        }
    }

    public void insertImgBatchUploadLog(String userCode, String orderNo, ClaimMediaCommitResult responseDTO) throws ApisBusinessException {
        try {
            CoreDtoConverter converter = this.coreDtoConverterFactory.get("JSON");
            String api = "employeeImgBatchUpload";
            String bodyStr = converter.toPacketStr((Object)responseDTO);
            ApisBusiReqmsgLog apisBusiReqmsgLog = new ApisBusiReqmsgLog();
            apisBusiReqmsgLog.setApiCode(api);
            apisBusiReqmsgLog.setLogContent(bodyStr);
            apisBusiReqmsgLog.setLogType("2");
            apisBusiReqmsgLog.setOrderNo(orderNo);
            apisBusiReqmsgLog.setCreator(userCode);
            this.apisBusiReqmsgLogService.save((Object)apisBusiReqmsgLog);
        }
        catch (Exception e) {
            this.log.error("\u8bb0\u5f55\u96c7\u4e3b\u8d23\u4efb\u9669\u5f71\u50cf\u4e0a\u4f20\u62a5\u6587\u65f6\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)orderNo, (Object)e);
            return;
        }
    }

    public static Map<String, String> netImageToBase64(String imageUrl) throws ApisBusinessException {
        HashMap<String, String> map = new HashMap<String, String>();
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            URL url = new URL(imageUrl);
            byte[] by = new byte[1024];
            URLConnection obj = url.openConnection();
            HttpURLConnection conn = null;
            if (obj instanceof HttpURLConnection) {
                conn = (HttpURLConnection)obj;
            }
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            map.put("imageType", conn.getHeaderFields().get("Content-Type").get(0).split("/")[1]);
            InputStream is = conn.getInputStream();
            int len = -1;
            while ((len = is.read(by)) != -1) {
                data.write(by, 0, len);
            }
            is.close();
        }
        catch (IOException e) {
            throw new ApisDataCompletionException("\u56fe\u7247\u8f6cbase64\u5931\u8d25\uff1a" + e.getMessage(), ChannelErrorCodeEnum.ERR_C10479.getKey());
        }
        BASE64Encoder encoder = new BASE64Encoder();
        map.put("base64", encoder.encode(data.toByteArray()));
        return map;
    }

    public String employeeListUpload(String insuredStr, String businessNo, StanderRequest request) throws ApisBusinessException {
        String fileAddress = "";
        com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = new com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadRequestDTO();
        ImgBatchUploadServiceRequest imgBatchUploadServiceRequest = new ImgBatchUploadServiceRequest();
        imgBatchUploadRequestDTO.setLinkNo(businessNo);
        ArrayList<ImgMetaDTO> imgMetaDTOS = new ArrayList<ImgMetaDTO>();
        ImgMetaDTO imgMetaDTO = new ImgMetaDTO();
        imgMetaDTO.setFileName(imgBatchUploadRequestDTO.getLinkNo() + "insured");
        imgMetaDTO.setExtendName("txt");
        String insuredBase64 = EmployeeImageUploadUtil.getFileBase64((String)insuredStr);
        imgMetaDTO.setFileContentWithBase64Encode(insuredBase64);
        imgMetaDTOS.add(imgMetaDTO);
        imgBatchUploadRequestDTO.setImgList(imgMetaDTOS);
        imgBatchUploadServiceRequest.setRequestBody(imgBatchUploadRequestDTO);
        imgBatchUploadServiceRequest.setRequestHead(com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO.initRequestHead());
        request.setImgBatchUploadServiceRequest(imgBatchUploadServiceRequest);
        ClaimMediaCommitResult claimMediaCommitResult = this.mediaUploadUtil.imgBatchUpload(request);
        if (claimMediaCommitResult != null && claimMediaCommitResult.getImgNodes() != null && claimMediaCommitResult.getImgNodes().size() > 0) {
            fileAddress = ((ImgNode)claimMediaCommitResult.getImgNodes().get(0)).getImgUrl();
        } else {
            this.log.error("\u88ab\u4fdd\u9669\u4eba\u6e05\u5355\u4e0a\u4f20\u5931\u8d25!");
        }
        return fileAddress;
    }

    public ApisChannelConfigs getConfigByChannelCode(String channelCode, String configCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"channel_code", (Object)channelCode);
        queryWrapper.eq((Object)"config_code", (Object)configCode);
        queryWrapper.eq((Object)"deleted", (Object)"0");
        return (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
    }

    public static String getFileBase64(String imgFile) {
        Base64 base64 = new Base64();
        return base64.encodeAsString(imgFile.getBytes());
    }

    static {
        imgTypeNameMap.put("UWA_A", "\u6295\u4fdd\u8d44\u6599");
        imgTypeNameMap.put("UWA_B", "\u6295\u4fdd\u4eba\u8d44\u6599");
        imgTypeNameMap.put("UWA_C", "\u88ab\u4fdd\u9669\u4eba\u8d44\u6599");
        imgTypeNameMap.put("UWA_D", "\u98ce\u63a7\u8d44\u6599");
        imgTypeNameMap.put("UWA_E", "\u6279\u6539\u8d44\u6599");
        imgTypeNameMap.put("UWA_A01", "\u6295\u4fdd\u5355");
        imgTypeNameMap.put("UWA_A02", "\u6295\u4fdd\u544a\u77e5\u4e66");
        imgTypeNameMap.put("UWA_A03", "\u6295\u4fdd\u6807\u7684\u4fe1\u606f");
        imgTypeNameMap.put("UWA_A04", "\u5171\u4fdd\u8d44\u6599");
        imgTypeNameMap.put("UWA_A05", "\u7535\u5b50\u4fdd\u5355");
        imgTypeNameMap.put("UWA_A99", "\u5176\u4ed6\u6295\u4fdd\u8d44\u6599");
        imgTypeNameMap.put("UWA_B01", "\u5ba2\u6237\u8eab\u4efd\u8d44\u6599");
        imgTypeNameMap.put("UWA_B02", "\u8d26\u6237\u4fe1\u606f");
        imgTypeNameMap.put("UWA_B03", "\u6295\u4fdd\u4eba\u53cd\u6d17\u94b1\u8d44\u6599");
        imgTypeNameMap.put("UWA_C01", "\u5ba2\u6237\u8eab\u4efd\u8d44\u6599");
        imgTypeNameMap.put("UWA_C02", "\u8d26\u6237\u4fe1\u606f");
        imgTypeNameMap.put("UWA_C03", "\u88ab\u4fdd\u9669\u4eba\u53cd\u6d17\u94b1\u8d44\u6599");
        imgTypeNameMap.put("UWA_C04", "\u88ab\u4fdd\u9669\u4eba\u6e05\u5355");
        imgTypeNameMap.put("UWA_D01", "\u5ba2\u6237\u8c03\u67e5\u62a5\u544a");
        imgTypeNameMap.put("UWA_D02", "\u5ba2\u6237\u5065\u5eb7\u544a\u77e5\u4e66");
        imgTypeNameMap.put("UWA_D03", "\u56e2\u4f53\u4e1a\u52a1\u5065\u5eb7\u7533\u660e");
        imgTypeNameMap.put("UWA_D04", "\u4f53\u68c0\u62a5\u544a");
        imgTypeNameMap.put("UWA_E01", "\u6279\u6539\u7533\u8bf7\u4e66");
        imgTypeNameMap.put("UWA_E02", "\u6279\u6539\u8d44\u6599");
        imgTypeNameMap.put("UWA_E03", "\u7535\u5b50\u6279\u5355");
        imgTypeNameMap.put("UWA_E04", "\u4fdd\u5355\u56de\u6536");
        imgTypeNameMap.put("UWA_E05", "\u4fdd\u9669\u53d1\u7968\u56de\u6536");
    }
}

