/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.LitigationUtils;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ExecutorUtilTask {
    private static final Logger log = LoggerFactory.getLogger(ExecutorUtilTask.class);
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    LitigationUtils litigationUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="scheduleTaskNotifyExecutor")
    public void litigationGeneralCorrectCutet(StanderRequest request) {
        StanderResponse resp = null;
        String orderNo = null;
        try {
            orderNo = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo();
            this.dataCompletionUtil.completionNoStanderDefaultInfo(request, "litigationQuotePrice");
            Date startDate = new Date();
            log.warn("\u5e42\u7b49\u6027\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            resp = this.apisBusinessService.execute("litigationGeneralCorrect", request);
        }
        catch (ApisBusinessException e) {
            this.litigationUtils.pushUwResultGy(orderNo, "2", e.getMessage(), new Date());
        }
        catch (Exception e) {
            log.error("\u9ad8\u9662\u8bc9\u8d23\u9669\u6279\u6539\u62a5\u9519{}", (Throwable)e);
            this.litigationUtils.pushUwResultGy(orderNo, "2", ChannelErrorCodeEnum.ERR_C10006.getValue(), new Date());
        }
        finally {
            this.dataCompletionUtil.unLockByKey(orderNo + "_litigationGeneralCorrect");
        }
    }
}

