/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.FxqCustomerCheckService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.WarnSendService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RedisTemplateUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.fxq.request.CustomerDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.fxq.request.FxqReqDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.fxq.resp.CustomerResDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.fxq.resp.FxqResDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.fxq.resp.HighRiskPersonsDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CommonsExecutorRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.BeneficiaryDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CommonsValidateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiReqmsgLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiReqmsgLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelConfigsMapper;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.FxqCustomerScenesEnum;
import com.jdaz.sinosoftgz.coreapi.common.factory.CoreDtoConverterFactory;
import com.jdaz.sinosoftgz.coreapi.common.handler.CoreDtoConverter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FxqCustomerCheckUtil {
    private static final Logger log = LoggerFactory.getLogger(FxqCustomerCheckUtil.class);
    @Value(value="${fxqCustomer.systemSource}")
    private String systemSource;
    @Value(value="${commonsExecutorUrl.fxqCustomerUrl}")
    private String fxqCustomerUrl;
    @Autowired
    private FxqCustomerCheckService fxqCustomerCheckService;
    @Autowired
    ApisBusiReqmsgLogService apisBusiReqmsgLogService;
    @Autowired
    private ApisChannelConfigsMapper apisChannelConfigsMapper;
    @Autowired
    CoreDtoConverterFactory coreDtoConverterFactory;
    @Autowired
    private WarnSendService warnSendService;
    @Autowired
    private RedisTemplateUtil redisTemplateUtil;
    private static final String FXQ_CUSTOMER_OPEN_CONFIG_CODE = "fxq_customer_open_code";
    private static final String COUNTRY_CODE_CHINA = "CHINA";
    private static final String FXQ_CUSTOMER_TYPE_OPEN_CONFIG_CODE = "fxq_customer_type_open_code";
    private static final Map<String, String> ID_TYPE_MAP = new HashMap();
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy");
    private static final Map<String, String> ID_TYPE_DESC_MAP = new HashMap();
    private static String ENDOR_TYPE_01 = "01";
    private static String ENDOR_TYPE_04 = "04";
    private static String BUSS_TYPE_T = "T";
    private static String BUSS_TYPE_E = "E";
    private static String BUSS_TYPE_P = "P";
    private static String error_code_0 = "0";
    private static String error_code_1 = "1";

    public String getFxqCustomerOpen() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)FXQ_CUSTOMER_OPEN_CONFIG_CODE);
        ApisChannelConfigs configs = (ApisChannelConfigs)this.apisChannelConfigsMapper.selectOne((Wrapper)queryWrapper);
        if (configs == null) {
            return "0";
        }
        return configs.getConfigValue();
    }

    public String[] getFxqCustomerTypeOpenFlag() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)FXQ_CUSTOMER_TYPE_OPEN_CONFIG_CODE);
        ApisChannelConfigs configs = (ApisChannelConfigs)this.apisChannelConfigsMapper.selectOne((Wrapper)queryWrapper);
        if (configs == null || StringUtils.isBlank((CharSequence)configs.getConfigValue())) {
            return new String[]{"0", "0", "0", "0", "0", "0", "0"};
        }
        return configs.getConfigValue().split(",");
    }

    public void fxqCustomerData(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        if ("0".equals(this.getFxqCustomerOpen())) {
            log.warn("\u4e0d\u5f00\u542f\u53cd\u6d17\u94b1\u5ba2\u6237\u6821\u9a8c");
            return;
        }
        this.initMap();
        this.dataConversion(request, policyDTO);
    }

    public CommonsValidateResponseDTO callApi(StanderRequest request) {
        CommonsValidateResponseDTO response = new CommonsValidateResponseDTO(ChannelErrorCodeEnum.ERR_C10002.getKey(), ChannelErrorCodeEnum.ERR_C10002.getValue(), request.getHeader().getBussinessType());
        try {
            this.fxqCustomerRuleCheck(request);
        }
        catch (ApisBusinessException e) {
            response.code(e.getErrorCode()).message(e.getMessage());
        }
        return response;
    }

    public void fxqCustomerRuleCheck(StanderRequest request) throws ApisBusinessException {
        if ("0".equals(this.getFxqCustomerOpen())) {
            log.warn("\u53cd\u6d17\u94b1\u5ba2\u6237\u6821\u9a8c\u4e3a\u4e0d\u5f00\u542f\u72b6\u6001\uff0c\u4e0d\u8fdb\u884c\u53cd\u6d17\u94b1\u5ba2\u6237\u6821\u9a8c\u63a5\u53e3\u7684\u8c03\u7528");
            return;
        }
        log.warn("\u53cd\u6d17\u94b1\u68c0\u6d4b\u5f00\u59cb\u3002\u3002\u3002");
        String[] flag = this.getFxqCustomerTypeOpenFlag();
        Long startTime = System.currentTimeMillis();
        log.warn("\u53cd\u6d17\u94b1\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSONObject.toJSONString((Object)request.getFxqReqDTO()));
        FxqResDTO response = null;
        response = this.fxqCustomerCheckService.checkCustomerRisk(request.getFxqReqDTO());
        if (response == null) {
            log.error("\u53cd\u6d17\u94b1\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u786e\u8ba4\u5904\u7406\u65b9\u6848\u4e3a\uff1a\u62e6\u622a");
            this.sendFxqWarnEmail(request, response, ChannelErrorCodeEnum.ERR_C10600.getKey(), "\u53cd\u6d17\u94b1\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u786e\u8ba4\u5904\u7406\u65b9\u6848\u4e3a\uff1a\u62e6\u622a");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10600.getValue(), ChannelErrorCodeEnum.ERR_C10600.getKey());
        }
        log.warn("\u53cd\u6d17\u94b1\u63a5\u53e3\u63a5\u53e3\u8c03\u7528\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)response);
        if (FxqCustomerScenesEnum.SUCCESS.getCode().equals(response.getCode())) {
            if (response.getObjectData() == null || response.getObjectData().getCustList() == null) {
                log.warn("\u53cd\u6d17\u94b1\u68c0\u6d4b\u901a\u8fc7\uff0c\u5904\u7406\u610f\u89c1\u4e3a\uff1a\u4e0d\u62e6\u622a");
            } else {
                String businessKey = request.getHeader().getBusinessKey();
                List customerResDTOS = response.getObjectData().getCustList();
                for (CustomerResDTO customerResDTO : customerResDTOS) {
                    String additional = customerResDTO.getAdditional();
                    if (!customerResDTO.isCountryResult() && !customerResDTO.isResult()) continue;
                    if (customerResDTO.isCountryResult()) {
                        log.warn("FxqCustomerCheck:\u6765\u81ea\u9ad8\u98ce\u9669\u5730\u533a,\u53cd\u6d17\u94b1\u5904\u7406\u610f\u89c1\u4e3a\u62e6\u622a");
                        this.sendFxqWarnEmail(request, response, ChannelErrorCodeEnum.ERR_C10600.getKey(), "\u6765\u81ea\u9ad8\u98ce\u9669\u5730\u533a,\u53cd\u6d17\u94b1\u5904\u7406\u610f\u89c1\u4e3a\u62e6\u622a");
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10600.getValue(), ChannelErrorCodeEnum.ERR_C10600.getKey());
                    }
                    for (HighRiskPersonsDTO highRiskPersonsDTO : customerResDTO.getList()) {
                        String hitType = highRiskPersonsDTO.getHitType();
                        String sanctionType = highRiskPersonsDTO.getSanctionType();
                        if (!StringUtils.isNotBlank((CharSequence)hitType)) continue;
                        if (FxqCustomerScenesEnum.riskTypeU1.getCode().equals(hitType)) {
                            log.warn("\u53cd\u6d17\u94b1\u68c0\u6d4b\u901a\u8fc7\uff0c\u5904\u7406\u610f\u89c1\u4e3a\uff1a\u59d3\u540d\u547d\u4e2d\uff0c\u8bc1\u4ef6\u53f7\u672a\u547d\u4e2d,\u4e0d\u62e6\u622a");
                            continue;
                        }
                        if (FxqCustomerScenesEnum.riskTypeU2.getCode().equals(hitType) && "1".equals(flag[0])) {
                            log.warn("FxqCustomerCheck:\u2f64\u6237\u59d3\u540d\u547d\u4e2d\uff0c\u8bc1\u4ef6 \u53f7\u7801\u672a\u547d\u4e2d\uff08\u5ba2\u6237\u4f20\u2f0a\u8bc1 \u4ef6\u53f7\u7801\uff0c\u540d\u5355\u7cfb\u7edf\u4e2d\u6ca1\u6709 \u7ef4\u62a4\u8bc1\u4ef6\u53f7\u7801\uff09,\u53cd\u6d17\u94b1\u5904\u7406\u610f\u89c1\u4e3a\u62e6\u622a");
                            this.error(additional, error_code_0, hitType, request, response);
                            continue;
                        }
                        if (FxqCustomerScenesEnum.riskTypeU3.getCode().equals(hitType) && "1".equals(flag[1])) {
                            log.warn("FxqCustomerCheck:\u2f64\u6237\u59d3\u540d{}\u547d\u4e2d\uff0c\u8bc1\u4ef6 \u53f7\u7801\u672a\u547d\u4e2d\uff08\u5ba2\u6237\u6ca1\u6709\u4f20 \u2f0a\u8bc1\u4ef6\u53f7\u7801\uff0c\u540d\u5355\u7cfb\u7edf\u4e2d \u7ef4\u62a4\u6709\u8bc1\u4ef6\u53f7\u7801\uff09,\u53cd\u6d17\u94b1\u5904\u7406\u610f\u89c1\u4e3a\u62e6\u622a", (Object)highRiskPersonsDTO.getName());
                            this.error(additional, error_code_0, hitType, request, response);
                            continue;
                        }
                        if (FxqCustomerScenesEnum.riskTypeI.getCode().equals(hitType) && "1".equals(flag[2])) {
                            log.warn("FxqCustomerCheck:\u2f64\u6237{}\u8bc1\u4ef6\u53f7\u547d\u4e2d, \u59d3\u540d\u672a \u547d\u4e2d,\u53cd\u6d17\u94b1\u5904\u7406\u610f\u89c1\u4e3a\u62e6\u622a", (Object)highRiskPersonsDTO.getName());
                            this.error(additional, error_code_0, hitType, request, response);
                            continue;
                        }
                        if (FxqCustomerScenesEnum.riskTypeUI.getCode().equals(hitType) && "A".equals(sanctionType) && error_code_1.equals(flag[3])) {
                            log.warn("FxqCustomerCheck:\u5236\u88c1\u7c7b\u578b\u4e3a\u7279\u522b\u5173\u6ce8\u7c7b,\u2f64\u6237\u59d3\u540d{}\u4e0e\u8bc1\u4ef6\u53f7\u540c\u65f6\u547d\u4e2d,\u53cd\u6d17\u94b1\u5904\u7406\u610f\u89c1\u4e3a\u62e6\u622a", (Object)highRiskPersonsDTO.getName());
                            this.error(additional, error_code_1, hitType, request, response);
                            continue;
                        }
                        if (FxqCustomerScenesEnum.riskTypeUI.getCode().equals(hitType) && FxqCustomerScenesEnum.riskTypeS.getCode().equals(sanctionType) && error_code_1.equals(flag[4])) {
                            log.warn("FxqCustomerCheck:\u5236\u88c1\u7c7b\u578b\u4e3a\u7981\u6b62\u4ea4\u6613\u7c7b\uff0c\u2f64\u6237\u59d3\u540d{}\u4e0e\u8bc1\u4ef6\u53f7\u540c\u65f6\u547d\u4e2d,\u53cd\u6d17\u94b1\u5904\u7406\u610f\u89c1\u4e3a\u62e6\u622a", (Object)highRiskPersonsDTO.getName());
                            this.error(additional, error_code_1, hitType, request, response);
                            continue;
                        }
                        if (FxqCustomerScenesEnum.riskTypeUI.getCode().equals(hitType) && FxqCustomerScenesEnum.riskTypeT.getCode().equals(sanctionType) && error_code_1.equals(flag[5])) {
                            log.warn("FxqCustomerCheck:\u5236\u88c1\u7c7b\u578b\u4e3a\u6050\u6016\u5206\u2f26\uff0c\u2f64\u6237\u59d3\u540d{}\u4e0e\u8bc1\u4ef6\u53f7\u540c\u65f6\u547d\u4e2d,\u53cd\u6d17\u94b1\u5904\u7406\u610f\u89c1\u4e3a\u62e6\u622a", (Object)highRiskPersonsDTO.getName());
                            this.error(additional, error_code_1, hitType, request, response);
                            continue;
                        }
                        if (FxqCustomerScenesEnum.riskTypeUI.getCode().equals(hitType) && FxqCustomerScenesEnum.riskTypeP.getCode().equals(sanctionType) && error_code_1.equals(flag[6])) {
                            log.warn("FxqCustomerCheck:\u5236\u88c1\u7c7b\u578b\u4e3a\u653f\u6cbb\u2f08\u7269\uff0c\u2f64\u6237\u59d3\u540d{}\u4e0e\u8bc1\u4ef6\u53f7\u540c\u65f6\u547d\u4e2d,\u53cd\u6d17\u94b1\u5904\u7406\u610f\u89c1\u4e3a\u62e6\u622a", (Object)highRiskPersonsDTO.getName());
                            this.error(additional, error_code_0, hitType, request, response);
                            continue;
                        }
                        if (FxqCustomerScenesEnum.riskTypeU2B.getCode().equals(hitType) && error_code_1.equals(flag[7])) {
                            log.warn("FxqCustomerCheck: \u5ba2\u6237\u59d3\u540d{}\u547d\u4e2d\uff0c\u8bc1\u4ef6\u53f7\u7801\u672a\u547d\u4e2d,\u56fd\u7c4dC\u672a\u547d\u4e2d,\u51fa\u751f\u5e74\u4efdB\u547d\u4e2d\u3002,\u53cd\u6d17\u94b1\u5904\u7406\u610f\u89c1\u4e3a\u62e6\u622a", (Object)highRiskPersonsDTO.getName());
                            this.error(additional, error_code_0, hitType, request, response);
                            continue;
                        }
                        if (FxqCustomerScenesEnum.riskTypeU2BLANK.getCode().equals(hitType) && error_code_1.equals(flag[8])) {
                            log.warn("FxqCustomerCheck:\u5ba2\u6237\u59d3\u540d\u547d\u4e2d\uff0c\u8bc1\u4ef6\u53f7\u7801\u672a\u547d\u4e2d,\u56fd\u7c4dC\u672a\u547d\u4e2d\u3001\u51fa\u751f\u5e74\u4efdB\u672a\u547d\u4e2d,\u4e14\u51fa\u751f\u5e74\u4efd\u4e3a\u7a7a,\u53cd\u6d17\u94b1\u5904\u7406\u610f\u89c1\u4e3a\u4e0d\u62e6\u622a");
                            continue;
                        }
                        if (FxqCustomerScenesEnum.riskTypeU2C.getCode().equals(hitType) && error_code_1.equals(flag[9])) {
                            log.warn("FxqCustomerCheck:\u5ba2\u6237\u59d3\u540d\u547d\u4e2d\uff0c\u8bc1\u4ef6\u53f7\u7801\u672a\u547d\u4e2d,\u56fd\u7c4dC\u547d\u4e2d,\u51fa\u751f\u5e74\u4efdB\u672a\u547d\u4e2d,\u4e14\u51fa\u751f\u5e74\u4efd\u4e3a\u7a7a\u2f26,\u53cd\u6d17\u94b1\u5904\u7406\u610f\u89c1\u4e3a\u4e0d\u62e6\u622a");
                            continue;
                        }
                        if (!FxqCustomerScenesEnum.riskTypeU2CB.getCode().equals(hitType) || !error_code_1.equals(flag[10])) continue;
                        log.warn("FxqCustomerCheck:\u5ba2\u6237\u59d3\u540d{}\u547d\u4e2d\uff0c\u8bc1\u4ef6\u53f7\u7801\u672a\u547d\u4e2d,\u56fd\u7c4dC\u3001\u51fa\u751f\u5e74\u4efdB\u5168\u547d\u4e2d,\u53cd\u6d17\u94b1\u5904\u7406\u610f\u89c1\u4e3a\u62e6\u622a", (Object)highRiskPersonsDTO.getName());
                        this.error(additional, error_code_0, hitType, request, response);
                    }
                }
            }
        } else {
            if (FxqCustomerScenesEnum.ERROR_CODE_00000001.getCode().equals(response.getCode())) {
                this.sendFxqWarnEmail(request, response, FxqCustomerScenesEnum.ERROR_CODE_00000001.getCode(), FxqCustomerScenesEnum.ERROR_CODE_00000001.getDesc());
                throw new ApisBusinessException(FxqCustomerScenesEnum.ERROR_CODE_00000001.getDesc(), FxqCustomerScenesEnum.ERROR_CODE_00000001.getCode());
            }
            if (FxqCustomerScenesEnum.ERROR_CODE_500.getCode().equals(response.getCode())) {
                this.sendFxqWarnEmail(request, response, FxqCustomerScenesEnum.ERROR_CODE_500.getCode(), FxqCustomerScenesEnum.ERROR_CODE_500.getDesc());
                throw new ApisBusinessException(FxqCustomerScenesEnum.ERROR_CODE_500.getDesc(), FxqCustomerScenesEnum.ERROR_CODE_500.getCode());
            }
        }
        log.warn("\u53cd\u6d17\u94b1\u68c0\u6d4b\u7ed3\u675f\uff0c\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void dataConversion(StanderRequest request, PolicyDTO policyDTO) throws ApisDataCompletionException {
        FxqReqDTO checkRequestDTO = new FxqReqDTO();
        checkRequestDTO.setSystemSource(this.systemSource);
        List insuredList = null;
        List idvList = new ArrayList();
        List appliClientList = null;
        String additional = BUSS_TYPE_P;
        String endorseType = "";
        if (policyDTO == null) {
            insuredList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getInsuredList();
            appliClientList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getAppliClient();
            if ((insuredList == null || insuredList.size() == 0) && request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage() != null) {
                idvList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList();
            }
        } else {
            additional = BUSS_TYPE_E;
            if (request.getEndorseServiceRequest() != null && request.getEndorseServiceRequest().getRequestBody() != null && request.getEndorseServiceRequest().getRequestBody().getMain() != null) {
                endorseType = request.getEndorseServiceRequest().getRequestBody().getMain().getEndorseType();
            }
            if (ENDOR_TYPE_01.equals(endorseType) || ENDOR_TYPE_04.equals(endorseType)) {
                additional = BUSS_TYPE_T;
            }
            insuredList = policyDTO.getInsuredList();
            appliClientList = policyDTO.getAppliClient();
            if ((insuredList == null || insuredList.size() == 0) && policyDTO.getCoverage() != null) {
                idvList = policyDTO.getCoverage().getInsuredIdvList();
                if ((insuredList == null || insuredList.size() == 0) && policyDTO.getCoverage().getItemList() != null) {
                    idvList = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getInsuredIdvList();
                }
            }
        }
        checkRequestDTO.setRequestId(this.systemSource + UUID.fastUUID().toString().replaceAll("-", ""));
        ArrayList<CustomerDTO> customerDTOS = new ArrayList<CustomerDTO>();
        CustomerDTO customerDTO = null;
        int i = 0;
        if (insuredList != null && insuredList.size() > 0) {
            for (InsuredDTO insuredDTO : insuredList) {
                customerDTO = new CustomerDTO();
                customerDTO.setIndex(i + "");
                customerDTO.setName(insuredDTO.getInsuredName());
                customerDTO.setIdNo(insuredDTO.getIdentifyNumber());
                customerDTO.setIdType((String)ID_TYPE_MAP.get(insuredDTO.getIdentifyType()));
                customerDTO.setPersonType("2");
                if (insuredDTO.getBirthDate() != null || insuredDTO.getBirthday() != null) {
                    if (insuredDTO.getBirthDate() != null) {
                        customerDTO.setBornDate(SDF.format(insuredDTO.getBirthDate()));
                    } else {
                        customerDTO.setBornDate(SDF.format(insuredDTO.getBirthday()));
                    }
                } else if ("01".equals(insuredDTO.getIdentifyType())) {
                    customerDTO.setBornDate(insuredDTO.getIdentifyNumber().substring(6, 9));
                }
                if ("01".equals(insuredDTO.getIdentifyType())) {
                    customerDTO.setCountry(COUNTRY_CODE_CHINA);
                }
                customerDTO.setAdditional(additional);
                customerDTOS.add(customerDTO);
                ++i;
                if (insuredDTO.getBeneficiary() == null || insuredDTO.getBeneficiary().size() <= 0) continue;
                for (BeneficiaryDTO beneficiaryDTO : insuredDTO.getBeneficiary()) {
                    customerDTO = new CustomerDTO();
                    customerDTO.setIndex(i + "");
                    customerDTO.setName(beneficiaryDTO.getBeneficiaryName());
                    customerDTO.setIdNo(beneficiaryDTO.getIdentifyNumber());
                    customerDTO.setIdType((String)ID_TYPE_MAP.get(beneficiaryDTO.getIdentifyType()));
                    customerDTO.setPersonType("2");
                    if (beneficiaryDTO.getBirthday() != null) {
                        customerDTO.setBornDate(SDF.format(beneficiaryDTO.getBirthday()));
                    } else if ("01".equals(beneficiaryDTO.getIdentifyType())) {
                        customerDTO.setBornDate(beneficiaryDTO.getIdentifyNumber().substring(6, 9));
                    }
                    if ("01".equals(beneficiaryDTO.getIdentifyType())) {
                        customerDTO.setCountry(COUNTRY_CODE_CHINA);
                    }
                    customerDTO.setAdditional(additional);
                    customerDTOS.add(customerDTO);
                    ++i;
                }
            }
        } else if (idvList != null && idvList.size() > 0) {
            for (InsuredDTO insuredDTO : idvList) {
                customerDTO = new CustomerDTO();
                customerDTO.setIndex(i + "");
                customerDTO.setName(insuredDTO.getInsuredName());
                customerDTO.setIdNo(insuredDTO.getIdentifyNumber());
                customerDTO.setIdType((String)ID_TYPE_MAP.get(insuredDTO.getIdentifyType()));
                customerDTO.setPersonType("2");
                if (insuredDTO.getBirthday() != null) {
                    customerDTO.setBornDate(SDF.format(insuredDTO.getBirthday()));
                } else if ("01".equals(insuredDTO.getIdentifyType())) {
                    customerDTO.setBornDate(insuredDTO.getIdentifyNumber().substring(6, 9));
                }
                if ("01".equals(insuredDTO.getIdentifyType())) {
                    customerDTO.setCountry(COUNTRY_CODE_CHINA);
                }
                customerDTO.setAdditional(additional);
                customerDTOS.add(customerDTO);
                ++i;
                if (insuredDTO.getBeneficiary() == null || insuredDTO.getBeneficiary().size() <= 0) continue;
                for (BeneficiaryDTO beneficiaryDTO : insuredDTO.getBeneficiary()) {
                    customerDTO = new CustomerDTO();
                    customerDTO.setIndex(i + "");
                    customerDTO.setName(beneficiaryDTO.getBeneficiaryName());
                    customerDTO.setIdNo(beneficiaryDTO.getIdentifyNumber());
                    customerDTO.setIdType((String)ID_TYPE_MAP.get(beneficiaryDTO.getIdentifyType()));
                    customerDTO.setPersonType("2");
                    if (beneficiaryDTO.getBirthday() != null) {
                        customerDTO.setBornDate(SDF.format(beneficiaryDTO.getBirthday()));
                    } else if ("01".equals(beneficiaryDTO.getIdentifyType()) && StringUtils.isNotEmpty((CharSequence)beneficiaryDTO.getIdentifyNumber())) {
                        customerDTO.setBornDate(beneficiaryDTO.getIdentifyNumber().substring(6, 9));
                    }
                    customerDTO.setAdditional(additional);
                    if ("01".equals(beneficiaryDTO.getIdentifyType())) {
                        customerDTO.setCountry(COUNTRY_CODE_CHINA);
                    }
                    customerDTOS.add(customerDTO);
                    ++i;
                }
            }
        }
        for (AppliClientDTO appliClientDTO : appliClientList) {
            customerDTO = new CustomerDTO();
            customerDTO.setIndex(i + "");
            customerDTO.setName(appliClientDTO.getInsuredName());
            customerDTO.setIdNo(appliClientDTO.getIdentifyNumber());
            if (appliClientDTO.getBirthday() != null) {
                customerDTO.setBornDate(SDF.format(appliClientDTO.getBirthday()));
            } else if ("01".equals(appliClientDTO.getIdentifyType())) {
                customerDTO.setBornDate(appliClientDTO.getIdentifyNumber().substring(6, 9));
            }
            customerDTO.setIdType((String)ID_TYPE_MAP.get(appliClientDTO.getIdentifyType()));
            customerDTO.setPersonType("1");
            customerDTO.setAdditional(additional);
            customerDTOS.add(customerDTO);
            if ("01".equals(appliClientDTO.getIdentifyType())) {
                customerDTO.setCountry(COUNTRY_CODE_CHINA);
            }
            ++i;
        }
        checkRequestDTO.setCustList(customerDTOS);
        request.setFxqReqDTO(checkRequestDTO);
    }

    private void initMap() {
        ID_TYPE_MAP.put("01", "110001");
        ID_TYPE_MAP.put("02", "110005");
        ID_TYPE_MAP.put("03", "619999");
        ID_TYPE_MAP.put("04", "110007");
        ID_TYPE_MAP.put("05", "110007");
        ID_TYPE_MAP.put("06", "110013");
        ID_TYPE_MAP.put("07", "110023");
        ID_TYPE_MAP.put("08", "610099");
        ID_TYPE_MAP.put("09", "110019");
        ID_TYPE_MAP.put("10", "110021");
        ID_TYPE_MAP.put("11", "610099");
        ID_TYPE_MAP.put("12", "110009");
        ID_TYPE_MAP.put("13", "110003");
        ID_TYPE_MAP.put("14", "619999");
        ID_TYPE_MAP.put("51", "110027");
        ID_TYPE_MAP.put("52", "619999");
        ID_TYPE_MAP.put("53", "110029");
        ID_TYPE_MAP.put("99", "619999");
        ID_TYPE_MAP.put("71", "610001");
        ID_TYPE_MAP.put("72", "610007");
        ID_TYPE_MAP.put("73", "610047");
        ID_TYPE_MAP.put("74", "610099");
        ID_TYPE_DESC_MAP.put("110001", "\u5c45\u2ea0\u8eab\u4efd\u8bc1");
        ID_TYPE_DESC_MAP.put("110003", "\u4e34\u65f6\u5c45\u2ea0\u8eab\u4efd\u8bc1");
        ID_TYPE_DESC_MAP.put("110005", "\u6237\u2f1d\u7c3f");
        ID_TYPE_DESC_MAP.put("110007", "\u4e2d\u56fd\u2f08\u2ea0\u89e3\u653e\u519b\u519b\u2f08\u8eab\u4efd\u8bc1\u4ef6");
        ID_TYPE_DESC_MAP.put("110009", "\u4e2d\u56fd\u2f08\u2ea0\u6b66\u88c5\u8b66\u5bdf\u8eab\u4efd\u8bc1\u4ef6");
        ID_TYPE_DESC_MAP.put("110011", "\u79bb\u4f11\u2f32\u90e8\u8363\u8a89\u8bc1");
        ID_TYPE_DESC_MAP.put("110013", "\u519b\u5b98\u9000\u4f11\u8bc1");
        ID_TYPE_DESC_MAP.put("110015", "\u2f42\u804c\u2f32\u90e8\u9000\u4f11\u8bc1");
        ID_TYPE_DESC_MAP.put("110017", "\u519b\u4e8b\u9662\u6821\u5b66\u5458\u8bc1");
        ID_TYPE_DESC_MAP.put("110019", "\u6e2f\u6fb3\u5c45\u2ea0\u5f80\u6765\u5185\u5730\u901a\u2f8f\u8bc1");
        ID_TYPE_DESC_MAP.put("110021", "\u53f0\u6e7e\u5c45\u2ea0\u6765\u5f80\u2f24\u9646\u901a\u2f8f\u8bc1");
        ID_TYPE_DESC_MAP.put("110023", "\u4e2d\u534e\u2f08\u2ea0\u5171\u548c\u56fd\u56e0\u79c1\u62a4\u7167");
        ID_TYPE_DESC_MAP.put("110025", "\u4e2d\u534e\u2f08\u2ea0\u5171\u548c\u56fd\u56e0\u516c\u62a4\u7167");
        ID_TYPE_DESC_MAP.put("110027", "\u5916\u56fd\u62a4\u7167");
        ID_TYPE_DESC_MAP.put("110029", "\u5916\u56fd\u2f08\u6c38\u4e45\u5c45\u7559\u8bc1");
        ID_TYPE_DESC_MAP.put("119999", "\u5176\u4ed6\u7c7b\u5883\u5185\u4e2a\u2f08\u8eab\u4efd\u6709\u6548\u8bc1\u4ef6");
        ID_TYPE_DESC_MAP.put("129999", "\u5176\u4ed6\u7c7b\u5883\u5916\u4e2a\u2f08\u8eab\u4efd\u6709\u6548\u8bc1\u4ef6");
        ID_TYPE_DESC_MAP.put("610001", "\u5168\u56fd\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801");
        ID_TYPE_DESC_MAP.put("610003", "\u94f6\u2f8f\u673a\u6784\u4ee3\u7801");
        ID_TYPE_DESC_MAP.put("610005", "\u4f01\u4e1a\u6cd5\u2f08\u8425\u4e1a\u6267\u7167\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610007", "\u56fd\u7a0e\u767b\u8bb0\u8bc1\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610009", "\u2fa6\u878d\u8bb8\u53ef\u8bc1\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610011", "\u57fa\u672c\u5b58\u6b3e\u8d26\u6237\u5f00\u6237\u767b\u8bb0\u8bc1\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610013", "\u653f\u5e9c\u2f08\u4e8b\u90e8\u2ed4\u6279\u2f42\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610015", "\u7f16\u5236\u59d4\u5458\u4f1a\u6279\u2f42\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610017", "\u653f\u5e9c\u2f08\u4e8b\u90e8\u2ed4\u767b\u8bb0\u8bc1\u4e66\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610019", "\u7f16\u5236\u59d4\u5458\u4f1a\u767b\u8bb0\u8bc1\u4e66\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610021", "\u519b\u961f\u3001\u6b66\u8b66\u8d22\u52a1\u90e8\u2ed4\u5f00\u6237\u8bc1\u660e\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610023", "\u793e\u4f1a\u56e2\u4f53\u767b\u8bb0\u8bc1\u4e66\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610025", "\u2ea0\u529e\u2fae\u4f01\u4e1a\u767b\u8bb0\u8bc1\u4e66\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610027", "\u5916\u5730\u5e38\u8bbe\u673a\u6784\u9a7b\u5728\u5730\u653f\u5e9c\u4e3b\u7ba1\u90e8\u2ed4\u6279\u2f42\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610029", "\u56fd\u5bb6\u4e3b\u7ba1\u90e8\u2ed4\u9881\u5916\u56fd\u9a7b\u534e\u673a\u6784\u6279\u2f42\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610031", "\u56fd\u5bb6\u767b\u8bb0\u673a\u5173\u9881\u5916\u8d44\u4f01\u4e1a\u9a7b\u534e\u4ee3\u8868\u3001\u529e\u4e8b\u5904\u767b\u8bb0\u8bc1\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610033", "\u4e3b\u7ba1\u90e8\u2ed4\u9881\u5c45\u2ea0\u3001\u6751\u2ea0\u3001\u793e\u533a\u59d4\u5458\u4f1a\u6279\u2f42\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610035", "\u72ec\u2f74\u6838\u7b97\u7684\u9644\u5c5e\u673a\u6784\u6279\u2f42\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610037", "\u4e3b\u7ba1\u90e8\u2ed4\u6279\u2f42\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610039", "\u8d22\u653f\u90e8\u2ed4\u8bc1\u660e\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610041", "\u8bc1\u5238\u6295\u8d44\u4e1a\u52a1\u8bb8\u53ef\u8bc1\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610043", "\u4e34\u65f6\u7ecf\u8425\u5730\u2f2f\u5546\u2f8f\u653f\u7ba1\u7406\u90e8\u2ed4\u6279\u2f42\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610045", "\u4f01\u4e1a\u540d\u79f0\u9884\u5148\u6838\u51c6\u901a\u77e5\u4e66\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610047", "\u4f01\u4e1a\u8425\u4e1a\u6267\u7167\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610049", "\u4e2a\u4f53\u2f2f\u5546\u6237\u8425\u4e1a\u6267\u7167\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610051", "\u5730\u7a0e\u767b\u8bb0\u8bc1\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610053", "\u5b97\u6559\u4e8b\u52a1\u7ba1\u7406\u90e8\u2ed4\u7684\u6279\u2f42\u6216\u8bc1\u660e\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610055", "\u501f\u6b3e\u5408\u540c\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610057", "\u56fd\u5bb6\u5916\u6c47\u7ba1\u7406\u90e8\u2ed4\u7684\u6279\u590d\u2f42\u4ef6\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610059", "\u4e3b\u7ba1\u90e8\u2ed4\u8bb8\u53ef\u8bc1\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610061", "\u5efa\u7b51\u65bd\u2f2f\u53ca\u5b89\u88c5\u5408\u540c\u53f7\u7801");
        ID_TYPE_DESC_MAP.put("610099", "\u7edf\u2f00\u793e\u4f1a\u4fe1\u2f64\u4ee3\u7801(\u4e94\u8bc1\u5408\u2f00\u53f7 \u7801)");
        ID_TYPE_DESC_MAP.put("619999", "\u5176\u4ed6\u7c7b\u5883\u5185\u673a\u6784\u4ee3\u7801");
        ID_TYPE_DESC_MAP.put("629999", "\u5176\u4ed6\u7c7b\u5883\u5916\u673a\u6784\u4ee3\u7801");
    }

    public void addFxqCheck(StanderRequest request, List<CommonsExecutorRequestDTO> requestList) {
        if (this.getFxqCustomerOpen().equals("0")) {
            log.warn("\u4e0d\u5f00\u542f\u53cd\u6d17\u94b1\u5ba2\u6237\u6821\u9a8c\u68c0\u6d4b\uff0c\u4e0d\u8fdb\u884c\u63a5\u53e3\u8c03\u7528");
            return;
        }
        requestList.add(new CommonsExecutorRequestDTO(this.fxqCustomerUrl, (Object)request, CommonsValidateResponseDTO.class));
    }

    private void error(String bussType, String errorType, String hitType, StanderRequest request, FxqResDTO response) throws ApisBusinessException {
        this.saveFxqResponeLog(request, response);
        this.sendFxqWarnEmail(request, response, hitType, "\u53cd\u6d17\u94b1\u62e6\u622a\u547d\u4e2d");
        if (BUSS_TYPE_P.equals(bussType) && error_code_0.equals(errorType)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10600.getValue(), ChannelErrorCodeEnum.ERR_C10600.getKey() + hitType);
        }
        if (BUSS_TYPE_P.equals(bussType) && error_code_1.equals(errorType)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10601.getValue(), ChannelErrorCodeEnum.ERR_C10601.getKey() + hitType);
        }
        if (BUSS_TYPE_E.equals(bussType) && error_code_0.equals(errorType)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10607.getValue(), ChannelErrorCodeEnum.ERR_C10603.getKey() + hitType);
        }
        if (BUSS_TYPE_E.equals(bussType) && error_code_1.equals(errorType)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10604.getValue(), ChannelErrorCodeEnum.ERR_C10604.getKey() + hitType);
        }
        if (BUSS_TYPE_T.equals(bussType) && error_code_0.equals(errorType)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10605.getValue(), ChannelErrorCodeEnum.ERR_C10605.getKey() + hitType);
        }
        if (BUSS_TYPE_T.equals(bussType) && error_code_1.equals(errorType)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10606.getValue(), ChannelErrorCodeEnum.ERR_C10606.getKey() + hitType);
        }
    }

    public void saveFxqResponeLog(StanderRequest request, FxqResDTO response) {
        try {
            CoreDtoConverter converter = this.coreDtoConverterFactory.get("JSON");
            String api = "fxqRiskCustomer";
            String bodyStr = converter.toPacketStr((Object)response);
            ApisBusiReqmsgLog apisBusiReqmsgLog = new ApisBusiReqmsgLog();
            apisBusiReqmsgLog.setApiCode(api);
            apisBusiReqmsgLog.setLogContent(bodyStr);
            apisBusiReqmsgLog.setLogType("2");
            apisBusiReqmsgLog.setOrderNo(request.getHeader().getBusinessKey());
            apisBusiReqmsgLog.setCreator(request.getHeader().getUserCode());
            this.apisBusiReqmsgLogService.save((Object)apisBusiReqmsgLog);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u53cd\u6d17\u94b1\u4ea4\u4e92\u8fd4\u56de\u65e5\u5fd7\u65f6\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)request.getHeader().getBusinessKey(), (Object)e);
        }
    }

    public void sendFxqWarnEmail(StanderRequest request, FxqResDTO response, String code, String message) {
        String sendFxqWarnEmail = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("FXQ_WARN_EMAIL_SEND_CONFIG", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        if ("1".equals(sendFxqWarnEmail)) {
            this.warnSendService.convertSaveWarnAndSendEmail("/FXQ_RISK_INTERCEPT", request, code, message, this.handleFxqResp(request, response, message));
        }
    }

    private String handleFxqResp(StanderRequest request, FxqResDTO fxqResDTO, String message) {
        List appliClientList = null;
        PolicyDTO policyDTO = request.getPolicyDetail();
        appliClientList = policyDTO == null ? request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getAppliClient() : policyDTO.getAppliClient();
        StringBuilder sb = new StringBuilder();
        if (ObjectUtil.isEmpty((Object)fxqResDTO) || ObjectUtil.isEmpty((Object)fxqResDTO.getObjectData())) {
            sb.append(message);
            sb.append("\n");
        } else {
            List customerResDTOList = fxqResDTO.getObjectData().getCustList();
            if (ObjectUtil.isNotEmpty((Object)customerResDTOList)) {
                List fxqAppliClientList = customerResDTOList.stream().filter(f -> "1".equals(f.getPersonType())).collect(Collectors.toList());
                List riskCustomerList = customerResDTOList.stream().filter(p -> !"1".equals(p.getPersonType()) && (p.isCountryResult() || p.isResult())).collect(Collectors.toList());
                sb.append(this.handleCustomerList(fxqAppliClientList, appliClientList));
                sb.append(this.handleCustomerList(riskCustomerList, null));
            }
        }
        sb.append("\n");
        sb.append("\u62a5\u544a\u65f6\u95f4\uff1a");
        sb.append(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        return sb.toString();
    }

    private String handleCustomerList(List<CustomerResDTO> customerList, List<AppliClientDTO> appliClientList) {
        if (ObjectUtil.isEmpty(customerList)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String applicantTemplateNoHit = "\u6295\u4fdd\u4eba\u540d\u79f0\uff1a{0}\n \u6295\u4fdd\u4eba\u8bc1\u4ef6\u7c7b\u578b\uff1a{1}\n \u6295\u4fdd\u4eba\u8bc1\u4ef6\u53f7\uff1a{2}\n \u6295\u4fdd\u4eba\u8054\u7cfb\u7535\u8bdd\uff1a{3}\n \u6295\u4fdd\u4eba\u7535\u5b50\u90ae\u7bb1\uff1a{4}\n";
        String applicantTemplateHit = "\u6295\u4fdd\u4eba\u540d\u79f0\uff1a{0}\n \u6295\u4fdd\u4eba\u8bc1\u4ef6\u7c7b\u578b\uff1a{1}\n \u6295\u4fdd\u4eba\u8bc1\u4ef6\u53f7\uff1a{2}\n \u6295\u4fdd\u4eba\u8054\u7cfb\u7535\u8bdd\uff1a{3}\n \u6295\u4fdd\u4eba\u7535\u5b50\u90ae\u7bb1\uff1a{4}\n \u547d\u4e2d\u89c4\u5219\u4ee3\u7801\uff1a{5}\n";
        String insuredTemplate = "\u88ab\u4fdd\u9669\u4eba\u540d\u79f0\uff1a{0}\n \u88ab\u4fdd\u9669\u4eba\u8bc1\u4ef6\u7c7b\u578b\uff1a{1}\n \u88ab\u4fdd\u9669\u4eba\u8bc1\u4ef6\u53f7\uff1a{2}\n \u547d\u4e2d\u89c4\u5219\u4ee3\u7801\uff1a{3}\n";
        customerList.forEach(f -> {
            List highRiskPersonsDTOList = f.getList();
            String hitTypeList = "\u627e\u4e0d\u5230\u547d\u4e2d\u89c4\u5219\u4ee3\u7801";
            if (ObjectUtil.isNotEmpty((Object)highRiskPersonsDTOList)) {
                hitTypeList = highRiskPersonsDTOList.stream().map(HighRiskPersonsDTO::getHitType).collect(Collectors.joining(", "));
            }
            if ("1".equals(f.getPersonType())) {
                String phone = "";
                String email = "";
                if (ObjectUtil.isNotEmpty((Object)appliClientList)) {
                    AppliClientDTO appliClientDTO = appliClientList.stream().filter(a -> a.getIdentifyNumber().equals(f.getIdNo())).findAny().orElse(AppliClientDTO.builder().build());
                    phone = Stream.of(appliClientDTO.getContactPhone(), appliClientDTO.getMobile()).filter(ObjectUtil::isNotEmpty).collect(Collectors.joining(", "));
                    email = appliClientDTO.getEmail();
                }
                if (f.isResult() || f.isCountryResult()) {
                    sb.append(MessageFormat.format(applicantTemplateHit, f.getName(), ID_TYPE_DESC_MAP.getOrDefault(f.getIdType(), f.getIdType()), f.getIdNo(), phone, email, hitTypeList));
                } else {
                    sb.append(MessageFormat.format(applicantTemplateNoHit, f.getName(), ID_TYPE_DESC_MAP.getOrDefault(f.getIdType(), f.getIdType()), f.getIdNo(), phone, email));
                }
            } else {
                sb.append(MessageFormat.format(insuredTemplate, f.getName(), ID_TYPE_DESC_MAP.getOrDefault(f.getIdType(), f.getIdType()), f.getIdNo(), hitTypeList));
            }
            sb.append("\n");
        });
        return sb.toString();
    }
}

