/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HttpClientJsonUtil {
    private static Logger log = LoggerFactory.getLogger(HttpClientJsonUtil.class);
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_JSON = "application/json;charset=utf-8";
    public static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    OkHttpClient client = new OkHttpClient.Builder().connectTimeout(400L, TimeUnit.SECONDS).readTimeout(400L, TimeUnit.SECONDS).build();

    public String requestJson(String reqJson, String url) throws Exception {
        try {
            RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)reqJson);
            Request request = new Request.Builder().header("Content-Type", CONTENT_TYPE_JSON).url(url).post(body).build();
            Call call = this.client.newCall(request);
            try {
                Response response = call.execute();
                String responseBodyStr = response.body().string();
                return responseBodyStr;
            }
            catch (IOException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            log.error("=============call api error :{}", (Object)url);
            throw e;
        }
    }

    public String request(String url) throws Exception {
        try {
            Request request = new Request.Builder().header("Content-Type", CONTENT_TYPE_JSON).url(url).get().build();
            Call call = this.client.newCall(request);
            try {
                Response response = call.execute();
                String responseBodyStr = response.body().string();
                return responseBodyStr;
            }
            catch (IOException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            log.error("=============call api error :{}", (Object)url);
            throw e;
        }
    }
}

