/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.CancelAutoDeductionMqDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CommonsExecutorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InsureCancelAutoDeductionPushUtil {
    private static final Logger log = LoggerFactory.getLogger(InsureCancelAutoDeductionPushUtil.class);
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    HttpRequestService httpRequestService;

    private void pushCancelAutoDeduction(List<CancelAutoDeductionMqDTO> dtoList, ApisBusiTaskLog taskLog) {
        try {
            ApisChannelConfigs config = this.getConfig();
            if (ObjectUtils.isEmpty((Object)config)) {
                if (ObjectUtil.isNotEmpty((Object)taskLog)) {
                    taskLog.setPushStatus("5");
                    taskLog.setRemark("\u672a\u914d\u7f6e\u51fa\u5355\u8d26\u53f7\u671f\u7f34\u4fdd\u5355\u7f34\u8d39\u4fe1\u606f\u63a8\u9001URL");
                    this.apisBusiTaskLogService.updateById((Object)taskLog);
                }
                return;
            }
            String pushUrl = config.getConfigValue();
            dtoList.forEach(dto -> {
                dto.setUserCode(config.getUserCode());
                dto.setChannelCode(config.getChannelCode());
            });
            if (ObjectUtil.isEmpty((Object)taskLog)) {
                taskLog = new ApisBusiTaskLog();
                taskLog.setPushType(ApisAutoTaskConstantsEnum.CANCEL_AUTO_DEDUCTION_TO_AGENT.getValue());
                taskLog.setBusinessKey(dtoList.get(0).getPolicyNo());
            } else {
                taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
            }
            taskLog.setPushStatus("2");
            taskLog.setLastPushTime(LocalDateTime.now());
            taskLog.setPushTargetUrl(pushUrl);
            taskLog.setPushContent(JSON.toJSONString(dtoList));
            CommonsExecutorResponseDTO responseDTO = (CommonsExecutorResponseDTO)this.httpRequestService.convertAndSendForAgent(pushUrl, dtoList, CommonsExecutorResponseDTO.class, ApisAutoTaskConstantsEnum.CANCEL_AUTO_DEDUCTION_TO_AGENT.getValue());
            if (ObjectUtils.isEmpty((Object)responseDTO) || ObjectUtils.isEmpty((Object)responseDTO.getCode())) {
                taskLog.setPushStatus("4");
                taskLog.setErrMsg("\u6295\u4fdd\u672a\u7b7e\u7ea6\u6216\u89e3\u7ea6\u81ea\u52a8\u6263\u8d39\u6e20\u9053\u672a\u8fd4\u56de\u5185\u5bb9");
                String policyNos = dtoList.stream().map(CancelAutoDeductionMqDTO::getPolicyNo).collect(Collectors.joining(","));
                log.error("\u6295\u4fdd\u672a\u7b7e\u7ea6\u6216\u89e3\u7ea6\u81ea\u52a8\u6263\u8d39\u5df2\u63a8\u9001\u672a\u8fd4\u56de\uff0c\u4fdd\u5355\u53f7\u4e3a: {}", (Object)policyNos);
            } else {
                if (responseDTO.getCode() == 0) {
                    taskLog.setPushStatus("1");
                } else {
                    taskLog.setPushStatus("4");
                }
                taskLog.setErrMsg(JSON.toJSONString((Object)responseDTO));
            }
        }
        catch (Exception e) {
            log.error("\u6295\u4fdd\u672a\u7b7e\u7ea6\u6216\u89e3\u7ea6\u81ea\u52a8\u6263\u8d39\u6d88\u606f\u63a8\u9001\u5931\u8d25 error:", (Throwable)e);
            taskLog.setPushStatus("4");
            if (StringUtils.isNotBlank((CharSequence)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT) {
                taskLog.setErrMsg(e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT));
            }
            taskLog.setErrMsg(e.getMessage());
        }
        if (ObjectUtils.isEmpty((Object)taskLog.getId())) {
            this.apisBusiTaskLogService.saveTaskInfo(taskLog);
        } else {
            this.apisBusiTaskLogService.updateById((Object)taskLog);
        }
    }

    public void pushCancelAutoDeduction(List<CancelAutoDeductionMqDTO> dtoList) {
        this.pushCancelAutoDeduction(dtoList, null);
    }

    public void pushCancelAutoDeductionTask(ApisBusiTaskLog taskLog) {
        List dtoList;
        if (ObjectUtil.isEmpty((Object)taskLog)) {
            log.error("\u63a8\u9001\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if (ObjectUtil.isEmpty((Object)taskLog.getPushContent())) {
            log.error("\u4efb\u52a1businessKey={}, \u6ca1\u6709\u8981\u63a8\u9001\u7684\u8bf7\u6c42\u4fe1\u606f", (Object)taskLog.getBusinessKey());
            return;
        }
        try {
            dtoList = JSON.parseArray((String)taskLog.getPushContent(), CancelAutoDeductionMqDTO.class);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u65e5\u5fd7\u63a8\u9001\u5185\u5bb9\u5e8f\u5217\u5316\u5931\u8d25,", (Throwable)e);
            return;
        }
        this.pushCancelAutoDeduction(dtoList, taskLog);
    }

    private ApisChannelConfigs getConfig() {
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode("CancelAutoDeductionPushUrl");
        ApisChannelConfigs channelConfig = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        if (ObjectUtil.isEmpty((Object)channelConfig) || StringUtils.isBlank((CharSequence)channelConfig.getConfigValue())) {
            log.error("\u672a\u914d\u7f6e\u6295\u4fdd\u672a\u7b7e\u7ea6\u6216\u89e3\u7ea6\u81ea\u52a8\u6263\u8d39\u72b6\u6001\u63a8\u9001Url");
        }
        return channelConfig;
    }
}

