/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.domain.healthopen.InsuranceCompanyApiService.request.modifyPolicy.PolicyHolderInfo;
import com.jd.open.api.sdk.domain.healthopen.InsuranceCompanyApiService.request.modifyPolicy.PolicyInsuredInfo;
import com.jd.open.api.sdk.domain.healthopen.InsuranceCompanyApiService.request.modifyPolicy.PolicyModificationParam;
import com.jd.open.api.sdk.domain.healthopen.InsuranceCompanyApiService.request.receivePolicyInfo.PolicyReceiveInfoParam;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.request.healthopen.JdhInsuranceModifyPolicyRequest;
import com.jd.open.api.sdk.request.healthopen.JdhInsuranceReceivePolicyInfoRequest;
import com.jd.open.api.sdk.request.healthopen.JdhInsuranceReceivePolicySurrenderInfoRequest;
import com.jd.open.api.sdk.response.healthopen.JdhInsuranceModifyPolicyResponse;
import com.jd.open.api.sdk.response.healthopen.JdhInsuranceReceivePolicyInfoResponse;
import com.jd.open.api.sdk.response.healthopen.JdhInsuranceReceivePolicySurrenderInfoResponse;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderPolicyDetailHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.EPolicyDownServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.TaskUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyModificationHolderDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyModificationInsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.EPolicyDownRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.EPolicyDownServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.jdh.HolderInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.jdh.InsuredInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.jdh.NotifyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.jdh.NotifyPolicyModifiyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.jdh.NotifyPolicySurrenderDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.jdh.PolicyInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.jdh.ProductScheme;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.jdh.ProductSchemeInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.jdh.RiskInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUwResultMsgDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class JDHNotifyUtils {
    private static final Logger log = LoggerFactory.getLogger(JDHNotifyUtils.class);
    @Autowired
    StanderPolicyDetailHandler standerPolicyDetailHandler;
    @Autowired
    private EPolicyDownServiceImpl ePolicyDownService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    TaskUtil taskUtil;
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Value(value="${jdh.pushUrl}")
    private String pushUrl;
    @Value(value="${jdh.accessToken}")
    private String accessToken;
    @Value(value="${jdh.appId}")
    private String appKey;
    @Value(value="${jdh.appSecret}")
    private String appSecret;
    @Value(value="${jdh.companyToken}")
    private String companyToken;
    public static Map<String, String> idTypeMap = new /* Unavailable Anonymous Inner Class!! */;
    public static Map<String, String> relationMap = new /* Unavailable Anonymous Inner Class!! */;
    private BigDecimal unit = new BigDecimal(100);

    public void messageDeal(String message, LitigationUwResultMsgDTO dto) {
        log.warn("JDH\u9700\u6c42MQ\u8f6c\u6362\u5b9e\u4f8b,{}", (Object)JSON.toJSONString((Object)dto));
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        apisMsgMqlogs.setCreateTime((Date)DateUtil.date());
        apisMsgMqlogs.setMessage(message);
        apisMsgMqlogs.setTopic("apisTopic");
        apisMsgMqlogs.setConsumerGroup("fccbApisUndwResult");
        apisMsgMqlogs.setErrorFlag("0");
        this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
        if ("P".equals(dto.getMsgType())) {
            this.notifyPolicyInfo(dto.getPolicyNo(), apisMsgMqlogs);
        } else if ("E".equals(dto.getMsgType()) && "06".equals(dto.getEndorseType())) {
            this.pushPolicyModifiy(dto, apisMsgMqlogs);
        } else if ("E".equals(dto.getMsgType()) && ("01".equals(dto.getEndorseType()) || "04".equals(dto.getEndorseType()))) {
            this.pushPolicySurrender(dto, apisMsgMqlogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushPolicySurrender(LitigationUwResultMsgDTO dto, ApisMsgMqlogs apisMsgMqlogs) {
        String flag = "0";
        try {
            String[] endSplits = dto.getEndorseDate().split(" ");
            String[] validSplits = dto.getValidDate().split(" ");
            NotifyPolicySurrenderDTO notifyPolicySurrenderDto = NotifyPolicySurrenderDTO.builder().policyNo(dto.getPolicyNo()).surrenderDate(endSplits[0]).surrenderEffectDate(validSplits[0]).dayFlag("1".equals(dto.getEdorType()) ? "1" : "0").partFlag(this.getPartFlag(dto.getSumPremium(), dto.getChgSumPremium()) != false ? "1" : "0").surrenderProtectId(dto.getApplyNo()).companyToken(this.companyToken).build();
            this.pushJDHSurrenderPolicy(notifyPolicySurrenderDto);
        }
        catch (Exception e) {
            flag = "1";
            log.error("JDH\u9700\u6c42\u63a8\u9001\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a: ", (Throwable)e);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }

    private Boolean getPartFlag(BigDecimal a, BigDecimal b) {
        return a.add(b).compareTo(new BigDecimal(0)) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushPolicyModifiy(LitigationUwResultMsgDTO dto, ApisMsgMqlogs apisMsgMqlogs) {
        String flag = "0";
        try {
            NotifyPolicyModifiyDTO notifyPolicyModifiyDto = NotifyPolicyModifiyDTO.builder().policyNo(dto.getPolicyNo()).holderInfo((PolicyModificationHolderDTO)dto.getPolicyModificationHolders().get(0)).insuredInfoList(dto.getPolicyModificationInsureds()).changeTime(dto.getEndorseDate()).companyToken(this.companyToken).build();
            this.pushJDHModifyPolicy(notifyPolicyModifiyDto);
        }
        catch (Exception e) {
            flag = "1";
            log.error("JDH\u9700\u6c42\u63a8\u9001\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:", (Throwable)e);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }

    private ApisBusiChannelOrder getOrder(LitigationUwResultMsgDTO msg) {
        ApisBusiChannelOrder order = null;
        if (ObjectUtil.isNotEmpty((Object)msg) && ObjectUtil.isNotEmpty((Object)msg.getPolicyNo())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"policy_no", (Object)msg.getPolicyNo());
            order = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
        } else {
            log.error("JDH\u63a8\u9001\u5931\u8d25-\u300b\u4fdd\u5355\u53f7\u4e3a\u7a7a\u3002");
        }
        return order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushJDHModifyPolicy(NotifyPolicyModifiyDTO dto) {
        boolean success = true;
        DefaultJdClient client = new DefaultJdClient(this.pushUrl, this.accessToken, this.appKey, this.appSecret);
        JdhInsuranceModifyPolicyRequest request = new JdhInsuranceModifyPolicyRequest();
        PolicyModificationParam bodyParam = new PolicyModificationParam();
        bodyParam.setChangeTime(dto.getChangeTime());
        bodyParam.setCompanyToken(dto.getCompanyToken());
        bodyParam.setPolicyNo(dto.getPolicyNo());
        this.setContentHolderInfo(bodyParam, dto.getHolderInfo());
        this.setContentInsureList(bodyParam, dto.getInsuredInfoList());
        request.setParam(bodyParam);
        try {
            JdhInsuranceModifyPolicyResponse response = (JdhInsuranceModifyPolicyResponse)client.execute((JdRequest)request);
            log.warn("JDH\u63a8\u9001\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)response));
            if (!response.getCode().equals("0")) {
                log.warn("JDH\u63a8\u9001\u5931\u8d25\uff0c{}", (Object)response.getMsg());
                success = false;
            }
            if (!response.getResult().getCode().equals("0000")) {
                log.warn("JDH\u63a8\u9001\u5931\u8d25\uff0c{}", (Object)response.getResult().getMsg());
                success = false;
            }
        }
        catch (Exception e) {
            log.error("JDH\u63a8\u9001\u5931\u8d25: ", (Throwable)e);
            success = false;
        }
        finally {
            this.taskLogSave(dto.getPolicyNo(), success);
        }
    }

    public void setContentInsureList(PolicyModificationParam param, List<PolicyModificationInsuredDTO> list) {
        ArrayList<PolicyInsuredInfo> insuredInfoList = new ArrayList<PolicyInsuredInfo>();
        for (PolicyModificationInsuredDTO dto : list) {
            PolicyInsuredInfo policyInsuredInfo = new PolicyInsuredInfo();
            policyInsuredInfo.setInsuredBirthday(dto.getModificationAfterInsuredBirthday());
            policyInsuredInfo.setInsuredCardNo(dto.getModificationAfterInsuredCardNo());
            policyInsuredInfo.setInsuredCardType((String)idTypeMap.get(dto.getModificationAfterInsuredCardType()));
            policyInsuredInfo.setInsuredSex(dto.getModificationAfterInsuredSex());
            policyInsuredInfo.setInsuredEmail(dto.getModificationAfterInsuredEmail());
            policyInsuredInfo.setInsuredMobile(dto.getModificationAfterInsuredMobile());
            policyInsuredInfo.setInsuredName(dto.getModificationAfterInsuredName());
            policyInsuredInfo.setInsuredRelation((String)relationMap.get(dto.getModificationAfterInsuredRelation()));
            policyInsuredInfo.setInsuredType(dto.getModificationAfterInsuredType());
            insuredInfoList.add(policyInsuredInfo);
        }
        param.setInsuredInfoList(insuredInfoList);
    }

    public void setContentHolderInfo(PolicyModificationParam param, PolicyModificationHolderDTO dto) {
        PolicyHolderInfo info = new PolicyHolderInfo();
        info.setHolderBirthday(dto.getModificationAfterHolderBirthday());
        info.setHolderCardNo(dto.getModificationAfterHolderCardNo());
        info.setHolderCardType((String)idTypeMap.get(dto.getModificationAfterHolderCardType()));
        info.setHolderEmail(dto.getModificationAfterHolderEmail());
        info.setHolderSex(dto.getModificationAfterHolderSex());
        info.setHolderName(dto.getModificationAfterHolderName());
        info.setHolderMobile(dto.getModificationAfterHolderMobile());
        info.setHolderType(dto.getModificationAfterHolderType());
        param.setHolderInfo(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushJDHSurrenderPolicy(NotifyPolicySurrenderDTO dto) {
        boolean success = true;
        DefaultJdClient client = new DefaultJdClient(this.pushUrl, this.accessToken, this.appKey, this.appSecret);
        JdhInsuranceReceivePolicySurrenderInfoRequest request = new JdhInsuranceReceivePolicySurrenderInfoRequest();
        request.setCompanyToken(dto.getCompanyToken());
        request.setDayFlag(dto.getDayFlag());
        request.setEdorFlag(dto.getEdorFlag());
        request.setPolicyNo(dto.getPolicyNo());
        request.setSurrenderDate(dto.getSurrenderDate());
        request.setSurrenderEffectDate(dto.getSurrenderEffectDate());
        request.setSurrenderProtectId(dto.getSurrenderProtectId());
        request.setPartFlag(dto.getPartFlag());
        try {
            JdhInsuranceReceivePolicySurrenderInfoResponse response = (JdhInsuranceReceivePolicySurrenderInfoResponse)client.execute((JdRequest)request);
            log.warn("JDH\u63a8\u9001\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)response));
            if (!response.getCode().equals("0")) {
                log.warn("JDH\u63a8\u9001\u5931\u8d25\uff0c{}", (Object)response.getMsg());
                success = false;
            }
            if (!response.getResult().getCode().equals("0000")) {
                log.warn("JDH\u63a8\u9001\u5931\u8d25\uff0c{}", (Object)response.getResult().getMsg());
                success = false;
            }
        }
        catch (Exception e) {
            log.error("JDH\u63a8\u9001\u5931\u8d25: ", (Throwable)e);
            success = false;
        }
        finally {
            this.taskLogSave(dto.getPolicyNo(), success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushJDHPolicyInfo(NotifyDTO dto) {
        boolean success = true;
        DefaultJdClient client = new DefaultJdClient(this.pushUrl, this.accessToken, this.appKey, this.appSecret);
        JdhInsuranceReceivePolicyInfoRequest request = new JdhInsuranceReceivePolicyInfoRequest();
        PolicyReceiveInfoParam bodyParam = (PolicyReceiveInfoParam)JSON.parseObject((String)JSON.toJSONString((Object)dto), PolicyReceiveInfoParam.class);
        request.setBodyParam(bodyParam);
        try {
            JdhInsuranceReceivePolicyInfoResponse response = (JdhInsuranceReceivePolicyInfoResponse)client.execute((JdRequest)request);
            log.warn("JDH\u63a8\u9001\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)response));
            if (!response.getCode().equals("0")) {
                log.warn("JDH\u63a8\u9001\u5931\u8d25\uff0c{}", (Object)response.getMsg());
                success = false;
            }
            if (!response.getReturnType().getCode().equals("0000")) {
                log.warn("JDH\u63a8\u9001\u5931\u8d25\uff0c{}", (Object)response.getReturnType().getMsg());
                success = false;
            }
        }
        catch (Exception e) {
            log.error("JDH\u63a8\u9001\u5931\u8d25: ", (Throwable)e);
            success = false;
        }
        finally {
            this.taskLogSave(dto.getPolicyInfo().getPolicyNo(), success);
        }
    }

    public void taskLogSave(String businessKey, boolean success) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)businessKey)) {
            businessKey = "\u9ed8\u8ba4";
        }
        ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
        apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.JDH_NOTIFY_CALLBACK.getValue());
        apisBusiTaskLog.setBusinessKey(businessKey);
        apisBusiTaskLog.setRemark("\u8ba2\u5355\u53f7\uff1a" + businessKey);
        apisBusiTaskLog.setPushStep(Integer.valueOf(1));
        apisBusiTaskLog.setPushContent(null);
        apisBusiTaskLog.setPushTargetUrl(null);
        apisBusiTaskLog.setLastPushTime(LocalDateTime.now());
        apisBusiTaskLog.setPushStatus(success ? "1" : "4");
        this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushAndSave(String policyNo, String content, ApisMsgMqlogs apisMsgMqlogs, String taskValue) {
        String flag = "0";
        try {
            ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
            apisBusiTaskLog.setPushStep(Integer.valueOf(0));
            apisBusiTaskLog.setPushStatus("0");
            apisBusiTaskLog.setBusinessKey(policyNo);
            apisBusiTaskLog.setPushType(taskValue);
            apisBusiTaskLog.setPushContent(content);
            apisBusiTaskLog.setRelatedId(apisMsgMqlogs.getId());
            ApisChannelConfigs channelConfig = new ApisChannelConfigs();
            channelConfig.setConfigCode(taskValue + "_url");
            channelConfig = this.apisChannelConfigsService.getChannelConfig(channelConfig);
            if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue())) {
                apisBusiTaskLog.setPushTargetUrl(channelConfig.getConfigValue());
                apisBusiTaskLog.setCreator(channelConfig.getUserCode());
            }
            this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
            this.taskUtil.asyncNotice(apisBusiTaskLog);
        }
        catch (Exception e) {
            flag = "1";
            log.error("JDH\u9700\u6c42\u63a8\u9001\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a: ", (Throwable)e);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPolicyInfo(String policyNo, ApisMsgMqlogs apisMsgMqlogs) {
        try {
            Thread.sleep(600L);
            log.warn("JDH\u63a5\u6536MQ\u6d88\u606f\u5ef6\u65f60.6\u79d2\u518d\u5904\u7406.");
        }
        catch (Exception e) {
            log.error("\u5ef6\u65f6\u51fa\u9519\uff1a", (Throwable)e);
        }
        String flag = "0";
        try {
            PolicyDetailResponse policyDetailResponse = this.getPolicyDetail(policyNo);
            NotifyDTO body = NotifyDTO.builder().policyInfo(this.getPolicyInfo(policyDetailResponse)).holderInfo(this.getHolderInfo(policyDetailResponse)).insuredInfoList(this.getInsuredInfoList(policyDetailResponse)).productScheme(this.getProductSchemeList(policyDetailResponse)).companyToken(this.companyToken).build();
            this.pushJDHPolicyInfo(body);
        }
        catch (Exception e) {
            flag = "1";
            log.error("JDH\u9700\u6c42\u63a8\u9001\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a: ", (Throwable)e);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }

    private List<InsuredInfo> getInsuredInfoList(PolicyDetailResponse policyDetailResponse) {
        List insuredIdvDTOList = ((ItemMainDTO)policyDetailResponse.getResponseBody().getPolicy().getCoverage().getItemList().get(0)).getInsuredIdvList();
        ArrayList<InsuredInfo> list = new ArrayList<InsuredInfo>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (InsuredIdvDTO dto : insuredIdvDTOList) {
            InsuredInfo insuredInfo = InsuredInfo.builder().insuredType(dto.getInsuredType()).insuredName(dto.getInsuredName()).insuredEmail(dto.getEmail()).insuredCardType((String)idTypeMap.get(dto.getIdentifyType())).insuredCardNo(dto.getIdentifyNumber()).insuredSex(dto.getSex()).insuredBirthday(simpleDateFormat.format(dto.getBirthday())).insuredMobile(dto.getMobile()).insuredRelation((String)relationMap.get(dto.getRelationToAppnt())).build();
            list.add(insuredInfo);
        }
        return list;
    }

    private HolderInfo getHolderInfo(PolicyDetailResponse policyDetailResponse) {
        AppliClientDTO dto = (AppliClientDTO)policyDetailResponse.getResponseBody().getPolicy().getAppliClient().get(0);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HolderInfo holderInfo = HolderInfo.builder().holderType(dto.getInsuredType()).holderName(dto.getInsuredName()).holderEmail(dto.getEmail()).holderCardType((String)idTypeMap.get(dto.getIdentifyType())).holderCardNo(dto.getIdentifyNumber()).holderSex(dto.getSex()).holderBirthday(simpleDateFormat.format(dto.getBirthday())).holderMobile(dto.getMobile()).build();
        return holderInfo;
    }

    private List<ProductScheme> getProductSchemeList(PolicyDetailResponse policyDetailResponse) {
        PolicyDTO dto = policyDetailResponse.getResponseBody().getPolicy();
        MainDTO mainDTO = dto.getMain();
        ArrayList<ProductScheme> list = new ArrayList<ProductScheme>();
        ProductScheme productScheme = ProductScheme.builder().productSchemeInfo(this.getProductSchemeInfo(dto)).riskList(this.getRiskInfoList(dto)).build();
        list.add(productScheme);
        return list;
    }

    private List<RiskInfo> getRiskInfoList(PolicyDTO dto) {
        ItemMainDTO itemMainDTO = (ItemMainDTO)dto.getCoverage().getItemList().get(0);
        ArrayList<RiskInfo> list = new ArrayList<RiskInfo>();
        for (ItemKindDTO itemKindDTO : itemMainDTO.getItemKind()) {
            RiskInfo riskDto = RiskInfo.builder().riskCode(itemKindDTO.getKindCode()).riskName(itemKindDTO.getKindName()).riskType("1".equals(itemKindDTO.getKindInd()) ? "M" : "S").dutyPremium(new BigDecimal(itemKindDTO.getGrossPremium()).multiply(this.unit).setScale(0, RoundingMode.HALF_UP).toString()).dutyCoverage(itemKindDTO.getSumInsured().multiply(this.unit).setScale(0, RoundingMode.HALF_UP).toString()).build();
            list.add(riskDto);
        }
        return list;
    }

    private ProductSchemeInfo getProductSchemeInfo(PolicyDTO dto) {
        MainDTO mainDTO = dto.getMain();
        ItemMainDTO itemMainDTO = (ItemMainDTO)dto.getCoverage().getItemList().get(0);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ProductSchemeInfo productSchemeInfo = ProductSchemeInfo.builder().productCode(itemMainDTO.getPlanCode()).productName(itemMainDTO.getPlanName()).productType("M").copies(String.valueOf(itemMainDTO.getRationCount())).schemePremium(new BigDecimal(mainDTO.getSumPremium()).multiply(this.unit).setScale(0, RoundingMode.HALF_UP).toString()).insurancePeriodType("Y").insurancePeriod("1").cvliDate(simpleDateFormat.format(mainDTO.getStartDate())).endDate(simpleDateFormat.format(mainDTO.getEndDate())).paymentType("1".equals(mainDTO.getPaymentType()) ? "U" : "M").productPlanCode(itemMainDTO.getGoodsCode()).productPlanName(itemMainDTO.getGoodsName()).build();
        return productSchemeInfo;
    }

    private PolicyInfo getPolicyInfo(PolicyDetailResponse policyDetailResponse) throws ApisBusinessException {
        PolicyDTO dto = policyDetailResponse.getResponseBody().getPolicy();
        MainDTO mainDTO = dto.getMain();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        StanderRequest standerRequest = new StanderRequest();
        standerRequest.setHeader(StanderHeader.builder().channelCode(dto.getSalesList().getAgentCode()).build());
        standerRequest.setEPolicyDownServiceRequest(EPolicyDownServiceRequest.builder().requestBody(EPolicyDownRequestDTO.builder().businessNo(mainDTO.getPolicyNo()).certificateNo("").build()).build());
        log.warn("JDH\u8c03\u7528\u4fdd\u5355\u4e0b\u8f7d\u8fd4\u56deurl\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)standerRequest);
        WebResponse webResponse = this.ePolicyDownService.down(standerRequest, null, null);
        log.warn("JDH\u8c03\u7528\u4fdd\u5355\u4e0b\u8f7d\u8fd4\u56deurl\u63a5\u53e3\u54cd\u5e94\u62a5\u6587:{} ", (Object)webResponse);
        HashMap result = null;
        if (webResponse.getResult() instanceof HashMap) {
            result = (HashMap)webResponse.getResult();
        }
        if (result == null) {
            throw new ApisBusinessException("\u3010JDH\u3011\u4fdd\u5355\u53f7\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u8bb0\u5f55", ErrorNullValueCodeEnum.ERR_N14004.getKey());
        }
        PolicyInfo policyInfo = PolicyInfo.builder().policyNo(mainDTO.getPolicyNo()).contType(mainDTO.getPolicyType()).policyPrice(new BigDecimal(mainDTO.getSumPremium()).multiply(this.unit).setScale(0, RoundingMode.HALF_UP).toString()).policyStatus(String.valueOf(mainDTO.getPolicyStatus())).insuredNum(String.valueOf(((ItemMainDTO)dto.getCoverage().getItemList().get(0)).getInsuredCount())).policyBeginDate(simpleDateFormat.format(mainDTO.getStartDate())).policyEndDate(simpleDateFormat.format(mainDTO.getEndDate())).contPrintFlag("1").policyUrl((String)result.get("url")).insureDate(simpleDateFormat.format(mainDTO.getInputDate())).manageID(dto.getSalesList().getAgentCode()).manageName(dto.getSalesList().getAgentName()).build();
        return policyInfo;
    }

    private Integer getIntegerDefault(String value) {
        if (StringUtils.isEmpty((Object)value)) {
            return null;
        }
        return Integer.valueOf(value);
    }

    private PolicyDetailResponse getPolicyDetail(String policyNo) throws ApisBusinessException {
        PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().build();
        policyDetailServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        policyDetailServiceRequest.setRequestBody(PolicyDetailRequestDTO.builder().policyNo(policyNo).businessNature2("all").operateCode("all").build());
        StanderRequest request = StanderRequest.builder().policyDetailServiceRequest(policyDetailServiceRequest).build();
        StanderResponse standerResponse = this.standerPolicyDetailHandler.execute(request);
        BaseApisParamUtil.verificationResponse((StanderResponse)standerResponse, (String)"policyDetailResponse");
        return standerResponse.getPolicyDetailResponse();
    }

    public static void main(String[] args) {
        String serverUrl = "https://api-dev.jd.com/routerjson";
        String accessToken = "jdhbx_yfb";
        String appKey = "73D48E1D14D1746887C884F1C8EC847A";
        String appSecret = "59a50b025cdc4501a189fa8faa360392";
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        JdhInsuranceModifyPolicyRequest request = new JdhInsuranceModifyPolicyRequest();
        String ss = "{\"chanageTime\":\"2021-03-19 11:36:27\",\"companyToken\":\"7fdf37b1f4632935b6fab24b0c5592f3\",\"holderInfo\":{\"holderType\":\"1\",\"holderBirthday\":\"1998-11-01\",\"holderCardNo\":\"TJOA20205707055706\",\"holderCardType\":\"8\",\"holderEmail\":\"1234567899@qq.com\",\"holderMobile\":\"13800138019\",\"holderName\":\"\u8c22\u5a07\"},\"insuredInfoList\":[{\"insuredBirthday\":\"2008-08-08\",\"insuredCardNo\":\"202102030925100384\",\"insuredCardType\":\"8\",\"insuredType\":\"1\",\"insuredEmail\":\"\",\"insuredMobile\":\"\",\"insuredName\":\"\u5927\u8001\u9f20\",\"insuredRelation\":\"1\",\"insuredSex\":\"1\"}],\"policyNo\":\"P0000C02109000100000193\"}";
        PolicyModificationParam bodyParam = (PolicyModificationParam)JSON.parseObject((String)ss, PolicyModificationParam.class);
        request.setParam(bodyParam);
        try {
            JdhInsuranceModifyPolicyResponse jdhInsuranceModifyPolicyResponse = (JdhInsuranceModifyPolicyResponse)client.execute((JdRequest)request);
        }
        catch (Exception e) {
            log.error("JDH\u63a8\u9001\u5931\u8d25: ", (Throwable)e);
        }
    }
}

