/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.EmailCommonUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationInvoiceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationInvoiceEmailDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.litigation.LitigationInvoiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.litigation.LitigationInvoiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiEmailSendLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiEmailSendLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LitigationInvoiceUtil {
    private static final Logger log = LoggerFactory.getLogger(LitigationInvoiceUtil.class);
    private static final String SUBJECT_NAME = "\u6807\u9898\u6a21\u677f";
    private static final String CONTENT_NAME = "\u5185\u5bb9\u6a21\u677f";
    private static final String SPECIAL_EMAIL_TO_NAME = "\u4e13\u7968\u6536\u4ef6\u4eba";
    private static final String SPECIAL_EMAIL_CC_NAME = "\u4e13\u7968\u6284\u9001\u4eba";
    private static final String NORMAL_EMAIL_TO_NAME = "\u666e\u7968\u6536\u4ef6\u4eba";
    private static final String NORMAL_EMAIL_CC_NAME = "\u666e\u7968\u6284\u9001\u4eba";
    private static final String INVOICE_LINKER_NAME = "\u4eac\u4e1c\u5b89\u8054\u8054\u7cfb\u4eba\u59d3\u540d";
    private static final String INVOICE_LINKER_PHONE = "\u4eac\u4e1c\u5b89\u8054\u8054\u7cfb\u4eba\u7535\u8bdd";
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisBusiEmailSendLogService apisBusiEmailSendLogService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    CoreInsureApi coreInsureApi;

    @Transactional(rollbackFor={Exception.class})
    public void sendInvoiceEmail(LitigationInvoiceDTO invoiceDTO) {
        this.emailSend(invoiceDTO);
        ApisBusiTaskLog taskLog = new ApisBusiTaskLog();
        taskLog.setPushType(ApisAutoTaskConstantsEnum.LITIGATION_INVOICE_NOTIFY.getValue());
        taskLog.setBusinessKey(invoiceDTO.getPolicyNo());
        taskLog.setPushStatus("1");
        taskLog.setLastPushTime(LocalDateTime.now());
        taskLog.setPushContent(JSON.toJSONString((Object)invoiceDTO));
        this.apisBusiTaskLogService.saveTaskInfo(taskLog);
    }

    private void emailSend(LitigationInvoiceDTO invoiceDTO) throws RuntimeException {
        LitigationInvoiceEmailDTO emailDTO = this.convertEmailDto(invoiceDTO);
        String subjectTpl = this.convertEmailVal(emailDTO, "GY_INVOICE_SUBJECT", SUBJECT_NAME);
        String contentTpl = this.convertEmailVal(emailDTO, "GY_INVOICE_CONTENT", CONTENT_NAME);
        String emailTo = "";
        String emailCc = "";
        if ("1".equals(emailDTO.getInvoiceType())) {
            emailTo = this.convertEmailVal(emailDTO, "GY_INVOICE_SPECIAL_TO", SPECIAL_EMAIL_TO_NAME);
            emailCc = this.convertEmailVal(emailDTO, "GY_INVOICE_SPECIAL_CC", SPECIAL_EMAIL_CC_NAME);
        } else if ("2".equals(emailDTO.getInvoiceType())) {
            emailTo = this.convertEmailVal(emailDTO, "GY_INVOICE_NORMAL_TO", NORMAL_EMAIL_TO_NAME);
            emailCc = this.convertEmailVal(emailDTO, "GY_INVOICE_NORMAL_CC", NORMAL_EMAIL_CC_NAME);
        }
        if (StringUtils.isNotBlank((CharSequence)subjectTpl) && StringUtils.isNotBlank((CharSequence)contentTpl) && StringUtils.isNotBlank((CharSequence)emailTo)) {
            ApisBusiEmailSendLog sendLog = new ApisBusiEmailSendLog(subjectTpl, contentTpl, emailTo, emailCc);
            log.warn("\u9ad8\u9662\u8bc9\u8d23\u5f00\u7968\u53d1\u9001\u90ae\u4ef6\uff0c{}", (Object)JSON.toJSONString((Object)sendLog));
            this.apisBusiEmailSendLogService.save((Object)sendLog);
        }
    }

    private LitigationInvoiceEmailDTO convertEmailDto(LitigationInvoiceDTO invoiceDTO) {
        LitigationInvoiceEmailDTO emailDTO = (LitigationInvoiceEmailDTO)BeanUtil.copyProperties((Object)invoiceDTO, LitigationInvoiceEmailDTO.class, (String[])new String[0]);
        String invoiceTypeName = this.apisChannelCodeService.getValueDescByCode("GY_FPLX", invoiceDTO.getInvoiceType());
        String titleTypeName = this.apisChannelCodeService.getValueDescByCode("GY_TTLX", invoiceDTO.getTitleType());
        String identifyTypeName = "1".equals(emailDTO.getTitleType()) ? this.apisChannelCodeService.getValueDescByCode("GY_ZJLX", invoiceDTO.getIdentifyType()) : this.apisChannelCodeService.getValueDescByCode("GY_QYLX", invoiceDTO.getIdentifyType());
        emailDTO.setInvoiceTypeName(invoiceTypeName);
        emailDTO.setTitleTypeName(titleTypeName);
        emailDTO.setIdentifyTypeName(identifyTypeName);
        return emailDTO;
    }

    private String convertEmailVal(LitigationInvoiceEmailDTO emailDTO, String configCode, String fieldName) {
        String result = "";
        ApisChannelConfigs config = this.getConfig(configCode, fieldName);
        if (ObjectUtils.isNotEmpty((Object)config) && StringUtils.isNotBlank((CharSequence)config.getConfigValue())) {
            JSONObject invoiceMap = JSONObject.parseObject((String)JSON.toJSONString((Object)emailDTO));
            result = EmailCommonUtil.templateReplace((String)config.getConfigValue(), (Map)invoiceMap);
        }
        return result;
    }

    private ApisChannelConfigs getConfig(String configCode, String fieldName) {
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode(configCode);
        ApisChannelConfigs channelConfig = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        if (ObjectUtil.isEmpty((Object)channelConfig) || StringUtils.isBlank((CharSequence)channelConfig.getConfigValue())) {
            log.error("\u672a\u914d\u7f6e\u9ad8\u9662\u8bc9\u8d23\u9669\u5f00\u7968{}", (Object)fieldName);
        }
        return channelConfig;
    }

    public StanderResponse convertResponse(StanderRequest request) {
        LitigationInvoiceDTO invoiceDTO = request.getLitigationInvoiceRequest().getRequestBody();
        ApisChannelConfigs linkerNameConfig = this.getConfig("GY_INVOICE_LINKER_NAME", INVOICE_LINKER_NAME);
        ApisChannelConfigs linkerPhoneConfig = this.getConfig("GY_INVOICE_LINKER_PHONE", INVOICE_LINKER_PHONE);
        LitigationInvoiceResponseDTO invoiceResponseDTO = LitigationInvoiceResponseDTO.builder().policyNo(invoiceDTO.getPolicyNo()).invoiceLinkerName(linkerNameConfig.getConfigValue()).invoiceLinkerPhone(linkerPhoneConfig.getConfigValue()).build();
        LitigationInvoiceResponse response = LitigationInvoiceResponse.builder().responseBody(invoiceResponseDTO).build();
        return StanderResponse.builder().litigationInvoiceResponse(response).build();
    }

    public PolicyDTO getPolicyDetail(StanderRequest request, String policyNo) {
        PolicyDetailRequestDTO policyDetailRequestDTO = PolicyDetailRequestDTO.builder().policyNo(policyNo).operateCode("all").businessNature2("all").build();
        PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(policyDetailRequestDTO).build();
        request.setPolicyDetailServiceRequest(policyDetailServiceRequest);
        StanderResponse response = this.coreInsureApi.policyDetail(request);
        if (response != null && response.getPolicyDetailResponse() != null && response.getPolicyDetailResponse().getResponseBody() != null) {
            return response.getPolicyDetailResponse().getResponseBody().getPolicy();
        }
        return null;
    }
}

