/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.CoreGuaranteeService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.LitigationCoreGuaranteeService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.EPolicyDownServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.EPolicyDownRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.EPolicyDownServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.BaseResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.PayResultAndGuaranteeDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.CommentNotifyResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiPayLog;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelUserMapper;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import java.io.Serializable;
import java.text.ParseException;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LitigationPushPayGuaranteeUtil {
    private static final Logger log = LoggerFactory.getLogger(LitigationPushPayGuaranteeUtil.class);
    @Autowired
    private EPolicyDownServiceImpl ePolicyDownService;
    @Autowired
    CoreGuaranteeService coreGuaranteeService;
    @Autowired
    LitigationCoreGuaranteeService litigationCoreGuaranteeService;
    @Autowired
    private ApisChannelUserMapper apisChannelUserMapper;

    public BaseResponse litigationPushPayGuaranteeAsync(PayResultAndGuaranteeDTO payResultAndGuaranteeDTO, CommentNotifyResponseDTO request, ApisBusiPayLog apisBusiPayLog, ApisBusiChannelOrder order, String pushPayResultAndGuaranteeUrl, String API_LITIGATION_PUSH_RESULT, boolean flag) throws ApisBusinessException {
        log.warn("\u9ad8\u9662\u4fdd\u5355\u4fdd\u51fd\u63a8\u9001\u53c2\u6570\u62fc\u63a5\u5f00\u59cb");
        this.setPayResultAndGuaranteeDTO(payResultAndGuaranteeDTO, request, apisBusiPayLog, order);
        if (flag) {
            log.warn("\u8c03\u7528\u9ad8\u9662\u4fdd\u5355\u4fdd\u51fd\u63a8\u9001\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)payResultAndGuaranteeDTO);
            return (BaseResponse)this.coreGuaranteeService.litigationConvertAndSend(pushPayResultAndGuaranteeUrl, API_LITIGATION_PUSH_RESULT, API_LITIGATION_PUSH_RESULT, (Object)payResultAndGuaranteeDTO, BaseResponse.class);
        }
        log.warn("\u8c03\u7528\u901a\u7528\u8bc9\u8d23\u9669\u4fdd\u5355\u4fdd\u51fd\u63a8\u9001\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)payResultAndGuaranteeDTO);
        String userCode = order.getCreator();
        String pwd = this.apisChannelUserMapper.queryPwdByCode(userCode);
        return (BaseResponse)this.litigationCoreGuaranteeService.litigationConvertAndSend(pushPayResultAndGuaranteeUrl, API_LITIGATION_PUSH_RESULT, userCode, pwd, (Object)payResultAndGuaranteeDTO, BaseResponse.class);
    }

    private void setPayResultAndGuaranteeDTO(PayResultAndGuaranteeDTO payResultAndGuaranteeDTO, CommentNotifyResponseDTO request, ApisBusiPayLog payLog, ApisBusiChannelOrder order) throws ApisBusinessException {
        payResultAndGuaranteeDTO.setCDbid(order.getOrderNo());
        payResultAndGuaranteeDTO.setBdh(order.getPolicyNo());
        payResultAndGuaranteeDTO.setDdh(order.getProposalNo());
        payResultAndGuaranteeDTO.setNSfjf("1");
        payResultAndGuaranteeDTO.setNZffs("4");
        payResultAndGuaranteeDTO.setNJfje(Double.valueOf(payLog.getTotalPremium().doubleValue()));
        try {
            payResultAndGuaranteeDTO.setDtJfsj(DateUtils.parseDate((String)request.getPayTime(), (String[])new String[]{"yyyy-MM-dd hh:mm:ss", "yyyy-MM-dd"}));
        }
        catch (ParseException e) {
            log.error("\u63a8\u9001\u4fdd\u5355\u4fdd\u51fd-\u652f\u4ed8\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef:", (Throwable)e);
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N14006.getValue(), ErrorNullValueCodeEnum.ERR_N14006.getKey());
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        payResultAndGuaranteeDTO.setQbrq(order.getStartDate().format(df));
        payResultAndGuaranteeDTO.setZbrq(order.getEndDate().format(df));
        StanderRequest standerRequest = new StanderRequest();
        standerRequest.setHeader(StanderHeader.builder().channelCode(request.getAgencyCode()).build());
        standerRequest.setEPolicyDownServiceRequest(EPolicyDownServiceRequest.builder().requestBody(EPolicyDownRequestDTO.builder().businessNo(order.getPolicyNo()).certificateNo("").build()).build());
        log.warn("\u9ad8\u9662\u8c03\u7528\u4fdd\u5355\u4e0b\u8f7d\u8fd4\u56deurl\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)request);
        WebResponse webResponse = this.ePolicyDownService.down(standerRequest, null, null);
        log.warn("\u9ad8\u9662\u8c03\u7528\u4fdd\u5355\u4e0b\u8f7d\u8fd4\u56deurl\u63a5\u53e3\u54cd\u5e94\u62a5\u6587: {}", (Object)webResponse);
        Serializable obj = webResponse.getResult();
        HashMap result = null;
        if (obj instanceof HashMap) {
            result = (HashMap)obj;
        }
        if (result == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N14004.getValue(), ErrorNullValueCodeEnum.ERR_N14004.getKey());
        }
        payResultAndGuaranteeDTO.setCbd((String)result.get("url"));
        String cbh = this.ePolicyDownService.getElectronicGuaranteeUrl(order.getProposalNo());
        log.warn("\u62ff\u56de\u7684\u4fdd\u51fdurl\uff1a{}", (Object)cbh);
        if (StringUtils.isEmpty((CharSequence)cbh)) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N14005.getValue(), "IgnoreError" + ErrorNullValueCodeEnum.ERR_N14005.getKey());
        }
        payResultAndGuaranteeDTO.setCbh(cbh);
    }
}

