/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderPolicyDetailHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.IdNumberUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RespondentDTO;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationClauseKindFactoryMapper;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.GeneralRegxs;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sinosoftgz.utils.data.DateUtils;

@Component
public class LitigationQuotePriceValidate {
    private static Logger log = LoggerFactory.getLogger(LitigationQuotePriceValidate.class);
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    StanderPolicyDetailHandler standerPolicyDetailHandler;
    @Autowired
    ApisPfpRationClauseKindFactoryMapper apisPfpRationClauseKindFactoryMapper;
    @Autowired
    IdNumberUtil idNumberUtil;

    public void validateRquest(StanderRequest standerRequest) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        String planCode = ((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        ApisPfpRationMain apisPfpRationMain = this.dataCompletionUtil.getApisPfpRationMainInfo(planCode, "2");
        this.valiNull(standerRequest, apisPfpRationMain);
        this.validFormat(standerRequest, apisPfpRationMain);
    }

    private List<AppliClientDTO> handleAppliClientAge(List<AppliClientDTO> appliClientDTOList) throws ApisBusinessException {
        List<AppliClientDTO> newList = appliClientDTOList.stream().filter(appli -> "1".equals(appli.getInsuredType()) && Integer.parseInt(appli.getAge()) >= 18 || "2".equals(appli.getInsuredType())).collect(Collectors.toList());
        if (newList.size() == 0) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10670.getValue(), ChannelErrorCodeEnum.ERR_C10670.getKey());
        }
        return newList;
    }

    private void validFormat(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        String birthDateStr;
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredList = quotePriceDTO.getInsuredList();
        List insuredIdvDTOList = quotePriceDTO.getCoverage().getInsuredIdvList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        if (quotePriceDTO.getRiskInfo().getStageOfAction().equals("1") || quotePriceDTO.getRiskInfo().getStageOfAction().equals("2")) {
            // empty if block
        }
        for (AppliClientDTO appList : appliClientList) {
            if (appList.getInsuredType().equals("1")) {
                if (!appList.getMobile().matches(GeneralRegxs.Mobile)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10465.getValue(), ChannelErrorCodeEnum.ERR_C10465.getKey());
                }
                if ("01".equals(appList.getIdentifyType()) && StringUtils.isNotEmpty((CharSequence)appList.getIdentifyNumber())) {
                    if (StringUtils.isNotEmpty((CharSequence)appList.getIdentifyNumber()) && !IdcardUtil.isValidCard((String)appList.getIdentifyNumber())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10266.getValue().replaceFirst("##", appList.getInsuredName()).replace("##", appList.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10266.getKey());
                    }
                    String birthDateStr2 = appList.getIdentifyNumber().substring(6, 14);
                    if (ObjectUtil.isNotEmpty((Object)appList.getBirthday()) && !birthDateStr2.equals(DateUtils.dateToStr((Date)appList.getBirthday(), (String)"yyyyMMdd"))) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", appList.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10119.getKey());
                    }
                    try {
                        appList.setBirthday(DateUtils.parseToDate((String)birthDateStr2, (String)"yyyyMMdd"));
                    }
                    catch (ParseException e) {
                        log.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff0c" + e);
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10005.getValue(), ChannelErrorCodeEnum.ERR_C10005.getKey());
                    }
                    if (StringUtils.isEmpty((CharSequence)appList.getSex())) {
                        appList.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)appList.getIdentifyNumber()) == 1 ? 1 : 2));
                    }
                    if (StringUtils.isEmpty((CharSequence)appList.getAge())) {
                        appList.setAge(String.valueOf(this.dataCompletionUtil.calculateAge(mainDTO.getStartDate(), appList.getBirthday())));
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)appList.getEmail()) || appList.getEmail().matches(GeneralRegxs.Email)) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10132.getValue(), ChannelErrorCodeEnum.ERR_C10132.getKey());
            }
            if (appList.getInsuredType().equals("2") || appList.getInsuredType().equals("3")) {
                if (this.idNumberUtil.validateIdNumberByIdType(appList.getIdentifyType(), appList.getIdentifyNumber())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10692.getValue().replaceFirst("##", appList.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10692.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10013.getValue().replace("##", "\u4eba\u5458\u7c7b\u578b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        List newAppliClientList = this.handleAppliClientAge(appliClientList);
        quotePriceDTO.setAppliClient(newAppliClientList);
        for (InsuredDTO insure : insuredList) {
            if (insure.getInsuredType().equals("1")) {
                if (!insure.getMobile().matches(GeneralRegxs.Mobile)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10465.getValue(), ChannelErrorCodeEnum.ERR_C10465.getKey());
                }
                if ("01".equals(insure.getIdentifyType()) && StringUtils.isNotEmpty((CharSequence)insure.getIdentifyNumber())) {
                    if (StringUtils.isNotEmpty((CharSequence)insure.getIdentifyNumber()) && !IdcardUtil.isValidCard((String)insure.getIdentifyNumber())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10266.getValue().replaceFirst("##", insure.getInsuredName()).replace("##", insure.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10266.getKey());
                    }
                    birthDateStr = insure.getIdentifyNumber().substring(6, 14);
                    if (ObjectUtil.isNotEmpty((Object)insure.getBirthday()) && !birthDateStr.equals(DateUtils.dateToStr((Date)insure.getBirthday(), (String)"yyyyMMdd"))) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", insure.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10119.getKey());
                    }
                    if (StringUtils.isEmpty((CharSequence)insure.getSex())) {
                        insure.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)insure.getIdentifyNumber()) == 1 ? 1 : 2));
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)insure.getEmail()) || insure.getEmail().matches(GeneralRegxs.Email)) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10132.getValue(), ChannelErrorCodeEnum.ERR_C10132.getKey());
            }
            if (insure.getInsuredType().equals("2") || insure.getInsuredType().equals("3")) {
                if (this.idNumberUtil.validateIdNumberByIdType(insure.getIdentifyType(), insure.getIdentifyNumber())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10692.getValue().replaceFirst("##", insure.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10692.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10013.getValue().replace("##", "\u4eba\u5458\u7c7b\u578b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        for (RespondentDTO respondentDTO : quotePriceDTO.getCoverage().getRespondents()) {
            if (respondentDTO.getInsuredType().equals("1")) {
                if (ObjectUtil.isNotEmpty((Object)respondentDTO.getMobile()) && !respondentDTO.getMobile().matches(GeneralRegxs.Mobile)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10465.getValue(), ChannelErrorCodeEnum.ERR_C10465.getKey());
                }
                if ("01".equals(respondentDTO.getIdentifyType()) && StringUtils.isNotEmpty((CharSequence)respondentDTO.getIdentifyNumber())) {
                    if (!IdcardUtil.isValidCard((String)respondentDTO.getIdentifyNumber())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10266.getValue().replaceFirst("##", respondentDTO.getInsuredName()).replace("##", respondentDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10266.getKey());
                    }
                    birthDateStr = respondentDTO.getIdentifyNumber().substring(6, 14);
                    if (ObjectUtil.isNotEmpty((Object)respondentDTO.getBirthday()) && !birthDateStr.equals(DateUtils.dateToStr((Date)respondentDTO.getBirthday(), (String)"yyyyMMdd"))) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", respondentDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10119.getKey());
                    }
                    if (StringUtils.isEmpty((CharSequence)respondentDTO.getSex())) {
                        respondentDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)respondentDTO.getIdentifyNumber()) == 1 ? 1 : 2));
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)respondentDTO.getEmail()) || respondentDTO.getEmail().matches(GeneralRegxs.Email)) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10132.getValue(), ChannelErrorCodeEnum.ERR_C10132.getKey());
            }
            if (respondentDTO.getInsuredType().equals("2") || respondentDTO.getInsuredType().equals("3")) {
                if (this.idNumberUtil.validateIdNumberByIdType(respondentDTO.getIdentifyType(), respondentDTO.getIdentifyNumber())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10693.getValue().replaceFirst("##", respondentDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10693.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10013.getValue().replace("##", "\u4eba\u5458\u7c7b\u578b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    private void valiNull(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredList = quotePriceDTO.getInsuredList();
        List insuredIdvDTOList = quotePriceDTO.getCoverage().getInsuredIdvList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        if (StringUtils.isBlank((CharSequence)mainDTO.getOrderNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u62c5\u4fdd\u7533\u8bf7Id"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)quotePriceDTO.getRiskInfo().getAcceptanceCourtCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u6cd5\u9662\u4ee3\u7801"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)quotePriceDTO.getRiskInfo().getStageOfAction())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u4fdd\u5168\u7c7b\u578b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).getSumInsured())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u4fdd\u5168\u91d1\u989d"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (mainDTO.getInputDate() == null || mainDTO.getInputDate().equals("")) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u62c5\u4fdd\u7533\u8bf7\u63d0\u4ea4\u65f6\u95f4"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (!quotePriceDTO.getRiskInfo().getStageOfAction().equals("2") && quotePriceDTO.getRiskInfo().getStageOfAction().equals("1")) {
            if (StringUtils.isBlank((CharSequence)quotePriceDTO.getRiskInfo().getCaseNo())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u6848\u53f7"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isBlank((CharSequence)quotePriceDTO.getRiskInfo().getActionTypeDesc())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u6848\u7531"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        }
        for (AppliClientDTO appList : appliClientList) {
            if (appList.getInsuredId() == null || appList.getInsuredId().equals("")) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u4eba\u5458\u4e3b\u952eId"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isBlank((CharSequence)appList.getInsuredType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u4eba\u5458\u7c7b\u578b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (appList.getInsuredType().equals("1")) {
                if (StringUtils.isBlank((CharSequence)appList.getInsuredName())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u4eba\u59d3\u540d"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StringUtils.isBlank((CharSequence)appList.getSex())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u4eba\u6027\u522b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StringUtils.isBlank((CharSequence)appList.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u4eba\u8bc1\u4ef6\u53f7"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StringUtils.isBlank((CharSequence)appList.getIdentifyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u4eba\u8bc1\u4ef6\u7c7b\u578b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (appList.getBirthday() == null || appList.getBirthday().equals("")) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u4eba\u51fa\u751f\u65e5\u671f"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StringUtils.isBlank((CharSequence)appList.getInsuredAddress())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u4eba\u7ecf\u5e38\u5c45\u4f4f\u5730"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StringUtils.isBlank((CharSequence)appList.getAge())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u4eba\u5e74\u9f84"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (!StringUtils.isBlank((CharSequence)appList.getMobile())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u4eba\u7535\u8bdd"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (appList.getInsuredType().equals("2") || appList.getInsuredType().equals("3")) {
                if (StringUtils.isBlank((CharSequence)appList.getContactPhone())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u4f01\u4e1a\u7535\u8bdd"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StringUtils.isBlank((CharSequence)appList.getInsuredAddress())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u5355\u4f4d\u5730\u5740"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StringUtils.isBlank((CharSequence)appList.getInsuredName())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u4f01\u4e1a\u540d\u79f0"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StrUtil.isEmpty((CharSequence)appList.getIdentifyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u4f01\u4e1a\u8bc1\u4ef6\u7c7b\u578b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (!StrUtil.isEmpty((CharSequence)appList.getIdentifyNumber())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u7533\u8bf7\u4f01\u4e1a\u8bc1\u4ef6\u53f7\u7801"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10013.getValue().replace("##", "\u4eba\u5458\u7c7b\u578b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        for (RespondentDTO respondentDTO : quotePriceDTO.getCoverage().getRespondents()) {
            if (StringUtils.isBlank((CharSequence)respondentDTO.getInsuredId())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u88ab\u7533\u8bf7\u4eba\u4eba\u5458\u4e3b\u952eId"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isBlank((CharSequence)respondentDTO.getInsuredType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u88ab\u7533\u8bf7\u4eba\u4eba\u5458\u7c7b\u578b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isBlank((CharSequence)respondentDTO.getInsuredType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u88ab\u7533\u8bf7\u4eba\u4eba\u5458\u7c7b\u578b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (respondentDTO.getInsuredType().equals("1")) {
                if (StringUtils.isBlank((CharSequence)respondentDTO.getInsuredName())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u88ab\u7533\u8bf7\u4eba\u59d3\u540d"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (!StringUtils.isBlank((CharSequence)respondentDTO.getSex())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u88ab\u7533\u8bf7\u4eba\u6027\u522b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (respondentDTO.getInsuredType().equals("2") || respondentDTO.getInsuredType().equals("3")) {
                if (StringUtils.isBlank((CharSequence)respondentDTO.getInsuredAddress())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u88ab\u7533\u8bf7\u4f01\u4e1a\u5355\u4f4d\u5730\u5740"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StringUtils.isBlank((CharSequence)respondentDTO.getInsuredName())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u88ab\u7533\u8bf7\u4f01\u4e1a\u540d\u79f0"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StringUtils.isBlank((CharSequence)respondentDTO.getIdentifyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u88ab\u7533\u8bf7\u4f01\u4e1a\u8bc1\u4ef6\u7c7b\u578b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (!StringUtils.isBlank((CharSequence)respondentDTO.getIdentifyNumber())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u88ab\u7533\u8bf7\u4f01\u4e1a\u8bc1\u4ef6\u53f7\u7801"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10013.getValue().replace("##", "\u4eba\u5458\u7c7b\u578b"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }
}

