/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderPolicyDetailHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.CoreGuaranteeApi;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.LitigationCoreGuaranteeApi;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.EPolicyDownServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.PaymentServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.CfDrugsUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.EmailCommonUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RespondentDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskInfoActionDutyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.EPolicyDownRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.EPolicyDownServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageNodeDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageQueryDownRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageQueryDownRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageQueryDownResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageQueryDownResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageRequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageSystemBaseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageSystemMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.BaseResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.BbxrDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.BdxxDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.CPayUrlDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.CcxsDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.DsrDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationChangeGuaOfflineDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationFileDto;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationOffLinePolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationOfflineSurrenderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationOnlineGerneralRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationOnlineSurrenderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationOnlineSurrenderUWRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationPaymentUrlDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationPaymentUrlRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationPolicyDto;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUpdateClerkRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUwGeneralRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUwRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUwResultMsgDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.SqclDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.UploadFileDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiCorrectOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiGuaranteeOffLineOrderLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiGuaranteeUnderwriteResultLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiCorrectOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiGuaranteeOffLineOrderLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiGuaranteeUnderwriteResultLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.commons.utils.ImageUtils;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ApisCommonConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.utils.LitigationSignUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class LitigationUtils {
    private static Logger log = LoggerFactory.getLogger(LitigationUtils.class);
    @Value(value="${apis.coreapi.serv.imgQueryDown.url}")
    private String coreApiImgQueryDownUrl;
    @Value(value="${ePolicy.down.url}")
    private String ePolicyDownUrl;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisBusiGuaranteeOffLineOrderLogService apisBusiGuaranteeOffLineOrderLogService;
    @Autowired
    ApisBusiGuaranteeUnderwriteResultLogService apisBusiGuaranteeUnderwriteResultLogService;
    @Autowired
    StanderPolicyDetailHandler standerPolicyDetailHandler;
    @Autowired
    CoreGuaranteeApi coreGuaranteeApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    EPolicyDownServiceImpl ePolicyDownService;
    @Autowired
    PaymentServiceImpl paymentService;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    LitigationCoreGuaranteeApi litigationCoreGuaranteeApi;
    @Autowired
    private EmailCommonUtil emailCommonUtil;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    private ApisBusiCorrectOrderService apisBusiCorrectOrderService;
    @Autowired
    private ImageUtils imageUtils;
    @Value(value="${apis.coreapi.serv.imgQueryDown.newUrl}")
    private String coreApiImgQueryDownNewUrl;
    @Autowired
    private CfDrugsUtil cfDrugsUtil;
    private static List<String> defaultPlanCode = Arrays.asList("ZR-SSBQ-FY-2C");
    private static String OPEN_APPLET_FLAG = "OPEN_APPLET_FLAG";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushPolicyToHighCourt(ApisBusiGuaranteeOffLineOrderLog offLineOrder) {
        String errMsg = "";
        String pushStatus = "0";
        try {
            PolicyDetailResponse policyDetailResponse = this.getPolicyDetail(offLineOrder.getPolicyNo());
            LitigationOffLinePolicyDTO litigationOffLinePolicyDTO = this.settlePolicyInfo(policyDetailResponse);
            BaseResponse baseResponse = this.coreGuaranteeApi.pushPolicyToHighCourt(litigationOffLinePolicyDTO);
            if (ObjectUtil.isNotEmpty((Object)baseResponse)) {
                if ("200".equals(baseResponse.getCode())) {
                    pushStatus = "1";
                    this.emailCommonUtil.saveLitigationBdbhEmailSendLog(offLineOrder.getPolicyNo());
                } else {
                    pushStatus = "4";
                    errMsg = baseResponse.getMsg();
                }
            }
        }
        catch (Exception e) {
            pushStatus = "4";
            errMsg = e.getMessage();
            log.error("\u7ebf\u4e0b\u6295\u4fdd\u63a8\u9001\u9ad8\u9662\u51fa\u9519: ", (Throwable)e);
        }
        finally {
            this.updateOffLineOrder(offLineOrder, pushStatus, errMsg);
        }
    }

    private void updateOffLineOrder(ApisBusiGuaranteeOffLineOrderLog offLineOrder, String pushStatus, String errMsg) {
        offLineOrder.setErrMsg(errMsg);
        offLineOrder.setPushStep(Integer.valueOf(offLineOrder.getPushStep() + 1));
        offLineOrder.setPushStatus(pushStatus);
        offLineOrder.setLastPushTime(LocalDateTime.now());
        this.apisBusiGuaranteeOffLineOrderLogService.updateById((Object)offLineOrder);
        ApisBusiTaskLog paramLog = new ApisBusiTaskLog();
        BeanUtil.copyProperties((Object)offLineOrder, (Object)paramLog, (String[])new String[0]);
        paramLog.setBusinessKey(offLineOrder.getPolicyNo());
        paramLog.setPushType(ApisAutoTaskConstantsEnum.OFFLINE_POLICY_TO_GY.getValue());
        this.handlerTaskLog(paramLog, BusinessConstants.LITIGATION_CONSTANTS.OFF_LINE_POLICY_MAX_PUSH_TIME);
    }

    private LitigationOffLinePolicyDTO settlePolicyInfo(PolicyDetailResponse policyDetailResponse) throws Exception {
        Map zjlxMap = this.dataCompletionUtil.getCodeMap("GY_ZJLX");
        Map qylxMap = this.dataCompletionUtil.getCodeMap("GY_QYLX");
        LitigationOffLinePolicyDTO litigationOffLinePolicyDTO = new LitigationOffLinePolicyDTO();
        MainDTO mainDTO = policyDetailResponse.getResponseBody().getPolicy().getMain();
        litigationOffLinePolicyDTO.setPolicy(this.packagedPolicy(policyDetailResponse));
        litigationOffLinePolicyDTO.setBbxrList(this.packagedAppliClient(policyDetailResponse, zjlxMap, qylxMap));
        litigationOffLinePolicyDTO.setBsqrList(this.packagedRespondents(policyDetailResponse, zjlxMap, qylxMap));
        litigationOffLinePolicyDTO.setUploadFiles(this.getUploadFiles(mainDTO));
        return litigationOffLinePolicyDTO;
    }

    public LitigationPolicyDto packagedPolicy(PolicyDetailResponse policyDetailResponse) throws ApisBusinessException {
        Map preservationTypeMap = this.dataCompletionUtil.getCodeMap("preservationType2");
        Map caseTypeMap = this.dataCompletionUtil.getCodeMap("caseType");
        Map noLitigationPeriodMap = this.dataCompletionUtil.getCodeMap("noLitigationPeriod");
        MainDTO mainDTO = policyDetailResponse.getResponseBody().getPolicy().getMain();
        RiskInfoDTO riskInfoDTO = policyDetailResponse.getResponseBody().getPolicy().getRiskInfo();
        LitigationPolicyDto policy = new LitigationPolicyDto();
        policy.setBdh(mainDTO.getPolicyNo());
        policy.setTjsj(mainDTO.getInputDate());
        String otherCode = "9999";
        if (StringUtils.isNotEmpty((CharSequence)riskInfoDTO.getAcceptanceCourtCode()) && !otherCode.equals(riskInfoDTO.getAcceptanceCourtCode())) {
            policy.setFybm(riskInfoDTO.getAcceptanceCourtCode());
        } else if (StringUtils.isNotEmpty((CharSequence)riskInfoDTO.getAcceptanceCourt())) {
            policy.setFybm(this.dataCompletionUtil.reversalCode("HighCourtCode", riskInfoDTO.getAcceptanceCourt()));
        }
        if (StringUtils.isEmpty((CharSequence)policy.getFybm())) {
            log.warn("\u7ebf\u4e0b\u6295\u4fdd\u4fe1\u606f\u7ec4\u88c5\u5f02\u5e38\uff1a\u53d7\u7406\u6cd5\u9662\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10017.getValue() + ":\u53d7\u7406\u6cd5\u9662\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10017.getKey());
        }
        policy.setSqdbje(riskInfoDTO.getActionAmount());
        policy.setAh(riskInfoDTO.getCaseNo());
        policy.setAy(this.getActionTypeDesc(riskInfoDTO));
        policy.setBqlb("1".equals(riskInfoDTO.getStageOfAction()) ? "2" : "1");
        String preservationType2 = ObjectUtil.isEmpty(preservationTypeMap.get(riskInfoDTO.getPreservationType2())) ? "1" : (String)preservationTypeMap.get(riskInfoDTO.getPreservationType2());
        policy.setBqlx(preservationType2);
        String caseType = ObjectUtil.isEmpty(caseTypeMap.get(riskInfoDTO.getCasesType())) ? "" : (String)preservationTypeMap.get(riskInfoDTO.getCasesType());
        policy.setAjlx(caseType);
        String noLitigationPeriod = ObjectUtil.isEmpty(noLitigationPeriodMap.get(riskInfoDTO.getNoLitigationPeriod())) ? "255" : (String)preservationTypeMap.get(riskInfoDTO.getNoLitigationPeriod());
        policy.setFsqj(noLitigationPeriod);
        policy.setBxgs("JD");
        policy.setDbid(mainDTO.getOrderNo());
        policy.setDbfy(mainDTO.getSumPremium());
        return policy;
    }

    public String getActionTypeDesc(RiskInfoDTO riskInfoDTO) {
        String ay = "";
        String otherActionType = "9";
        if (otherActionType.equals(riskInfoDTO.getActionType())) {
            ay = riskInfoDTO.getActionTypeDesc();
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"deleted", (Object)ApisChannelCode.DELETE_FLAG_FALSE);
            queryWrapper.eq((Object)"channel_value", (Object)riskInfoDTO.getActionType());
            queryWrapper.eq((Object)"valid_flag", (Object)CommonConstant.ValidStatus.VALID_YES);
            queryWrapper.eq((Object)"code", (Object)"ActionType");
            ApisChannelCode code = (ApisChannelCode)this.apisChannelCodeService.getOne((Wrapper)queryWrapper);
            if (ObjectUtil.isNotEmpty((Object)code)) {
                ay = code.getValue();
            }
        }
        return ay;
    }

    public List<BbxrDTO> packagedAppliClient(PolicyDetailResponse policyDetailResponse, Map<String, String> qylxMap, Map<String, String> zjlxMap) {
        MainDTO mainDTO = policyDetailResponse.getResponseBody().getPolicy().getMain();
        List appliClientDTOList = policyDetailResponse.getResponseBody().getPolicy().getAppliClient();
        ArrayList<BbxrDTO> bbxrDTOList = new ArrayList<BbxrDTO>();
        for (AppliClientDTO appliClientDTO : appliClientDTOList) {
            String zjlx;
            BbxrDTO bbxrDTO = new BbxrDTO();
            bbxrDTO.setCreatetime(mainDTO.getInputDate());
            bbxrDTO.setPersonType(appliClientDTO.getInsuredType());
            if ("1".equals(bbxrDTO.getPersonType())) {
                bbxrDTO.setXm(appliClientDTO.getInsuredName());
                bbxrDTO.setZjh(appliClientDTO.getIdentifyNumber());
                zjlx = ObjectUtil.isNotEmpty((Object)zjlxMap.get(appliClientDTO.getIdentifyType())) ? zjlxMap.get(appliClientDTO.getIdentifyType()) : "255";
                bbxrDTO.setZjlx(zjlx);
            } else {
                bbxrDTO.setQymc(appliClientDTO.getInsuredName());
                bbxrDTO.setQyzzjgdm(appliClientDTO.getIdentifyNumber());
                zjlx = ObjectUtil.isNotEmpty((Object)qylxMap.get(appliClientDTO.getIdentifyType())) ? qylxMap.get(appliClientDTO.getIdentifyType()) : "255";
                bbxrDTO.setQyzzjgdmlx(zjlx);
            }
            bbxrDTO.setSf("1");
            bbxrDTO.setZjhmsha256(LitigationSignUtil.encodeSha256((String)appliClientDTO.getIdentifyNumber()));
            bbxrDTOList.add(bbxrDTO);
        }
        return bbxrDTOList;
    }

    public List<BbxrDTO> packagedRespondents(PolicyDetailResponse policyDetailResponse, Map<String, String> qylxMap, Map<String, String> zjlxMap) {
        MainDTO mainDTO = policyDetailResponse.getResponseBody().getPolicy().getMain();
        List respondentDTOList = policyDetailResponse.getResponseBody().getPolicy().getCoverage().getRespondents();
        ArrayList<BbxrDTO> bsqrList = new ArrayList<BbxrDTO>();
        for (RespondentDTO respondentDTO : respondentDTOList) {
            String zjlx;
            BbxrDTO bbxrDTO = new BbxrDTO();
            bbxrDTO.setCreatetime(mainDTO.getInputDate());
            bbxrDTO.setPersonType(respondentDTO.getInsuredType());
            if ("1".equals(bbxrDTO.getPersonType())) {
                bbxrDTO.setXm(respondentDTO.getInsuredName());
                bbxrDTO.setZjh(respondentDTO.getIdentifyNumber());
                zjlx = ObjectUtil.isNotEmpty((Object)zjlxMap.get(respondentDTO.getIdentifyType())) ? zjlxMap.get(respondentDTO.getIdentifyType()) : "255";
                bbxrDTO.setZjlx(zjlx);
            } else {
                bbxrDTO.setQymc(respondentDTO.getInsuredName());
                bbxrDTO.setQyzzjgdm(respondentDTO.getIdentifyNumber());
                zjlx = ObjectUtil.isNotEmpty((Object)qylxMap.get(respondentDTO.getIdentifyType())) ? qylxMap.get(respondentDTO.getIdentifyType()) : "255";
                bbxrDTO.setQyzzjgdmlx(zjlx);
            }
            bbxrDTO.setSf("3");
            bbxrDTO.setZjhmsha256(LitigationSignUtil.encodeSha256((String)respondentDTO.getIdentifyNumber()));
            bsqrList.add(bbxrDTO);
        }
        return bsqrList;
    }

    private List<UploadFileDTO> getUploadFiles(MainDTO mainDTO) throws Exception {
        ArrayList<UploadFileDTO> uploadFiles = new ArrayList<UploadFileDTO>();
        String url1 = this.ePolicyDownUrl + "?bussNo=" + mainDTO.getProposalNo();
        log.warn("\u7ebf\u4e0b\u6295\u4fdd\u83b7\u53d6\u4fdd\u5355\u6587\u4ef6:{}", (Object)url1);
        UploadFileDTO uploadFileDTO = this.packagedPolicyFile(mainDTO, "BD", url1);
        if (ObjectUtil.isNotEmpty((Object)uploadFileDTO)) {
            uploadFiles.add(uploadFileDTO);
        }
        String url2 = this.ePolicyDownService.getPolicyDownUrl(mainDTO.getProposalNo());
        log.warn("\u7ebf\u4e0b\u6295\u4fdd\u83b7\u53d6\u4fdd\u6db5\u6587\u4ef6:{}", (Object)url2);
        UploadFileDTO uploadFileDTO2 = this.packagedPolicyFile(mainDTO, "BH", url2);
        if (ObjectUtil.isNotEmpty((Object)uploadFileDTO2)) {
            uploadFiles.add(uploadFileDTO2);
        }
        return uploadFiles;
    }

    public UploadFileDTO packagedPolicyFile(MainDTO mainDTO, String lx, String downUrl) throws Exception {
        UploadFileDTO policyFile = new UploadFileDTO();
        LitigationFileDto file = new LitigationFileDto();
        file.setBdh(mainDTO.getPolicyNo());
        file.setLx(lx);
        policyFile.setFile(file);
        policyFile.setFileData(this.getByteData(downUrl));
        return policyFile;
    }

    public byte[] getByteData(String downUrl) throws Exception {
        OkHttpClient okHttpClient = OkHttpUtils.getInstance();
        Request request = new Request.Builder().url(downUrl).get().build();
        Response okResponse = okHttpClient.newCall(request).execute();
        byte[] bytes = okResponse.body().bytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        String type = FileTypeUtil.getType((InputStream)inputStream);
        log.warn("\u7ebf\u4e0b\u6295\u4fdd-\u4e0b\u8f7d\u6587\u4ef6\u7c7b\u578b:{}", (Object)type);
        Integer minBytes = 500;
        if (bytes.length < minBytes) {
            throw new Exception();
        }
        return bytes;
    }

    public ImageQueryDownRequest packagedImageQueryDownRequest(MainDTO mainDTO) {
        ImageQueryDownRequest request = new ImageQueryDownRequest();
        ImageRequestHeadDTO headDto = new ImageRequestHeadDTO();
        headDto.setSeqNo(UUID.randomUUID().toString());
        headDto.setRequestTime(new Date());
        headDto.setConsumerID("0000000000");
        headDto.setConsumerPwd("fccb");
        ImageQueryDownRequestDTO requestDto = new ImageQueryDownRequestDTO();
        ImageSystemBaseDTO baseData = new ImageSystemBaseDTO();
        baseData.setComCode(mainDTO.getComCode());
        baseData.setNetType("http.inner");
        baseData.setOperator(mainDTO.getOperateCode());
        baseData.setOperatorName(mainDTO.getOperateName());
        baseData.setOperatorRole("UWA_T01");
        ImageSystemMetaDTO metaData = new ImageSystemMetaDTO();
        metaData.setAppCode("UW");
        metaData.setClassCode("UWA");
        metaData.setBusinessNo(mainDTO.getPolicyNo());
        ArrayList<String> nodeCodes = new ArrayList<String>();
        nodeCodes.add("|UWA_A|UWA_A06|");
        metaData.setNodeCodes(nodeCodes);
        requestDto.setBaseData(baseData);
        requestDto.setMetaData(metaData);
        request.setRequestHead(headDto);
        request.setRequestBody(requestDto);
        return request;
    }

    public String getFileDownUrl(ImageQueryDownRequest request) throws IOException {
        String returnUrl = "";
        OkHttpClient okHttpClient = new OkHttpClient();
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)JSON.toJSONString((Object)request));
        Request okRequest = new Request.Builder().url(this.ePolicyDownUrl).post(requestBody).build();
        Response okResponse = okHttpClient.newCall(okRequest).execute();
        String responseStr = okResponse.body().string();
        ImageQueryDownResponse imageQueryDownResponse = (ImageQueryDownResponse)JSON.parseObject((String)responseStr, ImageQueryDownResponse.class);
        ImageQueryDownResponseDTO imageQueryDownResponseDTO = imageQueryDownResponse.getResponseBody();
        returnUrl = imageQueryDownResponseDTO != null && imageQueryDownResponseDTO.getImageNodes() != null && imageQueryDownResponseDTO.getImageNodes().get(0) != null ? ((ImageNodeDTO)imageQueryDownResponseDTO.getImageNodes().get(0)).getImgUrl() : "";
        return returnUrl;
    }

    private PolicyDetailResponse getPolicyDetail(String policyNo) throws ApisBusinessException {
        PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().build();
        policyDetailServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        policyDetailServiceRequest.setRequestBody(PolicyDetailRequestDTO.builder().policyNo(policyNo).businessNature2("all").operateCode("all").build());
        StanderRequest request = StanderRequest.builder().policyDetailServiceRequest(policyDetailServiceRequest).build();
        StanderResponse standerResponse = this.standerPolicyDetailHandler.execute(request);
        BaseApisParamUtil.verificationResponse((StanderResponse)standerResponse, (String)"policyDetailResponse");
        return standerResponse.getPolicyDetailResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushUwResultAndPayUrl(ApisBusiGuaranteeUnderwriteResultLog result) {
        String errMsg = "";
        try {
            BaseResponse baseResponse;
            LitigationUwRequest requestDTO = this.beforeRequestProcess(result);
            ApisBusiChannelOrder order = this.getOrder(result.getProposalNo());
            if ("1".equals(requestDTO.getNShjg())) {
                if (defaultPlanCode.contains(order.getPlanCode())) {
                    if (this.appletFlag()) {
                        log.warn("\u63a8\u9001\u7ebf\u4e0b\u6295\u4fdd\u5230\u9ad8\u9662>>\u6295\u4fdd\u5355\u53f7\uff1a{}", (Object)result.getProposalNo());
                        requestDTO.setCPayUrls(null);
                        baseResponse = this.coreGuaranteeApi.pushUwResult(requestDTO);
                    } else {
                        log.warn("\u63a8\u9001\u7ebf\u4e0b\u6295\u4fdd\u5230\u9ad8\u9662>>\u6295\u4fdd\u5355\u53f7\uff1a{}", (Object)result.getProposalNo());
                        baseResponse = this.coreGuaranteeApi.pushUwResultAndPayUrl(requestDTO);
                    }
                } else {
                    log.warn("\u63a8\u9001\u7ebf\u4e0b\u6295\u4fdd\u5230\u9ad8\u9662>>\u6295\u4fdd\u5355\u53f7\uff1a{}", (Object)result.getProposalNo());
                    baseResponse = this.litigationCoreGuaranteeApi.pushUwResultAndPayUrl(requestDTO, order);
                }
            } else if (defaultPlanCode.contains(order.getPlanCode())) {
                log.warn("\u63a8\u9001\u7ebf\u4e0b\u6295\u4fdd\u5230\u9ad8\u9662>>\u6295\u4fdd\u5355\u53f7\uff1a{}", (Object)result.getProposalNo());
                baseResponse = this.coreGuaranteeApi.pushUwResult(requestDTO);
            } else {
                log.warn("\u63a8\u9001\u7ebf\u4e0b\u6295\u4fdd\u5230\u9ad8\u9662>>\u6295\u4fdd\u5355\u53f7\uff1a{}", (Object)result.getProposalNo());
                baseResponse = this.litigationCoreGuaranteeApi.pushUwResult(requestDTO, order);
            }
            if (ObjectUtil.isNotEmpty((Object)baseResponse) || "200".equals(baseResponse.getCode())) {
                result.setPushStatus("1");
            } else {
                result.setPushStatus("4");
                errMsg = baseResponse.getMsg();
            }
        }
        catch (Exception e) {
            result.setPushStatus("4");
            errMsg = e.getMessage();
            log.error("\u9ad8\u9662\u63a8\u9001\u6838\u4fdd\u7ed3\u679c\u548c\u7f34\u8d39\u94fe\u63a5\u51fa\u9519: ", (Throwable)e);
        }
        finally {
            this.updateUwResult(result, errMsg);
        }
    }

    private ApisBusiChannelOrder getOrder(String proposalNo) throws ApisBusinessException {
        ApisBusiChannelOrder order = null;
        if (ObjectUtil.isNotEmpty((Object)proposalNo)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"proposal_no", (Object)proposalNo);
            order = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
        } else {
            log.error("\u8bc9\u8d23\u9669\u5ba1\u6838\u6d88\u606f\u63a8\u9001\u5931\u8d25-\u300b\u6295\u4fdd\u5355\u53f7\u4e3a\u7a7a\u3002");
        }
        return order;
    }

    private void updateUwResult(ApisBusiGuaranteeUnderwriteResultLog result, String errMsg) {
        result.setErrMsg(errMsg);
        result.setPushStep(Integer.valueOf(result.getPushStep() + 1));
        result.setLastPushTime(LocalDateTime.now());
        this.apisBusiGuaranteeUnderwriteResultLogService.updateById((Object)result);
        ApisBusiTaskLog paramLog = new ApisBusiTaskLog();
        BeanUtil.copyProperties((Object)result, (Object)paramLog, (String[])new String[0]);
        paramLog.setBusinessKey(result.getProposalNo());
        paramLog.setPushType(ApisAutoTaskConstantsEnum.UWRESULT_PAYURL_TO_GY.getValue());
        this.handlerTaskLog(paramLog, BusinessConstants.LITIGATION_CONSTANTS.UW_PAYURL_BD_BH_MAX_PUSH_TIME);
    }

    public void handlerTaskLog(ApisBusiTaskLog paramLog, Integer maxPushTime) {
        log.warn("paramLog:{}", (Object)paramLog.toString());
        try {
            boolean insertFlag = false;
            if ("1".equals(paramLog.getPushStatus())) {
                insertFlag = true;
            }
            if (!"1".equals(paramLog.getPushStatus()) && maxPushTime == paramLog.getPushStep()) {
                insertFlag = true;
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"business_key", (Object)paramLog.getBusinessKey());
            queryWrapper.eq((Object)"push_type", (Object)paramLog.getPushType());
            ApisBusiTaskLog taskLog = (ApisBusiTaskLog)this.apisBusiTaskLogService.getOne((Wrapper)queryWrapper);
            if (insertFlag) {
                if (ObjectUtil.isNotEmpty((Object)taskLog)) {
                    taskLog.setPushStatus(paramLog.getPushStatus());
                    taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
                    taskLog.setErrMsg(paramLog.getErrMsg());
                    taskLog.setLastPushTime(LocalDateTime.now());
                    this.apisBusiTaskLogService.updateById((Object)taskLog);
                } else {
                    ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
                    BeanUtil.copyProperties((Object)paramLog, (Object)apisBusiTaskLog, (String[])new String[0]);
                    apisBusiTaskLog.setPushStep(Integer.valueOf(1));
                    apisBusiTaskLog.setLastPushTime(LocalDateTime.now());
                    this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
                }
            } else if (ObjectUtil.isNotEmpty((Object)taskLog)) {
                taskLog.setPushStatus(paramLog.getPushStatus());
                taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
                taskLog.setErrMsg(paramLog.getErrMsg());
                taskLog.setLastPushTime(LocalDateTime.now());
                log.warn("paramLog update2:{}", (Object)taskLog.toString());
                this.apisBusiTaskLogService.updateById((Object)taskLog);
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u4efb\u52a1\u65e5\u5fd7\u8868\u51fa\u9519\uff1a", (Throwable)e);
        }
    }

    private LitigationUwRequest beforeRequestProcess(ApisBusiGuaranteeUnderwriteResultLog result) {
        LitigationUwRequest requestDTO = LitigationUwRequest.builder().build();
        requestDTO.setCDbid(result.getOrderNo());
        requestDTO.setNShjg(result.getUnderwriteFlag());
        requestDTO.setCShyj(result.getUnderwriteMsg());
        requestDTO.setDtShsj(Date.from(result.getUnderwriteTime().atZone(ZoneId.systemDefault()).toInstant()));
        if ("1".equals(result.getUnderwriteFlag())) {
            LitigationPaymentUrlDTO litigationPaymentUrlDTO = LitigationPaymentUrlDTO.builder().orderNo(result.getOrderNo()).cPoint("2").build();
            StanderRequest standerRequest = StanderRequest.builder().header(StanderHeader.builder().build()).build();
            LitigationPaymentUrlRequest litigationPaymentUrlRequest = LitigationPaymentUrlRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(litigationPaymentUrlDTO).build();
            standerRequest.setLitigationPaymentUrlRequest(litigationPaymentUrlRequest);
            WebResponse webResponse = this.paymentService.wrapPaymentUrl(standerRequest);
            HashMap resultMap = (HashMap)webResponse.getResult();
            CPayUrlDTO cPayUrlDTO = CPayUrlDTO.builder().cPoint(resultMap.get("cPoint") instanceof String ? (String)resultMap.get("cPoint") : null).expiry(resultMap.get("expire") instanceof Date ? (Date)resultMap.get("expire") : null).cPayUrl(resultMap.get("payUrl") instanceof String ? (String)resultMap.get("payUrl") : null).build();
            ArrayList<CPayUrlDTO> payUrlList = new ArrayList<CPayUrlDTO>();
            payUrlList.add(cPayUrlDTO);
            requestDTO.setCPayUrls(payUrlList);
        }
        return requestDTO;
    }

    public boolean appletFlag() {
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setConfigCode(OPEN_APPLET_FLAG);
        apisChannelConfigsCondition.setConfigValue("1");
        apisChannelConfigsCondition.setDeleted(Integer.valueOf(0));
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        return ObjectUtil.isNotEmpty((Object)apisChannelConfigs);
    }

    @Async(value="scheduleTaskNotifyExecutor")
    public void updateClerk(String dbid) throws ApisBusinessException {
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setConfigCode("GY_CLERK_INFO");
        apisChannelConfigsCondition.setDeleted(Integer.valueOf(0));
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        LitigationUpdateClerkRequest request = LitigationUpdateClerkRequest.builder().dbid(dbid).clerkName(apisChannelConfigs.getValueType()).clerkPhone(apisChannelConfigs.getConfigValue()).build();
        BaseResponse response = this.coreGuaranteeApi.litigationUpdateClerk(request);
        if (ObjectUtil.isNotEmpty((Object)response) && !"200".equals(response.getCode())) {
            log.error("\u66f4\u65b0\u4e1a\u52a1\u5458\u4fe1\u606f,dbid:{}\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)dbid, (Object)response.getMsg());
        } else if (ObjectUtil.isEmpty((Object)response)) {
            log.error("\u66f4\u65b0\u4e1a\u52a1\u5458\u4fe1\u606f\u63a5\u53e3\u65e0\u8fd4\u56de,dbid:{}", (Object)dbid);
        }
    }

    public void pushUwResultGy(String dbid, String underwriteFlag, String msg, Date uwDate) {
        try {
            Thread.sleep(10000L);
            log.warn("\u9ad8\u9662\u5ba1\u6838\u63a8\u9001\u5ef6\u8fdf10S\u63a8\u9001");
            LitigationUwGeneralRequest requestDTO = LitigationUwGeneralRequest.builder().build();
            requestDTO.setDbid(dbid);
            requestDTO.setShjg(underwriteFlag);
            requestDTO.setBtgyy(msg);
            requestDTO.setShsj(uwDate);
            BaseResponse baseResponse = this.coreGuaranteeApi.pushOnlineUwGeneralCorrect(requestDTO);
            if (ObjectUtil.isNotEmpty((Object)baseResponse)) {
                if ("200".equals(baseResponse.getCode())) {
                    log.warn("\u9ad8\u9662\u63a8\u9001\u5ba1\u6838\u610f\u89c1\u6210\u529f");
                } else {
                    log.error("\u9ad8\u9662\u63a8\u9001\u5ba1\u6838\u610f\u89c1\u5931\u8d25");
                }
            } else {
                log.error("\u9ad8\u9662\u63a8\u9001\u5ba1\u6838\u610f\u89c1\u5931\u8d25, \u8fd4\u56de\u4e3a\u7a7a");
            }
        }
        catch (ApisBusinessException e) {
            log.error("\u9ad8\u9662\u5ba1\u6838\u63a8\u9001\u5931\u8d25\uff0c{}", (Throwable)e);
        }
        catch (Exception e) {
            log.error("\u9ad8\u9662\u5ba1\u6838\u63a8\u9001\u5931\u8d25\uff0c{}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushPolicySurrender(LitigationUwResultMsgDTO msg, String message) {
        log.warn("\u9ad8\u9662\u9000\u4fdd\u8f6c\u6362\u5b9e\u4f8b,{}", (Object)JSON.toJSONString((Object)msg));
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        apisMsgMqlogs.setCreateTime((Date)DateUtil.date());
        apisMsgMqlogs.setMessage(message);
        apisMsgMqlogs.setTopic("apisTopic");
        apisMsgMqlogs.setConsumerGroup("fccbApisUndwResult");
        apisMsgMqlogs.setErrorFlag("0");
        this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
        String flag = "0";
        try {
            ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
            apisBusiTaskLog.setPushStep(Integer.valueOf(0));
            apisBusiTaskLog.setPushStatus("0");
            apisBusiTaskLog.setBusinessKey(msg.getApplyNo());
            apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.LITIGATION_NOTIFY_CALLBACK.getValue());
            apisBusiTaskLog.setPushContent(JSON.toJSONString((Object)msg));
            apisBusiTaskLog.setRelatedId(apisMsgMqlogs.getId());
            ApisChannelConfigs channelConfig = new ApisChannelConfigs();
            channelConfig.setConfigCode(ApisAutoTaskConstantsEnum.LITIGATION_NOTIFY_CALLBACK.getValue() + "_url");
            channelConfig = this.apisChannelConfigsService.getChannelConfig(channelConfig);
            if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue())) {
                apisBusiTaskLog.setPushTargetUrl(channelConfig.getConfigValue());
                apisBusiTaskLog.setCreator(channelConfig.getUserCode());
            }
            this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
        }
        catch (Exception e) {
            flag = "1";
            log.warn("\u9ad8\u9662\u9000\u4fdd\u9700\u6c42\u63a8\u9001\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:{}", (Object)e.getMessage());
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }

    public void pushContentToLitigation(ApisBusiTaskLog busiTaskLog) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            if (isUpdSuccess) {
                Boolean flag = this.pushPolicySurrenderToLitigation(busiTaskLog.getPushContent());
                busiTaskLog.setPushStatus(flag != false ? "1" : "4");
            }
        }
        catch (Exception e) {
            busiTaskLog.setPushStatus("4");
            busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            log.error("\u5f02\u6b65\u56de\u8c03\u901a\u77e5 error:", (Throwable)e);
        }
        if (isUpdSuccess) {
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    private Boolean pushPolicySurrenderToLitigation(String content) {
        Boolean flag = true;
        LitigationUwResultMsgDTO dto = null;
        dto = (LitigationUwResultMsgDTO)JSON.parseObject((String)content, LitigationUwResultMsgDTO.class);
        log.warn("\u9ad8\u9662\u9000\u4fdd\u63a8\u9001\uff0c\u672c\u6b21\u63a8\u9001\u8f6c\u6362\u5b9e\u4f8b\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        ApisBusiCorrectOrder apisBusiCorrectOrder = new ApisBusiCorrectOrder();
        apisBusiCorrectOrder.setApplyNo(dto.getApplyNo());
        apisBusiCorrectOrder.setStatus("1");
        List correctList = this.apisBusiCorrectOrderService.getApisBusiCorrectOrderList(apisBusiCorrectOrder);
        ApisBusiChannelOrder order = this.apisBusiChannelOrderService.findOneByPolicyNo(dto.getPolicyNo());
        if (ObjectUtil.isEmpty((Object)order)) {
            log.error("\u9ad8\u9662\u9000\u4fdd\u63a8\u9001\u5931\u8d25\uff0c\u4fdd\u5355\u4e0d\u5b58\u5728\uff0c\u4fdd\u5355\u53f7\u4e3a\uff1a{}", (Object)dto.getPolicyNo());
            return false;
        }
        try {
            if (ObjectUtil.isNotEmpty((Object)correctList)) {
                log.warn("\u9ad8\u9662\u9000\u4fdd\uff0c\u672c\u6b21\u63a8\u9001\u4e3a\u7ebf\u4e0a\u5355\uff0c\u6279\u5355\u7533\u8bf7\u53f7\u4e3a:{}", (Object)dto.getApplyNo());
                LitigationOnlineSurrenderUWRequest litigationOnlineSurrenderUwRequest = LitigationOnlineSurrenderUWRequest.builder().tbbh(((ApisBusiCorrectOrder)correctList.get(0)).getBusinessKey()).dbid(order.getOrderNo()).bdh(dto.getPolicyNo()).shjg(Integer.valueOf(dto.getUnderwriteFlag())).btgyy(dto.getUnderwritemsg()).shrq(simpleDateFormat1.format(dto.getUnderWriteEndDate())).yjtbje(Long.valueOf(dto.getActualRefPremium().multiply(new BigDecimal(BusinessConstants.LITIGATION_CONSTANTS.MUTIPLY_UNIT)).longValue())).sfqetb(Integer.valueOf("1")).build();
                BaseResponse baseResponse = this.coreGuaranteeApi.pushUwOnlineSurrender(litigationOnlineSurrenderUwRequest);
                if (!"200".equals(baseResponse.getCode())) {
                    log.error("\u8bc9\u8d23\u9669\u9000\u4fdd\u4fdd\u6d88\u606f\u63a8\u9001>>\u8bf7\u6c42\u62c5\u4fdd\u7cfb\u7edf\u5f02\u5e38:{}", (Object)baseResponse.getMsg());
                    return false;
                }
                LitigationOnlineSurrenderRequest litigationOnlineSurrenderRequest = LitigationOnlineSurrenderRequest.builder().tbbh(((ApisBusiCorrectOrder)correctList.get(0)).getBusinessKey()).dbid(order.getOrderNo()).bdh(dto.getPolicyNo()).tbje(Long.valueOf(dto.getActualRefPremium().multiply(new BigDecimal(BusinessConstants.LITIGATION_CONSTANTS.MUTIPLY_UNIT)).longValue())).tbclsj(simpleDateFormat1.format(dto.getUnderWriteEndDate())).yjdzsj("\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u60a8\u7684\u9000\u4fdd\u7533\u8bf7\u5df2\u63d0\u4ea4\uff0c\u5ba1\u6838\u65e0\u8bef\u540e\u6211\u53f8\u5c06\u57283-7\u4e2a\u5de5\u4f5c\u65e5\u5185\u5b8c\u6210\u9000\u8d39\uff0c\u8bf7\u7559\u610f\u67e5\u6536").build();
                baseResponse = this.coreGuaranteeApi.pushOnlineSurrender(litigationOnlineSurrenderRequest);
                if (!"200".equals(baseResponse.getCode())) {
                    log.error("\u8bc9\u8d23\u9669\u9000\u4fdd\u6d88\u606f\u63a8\u9001>>\u8bf7\u6c42\u62c5\u4fdd\u7cfb\u7edf\u5f02\u5e38:{}", (Object)baseResponse.getMsg());
                    return false;
                }
            } else {
                log.warn("\u9ad8\u9662\u9000\u4fdd\uff0c\u672c\u6b21\u63a8\u9001\u4e3a\u7ebf\u4e0b\u6279\u6539\u5355\uff0c\u6279\u5355\u7533\u8bf7\u53f7\u4e3a:{}", (Object)dto.getApplyNo());
                LitigationOfflineSurrenderRequest litigationOfflineSurrenderRequest = LitigationOfflineSurrenderRequest.builder().bdh(dto.getPolicyNo()).shjg(Integer.valueOf(dto.getUnderwriteFlag())).shr("\u4eac\u4e1c\u5b89\u8054\u8bc9\u8d23\u4e1a\u52a1\u4e13\u7ebf").shrlxfs("0527-88120935").shrq(simpleDateFormat1.format(dto.getUnderWriteEndDate())).tbje(Long.valueOf(dto.getActualRefPremium().multiply(new BigDecimal(BusinessConstants.LITIGATION_CONSTANTS.MUTIPLY_UNIT)).longValue())).sfqetb(Integer.valueOf("1")).tbclsj(simpleDateFormat1.format(dto.getUnderWriteEndDate())).yjdzsj("\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u60a8\u7684\u9000\u4fdd\u7533\u8bf7\u5df2\u63d0\u4ea4\uff0c\u5ba1\u6838\u65e0\u8bef\u540e\u6211\u53f8\u5c06\u57283-7\u4e2a\u5de5\u4f5c\u65e5\u5185\u5b8c\u6210\u9000\u8d39\uff0c\u8bf7\u7559\u610f\u67e5\u6536").build();
                BaseResponse baseResponse = this.coreGuaranteeApi.pushOfflineSurrender(litigationOfflineSurrenderRequest);
                if (!"200".equals(baseResponse.getCode())) {
                    log.error("\u8bc9\u8d23\u9669\u9000\u4fdd\u4fdd\u6d88\u606f\u63a8\u9001>>\u8bf7\u6c42\u62c5\u4fdd\u7cfb\u7edf\u5f02\u5e38:{}", (Object)baseResponse.getMsg());
                    return false;
                }
            }
        }
        catch (Exception e) {
            flag = false;
            log.warn("\u9ad8\u9662\u9000\u4fdd\u9700\u6c42\u63a8\u9001\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:{}", (Object)e.getMessage());
        }
        return flag;
    }

    public void saveGeneralCorrectTask(LitigationUwResultMsgDTO msg) {
        log.warn("\u9ad8\u9662\u9000\u4fdd\u8f6c\u6362\u5b9e\u4f8b,{}", (Object)JSON.toJSONString((Object)msg));
        String flag = "0";
        try {
            ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
            apisBusiTaskLog.setPushStep(Integer.valueOf(0));
            apisBusiTaskLog.setPushStatus("0");
            apisBusiTaskLog.setBusinessKey(msg.getApplyNo());
            apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.ON_LINE_GENERAL_CORRECT_TO_GY.getValue());
            apisBusiTaskLog.setPushContent(JSON.toJSONString((Object)msg));
            ApisChannelConfigs channelConfig = new ApisChannelConfigs();
            channelConfig.setConfigCode(ApisAutoTaskConstantsEnum.ON_LINE_GENERAL_CORRECT_TO_GY.getValue() + "_url");
            channelConfig = this.apisChannelConfigsService.getChannelConfig(channelConfig);
            if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue())) {
                apisBusiTaskLog.setPushTargetUrl(channelConfig.getConfigValue());
                apisBusiTaskLog.setCreator(channelConfig.getUserCode());
            }
            this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
        }
        catch (Exception e) {
            flag = "1";
            log.warn("\u9ad8\u9662\u63a8\u9001\u6279\u6539\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:{}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushGeneralCorrect(LitigationUwResultMsgDTO msg, ApisBusiTaskLog taskLog) {
        if (ObjectUtil.isNotEmpty((Object)taskLog)) {
            taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
        } else {
            taskLog = new ApisBusiTaskLog();
            taskLog.setBusinessKey(msg.getApplyNo());
            taskLog.setPushStatus("0");
            taskLog.setPushStep(Integer.valueOf(1));
            taskLog.setPushType(ApisAutoTaskConstantsEnum.OFF_LINE_GENERAL_CORRECT_TO_GY.getKey());
        }
        taskLog.setLastPushTime(LocalDateTime.now());
        try {
            PolicyDetailResponse policyDetailResponse = this.getPolicyDetail(msg.getPolicyNo());
            if (ObjectUtil.isEmpty((Object)policyDetailResponse) || CommonConstant.FccbResponseCode.FAIL.equals(policyDetailResponse.getResponseHead().getStatus()) || ObjectUtil.isEmpty((Object)policyDetailResponse.getResponseBody())) {
                return;
            }
            if (!"DE200001_01".equals(policyDetailResponse.getResponseBody().getPolicy().getMain().getOperateCode())) {
                return;
            }
            LitigationChangeGuaOfflineDTO offlineDto = this.settleChangeGuaOfflineInfo(policyDetailResponse);
            taskLog.setPushContent(JSON.toJSONString((Object)offlineDto));
            BaseResponse baseResponse = this.coreGuaranteeApi.pushOfflineGeneralCorrect(offlineDto);
            if (ObjectUtil.isNotEmpty((Object)baseResponse)) {
                if ("200".equals(baseResponse.getCode())) {
                    taskLog.setPushStatus("1");
                } else {
                    taskLog.setPushStatus("4");
                }
                taskLog.setErrMsg(JSON.toJSONString((Object)baseResponse));
            }
        }
        catch (Exception e) {
            log.error("\u7ebf\u4e0b\u6279\u6539\u540c\u6b65\u7ed9\u9ad8\u9662\u51fa\u9519,\u4e1a\u52a1\u53f7\uff1a{},{}", (Object)msg.getApplyNo(), (Object)e);
            taskLog.setPushStatus("4");
            taskLog.setErrMsg(e.getLocalizedMessage());
        }
        finally {
            this.apisBusiTaskLogService.saveOrUpdate((Object)taskLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generalUwResultNotify(LitigationUwResultMsgDTO msg, ApisBusiTaskLog taskLog) {
        ApisBusiChannelOrder order = null;
        try {
            order = this.getUwResultOrder(msg);
            if (ObjectUtil.isEmpty((Object)order)) {
                log.error("\u9ad8\u9662\u6279\u6539\u6838\u4fdd\u901a\u77e5\u3002\u627e\u4e0d\u5230\u8be5\u8ba2\u5355\uff0c\u6295\u4fdd\u5355\u53f7\u4e3a{}\uff0c\u4fdd\u5355\u53f7\u4e3a{}", (Object)msg.getProposalNo(), (Object)msg.getPolicyNo());
                return;
            }
            if (ObjectUtil.isEmpty((Object)msg.getApplyNo())) {
                log.error("\u9ad8\u9662\u6279\u6539\u6838\u4fdd\u901a\u77e5\u3002\u6279\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4fdd\u5355\u53f7\u4e3a{}", (Object)order.getPolicyNo());
                return;
            }
            if (ObjectUtil.isNotEmpty((Object)taskLog.getBusinessKey())) {
                taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
            } else {
                taskLog.setBusinessKey(msg.getApplyNo());
                taskLog.setPushContent(JSON.toJSONString((Object)msg));
                taskLog.setPushStatus("0");
                taskLog.setPushStep(Integer.valueOf(1));
                taskLog.setPushType(ApisAutoTaskConstantsEnum.ON_LINE_UW_GENERAL_CORRECT_TO_GY.getValue());
            }
            taskLog.setLastPushTime(LocalDateTime.now());
            LitigationUwGeneralRequest requestDTO = this.beforeUwRequestProcess(msg, order);
            BaseResponse baseResponse = this.coreGuaranteeApi.pushOnlineUwGeneralCorrect(requestDTO);
            if (ObjectUtil.isNotEmpty((Object)baseResponse)) {
                if ("200".equals(baseResponse.getCode())) {
                    taskLog.setPushStatus("1");
                } else {
                    taskLog.setPushStatus("4");
                }
                taskLog.setErrMsg(JSON.toJSONString((Object)baseResponse));
            }
        }
        catch (Exception e) {
            log.error("\u9ad8\u9662\u7ebf\u4e0a\u6279\u6539\u6838\u4fdd\u5f02\u5e38\uff0c{}", (Throwable)e);
            taskLog.setPushStatus("4");
            taskLog.setErrMsg(e.getLocalizedMessage());
        }
        finally {
            this.apisBusiTaskLogService.saveOrUpdate((Object)taskLog);
        }
    }

    public void pushOnlineGeneralTask(ApisBusiTaskLog busiTaskLog) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            if (isUpdSuccess) {
                Boolean flag = this.pushOnlineGeneralResultNotify((LitigationUwResultMsgDTO)JSON.parseObject((String)busiTaskLog.getPushContent(), LitigationUwResultMsgDTO.class));
                busiTaskLog.setPushStatus(flag != false ? "1" : "4");
            }
        }
        catch (Exception e) {
            busiTaskLog.setPushStatus("4");
            busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            log.error("\u5f02\u6b65\u56de\u8c03\u901a\u77e5 error:", (Throwable)e);
        }
        if (isUpdSuccess) {
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    private Boolean pushOnlineGeneralResultNotify(LitigationUwResultMsgDTO dto) {
        Boolean flag = true;
        log.warn("\u9ad8\u9662\u7ebf\u4e0a\u6279\u6539\u63a8\u9001\uff0c\u672c\u6b21\u63a8\u9001\u8f6c\u6362\u5b9e\u4f8b\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ApisBusiChannelOrder order = this.apisBusiChannelOrderService.findOneByPolicyNo(dto.getPolicyNo());
        if (ObjectUtil.isEmpty((Object)order)) {
            log.error("\u9ad8\u9662\u7ebf\u4e0a\u6279\u6539\u63a8\u9001\uff0c\u4fdd\u5355\u4e0d\u5b58\u5728\uff0c\u4fdd\u5355\u53f7\u4e3a\uff1a{}", (Object)dto.getPolicyNo());
            return false;
        }
        try {
            log.warn("\u9ad8\u9662\u7ebf\u4e0a\u6279\u6539\u63a8\u9001\uff0c\u4fdd\u5355\u53f7\u4e3a:{}", (Object)dto.getPolicyNo());
            LitigationOnlineGerneralRequest litigationOnlineGerneralRequest = LitigationOnlineGerneralRequest.builder().bdh(dto.getPolicyNo()).dbid(order.getOrderNo()).hdsj(simpleDateFormat1.format(new Date())).bdUrl(this.getBdurl(order)).bhUrl(this.getBhUrl(order)).build();
            BaseResponse baseResponse = this.coreGuaranteeApi.pushOnlineGeneralCorrect(litigationOnlineGerneralRequest);
            if (!"200".equals(baseResponse.getCode())) {
                log.error("\u8bc9\u8d23\u9669\u9000\u4fdd\u4fdd\u6d88\u606f\u63a8\u9001>>\u8bf7\u6c42\u62c5\u4fdd\u7cfb\u7edf\u5f02\u5e38:{}", (Object)baseResponse.getMsg());
                return false;
            }
        }
        catch (ApisBusinessException e) {
            flag = false;
            log.error("\u9ad8\u9662\u7ebf\u4e0a\u6279\u6539\u63a8\u9001\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a{}", (Object)e.getMessage());
        }
        catch (Exception e) {
            flag = false;
            log.warn("\u9ad8\u9662\u7ebf\u4e0a\u6279\u6539\u63a8\u9001\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:{}", (Object)e.getMessage());
        }
        return flag;
    }

    private String getBdurl(ApisBusiChannelOrder order) throws ApisBusinessException {
        StanderRequest standerRequest = new StanderRequest();
        standerRequest.setHeader(StanderHeader.builder().channelCode(order.getAgentCode()).build());
        standerRequest.setEPolicyDownServiceRequest(EPolicyDownServiceRequest.builder().requestBody(EPolicyDownRequestDTO.builder().businessNo(order.getPolicyNo()).certificateNo("").build()).build());
        WebResponse webResponse = this.ePolicyDownService.down(standerRequest, null, null);
        log.warn("\u9ad8\u9662\u8c03\u7528\u4fdd\u5355\u4e0b\u8f7d\u8fd4\u56deurl\u63a5\u53e3\u54cd\u5e94\u62a5\u6587: {}", (Object)webResponse);
        Serializable obj = webResponse.getResult();
        HashMap result = null;
        if (obj instanceof HashMap) {
            result = (HashMap)obj;
        }
        if (result == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N14004.getValue(), ErrorNullValueCodeEnum.ERR_N14004.getKey());
        }
        return (String)result.get("url");
    }

    private String getBhUrl(ApisBusiChannelOrder order) throws ApisBusinessException {
        String cbh = this.ePolicyDownService.getElectronicGuaranteeUrl(order.getProposalNo());
        log.warn("\u62ff\u56de\u7684\u4fdd\u51fdurl\uff1a{}", (Object)cbh);
        if (StringUtils.isEmpty((CharSequence)cbh)) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N14005.getValue(), "IgnoreError" + ErrorNullValueCodeEnum.ERR_N14005.getKey());
        }
        return cbh;
    }

    private LitigationUwGeneralRequest beforeUwRequestProcess(LitigationUwResultMsgDTO msg, ApisBusiChannelOrder order) {
        LitigationUwGeneralRequest requestDTO = LitigationUwGeneralRequest.builder().build();
        requestDTO.setDbid(order.getOrderNo());
        requestDTO.setShjg(msg.getUnderwriteFlag());
        requestDTO.setBtgyy(msg.getUnderwritemsg());
        requestDTO.setShsj(ObjectUtil.isEmpty((Object)msg.getUnderwriteTime()) ? msg.getUnderWriteEndDate() : msg.getUnderwriteTime());
        return requestDTO;
    }

    private ApisBusiChannelOrder getUwResultOrder(LitigationUwResultMsgDTO msg) throws ApisBusinessException {
        ApisBusiChannelOrder order = null;
        if (ObjectUtil.isNotEmpty((Object)msg) && ObjectUtil.isNotEmpty((Object)msg.getPolicyNo())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"policy_no", (Object)msg.getPolicyNo());
            order = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
        } else if (ObjectUtil.isNotEmpty((Object)msg) && ObjectUtil.isNotEmpty((Object)msg.getProposalNo())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"proposal_no", (Object)msg.getProposalNo());
            order = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
        } else {
            log.error("\u8bc9\u8d23\u9669\u5ba1\u6838\u6d88\u606f\u63a8\u9001\u5931\u8d25-\u300b\u4fdd\u5355\u53f7\u4e3a\u7a7a\u3002");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10005.getValue(), ChannelErrorCodeEnum.ERR_C10005.getKey());
        }
        return order;
    }

    private LitigationChangeGuaOfflineDTO settleChangeGuaOfflineInfo(PolicyDetailResponse policyDetailResponse) throws ApisBusinessException {
        Map zjlxMap = this.dataCompletionUtil.getCodeMap("GY_ZJLX");
        Map qylxMap = this.dataCompletionUtil.getCodeMap("GY_QYLX");
        LitigationChangeGuaOfflineDTO changeGuaOfflineDto = new LitigationChangeGuaOfflineDTO();
        changeGuaOfflineDto.setJbxx(this.packagedPolicy(policyDetailResponse));
        changeGuaOfflineDto.setDsrList(this.packagedBsqr(policyDetailResponse, zjlxMap, qylxMap));
        changeGuaOfflineDto.setSqrList(this.packagedSqr(policyDetailResponse, zjlxMap, qylxMap));
        changeGuaOfflineDto.setCcxsList(this.packagedCcxsList(policyDetailResponse));
        changeGuaOfflineDto.setSqclList(this.packagedSqclList(policyDetailResponse));
        changeGuaOfflineDto.setBdxx(this.packagedBdxx(policyDetailResponse));
        return changeGuaOfflineDto;
    }

    private BdxxDTO packagedBdxx(PolicyDetailResponse policyDetailResponse) {
        MainDTO main = policyDetailResponse.getResponseBody().getPolicy().getMain();
        String bhUrl = this.ePolicyDownService.getElectronicGuaranteeUrl(main.getProposalNo());
        StanderRequest request = StanderRequest.builder().header(StanderHeader.builder().channelCode("SSP_USER").build()).build();
        String bdUrl = this.cfDrugsUtil.getPolicyDownUrl(request, main.getPolicyNo());
        return BdxxDTO.builder().bdh(main.getPolicyNo()).bhUrl(bhUrl).bdUrl(bdUrl).build();
    }

    private List<SqclDTO> packagedSqclList(PolicyDetailResponse policyDetailResponse) {
        ArrayList<SqclDTO> sqclList = new ArrayList<SqclDTO>();
        String proposalNo = policyDetailResponse.getResponseBody().getPolicy().getMain().getProposalNo();
        InsuredDTO insured = (InsuredDTO)policyDetailResponse.getResponseBody().getPolicy().getInsuredList().get(0);
        List imageNodes = this.getImageNodes(proposalNo);
        for (ImageNodeDTO imageNode : imageNodes) {
            SqclDTO sqclDto = new SqclDTO();
            sqclDto.setSqclid(insured.getInsuredId());
            sqclDto.setDbclmc(imageNode.getFileName());
            sqclDto.setFileUrl(this.ePolicyDownService.getOuterNetDownUrl(imageNode.getImgUrl(), imageNode.getFileName()));
            sqclDto.setDbcllx("5");
            sqclDto.setDbId(policyDetailResponse.getResponseBody().getPolicy().getMain().getOrderNo());
            sqclList.add(sqclDto);
        }
        return sqclList;
    }

    private List<ImageNodeDTO> getImageNodes(String proposalNo) {
        List<Object> imageNodes = new ArrayList<ImageNodeDTO>();
        try {
            ImageQueryDownRequest request = new ImageQueryDownRequest();
            boolean encFlag = this.imageUtils.imgConsumerPwdEncFlag();
            ImageRequestHeadDTO headDto = this.imageUtils.initImageRequestHead(encFlag);
            ImageQueryDownRequestDTO requestDto = new ImageQueryDownRequestDTO();
            ImageSystemBaseDTO baseData = new ImageSystemBaseDTO();
            baseData.setComCode("000000");
            baseData.setNetType("http.inner");
            baseData.setOperator("test001");
            baseData.setOperatorName("\u627f\u4fdd\u6d4b\u8bd5\u4eba\u5458");
            baseData.setOperatorRole("UWA_T01");
            ImageSystemMetaDTO metaData = new ImageSystemMetaDTO();
            metaData.setAppCode("UW");
            metaData.setClassCode("UWA");
            metaData.setBusinessNo(proposalNo);
            ArrayList<String> nodeCodes = new ArrayList<String>();
            nodeCodes.add("|UWA_A|UWA_A99|");
            metaData.setNodeCodes(nodeCodes);
            requestDto.setBaseData(baseData);
            requestDto.setMetaData(metaData);
            request.setRequestHead(headDto);
            request.setRequestBody(requestDto);
            String url = encFlag ? this.coreApiImgQueryDownNewUrl : this.coreApiImgQueryDownUrl;
            OkHttpClient okHttpClient = new OkHttpClient();
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)JSON.toJSONString((Object)request));
            Request okRequest = new Request.Builder().url(url).post(requestBody).build();
            Response okResponse = okHttpClient.newCall(okRequest).execute();
            String responseStr = okResponse.body().string();
            log.warn("\u5f71\u50cf\u7cfb\u7edf3.1\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseStr);
            ImageQueryDownResponse imageQueryDownResponse = (ImageQueryDownResponse)JSON.parseObject((String)responseStr, ImageQueryDownResponse.class);
            ImageQueryDownResponseDTO imageQueryDownResponseDTO = imageQueryDownResponse.getResponseBody();
            if (ObjectUtil.isNotEmpty((Object)imageQueryDownResponseDTO) && ObjectUtil.isNotEmpty((Object)imageQueryDownResponseDTO.getImageNodes())) {
                imageNodes = imageQueryDownResponseDTO.getImageNodes();
            }
        }
        catch (Exception e) {
            log.error("\u5f71\u50cf\u7cfb\u7edf3.1\u63a5\u53e3\u5f02\u5e38:" + e);
        }
        return imageNodes;
    }

    private List<CcxsDTO> packagedCcxsList(PolicyDetailResponse policyDetailResponse) {
        Map preservationTypeMap = this.dataCompletionUtil.getCodeMap("preservationType");
        ArrayList<CcxsDTO> ccxsList = new ArrayList<CcxsDTO>();
        MainDTO mainDTO = policyDetailResponse.getResponseBody().getPolicy().getMain();
        List riskInfoActionDutyList = policyDetailResponse.getResponseBody().getPolicy().getCoverage().getRiskInfoActionDutyList();
        List respondentList = policyDetailResponse.getResponseBody().getPolicy().getCoverage().getRespondents();
        HashMap<String, String> propertyOwnerMap = new HashMap<String, String>();
        for (RespondentDTO respondent : respondentList) {
            propertyOwnerMap.put(respondent.getSerialNo().toString(), respondent.getInsuredId());
        }
        for (RiskInfoActionDutyDTO riskInfoActionDutyDto : riskInfoActionDutyList) {
            CcxsDTO ccxs = new CcxsDTO();
            ccxs.setDbid(mainDTO.getOrderNo());
            String preservationType = ObjectUtil.isNotEmpty(preservationTypeMap.get(riskInfoActionDutyDto.getPropertyType())) ? (String)preservationTypeMap.get(riskInfoActionDutyDto.getPropertyType()) : "255";
            ccxs.setCclx(preservationType);
            String owner = ObjectUtil.isNotEmpty(propertyOwnerMap.get(riskInfoActionDutyDto.getPropertyOwner())) ? (String)propertyOwnerMap.get(riskInfoActionDutyDto.getPropertyOwner()) : "";
            ccxs.setCcsyr(owner);
            ccxs.setCcjz(riskInfoActionDutyDto.getPropertyValue());
            JSONObject jsonObject = new JSONObject();
            if (ApisCommonConstantsEnum.PROPERTY_CASH.getKey().equals(preservationType)) {
                jsonObject.put("se", (Object)riskInfoActionDutyDto.getAmount());
                jsonObject.put("bz", (Object)this.conversionCurrency(riskInfoActionDutyDto.getCurrency()));
            } else if (ApisCommonConstantsEnum.PROPERTY_HOUSE.getKey().equals(preservationType)) {
                jsonObject.put("fwzlwz", (Object)riskInfoActionDutyDto.getHouseLocation());
                jsonObject.put("fczh", (Object)riskInfoActionDutyDto.getHousePropertyNo());
            } else if (ApisCommonConstantsEnum.PROPERTY_BANK_DEPOSITS.getKey().equals(preservationType)) {
                jsonObject.put("khyhmc", (Object)riskInfoActionDutyDto.getBankName());
                jsonObject.put("yhzh", (Object)riskInfoActionDutyDto.getBankAccount());
                jsonObject.put("se", (Object)riskInfoActionDutyDto.getAmount());
                jsonObject.put("bz", (Object)this.conversionCurrency(riskInfoActionDutyDto.getCurrency()));
            } else if (ApisCommonConstantsEnum.PROPERTY_VEHICLE.getKey().equals(preservationType)) {
                jsonObject.put("clpp", (Object)riskInfoActionDutyDto.getVehicleBrand());
                jsonObject.put("cllx", (Object)riskInfoActionDutyDto.getVehicleType());
                jsonObject.put("cph", (Object)riskInfoActionDutyDto.getLicenseNo());
            } else if (ApisCommonConstantsEnum.PROPERTY_LAND.getKey().equals(preservationType)) {
                jsonObject.put("dzhqs", (Object)riskInfoActionDutyDto.getAddressOrOwnership());
                jsonObject.put("mj", (Object)riskInfoActionDutyDto.getArea());
                jsonObject.put("dw", (Object)riskInfoActionDutyDto.getUnit());
                jsonObject.put("cqzh", (Object)riskInfoActionDutyDto.getTitleCertificateNo());
            } else if (ApisCommonConstantsEnum.PROPERTY_STOCK.getKey().equals(preservationType)) {
                jsonObject.put("gpmc", (Object)riskInfoActionDutyDto.getStockName());
                jsonObject.put("gpdm", (Object)riskInfoActionDutyDto.getStockCode());
                jsonObject.put("cgsl", (Object)riskInfoActionDutyDto.getStockCount());
            } else if (ApisCommonConstantsEnum.PROPERTY_FUND.getKey().equals(preservationType)) {
                jsonObject.put("jjmc", (Object)riskInfoActionDutyDto.getFundName());
                jsonObject.put("jjsl", (Object)riskInfoActionDutyDto.getFundCount());
            } else if (ApisCommonConstantsEnum.PROPERTY_BOND.getKey().equals(preservationType)) {
                jsonObject.put("zqmc", (Object)riskInfoActionDutyDto.getBondName());
                jsonObject.put("zqmz", (Object)riskInfoActionDutyDto.getBondFaceValue());
            } else if (ApisCommonConstantsEnum.PROPERTY_EQUITY.getKey().equals(preservationType)) {
                jsonObject.put("cggsmc", (Object)riskInfoActionDutyDto.getHoldingCompanyName());
                jsonObject.put("czbl", (Object)riskInfoActionDutyDto.getInvestmentPropotion());
            } else {
                jsonObject.put("ms", (Object)riskInfoActionDutyDto.getDescription());
            }
            ccxs.setExtInfo(JSON.toJSONString((Object)jsonObject));
            ccxsList.add(ccxs);
        }
        return ccxsList;
    }

    public List<DsrDTO> packagedBsqr(PolicyDetailResponse policyDetailResponse, Map<String, String> qylxMap, Map<String, String> zjlxMap) {
        MainDTO mainDTO = policyDetailResponse.getResponseBody().getPolicy().getMain();
        List respondentDTOList = policyDetailResponse.getResponseBody().getPolicy().getCoverage().getRespondents();
        ArrayList<DsrDTO> dsrList = new ArrayList<DsrDTO>();
        for (RespondentDTO respondentDTO : respondentDTOList) {
            String idType;
            DsrDTO dsr = new DsrDTO();
            dsr.setPid(respondentDTO.getInsuredId());
            dsr.setDbid(mainDTO.getOrderNo());
            dsr.setPersonType(respondentDTO.getInsuredType());
            if ("1".equals(dsr.getPersonType())) {
                dsr.setXm(respondentDTO.getInsuredName());
                dsr.setZjh(respondentDTO.getIdentifyNumber());
                dsr.setXb(respondentDTO.getSex());
                if (ObjectUtil.isNotEmpty((Object)respondentDTO.getBirthday())) {
                    dsr.setCsrq(DateUtil.format((Date)respondentDTO.getBirthday(), (String)"yyyy-MM-dd"));
                }
                if (ObjectUtil.isNotEmpty((Object)respondentDTO.getAge())) {
                    dsr.setNl(respondentDTO.getAge().toString());
                }
                dsr.setYx(respondentDTO.getEmail());
                dsr.setSjhm(respondentDTO.getMobile());
                idType = ObjectUtil.isNotEmpty((Object)zjlxMap.get(respondentDTO.getIdentifyType())) ? zjlxMap.get(respondentDTO.getIdentifyType()) : "255";
                dsr.setZjlx(idType);
            } else {
                dsr.setQymc(respondentDTO.getInsuredName());
                dsr.setQyzzjgdm(respondentDTO.getIdentifyNumber());
                idType = ObjectUtil.isNotEmpty((Object)qylxMap.get(respondentDTO.getIdentifyType())) ? qylxMap.get(respondentDTO.getIdentifyType()) : "255";
                dsr.setQyzzjgdmlx(idType);
                dsr.setQyfr(respondentDTO.getCorporationName());
                dsr.setSjhm(respondentDTO.getContactPhone());
                dsr.setDwdz(respondentDTO.getInsuredAddress());
            }
            dsr.setSf("3");
            dsrList.add(dsr);
        }
        return dsrList;
    }

    public List<DsrDTO> packagedSqr(PolicyDetailResponse policyDetailResponse, Map<String, String> qylxMap, Map<String, String> zjlxMap) {
        MainDTO mainDTO = policyDetailResponse.getResponseBody().getPolicy().getMain();
        List insuredList = policyDetailResponse.getResponseBody().getPolicy().getInsuredList();
        ArrayList<DsrDTO> dsrList = new ArrayList<DsrDTO>();
        for (InsuredDTO insured : insuredList) {
            String zjlx;
            DsrDTO dsr = new DsrDTO();
            dsr.setPid(insured.getInsuredId());
            dsr.setDbid(mainDTO.getOrderNo());
            dsr.setPersonType(insured.getInsuredType());
            if ("1".equals(dsr.getPersonType())) {
                dsr.setXm(insured.getInsuredName());
                dsr.setZjh(insured.getIdentifyNumber());
                dsr.setXb(insured.getSex());
                if (ObjectUtil.isNotEmpty((Object)insured.getBirthday())) {
                    dsr.setCsrq(DateUtil.format((Date)insured.getBirthday(), (String)"yyyy-MM-dd"));
                }
                if (ObjectUtil.isNotEmpty((Object)insured.getAge())) {
                    dsr.setNl(insured.getAge().toString());
                }
                dsr.setYx(insured.getEmail());
                dsr.setSjhm(insured.getMobile());
                zjlx = ObjectUtil.isNotEmpty((Object)zjlxMap.get(insured.getIdentifyType())) ? zjlxMap.get(insured.getIdentifyType()) : "255";
                dsr.setZjlx(zjlx);
                dsr.setJcjzd(insured.getInsuredAddress());
            } else {
                dsr.setQymc(insured.getInsuredName());
                dsr.setQyzzjgdm(insured.getIdentifyNumber());
                zjlx = ObjectUtil.isNotEmpty((Object)qylxMap.get(insured.getIdentifyType())) ? qylxMap.get(insured.getIdentifyType()) : "255";
                dsr.setQyzzjgdmlx(zjlx);
                dsr.setQyfr(insured.getCorporationName());
                dsr.setSjhm(insured.getContactPhone());
                dsr.setDwdz(insured.getInsuredAddress());
            }
            dsr.setSf("3");
            dsrList.add(dsr);
        }
        return dsrList;
    }

    public String conversionCurrency(String paramCurrency) {
        HashMap<String, String> currencyMap = new HashMap<String, String>();
        currencyMap.put("\u4eba\u6c11\u5e01", "1");
        currencyMap.put("\u6e2f\u5e01", "2");
        currencyMap.put("\u7f8e\u5143", "3");
        currencyMap.put("\u82f1\u9551", "4");
        currencyMap.put("\u6b27\u5143", "5");
        if (ObjectUtil.isNotEmpty(currencyMap.get(paramCurrency)) && currencyMap.get(paramCurrency) instanceof String) {
            return currencyMap.get(paramCurrency).toString();
        }
        return "";
    }
}

