/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderBasicsPolicyQueryHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderCorrectListQueryHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderPolicyDetailHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.JDAZAesUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderPacket;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.BasicsPolicyQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.BasicsPolicyQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorseListQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorseListQueryServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RenewalInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.SalesDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUwResultMsgDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushEndorseDetailRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushEndorseDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushPolicyAppliClient;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushPolicyBeneficiary;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushPolicyCoverage;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushPolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushPolicyDetailRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushPolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushPolicyInsured;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushPolicyItemKind;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushPolicyItemMain;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushPolicyMain;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushPolicyRenewalInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushPolicyRiskInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.pushAgent.request.PushPolicySales;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.BasicsPolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.BasicsPolicyQueryDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.BeneficiaryDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseListQueryResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.MainEndorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelInstallmentOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelInstallmentOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class PushToAgentUtil {
    private static final Logger log = LoggerFactory.getLogger(PushToAgentUtil.class);
    @Autowired
    StanderPolicyDetailHandler standerPolicyDetailHandler;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    StanderCorrectListQueryHandler standerCorrectListQueryHandler;
    @Autowired
    ApisBusiChannelInstallmentOrderService apisBusiChannelInstallmentOrderService;
    @Autowired
    ApisChannelUserService apisChannelUserService;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    StanderBasicsPolicyQueryHandler standerBasicsPolicyQueryHandler;
    private static final String ENCRYPT_CONTENT = "encrypt";
    private static final String DECRYPT_CONTENT = "decrypt";
    private static final String FULL_SURRENDER = "ET";
    private static final String GENERAL_CORRECTION = "EB";
    private static String BUSS_TYPE_E = "E";

    @Async(value="scheduleTaskNotifyExecutor")
    public void pushPolicyDetailToAgent(LitigationUwResultMsgDTO msg) throws ApisBusinessException {
        List needPushChannels;
        log.warn("\u63a8\u9001\u6700\u65b0\u4fdd\u5355\u4fe1\u606f\u7ed9\u6e20\u9053mq\uff1a{}", (Object)JSON.toJSONString((Object)msg));
        PolicyDetailResponse policyDetailResponse = this.getPolicyDetail(msg.getPolicyNo());
        if (ObjectUtil.isEmpty((Object)policyDetailResponse)) {
            log.warn("\u63a8\u9001\u6700\u65b0\u4fdd\u5355\u4fe1\u606f\u7ed9\u6e20\u9053,\u8fd4\u56de\u4e3a\u7a7a,\u4fdd\u5355\u53f7:{}", (Object)msg.getPolicyNo());
            return;
        }
        MainDTO main = policyDetailResponse.getResponseBody().getPolicy().getMain();
        String agentCode = policyDetailResponse.getResponseBody().getPolicy().getSalesList().getAgentCode();
        String businessType = msg.getMsgType();
        String pushType = ApisAutoTaskConstantsEnum.PUSH_POLICY_INFO_TO_AGENT.getKey();
        String businessKey = msg.getPolicyNo();
        if (BUSS_TYPE_E.equals(businessType)) {
            if ("06".equals(msg.getEndorseType())) {
                businessType = GENERAL_CORRECTION;
                pushType = ApisAutoTaskConstantsEnum.PUSH_POLICY_PRESERVATION_TO_AGENT.getKey();
                businessKey = msg.getApplyNo();
            }
            if ("12".equals(msg.getEndorseType())) {
                businessType = GENERAL_CORRECTION;
                pushType = ApisAutoTaskConstantsEnum.PUSH_POLICY_PRESERVATION_TO_AGENT.getKey();
                businessKey = businessKey + "_" + RandomUtil.randomInt((int)1000);
            }
        }
        if (ObjectUtil.isEmpty((Object)(needPushChannels = this.getNeedPushChannels(businessType, agentCode, msg.getGoodsCode())))) {
            log.warn("\u63a8\u9001\u6700\u65b0\u4fdd\u5355\u4fe1\u606f\u7ed9\u6e20\u9053,\u6ca1\u6709\u914d\u7f6e\u63a8\u9001\u6e20\u9053,\u4fdd\u5355\u53f7:{}", (Object)msg.getPolicyNo());
            return;
        }
        PushPolicyDetailRequestDTO requestBody = this.buildPushPolicyDetailRequest(policyDetailResponse.getResponseBody());
        if ("06".equals(msg.getEndorseType())) {
            EndorseListQueryResponseDTO endorseListQueryResponse = this.getEndorseDetail(msg);
            if (ObjectUtil.isEmpty((Object)endorseListQueryResponse)) {
                log.warn("\u63a8\u9001\u6700\u65b0\u4fdd\u5355\u4fe1\u606f\u7ed9\u6e20\u9053,\u6ca1\u6709\u67e5\u8be2\u5230\u6279\u5355\u4fe1\u606f,\u4fdd\u5355\u53f7:{}", (Object)msg.getPolicyNo());
                return;
            }
            MainEndorResponseDTO mainEndorResponseDTO = (MainEndorResponseDTO)endorseListQueryResponse.getEndorseList().get(0);
            PushPolicyMain policyMain = requestBody.getPolicy().getMain();
            policyMain.setEndorseNo(mainEndorResponseDTO.getEndorseNo());
            policyMain.setEndorseText(mainEndorResponseDTO.getEndorseText());
            policyMain.setValidDateStr(mainEndorResponseDTO.getValidDateStr());
            policyMain.setEndorseType(mainEndorResponseDTO.getEndorseType());
            List basicsPolicyQueryList = this.getBasicsPolicyList(msg.getPolicyNo());
            this.buildBasicsPolicyQueryList(requestBody, basicsPolicyQueryList);
        }
        if ("12".equals(msg.getEndorseType())) {
            List basicsPolicyQueryList = this.getBasicsPolicyList(msg.getPolicyNo());
            this.buildBasicsPolicyQueryList(requestBody, basicsPolicyQueryList);
        }
        PushPolicyDetailRequest pushPolicyDetailRequest = PushPolicyDetailRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(requestBody).build();
        String pushContent = JSON.toJSONString((Object)pushPolicyDetailRequest);
        log.warn("\u63a8\u9001\u6700\u65b0\u4fdd\u5355\u4fe1\u606f\u7ed9\u6e20\u9053,\u52a0\u5bc6\u524d\u8bf7\u6c42\u62a5\u6587:{}", (Object)pushContent);
        String finalPushType = pushType;
        String finalBusinessKey = businessKey;
        needPushChannels.forEach(t -> {
            ApisChannelUser apisChannelUser = this.getApisChannelUser(StringUtils.isNotEmpty((CharSequence)t.getUserCode()) ? t.getUserCode() : main.getOperateCode());
            String requestContent = this.jdazAes(apisChannelUser, pushContent, ENCRYPT_CONTENT);
            ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
            String pushUrl = t.getConfigValue();
            apisBusiTaskLog.setPushTargetUrl(pushUrl);
            apisBusiTaskLog.setPushStep(Integer.valueOf(1));
            apisBusiTaskLog.setBusinessKey(t.getChannelCode() + finalBusinessKey);
            apisBusiTaskLog.setPushStatus("0");
            apisBusiTaskLog.setPushType(finalPushType);
            StanderPacket standerPacket = StanderPacket.builder().userCode(apisChannelUser.getUserCode()).content(requestContent).build();
            apisBusiTaskLog.setPushContent(JSON.toJSONString((Object)standerPacket));
            apisBusiTaskLog.setLastPushTime(LocalDateTime.now());
            try {
                StanderPacket responsePacket = (StanderPacket)this.httpRequestService.convertAndSendForAgent(apisBusiTaskLog.getPushTargetUrl(), (Object)standerPacket, StanderPacket.class, finalPushType);
                if (ObjectUtil.isNotEmpty((Object)responsePacket)) {
                    String responseStr = this.jdazAes(apisChannelUser, responsePacket.getContent(), DECRYPT_CONTENT);
                    ResponseHeadDTO responseHead = (ResponseHeadDTO)JSON.parseObject((String)responseStr, ResponseHeadDTO.class);
                    if (ObjectUtil.isNotEmpty((Object)responseHead) && CommonConstant.FccbResponseCode.SUCCESS.intValue() == responseHead.getStatus()) {
                        apisBusiTaskLog.setPushStatus("1");
                    } else {
                        apisBusiTaskLog.setPushStatus("4");
                    }
                    apisBusiTaskLog.setErrMsg(JSON.toJSONString((Object)responseHead));
                } else {
                    apisBusiTaskLog.setPushStatus("4");
                    apisBusiTaskLog.setErrMsg("\u672a\u8fd4\u56de\u5185\u5bb9");
                }
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u6700\u65b0\u4fdd\u5355\u4fe1\u606f\u7ed9\u6e20\u9053\u5931\u8d25\uff0c\u6e20\u9053\u4ee3\u7801\uff1a{},\u4fdd\u5355\u53f7\uff1a{}", (Object)t.getChannelCode(), (Object)msg.getPolicyNo());
                apisBusiTaskLog.setPushStatus("4");
                apisBusiTaskLog.setErrMsg(e.getLocalizedMessage());
            }
            finally {
                this.apisBusiTaskLogService.saveOrUpdate((Object)apisBusiTaskLog);
            }
        });
    }

    private void buildBasicsPolicyQueryList(PushPolicyDetailRequestDTO requestBody, List<BasicsPolicyQueryDTO> basicsPolicyQueryList) {
        List policyItemMains = requestBody.getPolicy().getCoverage().getItemList();
        List pushPolicyInsureds = ((PushPolicyItemMain)policyItemMains.get(0)).getInsuredIdvList();
        block0: for (PushPolicyInsured insured : pushPolicyInsureds) {
            for (BasicsPolicyQueryDTO basicsPolicyQueryDTO : basicsPolicyQueryList) {
                if (insured.getSerialNo() != basicsPolicyQueryDTO.getSerialNo()) continue;
                BasicsPolicyDTO basicsPolicyDTO = BasicsPolicyDTO.builder().build();
                BeanUtil.copyProperties((Object)basicsPolicyQueryDTO, (Object)basicsPolicyDTO, (String[])new String[0]);
                insured.setBasicsPolicy(basicsPolicyDTO);
                continue block0;
            }
        }
    }

    public List<BasicsPolicyQueryDTO> getBasicsPolicyList(String policyNo) throws ApisBusinessException {
        ArrayList<BasicsPolicyQueryDTO> basicsPolicyQueryList = new ArrayList<BasicsPolicyQueryDTO>();
        StanderRequest request = StanderRequest.builder().build();
        BasicsPolicyQueryRequest basicsPolicyQueryRequest = BasicsPolicyQueryRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(BasicsPolicyQueryRequestDTO.builder().policyNo(policyNo).build()).build();
        request.setBasicsPolicyQueryRequest(basicsPolicyQueryRequest);
        StanderResponse response = this.standerBasicsPolicyQueryHandler.execute(request);
        if (ObjectUtil.isNotEmpty((Object)response) && ObjectUtil.isNotEmpty((Object)response.getBasicsPolicyQueryResponse()) && CommonConstant.FccbResponseCode.SUCCESS.intValue() == response.getBasicsPolicyQueryResponse().getResponseHead().getStatus()) {
            List responseList = response.getBasicsPolicyQueryResponse().getResponseBody().getBasicsPolicy();
            Map<Integer, List<BasicsPolicyQueryDTO>> mapListAll = responseList.stream().collect(Collectors.groupingBy(BasicsPolicyQueryDTO::getSerialNo));
            for (Map.Entry<Integer, List<BasicsPolicyQueryDTO>> entry : mapListAll.entrySet()) {
                List<BasicsPolicyQueryDTO> basicsPolicyQueryDTOS = entry.getValue();
                BasicsPolicyQueryDTO b = (BasicsPolicyQueryDTO)basicsPolicyQueryDTOS.stream().max((e1, e2) -> {
                    Integer a = Integer.parseInt(e1.getSign().replaceAll("\\.", ""));
                    return a.compareTo(Integer.parseInt(e2.getSign().replaceAll("\\.", "")));
                }).get();
                basicsPolicyQueryList.add(b);
            }
            return basicsPolicyQueryList;
        }
        return null;
    }

    private PushPolicyDetailRequestDTO buildPushPolicyDetailRequest(PolicyDetailResponseDTO responseBody) {
        PushPolicyDetailRequestDTO pushPolicyDetailRequestDTO = PushPolicyDetailRequestDTO.builder().newApplyNo(responseBody.getNewApplyNo()).build();
        PushPolicyDTO pushPolicy = PushPolicyDTO.builder().build();
        MainDTO main = responseBody.getPolicy().getMain();
        PushPolicyMain policyMain = PushPolicyMain.builder().build();
        BeanUtil.copyProperties((Object)main, (Object)policyMain, (String[])new String[0]);
        pushPolicy.setMain(policyMain);
        List appliClientDTOList = responseBody.getPolicy().getAppliClient();
        ArrayList<PushPolicyAppliClient> pushPolicyAppliClientList = new ArrayList<PushPolicyAppliClient>();
        for (AppliClientDTO appliClientDTO : appliClientDTOList) {
            PushPolicyAppliClient pushPolicyAppliClient = PushPolicyAppliClient.builder().build();
            BeanUtil.copyProperties((Object)appliClientDTO, (Object)pushPolicyAppliClient, (String[])new String[0]);
            pushPolicyAppliClientList.add(pushPolicyAppliClient);
        }
        pushPolicy.setAppliClient(pushPolicyAppliClientList);
        PushPolicySales pushPolicySales = PushPolicySales.builder().build();
        SalesDTO salesDTO = responseBody.getPolicy().getSalesList();
        BeanUtil.copyProperties((Object)salesDTO, (Object)pushPolicySales, (String[])new String[0]);
        pushPolicy.setSales(pushPolicySales);
        PushPolicyRiskInfo pushPolicyRiskInfo = PushPolicyRiskInfo.builder().build();
        RiskInfoDTO riskInfo = responseBody.getPolicy().getRiskInfo();
        BeanUtil.copyProperties((Object)riskInfo, (Object)pushPolicyRiskInfo, (String[])new String[0]);
        pushPolicy.setRiskInfo(pushPolicyRiskInfo);
        PushPolicyRenewalInfo pushPolicyRenewalInfo = PushPolicyRenewalInfo.builder().build();
        RenewalInfoDTO renewalInfoDTO = responseBody.getPolicy().getRenewalInfoDTO();
        BeanUtil.copyProperties((Object)renewalInfoDTO, (Object)pushPolicyRenewalInfo, (String[])new String[0]);
        pushPolicy.setRenewal(pushPolicyRenewalInfo);
        PushPolicyCoverage pushPolicyCoverage = PushPolicyCoverage.builder().build();
        List itemMainList = responseBody.getPolicy().getCoverage().getItemList();
        ArrayList<PushPolicyItemMain> policyItemMains = new ArrayList<PushPolicyItemMain>();
        for (ItemMainDTO itemMain : itemMainList) {
            PushPolicyItemMain pushPolicyItemMain = PushPolicyItemMain.builder().build();
            BeanUtil.copyProperties((Object)itemMain, (Object)pushPolicyItemMain, (String[])new String[0]);
            ArrayList<PushPolicyInsured> insuredIdvList = new ArrayList<PushPolicyInsured>();
            for (InsuredIdvDTO insuredIdvDTO : itemMain.getInsuredIdvList()) {
                PushPolicyInsured policyInsured = PushPolicyInsured.builder().build();
                BeanUtil.copyProperties((Object)insuredIdvDTO, (Object)policyInsured, (String[])new String[0]);
                if (ObjectUtil.isNotEmpty((Object)insuredIdvDTO.getBeneficiary())) {
                    ArrayList<PushPolicyBeneficiary> beneficiaryList = new ArrayList<PushPolicyBeneficiary>();
                    for (BeneficiaryDTO beneficiaryDTO : insuredIdvDTO.getBeneficiary()) {
                        PushPolicyBeneficiary pushPolicyBeneficiary = PushPolicyBeneficiary.builder().build();
                        BeanUtil.copyProperties((Object)beneficiaryDTO, (Object)pushPolicyBeneficiary, (String[])new String[0]);
                        beneficiaryList.add(pushPolicyBeneficiary);
                    }
                    policyInsured.setBeneficiary(beneficiaryList);
                }
                insuredIdvList.add(policyInsured);
            }
            pushPolicyItemMain.setInsuredIdvList(insuredIdvList);
            ArrayList<PushPolicyItemKind> pushPolicyItemKindList = new ArrayList<PushPolicyItemKind>();
            for (ItemKindDTO itemKindDTO : itemMain.getItemKind()) {
                PushPolicyItemKind pushPolicyItemKind = PushPolicyItemKind.builder().build();
                BeanUtil.copyProperties((Object)itemKindDTO, (Object)pushPolicyItemKind, (String[])new String[0]);
                pushPolicyItemKindList.add(pushPolicyItemKind);
            }
            pushPolicyItemMain.setItemKind(pushPolicyItemKindList);
            policyItemMains.add(pushPolicyItemMain);
        }
        pushPolicyCoverage.setItemList(policyItemMains);
        pushPolicy.setCoverage(pushPolicyCoverage);
        pushPolicyDetailRequestDTO.setPolicy(pushPolicy);
        return pushPolicyDetailRequestDTO;
    }

    private String jdazAes(ApisChannelUser apisChannelUser, String pushContent, String type) {
        String seed = JDAZAesUtils.des3EncodeCbc((String)apisChannelUser.getUserCode(), (String)apisChannelUser.getPwd());
        String content = "";
        content = ENCRYPT_CONTENT.equals(type) ? JDAZAesUtils.encryptBase64((String)seed, (String)pushContent) : JDAZAesUtils.decryptBase64((String)seed, (String)pushContent);
        return content;
    }

    public void pushPolicySurrenderToAgent(LitigationUwResultMsgDTO msg) {
        log.warn("\u63a8\u9001\u4fdd\u5355\u9000\u4fdd\u4fe1\u606f\u7ed9\u6e20\u9053mq\uff1a{}", (Object)JSON.toJSONString((Object)msg));
        EndorseListQueryResponseDTO endorseListQueryResponse = this.getEndorseDetail(msg);
        if (ObjectUtil.isEmpty((Object)endorseListQueryResponse)) {
            log.warn("\u63a8\u9001\u4fdd\u5355\u9000\u4fdd\u4fe1\u606f\u7ed9\u6e20\u9053,\u6ca1\u6709\u67e5\u8be2\u5230\u6279\u5355\u4fe1\u606f,\u4fdd\u5355\u53f7:{}", (Object)msg.getPolicyNo());
            return;
        }
        MainEndorResponseDTO main = (MainEndorResponseDTO)endorseListQueryResponse.getEndorseList().get(0);
        ApisBusiChannelOrder apisBusiChannelOrder = this.apisBusiChannelOrderService.findOneByPolicyNo(msg.getPolicyNo());
        if (ObjectUtil.isEmpty((Object)apisBusiChannelOrder)) {
            log.warn("\u63a8\u9001\u4fdd\u5355\u9000\u4fdd\u4fe1\u606f\u7ed9\u6e20\u9053,\u4fdd\u5355\u4fe1\u606f\u4e0d\u5b58\u5728,\u4fdd\u5355\u53f7:{}", (Object)msg.getPolicyNo());
            return;
        }
        List needPushChannels = this.getNeedPushChannels(FULL_SURRENDER, apisBusiChannelOrder.getChannelCode(), msg.getGoodsCode());
        if (ObjectUtil.isEmpty((Object)needPushChannels)) {
            log.warn("\u63a8\u9001\u4fdd\u5355\u9000\u4fdd\u4fe1\u606f\u7ed9\u6e20\u9053,\u6ca1\u6709\u914d\u7f6e\u63a8\u9001\u6e20\u9053,\u6279\u6539\u7533\u8bf7\u5355\u53f7:{}", (Object)msg.getApplyNo());
            return;
        }
        String needRefund = this.judgeIsNeedRefund(main.getPaymentFlag());
        BigDecimal refundPremium = new BigDecimal(ObjectUtil.isNotEmpty((Object)msg.getActualRefPremium()) ? Math.abs(msg.getActualRefPremium().doubleValue()) : Math.abs(msg.getChgSumPremium().doubleValue()));
        PushEndorseDetailRequestDTO pushEndorseDetailRequestDTO = PushEndorseDetailRequestDTO.builder().auditDate((Date)DateUtil.parse((CharSequence)msg.getAuditDate(), (String)"yyyy-MM-dd HH:mm:ss")).policyNo(msg.getPolicyNo()).refundDate(main.getEndorseDate()).refundEffectDate((Date)DateUtil.parse((CharSequence)msg.getValidDate(), (String)"yyyy-MM-dd HH:mm:ss")).refundPremium(refundPremium.setScale(2, 4)).periodNum(this.getPeriodNum(msg.getPolicyNo())).needRefund(needRefund).build();
        PushEndorseDetailRequest pushEndorseDetailRequest = PushEndorseDetailRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(pushEndorseDetailRequestDTO).build();
        String pushContent = JSON.toJSONString((Object)pushEndorseDetailRequest);
        log.warn("\u63a8\u9001\u4fdd\u5355\u9000\u4fdd\u4fe1\u606f\u7ed9\u6e20\u9053,\u52a0\u5bc6\u524d\u8bf7\u6c42\u62a5\u6587:{}", (Object)pushContent);
        needPushChannels.forEach(t -> {
            ApisChannelUser apisChannelUser = this.getApisChannelUser(StringUtils.isNotEmpty((CharSequence)t.getUserCode()) ? t.getUserCode() : apisBusiChannelOrder.getCreator());
            String requestContent = this.jdazAes(apisChannelUser, pushContent, ENCRYPT_CONTENT);
            StanderPacket standerPacket = StanderPacket.builder().userCode(apisChannelUser.getUserCode()).content(requestContent).build();
            ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
            try {
                apisBusiTaskLog.setPushContent(JSON.toJSONString((Object)standerPacket));
                apisBusiTaskLog.setBusinessKey(t.getChannelCode() + msg.getPolicyNo());
                String pushUrl = t.getConfigValue();
                apisBusiTaskLog.setPushTargetUrl(pushUrl);
                apisBusiTaskLog.setPushStep(Integer.valueOf(1));
                apisBusiTaskLog.setPushStatus("0");
                apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.PUSH_POLICY_SURRENDER_TO_AGENT.getKey());
                apisBusiTaskLog.setLastPushTime(LocalDateTime.now());
                StanderPacket responsePacket = (StanderPacket)this.httpRequestService.convertAndSendForAgent(pushUrl, (Object)standerPacket, StanderPacket.class, ApisAutoTaskConstantsEnum.PUSH_POLICY_SURRENDER_TO_AGENT.getKey());
                if (ObjectUtil.isNotEmpty((Object)responsePacket)) {
                    String responseStr = this.jdazAes(apisChannelUser, responsePacket.getContent(), DECRYPT_CONTENT);
                    ResponseHeadDTO responseHead = (ResponseHeadDTO)JSON.parseObject((String)responseStr, ResponseHeadDTO.class);
                    if (ObjectUtil.isNotEmpty((Object)responseHead) && CommonConstant.FccbResponseCode.SUCCESS.intValue() == responseHead.getStatus()) {
                        apisBusiTaskLog.setPushStatus("1");
                    } else {
                        apisBusiTaskLog.setPushStatus("4");
                    }
                    apisBusiTaskLog.setErrMsg(JSON.toJSONString((Object)responseHead));
                } else {
                    apisBusiTaskLog.setPushStatus("4");
                    apisBusiTaskLog.setErrMsg("\u672a\u8fd4\u56de\u5185\u5bb9");
                }
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u4fdd\u5355\u9000\u4fdd\u4fe1\u606f\u7ed9\u6e20\u9053\u5931\u8d25\uff0c\u6e20\u9053\u4ee3\u7801\uff1a{},\u4fdd\u5355\u53f7\uff1a{}", (Object)t.getChannelCode(), (Object)msg.getPolicyNo());
                apisBusiTaskLog.setPushStatus("4");
                apisBusiTaskLog.setErrMsg(e.getLocalizedMessage());
            }
            finally {
                this.apisBusiTaskLogService.saveOrUpdate((Object)apisBusiTaskLog);
            }
        });
    }

    private ApisChannelUser getApisChannelUser(String operatorCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_code", (Object)operatorCode);
        queryWrapper.eq((Object)"deleted", (Object)ApisChannelUser.DELETE_FLAG_FALSE);
        ApisChannelUser apisChannelUser = (ApisChannelUser)this.apisChannelUserService.getOne((Wrapper)queryWrapper, false);
        if (ObjectUtil.isNotEmpty((Object)apisChannelUser)) {
            return apisChannelUser;
        }
        return null;
    }

    private String judgeIsNeedRefund(String paymentFlag) {
        String needRefund = "Y";
        switch (StringUtils.isEmpty((CharSequence)paymentFlag) ? "999" : paymentFlag) {
            case "1": {
                needRefund = "Y";
                break;
            }
            case "2": {
                needRefund = "N";
                break;
            }
            case "3": {
                needRefund = "N";
                break;
            }
            case "4": {
                needRefund = "N";
                break;
            }
            case "5": {
                needRefund = "N";
                break;
            }
            case "6": {
                needRefund = "N";
                break;
            }
            case "999": {
                needRefund = "Y";
                break;
            }
            default: {
                log.warn("\u652f\u4ed8\u65b9\u5f0f\u6807\u5fd7paymentFlag\u9519\u8bef");
            }
        }
        return needRefund;
    }

    private Integer getPeriodNum(String policyNo) {
        int sum = 0;
        List list = this.apisBusiChannelInstallmentOrderService.getOrderByPolicyNo(policyNo);
        for (ApisBusiChannelInstallmentOrder dto : list) {
            if (!ObjectUtil.isNotEmpty((Object)dto.getOrderNo())) continue;
            ++sum;
        }
        return sum == 0 ? null : Integer.valueOf(sum);
    }

    private EndorseListQueryResponseDTO getEndorseDetail(LitigationUwResultMsgDTO msg) {
        EndorseListQueryServiceRequest endorseListQueryServiceRequest = EndorseListQueryServiceRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(EndorseListQueryRequestDTO.builder().policyNo(msg.getPolicyNo()).operatorCode("all").endorseType(msg.getEndorseType()).build()).build();
        StanderResponse response = this.standerCorrectListQueryHandler.execute(StanderRequest.builder().endorseListQueryServiceRequest(endorseListQueryServiceRequest).build());
        if (ObjectUtil.isNotEmpty((Object)response) && ObjectUtil.isNotEmpty((Object)response.getEndorseListQueryResponse().getResponseBody()) && response.getEndorseListQueryResponse().getResponseBody().getCount() > 0) {
            return response.getEndorseListQueryResponse().getResponseBody();
        }
        return null;
    }

    private List<ApisChannelConfigs> getNeedPushChannels(String businessType, String agentCode, String goodsCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ration_code", (Object)goodsCode);
        queryWrapper.eq((Object)"config_code", (Object)"need_push_channels");
        queryWrapper.eq((Object)"value_type", (Object)businessType);
        List<Object> apisChannelConfigList = this.apisChannelConfigsService.list((Wrapper)queryWrapper);
        if (ObjectUtil.isEmpty((Object)apisChannelConfigList)) {
            apisChannelConfigList = new ArrayList<ApisChannelConfigs>();
        }
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"channel_code", (Object)agentCode);
        queryWrapper.eq((Object)"config_code", (Object)"need_push_channels");
        queryWrapper.eq((Object)"value_type", (Object)businessType);
        ApisChannelConfigs apisChannelConfigs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper, false);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs)) {
            apisChannelConfigList.add(apisChannelConfigs);
        }
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ration_code", (Object)goodsCode);
        queryWrapper.eq((Object)"channel_code", (Object)agentCode);
        queryWrapper.eq((Object)"config_code", (Object)"need_push_channels");
        queryWrapper.eq((Object)"value_type", (Object)businessType);
        apisChannelConfigs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper, false);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs)) {
            apisChannelConfigList.add(apisChannelConfigs);
        }
        if (ObjectUtil.isNotEmpty(apisChannelConfigList) && apisChannelConfigList.size() > 1) {
            apisChannelConfigList = apisChannelConfigList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ApisChannelConfigs>(Comparator.comparing(ApisChannelConfigs::getConfigValue))), ArrayList::new));
        }
        log.warn("\u9700\u8981\u63a8\u9001\u7684\u4fe1\u606f:{}", (Object)((Object)apisChannelConfigList).toString());
        return apisChannelConfigList;
    }

    private PolicyDetailResponse getPolicyDetail(String policyNo) throws ApisBusinessException {
        PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().build();
        policyDetailServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        policyDetailServiceRequest.setRequestBody(PolicyDetailRequestDTO.builder().policyNo(policyNo).businessNature2("all").operateCode("all").build());
        StanderRequest request = StanderRequest.builder().policyDetailServiceRequest(policyDetailServiceRequest).build();
        StanderResponse standerResponse = this.standerPolicyDetailHandler.execute(request);
        if (ObjectUtil.isNotEmpty((Object)standerResponse.getPolicyDetailResponse()) && ObjectUtil.isNotEmpty((Object)standerResponse.getPolicyDetailResponse().getResponseBody())) {
            return standerResponse.getPolicyDetailResponse();
        }
        return null;
    }
}

