/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.FastDateFormat;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.AesUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.TaskUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUwResultMsgDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.qiHu.QiHuData;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.qiHu.QiHuRequest;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelInstallmentOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiCorrectOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelInstallmentOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiCorrectOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class QiHuNotifyUtil {
    private static final Logger log = LoggerFactory.getLogger(QiHuNotifyUtil.class);
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    TaskUtil taskUtil;
    @Autowired
    AesUtils aesUtils;
    @Autowired
    ApisBusiCorrectOrderService apisBusiCorrectOrderService;
    @Autowired
    ApisBusiChannelInstallmentOrderService apisBusiChannelInstallmentOrderService;
    @Value(value="${qihu.secretKey}")
    private String secretKey;
    @Value(value="${qihu.appKey}")
    private String appKey;

    public void messageDeal(String message, LitigationUwResultMsgDTO dto) {
        log.warn("\u5947\u864e360MQ\u8f6c\u6362\u5b9e\u4f8b,{}", (Object)JSON.toJSONString((Object)dto));
        if (!this.isNeedPush(dto.getPolicyNo())) {
            log.warn("\u672c\u6b21\u5c5e\u4e8e\u6e20\u9053\u7533\u8bf7\u7684\u9000\u4fdd\uff0c\u4e0d\u63a8\u9001\u5230360");
            return;
        }
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        apisMsgMqlogs.setCreateTime((Date)DateUtil.date());
        apisMsgMqlogs.setMessage(message);
        apisMsgMqlogs.setTopic("apisTopic");
        apisMsgMqlogs.setConsumerGroup("fccbApisUndwResult");
        apisMsgMqlogs.setErrorFlag("0");
        this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
        if ("E".equals(dto.getMsgType()) && BusinessConstants.QIHU_NOTIFY_TYPE.SURRENDER_TYPE.contains(dto.getEndorseType())) {
            this.pushPolicySurrender(dto, apisMsgMqlogs);
        }
    }

    private boolean isNeedPush(String policyNo) {
        ApisBusiCorrectOrder apisBusiCorrectOrder = new ApisBusiCorrectOrder();
        apisBusiCorrectOrder.setPolicyNo(policyNo);
        List list = this.apisBusiCorrectOrderService.getApisBusiCorrectOrderList(apisBusiCorrectOrder);
        for (ApisBusiCorrectOrder dto : list) {
            if (!BusinessConstants.QIHU_NOTIFY_TYPE.SURRENDER_TYPE.contains(dto.getEndorseType())) continue;
            return "SSP_USER".equals(dto.getCreator());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushPolicySurrender(LitigationUwResultMsgDTO dto, ApisMsgMqlogs apisMsgMqlogs) {
        String flag = "0";
        try {
            String[] endSplits = dto.getEndorseDate().split(" ");
            SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            BigDecimal actualPremium = ObjectUtil.isNotEmpty((Object)dto.getActualRefPremium()) ? dto.getActualRefPremium().abs() : dto.getChgSumPremium().abs();
            QiHuData qiHuData = QiHuData.builder().requestId(UUID.randomUUID().toString().replace("-", "")).policyNo(dto.getPolicyNo()).refundDate(endSplits[0]).refundEffectDate(dto.getValidDate()).auditDate(dto.getAuditDate()).periodNum(this.getPeriodNum(dto.getPolicyNo())).refundPremium(actualPremium).build();
            log.warn("\u672c\u6b21\u63a8\u9001requestID\u4e3a:{}", (Object)qiHuData.getRequestId());
            String content = this.aesUtils.encrypt(JSON.toJSONString((Object)qiHuData), this.secretKey);
            log.warn("AES\u52a0\u5bc6\u540e\u6570\u636e\u4e3a\uff1a{}", (Object)content);
            QiHuRequest qiHuRequest = QiHuRequest.builder().data(content).appKey(this.appKey).serviceName("com.jdaz.360.policy.refundNotify").timestamp(QiHuNotifyUtil.getTimestamp()).build();
            log.warn("\u7b7e\u540d\u52a0\u5bc6\u503c\u4e3a\uff1a{}", (Object)(qiHuRequest.toString() + this.secretKey));
            String sign = SecureUtil.md5((String)(qiHuRequest.toString() + this.secretKey)).toUpperCase();
            qiHuRequest.setSign(sign);
            log.warn("MD5\u52a0\u5bc6\u540e\u7b7e\u660esign\u4e3a\uff1a{}", (Object)sign);
            this.pushAndSave(dto.getPolicyNo(), JSON.toJSONString((Object)qiHuRequest), apisMsgMqlogs, ApisAutoTaskConstantsEnum.QIHU_NOTIFY_CALLBACK.getValue());
        }
        catch (Exception e) {
            flag = "1";
            log.warn("360\u9700\u6c42\u63a8\u9001\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:{}", (Object)e.getMessage());
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }

    private Integer getPeriodNum(String policyNo) {
        int sum = 0;
        List list = this.apisBusiChannelInstallmentOrderService.getOrderByPolicyNo(policyNo);
        for (ApisBusiChannelInstallmentOrder dto : list) {
            if (!ObjectUtil.isNotEmpty((Object)dto.getOrderNo())) continue;
            ++sum;
        }
        return sum == 0 ? null : Integer.valueOf(sum);
    }

    public static String getTimestamp() {
        FastDateFormat fdf2 = FastDateFormat.getInstance((String)"yyyyMMddHHmmss");
        Date current = new Date();
        return fdf2.format(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushAndSave(String policyNo, String content, ApisMsgMqlogs apisMsgMqlogs, String taskValue) {
        String flag = "0";
        try {
            ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
            apisBusiTaskLog.setPushStep(Integer.valueOf(0));
            apisBusiTaskLog.setPushStatus("0");
            apisBusiTaskLog.setBusinessKey(policyNo);
            apisBusiTaskLog.setPushType(taskValue);
            apisBusiTaskLog.setPushContent(content);
            apisBusiTaskLog.setRelatedId(apisMsgMqlogs.getId());
            ApisChannelConfigs channelConfig = new ApisChannelConfigs();
            channelConfig.setConfigCode(taskValue + "_url");
            channelConfig = this.apisChannelConfigsService.getChannelConfig(channelConfig);
            if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue())) {
                apisBusiTaskLog.setPushTargetUrl(channelConfig.getConfigValue());
                apisBusiTaskLog.setCreator(channelConfig.getUserCode());
            }
            this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
            this.taskUtil.asyncNotice(apisBusiTaskLog);
        }
        catch (Exception e) {
            flag = "1";
            log.warn("360\u9700\u6c42\u63a8\u9001\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:{}", (Object)e.getMessage());
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }
}

