/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CoverageDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemTrafficDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.SalesDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.ApplicantDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.ClauseKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.InsQuotePriceRuleRequestDto;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.ItemDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.QuotePriceReqVo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.RationDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CalculateResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CalculateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredPremiumDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.quotePriceRule.QuotePriceRetVo;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwInsured;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwInsuredService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QuotePriceRulerUtil {
    private static final Logger log = LoggerFactory.getLogger(QuotePriceRulerUtil.class);
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiUwInsuredService apisBusiUwInsuredService;
    public static final String QUOTE_PRICE_RULER_SERVICE = "quotePriceRulerService";
    public static final String POLICY_TYPE_T = "T";
    public static final String POLICY_TYPE_E = "E";
    public static final String RESPONSE_SUCCESS = "1";
    public static final String INSURE_DEFINE_CODE = "9999999999";
    public static final String RULUER_PLAN_CODE = "QuotePriceRulerRationCode";

    public StanderResponse execute(StanderRequest request, String type) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice();
        if (ObjectUtil.isEmpty((Object)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice()) || ObjectUtil.isEmpty((Object)quotePriceDTO.getCoverage())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10017.getValue(), ChannelErrorCodeEnum.ERR_C10017.getKey());
        }
        List quotePriceReqVoList = this.requestDataCompletion(request, type);
        ArrayList<QuotePriceRetVo> quotePriceRetVoList = new ArrayList<QuotePriceRetVo>();
        for (QuotePriceReqVo quotePriceReqVo : quotePriceReqVoList) {
            QuotePriceRetVo quotePriceRetVo = (QuotePriceRetVo)this.httpRequestService.convertAndSend(QUOTE_PRICE_RULER_SERVICE, QUOTE_PRICE_RULER_SERVICE, (Object)quotePriceReqVo, QuotePriceRetVo.class);
            if (ObjectUtil.isNotEmpty((Object)quotePriceRetVo)) {
                if (!RESPONSE_SUCCESS.equals(quotePriceRetVo.getResponseCode())) {
                    this.validSecurityFlagException(quotePriceRetVo);
                    throw new ApisBusinessException(quotePriceRetVo.getErrorMsg(), quotePriceRetVo.getResponseCode());
                }
            } else {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
            }
            quotePriceRetVoList.add(quotePriceRetVo);
        }
        return this.responseDataCompletion(request, quotePriceRetVoList, type);
    }

    public void validSecurityFlagException(QuotePriceRetVo vo) throws ApisBusinessException {
        List itemList;
        if (ObjectUtil.isNotEmpty((Object)vo.getInsQuotePriceRuleRequestDto()) && ObjectUtil.isNotEmpty((Object)(itemList = vo.getInsQuotePriceRuleRequestDto().getItemList())) && itemList.size() > 0) {
            for (ItemDTO dto : itemList) {
                List rationList = dto.getRationList();
                if (!ObjectUtil.isNotEmpty((Object)rationList) || rationList.size() <= 0) continue;
                for (RationDTO rationDTO : rationList) {
                    List clauseList = rationDTO.getClauseKindList();
                    if (!ObjectUtil.isNotEmpty((Object)clauseList) || clauseList.size() <= 0) continue;
                    for (ClauseKindDTO clauseKindDTO : clauseList) {
                        if (!StringUtils.isNotEmpty((CharSequence)clauseKindDTO.getRsCheckMsg()) || !clauseKindDTO.getRsCheckMsg().contains("\u793e\u4fdd\u7684\u76f8\u5173\u914d\u7f6e")) continue;
                        throw new ApisBusinessException("\u662f\u5426\u6709\u793e\u4fdd\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10467.getKey());
                    }
                }
            }
        }
    }

    public StanderResponse responseDataCompletion(StanderRequest request, List<QuotePriceRetVo> quotePriceRetVoList, String type) {
        StanderResponse standerResponse = StanderResponse.builder().build();
        StanderHeader standerHeader = StanderHeader.builder().build();
        CalculateResponse calculateResponse = CalculateResponse.builder().build();
        ResponseHeadDTO responseHead = ResponseHeadDTO.builder().build();
        responseHead.setProviderSeqNo(UUID.randomUUID().toString().replaceAll("-", ""));
        responseHead.setStatus(1);
        BigDecimal sumPremium = new BigDecimal(0);
        String riskCode = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getMain().getRiskCode();
        CalculateResponseDTO calculateResponseDTO = CalculateResponseDTO.builder().build();
        RationDTO rationDto = null;
        if (RiskCodeEnum.getType((String)riskCode) == 1) {
            HashMap planDisCountMap = this.dataCompletionUtil.findPlanDiscountMap(request.getHeader().getUserCode(), request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getMain().getInputDate());
            ArrayList<InsuredPremiumDTO> insuredPremiumList = new ArrayList<InsuredPremiumDTO>();
            if (request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList().size() > 1) {
                for (int i = 0; i < quotePriceRetVoList.size(); ++i) {
                    InsuredIdvDTO insured = (InsuredIdvDTO)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList().get(i);
                    BigDecimal onePremium = BigDecimal.ZERO;
                    rationDto = (RationDTO)((ItemDTO)quotePriceRetVoList.get(i).getInsQuotePriceRuleRequestDto().getItemList().get(0)).getRationList().get(0);
                    if (planDisCountMap.containsKey(rationDto.getRationCode())) {
                        for (ClauseKindDTO clauseKindDto : rationDto.getClauseKindList()) {
                            clauseKindDto.setDisCount(Double.valueOf(((BigDecimal)planDisCountMap.get(rationDto.getRationCode())).doubleValue()));
                            clauseKindDto.setKindPremium(clauseKindDto.getRaKindPremium().multiply((BigDecimal)planDisCountMap.get(rationDto.getRationCode())).setScale(0, 4));
                            onePremium = onePremium.add(clauseKindDto.getKindPremium());
                        }
                    } else {
                        onePremium = this.calculate(request, quotePriceRetVoList.get(i), type);
                    }
                    InsuredPremiumDTO insuredPremiumDTO = InsuredPremiumDTO.builder().build();
                    insuredPremiumDTO.setSerialNo(insured.getInsuredIDCache());
                    insuredPremiumDTO.setInsuredName(insured.getInsuredName());
                    insuredPremiumDTO.setPremium(Double.valueOf(onePremium.setScale(2, 4).doubleValue()));
                    insuredPremiumDTO.setInsuredType(insured.getInsuredType());
                    insuredPremiumList.add(insuredPremiumDTO);
                    sumPremium = sumPremium.add(onePremium);
                }
            } else {
                List insuredIdvList = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList();
                rationDto = (RationDTO)((ItemDTO)quotePriceRetVoList.get(0).getInsQuotePriceRuleRequestDto().getItemList().get(0)).getRationList().get(0);
                if (planDisCountMap.containsKey(rationDto.getRationCode())) {
                    for (ClauseKindDTO clauseKindDto : rationDto.getClauseKindList()) {
                        clauseKindDto.setDisCount(Double.valueOf(((BigDecimal)planDisCountMap.get(rationDto.getRationCode())).doubleValue()));
                        clauseKindDto.setKindPremium(clauseKindDto.getRaKindPremium().multiply((BigDecimal)planDisCountMap.get(rationDto.getRationCode())).setScale(0, 4));
                        sumPremium = sumPremium.add(clauseKindDto.getKindPremium());
                        log.warn("\u8d23\u4efb\u6761\u6b3e\u4e3a\uff1a{}\uff0c\u6298\u6263\u7cfb\u6570\u4e3a\uff1a{}\uff0c\u8d23\u4efb\u4fdd\u8d39\u4e3a\uff1a{}\uff0cmap\u4e58\u6570\u96c6\u4e3a\uff1a{}", new Object[]{clauseKindDto.getClauseCode(), clauseKindDto.getDisCount(), clauseKindDto.getKindPremium(), planDisCountMap.get(rationDto.getRationCode())});
                    }
                } else {
                    sumPremium = this.calculate(request, quotePriceRetVoList.get(0), type);
                }
                for (InsuredIdvDTO insured : insuredIdvList) {
                    InsuredPremiumDTO insuredPremiumDTO = InsuredPremiumDTO.builder().build();
                    insuredPremiumDTO.setSerialNo(insured.getInsuredIDCache());
                    insuredPremiumDTO.setInsuredName(insured.getInsuredName());
                    insuredPremiumDTO.setPremium(Double.valueOf(sumPremium.setScale(2, 4).doubleValue()));
                    insuredPremiumDTO.setInsuredType(insured.getInsuredType());
                    insuredPremiumList.add(insuredPremiumDTO);
                }
            }
            calculateResponseDTO.setInsuredPremiumList(insuredPremiumList);
        } else if (RiskCodeEnum.getType((String)riskCode) == 3) {
            List clauseKindList = ((RationDTO)((ItemDTO)quotePriceRetVoList.get(0).getInsQuotePriceRuleRequestDto().getItemList().get(0)).getRationList().get(0)).getClauseKindList();
            for (ClauseKindDTO clauseKindDTO : clauseKindList) {
                clauseKindDTO.setKindPremium(clauseKindDTO.getRaKindPremium());
                sumPremium = sumPremium.add(clauseKindDTO.getRaKindPremium());
            }
        } else if (RiskCodeEnum.getType((String)riskCode) == 4) {
            List clauseKindList = ((RationDTO)((ItemDTO)quotePriceRetVoList.get(0).getInsQuotePriceRuleRequestDto().getItemList().get(0)).getRationList().get(0)).getClauseKindList();
            for (ClauseKindDTO clauseKindDTO : clauseKindList) {
                BigDecimal raKindPremium = clauseKindDTO.getKindAmount().multiply(clauseKindDTO.getKindRate()).divide(BigDecimal.valueOf(1000L)).setScale(2, 4);
                clauseKindDTO.setKindPremium(raKindPremium);
                sumPremium = sumPremium.add(raKindPremium);
            }
        } else if (RiskCodeEnum.getType((String)riskCode) == 7) {
            List retItemList = quotePriceRetVoList.get(0).getInsQuotePriceRuleRequestDto().getItemList();
            for (ItemDTO retItemDTO : retItemList) {
                List rationDTOList = retItemDTO.getRationList();
                for (RationDTO rationDTO : rationDTOList) {
                    int sumRationCount = rationDTO.getRationCount();
                    if (sumRationCount == 0) {
                        sumRationCount = 1;
                    }
                    BigDecimal tempSumPremium = new BigDecimal(0);
                    List clauseKindList = rationDTO.getClauseKindList();
                    for (ClauseKindDTO clauseKindDTO : clauseKindList) {
                        BigDecimal raKindPremium = clauseKindDTO.getRaKindPremium();
                        tempSumPremium = tempSumPremium.add(raKindPremium);
                    }
                    sumPremium = sumPremium.add(tempSumPremium.multiply(new BigDecimal(sumRationCount)));
                }
            }
        }
        calculateResponseDTO.setAgencyPolicyRef(request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo());
        calculateResponseDTO.setTotalPremium(Double.valueOf(sumPremium.setScale(2, 4).doubleValue()));
        calculateResponseDTO.setQuotePriceRetVoList(quotePriceRetVoList);
        calculateResponse.setResponseHead(responseHead);
        calculateResponse.setResponseBody(calculateResponseDTO);
        standerResponse.setHeader(standerHeader);
        standerResponse.setCalculateResponse(calculateResponse);
        return standerResponse;
    }

    private BigDecimal calculate(StanderRequest request, QuotePriceRetVo quotePriceRetVo, String type) {
        BigDecimal sumPremium = BigDecimal.valueOf(0L);
        List itemList = quotePriceRetVo.getInsQuotePriceRuleRequestDto().getItemList();
        for (ItemDTO item : itemList) {
            List rationList = item.getRationList();
            for (RationDTO ration : rationList) {
                List clauseKindList = ration.getClauseKindList();
                BigDecimal sumKindPremium = BigDecimal.valueOf(0L);
                for (ClauseKindDTO clauseKind : clauseKindList) {
                    if (ObjectUtil.isNotEmpty((Object)clauseKind.getRaKindPremium())) {
                        clauseKind.setKindPremium(clauseKind.getRaKindPremium());
                        sumKindPremium = sumKindPremium.add(clauseKind.getRaKindPremium());
                        continue;
                    }
                    BigDecimal premium = clauseKind.getKindAmount().multiply(clauseKind.getKindRate()).divide(BigDecimal.valueOf(1000L));
                    clauseKind.setKindPremium(premium.setScale(2, 4));
                    sumKindPremium = sumKindPremium.add(premium);
                }
                sumPremium = sumPremium.add(sumKindPremium);
            }
        }
        return sumPremium;
    }

    public List<QuotePriceReqVo> requestDataCompletion(StanderRequest request, String type) throws ApisBusinessException {
        String riskCode = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getMain().getRiskCode();
        ArrayList<QuotePriceReqVo> quotePriceReqVoList = new ArrayList<QuotePriceReqVo>();
        if (RiskCodeEnum.getType((String)riskCode) == 1) {
            List insuredIdvList = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList();
            for (int i = 0; i < insuredIdvList.size(); ++i) {
                InsQuotePriceRuleRequestDto insQuotePriceRuleRequestDto = this.packageInsQuotePriceRuleRequestDto(request, type);
                insQuotePriceRuleRequestDto.setRiskInfo(this.packageRiskInfo(request));
                insQuotePriceRuleRequestDto.setApplicantInfo(this.packageApplicantInfo(request));
                if (RiskCodeEnum.getType((String)riskCode) == 1) {
                    insQuotePriceRuleRequestDto.setInsuredList(this.packageInsuredList(request, i));
                }
                insQuotePriceRuleRequestDto.setItemList(this.packageItemList(request, type, i));
                quotePriceReqVoList.add(QuotePriceReqVo.builder().insQuotePriceRuleRequestDto(insQuotePriceRuleRequestDto).build());
            }
        } else if (RiskCodeEnum.getType((String)riskCode) == 4) {
            InsQuotePriceRuleRequestDto insQuotePriceRuleRequestDto = this.packageInsQuotePriceRuleRequestDto(request, type);
            insQuotePriceRuleRequestDto.setRiskInfo(this.packageRiskInfo(request));
            insQuotePriceRuleRequestDto.setApplicantInfo(this.packageApplicantInfo(request));
            insQuotePriceRuleRequestDto.setItemList(this.packageItemList(request, type, 0));
            insQuotePriceRuleRequestDto.setInsuredList(this.packageInsuredListFreight(request));
            quotePriceReqVoList.add(QuotePriceReqVo.builder().insQuotePriceRuleRequestDto(insQuotePriceRuleRequestDto).build());
        } else {
            InsQuotePriceRuleRequestDto insQuotePriceRuleRequestDto = this.packageInsQuotePriceRuleRequestDto(request, type);
            insQuotePriceRuleRequestDto.setRiskInfo(this.packageRiskInfo(request));
            insQuotePriceRuleRequestDto.setApplicantInfo(this.packageApplicantInfo(request));
            insQuotePriceRuleRequestDto.setItemList(this.packageItemList(request, type, 0));
            quotePriceReqVoList.add(QuotePriceReqVo.builder().insQuotePriceRuleRequestDto(insQuotePriceRuleRequestDto).build());
        }
        return quotePriceReqVoList;
    }

    private List<ItemDTO> packageItemList(StanderRequest request, String type, int index) {
        ArrayList<ItemDTO> list = new ArrayList<ItemDTO>();
        int size = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().size();
        ItemMainDTO it = null;
        if (size > 1) {
            for (ItemMainDTO eachIt : request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList()) {
                if (eachIt.getItemNo() != ((InsuredIdvDTO)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList().get(index)).getItemNo()) continue;
                it = eachIt;
                break;
            }
        } else {
            it = (ItemMainDTO)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0);
        }
        ItemDTO item = ItemDTO.builder().build();
        item.setItemSeq(it.getItemNo());
        item.setItemCode(INSURE_DEFINE_CODE);
        item.setItemName(INSURE_DEFINE_CODE);
        item.setRationList(this.packageRationList(it, request, type));
        list.add(item);
        return list;
    }

    private List<RationDTO> packageRationList(ItemMainDTO item, StanderRequest request, String type) {
        ArrayList<RationDTO> list = new ArrayList<RationDTO>();
        CoverageDTO coverageDTO = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage();
        if (ObjectUtil.isNotEmpty((Object)coverageDTO.getItemTrafficList())) {
            for (int i = 0; i < coverageDTO.getItemTrafficList().size(); ++i) {
                ItemTrafficDTO itemTrafficDTO = (ItemTrafficDTO)coverageDTO.getItemTrafficList().get(i);
                RationDTO ration = RationDTO.builder().build();
                ration.setRationSeq(itemTrafficDTO.getItemNo());
                ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
                channelConfigsCondition.setConfigCode(RULUER_PLAN_CODE);
                channelConfigsCondition.setRationCode(item.getPlanCode());
                ApisChannelConfigs accs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
                if (ObjectUtil.isNotEmpty((Object)accs)) {
                    ration.setRationCode(item.getPlanCode());
                } else {
                    ration.setRationCode(item.getGoodsCode());
                }
                ration.setRationName(item.getPlanName());
                ration.setRationCount(itemTrafficDTO.getRationCount());
                if (ObjectUtil.isNotEmpty((Object)itemTrafficDTO.getSeatNo())) {
                    ration.setNumberOfSeat(itemTrafficDTO.getSeatNo().toString());
                }
                if (ObjectUtil.isNotEmpty((Object)itemTrafficDTO.getVehicleType())) {
                    ration.setCarType(itemTrafficDTO.getVehicleType());
                }
                this.dataCompletionXyzRation(ration, request, type);
                ration.setClauseKindList(this.packageClauseKindList(request, item));
                list.add(ration);
            }
        } else {
            RationDTO ration = RationDTO.builder().build();
            ration.setRationSeq(item.getItemNo());
            ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
            channelConfigsCondition.setConfigCode(RULUER_PLAN_CODE);
            channelConfigsCondition.setRationCode(item.getPlanCode());
            ApisChannelConfigs accs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
            if (ObjectUtil.isNotEmpty((Object)accs)) {
                ration.setRationCode(item.getPlanCode());
            } else {
                ration.setRationCode(item.getGoodsCode());
            }
            ration.setRationName(item.getPlanName());
            ration.setRationCount(item.getRationCount());
            this.dataCompletionXyzRation(ration, request, type);
            ration.setClauseKindList(this.packageClauseKindList(request, item));
            list.add(ration);
        }
        return list;
    }

    private void dataCompletionXyzRation(RationDTO ration, StanderRequest request, String type) {
        String paymentType = null;
        if (POLICY_TYPE_T.equals(type)) {
            paymentType = "01";
        }
        if (POLICY_TYPE_E.equals(type)) {
            paymentType = "03";
        }
        if (StringUtils.isNotEmpty((CharSequence)paymentType)) {
            ration.setPaymentType(paymentType);
        }
    }

    private List<ClauseKindDTO> packageClauseKindList(StanderRequest request, ItemMainDTO item) {
        ArrayList<ClauseKindDTO> list = new ArrayList<ClauseKindDTO>();
        BigDecimal size = new BigDecimal(item.getInsuredCount());
        for (ItemKindDTO itemKindDTO : item.getItemKind()) {
            ClauseKindDTO clauseKind = ClauseKindDTO.builder().build();
            clauseKind.setItemKindSeq(itemKindDTO.getItemkindNo());
            clauseKind.setClauseCode(itemKindDTO.getClauseCode());
            clauseKind.setClauseName(itemKindDTO.getClauseName());
            clauseKind.setClauseType(itemKindDTO.getKindInd());
            clauseKind.setKindCode(itemKindDTO.getKindCode());
            clauseKind.setKindName(itemKindDTO.getKindName());
            clauseKind.setKindAmount(itemKindDTO.getSumInsured().divide(size));
            list.add(clauseKind);
        }
        return list;
    }

    private List<com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.InsuredDTO> packageInsuredList(StanderRequest request, int index) throws ApisBusinessException {
        ArrayList<com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.InsuredDTO> list = new ArrayList<com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.InsuredDTO>();
        InsuredIdvDTO insuredIdvDTO = (InsuredIdvDTO)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList().get(index);
        if (ObjectUtil.isEmpty((Object)insuredIdvDTO)) {
            log.warn("\u6784\u9020\u89c4\u5219\u5f15\u64ce\u53c2\u6570\u5931\u8d25\uff0c\u88ab\u4fdd\u4eba\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString((Object)request));
            return null;
        }
        Date startDate = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getMain().getStartDate();
        com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.InsuredDTO insured = com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.InsuredDTO.builder().build();
        insured.setInsuredCode(INSURE_DEFINE_CODE);
        insured.setInsuredName(insuredIdvDTO.getInsuredName());
        insured.setInsuredOccupation(insuredIdvDTO.getOccupationLevel());
        insured.setInsuredAge(Integer.valueOf(this.dataCompletionUtil.calculateAge(startDate, insuredIdvDTO.getBirthday())));
        insured.setIdentifyNumber(insuredIdvDTO.getIdentifyNumber());
        insured.setIsInsuranceFlag(this.transSecurityFlag(insuredIdvDTO.getSocialSecurityFlag()));
        insured.setInsuredSex(RESPONSE_SUCCESS.equals(insuredIdvDTO.getSex()) ? RESPONSE_SUCCESS : "0");
        if (StringUtils.isNotBlank((CharSequence)insuredIdvDTO.getManualUwId())) {
            ApisBusiUwInsured uwInsured = this.apisBusiUwInsuredService.getByUwId(insuredIdvDTO.getManualUwId());
            insured.setContainsExpensiveFlag("y".equals(uwInsured.getIncludeExpHosp()) ? "0" : RESPONSE_SUCCESS);
            insured.setDeductibleHospital(ObjectUtils.isEmpty((Object)uwInsured.getDeductibleHosp()) ? new BigDecimal(0) : uwInsured.getDeductibleHosp());
        }
        list.add(insured);
        return list;
    }

    private String transSecurityFlag(String flag) {
        if (StringUtils.isEmpty((CharSequence)flag)) {
            return "";
        }
        return RESPONSE_SUCCESS.equals(flag) ? "Y" : "N";
    }

    private List<com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.InsuredDTO> packageInsuredListFreight(StanderRequest request) throws ApisBusinessException {
        ArrayList<com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.InsuredDTO> list = new ArrayList<com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.InsuredDTO>();
        InsuredDTO insuredIdvDTO = (InsuredDTO)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getInsuredList().get(0);
        if (ObjectUtil.isEmpty((Object)insuredIdvDTO)) {
            log.warn("\u6784\u9020\u89c4\u5219\u5f15\u64ce\u53c2\u6570\u5931\u8d25\uff0c\u88ab\u4fdd\u4eba\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString((Object)request));
            return null;
        }
        com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.InsuredDTO insured = com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.InsuredDTO.builder().build();
        insured.setInsuredCode(INSURE_DEFINE_CODE);
        insured.setInsuredName(insuredIdvDTO.getInsuredName());
        insured.setInsuredOccupation(insuredIdvDTO.getOccupationLevel());
        insured.setInsuredAge(insuredIdvDTO.getAge());
        insured.setIdentifyNumber(insuredIdvDTO.getIdentifyNumber());
        insured.setIsInsuranceFlag(RESPONSE_SUCCESS.equals(insuredIdvDTO.getSocialSecurityFlag()) ? "Y" : "N");
        insured.setInsuredSex(RESPONSE_SUCCESS.equals(insuredIdvDTO.getSex()) ? RESPONSE_SUCCESS : "0");
        list.add(insured);
        return list;
    }

    private ApplicantDTO packageApplicantInfo(StanderRequest request) {
        ApplicantDTO applicantDTO = ApplicantDTO.builder().build();
        AppliClientDTO appliClient = (AppliClientDTO)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getAppliClient().get(0);
        applicantDTO.setAppliCode(INSURE_DEFINE_CODE);
        applicantDTO.setAppliName(appliClient.getInsuredName());
        applicantDTO.setCustomType(appliClient.getInsuredType());
        applicantDTO.setIdentifyNumber(appliClient.getIdentifyNumber());
        return applicantDTO;
    }

    private com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.RiskInfoDTO packageRiskInfo(StanderRequest request) {
        com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.RiskInfoDTO riskInfoDTO = com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.RiskInfoDTO.builder().build();
        HashMap<String, String> map = new HashMap<String, String>(16);
        CoverageDTO coverageDTO = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage();
        if (ObjectUtil.isNotEmpty((Object)coverageDTO.getInsuredIdvList()) && coverageDTO.getInsuredIdvList().size() > 0) {
            map.put("thyroidEvaluationGrade", ((InsuredIdvDTO)coverageDTO.getInsuredIdvList().get(0)).getTiRads());
        }
        String riskCode = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getMain().getRiskCode();
        if (ObjectUtil.isNotEmpty((Object)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getRiskInfo()) && RiskCodeEnum.getType((String)riskCode) == 4) {
            riskInfoDTO.setRegionType(request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getRiskInfo().getRegionType());
            riskInfoDTO.setContainer(request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getRiskInfo().getContainer());
        }
        if (RiskCodeEnum.getType((String)riskCode) == 3) {
            this.packageLiabRiskInfo(riskInfoDTO, request, map);
        }
        riskInfoDTO.setExtendMap(map);
        return riskInfoDTO;
    }

    private void packageLiabRiskInfo(com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.RiskInfoDTO riskInfoDTO, StanderRequest request, HashMap<String, String> map) {
        MainDTO mainDTO = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getMain();
        if (ObjectUtil.isNotEmpty((Object)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getRiskInfo())) {
            RiskInfoDTO liabRiskInfo = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getRiskInfo();
            riskInfoDTO.setActivityType(liabRiskInfo.getActivityType());
            riskInfoDTO.setInsuredCount(liabRiskInfo.getPeopleNumber());
            riskInfoDTO.setSiteArea(liabRiskInfo.getSiteArea());
            riskInfoDTO.setUnderwritingType(liabRiskInfo.getUnderwritingType());
            riskInfoDTO.setIndoorAndOutdoorFlag(liabRiskInfo.getIsIndoor());
            riskInfoDTO.setPoolDepth(liabRiskInfo.getWaterDepth());
            riskInfoDTO.setPoolArea(liabRiskInfo.getPoolArea());
            riskInfoDTO.setPoolType(liabRiskInfo.getSwimmingPoolType());
            riskInfoDTO.setVenuesType(liabRiskInfo.getVenueType());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(mainDTO.getEndDate());
            calendar.add(13, 1);
            Long coveredDays = DateUtil.betweenDay((Date)mainDTO.getStartDate(), (Date)calendar.getTime(), (boolean)false);
            riskInfoDTO.setCoveredDays(Integer.valueOf(coveredDays.intValue()));
            map.put("eachAndTotalLimit", liabRiskInfo.getEachAndTotalLimit().toString());
            map.put("eachLimit", liabRiskInfo.getEachLimit().toString());
            map.put("eachPeopleLimit", liabRiskInfo.getEachPeopleLimit().toString());
        }
    }

    private InsQuotePriceRuleRequestDto packageInsQuotePriceRuleRequestDto(StanderRequest request, String type) throws ApisBusinessException {
        if (POLICY_TYPE_T.equals(type) && ObjectUtil.isEmpty((Object)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice())) {
            throw new ApisBusinessException("", "");
        }
        QuotePriceDTO quotePrice = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice();
        MainDTO main = quotePrice.getMain();
        SalesDTO sales = quotePrice.getSales();
        InsQuotePriceRuleRequestDto insQuotePriceRuleRequestDto = InsQuotePriceRuleRequestDto.builder().build();
        insQuotePriceRuleRequestDto.setPolicyType(type);
        insQuotePriceRuleRequestDto.setInputDate(main.getInputDate());
        insQuotePriceRuleRequestDto.setStartDate(main.getStartDate());
        insQuotePriceRuleRequestDto.setEndDate(main.getEndDate());
        insQuotePriceRuleRequestDto.setMakeCom(main.getMakeCom());
        insQuotePriceRuleRequestDto.setComCode(main.getComCode());
        insQuotePriceRuleRequestDto.setClassCode(main.getClassCode());
        insQuotePriceRuleRequestDto.setClassName(INSURE_DEFINE_CODE);
        insQuotePriceRuleRequestDto.setProductCode(main.getRiskCode());
        insQuotePriceRuleRequestDto.setProductName(StringUtils.isNotBlank((CharSequence)main.getRiskName()) ? main.getRiskName() : INSURE_DEFINE_CODE);
        insQuotePriceRuleRequestDto.setChannelCode(sales.getAgentCode());
        insQuotePriceRuleRequestDto.setChannelName(sales.getAgentName());
        if (ObjectUtils.isEmpty((Object)quotePrice.getCoverage().getInsuredIdvList())) {
            insQuotePriceRuleRequestDto.setInsuredNumber(Integer.valueOf(0));
        } else {
            insQuotePriceRuleRequestDto.setInsuredNumber(Integer.valueOf(quotePrice.getCoverage().getInsuredIdvList().size()));
        }
        return insQuotePriceRuleRequestDto;
    }
}

