/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderPolicyDetailHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.IdNumberUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RedisTemplateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.ThyroidUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.BaseCodeConvertUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.ClaimListQueryServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.ClaimQueryInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.ClaimListInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.BeneficiaryDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CoverageDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.FLThyroidDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemCargoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemFamilyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemTrafficDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.JdUserVerify.JdUserVerifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.JdUserVerify.JdUserVerifyResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.UwInfoQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.BasicsPolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.UwInfoQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwResult;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwResultService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationClauseKindFactoryMapper;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.GeneralRegxs;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import io.netty.util.internal.StringUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import sinosoftgz.utils.data.DateUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class QuotePriceValidate {
    private static Logger log = LoggerFactory.getLogger(QuotePriceValidate.class);
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    private RedisTemplateUtil redisTemplateUtil;
    @Autowired
    StanderPolicyDetailHandler standerPolicyDetailHandler;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisPfpRationClauseKindFactoryMapper apisPfpRationClauseKindFactoryMapper;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    ThyroidUtil thyroidUtil;
    @Value(value="${system.backSignSwitch}")
    private String backSignSwitch;
    @Autowired
    private IdNumberUtil idNumberUtil;
    @Autowired
    BaseCodeConvertUtils baseCodeConvertUtils;
    @Autowired
    ApisBusiUwResultService apisBusiUwResultService;
    private static String[] PLAN_YEAR_ARRAY = new String[]{"4", "7", "8", "10", "11"};
    public static String[] ACCIDENT_HEALTH_RISKCODE = new String[]{"P090001", "P070005", "P070002", "P070006", "P070004", "P090002"};

    public void validateRquest(StanderRequest standerRequest) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        ArrayList<ApisPfpRationMain> apisPfpRationMainList = new ArrayList<ApisPfpRationMain>();
        for (ItemMainDTO item : quotePriceDTO.getCoverage().getItemList()) {
            ApisPfpRationMain apm = this.dataCompletionUtil.getApisPfpRationMainInfo(item.getGoodsCode(), "2");
            apisPfpRationMainList.add(apm);
        }
        this.validNull(standerRequest, (ApisPfpRationMain)apisPfpRationMainList.get(0));
        this.validFormat(standerRequest, (ApisPfpRationMain)apisPfpRationMainList.get(0));
        this.validProduct(standerRequest, apisPfpRationMainList);
        this.validPetData(standerRequest, (ApisPfpRationMain)apisPfpRationMainList.get(0));
        for (ApisPfpRationMain apm : apisPfpRationMainList) {
            this.validJdUser(standerRequest, apm);
            this.validJdAddr(standerRequest, apm);
        }
        this.validGive(standerRequest);
        this.validXyz(standerRequest, (ApisPfpRationMain)apisPfpRationMainList.get(0));
        this.vailFlData(standerRequest, (ApisPfpRationMain)apisPfpRationMainList.get(0));
        this.vailOptionData(standerRequest, (ApisPfpRationMain)apisPfpRationMainList.get(0));
        this.vailManUnderwrite(standerRequest);
    }

    private void vailManUnderwrite(StanderRequest standerRequest) throws ApisBusinessException {
        List insuredIdvList = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList();
        if (ObjectUtils.isEmpty((Object)insuredIdvList)) {
            return;
        }
        List itemList = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList();
        for (Object insuredIdvDTO : insuredIdvList) {
            if (!StringUtils.isNotBlank((CharSequence)insuredIdvDTO.getUwID()) || !StringUtils.isNotBlank((CharSequence)insuredIdvDTO.getManualUwId())) continue;
            throw new ApisBusinessException("\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6295\u4fdd\u95ee\u5377\u7b54\u6848UwId\u548c\u4eba\u6838ManualUwId", ChannelErrorCodeEnum.ERR_C10719.getKey());
        }
        List uwIds = insuredIdvList.stream().filter(insured -> StringUtils.isNotBlank((CharSequence)insured.getManualUwId())).map(InsuredIdvDTO::getManualUwId).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(uwIds)) {
            return;
        }
        for (InsuredIdvDTO insuredIdvDTO : insuredIdvList) {
            if (!StringUtils.isBlank((CharSequence)insuredIdvDTO.getCountry())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10737.getValue(), ChannelErrorCodeEnum.ERR_C10737.getKey());
        }
        List results = this.apisBusiUwResultService.listExtendByUwIds(uwIds);
        if (ObjectUtils.isEmpty((Object)results)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10719.getValue().replace("##", String.join((CharSequence)",", uwIds)), ChannelErrorCodeEnum.ERR_C10719.getKey());
        }
        List existUwIds = results.stream().map(ApisBusiUwResult::getUwId).collect(Collectors.toList());
        for (String uwId : uwIds) {
            if (existUwIds.contains(uwId)) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10719.getValue().replace("##", uwId), ChannelErrorCodeEnum.ERR_C10719.getKey());
        }
        for (ApisBusiUwResult result : results) {
            if (!"0".equals(result.getUwRsCode()) && !"3".equals(result.getUwRsCode())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10730.getValue().replace("##", result.getUwId()), ChannelErrorCodeEnum.ERR_C10730.getKey());
        }
        List mainResults = results.stream().filter(r -> "1".equals(r.getMain())).collect(Collectors.toList());
        for (ApisBusiUwResult mainResult : mainResults) {
            if (LocalDateTime.now().isAfter(mainResult.getUwExpireTime())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10729.getValue().replace("##", mainResult.getUwId()), ChannelErrorCodeEnum.ERR_C10729.getKey());
            }
            InsuredIdvDTO insuredIdvDTO = insuredIdvList.stream().filter(insured -> insured.getManualUwId().equals(mainResult.getUwId())).findFirst().orElse(null);
            if (ObjectUtils.isEmpty((Object)insuredIdvDTO)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10719.getValue().replace("##", mainResult.getUwId()), ChannelErrorCodeEnum.ERR_C10719.getKey());
            }
            if (!mainResult.getName().trim().equals(insuredIdvDTO.getInsuredName().trim())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10731.getValue().replace("##", mainResult.getUwId()).replace("@@", "\u88ab\u4fdd\u4eba\u540d\u79f0\uff1a" + insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10731.getKey());
            }
            if (!mainResult.getIdNo().equals(insuredIdvDTO.getIdentifyNumber())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10731.getValue().replace("##", mainResult.getUwId()).replace("@@", "\u8bc1\u4ef6\u53f7\u7801\uff1a" + insuredIdvDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10731.getKey());
            }
            ItemMainDTO currentItem = itemList.stream().filter(item -> item.getItemNo().equals(insuredIdvDTO.getItemNo())).findFirst().orElse(null);
            if (currentItem != null && mainResult.getRationCode().equals(currentItem.getGoodsCode())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10732.getValue().replace("##", mainResult.getUwId()), ChannelErrorCodeEnum.ERR_C10732.getKey());
        }
    }

    private void validXyz(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        if (!"JDACI".equals(apisPfpRationMain.getRationCode())) {
            return;
        }
        if (((ItemMainDTO)standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getRationCount() != 50) {
            throw new ApisBusinessException("\u6295\u4fdd\u4efd\u6570\u9700\u4e3a50", ChannelErrorCodeEnum.ERR_C10467.getKey());
        }
        List insuredIdvList = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList();
        for (InsuredIdvDTO insuredIdvDTO : insuredIdvList) {
            if (!StringUtils.isEmpty((CharSequence)insuredIdvDTO.getSex())) continue;
            throw new ApisBusinessException("\u65b0\u4e00\u7ad9\u8d60\u9669\u88ab\u4fdd\u4eba\u6027\u522b\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10467.getKey());
        }
    }

    private void vailOptionData(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)standerRequest.getQuotePriceServiceRequest().getRequestBody().getIsOptional()) || !standerRequest.getQuotePriceServiceRequest().getRequestBody().getIsOptional().booleanValue()) {
            return;
        }
        List insuredIdvList = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList();
        if (ObjectUtils.isEmpty((Object)insuredIdvList) || insuredIdvList.size() == 0) {
            return;
        }
        for (InsuredIdvDTO insuredIdvDTO : insuredIdvList) {
            if (!ObjectUtil.isNull((Object)insuredIdvDTO.getAge())) continue;
            if (ObjectUtil.isNull((Object)insuredIdvDTO.getBirthday())) {
                throw new ApisBusinessException("\u5e74\u9f84/\u51fa\u751f\u65e5\u671f\u4e0d\u540c\u540c\u65f6\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10467.getKey());
            }
            int age = insuredIdvDTO.getBirthday().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().until(LocalDate.now()).getYears();
            insuredIdvDTO.setAge(Integer.valueOf(age));
        }
    }

    private void validGive(StanderRequest standerRequest) throws ApisBusinessException {
        String giftType = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getGiftType();
        log.warn("=======\u8d60\u9669\u6821\u9a8c\u5f00\u59cb\uff0cgiftType = {}", (Object)giftType);
        if (StringUtils.isNotEmpty((CharSequence)giftType) && (giftType.equals("1") || giftType.equals("2"))) {
            String renewalFlag = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getRenewalFlag();
            if (StringUtils.isNotEmpty((CharSequence)renewalFlag) && renewalFlag.equals("1")) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10504.getValue(), ChannelErrorCodeEnum.ERR_C10504.getKey());
            }
            Date inputDate = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getInputDate();
            if (inputDate == null) {
                inputDate = new Date();
            }
            log.warn("\u8d60\u9669\u6295\u4fdd\u65f6\u95f4\u4e3a\uff1a{}", (Object)inputDate.getTime());
            Date giveStartTime = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getGiveStartTime();
            Date giveEndTime = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getGiveEndTime();
            if (inputDate.getTime() < giveStartTime.getTime() || inputDate.getTime() > giveEndTime.getTime()) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10505.getValue(), ChannelErrorCodeEnum.ERR_C10505.getKey());
            }
        }
    }

    private void vailFlData(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)standerRequest.getQuotePriceServiceRequest().getRequestBody().getIsThyriod()) || !standerRequest.getQuotePriceServiceRequest().getRequestBody().getIsThyriod().booleanValue()) {
            return;
        }
        FLThyroidDTO fLThyroidDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getFLThyroidDTO();
        if (ObjectUtil.isEmpty((Object)fLThyroidDTO) || StringUtil.isNullOrEmpty((String)fLThyroidDTO.getSerialNumber())) {
            return;
        }
        RiskInfoDTO riskInfoDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getRiskInfo();
        InsuredIdvDTO insuredIdvDTO = (InsuredIdvDTO)standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList().get(0);
        if (ObjectUtil.isNull((Object)riskInfoDTO.getReportTime()) || StringUtil.isNullOrEmpty((String)riskInfoDTO.getIsInsured()) || StringUtil.isNullOrEmpty((String)riskInfoDTO.getOrgnizationName())) {
            throw new ApisBusinessException("\u68c0\u6d4b\u673a\u6784/\u68c0\u6d4b\u65f6\u95f4/\u662f\u5426\u4e3a\u88ab\u4fdd\u9669\u4eba\u672c\u4eba\u7684\u62a5\u544a,\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10467.getKey());
        }
        if (StringUtil.isNullOrEmpty((String)insuredIdvDTO.getSocialSecurityFlag())) {
            throw new ApisBusinessException("\u662f\u5426\u6709\u793e\u4fdd\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10467.getKey());
        }
        if (!ObjectUtil.isNull((Object)riskInfoDTO.getReportTime())) {
            LocalDate now = LocalDate.now();
            if (riskInfoDTO.getReportTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().until(now, ChronoUnit.YEARS) >= 1L) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10488.getValue(), ChannelErrorCodeEnum.ERR_C10488.getKey());
            }
        }
        if (!"1".equals(riskInfoDTO.getIsInsured())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10489.getValue(), ChannelErrorCodeEnum.ERR_C10489.getKey());
        }
    }

    private void validJdAddr(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO;
        List insuredIdvDTOList;
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
        apisChannelConfigsCondition.setConfigCode("JD_ADDR_VERIFICATION");
        apisChannelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs) && ObjectUtil.isNotEmpty((Object)(insuredIdvDTOList = (quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice()).getCoverage().getInsuredIdvList())) && insuredIdvDTOList.size() > 0) {
            ApisPfpRationMain apisPfpRationMainP = this.dataCompletionUtil.getApisPfpRationMainInfo(apisPfpRationMain.getRationCode(), "1");
            for (InsuredIdvDTO insuredDTO : insuredIdvDTOList) {
                if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getResideAddressId())) {
                    UwInfoQueryRequest jdAddrVerifyRequest = UwInfoQueryRequest.builder().build();
                    jdAddrVerifyRequest.setSerialNumber(UUID.randomUUID().toString());
                    jdAddrVerifyRequest.setRequestType("UW02");
                    jdAddrVerifyRequest.setAgencyCode(standerRequest.getHeader().getChannelCode());
                    jdAddrVerifyRequest.setResideAddressId(insuredDTO.getResideAddressId());
                    jdAddrVerifyRequest.setProductName(apisPfpRationMainP.getRationName());
                    UwInfoQueryResponse uwInfoQueryResponse = this.coreInsureApi.uwInfoQuery(jdAddrVerifyRequest, "uwInfoQueryXmlService");
                    if (ObjectUtil.isEmpty((Object)uwInfoQueryResponse)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10480.getValue(), ChannelErrorCodeEnum.ERR_C10480.getKey());
                    }
                    if ("N".equals(uwInfoQueryResponse.getResult().getIsAddressRulePass())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10306.getValue(), ChannelErrorCodeEnum.ERR_C10306.getKey());
                    }
                    insuredDTO.setInsuredAddress(uwInfoQueryResponse.getResult().getResideFullAddress() + "," + insuredDTO.getInsuredAddress());
                    continue;
                }
                if (!"0".equals(quotePriceDTO.getMain().getRenewalFlag()) || "underwrit".equals(standerRequest.getHeader().getBussinessType()) || !StringUtils.isEmpty((CharSequence)quotePriceDTO.getMain().getRenewalPolicyNo())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10303.getValue(), ChannelErrorCodeEnum.ERR_C10303.getKey());
            }
        }
    }

    private void validJdUser(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO;
        List insuredIdvDTOList;
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setConfigCode("verifyJdUser");
        apisChannelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        MainDTO mainDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        boolean flag = "underwrit".equals(standerRequest.getHeader().getBussinessType());
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs) && ObjectUtil.isNotEmpty((Object)(insuredIdvDTOList = (quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice()).getCoverage().getInsuredIdvList())) && insuredIdvDTOList.size() > 0) {
            for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
                JdUserVerifyRequest jdUserVerifyRequest = JdUserVerifyRequest.builder().idNumber(insuredIdvDTO.getIdentifyNumber()).authDays("90").build();
                JdUserVerifyResponse jdUserVerifyResponse = this.coreInsureApi.verifyJdUser(jdUserVerifyRequest);
                if (ObjectUtil.isEmpty((Object)jdUserVerifyResponse)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10362.getValue(), ChannelErrorCodeEnum.ERR_C10362.getKey());
                }
                if ("N".equals(jdUserVerifyResponse.getResult().getStrategyResult())) {
                    if (flag) {
                        mainDTO.setJdUserVerifyFlag("0");
                        insuredIdvDTO.setPinFlag("N");
                        continue;
                    }
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10363.getValue(), ChannelErrorCodeEnum.ERR_C10363.getKey());
                }
                if (flag) {
                    mainDTO.setJdUserVerifyFlag("1");
                }
                insuredIdvDTO.setPinFlag("Y");
            }
        }
    }

    private void validPetUnderWritingArea(StanderRequest standerRequest) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        MainDTO mainDTO = quotePriceDTO.getMain();
        if (ObjectUtil.isNotEmpty((Object)mainDTO) && "1".equals(mainDTO.getUnderWritingArea()) && StrUtil.isBlank((CharSequence)mainDTO.getField10())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10644.getValue(), ChannelErrorCodeEnum.ERR_C10644.getKey());
        }
    }

    private void validPetData(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        if ("P010989".equals(apisPfpRationMain.getProductCode())) {
            this.validPetUnderWritingArea(standerRequest);
            this.validPetLiabilityData(standerRequest);
        } else if ("P010998".equals(apisPfpRationMain.getProductCode())) {
            this.validPetUnderWritingArea(standerRequest);
            this.validPetMedicalData(standerRequest);
        }
    }

    private void validPetMedicalData(StanderRequest request) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        CoverageDTO coverage = quotePriceDTO.getCoverage();
        if (ObjectUtil.isEmpty((Object)coverage) || ObjectUtil.isEmpty((Object)coverage.getItemList()) || ObjectUtil.isEmpty((Object)((ItemMainDTO)coverage.getItemList().get(0)).getItemFamily()) || ObjectUtil.isEmpty(((ItemMainDTO)coverage.getItemList().get(0)).getItemFamily().get(0))) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10448.getValue(), ChannelErrorCodeEnum.ERR_C10448.getKey());
        }
        ItemFamilyDTO itemFamily = (ItemFamilyDTO)((ItemMainDTO)coverage.getItemList().get(0)).getItemFamily().get(0);
        if (StringUtils.isBlank((CharSequence)itemFamily.getPetType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u5ba0\u7269\u7c7b\u578b\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)itemFamily.getPetBirth())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10256.getValue(), ChannelErrorCodeEnum.ERR_C10256.getKey());
        }
        if (StringUtils.isBlank((CharSequence)itemFamily.getPetSex())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10257.getValue(), ChannelErrorCodeEnum.ERR_C10257.getKey());
        }
        if (StringUtils.isBlank((CharSequence)itemFamily.getChipNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10258.getValue(), ChannelErrorCodeEnum.ERR_C10258.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getImgBatchUploadServiceRequest()) && ObjectUtil.isNotEmpty((Object)request.getImgBatchUploadServiceRequest().getRequestBody()) && ObjectUtil.isNotEmpty((Object)request.getImgBatchUploadServiceRequest().getRequestBody().getImgList())) {
            List petPicList = request.getImgBatchUploadServiceRequest().getRequestBody().getImgList();
            if (petPicList.size() > 3) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10213.getValue().replace("##", "3"), ChannelErrorCodeEnum.ERR_C10213.getKey());
            }
            for (ImgMetaDTO p : petPicList) {
                if ("URL-IMG".equals(p.getPetImgType())) continue;
                if (StringUtils.isBlank((CharSequence)p.getExtendName()) || !p.getExtendName().matches(GeneralRegxs.PictureFormat)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10216.getValue().replace("##", p.getFileName() + "." + p.getExtendName()), ChannelErrorCodeEnum.ERR_C10216.getKey());
                }
                if (ObjectUtil.isNotEmpty((Object)p.getFileContentWithBase64Encode())) {
                    float imageSize = this.imageSize(p.getFileContentWithBase64Encode());
                    if (!(imageSize > 3072.0f)) continue;
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10214.getValue().replaceFirst("##", p.getFileName() + "." + p.getExtendName()).replaceFirst("##", "3072"), ChannelErrorCodeEnum.ERR_C10214.getKey());
                }
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u56fe\u7247\u5185\u5bb9\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        }
    }

    public float imageSize(String imageBase64Str) {
        Integer equalIndex = imageBase64Str.indexOf("=");
        if (imageBase64Str.indexOf("=") > 0) {
            imageBase64Str = imageBase64Str.substring(0, equalIndex);
        }
        Integer strLength = imageBase64Str.length();
        Integer size = strLength - strLength / 8 * 2;
        BigDecimal fileSize = new BigDecimal(size);
        BigDecimal kilobyte = new BigDecimal(1024);
        return fileSize.divide(kilobyte, 1, 1).floatValue();
    }

    private void validPetLiabilityData(StanderRequest request) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        CoverageDTO coverage = quotePriceDTO.getCoverage();
        if (ObjectUtil.isEmpty((Object)coverage) || ObjectUtil.isEmpty((Object)coverage.getItemList()) || ObjectUtil.isEmpty((Object)((ItemMainDTO)coverage.getItemList().get(0)).getItemFamily())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10212.getValue(), ChannelErrorCodeEnum.ERR_C10212.getKey());
        }
        ItemFamilyDTO itemFamily = (ItemFamilyDTO)((ItemMainDTO)coverage.getItemList().get(0)).getItemFamily().get(0);
        if (StringUtils.isBlank((CharSequence)itemFamily.getPetType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u5ba0\u7269\u7c7b\u578b\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getImgBatchUploadServiceRequest()) && ObjectUtil.isNotEmpty((Object)request.getImgBatchUploadServiceRequest().getRequestBody()) && ObjectUtil.isNotEmpty((Object)request.getImgBatchUploadServiceRequest().getRequestBody().getImgList())) {
            List petPicList = request.getImgBatchUploadServiceRequest().getRequestBody().getImgList();
            for (ImgMetaDTO p : petPicList) {
                if (!StringUtils.isBlank((CharSequence)p.getExtendName()) && p.getExtendName().matches(GeneralRegxs.PictureFormat)) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10216.getValue().replace("##", p.getFileName() + "." + p.getExtendName()), ChannelErrorCodeEnum.ERR_C10216.getKey());
            }
        } else {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10212.getValue(), ChannelErrorCodeEnum.ERR_C10212.getKey());
        }
    }

    public void validNull(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        StanderHeader standerHeader = standerRequest.getHeader();
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredList = quotePriceDTO.getInsuredList();
        List insuredIdvDTOList = quotePriceDTO.getCoverage().getInsuredIdvList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        CoverageDTO coverageDTO = quotePriceDTO.getCoverage();
        Boolean isMerchantInsureRationCodes = false;
        for (AppliClientDTO appliClientDTO : appliClientList) {
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInsuredType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10384.getValue(), ChannelErrorCodeEnum.ERR_C10384.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInsuredName())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10387.getValue(), ChannelErrorCodeEnum.ERR_C10387.getKey());
            }
            if (Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode())) {
                if ("1".equals(appliClientDTO.getInsuredType())) {
                    if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyType())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10385.getValue(), ChannelErrorCodeEnum.ERR_C10385.getKey());
                    }
                    if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyNumber())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10386.getValue(), ChannelErrorCodeEnum.ERR_C10386.getKey());
                    }
                }
            } else {
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10082.getValue(), ChannelErrorCodeEnum.ERR_C10082.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10083.getValue(), ChannelErrorCodeEnum.ERR_C10083.getKey());
                }
            }
            if (Arrays.asList(BusinessConstants.HOME_PROPERTY_RISKCODE).contains(mainDTO.getRiskCode()) && "1".equals(appliClientDTO.getInsuredType()) && ObjectUtil.isEmpty((Object)appliClientDTO.getBirthday())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10079.getValue(), ChannelErrorCodeEnum.ERR_C10079.getKey());
            }
            if ("1".equals(appliClientDTO.getReqElecFaPiao()) && StringUtils.isEmpty((CharSequence)appliClientDTO.getEmail()) && StringUtils.isEmpty((CharSequence)appliClientDTO.getMobile())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10130.getValue(), ChannelErrorCodeEnum.ERR_C10130.getKey());
            }
            if (!Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode()) && StringUtils.isNotEmpty((CharSequence)appliClientDTO.getReqFaPiao()) && "1".equals(appliClientDTO.getReqFaPiao())) {
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getMailType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10070.getValue(), ChannelErrorCodeEnum.ERR_C10070.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getPhAddress())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10072.getValue(), ChannelErrorCodeEnum.ERR_C10072.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInvoiceTitle())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10071.getValue(), ChannelErrorCodeEnum.ERR_C10071.getKey());
                }
            }
            ApisChannelConfigs channelConfigs = new ApisChannelConfigs();
            channelConfigs.setUserCode(standerHeader.getUserCode());
            channelConfigs.setConfigCode("PHONE_NOT_NULL");
            channelConfigs.setRationCode(apisPfpRationMain.getRationCode());
            ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(channelConfigs);
            if (!ObjectUtil.isNotEmpty((Object)apisChannelConfigs) || !StringUtils.isEmpty((CharSequence)appliClientDTO.getMobile())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10129.getValue(), ChannelErrorCodeEnum.ERR_C10129.getKey());
        }
        ApisChannelConfigs configsCondition = new ApisChannelConfigs();
        configsCondition.setUserCode(standerHeader.getUserCode());
        configsCondition.setRationCode(apisPfpRationMain.getRationCode());
        configsCondition.setConfigCode("endcase_plan_code");
        ApisChannelConfigs endcaseConfigs = this.apisChannelConfigsService.getChannelConfig(configsCondition);
        if ("07".equals(apisPfpRationMain.getClassCode()) || "09".equals(apisPfpRationMain.getClassCode())) {
            for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
                if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getInsuredType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10077.getValue(), ChannelErrorCodeEnum.ERR_C10077.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getInsuredName())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10074.getValue(), ChannelErrorCodeEnum.ERR_C10074.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getIdentifyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10075.getValue(), ChannelErrorCodeEnum.ERR_C10075.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10076.getValue(), ChannelErrorCodeEnum.ERR_C10076.getKey());
                }
                if ("1".equals(insuredIdvDTO.getInsuredType()) && ObjectUtil.isEmpty((Object)insuredIdvDTO.getBirthday())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10080.getValue(), ChannelErrorCodeEnum.ERR_C10080.getKey());
                }
                if (ObjectUtil.isNotEmpty((Object)endcaseConfigs)) {
                    if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getLinkerName())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10091.getValue(), ChannelErrorCodeEnum.ERR_C10091.getKey());
                    }
                    if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getLinkerPhone())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10092.getValue(), ChannelErrorCodeEnum.ERR_C10092.getKey());
                    }
                }
                if (!"LXSBCYLBX".equals(apisPfpRationMain.getRationCode())) continue;
                if (ObjectUtil.isEmpty((Object)insuredIdvDTO.getBasicsPolicy())) {
                    throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N18001.getValue().replace("##", insuredIdvDTO.getInsuredName()), ErrorNullValueCodeEnum.ERR_N18001.getKey());
                }
                if (ObjectUtil.isEmpty((Object)insuredIdvDTO.getBasicsPolicy().getBasicsPolicyStartDate())) {
                    throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N18004.getValue(), ErrorNullValueCodeEnum.ERR_N18004.getKey());
                }
                if (!ObjectUtil.isEmpty((Object)insuredIdvDTO.getBasicsPolicy().getBasicsPolicyEndDate())) continue;
                throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N18005.getValue(), ErrorNullValueCodeEnum.ERR_N18005.getKey());
            }
        } else {
            for (InsuredDTO insuredDTO : insuredList) {
                if (StringUtils.isEmpty((CharSequence)insuredDTO.getInsuredType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10077.getValue(), ChannelErrorCodeEnum.ERR_C10077.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredDTO.getInsuredName())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10074.getValue(), ChannelErrorCodeEnum.ERR_C10074.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredDTO.getIdentifyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10075.getValue(), ChannelErrorCodeEnum.ERR_C10075.getKey());
                }
                if (!StringUtils.isEmpty((CharSequence)insuredDTO.getIdentifyNumber())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10076.getValue(), ChannelErrorCodeEnum.ERR_C10076.getKey());
            }
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getOrderNo())) {
            throw new ApisBusinessException("\u7b2c\u4e09\u65b9\u6e20\u9053\u516c\u53f8\u4fdd\u5355\u53f7\u7801\u6216\u8005\u7b2c\u4e09\u65b9\u6e20\u9053\u516c\u53f8\u8ba2\u5355\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getStartDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10066.getValue(), ChannelErrorCodeEnum.ERR_C10066.getKey());
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getEndDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10066.getValue(), ChannelErrorCodeEnum.ERR_C10066.getKey());
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getInputDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10391.getValue(), ChannelErrorCodeEnum.ERR_C10391.getKey());
        }
        boolean autoRenewalFlag = true;
        ApisPfpRationMain pfpRationMain = this.dataCompletionUtil.getApisPfpRationMainInfo(apisPfpRationMain.getRationCode(), "1");
        if (ObjectUtil.isNotEmpty((Object)pfpRationMain) && "N".equals(pfpRationMain.getIsAutoRenew()) && ObjectUtil.isNotEmpty((Object)quotePriceDTO.getRenewal()) && StringUtils.isNotEmpty((CharSequence)quotePriceDTO.getRenewal().getAccountName())) {
            autoRenewalFlag = false;
        }
        if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPayPlanList()) && quotePriceDTO.getPayPlanList().size() > 1 && ObjectUtil.isNotEmpty((Object)quotePriceDTO.getRenewal()) && StringUtils.isNotEmpty((CharSequence)quotePriceDTO.getRenewal().getAccountName())) {
            autoRenewalFlag = false;
        }
        if (!autoRenewalFlag) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10320.getValue(), ChannelErrorCodeEnum.ERR_C10320.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getRenewal()) && StringUtils.isNotEmpty((CharSequence)quotePriceDTO.getRenewal().getAccountName())) {
            ApisChannelCode channelCode = new ApisChannelCode();
            channelCode.setDeleted(Integer.valueOf(0));
            channelCode.setCode("auto_renewal_bank");
            QueryWrapper queryWrapper = new QueryWrapper((Object)channelCode);
            List configsList = this.apisChannelCodeService.list((Wrapper)queryWrapper);
            boolean flag = false;
            for (ApisChannelCode temp : configsList) {
                if (!temp.getChannelValue().equals(quotePriceDTO.getRenewal().getBankName())) continue;
                quotePriceDTO.getRenewal().setBankType(temp.getValue());
                flag = true;
                break;
            }
            if (!flag) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10190.getValue(), ChannelErrorCodeEnum.ERR_C10190.getKey());
            }
        }
        if ("1".equals(mainDTO.getRenewalFlag())) {
            if (StringUtils.isEmpty((CharSequence)mainDTO.getRenewalPolicyNo())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10242.getValue(), ChannelErrorCodeEnum.ERR_C10242.getKey());
            }
            this.verifyIsHasClaim(standerRequest, apisPfpRationMain);
            this.dataCompletionUtil.policyVerify(standerRequest, quotePriceDTO.getPolicyDTO(), "1002");
            if (!"07".equals(apisPfpRationMain.getClassCode()) && !"09".equals(apisPfpRationMain.getClassCode())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10458.getValue(), ChannelErrorCodeEnum.ERR_C10458.getKey());
            }
            if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getRenewal()) && !ObjectUtil.isEmpty((Object)quotePriceDTO.getRenewal().getAutoTransRenewFlag()) && "1".equals(quotePriceDTO.getRenewal().getAutoTransRenewFlag())) {
                if (ObjectUtil.isEmpty((Object)quotePriceDTO.getRenewal().getAccount()) || ObjectUtil.isEmpty((Object)quotePriceDTO.getRenewal().getBankName())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10455.getValue(), ChannelErrorCodeEnum.ERR_C10455.getKey());
                }
                log.warn("1002\u7eed\u4fdd\u4f20\u5165\u7684\u94f6\u884c\u8d26\u53f7\uff1a{}", (Object)quotePriceDTO.getRenewal().getAccount());
                log.warn("1002\u7eed\u4fdd\u4f20\u5165\u7684\u94f6\u884c\u540d\u79f0\uff1a{}", (Object)quotePriceDTO.getRenewal().getBankName());
                if (ObjectUtil.isEmpty((Object)quotePriceDTO.getRenewal().getAccount())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10499.getValue(), ChannelErrorCodeEnum.ERR_C10499.getKey());
                }
                if (ObjectUtil.isEmpty((Object)quotePriceDTO.getRenewal().getBankName())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10500.getValue(), ChannelErrorCodeEnum.ERR_C10500.getKey());
                }
                quotePriceDTO.getRenewal().setAccountName(((AppliClientDTO)quotePriceDTO.getAppliClient().get(0)).getInsuredName());
            }
        } else if ("0".equals(mainDTO.getRenewalFlag()) && StringUtils.isNotEmpty((CharSequence)mainDTO.getRenewalPolicyNo())) {
            this.verifyIsHasClaim(standerRequest, apisPfpRationMain);
        }
        if (ObjectUtil.isNotEmpty((Object)endcaseConfigs)) {
            if (StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getOriginAirport())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10093.getValue(), ChannelErrorCodeEnum.ERR_C10093.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getDestAirport())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10094.getValue(), ChannelErrorCodeEnum.ERR_C10094.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getFlightDate())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10095.getValue(), ChannelErrorCodeEnum.ERR_C10095.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getReturnFlightDate())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10096.getValue(), ChannelErrorCodeEnum.ERR_C10096.getKey());
            }
            try {
                if (DateUtils.parseToDate((String)quotePriceDTO.getRiskInfo().getFlightDate(), (String)"yyyy-MM-dd HH:mm:ss").before(mainDTO.getStartDate())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10097.getValue(), ChannelErrorCodeEnum.ERR_C10097.getKey());
                }
            }
            catch (ParseException e) {
                log.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            }
        }
        if ((RiskCodeEnum.getType((String)mainDTO.getRiskCode()) == 3 || RiskCodeEnum.getType((String)mainDTO.getRiskCode()) == 8) && ObjectUtil.isNotEmpty((Object)coverageDTO) && ObjectUtil.isNotEmpty((Object)coverageDTO.getItemList()) && ObjectUtil.isNotEmpty(coverageDTO.getItemList().get(0)) && ObjectUtil.isNotEmpty((Object)((ItemMainDTO)coverageDTO.getItemList().get(0)).getItemFamily())) {
            List itemFamilyDTOList = ((ItemMainDTO)coverageDTO.getItemList().get(0)).getItemFamily();
            String merchantInsureRationCodes = this.apisChannelConfigsService.getConfigValue("MerchantInsureRationCodes");
            if (ObjectUtil.isNotEmpty((Object)merchantInsureRationCodes) && merchantInsureRationCodes.contains(((ItemMainDTO)coverageDTO.getItemList().get(0)).getPlanCode()) && ObjectUtil.isNotEmpty((Object)itemFamilyDTOList)) {
                isMerchantInsureRationCodes = true;
                ItemFamilyDTO itemFamily = (ItemFamilyDTO)itemFamilyDTOList.get(0);
                if (StringUtils.isEmpty((CharSequence)itemFamily.getItemAddress())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "ItemAddress"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)itemFamily.getItemAddressProvince())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "ItemAddressProvince"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)itemFamily.getItemAddressCity())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "ItemAddressCity"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                String province = this.baseCodeConvertUtils.convertLocationCode("province", itemFamily.getItemAddressProvince(), null, null);
                if (ObjectUtil.isEmpty((Object)province)) {
                    throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10283.getValue(), ChannelErrorCodeEnum.ERR_C10283.getKey());
                }
                itemFamily.setItemAddressProvince(province);
                String itemAddressCity = this.baseCodeConvertUtils.convertLocationCode("city", itemFamily.getItemAddressProvince(), itemFamily.getItemAddressCity(), null);
                if (ObjectUtil.isEmpty((Object)itemAddressCity)) {
                    throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10283.getValue(), ChannelErrorCodeEnum.ERR_C10283.getKey());
                }
                itemFamily.setItemAddressCity(itemAddressCity);
                String itemAddressRegionZhs = "";
                if (ObjectUtil.isNotEmpty((Object)itemFamily.getItemAddressRegion())) {
                    String itemAddressRegion = this.baseCodeConvertUtils.convertLocationCode("subCity", itemFamily.getItemAddressProvince(), itemFamily.getItemAddressCity(), itemFamily.getItemAddressRegion());
                    if (ObjectUtil.isEmpty((Object)itemAddressRegion)) {
                        throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10283.getValue(), ChannelErrorCodeEnum.ERR_C10283.getKey());
                    }
                    itemFamily.setItemAddressRegion(itemAddressRegion);
                    itemAddressRegionZhs = this.apisChannelCodeService.getValueDescByProvinceCode("subCity", itemAddressRegion, itemAddressCity.substring(0, 4));
                    if (ObjectUtil.isEmpty((Object)itemAddressRegionZhs)) {
                        itemAddressRegionZhs = "";
                    }
                } else {
                    itemFamily.setItemAddressRegion("990000");
                }
                if (RiskCodeEnum.getType((String)mainDTO.getRiskCode()) == 3) {
                    String address = this.apisChannelCodeService.getValueDesc(null, "province", province) + this.apisChannelCodeService.getValueDescByProvinceCode("city", itemAddressCity, province.substring(0, 2)) + itemAddressRegionZhs + itemFamily.getItemAddress();
                    itemFamily.setItemAddress(address);
                }
                mainDTO.setUnderWritingArea("0");
                if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getRiskInfo())) {
                    if (RiskCodeEnum.getType((String)mainDTO.getRiskCode()) == 8) {
                        quotePriceDTO.getRiskInfo().setIndustryType1("F521");
                        quotePriceDTO.getRiskInfo().setIndustryType4("5213");
                    }
                    if (RiskCodeEnum.getType((String)mainDTO.getRiskCode()) == 3) {
                        quotePriceDTO.getRiskInfo().setPolicyBasis("1");
                        quotePriceDTO.getRiskInfo().setManageNature("B14");
                        itemFamily.setInsuredSerialNo(((InsuredDTO)quotePriceDTO.getInsuredList().get(0)).getSerialNo());
                    }
                }
            }
        }
        if (RiskCodeEnum.getType((String)mainDTO.getRiskCode()) == 3 && ObjectUtil.isNotEmpty((Object)quotePriceDTO.getRiskInfo()) && !isMerchantInsureRationCodes.booleanValue()) {
            if (StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getUnderwritingType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "UnderwritingType"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getIsIndoor())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "IsIndoor"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if ("01".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) && StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getVenueType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "IsIndoor"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (("01".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) || "02".equals(quotePriceDTO.getRiskInfo().getUnderwritingType())) && StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getPeopleNumber())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "PeopleNumber"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (("01".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) || "02".equals(quotePriceDTO.getRiskInfo().getUnderwritingType())) && ObjectUtil.isEmpty((Object)quotePriceDTO.getRiskInfo().getSiteArea())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "SiteArea"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if ("02".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) && StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getActivityType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "PeopleNumber"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if ("03".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) && StringUtils.isEmpty((CharSequence)quotePriceDTO.getRiskInfo().getSwimmingPoolType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "SwimmingPoolType"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if ("03".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) && ObjectUtil.isEmpty((Object)quotePriceDTO.getRiskInfo().getPoolArea())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "PoolArea"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if ("03".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) && ObjectUtil.isEmpty((Object)quotePriceDTO.getRiskInfo().getWaterDepth())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "WaterDepth"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        }
        if (ObjectUtils.isNotEmpty((Object)quotePriceDTO.getCoverage()) && ObjectUtils.isNotEmpty((Object)quotePriceDTO.getCoverage().getItemList()) && ObjectUtils.isNotEmpty((Object)((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).getItemCargo())) {
            ItemCargoDTO itemCargoDTO = (ItemCargoDTO)((ItemMainDTO)standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getItemCargo().get(0);
            if (StringUtils.isBlank((CharSequence)itemCargoDTO.getItemDetailCode())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "itemDetailCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (itemCargoDTO.getStartDate() == null) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u8d77\u8fd0\u65e5\u671f"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isBlank((CharSequence)itemCargoDTO.getConveyanceType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "conveyanceType"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isBlank((CharSequence)itemCargoDTO.getStartSiteCountryCode())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "startSiteCountryCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isBlank((CharSequence)itemCargoDTO.getTargetSiteCountryCode())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "targetSiteCountryCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isBlank((CharSequence)itemCargoDTO.getQuantity())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "quantity"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (itemCargoDTO.getCargoValue() == null) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "cargoValue"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        }
        if (ObjectUtils.isNotEmpty((Object)mainDTO.getPayInfo())) {
            if (StringUtils.isBlank((CharSequence)mainDTO.getPayInfo().getTransactionId())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "transactionId"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (ObjectUtil.isEmpty((Object)mainDTO.getPayInfo().getTotalFee())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "totalFee"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        }
        this.validateDrivingAccidentRequest(quotePriceDTO, apisPfpRationMain);
    }

    private void validateDrivingAccidentRequest(QuotePriceDTO quotePriceDTO, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        if ("P070008".equals(apisPfpRationMain.getProductCode())) {
            if (ObjectUtil.isEmpty((Object)quotePriceDTO.getCoverage().getItemTrafficList())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "ItemTrafficList"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            for (ItemTrafficDTO trafficDTO : quotePriceDTO.getCoverage().getItemTrafficList()) {
                if (ObjectUtil.isEmpty((Object)trafficDTO.getSerialNo())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u9a7e\u4e58\u8f66\u8f86\u4fe1\u606f\u7684\u5e8f\u53f7"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (ObjectUtil.isEmpty((Object)trafficDTO.getInsuredCount())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u9a7e\u4e58\u8f66\u8f86\u4fe1\u606f\u7684\u6295\u4fdd\u4eba\u6570"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StrUtil.isBlank((CharSequence)trafficDTO.getLicenseNo())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u9a7e\u4e58\u8f66\u8f86\u4fe1\u606f\u7684\u8f66\u724c\u53f7"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StrUtil.isBlank((CharSequence)trafficDTO.getFrameNo())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u9a7e\u4e58\u8f66\u8f86\u4fe1\u606f\u7684\u8f66\u67b6\u53f7"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StrUtil.isBlank((CharSequence)trafficDTO.getEngineNo())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u9a7e\u4e58\u8f66\u8f86\u4fe1\u606f\u7684\u53d1\u52a8\u673a\u53f7"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (ObjectUtil.isEmpty((Object)trafficDTO.getSeatNo())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u9a7e\u4e58\u8f66\u8f86\u4fe1\u606f\u7684\u5ea7\u4f4d\u6570"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (StrUtil.isBlank((CharSequence)trafficDTO.getVehicleType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u9a7e\u4e58\u8f66\u8f86\u4fe1\u606f\u7684\u8f66\u79cd"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
                if (!ObjectUtil.isEmpty((Object)trafficDTO.getRationCount())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u9a7e\u4e58\u8f66\u8f86\u4fe1\u606f\u7684\u6295\u4fdd\u4efd\u6570"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        }
    }

    private void verifyIsHasClaim(StanderRequest request, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        String renewalPolicyNo = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getRenewalPolicyNo();
        RequestHeadDTO requestHeadDTO = RequestHeadDTO.builder().build();
        ClaimQueryInfoDTO claimQueryInfoDTO = ClaimQueryInfoDTO.builder().policyNo(renewalPolicyNo).build();
        ClaimListQueryServiceRequest claimListQueryServiceRequest = ClaimListQueryServiceRequest.builder().head(requestHeadDTO).body(claimQueryInfoDTO).build();
        request.setClaimListQueryServiceRequest(claimListQueryServiceRequest);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)"RENEWAL_CONTROL_CLAIM_ZYB");
        queryWrapper.eq((Object)"config_value", (Object)apisPfpRationMain.getRelateRationCode());
        ApisChannelConfigs apisChannelConfigs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs)) {
            StanderResponse response = this.apisBusinessService.execute("claimQuery", request);
            if (response == null || response.getClaimListQueryResponse() == null || response.getClaimListQueryResponse().getBody() == null || response.getClaimListQueryResponse().getHead() == null) {
                return;
            }
            if (response.getClaimListQueryResponse().getBody().getClaimInfoList().size() > 0) {
                int claimNum = 0;
                BigDecimal sumRealPayCny = new BigDecimal(0);
                for (ClaimListInfo claimListInfo : response.getClaimListQueryResponse().getBody().getClaimInfoList()) {
                    if (ObjectUtil.isNotEmpty((Object)claimListInfo.getCanceloRejectTime()) || !ObjectUtil.isNotEmpty((Object)claimListInfo.getClaimTime())) continue;
                    ++claimNum;
                    sumRealPayCny = sumRealPayCny.add(new BigDecimal(claimListInfo.getSumRealPayCny() == null ? 0.0 : claimListInfo.getSumRealPayCny())).setScale(2, 4);
                }
                if (claimNum >= 2 && sumRealPayCny.doubleValue() >= 3000.0) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10361.getValue(), ChannelErrorCodeEnum.ERR_C10361.getKey());
                }
            }
        } else {
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"config_code", (Object)"RENEWAL_CONTROL_CLAIM");
            queryWrapper.eq((Object)"ration_code", (Object)apisPfpRationMain.getRationCode());
            ApisChannelConfigs apisChannelConfigs2 = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs2)) {
                StanderResponse response = this.apisBusinessService.execute("claimQuery", request);
                if (response == null || response.getClaimListQueryResponse() == null || response.getClaimListQueryResponse().getBody() == null || response.getClaimListQueryResponse().getHead() == null) {
                    return;
                }
                if (response.getClaimListQueryResponse().getBody().getClaimInfoList().size() > 0) {
                    int claimNum = 0;
                    for (ClaimListInfo claimListInfo : response.getClaimListQueryResponse().getBody().getClaimInfoList()) {
                        if (ObjectUtil.isNotEmpty((Object)claimListInfo.getCanceloRejectTime())) continue;
                        ++claimNum;
                    }
                    if (claimNum > 0) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10350.getValue().replaceFirst("##", renewalPolicyNo).replace("##", apisPfpRationMain.getRationCode()), ChannelErrorCodeEnum.ERR_C10350.getKey());
                    }
                }
            }
        }
    }

    public void validateIdNumberByIdType(String idType, String idCard, String riskCode, IdNumberUtil.PersonnelType personType, IdNumberUtil.ClientType clientType, String channelCode, String userCode) throws ApisBusinessException {
        if (!this.idNumberUtil.whetherAllowUsingOtherDocument(idType, riskCode, personType, clientType, channelCode, userCode)) {
            String idTypeDesc = (String)BusinessConstants.idTypeDescMap.get(idType);
            if (StrUtil.isBlank((CharSequence)idTypeDesc)) {
                idTypeDesc = idType;
            }
            if (IdNumberUtil.ClientType.CLIENT == clientType) {
                if (IdNumberUtil.PersonnelType.HOLDER == personType) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10646.getValue().replaceFirst("##", idTypeDesc), ChannelErrorCodeEnum.ERR_C10646.getKey());
                }
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10645.getValue().replaceFirst("##", idTypeDesc), ChannelErrorCodeEnum.ERR_C10645.getKey());
            }
            if (IdNumberUtil.PersonnelType.HOLDER == personType) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10636.getValue().replaceFirst("##", idTypeDesc), ChannelErrorCodeEnum.ERR_C10636.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10635.getValue().replaceFirst("##", idTypeDesc), ChannelErrorCodeEnum.ERR_C10635.getKey());
        }
        if (!this.idNumberUtil.validateIdNumberByIdType(idType, idCard)) {
            if (IdNumberUtil.PersonnelType.HOLDER == personType) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10073.getValue().replaceFirst("##", idCard), ChannelErrorCodeEnum.ERR_C10073.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10078.getValue().replaceFirst("##", idCard), ChannelErrorCodeEnum.ERR_C10078.getKey());
        }
    }

    public void validFormat(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        HashMap<String, String> idMap;
        HashMap<String, String> map;
        String regexEnName;
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        StanderHeader header = standerRequest.getHeader();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredList = quotePriceDTO.getInsuredList();
        List insuredIdvDTOList = quotePriceDTO.getCoverage().getInsuredIdvList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        if (!DateUtils.dateToStr((Date)mainDTO.getStartDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "startDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
        }
        if (!DateUtils.dateToStr((Date)mainDTO.getEndDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "endDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
        }
        String regexName = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_NAME", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        if (StringUtils.isBlank((CharSequence)regexName) || "NoData".equalsIgnoreCase(regexName)) {
            regexName = GeneralRegxs.Name_2;
        }
        if (StringUtils.isBlank((CharSequence)(regexEnName = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_NAME_EN", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code))) || "NoData".equalsIgnoreCase(regexEnName)) {
            regexEnName = GeneralRegxs.Ename;
        }
        boolean isValidEname = StringUtils.isNotBlank((CharSequence)regexEnName) && !"NoCheck".equals(regexEnName);
        String regexContactInfo = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_CONTACT_INFO", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        String regexMobileNo = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_MOBILE_NO", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        String regexContactPhone = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_CONTACT_PHONE", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        boolean isValidContactInfoFormat = StringUtils.isNotBlank((CharSequence)regexContactInfo) && !"NoData".equalsIgnoreCase(regexContactInfo) && !"NoCheck".equalsIgnoreCase(regexContactInfo);
        boolean isValidMobileNoFormat = StringUtils.isNotBlank((CharSequence)regexMobileNo) && !"NoData".equalsIgnoreCase(regexMobileNo) && !"NoCheck".equalsIgnoreCase(regexMobileNo);
        boolean isValidContactPhone = StringUtils.isNotBlank((CharSequence)regexContactPhone) && !"NoData".equalsIgnoreCase(regexContactPhone) && !"NoCheck".equalsIgnoreCase(regexContactPhone);
        for (AppliClientDTO appliClientDTO : appliClientList) {
            if (Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode()) && !"NoCheck".equalsIgnoreCase(regexName) && StringUtils.isNotEmpty((CharSequence)appliClientDTO.getInsuredName()) && !appliClientDTO.getInsuredName().trim().replace(" ", "").matches(regexName)) {
                log.warn("\u59d3\u540d\u6821\u9a8c\u62e6\u622a\uff0c\u6b63\u5219\u8868\u8fbe\u5f0f\uff1a{}", (Object)regexName);
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10477.getValue().replaceFirst("##", appliClientDTO.getInsuredName()).replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10477.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getInsuredEname()) && isValidEname && !appliClientDTO.getInsuredEname().trim().matches(regexEnName)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10619.getValue().replaceFirst("##", appliClientDTO.getInsuredEname()), ChannelErrorCodeEnum.ERR_C10619.getKey());
            }
            if ("1".equals(appliClientDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_PERSONAL).contains(appliClientDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("2".equals(appliClientDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_COMPANY).contains(appliClientDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("01".equals(appliClientDTO.getIdentifyType()) || "13".equals(appliClientDTO.getIdentifyType())) {
                if (StringUtils.isNotBlank((CharSequence)appliClientDTO.getIdentifyNumber()) && !IdcardUtil.isValidCard((String)appliClientDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10073.getValue().replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10073.getKey());
                }
                String birthDateStr = IdcardUtil.getBirth((String)appliClientDTO.getIdentifyNumber());
                if (ObjectUtil.isNotEmpty((Object)appliClientDTO.getBirthday())) {
                    String birthDay = DateUtils.dateToStr((Date)appliClientDTO.getBirthday(), (String)"yyyyMMdd");
                    if (!birthDateStr.equals(birthDay)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10240.getValue().replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10240.getKey());
                    }
                } else {
                    try {
                        appliClientDTO.setBirthday(DateUtils.parseToDate((String)birthDateStr, (String)"yyyyMMdd"));
                    }
                    catch (Exception e) {
                        log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getSex())) {
                    appliClientDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)appliClientDTO.getIdentifyNumber()) == 1 ? 1 : 2));
                } else if (!appliClientDTO.getSex().equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)appliClientDTO.getIdentifyNumber()) == 1 ? 1 : 2))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10616.getValue(), ChannelErrorCodeEnum.ERR_C10616.getKey());
                }
            } else {
                IdNumberUtil.ClientType clientType = null;
                if ("1".equals(appliClientDTO.getInsuredType())) {
                    clientType = IdNumberUtil.ClientType.PERSONAL;
                } else if ("2".equals(appliClientDTO.getInsuredType())) {
                    clientType = IdNumberUtil.ClientType.CLIENT;
                }
                this.validateIdNumberByIdType(appliClientDTO.getIdentifyType(), appliClientDTO.getIdentifyNumber(), mainDTO.getRiskCode(), IdNumberUtil.PersonnelType.HOLDER, clientType, header.getChannelCode(), header.getUserCode());
            }
            if (isValidContactInfoFormat) {
                if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getMobile()) && !appliClientDTO.getMobile().matches(regexContactInfo)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", appliClientDTO.getMobile()), ChannelErrorCodeEnum.ERR_C10618.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getContactPhone()) && isValidMobileNoFormat && StringUtils.isNotEmpty((CharSequence)appliClientDTO.getMobile()) && !appliClientDTO.getMobile().matches(regexMobileNo)) {
                    appliClientDTO.setContactPhone(appliClientDTO.getMobile());
                    appliClientDTO.setMobile(null);
                }
            }
            if (isValidContactPhone && StringUtils.isNotEmpty((CharSequence)appliClientDTO.getContactPhone()) && !appliClientDTO.getContactPhone().matches(regexContactPhone)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", appliClientDTO.getContactPhone()), ChannelErrorCodeEnum.ERR_C10618.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getEmail()) && !appliClientDTO.getEmail().matches(GeneralRegxs.Email)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10132.getValue(), ChannelErrorCodeEnum.ERR_C10132.getKey());
            }
            if (!StringUtils.isNotEmpty((CharSequence)appliClientDTO.getTaxPayerId()) || appliClientDTO.getTaxPayerId().matches(GeneralRegxs.TaxpayerId)) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10478.getValue(), ChannelErrorCodeEnum.ERR_C10478.getKey());
        }
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setConfigCode("OCCUPATION_NULL");
        apisChannelConfigsCondition.setChannelCode(standerRequest.getHeader().getChannelCode());
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        if ("07".equals(apisPfpRationMain.getClassCode()) || "09".equals(apisPfpRationMain.getClassCode())) {
            this.validateIsRepeatDate(insuredIdvDTOList);
            map = new HashMap<String, String>();
            idMap = new HashMap<String, String>();
            String phInsuredType = ((AppliClientDTO)appliClientList.get(0)).getInsuredType();
            for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
                String[] arr;
                String birthDateStr;
                if (map.containsKey(insuredIdvDTO.getInsuredIDCache())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10221.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10221.getKey());
                }
                map.put(insuredIdvDTO.getInsuredIDCache(), insuredIdvDTO.getInsuredName());
                if (idMap.containsKey(insuredIdvDTO.getIdentifyNumber()) && "01".equals(mainDTO.getPolicyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10404.getValue(), ChannelErrorCodeEnum.ERR_C10404.getKey());
                }
                idMap.put(insuredIdvDTO.getIdentifyNumber(), insuredIdvDTO.getInsuredName());
                if (StringUtils.isNotBlank((CharSequence)insuredIdvDTO.getSecondIdNum()) && StringUtils.isBlank((CharSequence)insuredIdvDTO.getSecondIdType()) || StringUtils.isBlank((CharSequence)insuredIdvDTO.getSecondIdNum()) && StringUtils.isNotBlank((CharSequence)insuredIdvDTO.getSecondIdType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10709.getValue(), ChannelErrorCodeEnum.ERR_C10709.getKey());
                }
                if (StringUtils.isNotBlank((CharSequence)insuredIdvDTO.getSecondIdType())) {
                    if ("01".equals(insuredIdvDTO.getSecondIdType()) || "13".equals(insuredIdvDTO.getSecondIdType())) {
                        if (StringUtils.isNotBlank((CharSequence)insuredIdvDTO.getSecondIdNum()) && !IdcardUtil.isValidCard((String)insuredIdvDTO.getSecondIdNum())) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10118.getValue().replace("##", insuredIdvDTO.getSecondIdNum()), ChannelErrorCodeEnum.ERR_C10118.getKey());
                        }
                        birthDateStr = IdcardUtil.getBirth((String)insuredIdvDTO.getSecondIdNum());
                        if (ObjectUtils.isEmpty((Object)insuredIdvDTO.getBirthday())) {
                            insuredIdvDTO.setBirthday(DateUtils.strToDate((String)birthDateStr, (String)"yyyyMMdd"));
                        } else if (!birthDateStr.equals(DateUtils.dateToStr((Date)insuredIdvDTO.getBirthday(), (String)"yyyyMMdd"))) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", insuredIdvDTO.getSecondIdNum()), ChannelErrorCodeEnum.ERR_C10119.getKey());
                        }
                        if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getSex())) {
                            insuredIdvDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredIdvDTO.getSecondIdNum()) == 1 ? 1 : 2));
                        } else if (!insuredIdvDTO.getSex().equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredIdvDTO.getSecondIdNum()) == 1 ? 1 : 2))) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10617.getValue(), ChannelErrorCodeEnum.ERR_C10617.getKey());
                        }
                    } else {
                        IdNumberUtil.ClientType clientType = null;
                        if ("1".equals(insuredIdvDTO.getInsuredType())) {
                            clientType = IdNumberUtil.ClientType.PERSONAL;
                        } else if ("2".equals(insuredIdvDTO.getInsuredType())) {
                            clientType = IdNumberUtil.ClientType.CLIENT;
                        }
                        this.validateIdNumberByIdType(insuredIdvDTO.getSecondIdType(), insuredIdvDTO.getSecondIdNum(), mainDTO.getRiskCode(), IdNumberUtil.PersonnelType.INSURE, clientType, header.getChannelCode(), header.getUserCode());
                    }
                }
                if (Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode()) && !"NoCheck".equalsIgnoreCase(regexName) && StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getInsuredName()) && !insuredIdvDTO.getInsuredName().trim().replace(" ", "").matches(regexName)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10477.getValue().replaceFirst("##", insuredIdvDTO.getInsuredName()).replace("##", insuredIdvDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10477.getKey());
                }
                if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getInsuredEname()) && isValidEname && !insuredIdvDTO.getInsuredEname().trim().matches(regexEnName)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10619.getValue().replaceFirst("##", insuredIdvDTO.getInsuredEname()), ChannelErrorCodeEnum.ERR_C10619.getKey());
                }
                if (!Arrays.asList(BusinessConstants.ID_TYPE_PERSONAL).contains(insuredIdvDTO.getIdentifyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
                }
                if ("01".equals(insuredIdvDTO.getIdentifyType()) || "13".equals(insuredIdvDTO.getIdentifyType())) {
                    if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getIdentifyNumber()) && !IdcardUtil.isValidCard((String)insuredIdvDTO.getIdentifyNumber())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10266.getValue().replaceFirst("##", insuredIdvDTO.getInsuredName()).replace("##", insuredIdvDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10266.getKey());
                    }
                    birthDateStr = IdcardUtil.getBirth((String)insuredIdvDTO.getIdentifyNumber());
                    if (!birthDateStr.equals(DateUtils.dateToStr((Date)insuredIdvDTO.getBirthday(), (String)"yyyyMMdd"))) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", insuredIdvDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10119.getKey());
                    }
                    if (StringUtils.isEmpty((CharSequence)insuredIdvDTO.getSex())) {
                        insuredIdvDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredIdvDTO.getIdentifyNumber()) == 1 ? 1 : 2));
                    } else if (!insuredIdvDTO.getSex().equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredIdvDTO.getIdentifyNumber()) == 1 ? 1 : 2))) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10617.getValue(), ChannelErrorCodeEnum.ERR_C10617.getKey());
                    }
                } else {
                    this.validateIdNumberByIdType(insuredIdvDTO.getIdentifyType(), insuredIdvDTO.getIdentifyNumber(), mainDTO.getRiskCode(), IdNumberUtil.PersonnelType.INSURE, IdNumberUtil.ClientType.PERSONAL, header.getChannelCode(), header.getUserCode());
                }
                if (isValidContactInfoFormat && StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getMobile()) && !insuredIdvDTO.getMobile().matches(regexContactInfo)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", insuredIdvDTO.getMobile()), ChannelErrorCodeEnum.ERR_C10618.getKey());
                }
                if (isValidContactPhone && StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getContactPhone()) && !insuredIdvDTO.getContactPhone().matches(regexContactPhone)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", insuredIdvDTO.getContactPhone()), ChannelErrorCodeEnum.ERR_C10618.getKey());
                }
                if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getEmail()) && !insuredIdvDTO.getEmail().matches(GeneralRegxs.Email)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10144.getValue(), ChannelErrorCodeEnum.ERR_C10144.getKey());
                }
                if ("2".equals(insuredIdvDTO.getBenefitModeCode()) && "1".equals(insuredIdvDTO.getBenefitOrder())) {
                    BigDecimal sumShare = new BigDecimal(0);
                    if (ObjectUtil.isNotEmpty((Object)insuredIdvDTO.getBeneficiary()) && insuredIdvDTO.getBeneficiary().size() > 0) {
                        for (com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.BeneficiaryDTO beneficiaryDTO : insuredIdvDTO.getBeneficiary()) {
                            BigDecimal share = new BigDecimal(StringUtils.isEmpty((CharSequence)beneficiaryDTO.getShare()) ? "0" : beneficiaryDTO.getShare());
                            sumShare = sumShare.add(share);
                        }
                        if (sumShare.compareTo(new BigDecimal(100)) != 0) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10038.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10038.getKey());
                        }
                    }
                }
                if ("1".equals(phInsuredType) && StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getRelationToAppnt()) && ("06".equals(insuredIdvDTO.getRelationToAppnt()) || "07".equals(insuredIdvDTO.getRelationToAppnt()))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10136.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10136.getKey());
                }
                if ("2".equals(phInsuredType) && StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getRelationToAppnt()) && !Arrays.asList(arr = new String[]{"06", "07", "99"}).contains(insuredIdvDTO.getRelationToAppnt())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10137.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10137.getKey());
                }
                if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getRelationToAppnt()) && "01".equals(insuredIdvDTO.getRelationToAppnt()) && (!insuredIdvDTO.getInsuredName().contains(((AppliClientDTO)appliClientList.get(0)).getInsuredName()) || !insuredIdvDTO.getIdentifyNumber().equals(((AppliClientDTO)appliClientList.get(0)).getIdentifyNumber()))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10138.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10138.getKey());
                }
                boolean isValidOccupationCode = true;
                if ("1".equals(mainDTO.getRenewalFlag()) || "underwrit".equals(standerRequest.getHeader().getBussinessType()) && StringUtils.isNotBlank((CharSequence)mainDTO.getRenewalPolicyNo())) {
                    List preInsuredList;
                    if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPolicyDTO()) && ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPolicyDTO().getCoverage().getItemList()) && ObjectUtil.isNotEmpty((Object)(preInsuredList = ((ItemMainDTO)quotePriceDTO.getPolicyDTO().getCoverage().getItemList().get(0)).getInsuredIdvList()))) {
                        boolean isOccupationEmtpy = ObjectUtil.isEmpty((Object)insuredIdvDTO.getOccupationCode());
                        for (InsuredIdvDTO preInsured : preInsuredList) {
                            if (!preInsured.getIdentifyNumber().equals(insuredIdvDTO.getIdentifyNumber())) continue;
                            if (isOccupationEmtpy) {
                                if (!ObjectUtil.isEmpty((Object)preInsured.getOccupationCode())) continue;
                                isValidOccupationCode = false;
                                continue;
                            }
                            if (!insuredIdvDTO.getOccupationCode().equals(preInsured.getOccupationCode())) continue;
                            isValidOccupationCode = false;
                        }
                    }
                    log.warn("\u539f\u3001\u7eed\u4fdd\u4fdd\u5355\u804c\u4e1a\u662f\u5426\u76f8\u7b49\uff1a{}", (Object)(!isValidOccupationCode ? 1 : 0));
                }
                if (isValidOccupationCode) {
                    ApisChannelConfigs apisChannelConfigs1 = new ApisChannelConfigs();
                    apisChannelConfigs1.setConfigCode("OCCUPATION_NOT_NULL");
                    apisChannelConfigs1.setProductCode(mainDTO.getRiskCode());
                    ApisChannelConfigs apisChannelConfigs2 = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs1);
                    if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs2) && ObjectUtil.isNotEmpty((Object)apisChannelConfigs2.getProductCode())) {
                        String[] occArr;
                        boolean aFlag;
                        if (ObjectUtil.isEmpty((Object)apisChannelConfigs) && StringUtils.isEmpty((CharSequence)insuredIdvDTO.getOccupationCode()) && StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getInsuredOccupation()) && StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getInsuredOccupation().trim()) && !(aFlag = Arrays.asList(occArr = apisPfpRationMain.getInsuredOccupation().split(",")).contains("7"))) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10120.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10120.getKey());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getOccupationLevel()) && StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getInsuredOccupation()) && StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getInsuredOccupation().trim()) && !"Z02001".equals(insuredIdvDTO.getOccupationCode())) {
                            String[] arr2 = apisPfpRationMain.getInsuredOccupation().split(",");
                            if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getOccupationLevel()) && !Arrays.asList(arr2).contains(insuredIdvDTO.getOccupationLevel()) && !Arrays.asList(arr2).contains("7")) {
                                QueryWrapper queryWrapper = new QueryWrapper();
                                queryWrapper.eq((Object)"config_code", (Object)"OCCUPATION_CONTROL_SPECIAL_ONE");
                                queryWrapper.eq((Object)"config_value", (Object)apisPfpRationMain.getRelateRationCode());
                                queryWrapper.like((Object)"remark", (Object)insuredIdvDTO.getOccupationCode());
                                ApisChannelConfigs occConfig = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
                                if (ObjectUtil.isEmpty((Object)occConfig)) {
                                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10121.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10121.getKey());
                                }
                            }
                        }
                    }
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"config_code", (Object)"OCCUPATION_CONTROL_SPECIAL");
                    queryWrapper.eq((Object)"config_value", (Object)apisPfpRationMain.getRelateRationCode());
                    queryWrapper.like((Object)"remark", (Object)insuredIdvDTO.getOccupationCode());
                    ApisChannelConfigs occConfig = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
                    if (ObjectUtil.isNotEmpty((Object)occConfig)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10626.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10626.getKey());
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)insuredIdvDTO.getStartDate()) && "02".equals(quotePriceDTO.getMain().getPolicyType())) {
                    if (!DateUtils.dateToStr((Date)insuredIdvDTO.getStartDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "startDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
                    }
                    if (insuredIdvDTO.getStartDate().before(quotePriceDTO.getMain().getStartDate()) || insuredIdvDTO.getStartDate().after(quotePriceDTO.getMain().getEndDate())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10459.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10459.getKey());
                    }
                }
                if (!ObjectUtil.isNotEmpty((Object)insuredIdvDTO.getEndDate()) || !"02".equals(quotePriceDTO.getMain().getPolicyType())) continue;
                if (!DateUtils.dateToStr((Date)insuredIdvDTO.getEndDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "endDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
                }
                if (!insuredIdvDTO.getEndDate().before(quotePriceDTO.getMain().getStartDate()) && !insuredIdvDTO.getEndDate().after(quotePriceDTO.getMain().getEndDate())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10460.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10460.getKey());
            }
            if (!"P070008".equals(apisPfpRationMain.getProductCode()) && mainDTO.getSumQuantity().intValue() != insuredIdvDTOList.size()) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10036.getValue(), ChannelErrorCodeEnum.ERR_C10036.getKey());
            }
        } else {
            map = new HashMap();
            idMap = new HashMap();
            for (InsuredDTO insuredDTO : insuredList) {
                if ("1".equals(insuredDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_PERSONAL).contains(insuredDTO.getIdentifyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
                }
                if ("2".equals(insuredDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_COMPANY).contains(insuredDTO.getIdentifyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
                }
                if (map.containsKey(insuredDTO.getInsuredIDCache())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10221.getValue().replace("##", insuredDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10221.getKey());
                }
                map.put(insuredDTO.getInsuredIDCache(), insuredDTO.getInsuredName());
                if (idMap.containsKey(insuredDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10404.getValue(), ChannelErrorCodeEnum.ERR_C10404.getKey());
                }
                idMap.put(insuredDTO.getIdentifyNumber(), insuredDTO.getInsuredName());
                if (Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode())) {
                    if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getInsuredName()) && insuredDTO.getInsuredName().trim().length() < 2 && !insuredDTO.getInsuredName().trim().replace(" ", "").matches(GeneralRegxs.Name)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10134.getValue(), ChannelErrorCodeEnum.ERR_C10134.getKey());
                    }
                    if (!"NoCheck".equalsIgnoreCase(regexName) && StringUtils.isNotEmpty((CharSequence)insuredDTO.getInsuredName()) && !insuredDTO.getInsuredName().trim().replace(" ", "").matches(regexName)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10477.getValue().replaceFirst("##", insuredDTO.getInsuredName()).replace("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10477.getKey());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getInsuredEname()) && isValidEname && !insuredDTO.getInsuredEname().trim().matches(regexEnName)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10619.getValue().replaceFirst("##", insuredDTO.getInsuredEname()), ChannelErrorCodeEnum.ERR_C10619.getKey());
                }
                if (StringUtils.isNotBlank((CharSequence)insuredDTO.getSecondIdNum()) && StringUtils.isBlank((CharSequence)insuredDTO.getSecondIdType()) || StringUtils.isBlank((CharSequence)insuredDTO.getSecondIdNum()) && StringUtils.isNotBlank((CharSequence)insuredDTO.getSecondIdType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10709.getValue(), ChannelErrorCodeEnum.ERR_C10709.getKey());
                }
                if (StringUtils.isNotBlank((CharSequence)insuredDTO.getSecondIdType())) {
                    if ("01".equals(insuredDTO.getSecondIdType()) || "13".equals(insuredDTO.getSecondIdType())) {
                        if (StringUtils.isNotBlank((CharSequence)insuredDTO.getSecondIdNum()) && !IdcardUtil.isValidCard((String)insuredDTO.getSecondIdNum())) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10118.getValue().replace("##", insuredDTO.getSecondIdNum()), ChannelErrorCodeEnum.ERR_C10118.getKey());
                        }
                        String birthDateStr = IdcardUtil.getBirth((String)insuredDTO.getIdentifyNumber());
                        if (ObjectUtils.isEmpty((Object)insuredDTO.getBirthday())) {
                            insuredDTO.setBirthday(DateUtils.strToDate((String)birthDateStr, (String)"yyyyMMdd"));
                        } else if (!birthDateStr.equals(DateUtils.dateToStr((Date)insuredDTO.getBirthday(), (String)"yyyyMMdd"))) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10119.getKey());
                        }
                        if (StringUtils.isEmpty((CharSequence)insuredDTO.getSex())) {
                            insuredDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredDTO.getSecondIdNum()) == 1 ? 1 : 2));
                        } else if (!insuredDTO.getSex().equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredDTO.getSecondIdNum()) == 1 ? 1 : 2))) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10617.getValue(), ChannelErrorCodeEnum.ERR_C10617.getKey());
                        }
                    } else {
                        IdNumberUtil.ClientType clientType = null;
                        if ("1".equals(insuredDTO.getInsuredType())) {
                            clientType = IdNumberUtil.ClientType.PERSONAL;
                        } else if ("2".equals(insuredDTO.getInsuredType())) {
                            clientType = IdNumberUtil.ClientType.CLIENT;
                        }
                        this.validateIdNumberByIdType(insuredDTO.getSecondIdType(), insuredDTO.getSecondIdNum(), mainDTO.getRiskCode(), IdNumberUtil.PersonnelType.INSURE, clientType, header.getChannelCode(), header.getUserCode());
                    }
                }
                if ("01".equals(insuredDTO.getIdentifyType()) || "13".equals(insuredDTO.getIdentifyType())) {
                    if (StringUtils.isNotBlank((CharSequence)insuredDTO.getIdentifyNumber()) && !IdcardUtil.isValidCard((String)insuredDTO.getIdentifyNumber())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10118.getValue().replace("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10118.getKey());
                    }
                    String birthDateStr = IdcardUtil.getBirth((String)insuredDTO.getIdentifyNumber());
                    if (ObjectUtils.isEmpty((Object)insuredDTO.getBirthday())) {
                        insuredDTO.setBirthday(DateUtils.strToDate((String)birthDateStr, (String)"yyyyMMdd"));
                    } else if (!birthDateStr.equals(DateUtils.dateToStr((Date)insuredDTO.getBirthday(), (String)"yyyyMMdd"))) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10119.getKey());
                    }
                    if (StringUtils.isEmpty((CharSequence)insuredDTO.getSex())) {
                        insuredDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredDTO.getIdentifyNumber()) == 1 ? 1 : 2));
                    } else if (!insuredDTO.getSex().equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredDTO.getIdentifyNumber()) == 1 ? 1 : 2))) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10617.getValue(), ChannelErrorCodeEnum.ERR_C10617.getKey());
                    }
                } else {
                    IdNumberUtil.ClientType clientType = null;
                    if ("1".equals(insuredDTO.getInsuredType())) {
                        clientType = IdNumberUtil.ClientType.PERSONAL;
                    } else if ("2".equals(insuredDTO.getInsuredType())) {
                        clientType = IdNumberUtil.ClientType.CLIENT;
                    }
                    this.validateIdNumberByIdType(insuredDTO.getIdentifyType(), insuredDTO.getIdentifyNumber(), mainDTO.getRiskCode(), IdNumberUtil.PersonnelType.INSURE, clientType, header.getChannelCode(), header.getUserCode());
                }
                if (isValidContactInfoFormat && StringUtils.isNotEmpty((CharSequence)insuredDTO.getMobile()) && !insuredDTO.getMobile().matches(regexContactInfo)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", insuredDTO.getMobile()), ChannelErrorCodeEnum.ERR_C10618.getKey());
                }
                if (isValidContactPhone && StringUtils.isNotEmpty((CharSequence)insuredDTO.getContactPhone()) && !insuredDTO.getContactPhone().matches(regexContactPhone)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", insuredDTO.getContactPhone()), ChannelErrorCodeEnum.ERR_C10618.getKey());
                }
                if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getEmail()) && !insuredDTO.getEmail().matches(GeneralRegxs.Email)) {
                    throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u3010" + insuredDTO.getInsuredName() + "\u3011\u3010\u8bc1\u4ef6\u53f7" + insuredDTO.getIdentifyNumber() + "\u3011\u90ae\u7bb1\u3010" + insuredDTO.getEmail() + "\u3011\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4!", ChannelErrorCodeEnum.ERR_C10133.getKey());
                }
                if ("2".equals(insuredDTO.getBenefitModeCode()) && "1".equals(insuredDTO.getBenefitOrder())) {
                    int sumShare = 0;
                    for (BeneficiaryDTO beneficiaryDTO : insuredDTO.getBeneficiary()) {
                        int share = Integer.valueOf(beneficiaryDTO.getShare());
                        sumShare += share;
                    }
                    if (sumShare != 100) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10038.getValue().replace("##", insuredDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10038.getKey());
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)insuredDTO.getRelationToAppnt()) || !"01".equals(insuredDTO.getRelationToAppnt()) || insuredDTO.getInsuredName().contains(((AppliClientDTO)appliClientList.get(0)).getInsuredName()) && insuredDTO.getIdentifyNumber().equals(((AppliClientDTO)appliClientList.get(0)).getIdentifyNumber())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10138.getValue().replace("##", insuredDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10138.getKey());
            }
            if (mainDTO.getSumQuantity().intValue() != insuredList.size()) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10036.getValue(), ChannelErrorCodeEnum.ERR_C10036.getKey());
            }
        }
        if ("P070008".equals(apisPfpRationMain.getProductCode())) {
            String regexLicenseNo = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_DRIVE_LICENSE_NO", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
            boolean isCheckLicenseNo = ObjectUtil.isNotEmpty((Object)regexLicenseNo) && !"NoCheck".equalsIgnoreCase(regexLicenseNo);
            String regexFrameNo = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_DRIVE_FRAME_NO", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
            boolean isCheckFrameNo = ObjectUtil.isNotEmpty((Object)regexFrameNo) && !"NoCheck".equalsIgnoreCase(regexFrameNo);
            String regexEngineNo = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_DRIVE_ENGINE_NO", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
            boolean isCheckEngineNo = ObjectUtil.isNotEmpty((Object)regexEngineNo) && !"NoCheck".equalsIgnoreCase(regexEngineNo);
            List itemTrafficDTOList = quotePriceDTO.getCoverage().getItemTrafficList();
            for (ItemTrafficDTO itemTrafficDTO : itemTrafficDTOList) {
                if (isCheckLicenseNo && ObjectUtil.isNotEmpty((Object)itemTrafficDTO.getLicenseNo()) && !ReUtil.isMatch((String)regexLicenseNo, (CharSequence)itemTrafficDTO.getLicenseNo().trim())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10685.getValue().replaceFirst("##", itemTrafficDTO.getLicenseNo().trim()), ChannelErrorCodeEnum.ERR_C10685.getKey());
                }
                if (isCheckFrameNo && StrUtil.isNotEmpty((CharSequence)itemTrafficDTO.getFrameNo()) && !ReUtil.isMatch((String)regexFrameNo, (CharSequence)itemTrafficDTO.getFrameNo().trim())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10686.getValue().replaceFirst("##", itemTrafficDTO.getFrameNo().trim()), ChannelErrorCodeEnum.ERR_C10686.getKey());
                }
                if (!isCheckEngineNo || !StrUtil.isNotEmpty((CharSequence)itemTrafficDTO.getEngineNo()) || ReUtil.isMatch((String)regexEngineNo, (CharSequence)itemTrafficDTO.getEngineNo().trim())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10687.getValue().replaceFirst("##", itemTrafficDTO.getEngineNo().trim()), ChannelErrorCodeEnum.ERR_C10687.getKey());
            }
        }
    }

    public void validProduct(StanderRequest standerRequest, List<ApisPfpRationMain> apisPfpRationMainList) throws ApisBusinessException {
        ApisPfpRationMain apisPfpRationMain = apisPfpRationMainList.get(0);
        StanderHeader standerHeader = standerRequest.getHeader();
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredList = quotePriceDTO.getInsuredList();
        List insuredIdvDTOList = quotePriceDTO.getCoverage().getInsuredIdvList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        Date startDate = mainDTO.getStartDate();
        long lessFifty = 0L;
        int parentCount = 0;
        int childCount = 0;
        int myCount = 0;
        int spouseCount = 0;
        int juveniles = 0;
        int adult = 0;
        String caclMethod = "";
        if (!("ZR-SSBQ-FY-2C".equals(apisPfpRationMain.getRationCode()) || "HY-GN- LAND-7D-WBHW-2C".equals(apisPfpRationMain.getRationCode()) || "03".equals(apisPfpRationMain.getRationRateType()) || "04".equals(apisPfpRationMain.getRationRateType()))) {
            caclMethod = this.dataCompletionUtil.queryCalcType(apisPfpRationMain.getRationCode());
        }
        if (startDate.after(mainDTO.getEndDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10067.getValue(), ChannelErrorCodeEnum.ERR_C10067.getKey());
        }
        ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("backSign");
        channelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
        ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (ObjectUtil.isEmpty((Object)channelConfigs) && startDate.before(new Date()) && "1".equals(this.backSignSwitch)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10035.getValue(), ChannelErrorCodeEnum.ERR_C10035.getKey());
        }
        if (!QuotePriceValidate.isOutOneYear((Date)startDate, (Date)mainDTO.getEndDate(), (boolean)false)) {
            if (Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10040.getValue(), ChannelErrorCodeEnum.ERR_C10040.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10068.getValue(), ChannelErrorCodeEnum.ERR_C10068.getKey());
        }
        if ("LXSBCYLBX".equals(apisPfpRationMain.getRationCode())) {
            Object maxStartDate;
            if (DateUtil.offsetMonth((Date)mainDTO.getInputDate(), (int)3).isBefore(mainDTO.getStartDate())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10720.getValue(), ChannelErrorCodeEnum.ERR_C10720.getKey());
            }
            Date maxStart = insuredIdvDTOList.stream().map(InsuredIdvDTO::getBasicsPolicy).map(BasicsPolicyDTO::getBasicsPolicyStartDate).max(Comparator.comparing(Date::getTime)).get();
            DateTime inputDatePlusDay = DateUtil.offsetDay((Date)mainDTO.getInputDate(), (int)1);
            Calendar plusDayCalendar = DateUtil.calendar((Date)inputDatePlusDay);
            plusDayCalendar.set(11, 0);
            plusDayCalendar.set(12, 0);
            plusDayCalendar.set(13, 0);
            plusDayCalendar.set(14, 0);
            Date plusDayZeroTime = plusDayCalendar.getTime();
            Object object = maxStartDate = maxStart.after(plusDayZeroTime) ? maxStart : plusDayZeroTime;
            if (DateUtil.compare((Date)maxStartDate, (Date)mainDTO.getStartDate()) != 0) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10727.getValue(), ChannelErrorCodeEnum.ERR_C10727.getKey());
            }
            Date maxEnd = insuredIdvDTOList.stream().map(InsuredIdvDTO::getBasicsPolicy).map(BasicsPolicyDTO::getBasicsPolicyEndDate).max(Comparator.comparing(Date::getTime)).get();
            if (DateUtil.compare((Date)maxEnd, (Date)mainDTO.getEndDate()) != 0) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10728.getValue(), ChannelErrorCodeEnum.ERR_C10728.getKey());
            }
        }
        boolean flag = false;
        Integer ageMin = null;
        Integer ageMax = null;
        int renewableMaxAge = 0;
        for (Object appliClientDTO : appliClientList) {
            long year;
            if (!"1".equals(appliClientDTO.getInsuredType())) continue;
            ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
            apisChannelConfigsCondition.setConfigCode("MINOR_INSURE_PLANS");
            apisChannelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
            apisChannelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
            ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
            if (!ObjectUtil.isEmpty((Object)apisChannelConfigs) || !ObjectUtil.isNotEmpty((Object)appliClientDTO.getBirthday()) || (year = (long)this.dataCompletionUtil.calculateAge(startDate, appliClientDTO.getBirthday())) >= 18L) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10124.getValue(), ChannelErrorCodeEnum.ERR_C10124.getKey());
        }
        channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("ONE_INSURED");
        channelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
        ApisChannelConfigs configsOneInsured = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)insuredList) && insuredList.size() > 0) {
            if (ObjectUtil.isNotEmpty((Object)configsOneInsured) && insuredList.size() > 1) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10269.getValue(), ChannelErrorCodeEnum.ERR_C10269.getKey());
            }
            for (InsuredDTO insuredDTO : insuredList) {
                String[] arr;
                String birthDay;
                String birthDateStr;
                if ("01".equals(insuredDTO.getIdentifyType()) && !(birthDateStr = IdcardUtil.getBirth((String)insuredDTO.getIdentifyNumber())).equals(birthDay = DateUtils.dateToStr((Date)insuredDTO.getBirthday(), (String)"yyyyMMdd"))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10267.getValue(), ChannelErrorCodeEnum.ERR_C10267.getKey());
                }
                if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getRelationToAppnt()) && StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getAppliRelation().trim()) && !Arrays.asList(arr = apisPfpRationMain.getAppliRelation().trim().split(",")).contains(insuredDTO.getRelationToAppnt())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10135.getValue().replace("##", apisPfpRationMain.getRationCode()), ChannelErrorCodeEnum.ERR_C10135.getKey());
                }
                if (!Arrays.asList(PLAN_YEAR_ARRAY).contains(caclMethod) || QuotePriceValidate.isOutOneYear((Date)startDate, (Date)mainDTO.getEndDate(), (boolean)true) || !"01".equals(apisPfpRationMain.getPaymentType())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10043.getValue(), ChannelErrorCodeEnum.ERR_C10043.getKey());
            }
        } else if (ObjectUtil.isNotEmpty((Object)insuredIdvDTOList) && insuredIdvDTOList.size() > 0) {
            ApisChannelConfigs relationToAppntConfig = new ApisChannelConfigs();
            relationToAppntConfig.setConfigCode("INSURED_RELATION_NULL");
            relationToAppntConfig.setChannelCode(standerRequest.getHeader().getChannelCode());
            ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(relationToAppntConfig);
            if (ObjectUtil.isNotEmpty((Object)configsOneInsured) && insuredIdvDTOList.size() > 1) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10269.getValue(), ChannelErrorCodeEnum.ERR_C10269.getKey());
            }
            int index = 0;
            for (InsuredIdvDTO idvDTO : insuredIdvDTOList) {
                ApisPfpRationMain apm;
                long year;
                String birthDay;
                String birthDateStr;
                if ("01".equals(idvDTO.getIdentifyType()) && !(birthDateStr = IdcardUtil.getBirth((String)idvDTO.getIdentifyNumber())).equals(birthDay = DateUtils.dateToStr((Date)idvDTO.getBirthday(), (String)"yyyyMMdd"))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10267.getValue(), ChannelErrorCodeEnum.ERR_C10267.getKey());
                }
                String alipayFlag = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getAlipayFlag();
                if ("1".equals(alipayFlag)) {
                    Date inputDate = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getInputDate();
                    year = this.dataCompletionUtil.calculateAge(inputDate, idvDTO.getBirthday());
                } else {
                    year = this.dataCompletionUtil.calculateAge(startDate, idvDTO.getBirthday());
                }
                int apmIndex = 0;
                if (apisPfpRationMainList.size() > 1) {
                    for (int i = 0; i < quotePriceDTO.getCoverage().getItemList().size(); ++i) {
                        if (((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(i)).getItemNo() != idvDTO.getItemNo()) continue;
                        apmIndex = i;
                        break;
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)(apm = apisPfpRationMainList.get(apmIndex)).getAgeMax()) && StringUtils.isNotEmpty((CharSequence)apm.getAgeMin())) {
                    flag = true;
                    ageMin = Integer.parseInt(apm.getAgeMin());
                    ageMax = Integer.parseInt(apm.getAgeMax());
                    int n = renewableMaxAge = ObjectUtil.isNotEmpty((Object)apm.getRenewableMaxAge()) ? apm.getRenewableMaxAge() : 0;
                }
                if (flag) {
                    if (renewableMaxAge != 0 && (ObjectUtil.isNotEmpty((Object)mainDTO.getRenewalPolicyNo()) || ObjectUtil.isNotEmpty((Object)mainDTO.getTurnInsureType()))) {
                        ageMax = renewableMaxAge;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)mainDTO.getTurnInsureType())) {
                        if (year > (long)ageMax.intValue()) {
                            throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u59d3\u540d\u3010" + idvDTO.getInsuredName() + "\u3011\u8bc1\u4ef6\u53f7\u3010" + idvDTO.getIdentifyNumber() + "\u3011\u5e74\u9f84\u8d85\u51fa\u4e86\u8ba1\u5212\u7684\u7eed\u4fdd\u5e74\u9f84\u9650\u5236\u3010" + ageMin + "\u3011-\u3010" + ageMax + "\u3011!", ChannelErrorCodeEnum.ERR_C10264.getKey());
                        }
                    } else if (year < (long)ageMin.intValue() || year > (long)ageMax.intValue()) {
                        throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u59d3\u540d\u3010" + idvDTO.getInsuredName() + "\u3011\u8bc1\u4ef6\u53f7\u3010" + idvDTO.getIdentifyNumber() + "\u3011\u5e74\u9f84\u8d85\u51fa\u8ba1\u5212\u7684\u5e74\u9f84\u9650\u5236\u3010" + ageMin + "\u3011-\u3010" + ageMax + "\u3011!", ChannelErrorCodeEnum.ERR_C10366.getKey());
                    }
                }
                flag = false;
                ageMin = null;
                renewableMaxAge = 0;
                if (StringUtils.isNotEmpty((CharSequence)apm.getAppliRelation().trim()) && ObjectUtil.isEmpty((Object)apisChannelConfigs)) {
                    if (StringUtils.isEmpty((CharSequence)idvDTO.getRelationToAppnt())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "PolicyholderInsuredRelation"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                    }
                    String[] arr = apm.getAppliRelation().trim().split(",");
                    if (!Arrays.asList(arr).contains(idvDTO.getRelationToAppnt())) {
                        if ("underwrit".equals(standerHeader.getBussinessType())) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10195.getValue().replaceFirst("##", idvDTO.getInsuredName()).replace("##", idvDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10195.getKey());
                        }
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10135.getValue().replace("##", idvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10135.getKey());
                    }
                }
                if (year < 50L) {
                    ++lessFifty;
                }
                if (year < 18L) {
                    ++juveniles;
                } else {
                    ++adult;
                }
                if (Arrays.asList(PLAN_YEAR_ARRAY).contains(caclMethod) && !QuotePriceValidate.isOutOneYear((Date)startDate, (Date)mainDTO.getEndDate(), (boolean)true)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10043.getValue(), ChannelErrorCodeEnum.ERR_C10043.getKey());
                }
                if (StringUtils.isNotEmpty((CharSequence)idvDTO.getRelationToAppnt())) {
                    if ("04".equals(idvDTO.getRelationToAppnt())) {
                        ++childCount;
                    }
                    if ("03".equals(idvDTO.getRelationToAppnt())) {
                        ++parentCount;
                    }
                    if ("01".equals(idvDTO.getRelationToAppnt())) {
                        ++myCount;
                    }
                    if ("02".equals(idvDTO.getRelationToAppnt())) {
                        ++spouseCount;
                    }
                }
                if ("3".equals(mainDTO.getCalcType()) && "P070002".equals(mainDTO.getRiskCode()) && StringUtils.isEmpty((CharSequence)idvDTO.getSocialSecurityFlag())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10351.getValue().replace("##", idvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10351.getKey());
                }
                ++index;
            }
        }
        channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
        channelConfigsCondition.setConfigCode("ONE_STEP_ISSUE_CODE");
        ApisChannelConfigs apisChannelConfigsO = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (StringUtils.isNotEmpty((CharSequence)mainDTO.getOutPaymentType())) {
            if ("0".equals(mainDTO.getJFeeFlag())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10471.getValue(), ChannelErrorCodeEnum.ERR_C10471.getKey());
            }
            if (ObjectUtil.isEmpty((Object)apisChannelConfigsO)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10443.getValue(), ChannelErrorCodeEnum.ERR_C10443.getKey());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigsO) && "1".equals(mainDTO.getStepFlag()) && (StringUtils.isEmpty((CharSequence)mainDTO.getOutPaymentType()) || StringUtils.isEmpty((CharSequence)mainDTO.getAccountCode())) && "1".equals(mainDTO.getRenewalFlag()) && ObjectUtil.isNotEmpty((Object)standerRequest.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform()) && !standerRequest.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform().booleanValue()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10470.getValue(), ChannelErrorCodeEnum.ERR_C10470.getKey());
        }
        if ("3".equals(mainDTO.getCalcType()) && Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode())) {
            if ("P070002".equals(mainDTO.getRiskCode()) || "P090002".equals(mainDTO.getRiskCode())) {
                ApisChannelConfigs fityfAgeConfig = new ApisChannelConfigs();
                fityfAgeConfig.setConfigCode("doubleBelowFiftyAge");
                fityfAgeConfig.setRationCode(apisPfpRationMain.getRelateRationCode());
                ApisChannelConfigs acConfigs = this.apisChannelConfigsService.getChannelConfig(fityfAgeConfig);
                if (!(!"P070002P154".equals(apisPfpRationMain.getRelateRationCode()) && !ObjectUtil.isNotEmpty((Object)acConfigs) || "1".equals(mainDTO.getRenewalFlag()) || "underwrit".equals(standerRequest.getHeader().getBussinessType()) && StringUtils.isNotBlank((CharSequence)mainDTO.getRenewalPolicyNo()) || lessFifty >= 2L)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10353.getValue().replaceFirst("##", "2").replace("##", "50"), ChannelErrorCodeEnum.ERR_C10353.getKey());
                }
                if (quotePriceDTO.getCoverage().getInsuredIdvList().size() < 2 || quotePriceDTO.getCoverage().getInsuredIdvList().size() > 8) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10352.getValue().replaceFirst("##", "2").replace("##", "8"), ChannelErrorCodeEnum.ERR_C10352.getKey());
                }
                if (myCount > 1 || spouseCount > 1) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10356.getValue(), ChannelErrorCodeEnum.ERR_C10356.getKey());
                }
            }
            if ("P070006".equals(mainDTO.getRiskCode()) && ("11".equals(caclMethod) || "12".equals(caclMethod))) {
                if (childCount > 2) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10360.getValue(), ChannelErrorCodeEnum.ERR_C10360.getKey());
                }
                if (parentCount > 2) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10358.getValue(), ChannelErrorCodeEnum.ERR_C10358.getKey());
                }
                if (myCount > 1 || spouseCount > 1) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10356.getValue(), ChannelErrorCodeEnum.ERR_C10356.getKey());
                }
                if (myCount == 0) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10357.getValue(), ChannelErrorCodeEnum.ERR_C10357.getKey());
                }
            }
            ApisChannelConfigs juvenileConfig = new ApisChannelConfigs();
            juvenileConfig.setConfigCode("juveniles_not_proposal");
            juvenileConfig.setRationCode(apisPfpRationMain.getRelateRationCode());
            ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(juvenileConfig);
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs) && juveniles > 0 && adult == 0) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10282.getValue(), ChannelErrorCodeEnum.ERR_C10282.getKey());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPayPlanList()) && quotePriceDTO.getPayPlanList().size() > 1 && StringUtils.isEmpty((CharSequence)quotePriceDTO.getMain().getTurnInsureType()) && "0".equals(mainDTO.getRenewalFlag())) {
            Calendar calendar = Calendar.getInstance();
            ApisChannelConfigs installmentConfig = new ApisChannelConfigs();
            installmentConfig.setConfigCode("Installment_back");
            installmentConfig.setUserCode(standerHeader.getUserCode());
            ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(installmentConfig);
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs)) {
                String[] dayArr = apisChannelConfigs.getConfigValue().split(",");
                boolean passFlag = true;
                for (int i = 0; i < dayArr.length; ++i) {
                    calendar.setTime(mainDTO.getInputDate());
                    calendar.add(5, Integer.parseInt(dayArr[i]));
                    long a = Long.parseLong(DateUtils.dateToStr((Date)quotePriceDTO.getMain().getStartDate(), (String)"yyyyMMddHHmmss"));
                    long b = Long.parseLong(DateUtils.dateToStr((Date)calendar.getTime(), (String)"yyyyMMdd") + "000000");
                    if (a != b) continue;
                    passFlag = false;
                    break;
                }
                if (passFlag) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10452.getValue(), ChannelErrorCodeEnum.ERR_C10452.getKey());
                }
            } else {
                calendar.setTime(mainDTO.getInputDate());
                calendar.add(5, 1);
                long a = Long.parseLong(DateUtils.dateToStr((Date)quotePriceDTO.getMain().getStartDate(), (String)"yyyyMMddHHmmss"));
                long b = Long.parseLong(DateUtils.dateToStr((Date)calendar.getTime(), (String)"yyyyMMdd") + "000000");
                if (a != b) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10452.getValue(), ChannelErrorCodeEnum.ERR_C10452.getKey());
                }
            }
        }
        if (RiskCodeEnum.getType((String)mainDTO.getRiskCode()) == 3 && ObjectUtil.isNotEmpty((Object)quotePriceDTO.getRiskInfo())) {
            if ("01".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) && quotePriceDTO.getRiskInfo().getSiteArea().compareTo(new BigDecimal(10000)) == 1) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10610.getValue(), ChannelErrorCodeEnum.ERR_C10610.getKey());
            }
            if ("02".equals(quotePriceDTO.getRiskInfo().getUnderwritingType())) {
                if (quotePriceDTO.getRiskInfo().getSiteArea().compareTo(new BigDecimal(10000)) == 1) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10610.getValue(), ChannelErrorCodeEnum.ERR_C10610.getKey());
                }
                if (Integer.parseInt(quotePriceDTO.getRiskInfo().getPeopleNumber()) > 2000) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10611.getValue(), ChannelErrorCodeEnum.ERR_C10611.getKey());
                }
                long days = DateUtils.getDays((String)DateUtils.dateToStr((Date)mainDTO.getEndDate()), (String)DateUtils.dateToStr((Date)mainDTO.getStartDate()));
                SimpleDateFormat formatter = new SimpleDateFormat("HHmmss");
                Integer endHm = Integer.parseInt(formatter.format(mainDTO.getEndDate()));
                if (endHm >= 235900) {
                    ++days;
                }
                if (days > 30L) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10612.getValue(), ChannelErrorCodeEnum.ERR_C10612.getKey());
                }
            }
            if ("03".equals(quotePriceDTO.getRiskInfo().getUnderwritingType())) {
                if (quotePriceDTO.getRiskInfo().getPoolArea().compareTo(new BigDecimal(1500)) == 1) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10613.getValue(), ChannelErrorCodeEnum.ERR_C10613.getKey());
                }
                if (quotePriceDTO.getRiskInfo().getWaterDepth().compareTo(new BigDecimal(2)) == 1) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10614.getValue(), ChannelErrorCodeEnum.ERR_C10614.getKey());
                }
            }
        }
        channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("verifySocialSecurity");
        channelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
        ApisChannelConfigs configsSocialSecurity = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)configsSocialSecurity)) {
            for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
                if (!StringUtil.isNullOrEmpty((String)insuredIdvDTO.getSocialSecurityFlag())) continue;
                throw new ApisBusinessException("\u662f\u5426\u6709\u793e\u4fdd\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10467.getKey());
            }
        }
        this.zhenaiDiscountValid(standerRequest);
        this.verifyJybbwyl(standerRequest, apisPfpRationMainList);
        this.verifyOverSeasStudentsAge(quotePriceDTO);
    }

    private void verifyOverSeasStudentsAge(QuotePriceDTO quotePriceDTO) throws ApisBusinessException {
        String rationCode = ((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        if (!"LXSBCYLBX".equals(rationCode)) {
            return;
        }
        List insuredIdvList = quotePriceDTO.getCoverage().getInsuredIdvList();
        for (InsuredIdvDTO insuredIdvDTO : insuredIdvList) {
            int age = this.dataCompletionUtil.calculateAge(quotePriceDTO.getMain().getStartDate(), insuredIdvDTO.getBirthday());
            if (age >= 17 && age <= 25) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10721.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10721.getKey());
        }
    }

    private void verifyJybbwyl(StanderRequest standerRequest, List<ApisPfpRationMain> apisPfpRationMainList) throws ApisBusinessException {
        String[] rationCodes;
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode("RATION_CODE_JYBBWYL");
        ApisChannelConfigs jybbwylConfig = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        if (ObjectUtil.isNotEmpty((Object)jybbwylConfig) && Arrays.asList(rationCodes = jybbwylConfig.getConfigValue().split(",")).contains(apisPfpRationMainList.get(0).getRationCode())) {
            QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
            List appliClientList = quotePriceDTO.getAppliClient();
            List insuredIdvDTOList = quotePriceDTO.getCoverage().getInsuredIdvList();
            boolean flag = false;
            block0: for (AppliClientDTO appliClientDTO : appliClientList) {
                for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
                    if (!appliClientDTO.getIdentifyNumber().equals(insuredIdvDTO.getIdentifyNumber())) continue;
                    flag = true;
                    continue block0;
                }
            }
            if (!flag) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10683.getValue(), ChannelErrorCodeEnum.ERR_C10683.getKey());
            }
            if (rationCodes[1].equals(apisPfpRationMainList.get(0).getRationCode())) {
                boolean sixTyFlag = false;
                for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
                    Integer age = this.dataCompletionUtil.calculateAge(quotePriceDTO.getMain().getStartDate(), insuredIdvDTO.getBirthday());
                    if (age <= 60) continue;
                    sixTyFlag = true;
                    break;
                }
                if (!sixTyFlag) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10684.getValue(), ChannelErrorCodeEnum.ERR_C10684.getKey());
                }
            }
        }
    }

    public void zhenaiDiscountValid(StanderRequest standerRequest) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        MainDTO mainDTO = quotePriceDTO.getMain();
        List idvList = quotePriceDTO.getCoverage().getInsuredIdvList();
        if (ObjectUtil.isEmpty((Object)idvList)) {
            return;
        }
        for (InsuredIdvDTO idv : idvList) {
            ItemMainDTO apisItMain = this.getItemMainDTOByNo(idv.getItemNo().intValue(), quotePriceDTO.getCoverage().getItemList());
            if (ObjectUtil.isEmpty((Object)apisItMain)) continue;
            ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
            channelConfigsCondition.setConfigCode("zhenaiDiscount");
            ApisChannelConfigs configsDiscount = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
            if (!ObjectUtil.isNotEmpty((Object)configsDiscount) || !StringUtils.isNotEmpty((CharSequence)configsDiscount.getConfigValue()) || !Arrays.asList(configsDiscount.getConfigValue().split(",")).contains(apisItMain.getGoodsCode())) continue;
            if (mainDTO.getInputDate().compareTo(configsDiscount.getExpireDate()) < 0) {
                List oldItemList;
                if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPolicyDTO()) && ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPolicyDTO().getCoverage()) && ObjectUtil.isNotEmpty((Object)(oldItemList = quotePriceDTO.getPolicyDTO().getCoverage().getItemList()))) {
                    boolean flag = false;
                    block1: for (ItemMainDTO itemdto : oldItemList) {
                        List oldIdvList = itemdto.getInsuredIdvList();
                        if (!ObjectUtil.isNotEmpty((Object)oldIdvList)) continue;
                        for (InsuredIdvDTO oldDto : oldIdvList) {
                            if (!oldDto.getIdentifyNumber().equals(idv.getIdentifyNumber())) continue;
                            ApisChannelConfigs oldConfig = new ApisChannelConfigs();
                            oldConfig.setConfigCode("oldDiscountPlan");
                            if (!ObjectUtil.isNotEmpty((Object)(oldConfig = this.apisChannelConfigsService.getChannelConfig(oldConfig))) || !StringUtils.isNotEmpty((CharSequence)oldConfig.getConfigValue()) || !ObjectUtil.isNotEmpty((Object)oldDto.getPlanCode()) || !Arrays.asList(oldConfig.getConfigValue().split(",")).contains(oldDto.getPlanCode())) continue;
                            flag = true;
                            continue block1;
                        }
                    }
                    if (flag) continue;
                }
                if ("1".equals(quotePriceDTO.getRenewal().getAutoTransRenewFlag())) {
                    if (StringUtils.isEmpty((CharSequence)quotePriceDTO.getRenewal().getAccount()) || StringUtils.isEmpty((CharSequence)quotePriceDTO.getRenewal().getAccountName())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10659.getValue(), ChannelErrorCodeEnum.ERR_C10659.getKey());
                    }
                    return;
                }
                if ("1".equals(mainDTO.getRenewalFlag()) || "underwrit".equals(standerRequest.getHeader().getBussinessType()) && StringUtils.isNotBlank((CharSequence)mainDTO.getRenewalPolicyNo())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10663.getValue(), ChannelErrorCodeEnum.ERR_C10663.getKey());
                }
                if (idv.getAge() <= 35) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10660.getValue(), ChannelErrorCodeEnum.ERR_C10660.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10658.getValue(), ChannelErrorCodeEnum.ERR_C10658.getKey());
        }
    }

    private ItemMainDTO getItemMainDTOByNo(int no, List<ItemMainDTO> itemMainDTOList) {
        if (ObjectUtil.isEmpty(itemMainDTOList)) {
            return null;
        }
        for (ItemMainDTO dto : itemMainDTOList) {
            if (dto.getItemNo() != no) continue;
            return dto;
        }
        return null;
    }

    public void checkIsOption(List<ItemMainDTO> itemMainDTOList) throws ApisBusinessException {
        HashMap totalItemList = new HashMap();
        for (ItemMainDTO it : itemMainDTOList) {
            ArrayList<ItemKindDTO> itemKindDTOS = new ArrayList<ItemKindDTO>();
            ArrayList<String> kindCodeList = new ArrayList<String>();
            for (ItemKindDTO ik : it.getItemKind()) {
                if (kindCodeList.contains(ik.getClauseCode() + "-" + ik.getKindCode())) continue;
                itemKindDTOS.add(ik);
                kindCodeList.add(ik.getClauseCode() + "-" + ik.getKindCode());
            }
            totalItemList.put(it.getGoodsCode(), itemKindDTOS);
        }
        for (ItemMainDTO it : itemMainDTOList) {
            if (this.compare(it.getItemKind(), (List)totalItemList.get(it.getGoodsCode()))) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10652.getValue(), ChannelErrorCodeEnum.ERR_C10652.getKey());
        }
    }

    public boolean compare(List<ItemKindDTO> a, List<ItemKindDTO> b) {
        ArrayList<ItemKindDTO> list1 = new ArrayList<ItemKindDTO>();
        list1.addAll(b);
        block0: for (ItemKindDTO ika : a) {
            for (ItemKindDTO ikb : list1) {
                if (!ika.getKindCode().equals(ikb.getKindCode()) || !ika.getClauseCode().equals(ikb.getClauseCode()) || ika.getSumInsured().compareTo(ikb.getSumInsured()) != 0) continue;
                list1.remove(ikb);
                continue block0;
            }
        }
        return list1.size() == 0;
    }

    public static boolean isOutOneYear(Date start, Date end, boolean yearFlag) {
        long yearDays = 365L;
        if (start.after(end)) {
            return false;
        }
        Calendar startDay = Calendar.getInstance();
        Calendar endDay = Calendar.getInstance();
        startDay.setTime(start);
        endDay.setTime(end);
        long month = startDay.get(2) + 1;
        int year = month < 3L ? startDay.get(1) : endDay.get(1);
        if (DateUtil.isLeapYear((int)year)) {
            yearDays = 366L;
        }
        endDay.add(12, 1);
        long time = endDay.getTimeInMillis() - startDay.getTimeInMillis();
        long yearTime = DateUnit.DAY.getMillis() * yearDays + DateUnit.MINUTE.getMillis();
        if (time > yearTime) {
            return false;
        }
        return !yearFlag || yearTime - time <= DateUnit.MINUTE.getMillis();
    }

    private void validateIsRepeatDate(List<InsuredIdvDTO> insuredIdvDTOList) throws ApisBusinessException {
        for (int i = 0; i < insuredIdvDTOList.size(); ++i) {
            InsuredIdvDTO insuredIdvDTO = insuredIdvDTOList.get(i);
            for (int j = i + 1; j < insuredIdvDTOList.size(); ++j) {
                InsuredIdvDTO idvDTO = insuredIdvDTOList.get(j);
                if (insuredIdvDTO.getItemNo() != idvDTO.getItemNo() && insuredIdvDTO.getIdentifyNumber().equals(idvDTO.getIdentifyNumber()) && insuredIdvDTO.getEndDate().after(idvDTO.getStartDate())) {
                    throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u3010" + insuredIdvDTO.getInsuredName() + "\u3011\u6709\u91cd\u590d\u4fdd\u9669\u533a\u95f4", ChannelErrorCodeEnum.ERR_C10111.getKey());
                }
                if (insuredIdvDTO.getItemNo() != idvDTO.getItemNo() || !insuredIdvDTO.getIdentifyNumber().equals(idvDTO.getIdentifyNumber())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10420.getValue(), ChannelErrorCodeEnum.ERR_C10420.getKey());
            }
        }
    }

    public void validateRquestGroup(StanderRequest standerRequest) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        String planCode = ((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        ApisPfpRationMain apisPfpRationMain = this.dataCompletionUtil.getApisPfpRationMainInfo(planCode, "2");
        this.validNull(standerRequest, apisPfpRationMain);
        this.validFormatGroup(standerRequest, apisPfpRationMain);
        this.validProductGroup(standerRequest, apisPfpRationMain);
        this.validJdUser(standerRequest, apisPfpRationMain);
        this.validJdAddr(standerRequest, apisPfpRationMain);
    }

    public void validFormatGroup(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        String regexEnName;
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        StanderHeader header = standerRequest.getHeader();
        List appliClientList = quotePriceDTO.getAppliClient();
        MainDTO mainDTO = quotePriceDTO.getMain();
        if (!DateUtils.dateToStr((Date)mainDTO.getStartDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "startDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
        }
        if (!DateUtils.dateToStr((Date)mainDTO.getEndDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "endDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
        }
        String regexName = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_NAME", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        if (StringUtils.isBlank((CharSequence)regexName) || "NoData".equalsIgnoreCase(regexName)) {
            regexName = GeneralRegxs.Name_2;
        }
        if (StringUtils.isBlank((CharSequence)(regexEnName = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_NAME_EN", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code))) || "NoData".equalsIgnoreCase(regexEnName)) {
            regexEnName = GeneralRegxs.Ename;
        }
        boolean isValidEname = StringUtils.isNotBlank((CharSequence)regexEnName) && !"NoCheck".equals(regexEnName);
        String regexContactInfo = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_CONTACT_INFO", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        String regexMobileNo = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_MOBILE_NO", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        String regexContactPhone = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_CONTACT_PHONE", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        boolean isValidContactInfoFormat = StringUtils.isNotBlank((CharSequence)regexContactInfo) && !"NoData".equalsIgnoreCase(regexContactInfo) && !"NoCheck".equalsIgnoreCase(regexContactInfo);
        boolean isValidMobileNoFormat = StringUtils.isNotBlank((CharSequence)regexMobileNo) && !"NoData".equalsIgnoreCase(regexMobileNo) && !"NoCheck".equalsIgnoreCase(regexMobileNo);
        boolean isValidContactPhone = StringUtils.isNotBlank((CharSequence)regexContactPhone) && !"NoData".equalsIgnoreCase(regexContactPhone) && !"NoCheck".equalsIgnoreCase(regexContactPhone);
        for (AppliClientDTO appliClientDTO : appliClientList) {
            if (Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode()) && !"NoCheck".equalsIgnoreCase(regexName) && StringUtils.isNotEmpty((CharSequence)appliClientDTO.getInsuredName()) && !appliClientDTO.getInsuredName().trim().replace(" ", "").matches(regexName)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10477.getValue().replaceFirst("##", appliClientDTO.getInsuredName()).replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10477.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getInsuredEname()) && isValidEname && !appliClientDTO.getInsuredEname().trim().matches(regexEnName)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10619.getValue().replaceFirst("##", appliClientDTO.getInsuredEname()), ChannelErrorCodeEnum.ERR_C10619.getKey());
            }
            if ("1".equals(appliClientDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_PERSONAL).contains(appliClientDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("2".equals(appliClientDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_COMPANY).contains(appliClientDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("01".equals(appliClientDTO.getIdentifyType()) || "13".equals(appliClientDTO.getIdentifyType())) {
                if (StringUtils.isNotBlank((CharSequence)appliClientDTO.getIdentifyNumber()) && !IdcardUtil.isValidCard((String)appliClientDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10073.getValue().replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10073.getKey());
                }
                String birthDateStr = IdcardUtil.getBirth((String)appliClientDTO.getIdentifyNumber());
                if (ObjectUtil.isNotEmpty((Object)appliClientDTO.getBirthday())) {
                    String birthDay = DateUtils.dateToStr((Date)appliClientDTO.getBirthday(), (String)"yyyyMMdd");
                    if (!birthDateStr.equals(birthDay)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10240.getValue().replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10240.getKey());
                    }
                } else {
                    try {
                        appliClientDTO.setBirthday(DateUtils.parseToDate((String)birthDateStr, (String)"yyyyMMdd"));
                    }
                    catch (Exception e) {
                        log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getSex())) {
                    appliClientDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)appliClientDTO.getIdentifyNumber()) == 1 ? 1 : 2));
                } else if (!appliClientDTO.getSex().equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)appliClientDTO.getIdentifyNumber()) == 1 ? 1 : 2))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10616.getValue(), ChannelErrorCodeEnum.ERR_C10616.getKey());
                }
            } else {
                IdNumberUtil.ClientType clientType = null;
                if ("1".equals(appliClientDTO.getInsuredType())) {
                    clientType = IdNumberUtil.ClientType.PERSONAL;
                } else if ("2".equals(appliClientDTO.getInsuredType())) {
                    clientType = IdNumberUtil.ClientType.CLIENT;
                }
                this.validateIdNumberByIdType(appliClientDTO.getIdentifyType(), appliClientDTO.getIdentifyNumber(), mainDTO.getRiskCode(), IdNumberUtil.PersonnelType.HOLDER, clientType, header.getChannelCode(), header.getUserCode());
            }
            if (isValidContactInfoFormat) {
                if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getMobile()) && !appliClientDTO.getMobile().matches(regexContactInfo)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", appliClientDTO.getMobile()), ChannelErrorCodeEnum.ERR_C10618.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getContactPhone()) && isValidMobileNoFormat && StringUtils.isNotEmpty((CharSequence)appliClientDTO.getMobile()) && !appliClientDTO.getMobile().matches(regexMobileNo)) {
                    appliClientDTO.setContactPhone(appliClientDTO.getMobile());
                    appliClientDTO.setMobile(null);
                }
            }
            if (isValidContactPhone && StringUtils.isNotEmpty((CharSequence)appliClientDTO.getContactPhone()) && !appliClientDTO.getContactPhone().matches(regexContactPhone)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", appliClientDTO.getContactPhone()), ChannelErrorCodeEnum.ERR_C10618.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getEmail()) && !appliClientDTO.getEmail().matches(GeneralRegxs.Email)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10132.getValue(), ChannelErrorCodeEnum.ERR_C10132.getKey());
            }
            if (!StringUtils.isNotEmpty((CharSequence)appliClientDTO.getTaxPayerId()) || appliClientDTO.getTaxPayerId().matches(GeneralRegxs.TaxpayerId)) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10478.getValue(), ChannelErrorCodeEnum.ERR_C10478.getKey());
        }
    }

    public void validProductGroup(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        StanderHeader standerHeader = standerRequest.getHeader();
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        MainDTO mainDTO = quotePriceDTO.getMain();
        Date startDate = mainDTO.getStartDate();
        if (startDate.after(mainDTO.getEndDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10067.getValue(), ChannelErrorCodeEnum.ERR_C10067.getKey());
        }
        ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("backSign");
        channelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
        ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (ObjectUtil.isEmpty((Object)channelConfigs) && startDate.before(new Date()) && "1".equals(this.backSignSwitch)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10035.getValue(), ChannelErrorCodeEnum.ERR_C10035.getKey());
        }
        if (!QuotePriceValidate.isOutOneYear((Date)startDate, (Date)mainDTO.getEndDate(), (boolean)false)) {
            if (Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10040.getValue(), ChannelErrorCodeEnum.ERR_C10040.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10068.getValue(), ChannelErrorCodeEnum.ERR_C10068.getKey());
        }
        for (AppliClientDTO appliClientDTO : appliClientList) {
            long year;
            if (!"1".equals(appliClientDTO.getInsuredType())) continue;
            ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
            apisChannelConfigsCondition.setConfigCode("MINOR_INSURE_PLANS");
            apisChannelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
            apisChannelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
            ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
            if (!ObjectUtil.isEmpty((Object)apisChannelConfigs) || !ObjectUtil.isNotEmpty((Object)appliClientDTO.getBirthday()) || (year = (long)this.dataCompletionUtil.calculateAge(startDate, appliClientDTO.getBirthday())) >= 18L) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10124.getValue(), ChannelErrorCodeEnum.ERR_C10124.getKey());
        }
        channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("ONE_INSURED");
        channelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
        ApisChannelConfigs configsOneInsured = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
        channelConfigsCondition.setConfigCode("ONE_STEP_ISSUE_CODE");
        ApisChannelConfigs apisChannelConfigsO = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (StringUtils.isNotEmpty((CharSequence)mainDTO.getOutPaymentType())) {
            if ("0".equals(mainDTO.getJFeeFlag())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10471.getValue(), ChannelErrorCodeEnum.ERR_C10471.getKey());
            }
            if (ObjectUtil.isEmpty((Object)apisChannelConfigsO)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10443.getValue(), ChannelErrorCodeEnum.ERR_C10443.getKey());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigsO) && "1".equals(mainDTO.getStepFlag()) && (StringUtils.isEmpty((CharSequence)mainDTO.getOutPaymentType()) || StringUtils.isEmpty((CharSequence)mainDTO.getAccountCode())) && "1".equals(mainDTO.getRenewalFlag()) && ObjectUtil.isNotEmpty((Object)standerRequest.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform()) && !standerRequest.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform().booleanValue()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10470.getValue(), ChannelErrorCodeEnum.ERR_C10470.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPayPlanList()) && quotePriceDTO.getPayPlanList().size() > 1 && StringUtils.isEmpty((CharSequence)quotePriceDTO.getMain().getTurnInsureType()) && "0".equals(mainDTO.getRenewalFlag())) {
            Calendar calendar = Calendar.getInstance();
            ApisChannelConfigs installmentConfig = new ApisChannelConfigs();
            installmentConfig.setConfigCode("Installment_back");
            installmentConfig.setUserCode(standerHeader.getUserCode());
            ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(installmentConfig);
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs)) {
                String[] dayArr = apisChannelConfigs.getConfigValue().split(",");
                boolean passFlag = true;
                for (int i = 0; i < dayArr.length; ++i) {
                    calendar.setTime(mainDTO.getInputDate());
                    calendar.add(5, Integer.parseInt(dayArr[i]));
                    long a = Long.parseLong(DateUtils.dateToStr((Date)quotePriceDTO.getMain().getStartDate(), (String)"yyyyMMddHHmmss"));
                    long b = Long.parseLong(DateUtils.dateToStr((Date)calendar.getTime(), (String)"yyyyMMdd") + "000000");
                    if (a != b) continue;
                    passFlag = false;
                    break;
                }
                if (passFlag) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10452.getValue(), ChannelErrorCodeEnum.ERR_C10452.getKey());
                }
            } else {
                calendar.setTime(mainDTO.getInputDate());
                calendar.add(5, 1);
                long a = Long.parseLong(DateUtils.dateToStr((Date)quotePriceDTO.getMain().getStartDate(), (String)"yyyyMMddHHmmss"));
                long b = Long.parseLong(DateUtils.dateToStr((Date)calendar.getTime(), (String)"yyyyMMdd") + "000000");
                if (a != b) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10452.getValue(), ChannelErrorCodeEnum.ERR_C10452.getKey());
                }
            }
        }
        if (RiskCodeEnum.getType((String)mainDTO.getRiskCode()) == 3 && ObjectUtil.isNotEmpty((Object)quotePriceDTO.getRiskInfo())) {
            if ("01".equals(quotePriceDTO.getRiskInfo().getUnderwritingType()) && quotePriceDTO.getRiskInfo().getSiteArea().compareTo(new BigDecimal(10000)) == 1) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10610.getValue(), ChannelErrorCodeEnum.ERR_C10610.getKey());
            }
            if ("02".equals(quotePriceDTO.getRiskInfo().getUnderwritingType())) {
                if (quotePriceDTO.getRiskInfo().getSiteArea().compareTo(new BigDecimal(10000)) == 1) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10610.getValue(), ChannelErrorCodeEnum.ERR_C10610.getKey());
                }
                if (Integer.parseInt(quotePriceDTO.getRiskInfo().getPeopleNumber()) > 2000) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10611.getValue(), ChannelErrorCodeEnum.ERR_C10611.getKey());
                }
                long days = DateUtils.getDays((String)DateUtils.dateToStr((Date)mainDTO.getEndDate()), (String)DateUtils.dateToStr((Date)mainDTO.getStartDate()));
                SimpleDateFormat formatter = new SimpleDateFormat("HHmmss");
                Integer endHm = Integer.parseInt(formatter.format(mainDTO.getEndDate()));
                if (endHm >= 235900) {
                    ++days;
                }
                if (days > 30L) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10612.getValue(), ChannelErrorCodeEnum.ERR_C10612.getKey());
                }
            }
            if ("03".equals(quotePriceDTO.getRiskInfo().getUnderwritingType())) {
                if (quotePriceDTO.getRiskInfo().getPoolArea().compareTo(new BigDecimal(1500)) == 1) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10613.getValue(), ChannelErrorCodeEnum.ERR_C10613.getKey());
                }
                if (quotePriceDTO.getRiskInfo().getWaterDepth().compareTo(new BigDecimal(2)) == 1) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10614.getValue(), ChannelErrorCodeEnum.ERR_C10614.getKey());
                }
            }
        }
    }
}

