/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RedisTemplateUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.ClaimListQueryServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.ClaimQueryInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.ClaimListInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PlanDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PlanDetailQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PlanDetailQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RenewablePolicyListQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RenewablePolicyListQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyListDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.RenewablePolicyListQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.CommissionQueryDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.resp.AgentQueryResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisBusiRenewal;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.impl.ApisBusiRenewalServiceImpl;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RenewalQueryUtil {
    private static final Logger log = LoggerFactory.getLogger(RenewalQueryUtil.class);
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisBusiRenewalServiceImpl apisBusiRenewalService;
    @Autowired
    private ApisBusinessService apisBusinessService;
    private static final String RENEWAL_FLAG_Y = "Y";
    private static final String RENEWAL_FLAG_N = "N";
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    private ApisPfpRationMainService apisPfpRationMainService;
    private static final String PLAN_DETAIL_QUERY = "planDetailQuery";
    @Autowired
    private RedisTemplateUtil redisTemplateUtil;
    @Autowired
    private QuotePriceValidate quotePriceValidate;
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;

    public void completeRenewal(PolicyListDTO policyListDTO, StanderRequest request) throws ApisBusinessException {
        ArrayList planDTOS = new ArrayList();
        List renewalGoodsList = new ArrayList();
        this.checkPolicy(policyListDTO);
        this.policyVerify(request, policyListDTO, "1001");
        this.completeClaimFlag(policyListDTO, request);
        renewalGoodsList = this.apisBusiRenewalService.getApisBusiRenewals(((ItemMainDTO)policyListDTO.getCoverage().getItemList().get(0)).getGoodsCode());
        log.warn("\u5546\u54c1\u8868size():{}", (Object)renewalGoodsList.size());
        if (ObjectUtils.isNotEmpty(renewalGoodsList) || renewalGoodsList.size() > 0) {
            List apisPfpRationMainList;
            boolean isOpen;
            log.warn("\u5546\u54c1\u53ef\u7eed\u4fdd");
            policyListDTO.setRenewalFlag(RENEWAL_FLAG_Y);
            ApisPfpRationMain apisPfpRationMain = new ApisPfpRationMain();
            QueryWrapper queryWrapper = new QueryWrapper((Object)apisPfpRationMain);
            ArrayList<String> rationCodes = new ArrayList<String>();
            String configValue = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("RQ_QRY_COMMISSION_CLOSE", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
            boolean bl = isOpen = !"1".equals(configValue);
            if (StringUtils.isNotBlank((CharSequence)((ApisBusiRenewal)renewalGoodsList.get(0)).getOutSeciInsuSelUpgGosCods())) {
                String[] outSeciInsuSelUpgGosCods = ((ApisBusiRenewal)renewalGoodsList.get(0)).getOutSeciInsuSelUpgGosCods().split(",");
                rationCodes.addAll(new ArrayList<String>(Arrays.asList(outSeciInsuSelUpgGosCods)));
                apisPfpRationMainList = this.apisPfpRationMainService.findRationInfoByRationCodes(rationCodes);
                if (isOpen && ObjectUtil.isNotEmpty((Object)apisPfpRationMainList)) {
                    apisPfpRationMainList = this.commissionQueryByRationCodes(apisPfpRationMainList, StringUtils.isNotBlank((CharSequence)policyListDTO.getAgentCode()) ? policyListDTO.getAgentCode() : request.getHeader().getChannelCode());
                }
                this.setPlanDTO(planDTOS, apisPfpRationMainList, RENEWAL_FLAG_N, policyListDTO);
            }
            if (StringUtils.isNotBlank((CharSequence)((ApisBusiRenewal)renewalGoodsList.get(0)).getInSeciInsuSelUpgGosCods())) {
                String[] inSeciInsuSelUpgGosCods = ((ApisBusiRenewal)renewalGoodsList.get(0)).getInSeciInsuSelUpgGosCods().split(",");
                rationCodes.addAll(new ArrayList<String>(Arrays.asList(inSeciInsuSelUpgGosCods)));
                apisPfpRationMainList = this.apisPfpRationMainService.findRationInfoByRationCodes(rationCodes);
                if (isOpen && ObjectUtil.isNotEmpty((Object)apisPfpRationMainList)) {
                    apisPfpRationMainList = this.commissionQueryByRationCodes(apisPfpRationMainList, StringUtils.isNotBlank((CharSequence)policyListDTO.getAgentCode()) ? policyListDTO.getAgentCode() : request.getHeader().getChannelCode());
                }
                this.setPlanDTO(planDTOS, apisPfpRationMainList, RENEWAL_FLAG_Y, policyListDTO);
            }
            if (ObjectUtil.isNotEmpty(planDTOS)) {
                String goodsCode = ((ApisBusiRenewal)renewalGoodsList.get(0)).getGoodsCode();
                List originPlanCodeList = planDTOS.stream().filter(pd -> null != pd && goodsCode.contains(pd.getGoodsCode())).collect(Collectors.toList());
                if (ObjectUtil.isNotEmpty(originPlanCodeList)) {
                    planDTOS.remove(originPlanCodeList.get(0));
                    planDTOS.add(0, originPlanCodeList.get(0));
                }
            }
            if (ObjectUtil.isEmpty(planDTOS) || planDTOS.size() == 0) {
                policyListDTO.setRenewalFlag(RENEWAL_FLAG_N);
            }
        } else {
            policyListDTO.setRenewalFlag(RENEWAL_FLAG_N);
            log.warn("\u5546\u54c1\u4e0d\u53ef\u7eed\u4fdd{}", (Object)policyListDTO.getRenewalFlag());
            return;
        }
    }

    private void setPlanDTO(List<PlanDTO> planDTOS, List<ApisPfpRationMain> apisPfpRationMainList, String n, PolicyListDTO policyListDTO) throws ApisBusinessException {
        if (ObjectUtils.isNotEmpty(apisPfpRationMainList) && apisPfpRationMainList.size() > 0) {
            for (ApisPfpRationMain apisPfpRationMain1 : apisPfpRationMainList) {
                boolean ageFlag = this.verifyAge(policyListDTO, apisPfpRationMain1);
                if (!ageFlag) continue;
                PlanDTO planDTO = PlanDTO.builder().build();
                planDTO.setGoodsCode(apisPfpRationMain1.getRationCode());
                planDTO.setGoodsName(apisPfpRationMain1.getRationName());
                planDTO.setGroupPlanName(apisPfpRationMain1.getProductName());
                planDTO.setSocialInsuranceFlag(n);
                planDTOS.add(planDTO);
            }
        }
    }

    private boolean verifyAge(PolicyListDTO policyListDTO, ApisPfpRationMain apisPfpRationMainInfo) throws ApisBusinessException {
        List insuredIdvList = policyListDTO.getInsuredList();
        for (InsuredDTO insured : insuredIdvList) {
            long age = this.getInsuredIdvAge(insured, policyListDTO);
            if (apisPfpRationMainInfo.getRenewableMaxAge() != null && !apisPfpRationMainInfo.getRenewableMaxAge().equals(0)) {
                if (age <= (long)Integer.valueOf(apisPfpRationMainInfo.getRenewableMaxAge()).intValue()) continue;
                log.warn("\u7eed\u4fdd\u4eba\u5e74\u9f84:{},\u8d85\u8fc7\u6700\u5927\u5e74\u9f84:{}", (Object)age, (Object)apisPfpRationMainInfo.getRenewableMaxAge());
                return false;
            }
            if (age <= (long)Integer.valueOf(apisPfpRationMainInfo.getAgeMax()).intValue()) continue;
            log.warn("\u7eed\u4fdd\u4eba\u5e74\u9f84:{},\u8d85\u8fc7\u6700\u5927\u5e74\u9f84:{}", (Object)age, (Object)apisPfpRationMainInfo.getAgeMax());
            return false;
        }
        return true;
    }

    private long getInsuredIdvAge(InsuredDTO insured, PolicyListDTO policyListDTO) throws ApisBusinessException {
        long age = 0L;
        try {
            if (ObjectUtil.isEmpty((Object)insured.getAge())) {
                Date newStartDate;
                DateTime startDate;
                Date maxDate = new Date();
                if (ObjectUtil.isNotEmpty((Object)policyListDTO) && ObjectUtil.isNotEmpty((Object)policyListDTO.getStartDateStr()) && ObjectUtil.isNotEmpty((Object)(startDate = DateUtil.parse((CharSequence)policyListDTO.getStartDateStr(), (String)"yyyy-MM-dd HH:mm:ss"))) && (newStartDate = DateUtils.addYears((Date)startDate, (int)1)).after(maxDate)) {
                    log.warn("\u7eed\u4fdd\u4fdd\u5355\u7684\u8d77\u4fdd\u65f6\u95f4\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
                    maxDate = newStartDate;
                }
                if (ObjectUtil.isNotEmpty((Object)insured.getBirthday())) {
                    age = DateUtil.betweenYear((Date)insured.getBirthday(), (Date)maxDate, (boolean)false);
                } else if (ObjectUtil.isNotEmpty((Object)insured.getIdentifyNumber()) && "01".equals(insured.getIdentifyType())) {
                    String birthdayStr = insured.getIdentifyNumber().substring(6, 14);
                    Date birthday = DateUtil.parse((CharSequence)birthdayStr, (String)"yyyyMMdd").toJdkDate();
                    age = DateUtil.betweenYear((Date)birthday, (Date)maxDate, (boolean)false);
                }
            } else {
                age = insured.getAge() + 1;
            }
        }
        catch (Exception e) {
            log.error("\u7eed\u4fdd\u89c4\u5219\u6821\u9a8c--\u300b\u8ba1\u7b97\u88ab\u4fdd\u4eba\u5e74\u9f84\u5931\u8d25\u3002", (Throwable)e);
        }
        return age;
    }

    public boolean isRenewableFlag(StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("renewablePolicyListQuery", request);
            if (resp == null || resp.getHeader() == null || resp.getRenewablePolicyListQueryResponse() == null || resp.getRenewablePolicyListQueryResponse().getResponseBody() == null || resp.getRenewablePolicyListQueryResponse().getResponseHead() == null) {
                log.error("\u8c03\u7528\u53ef\u7eed\u4fdd\u6e05\u5355\u63a5\u53e3\u9519\u8bef");
                return false;
            }
            if (ObjectUtils.isNotEmpty((Object)resp.getRenewablePolicyListQueryResponse().getResponseBody().getPolicyList()) && resp.getRenewablePolicyListQueryResponse().getResponseBody().getPolicyList().size() > 0) {
                return true;
            }
        }
        catch (ApisBusinessException e) {
            log.error("\u8c03\u7528\u53ef\u7eed\u4fdd\u6e05\u5355\u63a5\u53e3\u9519\u8bef", (Throwable)e);
        }
        return false;
    }

    private void completePlanDetail(PolicyDTO policyDTO, StanderRequest request) {
        String goodsCode = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        if (StringUtils.isEmpty((CharSequence)goodsCode)) {
            log.error("\u4fdd\u5355\u6ca1\u6709\u8ba1\u5212 \uff1a{}");
            return;
        }
        PlanDetailQueryRequest planDetailQueryRequest = PlanDetailQueryRequest.builder().build();
        PlanDetailQueryRequestDTO planDetailQueryRequestDTO = PlanDetailQueryRequestDTO.builder().build();
        planDetailQueryRequestDTO.setPlanCode(goodsCode);
        planDetailQueryRequest.setRequestBody(planDetailQueryRequestDTO);
        request.setPlanDetailQueryRequest(planDetailQueryRequest);
        try {
            TimeInterval timer = DateUtil.timer();
            StanderResponse resp = this.apisBusinessService.execute(PLAN_DETAIL_QUERY, request);
            log.warn("\u8c03\u7528\u8ba1\u5212\u660e\u7ec6\u63a5\u53e3\u7528\u65f6{}", (Object)timer.intervalRestart());
            if (ObjectUtils.isNotEmpty((Object)resp) && ObjectUtils.isNotEmpty((Object)resp.getPlanDetailQueryResponse())) {
                policyDTO.setPlanDetail(resp.getPlanDetailQueryResponse().getResponseBody());
            } else {
                log.error("\u6ca1\u6709\u5bf9\u5e94\u8ba1\u5212\u7684\u8ba1\u5212\u660e\u7ec6 :{}");
            }
        }
        catch (ApisBusinessException e) {
            log.error("\u83b7\u53d6\u8ba1\u5212\u660e\u7ec6\u62a5\u9519 :{}", (Object)e.getMessage());
        }
    }

    private List<ApisPfpRationMain> commissionQueryByRationCodes(List<ApisPfpRationMain> rationCodes, String agencyCode) {
        ArrayList<ApisPfpRationMain> ret = null;
        if (rationCodes.size() > 0) {
            CommissionQueryDTO commissionQueryDTO = new CommissionQueryDTO();
            commissionQueryDTO.setAgentCode(agencyCode);
            ret = new ArrayList<ApisPfpRationMain>();
            for (int i = 0; i < rationCodes.size(); ++i) {
                ApisPfpRationMain rc = rationCodes.get(i);
                log.warn("\u6e20\u9053\u4ee3\u7801:{}, \u8ba1\u5212\u4ee3\u7801\uff1a{}, \u4ea7\u54c1\u4ee3\u7801\uff1a{}\uff0crelateRationCode\uff1a{}", new Object[]{agencyCode, rc.getRationCode(), rc.getProductCode(), rc.getRelateRationCode()});
                commissionQueryDTO.setPlanCode(rc.getRationCode());
                commissionQueryDTO.setProductCode(rc.getRelateRationCode());
                commissionQueryDTO.setRiskCode(rc.getProductCode());
                AgentQueryResponseDTO commissionQueryResponseDTO = this.coreInsureApi.commissionQuery(commissionQueryDTO);
                if (ObjectUtil.isEmpty((Object)commissionQueryResponseDTO) || !"0000".equals(commissionQueryResponseDTO.getHead().getAppCode()) || ObjectUtils.isEmpty((Object)commissionQueryResponseDTO.getData())) {
                    if (ObjectUtil.isNotEmpty((Object)commissionQueryResponseDTO) && ObjectUtils.isNotEmpty((Object)commissionQueryResponseDTO.getHead())) {
                        log.error("\u8c03\u7528\u9500\u7ba1\u63a5\u53e3\u51fa\u9519\uff1a{}", (Object)commissionQueryResponseDTO.getHead().getAppMessage());
                        continue;
                    }
                    log.error("\u8c03\u7528\u9500\u7ba1\u63a5\u53e3\u51fa\u9519\uff1a{}", (Object)ErrorNullValueCodeEnum.ERR_N10002.getValue());
                    continue;
                }
                ret.add(rc);
            }
        }
        return ret;
    }

    private void completeClaimFlag(PolicyListDTO policyListDTO, StanderRequest request) throws ApisBusinessException {
        StanderResponse response = null;
        ClaimListQueryServiceRequest claimListQueryServiceRequest = ClaimListQueryServiceRequest.builder().build();
        RequestHeadDTO requestHeadDTO = RequestHeadDTO.builder().build();
        ClaimQueryInfoDTO claimQueryInfoDTO = ClaimQueryInfoDTO.builder().build();
        if (StringUtils.isEmpty((CharSequence)policyListDTO.getPolicyNo())) {
            return;
        }
        claimQueryInfoDTO.setPolicyNo(policyListDTO.getPolicyNo());
        claimListQueryServiceRequest.setHead(requestHeadDTO);
        claimListQueryServiceRequest.setBody(claimQueryInfoDTO);
        request.setClaimListQueryServiceRequest(claimListQueryServiceRequest);
        response = this.apisBusinessService.execute("claimQuery", request);
        if (response == null || response.getClaimListQueryResponse() == null || response.getClaimListQueryResponse().getBody() == null || response.getClaimListQueryResponse().getHead() == null) {
            return;
        }
        if (response.getClaimListQueryResponse().getBody().getClaimInfoList().size() > 0) {
            int claimNum = 0;
            BigDecimal sumRealPayCny = new BigDecimal(0);
            for (ClaimListInfo claimListInfo : response.getClaimListQueryResponse().getBody().getClaimInfoList()) {
                if (ObjectUtil.isNotEmpty((Object)claimListInfo.getCanceloRejectTime()) || !ObjectUtil.isNotEmpty((Object)claimListInfo.getClaimTime())) continue;
                ++claimNum;
                sumRealPayCny = sumRealPayCny.add(new BigDecimal(claimListInfo.getSumRealPayCny() == null ? 0.0 : claimListInfo.getSumRealPayCny())).setScale(2, 4);
            }
            log.warn("\u7406\u8d54\u6b21\u6570\uff1a{},\u603b\u8d54\u6b3e\uff1a{}", (Object)claimNum, (Object)sumRealPayCny);
            String planCode = ((ItemMainDTO)policyListDTO.getCoverage().getItemList().get(0)).getPlanCode();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"config_code", (Object)"RENEWAL_CONTROL_CLAIM_ZYB");
            queryWrapper.eq((Object)"config_value", (Object)planCode);
            ApisChannelConfigs apisChannelConfigs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
            if (claimNum >= 2 && sumRealPayCny.doubleValue() >= 3000.0 && ObjectUtil.isNotEmpty((Object)apisChannelConfigs)) {
                log.error(ChannelErrorCodeEnum.ERR_C10361.getValue());
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10361.getValue(), ChannelErrorCodeEnum.ERR_C10361.getKey());
            }
            policyListDTO.setClaimFlag(RENEWAL_FLAG_Y);
        } else {
            policyListDTO.setClaimFlag(RENEWAL_FLAG_N);
        }
    }

    public void checkPolicy(PolicyListDTO policyListDTO) throws ApisBusinessException {
        if (!"1".equals(policyListDTO.getPolicyStatus()) && !"4".equals(policyListDTO.getPolicyStatus())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10243.getValue(), ChannelErrorCodeEnum.ERR_C10243.getKey());
        }
        if (!"07".equals(policyListDTO.getClassCode()) && !"09".equals(policyListDTO.getClassCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10458.getValue(), ChannelErrorCodeEnum.ERR_C10458.getKey());
        }
    }

    public void policyVerify(StanderRequest request, PolicyListDTO policyListDTO, String code) throws ApisBusinessException {
        if (policyListDTO.getGiftType() != null && !policyListDTO.getGiftType().equals("0")) {
            log.warn("\u8d60\u9669\u4e0d\u80fd\u7eed\u4fdd");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10502.getValue(), ChannelErrorCodeEnum.ERR_C10502.getKey());
        }
        this.checkRation(policyListDTO, request);
        Date startTime = new Date();
        List policyList = this.executeRenewablePolicyListQuery(request, policyListDTO);
        log.warn("\u7eed\u4fdd\u67e5\u8be2\u53ef\u7eed\u4fdd\u6e05\u5355\u63a5\u53e3\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime.getTime()));
        if (StringUtils.isNotBlank((CharSequence)code) && "1002".equals(code)) {
            List renewalGoodsList = this.apisBusiRenewalService.getApisBusiRenewals(((ItemMainDTO)policyListDTO.getCoverage().getItemList().get(0)).getGoodsCode());
            log.warn("\u5546\u54c1\u8868size():{}", (Object)renewalGoodsList.size());
            if (ObjectUtils.isNotEmpty((Object)renewalGoodsList) || renewalGoodsList.size() > 0) {
                log.warn("\u5546\u54c1\u53ef\u7eed\u4fdd");
                ArrayList<String> rationCodes = new ArrayList<String>();
                rationCodes.add(((ApisBusiRenewal)renewalGoodsList.get(0)).getGoodsCode());
                if (((ApisBusiRenewal)renewalGoodsList.get(0)).getOutSeciInsuDefUpgGosCods() != null) {
                    String[] outSeciInsuDefUpgGosCods = ((ApisBusiRenewal)renewalGoodsList.get(0)).getOutSeciInsuDefUpgGosCods().split(",");
                    rationCodes.addAll(new ArrayList<String>(Arrays.asList(outSeciInsuDefUpgGosCods)));
                }
                if (((ApisBusiRenewal)renewalGoodsList.get(0)).getInSeciInsuDefUpgGosCods() != null) {
                    String[] inSeciInsuDefUpgGosCods = ((ApisBusiRenewal)renewalGoodsList.get(0)).getInSeciInsuDefUpgGosCods().split(",");
                    rationCodes.addAll(new ArrayList<String>(Arrays.asList(inSeciInsuDefUpgGosCods)));
                }
                if (((ApisBusiRenewal)renewalGoodsList.get(0)).getOutSeciInsuSelUpgGosCods() != null) {
                    String[] outSeciInsuSelUpgGosCods = ((ApisBusiRenewal)renewalGoodsList.get(0)).getOutSeciInsuSelUpgGosCods().split(",");
                    rationCodes.addAll(new ArrayList<String>(Arrays.asList(outSeciInsuSelUpgGosCods)));
                }
                if (((ApisBusiRenewal)renewalGoodsList.get(0)).getInSeciInsuSelUpgGosCods() != null) {
                    String[] inSeciInsuSelUpgGosCods = ((ApisBusiRenewal)renewalGoodsList.get(0)).getInSeciInsuSelUpgGosCods().split(",");
                    rationCodes.addAll(new ArrayList<String>(Arrays.asList(inSeciInsuSelUpgGosCods)));
                }
                String goodCode = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsCode();
                log.warn("rationCodes\uff1a{}", (Object)JSON.toJSONString(rationCodes));
                log.warn("goodCode\uff1a{}", (Object)goodCode);
                if (!rationCodes.contains(goodCode)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10511.getValue().replaceFirst("##", goodCode).replace("##", ((ItemMainDTO)policyListDTO.getCoverage().getItemList().get(0)).getGoodsCode()), ChannelErrorCodeEnum.ERR_C10511.getKey());
                }
            }
        }
    }

    private void checkRation(PolicyListDTO policyListDTO, StanderRequest request) throws ApisBusinessException {
        long day;
        MainDTO mainDTO;
        String goodsCode = ((ItemMainDTO)policyListDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        ApisPfpRationMain apisPfpRationMainInfo = this.apisPfpRationMainService.getSafeguardScheme(goodsCode);
        if (ObjectUtil.isEmpty((Object)apisPfpRationMainInfo)) {
            throw new ApisBusinessException("\u8ba1\u5212\uff1a" + goodsCode + "\u6ca1\u6709\u914d\u7f6e\u4fdd\u969c\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4", ChannelErrorCodeEnum.ERR_C10024.getKey());
        }
        if (!RENEWAL_FLAG_Y.equals(apisPfpRationMainInfo.getIsSupportRenew())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10254.getValue().replace("##", goodsCode), ChannelErrorCodeEnum.ERR_C10254.getKey());
        }
        int renewalBeforeDays = Integer.parseInt(StringUtils.isNotEmpty((CharSequence)apisPfpRationMainInfo.getOutwithBeforeRenewalDays()) ? apisPfpRationMainInfo.getOutwithBeforeRenewalDays() : "0");
        int renewalAfterDays = Integer.parseInt(StringUtils.isNotEmpty((CharSequence)apisPfpRationMainInfo.getOutwithAfterRenewalDays()) ? apisPfpRationMainInfo.getOutwithAfterRenewalDays() : "0");
        if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest()) && "1".equals((mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain()).getRenewalFlag()) && request.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform().booleanValue()) {
            renewalBeforeDays = Integer.parseInt(StringUtils.isNotEmpty((CharSequence)apisPfpRationMainInfo.getInnerBeforeRenewalDays()) ? apisPfpRationMainInfo.getInnerBeforeRenewalDays() : "0");
            renewalAfterDays = Integer.parseInt(StringUtils.isNotEmpty((CharSequence)apisPfpRationMainInfo.getInnerAfterRenewalDays()) ? apisPfpRationMainInfo.getInnerAfterRenewalDays() : "0");
        }
        DateTime startDate = DateUtil.parse((CharSequence)policyListDTO.getStartDateStr(), (String)"yyyy-MM-dd HH:mm:ss");
        DateTime endDate = DateUtil.parse((CharSequence)policyListDTO.getEndDateStr(), (String)"yyyy-MM-dd HH:mm:ss");
        if (System.currentTimeMillis() > endDate.getTime()) {
            long day2 = DateUtil.betweenDay((Date)new Date(), (Date)endDate, (boolean)true);
            if (day2 > (long)renewalAfterDays) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10246.getValue().replaceFirst("##", goodsCode).replaceFirst("##", String.valueOf(renewalAfterDays)), ChannelErrorCodeEnum.ERR_C10246.getKey());
            }
        } else if (System.currentTimeMillis() < endDate.getTime() && (day = DateUtil.betweenDay((Date)endDate, (Date)new Date(), (boolean)true)) > (long)renewalBeforeDays) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10634.getValue().replaceFirst("##", goodsCode).replaceFirst("##", String.valueOf(renewalBeforeDays)), ChannelErrorCodeEnum.ERR_C10634.getKey());
        }
        if (!QuotePriceValidate.isOutOneYear((Date)startDate, (Date)endDate, (boolean)true)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10248.getValue(), ChannelErrorCodeEnum.ERR_C10248.getKey());
        }
    }

    private List<PolicyListDTO> executeRenewablePolicyListQuery(StanderRequest request, PolicyListDTO policyListDTO) throws ApisBusinessException {
        String policyNo = policyListDTO.getPolicyNo();
        String planCode = ((ItemMainDTO)policyListDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        RenewablePolicyListQueryRequestDTO renewablePolicyListQueryRequestDTO = RenewablePolicyListQueryRequestDTO.builder().policyNo(policyNo).build();
        RenewablePolicyListQueryRequest renewablePolicyListQueryRequest = RenewablePolicyListQueryRequest.builder().requestHead(com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO.initRequestHead()).requestBody(renewablePolicyListQueryRequestDTO).build();
        request.setRenewablePolicyListQueryRequest(renewablePolicyListQueryRequest);
        StanderResponse standerResponse = this.apisBusinessService.execute("renewablePolicyListQuery", request);
        BaseApisParamUtil.verificationResponse((StanderResponse)standerResponse, (String)"renewablePolicyListQueryResponse");
        RenewablePolicyListQueryResponse renewablePolicyListQueryResponse = standerResponse.getRenewablePolicyListQueryResponse();
        if (1 != renewablePolicyListQueryResponse.getResponseHead().getStatus()) {
            String appCode = renewablePolicyListQueryResponse.getResponseHead().getAppCode();
            String appMessage = renewablePolicyListQueryResponse.getResponseHead().getAppMessage();
            throw new ApisBusinessException(appMessage, appCode);
        }
        if (ObjectUtil.isEmpty((Object)renewablePolicyListQueryResponse) || ObjectUtil.isEmpty((Object)renewablePolicyListQueryResponse.getResponseBody()) || ObjectUtil.isEmpty((Object)renewablePolicyListQueryResponse.getResponseBody().getPolicyList()) || renewablePolicyListQueryResponse.getResponseBody().getPolicyList().size() == 0) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10457.getValue(), ChannelErrorCodeEnum.ERR_C10457.getKey());
        }
        return renewablePolicyListQueryResponse.getResponseBody().getPolicyList();
    }
}

