/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.RiskManagementService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.WarnSendService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CommonsExecutorRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CoverageDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskManagemengCheckBusinessParamDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskManagemengCheckDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskManagemengCheckPartnerParamDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskManagemengCheckRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskManagemengCheckServiceParamDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskManagemengCheckSystemParamDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskManagementCoverageDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CommonsValidateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.RiskManagemengCheckResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelConfigsMapper;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskManagementScenesEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RiskManagementCheckUtil {
    private static final Logger log = LoggerFactory.getLogger(RiskManagementCheckUtil.class);
    @Value(value="${riskManagement.systemId}")
    private String systemId;
    @Value(value="${riskManagement.token}")
    private String token;
    @Value(value="${riskManagement.url}")
    private String url;
    @Value(value="${commonsExecutorUrl.riskManagementUrl}")
    private String riskManagementUrl;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    private RiskManagementService riskManagementService;
    @Autowired
    private ApisChannelConfigsMapper apisChannelConfigsMapper;
    @Autowired
    WarnSendService warnSendService;
    public static final String RISK_INTERCEPTION = "I";
    private static final String RISK_MANAGEMENT_OPEN_CONFIG_CODE = "risk_management_open_code";

    public String getRiskManagementOpen() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)RISK_MANAGEMENT_OPEN_CONFIG_CODE);
        ApisChannelConfigs configs = (ApisChannelConfigs)this.apisChannelConfigsMapper.selectOne((Wrapper)queryWrapper);
        if (configs == null) {
            return "0";
        }
        return configs.getConfigValue();
    }

    public void riskManagementData(StanderRequest request, PolicyDTO policyDTO, String scenes, String policyType) throws ApisBusinessException {
        if ("0".equals(this.getRiskManagementOpen())) {
            log.warn("\u4e0d\u5f00\u542f\u98ce\u63a7\u68c0\u6d4b");
            return;
        }
        if (!RiskManagementScenesEnum.check((String)scenes)) {
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B100003.getKey(), ErrorBisCodeEnum.ERR_B100003.getValue());
        }
        RiskManagemengCheckRequestDTO checkRequestDTO = this.dataConversion(request, policyDTO, scenes);
        request.setRiskManagemengCheckDTO(new RiskManagemengCheckDTO(checkRequestDTO, policyType));
    }

    public CommonsValidateResponseDTO callApi(StanderRequest request) {
        CommonsValidateResponseDTO response = new CommonsValidateResponseDTO(ChannelErrorCodeEnum.ERR_C10002.getKey(), ChannelErrorCodeEnum.ERR_C10002.getValue(), request.getHeader().getBussinessType());
        try {
            this.riskManagementRuleCheck(request, response);
        }
        catch (ApisBusinessException e) {
            response.code(e.getErrorCode()).message(e.getMessage());
        }
        return response;
    }

    public void riskManagementRuleCheck(StanderRequest request, CommonsValidateResponseDTO res) throws ApisBusinessException {
        if ("0".equals(this.getRiskManagementOpen())) {
            log.warn("\u98ce\u63a7\u68c0\u6d4b\u914d\u7f6e\u4e3a\u4e0d\u5f00\u542f\u72b6\u6001\uff0c\u4e0d\u8fdb\u884c\u98ce\u63a7\u63a5\u53e3\u7684\u8c03\u7528");
            return;
        }
        log.warn("\u98ce\u63a7\u68c0\u6d4b\u5f00\u59cb\u3002\u3002\u3002{}", (Object)request.getRiskManagemengCheckDTO().getPolicyType());
        if (!"01".equals(request.getRiskManagemengCheckDTO().getPolicyType())) {
            log.warn("\u56e2\u4f53\u5355\uff0c\u4e0d\u8fdb\u884c\u98ce\u63a7\u68c0\u6d4b");
            return;
        }
        Long startTime = System.currentTimeMillis();
        log.warn("\u98ce\u63a7\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSONObject.toJSONString((Object)request.getRiskManagemengCheckDTO().getRequestDTO()));
        RiskManagemengCheckResponseDTO response = (RiskManagemengCheckResponseDTO)this.riskManagementService.riskManagementSend(this.url, (Object)request.getRiskManagemengCheckDTO().getRequestDTO(), RiskManagemengCheckResponseDTO.class);
        HashMap<String, String> emailMap = new HashMap<String, String>();
        try {
            emailMap.put("businessKey", request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo());
            if (ObjectUtils.isEmpty(emailMap.get("businessKey"))) {
                emailMap.put("businessKey", request.getEndorseServiceRequest().getRequestBody().getMain().getPolicyNo());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        boolean flag = false;
        try {
            if (!"0000".equals(response.getCode())) {
                emailMap.put("code", response.getCode());
                emailMap.put("message", response.getMsg());
                flag = true;
                emailMap.put("tid", request.getRiskManagemengCheckDTO().getRequestDTO().getServiceParam().getTraceId());
            }
        }
        catch (Exception e) {
            emailMap.put("code", "-1");
            emailMap.put("message", "\u98ce\u63a7\u8fd4\u56de\u4e3a\u7a7a");
            flag = true;
            emailMap.put("tid", request.getRiskManagemengCheckDTO().getRequestDTO().getServiceParam().getTraceId());
        }
        if (flag) {
            this.warnSendService.convertSaveWarnSendEmail("/COMM_RULE_001", (String)emailMap.get("businessKey"), (String)emailMap.get("code"), (String)emailMap.get("message"), "\u98ce\u63a7\u8c03\u7528\u5f02\u5e38" + (String)emailMap.get("tid"));
        }
        if (response == null || response.getData() == null || response.getData().getRiskResult() == null || response.getData().getRiskResult().getProcess() == null) {
            log.error("\u98ce\u63a7\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u8ddf\u98ce\u63a7\u786e\u8ba4\u5904\u7406\u65b9\u6848\u4e3a\uff1a\u81ea\u52a8\u901a\u8fc7");
            return;
        }
        log.warn("\u98ce\u63a7\u63a5\u53e3\u8c03\u7528\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)response);
        if (null != res) {
            res.setProcess(response.getData().getRiskResult().getProcess());
        }
        if (RISK_INTERCEPTION.equals(response.getData().getRiskResult().getProcess())) {
            log.warn("riskManagementRuleCheck:\u98ce\u63a7\u5904\u7406\u610f\u89c1\u4e3a\u62e6\u622a\uff0c\u4e0d\u4e88\u901a\u8fc7");
            throw new ApisBusinessException(response.getData().getRiskResult().getRiskMsg(), ChannelErrorCodeEnum.ERR_C10369.getKey());
        }
        log.warn("\u98ce\u63a7\u68c0\u6d4b\u901a\u8fc7\uff0c\u5904\u7406\u610f\u89c1\u4e3a\uff1a{}", (Object)response.getData().getRiskResult().getProcess());
        log.warn("\u98ce\u63a7\u68c0\u6d4b\u7ed3\u675f\uff0c\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private RiskManagemengCheckRequestDTO dataConversion(StanderRequest request, PolicyDTO policyDTO, String scenes) throws ApisDataCompletionException {
        RiskManagemengCheckRequestDTO checkRequestDTO = new RiskManagemengCheckRequestDTO();
        checkRequestDTO.setSystemParam(this.getSystemParam(scenes));
        checkRequestDTO.setBusinessParam(this.getBusinessParam(request, policyDTO, scenes));
        checkRequestDTO.setPartnerParam(this.getPartnerParam(request, policyDTO, scenes));
        checkRequestDTO.setServiceParam(this.getServiceParam(request));
        return checkRequestDTO;
    }

    private RiskManagemengCheckSystemParamDTO getSystemParam(String scenes) {
        RiskManagemengCheckSystemParamDTO param = new RiskManagemengCheckSystemParamDTO();
        param.setSystemId(this.systemId);
        param.setScenes(scenes);
        return param;
    }

    private RiskManagemengCheckBusinessParamDTO getBusinessParam(StanderRequest request, PolicyDTO policyDTO, String scenes) {
        RiskManagemengCheckBusinessParamDTO param = new RiskManagemengCheckBusinessParamDTO();
        param.setUniqueId(StringUtils.isNotEmpty((CharSequence)request.getHeader().getBusinessKey()) ? request.getHeader().getBusinessKey() : UUID.randomUUID().toString());
        param.setDataVer("1");
        if (!RiskManagementScenesEnum.isCorrect((String)scenes)) {
            Map parameterMap = this.getMap(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain(), request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getAppliClient(), request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getInsuredList(), request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getRiskInfo(), request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage(), request, scenes);
            param.setParameterMap(parameterMap);
            param.setProductRef(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getRiskCode());
            param.setProductName(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getRiskName());
            param.setPlanRef(((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsCode());
            param.setPlanName(((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsName());
            param.setSupportPlanRef(((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getPlanCode());
            param.setSupportPlanName(((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getPlanName());
        } else {
            Map parameterMap = this.getMap(policyDTO.getMain(), policyDTO.getAppliClient(), policyDTO.getInsuredList(), policyDTO.getRiskInfo(), policyDTO.getCoverage(), request, scenes);
            param.setParameterMap(parameterMap);
            param.setParameterMap(parameterMap);
            param.setProductRef(policyDTO.getMain().getRiskCode());
            param.setProductName(policyDTO.getMain().getRiskName());
            param.setPlanRef(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode());
            param.setPlanName(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsName());
            param.setSupportPlanRef(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getPlanCode());
            param.setSupportPlanName(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getPlanName());
        }
        return param;
    }

    private Map<Object, Object> getMap(MainDTO main, List<AppliClientDTO> appliClient, List<InsuredDTO> insuredList, RiskInfoDTO riskInfo, CoverageDTO coverage, StanderRequest request, String scenes) {
        HashMap<Object, Object> parameterMap = new HashMap<Object, Object>();
        boolean isCorrect = false;
        boolean requestHaveAppLiData = false;
        String appliClientNumber = "";
        String appliClientIdentifyType = "";
        boolean requestHaveInsuredData = false;
        String insuredNumber = "";
        String insuredIdentifyType = "";
        if (RiskManagementScenesEnum.CORRECT.getCode().equals(scenes)) {
            isCorrect = true;
            if (request.getEndorsePriceServiceRequest().getRequestBody().getMain().getAssociatePersons() != null) {
                List requestAppliClient = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getAssociatePersons().getAppliClient();
                if (requestAppliClient != null && requestAppliClient.size() > 0) {
                    appliClientNumber = ((AppliClientDTO)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getAssociatePersons().getAppliClient().get(0)).getIdentifyNumber();
                    appliClientIdentifyType = ((AppliClientDTO)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getAssociatePersons().getAppliClient().get(0)).getIdentifyType();
                    requestHaveAppLiData = true;
                }
                List requestInsuredList = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getAssociatePersons().getInsuredList();
                List insuredIdvList = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getAssociatePersons().getInsuredIdvList();
                if (requestInsuredList != null && requestInsuredList.size() > 0) {
                    insuredNumber = ((InsuredDTO)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getAssociatePersons().getInsuredList().get(0)).getIdentifyNumber();
                    insuredIdentifyType = ((InsuredDTO)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getAssociatePersons().getInsuredList().get(0)).getIdentifyType();
                    requestHaveInsuredData = true;
                } else if (insuredIdvList != null && insuredIdvList.size() > 0) {
                    insuredNumber = ((InsuredIdvDTO)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getAssociatePersons().getInsuredIdvList().get(0)).getIdentifyNumber();
                    insuredIdentifyType = ((InsuredIdvDTO)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getAssociatePersons().getInsuredIdvList().get(0)).getIdentifyType();
                    requestHaveInsuredData = true;
                }
            }
        }
        parameterMap.put("main", main);
        if (isCorrect && requestHaveAppLiData) {
            if (StringUtils.isNotEmpty((CharSequence)appliClientNumber)) {
                appliClient.get(0).setIdentifyNumber(appliClientNumber);
            }
            if (StringUtils.isNotEmpty((CharSequence)appliClientIdentifyType)) {
                appliClient.get(0).setIdentifyType(appliClientIdentifyType);
            }
            parameterMap.put("appliClient", appliClient);
        } else {
            parameterMap.put("appliClient", appliClient);
        }
        if (insuredList != null && insuredList.size() > 0) {
            if (isCorrect && requestHaveInsuredData) {
                if (StringUtils.isNotEmpty((CharSequence)insuredNumber)) {
                    insuredList.get(0).setIdentifyNumber(insuredNumber);
                }
                if (StringUtils.isNotEmpty((CharSequence)insuredIdentifyType)) {
                    insuredList.get(0).setIdentifyType(insuredIdentifyType);
                }
                parameterMap.put("insuredList", insuredList);
            } else {
                parameterMap.put("insuredList", insuredList);
            }
        }
        if (riskInfo != null) {
            parameterMap.put("riskInfo", riskInfo);
        }
        if (coverage != null) {
            if (insuredList == null || insuredList.size() == 0) {
                if (coverage.getInsuredIdvList() != null && coverage.getInsuredIdvList().size() > 0) {
                    if (isCorrect && requestHaveInsuredData) {
                        if (StringUtils.isNotEmpty((CharSequence)insuredNumber)) {
                            ((InsuredIdvDTO)coverage.getInsuredIdvList().get(0)).setIdentifyNumber(insuredNumber);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)insuredIdentifyType)) {
                            ((InsuredIdvDTO)coverage.getInsuredIdvList().get(0)).setIdentifyType(insuredIdentifyType);
                        }
                        parameterMap.put("insuredList", coverage.getInsuredIdvList());
                    } else {
                        parameterMap.put("insuredList", coverage.getInsuredIdvList());
                    }
                } else if (((ItemMainDTO)coverage.getItemList().get(0)).getInsuredIdvList() != null && ((ItemMainDTO)coverage.getItemList().get(0)).getInsuredIdvList().size() > 0) {
                    if (isCorrect && requestHaveInsuredData) {
                        if (StringUtils.isNotEmpty((CharSequence)insuredNumber)) {
                            ((InsuredIdvDTO)((ItemMainDTO)coverage.getItemList().get(0)).getInsuredIdvList().get(0)).setIdentifyNumber(insuredNumber);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)insuredIdentifyType)) {
                            ((InsuredIdvDTO)((ItemMainDTO)coverage.getItemList().get(0)).getInsuredIdvList().get(0)).setIdentifyType(insuredIdentifyType);
                        }
                        parameterMap.put("insuredList", ((ItemMainDTO)coverage.getItemList().get(0)).getInsuredIdvList());
                    } else {
                        parameterMap.put("insuredList", ((ItemMainDTO)coverage.getItemList().get(0)).getInsuredIdvList());
                    }
                }
            }
            RiskManagementCoverageDTO coverageDTO = new RiskManagementCoverageDTO(coverage.getItemList(), coverage.getPublicAdditionKindList(), coverage.getRespondents(), coverage.getExpands());
            parameterMap.put("coverage", coverageDTO);
        }
        return parameterMap;
    }

    private RiskManagemengCheckPartnerParamDTO getPartnerParam(StanderRequest request, PolicyDTO policyDTO, String scenes) throws ApisDataCompletionException {
        String partnerType;
        String partnerName;
        String partnerRef;
        RiskManagemengCheckPartnerParamDTO param = new RiskManagemengCheckPartnerParamDTO();
        if (RiskManagementScenesEnum.isCorrect((String)scenes)) {
            partnerRef = policyDTO.getMain().getOperateCode();
            partnerName = policyDTO.getMain().getOperateName();
            partnerType = policyDTO.getSalesList().getAgentType();
        } else {
            Map userMap = this.dataCompletionUtil.getChannelUserInfo(request);
            partnerRef = (String)DataCompletionUtil.castToClass(String.class, userMap.get("channel_code"));
            partnerName = (String)DataCompletionUtil.castToClass(String.class, userMap.get("channel_name"));
            partnerType = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getSales().getAgentType();
        }
        param.setPartnerRef(partnerRef);
        param.setPartnerName(partnerName);
        param.setPartnerType(partnerType);
        param.setIssueAcc(request.getHeader().getUserCode());
        return param;
    }

    private RiskManagemengCheckServiceParamDTO getServiceParam(StanderRequest request) {
        RiskManagemengCheckServiceParamDTO param = new RiskManagemengCheckServiceParamDTO();
        param.setToken(this.token);
        param.setTraceId(UUID.randomUUID().toString().replaceAll("-", ""));
        param.setPrintRuleLog("N");
        return param;
    }

    public void addRiskManagement(StanderRequest request, List<CommonsExecutorRequestDTO> requestList) {
        if ("0".equals(this.getRiskManagementOpen())) {
            log.warn("\u4e0d\u5f00\u542f\u98ce\u63a7\u68c0\u6d4b\uff0c\u4e0d\u8fdb\u884c\u63a5\u53e3\u8c03\u7528");
            return;
        }
        requestList.add(new CommonsExecutorRequestDTO(this.riskManagementUrl, (Object)request, "riskManageCheck", CommonsValidateResponseDTO.class));
    }
}

