/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.InstallmentPayRecordSaveRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CommonsExecutorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class SaveInstallmentPayRecordAndPushUtil {
    private static final Logger log = LoggerFactory.getLogger(SaveInstallmentPayRecordAndPushUtil.class);
    private static final String INSTALLMENT_PAY_RECORD_PUSH_URL = "installment_pay_record_push_url";
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    HttpRequestService httpRequestService;

    @Async(value="imgBatchUploadExecutor")
    public void asyncNotice(InstallmentPayRecordSaveRequestDTO installmentPayRecordSaveRequestDTO, ApisBusiTaskLog busiTaskLog) {
        this.pushInstallmentPayRecordToAgent(installmentPayRecordSaveRequestDTO, busiTaskLog);
    }

    public void pushInstallmentPayRecordToAgent(InstallmentPayRecordSaveRequestDTO installmentPayRecordSaveRequestDTO, ApisBusiTaskLog busiTaskLog) {
        try {
            if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
                ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
                apisBusiTaskLog.setBusinessKey(installmentPayRecordSaveRequestDTO.getOrderNo());
                apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.INSTALLMENT_PAY_RECORED_TO_AGENT.getValue());
                QueryWrapper queryWrapper = new QueryWrapper((Object)apisBusiTaskLog);
                busiTaskLog = (ApisBusiTaskLog)this.apisBusiTaskLogService.getOne((Wrapper)queryWrapper);
            }
            ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
            apisChannelConfigs.setUserCode(installmentPayRecordSaveRequestDTO.getUserCode());
            apisChannelConfigs.setConfigCode(INSTALLMENT_PAY_RECORD_PUSH_URL);
            ApisChannelConfigs channelConfig = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
            if (ObjectUtil.isEmpty((Object)channelConfig) || ObjectUtil.isEmpty((Object)channelConfig.getConfigValue())) {
                log.error("\u672a\u914d\u7f6e\u51fa\u5355\u8d26\u53f7\u671f\u7f34\u4fdd\u5355\u7f34\u8d39\u4fe1\u606f\u63a8\u9001URL");
                if (ObjectUtil.isNotEmpty((Object)busiTaskLog)) {
                    busiTaskLog.setPushStatus("5");
                    busiTaskLog.setRemark("\u672a\u914d\u7f6e\u51fa\u5355\u8d26\u53f7\u671f\u7f34\u4fdd\u5355\u7f34\u8d39\u4fe1\u606f\u63a8\u9001URL");
                    this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
                }
                return;
            }
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            busiTaskLog.setPushTargetUrl(channelConfig.getConfigValue());
            busiTaskLog.setPushContent(JSON.toJSONString((Object)installmentPayRecordSaveRequestDTO));
            CommonsExecutorResponseDTO responseDTO = (CommonsExecutorResponseDTO)this.httpRequestService.convertAndSendForAgent(channelConfig.getConfigValue(), (Object)installmentPayRecordSaveRequestDTO, CommonsExecutorResponseDTO.class, "installmentPayRecordToAgent");
            if (ObjectUtil.isNull((Object)responseDTO)) {
                busiTaskLog.setPushStatus("4");
                busiTaskLog.setErrMsg("\u6e20\u9053\u672a\u8fd4\u56de\u5185\u5bb9");
                log.warn("\u5df2\u63a8\u9001\u672a\u8fd4\u56de\uff0c\u8ba2\u5355\u53f7\u4e3a{}", (Object)installmentPayRecordSaveRequestDTO.getOrderNo());
            } else {
                if (responseDTO.getCode() == 0) {
                    busiTaskLog.setPushStatus("1");
                } else {
                    busiTaskLog.setPushStatus("4");
                }
                busiTaskLog.setErrMsg(JSON.toJSONString((Object)responseDTO));
            }
        }
        catch (Exception e) {
            if (!ObjectUtil.isEmpty((Object)busiTaskLog)) {
                busiTaskLog.setPushStatus("4");
                busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > 1300 ? e.getMessage().substring(0, 1300) : e.getMessage());
            }
            log.error("push installmentPayRecoredToSales error:", (Throwable)e);
        }
        if (!ObjectUtil.isEmpty((Object)busiTaskLog)) {
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public void validateRquest(StanderRequest standerRequest) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)standerRequest) || ObjectUtil.isEmpty((Object)standerRequest.getInstallmentPayRecordSaveServiceRequest()) || ObjectUtil.isEmpty((Object)standerRequest.getInstallmentPayRecordSaveServiceRequest().getRequestBody())) {
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        InstallmentPayRecordSaveRequestDTO requestBody = standerRequest.getInstallmentPayRecordSaveServiceRequest().getRequestBody();
        if (ObjectUtil.isEmpty((Object)requestBody.getOrderNo())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N80001.getValue(), ErrorNullValueCodeEnum.ERR_N80001.getKey());
        }
        if (ObjectUtil.isEmpty((Object)requestBody.getPolicyNo())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N90003.getValue(), ErrorNullValueCodeEnum.ERR_N90003.getKey());
        }
        if (ObjectUtil.isEmpty((Object)requestBody.getPayNo())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N16002.getValue(), ErrorNullValueCodeEnum.ERR_N16002.getKey());
        }
        if (ObjectUtil.isEmpty((Object)requestBody.getPayAmount())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N16003.getValue(), ErrorNullValueCodeEnum.ERR_N16003.getKey());
        }
        if (ObjectUtil.isEmpty((Object)requestBody.getPayTime())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N16004.getValue(), ErrorNullValueCodeEnum.ERR_N16004.getKey());
        }
        if (ObjectUtil.isEmpty((Object)requestBody.getPayStatus())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N16005.getValue(), ErrorNullValueCodeEnum.ERR_N16005.getKey());
        }
        if (requestBody.getPayNo() < 1 || requestBody.getPayNo() > 12) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10650.getValue(), ChannelErrorCodeEnum.ERR_C10650.getKey());
        }
    }

    public void verifyRepeatRequest(StanderRequest request) throws ApisBusinessException {
        String businessKey = request.getInstallmentPayRecordSaveServiceRequest().getRequestBody().getOrderNo();
        if (!this.lock(businessKey)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10007.getValue(), ChannelErrorCodeEnum.ERR_C10007.getKey());
        }
    }

    public boolean lock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)key, 3L, TimeUnit.MINUTES);
    }

    public void unLock(StanderRequest request) {
        String businessKey = request.getInstallmentPayRecordSaveServiceRequest().getRequestBody().getOrderNo();
        this.redisTemplate.delete((Object)businessKey);
    }
}

