/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CalculateResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CalculateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredPremiumDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyListQueryResponse;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShortRateCalculateUtil {
    private static final Logger log = LoggerFactory.getLogger(ShortRateCalculateUtil.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    private static final String RESPONSE_ENTITY_QUOTE_PRICE = "policyListQueryResponse";

    public StanderResponse calculate(StanderRequest request) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        quotePriceDTO.setIsCalculateOnly("0");
        request.getQuotePriceServiceRequest().getRequestHead().setConsumerSeqNo(UUID.randomUUID().toString());
        List insuredIdvList = quotePriceDTO.getCoverage().getInsuredIdvList();
        for (InsuredIdvDTO insured : insuredIdvList) {
            if (!StringUtils.isEmpty((CharSequence)insured.getInsuredType())) continue;
            insured.setInsuredType("1");
        }
        StanderResponse quotePriceResponse = this.coreInsureApi.quotePrice(request);
        BaseApisParamUtil.verificationResponse((StanderResponse)quotePriceResponse, (String)RESPONSE_ENTITY_QUOTE_PRICE);
        CalculateResponse calculateResponse = this.buildCalculateResponse(quotePriceDTO, quotePriceResponse.getPolicyListQueryResponse());
        quotePriceDTO.setIsCalculateOnly("1");
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        request.getQuotePriceServiceRequest().getRequestHead().setConsumerSeqNo(request.getHeader().getUserCode() + mainDTO.getOrderNo());
        return StanderResponse.builder().calculateResponse(calculateResponse).header(request.getHeader()).build();
    }

    private CalculateResponse buildCalculateResponse(QuotePriceDTO quotePriceDTO, PolicyListQueryResponse policyListQueryResponse) {
        CalculateResponse calculateResponse = CalculateResponse.builder().responseHead(policyListQueryResponse.getResponseHead()).build();
        MainDTO main = policyListQueryResponse.getResponseBody().getMain();
        CalculateResponseDTO calculateResponseDTO = CalculateResponseDTO.builder().totalPremium(main.getSumPremium()).build();
        List insuredPremiumList = this.buildInsuredPremiumList(quotePriceDTO, policyListQueryResponse);
        calculateResponseDTO.setAgencyPolicyRef(main.getOrderNo());
        calculateResponseDTO.setInsuredPremiumList(insuredPremiumList);
        calculateResponse.setResponseBody(calculateResponseDTO);
        return calculateResponse;
    }

    private List<InsuredPremiumDTO> buildInsuredPremiumList(QuotePriceDTO quotePriceDTO, PolicyListQueryResponse policyListQueryResponse) {
        ArrayList<InsuredPremiumDTO> insuredPremiumList = new ArrayList<InsuredPremiumDTO>();
        List insuredIdvList = quotePriceDTO.getCoverage().getInsuredIdvList();
        List insuredList = policyListQueryResponse.getResponseBody().getInsured();
        block0: for (InsuredDTO insuredDTO : insuredList) {
            for (InsuredIdvDTO insured : insuredIdvList) {
                if (!insured.getSerialNo().equals(insuredDTO.getSerialNo())) continue;
                insured.setPremium(insuredDTO.getGrossPremium());
                continue block0;
            }
        }
        for (InsuredIdvDTO insured : insuredIdvList) {
            InsuredPremiumDTO insuredPremiumDTO = InsuredPremiumDTO.builder().build();
            insuredPremiumDTO.setSerialNo(insured.getInsuredIDCache());
            insuredPremiumDTO.setInsuredName(insured.getInsuredName());
            insuredPremiumDTO.setInsuredType(insured.getInsuredType());
            insuredPremiumDTO.setPremium(insured.getPremium());
            insuredPremiumList.add(insuredPremiumDTO);
        }
        return insuredPremiumList;
    }
}

