/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.base.Splitter;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.WarnSendService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.EPolicyDownServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.PaymentServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.EmailCommonUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.TaskUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PayPlanDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.EPolicyDownRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.EPolicyDownServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.EmpUwresultMsgDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PaymentNotifyMessageRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PaymentNotifyToAgentDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.tianYuan.TianYuanDownloadUrlRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.tianYuan.TianYuanRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.tianYuan.TianYuanResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.PayNotifyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.PayNotifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.resp.PayNotifyResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelInstallmentOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrderExt;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiCorrectOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiEmailSendLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiWarnRule;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiPhyexamTaskLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderExtService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiCorrectOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiEmailSendLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiWarnRuleService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ApisDataDictionaryConstants;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class TaskUtil {
    private static final Logger log = LoggerFactory.getLogger(TaskUtil.class);
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    ApisBusiPhyexamTaskLogMapper apisBusiPhyexamTaskLogMapper;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    private ApisBusiCorrectOrderService apisBusiCorrectOrderService;
    @Autowired
    private ApisChannelCodeService apisChannelCodeService;
    @Autowired
    WarnSendService warnSendService;
    @Autowired
    ApisBusiWarnRuleService apisBusiWarnRuleService;
    private static final String EXAMINAT_HEALTH_INFO = "examinatHealthInfo";
    @Autowired
    private PaymentServiceImpl paymentServiceImpl;
    @Autowired
    private EmailCommonUtil emailCommonUtil;
    @Autowired
    ApisBusiEmailSendLogService emailSendLogService;
    @Autowired
    private ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    private ApisBusiChannelOrderExtService apisBusiChannelOrderExtService;
    @Autowired
    private EPolicyDownServiceImpl ePolicyDownService;
    @Value(value="#${tianYuan.account}")
    private String tianYuanAccount;
    @Value(value="#${tianYuan.key}")
    private String tianYuanKey;
    private static final String EMAIL_SPLIT = ";";
    private static final String EMAIL_REPLACE = "###";
    public static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    public static final String CONTENT_TYPE_JSON = "application/json;charset=utf-8";
    private static final String EMAIL_HTML_TABLE_TR_TD = "<tr><td>";
    private static final String EMAIL_HTML_TABLE_TD_TD = "</td><td>";
    private static final String EMAIL_HTML_TABLE_TD_TR = "</td></tr>";
    static OkHttpClient client = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
    static OkHttpClient httpsClient = OkHttpUtils.getSslHttpsClient().newBuilder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
    private static Predicate<ApisBusiTaskLog> pushContentNotEmptyPredicate = busiTaskLog -> {
        boolean isValid = true;
        if (ObjectUtil.isEmpty((Object)busiTaskLog.getPushContent())) {
            log.warn("\u4efb\u52a1businessKey={},\u6ca1\u6709\u8981\u63a8\u9001\u7684\u8bf7\u6c42\u4fe1\u606f", (Object)busiTaskLog.getBusinessKey());
            isValid = false;
        }
        return isValid;
    };
    private static Predicate<ApisBusiTaskLog> pushTargetUrlNotEmptyPredicate = busiTaskLog -> {
        boolean isValid = true;
        if (ObjectUtil.isEmpty((Object)busiTaskLog.getPushTargetUrl())) {
            log.warn("\u4efb\u52a1businessKey={},\u6ca1\u6709\u8981\u63a8\u9001\u7684\u8bf7\u6c42\u5730\u5740", (Object)busiTaskLog.getBusinessKey());
            isValid = false;
        }
        return isValid;
    };
    private static Function<ApisBusiTaskLog, Object> pushContentToUrlRequestFunc = apisBusiTaskLog -> {
        RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)apisBusiTaskLog.getPushContent());
        Request request = new Request.Builder().header("Content-Type", CONTENT_TYPE_JSON).url(apisBusiTaskLog.getPushTargetUrl()).post(body).build();
        Call call = client.newCall(request);
        Response resp = null;
        try {
            resp = call.execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resp;
    };
    private static BiConsumer<ApisBusiTaskLog, Object> tianYuanResponseHandleFunc = (taskLog, res) -> {
        if (res instanceof Response) {
            Response resp = (Response)res;
            if (null != resp && resp.isSuccessful()) {
                TianYuanResponse response = (TianYuanResponse)JSON.parseObject((String)resp.toString(), TianYuanResponse.class);
                if (null != response && "0".equals(response.getErrorCode())) {
                    log.warn("\u4efb\u52a1\u7c7b\u578b={}\uff0c\u4efb\u52a1businessKey={}\u6267\u884c\u6210\u529f", (Object)taskLog.getPushType(), (Object)taskLog.getBusinessKey());
                    taskLog.setPushStatus("1");
                } else {
                    log.warn("\u4efb\u52a1\u7c7b\u578b={}\uff0c\u4efb\u52a1businessKey={}\u6267\u884c\u5931\u8d25", (Object)taskLog.getPushType(), (Object)taskLog.getBusinessKey());
                    taskLog.setPushStatus("4");
                }
            } else {
                log.warn("\u4efb\u52a1\u7c7b\u578b={}\uff0c\u4efb\u52a1businessKey={}\u6267\u884c\u5931\u8d25", (Object)taskLog.getPushType(), (Object)taskLog.getBusinessKey());
                taskLog.setPushStatus("4");
            }
        }
    };

    @Async(value="scheduleTaskNotifyExecutor")
    public void asyncNotice(ApisBusiTaskLog busiTaskLog) {
        this.pushContentToUrl(busiTaskLog);
    }

    @Async(value="scheduleTaskNotifyExecutor")
    public void asyncNotice(String businessKey, String pushType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_key", (Object)businessKey);
        queryWrapper.eq((Object)"push_type", (Object)pushType);
        queryWrapper.eq((Object)"push_status", (Object)"0");
        ApisBusiTaskLog apisBusiTaskLog = (ApisBusiTaskLog)this.apisBusiTaskLogService.getOne((Wrapper)queryWrapper);
        this.pushContentToUrl(apisBusiTaskLog);
    }

    public void pushContentToUrl(ApisBusiTaskLog busiTaskLog) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)busiTaskLog.getPushTargetUrl())) {
            log.warn("\u4efb\u52a1businessKey={},\u6ca1\u6709\u914d\u7f6e\u63a8\u9001\u7684URL", (Object)busiTaskLog.getBusinessKey());
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            if (isUpdSuccess) {
                Response resp = (Response)this.convertAndSendForCallback(busiTaskLog.getPushTargetUrl(), (Object)busiTaskLog.getPushContent(), Response.class);
                log.warn("\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\uff1a{}", (Object)resp);
                if (null != resp && resp.isSuccessful()) {
                    busiTaskLog.setPushStatus("1");
                } else {
                    busiTaskLog.setPushStatus("4");
                }
                if (null != resp) {
                    busiTaskLog.setErrMsg(resp.toString());
                }
            }
        }
        catch (Exception e) {
            busiTaskLog.setPushStatus("4");
            busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            log.error("\u5f02\u6b65\u56de\u8c03\u901a\u77e5 error:", (Throwable)e);
        }
        if (isUpdSuccess) {
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public <T> T convertAndSendForCallback(String url, Object body, Class<T> respType) {
        Date startDate = new Date();
        try {
            Object resp;
            String requestBodyStr = body instanceof String ? (String)body : JSON.toJSONString((Object)body);
            RequestBody requestBody = RequestBody.create((MediaType)JSON_TYPE, (String)requestBodyStr);
            Request request = new Request.Builder().url(url).post(requestBody).build();
            log.warn("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)requestBodyStr);
            Call call = client.newCall(request);
            Response response = call.execute();
            if (respType == Response.class) {
                resp = response;
            } else {
                String responseBodyStr = response.body().string();
                log.warn("\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseBodyStr);
                resp = JSON.parseObject((String)responseBodyStr, respType);
            }
            Response response2 = resp;
            return (T)response2;
        }
        catch (Exception e) {
            log.error("=============call api error :{}", (Object)url);
            throw new RuntimeException(e);
        }
        finally {
            log.warn("\u63a8\u9001\u7528\u65f6:{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
        }
    }

    public void pushFormContentToUrl(ApisBusiTaskLog busiTaskLog, String taskType) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)busiTaskLog.getPushTargetUrl())) {
            log.warn("\u4efb\u52a1\u7c7b\u578b={}\uff0c\u4efb\u52a1businessKey={},\u6ca1\u6709\u914d\u7f6e\u63a8\u9001\u7684URL", (Object)busiTaskLog.getPushType(), (Object)busiTaskLog.getBusinessKey());
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            if (isUpdSuccess) {
                String requestString = null;
                FormBody requestBody = null;
                if (ApisAutoTaskConstantsEnum.PAY_NOTIFY_CALLBACK.getValue().equals(taskType)) {
                    PaymentNotifyToAgentDTO paymentNotifyToAgentDTO = (PaymentNotifyToAgentDTO)JSON.parseObject((String)busiTaskLog.getPushContent(), PaymentNotifyToAgentDTO.class);
                    requestString = JSON.toJSONString((Object)paymentNotifyToAgentDTO);
                    requestBody = new FormBody.Builder().add("policyRef", paymentNotifyToAgentDTO.getPolicyRef()).add("agencyCode", paymentNotifyToAgentDTO.getAgencyCode()).add("totalPremium", paymentNotifyToAgentDTO.getTotalPremium()).add("paymentMethod", paymentNotifyToAgentDTO.getPaymentMethod()).add("notifyUrl", paymentNotifyToAgentDTO.getNotifyUrl()).add("returnUrl", paymentNotifyToAgentDTO.getReturnUrl()).add("paymentGatewaySn", paymentNotifyToAgentDTO.getPaymentGatewaySn()).add("payTime", paymentNotifyToAgentDTO.getPayTime()).add("tradeStatus", paymentNotifyToAgentDTO.getTradeStatus()).add("msg", paymentNotifyToAgentDTO.getMsg()).add("sign", paymentNotifyToAgentDTO.getSign()).build();
                }
                Request req = new Request.Builder().url(busiTaskLog.getPushTargetUrl()).post(requestBody).build();
                log.warn("\u652f\u4ed8\u5f02\u6b65\u56de\u8c03\u8bf7\u6c42\uff1a{}", (Object)requestString);
                Response resp = httpsClient.newCall(req).execute();
                log.warn("\u652f\u4ed8\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\uff1a{}", (Object)resp.toString());
                if (null != resp && resp.isSuccessful()) {
                    log.warn("notify\u56de\u8c03\u6267\u884c\u6210\u529f");
                    busiTaskLog.setPushStatus("1");
                } else {
                    log.warn("notify\u56de\u8c03\u6267\u884c\u5931\u8d25");
                    busiTaskLog.setPushStatus("4");
                }
                if (null != resp) {
                    busiTaskLog.setErrMsg(resp.toString());
                }
            }
        }
        catch (Exception e) {
            busiTaskLog.setPushStatus("4");
            busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            log.error("\u5f02\u6b65\u56de\u8c03\u901a\u77e5 error:", (Throwable)e);
        }
        if (isUpdSuccess) {
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public void pushExaminatHealthInfo(ApisBusiTaskLog busiTaskLog, String taskType) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            if (isUpdSuccess) {
                if (EXAMINAT_HEALTH_INFO.equals(taskType)) {
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"policy_no", (Object)busiTaskLog.getBusinessKey());
                    queryWrapper.notIn((Object)"status", new Object[]{"4"});
                    List apisBusiPhyexamTaskLogs = this.apisBusiPhyexamTaskLogMapper.selectList((Wrapper)queryWrapper);
                    if (ObjectUtils.isEmpty((Object)apisBusiPhyexamTaskLogs)) {
                        return;
                    }
                    apisBusiPhyexamTaskLogs.forEach(taskLog -> {
                        taskLog.setStatus("3");
                        taskLog.setRetryCount(Integer.valueOf(1));
                        this.apisBusiPhyexamTaskLogMapper.updateById(taskLog);
                    });
                }
                busiTaskLog.setPushStatus("1");
            }
        }
        catch (Exception e) {
            busiTaskLog.setPushStatus("4");
            busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            log.error("\u5347\u7ea7\u9519\u8bef error:", (Throwable)e);
        }
        if (isUpdSuccess) {
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public void payNotifyToSales(ApisBusiChannelInstallmentOrder apisBusiChannelInstallmentOrder) throws ApisBusinessException {
        PayNotifyRequest payNotifyRequest = new PayNotifyRequest();
        payNotifyRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        PayNotifyDTO payNotifyDTO = new PayNotifyDTO();
        payNotifyDTO.setPolicyNo(apisBusiChannelInstallmentOrder.getPolicyNo());
        payNotifyDTO.setPayDate(Date.from(apisBusiChannelInstallmentOrder.getPayTime().atZone(ZoneId.systemDefault()).toInstant()));
        payNotifyDTO.setPayFee(apisBusiChannelInstallmentOrder.getCurrentPremium());
        payNotifyDTO.setPayNo(apisBusiChannelInstallmentOrder.getCurrentPayNo());
        ArrayList<PayNotifyDTO> payNotifyList = new ArrayList<PayNotifyDTO>();
        payNotifyList.add(payNotifyDTO);
        payNotifyRequest.setRequestBody(payNotifyList);
        PayNotifyResponse payNotifyResponse = this.coreInsureApi.payNotifyToSales(payNotifyRequest);
        if (ObjectUtil.isEmpty((Object)payNotifyResponse)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
        if (!ChannelErrorCodeEnum.ERR_C10002.getKey().equals(payNotifyResponse.getCode())) {
            if (ObjectUtil.isNotEmpty((Object)payNotifyResponse.getErrorMsg())) {
                throw new ApisBusinessException(payNotifyResponse.getErrorMsg(), payNotifyResponse.getCode());
            }
            if (ObjectUtil.isNotEmpty((Object)payNotifyResponse.getHead())) {
                throw new ApisBusinessException(payNotifyResponse.getHead().getAppMessage(), payNotifyResponse.getHead().getAppCode());
            }
        }
    }

    @Async(value="scheduleTaskNotifyExecutor")
    public void asyncPayNotifyToSales(ApisBusiChannelInstallmentOrder apisBusiChannelInstallmentOrder) throws ApisBusinessException {
        try {
            this.payNotifyToSales(apisBusiChannelInstallmentOrder);
        }
        catch (ApisBusinessException e) {
            this.saveTaskInfo(ApisAutoTaskConstantsEnum.DEBITNOTE_TO_SALES.getValue(), apisBusiChannelInstallmentOrder.getPolicyNo() + "-" + apisBusiChannelInstallmentOrder.getCurrentPayNo(), Integer.valueOf(1), e.getMessage(), "4");
            log.error("\u5206\u671f\u4ed8\u6b3e\u901a\u77e5\u9500\u7ba1\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519\uff0c\u6dfb\u52a0\u5230\u63a8\u9001\u4efb\u52a1\u4e2d", (Throwable)e);
        }
        catch (Exception e) {
            this.saveTaskInfo(ApisAutoTaskConstantsEnum.DEBITNOTE_TO_SALES.getValue(), apisBusiChannelInstallmentOrder.getPolicyNo() + "-" + apisBusiChannelInstallmentOrder.getCurrentPayNo(), Integer.valueOf(1), e.getMessage(), "4");
            log.error("\u5206\u671f\u4ed8\u6b3e\u901a\u77e5\u9500\u7ba1\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519\uff0c\u6dfb\u52a0\u5230\u63a8\u9001\u4efb\u52a1\u4e2d", (Throwable)e);
        }
    }

    public void pushJsonToUrl(ApisBusiTaskLog busiTaskLog) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)busiTaskLog.getPushTargetUrl())) {
            log.warn("\u4efb\u52a1\u7c7b\u578b={}\uff0c\u4efb\u52a1businessKey={},\u6ca1\u6709\u914d\u7f6e\u63a8\u9001\u7684URL", (Object)busiTaskLog.getPushType(), (Object)busiTaskLog.getBusinessKey());
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            if (isUpdSuccess) {
                log.warn("\u56e2\u9669\u5f02\u6b65\u901a\u77e5\u8bf7\u6c42\uff1a{}", (Object)busiTaskLog.getPushContent());
                RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)busiTaskLog.getPushContent());
                Request request = new Request.Builder().header("Content-Type", CONTENT_TYPE_JSON).url(busiTaskLog.getPushTargetUrl()).post(body).build();
                Call call = client.newCall(request);
                Response resp = call.execute();
                log.warn("\u56e2\u9669\u5f02\u6b65\u901a\u77e5\u54cd\u5e94\uff1a{}", (Object)resp.toString());
                if (null != resp && resp.isSuccessful()) {
                    log.warn("notify\u56de\u8c03\u6267\u884c\u6210\u529f");
                    busiTaskLog.setPushStatus("1");
                } else {
                    log.warn("notify\u56de\u8c03\u6267\u884c\u5931\u8d25");
                    busiTaskLog.setPushStatus("4");
                }
                if (null != resp) {
                    busiTaskLog.setErrMsg(resp.toString());
                }
            }
        }
        catch (Exception e) {
            busiTaskLog.setPushStatus("4");
            busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            log.error("\u5f02\u6b65\u56de\u8c03\u901a\u77e5 error:", (Throwable)e);
        }
        if (isUpdSuccess) {
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    private void saveTaskInfo(String pushType, String businessKey, Integer pushStep, String errMsg, String pushStatus) {
        ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
        apisBusiTaskLog.setPushType(pushType);
        apisBusiTaskLog.setBusinessKey(businessKey);
        apisBusiTaskLog.setPushStep(pushStep);
        apisBusiTaskLog.setErrMsg(errMsg);
        apisBusiTaskLog.setPushStatus(pushStatus);
        apisBusiTaskLog.setLastPushTime(LocalDateTime.now());
        this.apisBusiTaskLogService.saveTaskInfo(apisBusiTaskLog);
    }

    public void doPolicyCancelAsyncConfirmExecute(ApisBusiTaskLog busiTaskLog) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        boolean isInvalid = false;
        if (ObjectUtil.isEmpty((Object)busiTaskLog.getPushContent())) {
            log.warn("\u4efb\u52a1businessKey={},\u6ca1\u6709\u8981\u63a8\u9001\u7684\u8bf7\u6c42\u4fe1\u606f", (Object)busiTaskLog.getBusinessKey());
            isInvalid = true;
        }
        if (isInvalid) {
            busiTaskLog.setPushStatus("5");
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            return;
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0taskLog\u4efb\u52a1\u72b6\u6001\u51fa\u9519\uff1a", (Throwable)e);
        }
        if (isUpdSuccess) {
            try {
                PolicySubmitRequest policySubmitRequest = (PolicySubmitRequest)JSON.parseObject((String)busiTaskLog.getPushContent(), PolicySubmitRequest.class);
                StanderRequest request = StanderRequest.builder().policySubmitRequest(policySubmitRequest).build();
                StanderResponse response = this.dataCompletionUtil.doPolicyCancelExecute(request);
                busiTaskLog.setPushStatus("1");
                String responseTxt = JSON.toJSONString((Object)response);
                busiTaskLog.setErrMsg(responseTxt.length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? responseTxt.substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : responseTxt);
            }
            catch (ApisBusinessException e) {
                busiTaskLog.setPushStatus("4");
                busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            }
            catch (Exception e) {
                log.error("\u5f02\u6b65\u53d1\u9001\u9000\u4fdd\u786e\u8ba4\u8bf7\u6c42 error:", (Throwable)e);
                busiTaskLog.setPushStatus("4");
                busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            }
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public void doPolicyCancelAsyncEndorsePriceExecute(ApisBusiTaskLog busiTaskLog) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        boolean isInvalid = false;
        if (ObjectUtil.isEmpty((Object)busiTaskLog.getPushContent())) {
            log.warn("\u4efb\u52a1businessKey={},\u6ca1\u6709\u8981\u63a8\u9001\u7684\u8bf7\u6c42\u4fe1\u606f", (Object)busiTaskLog.getBusinessKey());
            isInvalid = true;
        }
        if (isInvalid) {
            busiTaskLog.setPushStatus("5");
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            return;
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0taskLog\u4efb\u52a1\u72b6\u6001\u51fa\u9519\uff1a", (Throwable)e);
        }
        if (isUpdSuccess) {
            try {
                StanderRequest request = (StanderRequest)JSON.parseObject((String)busiTaskLog.getPushContent(), StanderRequest.class);
                PolicyDTO policyDTO = this.dataCompletionUtil.executePolicyDetails(request);
                request.getEndorseServiceRequest().getRequestBody().setPolicyDTO(policyDTO);
                request.getEndorseServiceRequest().getRequestBody().getMain().setEndDate(policyDTO.getMain().getEndDate());
                StanderResponse response = this.dataCompletionUtil.doPolicyCancelAsyncEndorsePrice(request);
                busiTaskLog.setPushStatus("1");
                String responseTxt = JSON.toJSONString((Object)response);
                busiTaskLog.setErrMsg(responseTxt.length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? responseTxt.substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : responseTxt);
            }
            catch (ApisBusinessException e) {
                if (ChannelErrorCodeEnum.ERR_C10127.getKey().equals(e.getErrorCode()) || ChannelErrorCodeEnum.ERR_C10025.getKey().equals(e.getErrorCode())) {
                    busiTaskLog.setPushStatus("5");
                    busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
                } else {
                    busiTaskLog.setPushStatus("4");
                    busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
                }
            }
            catch (Exception e) {
                log.error("\u5f02\u6b65\u53d1\u9001\u9000\u4fdd\u786e\u8ba4\u8bf7\u6c42 error:", (Throwable)e);
                busiTaskLog.setPushStatus("4");
                busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            }
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public void pushPolicyStatusIyunBao(ApisBusiTaskLog busiTaskLog) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        boolean isInvalid = false;
        if (ObjectUtil.isEmpty((Object)busiTaskLog.getPushContent())) {
            log.warn("\u4efb\u52a1businessKey={},\u6ca1\u6709\u8981\u63a8\u9001\u7684\u8bf7\u6c42\u4fe1\u606f", (Object)busiTaskLog.getBusinessKey());
            isInvalid = true;
        }
        if (isInvalid) {
            busiTaskLog.setPushStatus("5");
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            return;
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0taskLog\u4efb\u52a1\u72b6\u6001\u51fa\u9519\uff1a", (Throwable)e);
        }
        if (isUpdSuccess) {
            try {
                if ("1".equals(busiTaskLog.getRemark())) {
                    EmpUwresultMsgDTO empUwresultMsgDTO = (EmpUwresultMsgDTO)JSON.parseObject((String)busiTaskLog.getPushContent(), EmpUwresultMsgDTO.class);
                    FormBody requestBody = null;
                    requestBody = "1".equals(empUwresultMsgDTO.getType()) ? new FormBody.Builder().add("totalPremium", empUwresultMsgDTO.getTotalPremium().toString()).add("agencyCode", empUwresultMsgDTO.getAgencyCode()).add("type", empUwresultMsgDTO.getType()).add("policyRef", empUwresultMsgDTO.getPolicyRef()).add("status", empUwresultMsgDTO.getStatus()).build() : new FormBody.Builder().add("totalPremium", empUwresultMsgDTO.getTotalPremium().toString()).add("agencyCode", empUwresultMsgDTO.getAgencyCode()).add("endorseNo", empUwresultMsgDTO.getEndorseNo()).add("applyNo", empUwresultMsgDTO.getApplyNo()).add("type", empUwresultMsgDTO.getType()).add("policyRef", empUwresultMsgDTO.getPolicyRef()).add("status", empUwresultMsgDTO.getStatus()).add("adjustmentPremium", empUwresultMsgDTO.getAdjustmentPremium().toString()).build();
                    Request req = new Request.Builder().url(busiTaskLog.getPushTargetUrl()).post((RequestBody)requestBody).build();
                    Response resp = httpsClient.newCall(req).execute();
                    if (resp != null && resp.isSuccessful()) {
                        busiTaskLog.setPushStatus("1");
                    } else {
                        busiTaskLog.setPushStatus("4");
                    }
                    String responseTxt = JSON.toJSONString((Object)resp);
                    busiTaskLog.setErrMsg(responseTxt.length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? responseTxt.substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : responseTxt);
                } else if ("2".equals(busiTaskLog.getRemark())) {
                    RequestBody body = RequestBody.create((MediaType)JSON_TYPE, (String)busiTaskLog.getPushContent());
                    Request request = new Request.Builder().header("Content-Type", CONTENT_TYPE_JSON).url(busiTaskLog.getPushTargetUrl()).post(body).build();
                    Response resp = httpsClient.newCall(request).execute();
                    if (resp != null && resp.isSuccessful()) {
                        busiTaskLog.setPushStatus("1");
                    } else {
                        busiTaskLog.setPushStatus("4");
                    }
                }
            }
            catch (Exception e) {
                log.error("\u4fdd\u6279\u5355\u751f\u6548\u901a\u77e5i\u4e91\u4fdd error:", (Throwable)e);
                busiTaskLog.setPushStatus("4");
                busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            }
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public void commonDoTask(ApisBusiTaskLog busiTaskLog, TaskBusinessFunction taskBusinessFunction, Predicate<ApisBusiTaskLog> predicate, BiConsumer<ApisBusiTaskLog, Exception> exceptionHandleConsumer) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        boolean isValid = true;
        if (null != predicate) {
            isValid = predicate.test(busiTaskLog);
        }
        if (!isValid) {
            busiTaskLog.setPushStatus("5");
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            return;
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0taskLog\u4efb\u52a1\u72b6\u6001\u51fa\u9519\uff1a", (Throwable)e);
        }
        if (isUpdSuccess) {
            try {
                taskBusinessFunction.doTask(busiTaskLog);
            }
            catch (Exception e) {
                log.error("\u4efb\u52a1\u7c7b\u578b={}\uff0c\u4efb\u52a1businessKey={}\u6267\u884c\u51fa\u9519:", new Object[]{busiTaskLog.getPushType(), busiTaskLog.getBusinessKey(), e});
                if (null != exceptionHandleConsumer) {
                    exceptionHandleConsumer.accept(busiTaskLog, e);
                }
                busiTaskLog.setPushStatus("4");
                busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            }
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public void commonDoTask(ApisBusiTaskLog busiTaskLog, TaskBusinessFunction taskBusinessFunction) {
        this.commonDoTask(busiTaskLog, taskBusinessFunction, pushContentNotEmptyPredicate, null);
    }

    public void doEndorsePaymentAsyncReturnEndorseNo(ApisBusiTaskLog busiTaskLog, int maxPushTimes) {
        this.commonDoTask(busiTaskLog, apisBusiTaskLog -> {
            try {
                PaymentNotifyMessageRequestDTO request = (PaymentNotifyMessageRequestDTO)JSON.parseObject((String)busiTaskLog.getPushContent(), PaymentNotifyMessageRequestDTO.class);
                Object retObj = this.paymentServiceImpl.endorsePayNotifyCallBack(request);
                busiTaskLog.setPushStatus("1");
                if (ObjectUtil.isNotEmpty((Object)retObj)) {
                    String responseTxt = JSON.toJSONString((Object)retObj);
                    busiTaskLog.setErrMsg(responseTxt.length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? responseTxt.substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : responseTxt);
                }
            }
            catch (Exception e) {
                if (busiTaskLog.getPushStep() >= maxPushTimes) {
                    QueryWrapper apisBusiCorrectOrderQueryWrapper = new QueryWrapper();
                    apisBusiCorrectOrderQueryWrapper.eq((Object)"business_key", (Object)busiTaskLog.getBusinessKey());
                    ApisBusiCorrectOrder apisBusiCorrectOrder = (ApisBusiCorrectOrder)this.apisBusiCorrectOrderService.getOne((Wrapper)apisBusiCorrectOrderQueryWrapper);
                    this.warnSendService.convertSaveWarnSendEmail("/endorsePaymentCallAsyncReturn", apisBusiCorrectOrder, e instanceof ApisBusinessException ? ((ApisBusinessException)((Object)((Object)e))).getErrorCode() : "", e.getMessage());
                }
                if (e instanceof ApisBusinessException) {
                    busiTaskLog.setPushStatus("4");
                    busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
                }
                throw e;
            }
        });
    }

    public void doTaskLogFailEmail(List<ApisBusiTaskLog> apisBusiTaskLogs) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"rule_code", (Object)"taskLogFailEmail");
        ApisBusiWarnRule rules = (ApisBusiWarnRule)this.apisBusiWarnRuleService.getOne((Wrapper)queryWrapper);
        StringBuilder content = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>(16);
        ApisChannelCode apisChannelCode = new ApisChannelCode();
        apisChannelCode.setCode("TaskType");
        apisChannelCode.setDeleted(Integer.valueOf(0));
        apisChannelCode.setValidFlag(Boolean.valueOf(true));
        QueryWrapper queryWrapperConfig = new QueryWrapper((Object)apisChannelCode);
        List list = this.apisChannelCodeService.list((Wrapper)queryWrapperConfig);
        if (ObjectUtil.isNotEmpty((Object)list)) {
            for (ApisChannelCode code : list) {
                map.put(code.getValue(), code.getValueDesc());
            }
        }
        apisBusiTaskLogs.forEach(apisBusiTaskLog -> {
            content.append(EMAIL_HTML_TABLE_TR_TD);
            content.append(StringUtils.isNotBlank((CharSequence)((CharSequence)map.get(apisBusiTaskLog.getPushType()))) ? (String)map.get(apisBusiTaskLog.getPushType()) : apisBusiTaskLog.getPushType());
            content.append(EMAIL_HTML_TABLE_TD_TD);
            content.append(apisBusiTaskLog.getPushStep());
            content.append(EMAIL_HTML_TABLE_TD_TR);
        });
        String contentText = rules.getEmailContentTpl().replaceAll(EMAIL_REPLACE, content.toString());
        ApisBusiEmailSendLog sendLog = new ApisBusiEmailSendLog(rules.getEmailSubjectTpl(), contentText, rules.getEmailToList(), rules.getEmailCcList());
        sendLog.setSendStatus("1");
        sendLog.setSendStep(BusinessConstants.DAY_ADD_NUM);
        this.emailSendLogService.save((Object)sendLog);
        log.warn("\u544a\u8b66\u53d1\u9001\u90ae\u4ef6\uff0c{}", (Object)JSON.toJSONString((Object)sendLog));
        this.emailCommonUtil.sendEmailHtml(rules.getEmailSubjectTpl(), contentText, rules.getEmailToList(), rules.getEmailCcList());
        log.warn("\u63a8\u9001\u4efb\u52a1\u8865\u507f\u540e\u4ecd\u5931\u8d25\u7684\u90ae\u4ef6\u544a\u8b66\u4efb\u52a1\u7ed3\u675f");
    }

    public void commonPushContentToUrl(ApisBusiTaskLog busiTaskLog, Function<ApisBusiTaskLog, Boolean> preFunc, Function<ApisBusiTaskLog, Object> requestFunc, BiConsumer<ApisBusiTaskLog, Object> responseHandleConsumer, Predicate<ApisBusiTaskLog> predicate, BiConsumer<ApisBusiTaskLog, Exception> exceptionHandleConsumer) {
        boolean isContinue = true;
        if (null != preFunc) {
            isContinue = preFunc.apply(busiTaskLog);
        }
        if (isContinue) {
            this.commonDoTask(busiTaskLog, apisBusiTaskLog -> {
                Object resp = requestFunc.apply(apisBusiTaskLog);
                log.warn("\u4efb\u52a1\u7c7b\u578b={}\uff0c\u4efb\u52a1businessKey={}\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{apisBusiTaskLog.getPushType(), apisBusiTaskLog.getBusinessKey(), resp.toString()});
                if (null != responseHandleConsumer) {
                    responseHandleConsumer.accept(apisBusiTaskLog, resp);
                }
                if (null != resp) {
                    apisBusiTaskLog.setErrMsg(resp.toString());
                }
            }, predicate, exceptionHandleConsumer);
        }
    }

    public void commonPushContentToUrl(ApisBusiTaskLog busiTaskLog, Function<ApisBusiTaskLog, Object> requestFunc, BiConsumer<ApisBusiTaskLog, Object> responseHandleConsumer, Predicate<ApisBusiTaskLog> predicate) {
        this.commonPushContentToUrl(busiTaskLog, null, requestFunc, responseHandleConsumer, predicate, null);
    }

    public void pushPolicyInfoToTianYuanAfterPayment(ApisBusiTaskLog busiTaskLog, int failWarnTimes) {
        this.commonPushContentToUrl(busiTaskLog, taskLog -> {
            boolean isContinue = true;
            try {
                this.dataCompleteTianYuanPolicyPushRequest(taskLog);
            }
            catch (Exception e) {
                isContinue = false;
                log.error(e.getMessage());
                taskLog.setPushStatus("4");
                taskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
                taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
                this.apisBusiTaskLogService.updateById(taskLog);
            }
            return isContinue;
        }, pushContentToUrlRequestFunc, tianYuanResponseHandleFunc, pushContentNotEmptyPredicate.and(pushTargetUrlNotEmptyPredicate), (apisBusiTaskLog, e) -> {
            if (apisBusiTaskLog.getPushStep() >= failWarnTimes) {
                QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
                apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)apisBusiTaskLog.getRemark().split(",")[0]);
                ApisBusiChannelOrder apisBusiChannelOrder = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)apisBusiChannelOrderQueryWrapper);
                this.warnSendService.convertSaveWarnSendEmail("/pushPolicyInfoToTianYuan", apisBusiChannelOrder, e instanceof ApisBusinessException ? ((ApisBusinessException)((Object)((Object)e))).getErrorCode() : "", e.getMessage());
            }
        });
    }

    public void pushDownloadUrlToTianYuanAfterPayment(ApisBusiTaskLog busiTaskLog, int failWarnTimes) {
        this.commonPushContentToUrl(busiTaskLog, taskLog -> {
            boolean isContinue = true;
            try {
                this.dataCompleteTianYuanDownloadUrlRequest(taskLog);
            }
            catch (Exception e) {
                isContinue = false;
                log.error(e.getMessage());
                taskLog.setPushStatus("4");
                taskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
                taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
                this.apisBusiTaskLogService.updateById(taskLog);
            }
            return isContinue;
        }, pushContentToUrlRequestFunc, tianYuanResponseHandleFunc, pushContentNotEmptyPredicate.and(pushTargetUrlNotEmptyPredicate), (apisBusiTaskLog, e) -> {
            if (apisBusiTaskLog.getPushStep() >= failWarnTimes) {
                QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
                apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)apisBusiTaskLog.getRemark().split(",")[0]);
                ApisBusiChannelOrder apisBusiChannelOrder = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)apisBusiChannelOrderQueryWrapper);
                this.warnSendService.convertSaveWarnSendEmail("/pushDownloadUrlToTianYuan", apisBusiChannelOrder, e instanceof ApisBusinessException ? ((ApisBusinessException)((Object)((Object)e))).getErrorCode() : "", e.getMessage());
            }
        });
    }

    private void dataCompleteTianYuanPolicyPushRequest(ApisBusiTaskLog busiTaskLog) throws ApisBusinessException {
        if (StrUtil.isBlank((CharSequence)busiTaskLog.getPushContent()) && StrUtil.isNotBlank((CharSequence)busiTaskLog.getRemark())) {
            Map agencyMap;
            ApisBusiChannelOrderExt apisBusiChannelOrderExt;
            String policyNo = null;
            String userCode = null;
            String[] policyNoAndUserCodeArr = busiTaskLog.getRemark().split(",");
            policyNo = policyNoAndUserCodeArr[0];
            userCode = policyNoAndUserCodeArr[1];
            PolicyDTO policyDTO = this.dataCompletionUtil.getPolicyDetail(StanderRequest.builder().header(StanderHeader.builder().userCode(userCode).build()).build(), policyNo, false);
            TianYuanRequest tianYuanRequest = TianYuanRequest.builder().build();
            MainDTO main = policyDTO.getMain();
            String inRemark = main.getInRemark();
            if (StrUtil.isBlank((CharSequence)inRemark) && ObjectUtil.isNotEmpty((Object)(apisBusiChannelOrderExt = this.apisBusiChannelOrderExtService.getOrderExtByOrderId(policyNo)))) {
                inRemark = apisBusiChannelOrderExt.getInRemark();
            }
            String productId = null;
            String userId = null;
            if (StrUtil.isNotBlank((CharSequence)inRemark) && ObjectUtil.isNotEmpty((Object)(agencyMap = Splitter.on((String)",").withKeyValueSeparator("=").split((CharSequence)inRemark)))) {
                productId = (String)agencyMap.get("productid");
                userId = (String)agencyMap.get("userid");
            }
            tianYuanRequest.setProductID(productId);
            tianYuanRequest.setOrderNo(null);
            tianYuanRequest.setTransactionNo(null);
            tianYuanRequest.setPolicyNo(main.getPolicyNo());
            List itemMainDTOList = policyDTO.getCoverage().getItemList();
            if (ObjectUtil.isNotEmpty((Object)itemMainDTOList)) {
                tianYuanRequest.setTitle(((ItemMainDTO)itemMainDTOList.get(0)).getGoodsName());
                tianYuanRequest.setSchemeCode(((ItemMainDTO)itemMainDTOList.get(0)).getPlanCode());
                tianYuanRequest.setSchemeName(((ItemMainDTO)itemMainDTOList.get(0)).getPlanName());
            }
            tianYuanRequest.setInsuranceCode(main.getRiskCode());
            tianYuanRequest.setInsuranceName(main.getRiskName());
            tianYuanRequest.setInsuredName(((AppliClientDTO)policyDTO.getAppliClient().get(0)).getInsuredName());
            tianYuanRequest.setInsuredIDCard(((AppliClientDTO)policyDTO.getAppliClient().get(0)).getIdentifyNumber());
            String insuranceType = (String)ApisDataDictionaryConstants.insuranceTypeMap.get(((AppliClientDTO)policyDTO.getAppliClient().get(0)).getInsuredType());
            tianYuanRequest.setInsuranceType(insuranceType);
            List itemList = policyDTO.getCoverage().getItemList();
            int insNum = 0;
            if (ObjectUtil.isNotEmpty((Object)itemList)) {
                ArrayList<String> nameList = new ArrayList<String>();
                ArrayList<String> idNoList = new ArrayList<String>();
                for (ItemMainDTO item : itemList) {
                    List insuredList = item.getInsuredIdvList();
                    for (InsuredIdvDTO insured : insuredList) {
                        nameList.add(insured.getInsuredName());
                        idNoList.add(insured.getIdentifyNumber());
                        ++insNum;
                    }
                }
                if (ObjectUtil.isNotEmpty(nameList)) {
                    tianYuanRequest.setInsuredPersonName(CollectionUtil.join(nameList, (CharSequence)","));
                }
                if (ObjectUtil.isNotEmpty(idNoList)) {
                    tianYuanRequest.setInsuredPersonIDCard(CollectionUtil.join(idNoList, (CharSequence)","));
                }
            }
            tianYuanRequest.setInsuredPersonNumber(Integer.valueOf(insNum));
            tianYuanRequest.setState("\u5df2\u5b8c\u7ed3");
            int rationCount = 0;
            if (ObjectUtil.isNotEmpty((Object)policyDTO.getCoverage().getItemList())) {
                rationCount = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getRationCount();
            }
            tianYuanRequest.setInsuredPortion(Integer.valueOf(rationCount));
            if (ObjectUtil.isNotEmpty((Object)main.getSumPremium())) {
                tianYuanRequest.setPremium(BigDecimal.valueOf(main.getSumPremium()));
            }
            tianYuanRequest.setWayOut(main.getPaymentType());
            String seeFee = (String)ApisDataDictionaryConstants.jFeeFlagMap.get(main.getJFeeFlag());
            tianYuanRequest.setSeeFee(seeFee);
            if (ObjectUtil.isNotEmpty((Object)policyDTO.getPayPlanList()) && ObjectUtil.isNotEmpty((Object)((PayPlanDTO)policyDTO.getPayPlanList().get(0)).getPlanVat())) {
                tianYuanRequest.setPaymentAmount(BigDecimal.valueOf(((PayPlanDTO)policyDTO.getPayPlanList().get(0)).getPlanVat()).toString());
            }
            tianYuanRequest.setInsureBegin(main.getStartDateStr());
            tianYuanRequest.setInsureEnd(main.getEndDateStr());
            tianYuanRequest.setCreateTime(LocalDateTime.now());
            tianYuanRequest.setUserId(userId);
            busiTaskLog.setPushContent(JSON.toJSONString((Object)tianYuanRequest));
        }
        this.tianYuanRequestSignAndAssembleUrlParam(busiTaskLog);
        this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
    }

    private void tianYuanRequestSignAndAssembleUrlParam(ApisBusiTaskLog busiTaskLog) {
        if (StrUtil.isNotBlank((CharSequence)busiTaskLog.getPushTargetUrl())) {
            Map paramMap;
            String[] ss = busiTaskLog.getPushTargetUrl().split("\\?");
            String url = null;
            String queryString = null;
            if (ss.length >= 1) {
                url = ss[0];
            }
            if (ss.length >= 2) {
                queryString = ss[1];
            }
            String nonce = null;
            if (StrUtil.isNotBlank((CharSequence)queryString) && ObjectUtil.isNotEmpty((Object)(paramMap = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)queryString)))) {
                nonce = (String)paramMap.get("nonce");
            }
            if (ObjectUtil.isEmpty(nonce)) {
                nonce = UUID.fastUUID().toString().replaceAll("-", "");
            }
            int millisInOneSecond = 1000;
            long timestamp = System.currentTimeMillis() / (long)millisInOneSecond;
            StringBuilder sb = new StringBuilder();
            String toSign = sb.append(this.tianYuanAccount).append(this.tianYuanKey).append(nonce).append(timestamp).append(this.tianYuanKey).append(busiTaskLog.getPushContent()).toString();
            String sign = SecureUtil.md5((String)toSign);
            StringBuilder urlQueryStringBuilder = new StringBuilder();
            String urlQueryString = urlQueryStringBuilder.append("account=").append(this.tianYuanAccount).append("&nonce=").append(nonce).append("&timestamp=").append(timestamp).append("&sign=").append(sign).toString();
            busiTaskLog.setPushTargetUrl(url + "?" + urlQueryString);
        }
    }

    private void dataCompleteTianYuanDownloadUrlRequest(ApisBusiTaskLog busiTaskLog) throws ApisBusinessException {
        if (StrUtil.isBlank((CharSequence)busiTaskLog.getPushContent()) && StrUtil.isNotBlank((CharSequence)busiTaskLog.getRemark())) {
            TianYuanDownloadUrlRequest downloadUrlRequest = TianYuanDownloadUrlRequest.builder().build();
            String policyNo = null;
            String userCode = null;
            String[] policyNoAndUserCodeArr = busiTaskLog.getRemark().split(",");
            policyNo = policyNoAndUserCodeArr[0];
            userCode = policyNoAndUserCodeArr[1];
            StanderRequest request = StanderRequest.builder().header(StanderHeader.builder().bussinessType("epolicyUrl").userCode(userCode).businessKey(UUID.fastUUID().toString()).build()).ePolicyDownServiceRequest(EPolicyDownServiceRequest.builder().requestBody(EPolicyDownRequestDTO.builder().businessNo(policyNo).build()).build()).build();
            WebResponse response = this.ePolicyDownService.down(request, null, null);
            String url = null;
            if ("0".equals(response.getCode())) {
                if (response.getResult() instanceof Map) {
                    url = (String)((Map)((Object)response.getResult())).get("url");
                }
            } else {
                throw new ApisBusinessException(response.getCode(), response.getMessage());
            }
            downloadUrlRequest.setPolicyNo(policyNo);
            downloadUrlRequest.setDownloadUrl(url);
            busiTaskLog.setPushContent(JSON.toJSONString((Object)downloadUrlRequest));
        }
        this.tianYuanRequestSignAndAssembleUrlParam(busiTaskLog);
        this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
    }

    public void pushBudgetResultToAgent(ApisBusiTaskLog busiTaskLog) {
        this.commonPushContentToUrl(busiTaskLog, pushContentToUrlRequestFunc, null, pushContentNotEmptyPredicate);
    }
}

