/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.ThyroidAddressService;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ThyroidInquireDataRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ThyroidInquiryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ThyroidNoticeDataRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.thyroid.ThyroidCommentResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.thyroid.ThyroidInquireResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiReqmsgLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiThyroidAddressLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiThyroidResultLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiReqmsgLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiThyroidAddressLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiThyroidResultLogService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiProperties;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiServProperties;
import com.jdaz.sinosoftgz.coreapi.common.factory.CoreDtoConverterFactory;
import com.jdaz.sinosoftgz.coreapi.common.handler.CoreDtoConverter;
import com.jdaz.sinosoftgz.coreapi.h5img.MediaUploadApi;
import com.sinosoft.image.client.dto.ImgBatchUploadMetaDTO;
import com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO;
import com.sinosoft.image.client.dto.ImgBusiDTO;
import com.sinosoft.image.client.dto.RequestHeadDTO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Encoder;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ThyroidUtil {
    private Logger log = LoggerFactory.getLogger(ThyroidUtil.class);
    @Autowired
    ThyroidAddressService thyroidAddressService;
    @Autowired
    ApisBusiThyroidResultLogService apisBusiThyroidResultLogService;
    @Autowired
    ApisBusiThyroidAddressLogService apisBusiThyroidAddressLogService;
    @Autowired
    CoreApiProperties coreApiProperties;
    @Autowired
    CoreDtoConverterFactory coreDtoConverterFactory;
    @Autowired
    ApisBusiReqmsgLogService apisBusiReqmsgLogService;
    @Autowired
    MediaUploadApi mediaUploadApi;
    @Value(value="${thyroid.url}")
    private String url;
    @Value(value="${thyroid.appId}")
    private String appId;
    @Value(value="${thyroid.appKey}")
    private String appKey;
    @Value(value="${thyroid.publicKey}")
    private String publicKey;
    @Value(value="${thyroid.privateKey}")
    private String privateKey;

    public String createMD5Sign(String content) throws Exception {
        PrivateKey privateKey = this.getPrivateKeyByStr();
        byte[] contentBytes = content.getBytes("utf-8");
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initSign(privateKey);
        signature.update(contentBytes);
        byte[] signs = signature.sign();
        return Base64.encodeBase64String((byte[])signs);
    }

    public boolean verifyMD5Sign(String content, String sign) throws Exception {
        PublicKey publicKey = this.getPublicKeyByStr();
        byte[] contentBytes = content.getBytes("utf-8");
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initVerify(publicKey);
        signature.update(contentBytes);
        return signature.verify(Base64.decodeBase64((String)sign));
    }

    public PrivateKey getPrivateKeyByStr() throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)this.privateKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    public PublicKey getPublicKeyByStr() throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)this.publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpec);
    }

    public static String encryptRSA(String content, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        byte[] bytes = cipher.doFinal(content.getBytes("utf-8"));
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static String decryptRSA(String content, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        byte[] bytes = cipher.doFinal(Base64.decodeBase64((String)content));
        return new String(bytes, "utf-8");
    }

    public static KeyPair createKeyPair() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(512);
        KeyPair keyPair = keyGen.generateKeyPair();
        return keyPair;
    }

    @Async(value="imgBatchUploadExecutor")
    public void syncNotice(ThyroidNoticeDataRequestDTO thyroidNoticeDataRequestDTO, String url) {
        try {
            ThyroidCommentResponseDTO thyroidCommentResponseDTO = (ThyroidCommentResponseDTO)this.thyroidAddressService.thyroidSend(url, (Object)thyroidNoticeDataRequestDTO, ThyroidCommentResponseDTO.class);
            if (ObjectUtil.isNull((Object)thyroidCommentResponseDTO)) {
                this.log.warn("\u5f02\u6b65\u901a\u77e5\u6e20\u9053\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\u4e3a{}", (Object)thyroidNoticeDataRequestDTO.getSerialNumber());
            }
        }
        catch (Exception e) {
            this.log.error("error: ", (Throwable)e);
        }
    }

    @Async(value="imgBatchUploadExecutor")
    public void syncUpload(StanderRequest request, String businessNo, String oderCode) throws ApisBusinessException {
        Optional properties = this.coreApiProperties.getServProperties("batchUploadFile");
        ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = new ImgBatchUploadRequestDTO();
        RequestHeadDTO requestHeadDTO = new RequestHeadDTO();
        requestHeadDTO.setSeqNo(UUID.randomUUID().toString().replace("-", ""));
        requestHeadDTO.setRequestTime(new Date());
        requestHeadDTO.setOptComCode("apis");
        requestHeadDTO.setOptUserCode("apis");
        requestHeadDTO.setOptUserName("apis");
        requestHeadDTO.setConsumerID(((CoreApiServProperties)properties.get()).getUser());
        requestHeadDTO.setConsumerPWD(((CoreApiServProperties)properties.get()).getUserPwd());
        imgBatchUploadRequestDTO.setHeadDto(requestHeadDTO);
        ImgBusiDTO imgBusiDTO = new ImgBusiDTO();
        imgBusiDTO.setAppCode("UW");
        imgBusiDTO.setClassCode("UWA");
        imgBusiDTO.setBusinessNo(businessNo);
        imgBusiDTO.setBusiComCode("apis");
        imgBatchUploadRequestDTO.setBusiDto(imgBusiDTO);
        List imgBatchUploadMetaDTOS = this.compensateImgBatchUploadMeta(request);
        if (imgBatchUploadMetaDTOS == null) {
            this.log.warn("\u5728\u6570\u636e\u5e93\u4e2d\u65e0\u56fe\u7247\u4fe1\u606f");
            return;
        }
        imgBatchUploadRequestDTO.setUploadMetas(imgBatchUploadMetaDTOS);
        this.imgBatchUpload(imgBatchUploadRequestDTO, ((CoreApiServProperties)properties.get()).getUrl(), oderCode, request.getHeader().getUserCode());
    }

    public List<ImgBatchUploadMetaDTO> compensateImgBatchUploadMeta(StanderRequest request) throws ApisBusinessException {
        ArrayList<ImgBatchUploadMetaDTO> uploadMetaDTOList = new ArrayList<ImgBatchUploadMetaDTO>();
        ImgBatchUploadMetaDTO imgBatchUploadMetaDTO = new ImgBatchUploadMetaDTO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"serialNumber", (Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getFLThyroidDTO().getSerialNumber());
        List apisThyroidResultList = this.apisBusiThyroidResultLogService.list((Wrapper)queryWrapper);
        if (apisThyroidResultList.size() <= 0) {
            return null;
        }
        Map map = ThyroidUtil.netImageToBase64((String)((ApisBusiThyroidResultLog)apisThyroidResultList.get(0)).getFullPicUrl());
        imgBatchUploadMetaDTO.setBase64FileContent((String)map.get("base64"));
        imgBatchUploadMetaDTO.setFileOrgName("\u7532\u72b6\u817a\u6d4b\u8bc4\u53f7" + request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getFLThyroidDTO().getSerialNumber() + "." + (String)map.get("imageType"));
        imgBatchUploadMetaDTO.setImgType("|UWA_A|UWA_A99|");
        imgBatchUploadMetaDTO.setImgTypeName("|\u6295\u4fdd\u8d44\u6599|\u5176\u4ed6\u6295\u4fdd\u8d44\u6599|");
        uploadMetaDTOList.add(imgBatchUploadMetaDTO);
        return uploadMetaDTOList;
    }

    private void imgBatchUpload(ImgBatchUploadRequestDTO imgBatchUploadRequestDTO, String url, String oderCode, String userCode) {
        try {
            ClaimMediaCommitResult responseDTO = this.mediaUploadApi.batchUpload(url, imgBatchUploadRequestDTO, null);
            if (ObjectUtil.isEmpty((Object)responseDTO) || ObjectUtil.isEmpty((Object)responseDTO.getHeadDto())) {
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B80002.getValue(), ErrorBisCodeEnum.ERR_B80002.getKey());
            }
            if (responseDTO.getHeadDto().getStatus() < 0) {
                this.log.warn("\u4e0a\u4f20\u7532\u72b6\u817a\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u5931\u8d25\uff1a{}", (Object)responseDTO.getHeadDto().getErrorMessage());
                return;
            }
            this.log.warn("\u4e0a\u4f20\u7532\u72b6\u817a\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u6210\u529f\uff0c\u54cd\u5e94\u62a5\u6587:{}", (Object)responseDTO.toString());
            this.insertImgBatchUploadLog(userCode, oderCode, responseDTO);
        }
        catch (Exception e) {
            this.log.error("error: ", (Throwable)e);
        }
    }

    public void insertImgBatchUploadLog(String userCode, String orderNo, ClaimMediaCommitResult responseDTO) throws ApisBusinessException {
        try {
            CoreDtoConverter converter = this.coreDtoConverterFactory.get("JSON");
            String api = "thyroidImgBatchUpload";
            String bodyStr = converter.toPacketStr((Object)responseDTO);
            ApisBusiReqmsgLog apisBusiReqmsgLog = new ApisBusiReqmsgLog();
            apisBusiReqmsgLog.setApiCode(api);
            apisBusiReqmsgLog.setLogContent(bodyStr);
            apisBusiReqmsgLog.setLogType("2");
            apisBusiReqmsgLog.setOrderNo(orderNo);
            apisBusiReqmsgLog.setCreator(userCode);
            this.apisBusiReqmsgLogService.save((Object)apisBusiReqmsgLog);
        }
        catch (Exception e) {
            this.log.error("\u8bb0\u5f55\u7532\u72b6\u817a\u5f71\u50cf\u4e0a\u4f20\u62a5\u6587\u65f6\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)orderNo, (Object)e);
            return;
        }
    }

    public ApisBusiThyroidResultLog inserResultLog(ThyroidNoticeDataRequestDTO thyroidNoticeDataRequestDTO) {
        ApisBusiThyroidResultLog apisBusiThyroidResultLog = new ApisBusiThyroidResultLog();
        apisBusiThyroidResultLog.setSerialNumber(thyroidNoticeDataRequestDTO.getSerialNumber());
        apisBusiThyroidResultLog.setFullPicUrl(thyroidNoticeDataRequestDTO.getFullPicUrl());
        apisBusiThyroidResultLog.setIsNormal(Integer.valueOf(thyroidNoticeDataRequestDTO.getIsNormal() ? 1 : 0));
        apisBusiThyroidResultLog.setTiRads(thyroidNoticeDataRequestDTO.getTiRads());
        apisBusiThyroidResultLog.setAcr(thyroidNoticeDataRequestDTO.getAcr());
        apisBusiThyroidResultLog.setStatus(Integer.valueOf(thyroidNoticeDataRequestDTO.getStatus()));
        this.apisBusiThyroidResultLogService.save((Object)apisBusiThyroidResultLog);
        return apisBusiThyroidResultLog;
    }

    public ApisBusiThyroidResultLog thyroidValidate(String serialNumber) throws ApisBusinessException {
        ApisBusiThyroidResultLog apisBusiThyroidResultLog = null;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"serialNumber", (Object)serialNumber);
        List apisThyroidResultList = this.apisBusiThyroidResultLogService.list((Wrapper)queryWrapper);
        if (apisThyroidResultList.size() <= 0) {
            QueryWrapper queryAdressWrapper = new QueryWrapper();
            queryAdressWrapper.eq((Object)"serialNumber", (Object)serialNumber);
            List apisBusiThyroidAddressLogList = this.apisBusiThyroidAddressLogService.list((Wrapper)queryAdressWrapper);
            if (apisBusiThyroidAddressLogList.size() <= 0) {
                throw new ApisDataCompletionException("\u67e5\u8be2\u5931\u8d25,\u6ca1\u627e\u5230\u8be5\u6d41\u6c34\u53f7\u6240\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u53f7", ChannelErrorCodeEnum.ERR_C10479.getKey());
            }
            apisBusiThyroidResultLog = this.inquiryResult(((ApisBusiThyroidAddressLog)apisBusiThyroidAddressLogList.get(0)).getBzID());
        } else {
            apisBusiThyroidResultLog = (ApisBusiThyroidResultLog)apisThyroidResultList.get(0);
        }
        if ("3".compareTo(apisBusiThyroidResultLog.getTiRads()) < 0) {
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10490.getValue(), ChannelErrorCodeEnum.ERR_C10490.getKey());
        }
        return apisBusiThyroidResultLog;
    }

    public ApisBusiThyroidResultLog inquiryResult(String bzId) throws ApisBusinessException {
        ThyroidInquiryRequest thyroidInquiryRequest = ThyroidInquiryRequest.builder().data(ThyroidInquireDataRequestDTO.builder().bzId(bzId).build()).build();
        thyroidInquiryRequest.setAppId(this.appId);
        thyroidInquiryRequest.setApiCode("evaluateInfo");
        thyroidInquiryRequest.setAppKey(this.appKey);
        thyroidInquiryRequest.setVersion("1.0");
        try {
            thyroidInquiryRequest.setSign(this.createMD5Sign(JSON.toJSONString((Object)thyroidInquiryRequest.getData())));
        }
        catch (Exception e) {
            throw new ApisDataCompletionException("\u6570\u636e\u7b7e\u540d\u751f\u6210\u5931\u8d25\uff1a" + e.getMessage(), ChannelErrorCodeEnum.ERR_C10383.getKey());
        }
        ThyroidInquireResponse thyroidInquireResponse = (ThyroidInquireResponse)this.thyroidAddressService.thyroidSend(this.url, (Object)thyroidInquiryRequest, ThyroidInquireResponse.class);
        if (thyroidInquireResponse == null || thyroidInquireResponse.getCode() == null || !thyroidInquireResponse.getCode().equals("0000") || ObjectUtil.isNull((Object)thyroidInquireResponse.getData())) {
            this.log.warn("\u98ce\u6797\u67e5\u8be2\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a{}", (Object)thyroidInquireResponse.getDesc());
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10494.getValue(), ChannelErrorCodeEnum.ERR_C10494.getKey());
        }
        return this.inserResultLog(thyroidInquireResponse.getData());
    }

    public static Map<String, String> netImageToBase64(String imageUrl) throws ApisBusinessException {
        HashMap<String, String> map = new HashMap<String, String>();
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            URL url = new URL(imageUrl);
            byte[] by = new byte[1024];
            HttpURLConnection conn = null;
            URLConnection obj = url.openConnection();
            if (obj instanceof HttpURLConnection) {
                conn = (HttpURLConnection)obj;
            }
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            map.put("imageType", conn.getHeaderFields().get("Content-Type").get(0).split("/")[1]);
            InputStream is = conn.getInputStream();
            int len = -1;
            while ((len = is.read(by)) != -1) {
                data.write(by, 0, len);
            }
            is.close();
        }
        catch (IOException e) {
            throw new ApisDataCompletionException("\u56fe\u7247\u8f6cbase64\u5931\u8d25\uff1a" + e.getMessage(), ChannelErrorCodeEnum.ERR_C10479.getKey());
        }
        BASE64Encoder encoder = new BASE64Encoder();
        map.put("base64", encoder.encode(data.toByteArray()));
        return map;
    }

    public void updateAddressMsg(String serialNumber, RiskInfoDTO riskInfoDTO, String businessNo) {
        QueryWrapper apisBusiThyroidAddressLogQueryWrapper = new QueryWrapper();
        apisBusiThyroidAddressLogQueryWrapper.eq((Object)"serialNumber", (Object)serialNumber);
        ApisBusiThyroidAddressLog addressLog = (ApisBusiThyroidAddressLog)this.apisBusiThyroidAddressLogService.getOne((Wrapper)apisBusiThyroidAddressLogQueryWrapper);
        addressLog.setOrgnizationName(riskInfoDTO.getOrgnizationName());
        addressLog.setIsInsured(Integer.valueOf(Integer.parseInt(riskInfoDTO.getIsInsured())));
        addressLog.setReportTime(riskInfoDTO.getReportTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
        addressLog.setPolicyNo(businessNo);
        this.apisBusiThyroidAddressLogService.updateById((Object)addressLog);
    }

    public String getUrl() {
        return this.url;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppKey() {
        return this.appKey;
    }
}

