/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CoverageDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorseQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorseQueryServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RespondentDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiCorrectOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiWarnData;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WarnDataConvertUtil {
    private static final Logger log = LoggerFactory.getLogger(WarnDataConvertUtil.class);
    private static final String CODE_SPLIT = ",";
    @Autowired
    ApisChannelUserService apisChannelUserService;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisPfpRationMainService apisPfpRationMainService;
    @Autowired
    CoreCorrectApi coreCorrectApi;

    public ApisBusiWarnData standerWarnDataConvert(StanderRequest request, StanderResponse resp, String code, String message) {
        QuotePriceServiceRequestDTO body;
        QuotePriceServiceRequest quotePriceReq;
        ApisBusiWarnData warnData = new ApisBusiWarnData();
        warnData.setErrorCode(code);
        warnData.setErrorMessage(message);
        StanderHeader header = request.getHeader();
        if (header != null) {
            warnData.setChannelCode(header.getChannelCode());
            warnData.setUserCode(header.getUserCode());
            warnData.setCreator(header.getUserCode());
            QueryWrapper userQueryWrapper = new QueryWrapper();
            userQueryWrapper.eq((Object)"user_code", (Object)header.getUserCode());
            userQueryWrapper.eq((Object)"channel_code", (Object)header.getChannelCode());
            ApisChannelUser user = (ApisChannelUser)this.apisChannelUserService.getOne((Wrapper)userQueryWrapper);
            if (user != null) {
                warnData.setChannelName(user.getChannelName());
            }
        }
        if ((quotePriceReq = request.getQuotePriceServiceRequest()) != null && (body = quotePriceReq.getRequestBody()) != null && body.getQuotePrice() != null) {
            MainDTO main = body.getQuotePrice().getMain();
            List appliClient = body.getQuotePrice().getAppliClient();
            CoverageDTO coverage = body.getQuotePrice().getCoverage();
            if (main != null) {
                warnData.setDbid(main.getOrderNo());
                warnData.setAgencyPolicyRef(main.getOrderNo());
                warnData.setProposalNo(main.getProposalNo());
                warnData.setPolicyNo(main.getPolicyNo());
            }
            if (!CollectionUtils.isEmpty((Collection)appliClient)) {
                String applicants = appliClient.stream().map(AppliClientDTO::getInsuredName).collect(Collectors.joining(CODE_SPLIT));
                warnData.setApplicantList(applicants);
            }
            if (coverage != null && !CollectionUtils.isEmpty((Collection)coverage.getRespondents())) {
                String planCode;
                ApisPfpRationMain product;
                if (!CollectionUtils.isEmpty((Collection)coverage.getItemList()) && (product = this.getApisPfpRationMainInfo(planCode = ((ItemMainDTO)coverage.getItemList().get(0)).getGoodsCode(), "2")) != null) {
                    warnData.setProductCode(product.getProductCode());
                    warnData.setGoodsCode(product.getGoodsCode());
                }
                String respondents = coverage.getRespondents().stream().map(RespondentDTO::getInsuredName).collect(Collectors.joining(CODE_SPLIT));
                warnData.setRespondentList(respondents);
            }
        }
        if (resp != null && resp.getQuotePriceServiceResponse() != null && resp.getQuotePriceServiceResponse().getResponseBody() != null) {
            body = resp.getQuotePriceServiceResponse().getResponseBody();
            warnData.setAgencyPolicyRef(body.getAgencyPolicyRef());
            warnData.setProposalNo(body.getProposalNo());
            warnData.setPolicyNo(body.getBusinessNo());
        }
        return warnData;
    }

    public ApisBusiWarnData standerWarnDataConvert(ApisBusiChannelOrder order, String code, String message) {
        ApisBusiWarnData warnData = new ApisBusiWarnData();
        warnData.setErrorCode(code);
        warnData.setErrorMessage(message);
        if (order != null) {
            ApisPfpRationMain product;
            warnData.setProductCode(order.getProductCode());
            warnData.setUserCode(order.getCreator());
            warnData.setCreator(order.getCreator());
            warnData.setChannelCode(order.getChannelCode());
            warnData.setProposalNo(order.getProposalNo());
            warnData.setPolicyNo(order.getPolicyNo());
            warnData.setDbid(order.getOrderNo());
            warnData.setAgencyPolicyRef(order.getOrderNo());
            if (StringUtils.isNotBlank((CharSequence)order.getAgentCode()) && StringUtils.isNotBlank((CharSequence)order.getChannelCode())) {
                QueryWrapper userQueryWrapper = new QueryWrapper();
                userQueryWrapper.eq((Object)"user_code", (Object)order.getCreator());
                userQueryWrapper.eq((Object)"channel_code", (Object)order.getChannelCode());
                ApisChannelUser user = (ApisChannelUser)this.apisChannelUserService.getOne((Wrapper)userQueryWrapper);
                if (user != null) {
                    warnData.setChannelName(user.getChannelName());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)order.getPlanCode()) && (product = this.getApisPfpRationMainInfo(order.getPlanCode(), "2")) != null) {
                warnData.setGoodsCode(product.getGoodsCode());
            }
            StanderRequest request = StanderRequest.builder().header(StanderHeader.builder().userCode(order.getAgentCode()).build()).build();
            PolicyDetailRequestDTO policyDetailRequestDTO = PolicyDetailRequestDTO.builder().policyNo(order.getPolicyNo()).operateCode("all").businessNature2("all").build();
            PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(policyDetailRequestDTO).build();
            request.setPolicyDetailServiceRequest(policyDetailServiceRequest);
            StanderResponse response = this.coreInsureApi.policyDetail(request);
            if (response != null && response.getPolicyDetailResponse() != null && response.getPolicyDetailResponse().getResponseBody() != null && response.getPolicyDetailResponse().getResponseBody().getPolicy() != null) {
                PolicyDTO policy = response.getPolicyDetailResponse().getResponseBody().getPolicy();
                List appliClient = policy.getAppliClient();
                String applicantList = appliClient.stream().map(AppliClientDTO::getInsuredName).collect(Collectors.joining(CODE_SPLIT));
                warnData.setApplicantList(applicantList);
                List insuredList = policy.getInsuredList();
                String respondentList = insuredList.stream().map(InsuredDTO::getInsuredName).collect(Collectors.joining(CODE_SPLIT));
                warnData.setRespondentList(respondentList);
            }
        }
        return warnData;
    }

    public ApisBusiWarnData standerWarnDataConvert(ApisBusiCorrectOrder order, String requestUrl, String code, String message) {
        ApisBusiWarnData warnData = new ApisBusiWarnData();
        warnData.setErrorCode(code);
        warnData.setErrorMessage(message);
        warnData.setRemark(requestUrl);
        if (order != null) {
            StanderResponse response;
            warnData.setUserCode(order.getUserCode());
            warnData.setCreator(order.getUserCode());
            warnData.setChannelCode(order.getChannelCode());
            warnData.setProposalNo(order.getApplyNo());
            warnData.setPolicyNo(order.getPolicyNo());
            warnData.setAgencyPolicyRef(order.getBusinessKey());
            if (StringUtils.isNotBlank((CharSequence)order.getChannelCode())) {
                QueryWrapper userQueryWrapper = new QueryWrapper();
                userQueryWrapper.eq((Object)"user_code", (Object)order.getUserCode());
                userQueryWrapper.eq((Object)"channel_code", (Object)order.getChannelCode());
                ApisChannelUser user = (ApisChannelUser)this.apisChannelUserService.getOne((Wrapper)userQueryWrapper);
                if (user != null) {
                    warnData.setChannelName(user.getChannelName());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)order.getPlanCode())) {
                ApisPfpRationMain product = this.getApisPfpRationMainInfo(order.getPlanCode(), "2");
                if (product != null) {
                    warnData.setGoodsCode(product.getGoodsCode());
                    warnData.setProductCode(product.getProductCode());
                }
            } else if (StringUtils.isNotBlank((CharSequence)order.getApplyNo()) && ObjectUtils.isNotEmpty((Object)(response = this.endorseProcess(order.getApplyNo())))) {
                warnData.setProductCode(response.getEndorseQueryResponse().getResponseBody().getMain().getRiskCode());
            }
        }
        return warnData;
    }

    public ApisPfpRationMain getApisPfpRationMainInfo(String planCode, String rationFlag) {
        ApisPfpRationMain apisPfpRationMain = new ApisPfpRationMain();
        apisPfpRationMain.setRationCode(planCode);
        String rationFlagOne = "1";
        if (rationFlagOne.equals(rationFlag)) {
            apisPfpRationMain.setRationFlag("2");
        } else {
            apisPfpRationMain.setRationFlag(rationFlag);
        }
        apisPfpRationMain.setDeleted(Integer.valueOf(0));
        apisPfpRationMain.setValidStatus(Integer.valueOf(1));
        QueryWrapper queryWrapper = new QueryWrapper((Object)apisPfpRationMain);
        List rationMainList = new ArrayList();
        rationMainList = this.apisPfpRationMainService.list((Wrapper)queryWrapper);
        if (rationFlagOne.equals(rationFlag) && ObjectUtil.isNotEmpty(rationMainList) && rationMainList.size() > 0) {
            QueryWrapper queryWrapperT = new QueryWrapper();
            queryWrapperT.eq((Object)"ration_flag", (Object)rationFlag);
            queryWrapperT.eq((Object)"ration_code", (Object)((ApisPfpRationMain)rationMainList.get(0)).getRelateRationCode());
            queryWrapperT.eq((Object)"deleted", (Object)0);
            queryWrapperT.eq((Object)"valid_status", (Object)1);
            rationMainList = this.apisPfpRationMainService.list((Wrapper)queryWrapperT);
        }
        if (ObjectUtil.isNotEmpty(rationMainList) && rationMainList.size() > 0) {
            return (ApisPfpRationMain)rationMainList.get(0);
        }
        return null;
    }

    public StanderResponse endorseProcess(String applyNo) {
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            return null;
        }
        StanderRequest request = StanderRequest.builder().build();
        EndorseQueryServiceRequest endorseQueryServiceRequest = EndorseQueryServiceRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(EndorseQueryRequestDTO.builder().applyNo(applyNo).build()).build();
        request.setEndorseQueryServiceRequest(endorseQueryServiceRequest);
        try {
            StanderResponse response = this.coreCorrectApi.correctQuery(request);
            if (ObjectUtil.isEmpty((Object)response) || ObjectUtil.isEmpty((Object)response.getEndorseQueryResponse()) || ObjectUtil.isEmpty((Object)response.getEndorseQueryResponse().getResponseBody()) || ObjectUtil.isEmpty((Object)response.getEndorseQueryResponse().getResponseBody().getMain())) {
                log.error("\u83b7\u53d6\u6279\u5355\u4fe1\u606f\u5f02\u5e38,\u6279\u5355\u7533\u8bf7\u53f7\uff1a{}", (Object)applyNo);
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B00002.getValue(), ErrorBisCodeEnum.ERR_B00002.getKey());
            }
            return response;
        }
        catch (Exception e) {
            log.error("\u6279\u5355\u7533\u8bf7\u53f7\uff1a{}\uff0c\u8c03\u7528\u6279\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3 \u62a5\u9519\uff1a", (Object)applyNo, (Object)e);
            return null;
        }
    }

    public ApisBusiWarnData standerWarnDataConvert(StanderRequest request, String code, String message) {
        QuotePriceServiceRequestDTO body;
        QuotePriceServiceRequest quotePriceReq;
        ApisBusiWarnData warnData = new ApisBusiWarnData();
        warnData.setErrorCode(code);
        warnData.setErrorMessage(message);
        StanderHeader header = request.getHeader();
        if (header != null) {
            warnData.setChannelCode(header.getChannelCode());
            warnData.setUserCode(header.getUserCode());
            warnData.setCreator(header.getUserCode());
            QueryWrapper userQueryWrapper = new QueryWrapper();
            userQueryWrapper.eq((Object)"user_code", (Object)header.getUserCode());
            userQueryWrapper.eq((Object)"channel_code", (Object)header.getChannelCode());
            ApisChannelUser user = (ApisChannelUser)this.apisChannelUserService.getOne((Wrapper)userQueryWrapper);
            if (user != null) {
                warnData.setChannelName(user.getChannelName());
            }
        }
        if ((quotePriceReq = request.getQuotePriceServiceRequest()) != null && (body = quotePriceReq.getRequestBody()) != null && body.getQuotePrice() != null) {
            MainDTO main = body.getQuotePrice().getMain();
            List appliClient = body.getQuotePrice().getAppliClient();
            CoverageDTO coverage = body.getQuotePrice().getCoverage();
            if (main != null) {
                warnData.setDbid(main.getOrderNo());
                warnData.setAgencyPolicyRef(main.getOrderNo());
                warnData.setProposalNo(main.getProposalNo());
                warnData.setPolicyNo(main.getPolicyNo());
                warnData.setProductCode(main.getRiskCode());
            }
            if (!CollectionUtils.isEmpty((Collection)appliClient)) {
                String applicants = appliClient.stream().map(AppliClientDTO::getInsuredName).collect(Collectors.joining(CODE_SPLIT));
                warnData.setApplicantList(applicants);
            }
            if (coverage != null) {
                if (!CollectionUtils.isEmpty((Collection)coverage.getItemList())) {
                    String goodsCode = ((ItemMainDTO)coverage.getItemList().get(0)).getGoodsCode();
                    warnData.setGoodsCode(goodsCode);
                }
                if (!CollectionUtils.isEmpty((Collection)coverage.getRespondents())) {
                    String respondents = coverage.getRespondents().stream().map(RespondentDTO::getInsuredName).collect(Collectors.joining(CODE_SPLIT));
                    warnData.setRespondentList(respondents);
                }
            }
        }
        return warnData;
    }
}

