/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CallApiService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CommonsExecutorRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ZYBXRiskManagementAccidentData;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ZYBXRiskManagementRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ZYBXRiskManagementUrlDto;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CommonsValidateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ZYBXAccidentResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ZYBXAllowanceCheckDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ZYBXCommonsResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ZYBXMajorDiseaseCheckDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ZYBXSupplementaryMedicalCheckDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelConfigsMapper;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ZybxRiskManagementKindCodeEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ZybxRiskManagementCheckUtil {
    private static final Logger log = LoggerFactory.getLogger(ZybxRiskManagementCheckUtil.class);
    @Value(value="${zybxRiskManagement.systemId}")
    private String systemId;
    @Value(value="${zybxRiskManagement.token}")
    private String token;
    @Value(value="${zybxRiskManagement.accidentUrl}")
    private String accidentUrl;
    @Value(value="${zybxRiskManagement.supplementaryMedicalCheckUrl}")
    private String supplementaryMedicalCheckUrl;
    @Value(value="${zybxRiskManagement.majorDiseaseCheckUrl}")
    private String majorDiseaseCheckUrl;
    @Value(value="${zybxRiskManagement.allowanceCheckUrl}")
    private String allowanceCheckUrl;
    @Value(value="${commonsExecutorUrl.zybxRiskManagementUrl}")
    private String zybxRiskManagementUrl;
    private static final String ZYSX_RISK_MANAGEMENT_OPEN_CONFIG_CODE = "zysx_risk_management_open_code";
    private static final String RESPONSE_CODE_SUCCESS = "001";
    @Autowired
    private CallApiService callApiService;
    @Autowired
    private ApisChannelConfigsMapper apisChannelConfigsMapper;
    private static final Pattern CHINESE_PATTERN = Pattern.compile("[\u4e00-\u9fa5]");
    private static final Pattern CHINESE_PATTERN_2 = Pattern.compile("[\\u4e00-\\u9fa5|\u00b7]");

    public CommonsValidateResponseDTO callApi(ZYBXRiskManagementRequestDTO request) {
        long startTime = System.currentTimeMillis();
        CommonsValidateResponseDTO response = new CommonsValidateResponseDTO(ChannelErrorCodeEnum.ERR_C10002.getKey(), ChannelErrorCodeEnum.ERR_C10002.getValue(), request.getBussinessType());
        ZYBXCommonsResponseDTO responseDTO = (ZYBXCommonsResponseDTO)this.callApiService.callApi(request.getUrl(), (Object)request, ZYBXCommonsResponseDTO.class);
        boolean access = this.getAccess(responseDTO, request.getUrl(), request.getInsuredNum().intValue());
        if (access) {
            log.warn("\u547d\u4e2d\u4e2d\u94f6\u4fdd\u4fe1\uff1a\u8ba2\u5355\u53f7\uff1a{},\u59d3\u540d\uff1a{},\u8eab\u4efd\u8bc1\uff1a{},\u547d\u4e2d\u7684url\uff1a{}", new Object[]{request.getOrderNo(), request.getData().getPolicyHolderName(), request.getData().getCredentialsCode(), request.getUrl()});
        }
        log.warn("\u4e2d\u94f6\u4fdd\u4fe1\u63a5\u53e3\u8c03\u7528\u603b\u7528\u65f6\uff1a{}\u7528\u65f6\uff1a{}", (Object)request.getUrl(), (Object)(System.currentTimeMillis() - startTime));
        return response;
    }

    public void addZybxRiskManagementApi(StanderRequest request, List<CommonsExecutorRequestDTO> requestList) {
        if ("0".equals(this.getRiskManagementOpen())) {
            log.warn("\u4e0d\u5f00\u542f\u4e2d\u94f6\u4fdd\u4fe1\u98ce\u63a7\u68c0\u6d4b\uff0c\u4e0d\u8fdb\u884c\u63a5\u53e3\u8c03\u7528");
            return;
        }
        String riskCode = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getRiskCode();
        Double sumAmount = this.getSumAmount(request, riskCode);
        log.warn("\u4e2d\u94f6\u4fdd\u4fe1\u5b88\u62a4\u8005\uff0c\u4ea7\u54c1code = {}\uff0c\u603b\u4fdd\u989d\u4e3a\uff1a{}", (Object)riskCode, (Object)sumAmount);
        if (StringUtils.isNotEmpty((CharSequence)riskCode) && ("P070002".equals(riskCode) || "P090001".equals(riskCode) || "P070006".equals(riskCode)) && sumAmount >= 1000000.0) {
            log.warn("\u7b26\u5408\u4e2d\u94f6\u4fdd\u4fe1\u89e6\u53d1\u89c4\u5219\uff0c\u6dfb\u52a0\u9700\u8981\u8c03\u7528\u7684\u63a5\u53e3\u5230\u5e76\u53d1\u96c6\u5408\u4e2d");
            this.addApiToExecutor(request, requestList);
        } else {
            log.warn("\u4e0d\u7b26\u5408\u4e2d\u94f6\u4fdd\u4fe1\u89e6\u53d1\u89c4\u5219\uff0c\u4e0d\u6dfb\u52a0\u5230\u5e76\u53d1\u96c6\u5408\u4e2d");
        }
    }

    public Double getSumAmount(StanderRequest request, String riskCode) {
        List itemList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList();
        int insuredNum = 1;
        if (RiskCodeEnum.getType((String)riskCode) == 1) {
            insuredNum = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList().size();
        } else if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getInsuredList())) {
            insuredNum = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getInsuredList().size();
        }
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (ItemMainDTO mainDTO : itemList) {
            List itemKindDTOList = mainDTO.getItemKind();
            sumAmount = itemKindDTOList.stream().filter(f -> f.getCalculateInd().equals("1")).map(ItemKindDTO::getSumInsured).reduce(sumAmount, BigDecimal::add);
        }
        return sumAmount.divide(new BigDecimal(insuredNum), 2, 4).doubleValue();
    }

    public void addApiToExecutor(StanderRequest request, List<CommonsExecutorRequestDTO> requestList) {
        List itemList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList();
        List<Object> urlDtoList = new ArrayList();
        for (ItemMainDTO itemMainDTO : itemList) {
            List list = itemMainDTO.getItemKind();
            for (ItemKindDTO kindDTO : list) {
                urlDtoList.addAll(this.getUrlByEnum(kindDTO.getClauseCode()));
            }
        }
        urlDtoList = urlDtoList.stream().filter(this.distinctByKey(u -> u.getUrlCode())).collect(Collectors.toList());
        log.warn("\u4e2d\u94f6\u4fdd\u4fe1\u547d\u4e2d\u7684url\u4e3a\uff1a{}", urlDtoList);
        List insuredIdvList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList();
        for (ZYBXRiskManagementUrlDto zYBXRiskManagementUrlDto : urlDtoList) {
            for (InsuredIdvDTO insuredIdvDTO : insuredIdvList) {
                String orderNo = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo();
                this.completionData(this.getUrl(zYBXRiskManagementUrlDto.getUrl()), insuredIdvDTO, request.getQuotePriceServiceRequest().getRequestHead().getConsumerSeqNo(), zYBXRiskManagementUrlDto.getCode(), requestList, orderNo, insuredIdvList.size());
            }
        }
    }

    public List<ZYBXRiskManagementUrlDto> getUrlByEnum(String code) {
        ArrayList<ZYBXRiskManagementUrlDto> urlDtoList = new ArrayList<ZYBXRiskManagementUrlDto>();
        for (ZybxRiskManagementKindCodeEnum kindCodeEnum : ZybxRiskManagementKindCodeEnum.values()) {
            if (!code.equals(kindCodeEnum.getCode())) continue;
            urlDtoList.add(new ZYBXRiskManagementUrlDto().url(kindCodeEnum.getType()).urlCode(kindCodeEnum.getType() + "_" + code).code(code));
        }
        return urlDtoList;
    }

    public <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public void completionData(String url, InsuredIdvDTO insuredIdvDTO, String policyNo, String productCode, List<CommonsExecutorRequestDTO> requestList, String orderNo, int insuredNum) {
        ZYBXRiskManagementRequestDTO requestDTO = new ZYBXRiskManagementRequestDTO();
        requestDTO.setSystemId(this.systemId);
        requestDTO.setToken(this.token);
        requestDTO.setPolicyNo(policyNo);
        requestDTO.setOrderNo(orderNo);
        requestDTO.setInsuredNum(Integer.valueOf(insuredNum));
        ZYBXRiskManagementAccidentData data = new ZYBXRiskManagementAccidentData(insuredIdvDTO, policyNo, productCode, this.getName(insuredIdvDTO.getInsuredName()));
        requestDTO.setData(data);
        requestDTO.setUrl(url);
        requestList.add(new CommonsExecutorRequestDTO(this.zybxRiskManagementUrl, (Object)requestDTO, CommonsValidateResponseDTO.class));
    }

    public boolean getAccess(ZYBXCommonsResponseDTO response, String url, int insuredNum) {
        if (ObjectUtil.isEmpty((Object)response) || !RESPONSE_CODE_SUCCESS.equals(response.getCode())) {
            log.warn("\u8c03\u7528\u4e2d\u94f6\u4fdd\u4fe1\u63a5\u53e3\u975e\u5e38\u89c4\u54cd\u5e94\uff0c\u4e0d\u8fdb\u884c\u62e6\u622a\uff0cresponse = {}", (Object)response);
            return false;
        }
        if (url.equals(this.accidentUrl)) {
            ZYBXAccidentResponseDTO accident = (ZYBXAccidentResponseDTO)JSONObject.parseObject((String)JSON.toJSONString((Object)response.getResult()), ZYBXAccidentResponseDTO.class);
            return this.checkAccident(accident);
        }
        if (insuredNum > 1) {
            log.warn("\u8c03\u7528\u4e2d\u94f6\u4fdd\u4fe1\u63a5\u53e3\u88ab\u4fdd\u4eba\u4e2a\u6570\u5927\u4e8e1\uff0c\u4e0d\u8fdb\u884c\u62e6\u622a. \u88ab\u4fdd\u4eba\u4e2a\u6570\uff1a {}", (Object)insuredNum);
            return false;
        }
        return false;
    }

    public boolean checkAccident(ZYBXAccidentResponseDTO response) {
        return "Y".equals(response.getMultiCompany()) || "Y".equals(response.getMajorDiseasePayment()) || "Y".equals(response.getDisability()) || "Y".equals(response.getDense()) || "Y".equals(response.getAccumulativeMoney()) || "Y".equals(response.getDriveAccAccumulativeMoney()) || "Y".equals(response.getDriveDutyMultiCompany()) || "Y".equals(response.getSpecDiseasePayment());
    }

    public boolean checkSupplementaryMedical(ZYBXSupplementaryMedicalCheckDTO response) {
        return "Y".equals(response.getAbnormalCheck()) || "Y".equals(response.getAbnormalPayment()) || "Y".equals(response.getMajorDiseasePayment()) || "Y".equals(response.getSpecDiseasePayment()) || "Y".equals(response.getChronicDiseasePayment()) || "Y".equals(response.getAccumulativePaymentCount()) || "Y".equals(response.getAccumulativePaymentMoney());
    }

    public boolean checkMajorDisease(ZYBXMajorDiseaseCheckDTO response) {
        return "Y".equals(response.getAbnormalCheck()) || "Y".equals(response.getAbnormalPayment()) || "Y".equals(response.getMajorDiseasePayment()) || "Y".equals(response.getChronicDiseasePayment()) || "Y".equals(response.getMajorDiseaseMoney()) || "Y".equals(response.getMultiCompany()) || "Y".equals(response.getDense()) || "Y".equals(response.getSpecDiseasePayment());
    }

    public boolean checkAllowance(ZYBXAllowanceCheckDTO response) {
        return "Y".equals(response.getAbnormalCheck()) || "Y".equals(response.getAbnormalPayment()) || "Y".equals(response.getMajorDiseasePayment()) || "Y".equals(response.getChronicDiseasePayment()) || "Y".equals(response.getAccumulativeDayMoney()) || "Y".equals(response.getAccumulativePaymentDayCount()) || "Y".equals(response.getPaymentCountOneYear()) || "Y".equals(response.getSpecDiseasePayment());
    }

    public String getUrl(String url) {
        switch (url) {
            case "accident": {
                return this.accidentUrl;
            }
            case "majorDiseaseCheck": {
                return this.majorDiseaseCheckUrl;
            }
            case "supplementaryMedicalCheck": {
                return this.supplementaryMedicalCheckUrl;
            }
        }
        return this.allowanceCheckUrl;
    }

    public String getProductCode(String url) {
        switch (url) {
            case "accident": {
                return "11";
            }
            case "majorDiseaseCheck": {
                return "33";
            }
            case "supplementaryMedicalCheck": {
                return "22";
            }
        }
        return "44";
    }

    public String getName(String name) {
        Matcher m1 = CHINESE_PATTERN.matcher(name);
        if (m1.find()) {
            Matcher m2 = CHINESE_PATTERN_2.matcher(name);
            StringBuffer sb = new StringBuffer();
            while (m2.find()) {
                sb.append(m2.group());
            }
            return sb.toString();
        }
        return name;
    }

    public String getRiskManagementOpen() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)ZYSX_RISK_MANAGEMENT_OPEN_CONFIG_CODE);
        ApisChannelConfigs configs = (ApisChannelConfigs)this.apisChannelConfigsMapper.selectOne((Wrapper)queryWrapper);
        if (configs == null) {
            return "0";
        }
        return configs.getConfigValue();
    }
}

