/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.web;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseListQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CorrectApiController {
    private static final Logger logger = LoggerFactory.getLogger(CorrectApiController.class);
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/insure/correct"})
    public WebResponse correct(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        String status = "0";
        String errMsg = "";
        try {
            resp = this.apisBusinessService.execute("correct", request);
            status = "1";
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
            return webResponse;
        }
        catch (ApisBusinessException e) {
            errMsg = e.getMessage();
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage()).code(e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
            return webResponse;
        }
        finally {
            this.dataCompletionUtil.insertCorrectOrder(request, resp, status, errMsg);
        }
    }

    @RequestMapping(value={"/insure/correctQuery"})
    public WebResponse correctQuery(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("correctQuery", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u6279\u6539\u8be6\u60c5\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/endorseList"})
    public WebResponse correctListQuery(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("correctListQuery", request);
            int status = resp.getEndorseListQueryResponse().getResponseHead().getStatus();
            return WebResponse.builder().success(Boolean.valueOf(1 == status)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u6279\u6539\u5217\u8868\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
            responseHeadDTO.setStatus(0);
            responseHeadDTO.setAppCode(ChannelErrorCodeEnum.ERR_C10006.getKey());
            responseHeadDTO.setAppMessage(ChannelErrorCodeEnum.ERR_C10006.getValue());
            EndorseListQueryResponse endorseListQueryResponse = EndorseListQueryResponse.builder().responseHead(responseHeadDTO).build();
            resp.setEndorseListQueryResponse(endorseListQueryResponse);
            return WebResponse.builder().success(Boolean.valueOf(false)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/groupCorrect"})
    public WebResponse groupCorrect(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        String userCode = request.getHeader().getUserCode();
        try {
            TimeInterval timer = DateUtil.timer();
            EndorseServiceResponse endorseServiceResponse = this.dataCompletionUtil.judgeGroupCorrectIsRepeatRequest(request, "G002");
            logger.warn("\u5e42\u7b49\u6027\u6821\u9a8c\uff0c\u603b\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            if (ObjectUtil.isNotEmpty((Object)endorseServiceResponse)) {
                resp = StanderResponse.builder().header(request.getHeader()).endorseServiceResponse(endorseServiceResponse).build();
            } else {
                resp = this.apisBusinessService.execute("groupCorrect", request);
                logger.warn("\u56e2\u9669\u6279\u6539\u603b\u7528\u65f6, {}", (Object)timer.intervalRestart());
            }
            request.getHeader().setUserCode(userCode);
            this.dataCompletionUtil.unLock(request);
            logger.warn("\u56e2\u5355\u6279\u6539\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)resp));
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            if (!ChannelErrorCodeEnum.ERR_C10007.getKey().equals(e.getErrorCode())) {
                request.getHeader().setUserCode(userCode);
                this.dataCompletionUtil.unLock(request);
            }
            logger.warn(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage());
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage()).code(e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u56e2\u5355\u6279\u6539\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            request.getHeader().setUserCode(userCode);
            this.dataCompletionUtil.unLock(request);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/groupBudget"})
    public WebResponse groupBudget(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        String userCode = request.getHeader().getUserCode();
        try {
            TimeInterval timer = DateUtil.timer();
            EndorseServiceResponse endorseServiceResponse = this.dataCompletionUtil.judgeBudgetIsRepeatRequest(request);
            logger.warn("\u9884\u8bd5\u7b97\u5e42\u7b49\u6027\u6821\u9a8c\uff0c\u603b\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            if (ObjectUtil.isNotEmpty((Object)endorseServiceResponse)) {
                resp = StanderResponse.builder().header(request.getHeader()).endorseServiceResponse(endorseServiceResponse).build();
            } else {
                resp = this.apisBusinessService.execute("groupBudget", request);
                logger.warn("\u9884\u8bd5\u7b97\u603b\u7528\u65f6, {}", (Object)timer.intervalRestart());
            }
            request.getHeader().setUserCode(userCode);
            this.dataCompletionUtil.unLock(request);
            logger.warn("\u9884\u8bd5\u7b97\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)resp));
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            if (!ChannelErrorCodeEnum.ERR_C10007.getKey().equals(e.getErrorCode())) {
                request.getHeader().setUserCode(userCode);
                this.dataCompletionUtil.unLock(request);
            }
            logger.warn(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage());
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage()).code(e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u9884\u8bd5\u7b97\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            request.getHeader().setUserCode(userCode);
            this.dataCompletionUtil.unLock(request);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }
}

