/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.web;

import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.EPolicyDownServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EmployeePolicyResoneseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EmployeePolicyResoneseHeadDTO;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class EPolicyDownController {
    @Autowired
    private EPolicyDownServiceImpl ePolicyDownService;
    private static final String POLICY_RES_TYPE_URL = "Url";
    private static final String POLICY_RES_TYPE_STREAM = "DataStream";

    @RequestMapping(value={"/insure/ePolicy/down/stream"})
    public void ePolicyDown(@RequestBody StanderRequest request, HttpServletRequest req, HttpServletResponse resp) {
        this.ePolicyDownService.ePolicyDown(request, req, resp);
    }

    @RequestMapping(value={"/insure/ePolicy/down/url"})
    @ResponseBody
    public WebResponse down(@RequestBody StanderRequest request, HttpServletRequest req, HttpServletResponse resp) {
        return this.ePolicyDownService.down(request, req, resp);
    }

    @RequestMapping(value={"/IG_ePolicy/IG_eLink/insure/ePolicy/down/execute/{encryptHex}"})
    public void execute(@PathVariable String encryptHex, HttpServletRequest req, HttpServletResponse resp) {
        this.ePolicyDownService.execute(encryptHex, req, resp);
    }

    @RequestMapping(value={"/IG_ePolicy/IG_eLink/insure/getElectronicGuaranteeUrl"})
    @ResponseBody
    public Object testDzbh() {
        String url = this.ePolicyDownService.getElectronicGuaranteeUrl("000");
        return url;
    }

    @RequestMapping(value={"/IG_ePolicy/IG_eLink/insure/electronicGuarantee/down/execute/{encryptHex}"})
    public void electronicGuaranteeUrlExecute(@PathVariable String encryptHex, HttpServletRequest req, HttpServletResponse resp) {
        this.ePolicyDownService.electronicGuaranteeUrlExecute(encryptHex, req, resp);
    }

    @RequestMapping(value={"/IG_ePolicy/IG_eLink/insure/commonFile/down/execute/{encryptHex}"})
    public void commonFileUrlExecute(@PathVariable String encryptHex, HttpServletRequest req, HttpServletResponse resp) {
        this.ePolicyDownService.commonFileUrlExecute(encryptHex, req, resp);
    }

    @RequestMapping(value={"/IG_ePolicy/IG_eLink/insure/downPolicyByPolicyNo/execute/{encryptHex}"})
    public void downPolicyByPolicyNo(@PathVariable String encryptHex, HttpServletResponse resp) {
        this.ePolicyDownService.downPolicyByPolicyNo(encryptHex, resp);
    }

    @RequestMapping(value={"/insure/employeeVocherDown"})
    @ResponseBody
    public EmployeePolicyResoneseDTO employeeVocherDown(@RequestBody StanderRequest request, HttpServletRequest req, HttpServletResponse resp) {
        EmployeePolicyResoneseDTO standerResponse = null;
        try {
            standerResponse = this.ePolicyDownService.employeeVoucherDown(request, req, resp);
            if (POLICY_RES_TYPE_STREAM.equals(request.getPrintQueryVoucherImgUrlRequest().getRequestBody().getRepsType())) {
                return null;
            }
            return standerResponse;
        }
        catch (ApisBusinessException e) {
            standerResponse = EmployeePolicyResoneseDTO.builder().build();
            EmployeePolicyResoneseHeadDTO employeePolicyResoneseHeadDTO = EmployeePolicyResoneseHeadDTO.builder().build();
            standerResponse.setHead(employeePolicyResoneseHeadDTO);
            standerResponse.getHead().setErrorCode(e.getErrorCode());
            standerResponse.getHead().setRequestId(request.getHeader().getBusinessKey());
            standerResponse.getHead().setRequestType(request.getHeader().getOriginRequestType());
            standerResponse.getHead().setResponseCode("0");
            standerResponse.getHead().setErrorMessage(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return standerResponse;
        }
        catch (Exception e) {
            standerResponse = EmployeePolicyResoneseDTO.builder().build();
            EmployeePolicyResoneseHeadDTO employeePolicyResoneseHeadDTO = EmployeePolicyResoneseHeadDTO.builder().build();
            standerResponse.setHead(employeePolicyResoneseHeadDTO);
            standerResponse.getHead().setRequestId(request.getHeader().getBusinessKey());
            standerResponse.getHead().setRequestType(request.getHeader().getOriginRequestType());
            standerResponse.getHead().setResponseCode("0");
            standerResponse.getHead().setErrorCode(ChannelErrorCodeEnum.ERR_C10006.getKey());
            standerResponse.getHead().setErrorMessage(ChannelErrorCodeEnum.ERR_C10006.getValue());
            return standerResponse;
        }
    }
}

