/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.web;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EmployerController {
    private static final Logger logger = LoggerFactory.getLogger(EmployerController.class);
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;

    @RequestMapping(value={"/insure/underWriteQuery"})
    public WebResponse underWriteQuery(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("underWriteQuery", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message("200").code("\u6210\u529f").build();
        }
        catch (ApisBusinessException e) {
            logger.error(e.getMessage());
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage()).code(e.getErrorCode() == null ? ChannelErrorCodeEnum.ERR_C10006.getKey() : e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u96c7\u4e3b\u8d23\u4efb\u9669\u6838\u4fdd\u7ed3\u679c\u67e5\u8be2\u62a5\u9519{}", (Object)e.getMessage());
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/imageUpload"})
    public WebResponse imageUpload(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("imageUpload", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message("200").code("\u6210\u529f").build();
        }
        catch (ApisBusinessException e) {
            logger.error(e.getMessage());
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage()).code(e.getErrorCode() == null ? ChannelErrorCodeEnum.ERR_C10006.getKey() : e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u96c7\u4e3b\u8d23\u4efb\u9669\u5f71\u50cf\u4e0a\u4f20\u62a5\u9519{}", (Object)e.getMessage());
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/employeeQuotePrice"})
    public WebResponse employeeQuotePrice(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        String userCode = request.getHeader().getUserCode();
        try {
            Date startDate = new Date();
            QuotePriceServiceResponse priceServiceResponse = this.dataCompletionUtil.judgeIsRepeatRequest(request, false);
            logger.warn("\u5e42\u7b49\u6027\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            if (ObjectUtil.isNotEmpty((Object)priceServiceResponse)) {
                resp = resp.builder().header(request.getHeader()).quotePriceServiceResponse(priceServiceResponse).build();
            } else {
                Date t1 = new Date();
                resp = this.apisBusinessService.execute("employeeQuotePrice", request);
                logger.warn("\u51fa\u5355\u603b\u7528\u65f6, {}", (Object)(System.currentTimeMillis() - t1.getTime()));
            }
            request.getHeader().setUserCode(userCode);
            this.dataCompletionUtil.unLock(request);
            logger.warn("\u51fa\u5355\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)resp));
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            if (!ChannelErrorCodeEnum.ERR_C10007.getKey().equals(e.getErrorCode())) {
                request.getHeader().setUserCode(userCode);
                this.dataCompletionUtil.unLock(request);
            }
            logger.warn(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage());
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage()).code(e.getErrorCode() == null ? ChannelErrorCodeEnum.ERR_C10006.getKey() : e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u51fa\u5355\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            request.getHeader().setUserCode(userCode);
            this.dataCompletionUtil.unLock(request);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }
}

