/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.web;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.SaveInstallmentPayRecordAndPushUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.TaskUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientCheckNotifyServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorsePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.AppliClientCheckServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CorrectQuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PayerInfoChangeResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiCorrectReqMsgLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiCorrectReqMsgLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.PfpMessageService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.utils.SpringContextHolder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u627f\u4fdd\u63a5\u53e3"})
@RestController
public class InsureApiController {
    private static final Logger logger = LoggerFactory.getLogger(InsureApiController.class);
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisBusiCorrectReqMsgLogService apisBusiCorrectReqMsgLogService;
    @Autowired
    private SaveInstallmentPayRecordAndPushUtil saveInstallmentPayRecordAndPushUtil;
    @Autowired
    private ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    private TaskUtil taskUtil;
    private static String BUSINESS_TYPE_CORRECT = "E";
    private static String BUSINESS_TYPE_POLICY = "P";
    @Autowired
    PfpMessageService pfpMessageService;
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;

    @ApiOperation(value="\u51fa\u5355\u63a5\u53e3@(v1.0.0)", notes="\u51fa\u5355\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="StanderRequest", name="request", value="\u8bf7\u6c42\u5bf9\u8c61\u53c2\u6570", required=true)})
    @RequestMapping(value={"/insure/quotePrice"}, produces={"application/json;charset=UTF-8"}, consumes={"application/json"})
    public WebResponse quotePrice(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        String userCode = request.getHeader().getUserCode();
        try {
            Date startDate = new Date();
            QuotePriceServiceResponse priceServiceResponse = this.dataCompletionUtil.judgeIsRepeatRequest(request, false);
            logger.warn("\u5e42\u7b49\u6027\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            if (ObjectUtil.isNotEmpty((Object)priceServiceResponse)) {
                resp = resp.builder().header(request.getHeader()).quotePriceServiceResponse(priceServiceResponse).build();
            } else {
                Date t1 = new Date();
                resp = this.apisBusinessService.execute("quotePrice", request);
                logger.warn("\u51fa\u5355\u603b\u7528\u65f6, {}", (Object)(System.currentTimeMillis() - t1.getTime()));
            }
            request.getHeader().setUserCode(userCode);
            this.dataCompletionUtil.unLock(request);
            logger.warn("\u51fa\u5355\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)resp));
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            if (!ChannelErrorCodeEnum.ERR_C10007.getKey().equals(e.getErrorCode())) {
                request.getHeader().setUserCode(userCode);
                this.dataCompletionUtil.unLock(request);
            }
            logger.warn(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage());
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage()).code(e.getErrorCode() == null ? ChannelErrorCodeEnum.ERR_C10006.getKey() : e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u51fa\u5355\u63a5\u53e3\u51fa\u9519: ", (Throwable)e);
            request.getHeader().setUserCode(userCode);
            this.dataCompletionUtil.unLock(request);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/policyList"})
    @ApiOperation(value="\u4fdd\u5355\u5217\u8868\u67e5\u8be2@(v1.0.1)", notes="\u4fdd\u5355\u5217\u8868\u67e5\u8be2")
    public WebResponse queryPolicy(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("policyList", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4fdd\u5355\u5217\u8868\u67e5\u8be2\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/policyDetail"})
    public WebResponse policyDetail(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("policyDetail", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4fdd\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/renewalQuery"})
    public WebResponse renewalQuery(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("renewalQuery", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u53ef\u7eed\u4fdd\u67e5\u8be2\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/renewalQueryRapid"})
    public WebResponse renewalQueryRapid(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("renewalQueryRapid", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u53ef\u7eed\u4fdd\u67e5\u8be2\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/renewalPolicyQuery"})
    public WebResponse renewaPolicylQuery(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("renewalPolicyQuery", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7eed\u4fdd\u67e5\u8be2\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/renewablePolicyListQuery"})
    public WebResponse renewablePolicyListQuery(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("renewablePolicyListQuery", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u53ef\u7eed\u4fdd\u6e05\u5355\u67e5\u8be2\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/underwrit", "/insure/riskUnderwrit"})
    public WebResponse underwriting(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("underwriting", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u6838\u4fdd\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/calculate"})
    public WebResponse policyCalculate(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.calculateExecute("calculate", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message("\u6210\u529f").code("0").businessKey(resp.getHeader().getBusinessKey()).bussinessType(resp.getHeader().getBussinessType()).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).code(e.getErrorCode()).message(e.getMessage()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u4fdd\u8d39\u8bd5\u7b97\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/policyActivate"})
    public WebResponse policyActivate(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("policyActivate", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            logger.error("error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5355\u6fc0\u6d3b\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/groupPolicyActivate"})
    public WebResponse groupPolicyActivate(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            String policyNo = request.getPolicyActivateServiceRequest().getRequestBody().getBusinessNo();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"policy_no", (Object)policyNo);
            List list = this.apisBusiCorrectReqMsgLogService.list((Wrapper)queryWrapper);
            QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
            apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)policyNo);
            ApisBusiChannelOrderService apisBusiChannelOrderService = (ApisBusiChannelOrderService)SpringContextHolder.getApplicationContext().getBean(ApisBusiChannelOrderService.class);
            ApisBusiChannelOrder order = (ApisBusiChannelOrder)apisBusiChannelOrderService.getOne((Wrapper)apisBusiChannelOrderQueryWrapper);
            if (BeanUtil.isEmpty((Object)order, (String[])new String[0])) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10162.getValue(), ChannelErrorCodeEnum.ERR_C10162.getKey());
            }
            if (list.size() == 0) {
                request.getPolicyActivateServiceRequest().getRequestBody().setBusinessType(BUSINESS_TYPE_POLICY);
                request.getPolicyActivateServiceRequest().getRequestBody().setTotalPremium(order.getPremium());
                resp = this.apisBusinessService.execute("groupPolicyActivate", request);
            } else {
                List applyList = list.stream().filter(item -> "0".equals(item.getValidFlag())).collect(Collectors.toList());
                if (applyList.size() == 0) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10281.getValue(), ChannelErrorCodeEnum.ERR_C10281.getKey());
                }
                String applyNo = ((ApisBusiCorrectReqMsgLog)applyList.get(0)).getApplyNo();
                String requestContent = ((ApisBusiCorrectReqMsgLog)applyList.get(0)).getLogContent();
                CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse = null;
                try {
                    correctQuotePriceServiceResponse = (CorrectQuotePriceServiceResponse)JSON.parseObject((String)requestContent, CorrectQuotePriceServiceResponse.class);
                }
                catch (Exception e) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10201.getValue(), ChannelErrorCodeEnum.ERR_C10201.getKey());
                }
                Double sumAmount = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getSumPremium();
                BigDecimal adjustmentPremium = BigDecimal.valueOf(sumAmount);
                request.getPolicyActivateServiceRequest().getRequestBody().setBusinessType(BUSINESS_TYPE_CORRECT);
                request.getPolicyActivateServiceRequest().getRequestBody().setApplyNo(applyNo);
                request.getPolicyActivateServiceRequest().getRequestBody().setAdjustmentPremium(adjustmentPremium);
                request.getPolicyActivateServiceRequest().getRequestBody().setTotalPremium(order.getPremium());
                resp = this.apisBusinessService.execute("groupCorrectActivate", request);
            }
            return WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            logger.error("error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/insuredListQuery"})
    public WebResponse insuredIdvListQuery(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("insuredIdvListQuery", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u88ab\u4fdd\u4eba\u3001\u96c7\u5458\u6e05\u5355\u67e5\u8be2\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/authorizePlanQuery"})
    public WebResponse authorizePlanQuery(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("authorizePlanQuery", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u6388\u6743\u8ba1\u5212\u67e5\u8be2\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/debitNote"})
    public WebResponse debitNote(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("debitNote", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u6263\u6b3e\u901a\u77e5\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/planDetailQuery"})
    public WebResponse planDetailQuery(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("planDetailQuery", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u8ba1\u5212\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/planQuotationQuery"})
    public WebResponse planQuotationQuery(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("planQuotationQuery", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u8ba1\u5212\u62a5\u4ef7\u67e5\u8be2\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/refundCalculate"})
    public WebResponse calculationQuery(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("refundCalculate", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u9000\u4fdd\u4fdd\u8d39\u8ba1\u7b97\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @RequestMapping(value={"/insure/policyCorrect"})
    public WebResponse policyCorrect(@RequestBody StanderRequest request) {
        WebResponse webResponse;
        StanderResponse resp = null;
        String status = "0";
        String errMsg = null;
        try {
            EndorsePriceServiceRequest endorsePriceServiceRequest = request.getEndorsePriceServiceRequest();
            resp = ObjectUtil.isNotEmpty((Object)endorsePriceServiceRequest) && ObjectUtil.isNotEmpty((Object)endorsePriceServiceRequest.getRequestBody()) && ObjectUtil.isNotEmpty((Object)endorsePriceServiceRequest.getRequestBody().getMain()) && ObjectUtil.isNotEmpty((Object)endorsePriceServiceRequest.getRequestBody().getMain().getStartDate()) && ObjectUtil.isNotEmpty((Object)endorsePriceServiceRequest.getRequestBody().getMain().getEndDate()) ? this.apisBusinessService.execute("policyValidityCorrect", request) : this.apisBusinessService.execute("generalCorrect", request);
            status = "1";
            webResponse = WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            errMsg = e.getMessage();
            WebResponse webResponse2 = WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
            this.dataCompletionUtil.insertCorrectOrder2(request, resp, status, errMsg);
            return webResponse2;
        }
        catch (Exception e2) {
            errMsg = ChannelErrorCodeEnum.ERR_C10006.getValue();
            logger.error("\u4fdd\u5355\u6279\u6539\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e2);
            WebResponse webResponse3 = WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
            {
                catch (Throwable throwable) {
                    this.dataCompletionUtil.insertCorrectOrder2(request, resp, status, errMsg);
                    throw throwable;
                }
            }
            this.dataCompletionUtil.insertCorrectOrder2(request, resp, status, errMsg);
            return webResponse3;
        }
        this.dataCompletionUtil.insertCorrectOrder2(request, resp, status, errMsg);
        return webResponse;
    }

    @RequestMapping(value={"/insure/generalCorrect"})
    public WebResponse generalCorrect(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("generalCorrect", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u666e\u901a\u6279\u6539\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/generalCorrectCalculate"})
    public WebResponse generalCorrectCalculate(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("generalCorrectCalculate", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u666e\u901a\u6279\u6539\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/groupCorrectUnderWrite"})
    public WebResponse groupCorrectUnderWrite(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("groupCorrectUnderWrite", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u56e2\u5355\u6279\u5355\u6838\u4fdd\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/rechargePoa"})
    public WebResponse rechargePoa(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("rechargePoa", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u6682\u6536\u6b3e\u5145\u503c\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/thyroidAddress"})
    public WebResponse thyroidAddress(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("thyroidAddress", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7532\u72b6\u817a\u6d4b\u8bc4\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/thyroidNotice"})
    public WebResponse thyroidNotice(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("thyroidNotice", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0000").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7532\u72b6\u817a\u6d4b\u8bc4\u7ed3\u679c\u56de\u8c03\u901a\u77e5\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/insure/asyncQuotePrice"})
    public WebResponse asyncQuotePrice(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            TimeInterval timer = DateUtil.timer();
            QuotePriceServiceResponse priceServiceResponse = this.dataCompletionUtil.judgeIsRepeatRequest(request, true);
            logger.warn("\u5e42\u7b49\u6027\u6821\u9a8c\uff0c\u603b\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            if (ObjectUtil.isNotEmpty((Object)priceServiceResponse)) {
                resp = resp.builder().header(request.getHeader()).quotePriceServiceResponse(priceServiceResponse).build();
            } else {
                resp = this.apisBusinessService.execute("asyncQuotePrice", request);
                logger.warn("\u5f02\u6b65\u51fa\u5355\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            }
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).result((Serializable)resp).build();
            return webResponse;
        }
        catch (ApisBusinessException e) {
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
            return webResponse;
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u51fa\u5355\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
            return webResponse;
        }
        finally {
            this.dataCompletionUtil.unLock(request);
        }
    }

    @RequestMapping(value={"/insure/retryRationMessages"})
    public WebResponse testMqSync() {
        this.apisMsgMqlogsService.retryRationMessages();
        return WebResponse.builder().success(Boolean.valueOf(true)).build();
    }

    @RequestMapping(value={"/insure/printQueryVoucherImgURL"})
    public WebResponse printQueryVoucherImgUrl(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("printQueryVoucherImgURL", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u51ed\u8bc1\u4e0b\u8f7d\u5730\u5740\u67e5\u8be2\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/installmentList"})
    public WebResponse installmentList(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("installmentList", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u5206\u671f\u4ed8\u6b3e\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/insure/asyncGroupQuotePrice"})
    public WebResponse asyncGroupQuotePrice(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            TimeInterval timer = DateUtil.timer();
            QuotePriceServiceResponse priceServiceResponse = this.dataCompletionUtil.syncGroupPolicyProcess(request);
            if (ObjectUtil.isNotEmpty((Object)priceServiceResponse)) {
                resp = resp.builder().header(request.getHeader()).quotePriceServiceResponse(priceServiceResponse).build();
            } else {
                resp = this.apisBusinessService.execute("asyncGroupQuotePrice", request);
                logger.warn("\u5f02\u6b65\u51fa\u5355\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            }
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).result((Serializable)resp).build();
            return webResponse;
        }
        catch (ApisBusinessException e) {
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
            return webResponse;
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u51fa\u5355\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
            return webResponse;
        }
        finally {
            this.dataCompletionUtil.unLock(request);
        }
    }

    @RequestMapping(value={"/insure/appliCheck"})
    public WebResponse appliCheck(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            TimeInterval timer = DateUtil.timer();
            resp = this.apisBusinessService.execute("appliCheck", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u5ba2\u6237\u5ba1\u6838\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/appliCheckNotify"})
    public AppliClientCheckServiceResponse appliCheckNotify(@RequestBody AppliClientCheckNotifyServiceRequest appliClientCheckNotifyServiceRequest) {
        StanderResponse resp = null;
        StanderRequest request = StanderRequest.builder().appliClientCheckNotifyServiceRequest(appliClientCheckNotifyServiceRequest).build();
        try {
            TimeInterval timer = DateUtil.timer();
            resp = this.apisBusinessService.execute("appliCheckNotify", request);
            logger.warn("\u5ba2\u6237\u5ba1\u6838\u63a5\u53e3\u901a\u77e5\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            return resp.getAppliClientCheckServiceResponse();
        }
        catch (ApisBusinessException e) {
            logger.error("\u5ba2\u6237\u5ba1\u6838\u63a5\u53e3\u901a\u77e5\u51fa\u9519\uff1a", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("\u5ba2\u6237\u5ba1\u6838\u63a5\u53e3\u901a\u77e5\u51fa\u9519\uff1a", (Throwable)e);
        }
        return null;
    }

    @RequestMapping(value={"/insure/payerInfoChange"})
    public PayerInfoChangeResponse payerInfoChange(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("payerInfoChange", request);
            return resp.getPayerInfoChangeResponse();
        }
        catch (ApisBusinessException e) {
            return null;
        }
    }

    @RequestMapping(value={"/insure/freightHYQuotePrice"})
    public WebResponse freightHyQuotePrice(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            Date startDate = new Date();
            QuotePriceServiceResponse priceServiceResponse = this.dataCompletionUtil.syncProcessFreight(request);
            logger.warn("\u5e42\u7b49\u6027\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            if (ObjectUtil.isNotEmpty((Object)priceServiceResponse)) {
                resp = resp.builder().header(request.getHeader()).quotePriceServiceResponse(priceServiceResponse).build();
            } else {
                Date t1 = new Date();
                resp = this.apisBusinessService.execute("freightHYQuotePrice", request);
                logger.warn("\u51fa\u5355\u603b\u7528\u65f6, {}", (Object)(System.currentTimeMillis() - t1.getTime()));
            }
            this.dataCompletionUtil.unLock(request);
            logger.warn("\u51fa\u5355\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)resp));
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            if (!ChannelErrorCodeEnum.ERR_C10007.getKey().equals(e.getErrorCode())) {
                this.dataCompletionUtil.unLock(request);
            }
            logger.warn(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage());
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage()).code(e.getErrorCode() == null ? ChannelErrorCodeEnum.ERR_C10006.getKey() : e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u51fa\u5355\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            this.dataCompletionUtil.unLock(request);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/freightPolicySubmit"})
    public WebResponse freightPolicySubmit(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            Date startDate = new Date();
            Date t1 = new Date();
            resp = this.apisBusinessService.execute("freightPolicySubmit", request);
            logger.warn("\u51fa\u5355\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)resp));
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            if (!ChannelErrorCodeEnum.ERR_C10007.getKey().equals(e.getErrorCode())) {
                this.dataCompletionUtil.unLock(request);
            }
            logger.warn(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage());
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage()).code(e.getErrorCode() == null ? ChannelErrorCodeEnum.ERR_C10006.getKey() : e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u51fa\u5355\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            this.dataCompletionUtil.unLock(request);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/insure/examinatInformation"})
    public WebResponse examinatInformation(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("examinatInformation", request);
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
            return webResponse;
        }
        catch (ApisBusinessException e) {
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
            return webResponse;
        }
        finally {
            this.dataCompletionUtil.unLockExaminat(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/insure/healthInformation"})
    public WebResponse healthInformation(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("healthInformation", request);
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
            return webResponse;
        }
        catch (ApisBusinessException e) {
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
            return webResponse;
        }
        finally {
            this.dataCompletionUtil.unLockExaminat(request);
        }
    }

    @RequestMapping(value={"/insure/saveInstallmentPayRecordAndPush"})
    public WebResponse saveInstallmentPayRecordAndPush(@RequestBody StanderRequest request) {
        WebResponse webResponse = null;
        try {
            this.apisBusinessService.execute("saveInstallmentPayRecordAndPush", request);
            webResponse = WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (ApisBusinessException e) {
            logger.error("saveInstallmentPayRecordAndPush error: ", (Throwable)e);
            this.saveInstallmentPayRecordAndPushUtil.unLock(request);
            webResponse = WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(e.getMessage()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("saveInstallmentPayRecordAndPush error: ", (Throwable)e);
            this.saveInstallmentPayRecordAndPushUtil.unLock(request);
            webResponse = WebResponse.builder().success(Boolean.valueOf(false)).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        return webResponse;
    }

    @RequestMapping(value={"/insure/queryVoucherInfomation"})
    public WebResponse queryVoucherInfomation(@RequestBody StanderRequest request) {
        try {
            TimeInterval timer = DateUtil.timer();
            StanderResponse resp = this.apisBusinessService.execute("queryVoucherInfomation", request);
            logger.warn("\u7ebf\u4e0a\u51ed\u8bc1\u67e5\u8be2\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            logger.error("queryVoucherInfomation error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("queryVoucherInfomation error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
    }

    @RequestMapping(value={"/insure/declarationVoucher"})
    public WebResponse declarationVoucher(@RequestBody StanderRequest request) {
        try {
            TimeInterval timer = DateUtil.timer();
            StanderResponse standerResponse = this.apisBusinessService.execute("declarationVoucher", request);
            logger.warn("\u7ebf\u4e0a\u7533\u62a5\u51ed\u8bc1\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)standerResponse).build();
        }
        catch (ApisBusinessException e) {
            logger.error("declarationVoucher error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("declarationVoucher error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
    }

    @RequestMapping(value={"/insure/declarationVoucherAndGroupCorrect"})
    public WebResponse declarationVoucherAndGroupCorrect(@RequestBody StanderRequest request) {
        String pushUrl = null;
        if (ObjectUtil.isNotEmpty((Object)request) && ObjectUtil.isNotEmpty((Object)request.getDeclarationVoucherRequest()) && ObjectUtil.isNotEmpty((Object)request.getDeclarationVoucherRequest().getRequestBody())) {
            pushUrl = request.getDeclarationVoucherRequest().getRequestBody().getNotifyUrl();
        }
        try {
            TimeInterval timer = DateUtil.timer();
            StanderResponse standerResponse = this.apisBusinessService.execute("huaweiDeclarationVoucher", request);
            logger.warn("\u7ebf\u4e0a\u7533\u62a5\u51ed\u8bc1\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            if (StrUtil.isNotBlank((CharSequence)pushUrl)) {
                String businessKey = "VOU-" + request.getHeader().getBusinessKey();
                this.apisBusiTaskLogService.insertTaskInfo(ApisAutoTaskConstantsEnum.DECLARATION_VOUCHER_NOTIFY.getValue(), businessKey, pushUrl, JSONObject.toJSONString((Object)standerResponse));
                this.taskUtil.asyncNotice(businessKey, ApisAutoTaskConstantsEnum.DECLARATION_VOUCHER_NOTIFY.getValue());
            }
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result((Serializable)standerResponse).build();
        }
        catch (ApisBusinessException e) {
            logger.error("declarationVoucher error: ", (Throwable)e);
            WebResponse res = WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
            if (StrUtil.isNotBlank((CharSequence)pushUrl)) {
                String businessKey = request.getHeader() == null || StrUtil.isBlank((CharSequence)request.getHeader().getBusinessKey()) ? "VOU-" + UUID.fastUUID().toString().replaceAll("-", "") : "VOU-" + request.getHeader().getBusinessKey();
                this.apisBusiTaskLogService.insertTaskInfo(ApisAutoTaskConstantsEnum.DECLARATION_VOUCHER_NOTIFY.getValue(), businessKey, pushUrl, JSONObject.toJSONString((Object)res));
                this.taskUtil.asyncNotice(businessKey, ApisAutoTaskConstantsEnum.DECLARATION_VOUCHER_NOTIFY.getValue());
            }
            return res;
        }
        catch (Exception e) {
            logger.error("declarationVoucher error: ", (Throwable)e);
            WebResponse res = WebResponse.builder().success(Boolean.valueOf(false)).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
            if (StrUtil.isNotBlank((CharSequence)pushUrl)) {
                String businessKey = request.getHeader() == null || StrUtil.isBlank((CharSequence)request.getHeader().getBusinessKey()) ? "VOU-" + UUID.fastUUID().toString().replaceAll("-", "") : "VOU-" + request.getHeader().getBusinessKey();
                this.apisBusiTaskLogService.insertTaskInfo(ApisAutoTaskConstantsEnum.DECLARATION_VOUCHER_NOTIFY.getValue(), businessKey, pushUrl, JSONObject.toJSONString((Object)res));
                this.taskUtil.asyncNotice(businessKey, ApisAutoTaskConstantsEnum.DECLARATION_VOUCHER_NOTIFY.getValue());
            }
            return res;
        }
    }

    @RequestMapping(value={"/insure/paymentApply"})
    public WebResponse paymentApply(@RequestBody StanderRequest request) {
        try {
            TimeInterval timer = DateUtil.timer();
            StanderResponse standerResponse = this.apisBusinessService.execute("paymentApply", request);
            logger.warn("\u652f\u4ed8\u7533\u8bf7\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)standerResponse).build();
        }
        catch (ApisBusinessException e) {
            logger.error("declarationVoucher error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("declarationVoucher error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
    }

    @RequestMapping(value={"/insure/withholdingContract"})
    public WebResponse withholdingContract(@RequestBody StanderRequest request) {
        try {
            TimeInterval timer = DateUtil.timer();
            logger.warn("\u4ee3\u6263\u7b7e\u7ea6\u63a5\u53e3\uff0c\u8bf7\u6c42\u53c2\u6570 :{}", (Object)request);
            StanderResponse standerResponse = this.apisBusinessService.execute("withholdingContract", request);
            logger.warn("\u4ee3\u6263\u7b7e\u7ea6\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)standerResponse).build();
        }
        catch (ApisBusinessException e) {
            logger.error("declarationVoucher error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("declarationVoucher error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
    }

    @RequestMapping(value={"/insure/refundQuery"})
    public WebResponse refundQuery(@RequestBody StanderRequest request) {
        try {
            TimeInterval timer = DateUtil.timer();
            logger.warn("\u539f\u8def\u9000\u6b3e\u67e5\u8be2\u786e\u8ba4\u63a5\u53e3\uff0c\u8bf7\u6c42\u53c2\u6570 :{}", (Object)request);
            StanderResponse standerResponse = this.apisBusinessService.execute("refundQuery", request);
            logger.warn("\u539f\u8def\u9000\u6b3e\u67e5\u8be2\u786e\u8ba4\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)standerResponse).build();
        }
        catch (ApisBusinessException e) {
            logger.error("originalRefundQuerytRequest error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("originalRefundQuerytRequest error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
    }

    @RequestMapping(value={"/insure/payContractSendMsg"})
    public WebResponse payContractSendMsg(@RequestBody StanderRequest request) {
        try {
            TimeInterval timer = DateUtil.timer();
            StanderResponse standerResponse = this.apisBusinessService.execute("payContractSendSms", request);
            logger.warn("\u6536\u4ed8\u53d1\u8865\u7b7e\u7ea6\u77ed\u4fe1\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)standerResponse).build();
        }
        catch (ApisBusinessException e) {
            logger.error("payContractSendMsg error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("payContractSendMsg error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
    }

    @RequestMapping(value={"/insure/accountQuery"})
    public WebResponse accountQuery(@RequestBody StanderRequest request) {
        try {
            TimeInterval timer = DateUtil.timer();
            StanderResponse standerResponse = this.apisBusinessService.execute("accountQuery", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)standerResponse).build();
        }
        catch (ApisBusinessException e) {
            logger.error("accountQueryMsg error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("accountQueryMsg error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
    }

    @RequestMapping(value={"/insure/renewalShortLike"})
    public WebResponse renewalShortLike(@RequestBody StanderRequest request) {
        try {
            TimeInterval timer = DateUtil.timer();
            StanderResponse standerResponse = this.apisBusinessService.execute("renewalShortLike", request);
            logger.warn("\u83b7\u53d6\u7eed\u4fdd\u77ed\u8fde\u63a5\uff08\u4fdd\u53f8\u81ea\u52a9\u5e73\u53f0\u7eed\u4fdd\uff09\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
            return WebResponse.builder().success(Boolean.valueOf(true)).code("0").message("\u6210\u529f").result((Serializable)standerResponse).build();
        }
        catch (ApisBusinessException e) {
            logger.error("renewalShortLikeMsg error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("renewalShortLikeMsg error: ", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
    }

    @RequestMapping(value={"/insure/cfDrugsQuotePrice"})
    public WebResponse cfDrugsQuotePrice(@RequestBody StanderRequest request) {
        try {
            Date startDate = new Date();
            StanderResponse resp = null;
            this.dataCompletionUtil.completionNoStanderDefaultInfo(request, "cfDrugsQuotePrice");
            QuotePriceServiceResponse priceServiceResponse = this.dataCompletionUtil.judgeIsRepeatRequest(request, false);
            logger.warn("\u5e42\u7b49\u6027\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            resp = ObjectUtil.isNotEmpty((Object)priceServiceResponse) ? resp.builder().header(request.getHeader()).quotePriceServiceResponse(priceServiceResponse).build() : this.apisBusinessService.execute("cfDrugsQuotePrice", request);
            this.dataCompletionUtil.unLock(request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            logger.error("cfDrugsQuotePrice error: ", (Throwable)e);
            if (!ChannelErrorCodeEnum.ERR_C10007.getKey().equals(e.getErrorCode())) {
                this.dataCompletionUtil.unLock(request);
            }
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("cfDrugsQuotePrice error: ", (Throwable)e);
            this.dataCompletionUtil.unLock(request);
            return WebResponse.builder().success(Boolean.valueOf(false)).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
    }

    @RequestMapping(value={"/insure/basicsPolicyModify"})
    public WebResponse basicsPolicyModify(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("basicsPolicyModify", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u88ab\u4fdd\u9669\u4eba\u57fa\u7840\u4fdd\u5355\u4fe1\u606f\u4fee\u6539\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/basicsPolicyQuery"})
    public WebResponse basicsPolicyQuery(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("basicsPolicyQuery", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").result(null).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u88ab\u4fdd\u9669\u4eba\u57fa\u7840\u4fdd\u5355\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/renewalContract"})
    public WebResponse renewalContract(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("renewalContract", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).result((Serializable)resp).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).code(e.getErrorCode()).message(StringUtils.isNotEmpty((CharSequence)e.getMessage()) ? e.getMessage() : "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).result(null).build();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528DDA\u7eed\u4fdd\u7b7e\u7ea6\u63a5\u53e3\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }
}

