/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.web;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.CoreGuaranteeApi;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.LitigationCoreGuaranteeApi;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.WarnSendService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.PaymentServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.EmailCommonUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.ExecutorUtilTask;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.LitigationUtils;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.BaseResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.CommentNotifyResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiLitigationPushLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiLitigationPushLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.utils.LitigationSignUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LitigationController {
    private static final Logger logger = LoggerFactory.getLogger(LitigationController.class);
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    PaymentServiceImpl paymentService;
    @Autowired
    private CoreGuaranteeApi coreGuaranteeApi;
    @Autowired
    private ApisBusiLitigationPushLogMapper apisBusiLitigationPushLogMapper;
    @Autowired
    private EmailCommonUtil emailCommonUtil;
    @Autowired
    private LitigationCoreGuaranteeApi litigationCoreGuaranteeApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    LitigationUtils litigationUtils;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    WarnSendService warnSendService;
    @Autowired
    ExecutorUtilTask executorUtilTask;
    private static List<String> defaultPlanCode = Arrays.asList("ZR-SSBQ-FY-2C");

    @RequestMapping(value={"/insure/litigationQuotePrice"})
    public WebResponse litigationQuotePrice(@RequestBody StanderRequest request, HttpServletRequest httpRequest) {
        StanderResponse resp = null;
        try {
            this.dataCompletionUtil.completionNoStanderDefaultInfo(request, "litigationQuotePrice");
            Date startDate = new Date();
            QuotePriceServiceResponse priceServiceResponse = this.dataCompletionUtil.judgeLitigationRepeatRequest(request);
            logger.warn("\u9ad8\u9662\u5e42\u7b49\u6027\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            if (ObjectUtil.isNotEmpty((Object)priceServiceResponse)) {
                logger.warn("\u9ad8\u9662\u8ba2\u5355\u53f7\uff1a{}\uff0c\u4e0d\u91cd\u65b0\u51fa\u5355", (Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo());
                resp = resp.builder().header(request.getHeader()).quotePriceServiceResponse(priceServiceResponse).build();
            } else {
                resp = this.apisBusinessService.execute("litigationQuotePrice", request);
            }
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message("200").code("\u6210\u529f").build();
        }
        catch (ApisBusinessException e) {
            logger.error(e.getMessage());
            this.warnSendService.convertSaveWarnSendEmail(httpRequest.getRequestURI(), request, resp, e.getErrorCode() == null ? ChannelErrorCodeEnum.ERR_C10006.getKey() : e.getErrorCode(), e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage());
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage()).code(e.getErrorCode() == null ? ChannelErrorCodeEnum.ERR_C10006.getKey() : e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u9ad8\u9662\u8bc9\u8d23\u9669\u51fa\u5355\u62a5\u9519", (Throwable)e);
            this.warnSendService.convertSaveWarnSendEmail(httpRequest.getRequestURI(), request, resp, ChannelErrorCodeEnum.ERR_C10006.getKey(), e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage());
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/insure/litigationCorrect"})
    public WebResponse correct(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        String status = "0";
        String errMsg = "";
        try {
            resp = this.apisBusinessService.execute("litigationCorrect", request);
            status = "1";
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
            return webResponse;
        }
        catch (ApisBusinessException e) {
            errMsg = e.getMessage();
            WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage()).code(e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
            return webResponse;
        }
        finally {
            this.dataCompletionUtil.insertCorrectOrder(request, resp, status, errMsg);
        }
    }

    @RequestMapping(value={"/insure/litigationGerneralCorrect"})
    public WebResponse litigationGeneralCorrect(@RequestBody StanderRequest request, HttpServletRequest httpRequest) {
        Serializable resp = null;
        logger.warn("\u5f02\u6b65\u5f00\u59cb");
        this.executorUtilTask.litigationGeneralCorrectCutet(request);
        logger.warn("\u5f02\u6b65\u7ed3\u675f");
        return WebResponse.builder().success(Boolean.valueOf(true)).result(resp).message("200").code("\u6210\u529f").build();
    }

    @RequestMapping(value={"/insure/litigationRate"})
    public WebResponse gainRate(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("gainRate", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage()).code(e.getErrorCode() == null ? ChannelErrorCodeEnum.ERR_C10006.getKey() : e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/gainPaymentUrl"})
    public WebResponse gainPaymentUrl(@RequestBody StanderRequest request) {
        WebResponse resp = null;
        try {
            resp = this.litigationUtils.appletFlag() ? this.paymentService.wrapPaymentUrlInterface(request) : this.paymentService.wrapPaymentUrl(request);
            return resp;
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage()).code(e.getErrorCode() == null ? ChannelErrorCodeEnum.ERR_C10006.getKey() : e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @PostMapping(value={"/insure/litigationPushPayGuarantee"})
    public WebResponse litigationPushPayGuarantee(CommentNotifyResponseDTO request, HttpServletRequest httpRequest) {
        ApisBusiChannelOrder order = null;
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"policy_no", (Object)request.getPolicyRef());
            order = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
            BaseResponse baseResponse = null;
            baseResponse = defaultPlanCode.contains(order.getPlanCode()) ? this.coreGuaranteeApi.litigationPushPayGuarantee(request) : this.litigationCoreGuaranteeApi.litigationPushPayGuarantee(request);
            if ("200".equals(baseResponse.getCode())) {
                if ("ZR-SSBQ-FY-2C".equals(order.getPlanCode())) {
                    this.emailCommonUtil.saveLitigationBdbhEmailSendLog(request.getPolicyRef());
                    ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
                    apisBusiTaskLog.setBusinessKey(request.getPolicyRef());
                    apisBusiTaskLog.setPushStatus("1");
                    apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.BD_BH_TO_GY.getValue());
                    apisBusiTaskLog.setLastPushTime(LocalDateTime.now());
                    apisBusiTaskLog.setPushStep(Integer.valueOf(1));
                    this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
                }
                return WebResponse.builder().success(Boolean.valueOf(true)).result(null).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
            }
            logger.warn("\u63a8\u9001\u4fdd\u5355\u4fdd\u51fd\u5230\u9ad8\u9662\u5931\u8d25: {}", (Object)baseResponse.getMsg());
            this.warnSendService.convertSaveWarnSendEmail(httpRequest.getRequestURI(), order, baseResponse.getCode(), baseResponse.getMsg());
            this.saveLitigationPushLog(request);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(baseResponse.getMsg()).code(baseResponse.getCode()).build();
        }
        catch (ApisBusinessException e) {
            logger.error("\u63a8\u9001\u4fdd\u5355\u4fdd\u51fd\u5230\u9ad8\u9662\u5f02\u5e38\uff1a" + (Object)((Object)e));
            this.warnSendService.convertSaveWarnSendEmail(httpRequest.getRequestURI(), order, e.getErrorCode(), e.getMessage());
            this.saveLitigationPushLog(request);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage()).code(e.getErrorCode()).build();
        }
    }

    @RequestMapping(value={"/IG_ePolicy/IG_eLink/insure/litigation/returnBack"})
    public void litigationReturnBack(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.warn("\u9ad8\u9662\u652f\u4ed8\u94fe\u63a5\u540c\u6b65\u56de\u8c03\u63a5\u53e3\u3002\u3002\u3002");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.print("\u652f\u4ed8\u6210\u529f");
        out.flush();
    }

    @RequestMapping(value={"/insure/rulingsUpdate"})
    public WebResponse rulingsUpdate(@RequestBody StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("rulingsUpdate", request);
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage()).code(e.getErrorCode() == null ? ChannelErrorCodeEnum.ERR_C10006.getKey() : e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            logger.error("\u9ad8\u9662\u8bc9\u8d23\u9669\u66f4\u65b0\u88c1\u5b9a\u7ed3\u679c\u51fa\u9519,", (Throwable)e);
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    @RequestMapping(value={"/insure/litigation/digest"})
    public Map digest(@RequestBody Map<String, String> map) throws IOException {
        String appId = "Rs53zwJw";
        String appSecfff = "iKIwNhAQYwMEvAzhwTNPoxoTWv5sJIFo";
        String date = map.get("date");
        String requestBody = map.get("requestBody");
        String ma = LitigationSignUtil.getMsgDigest((String)appId, (String)date, (String)"15924272", (String)appSecfff);
        String mb = LitigationSignUtil.getMsgDigest((String)appId, (String)date, (String)"15924272", (String)appSecfff, (byte[])requestBody.getBytes());
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("msgDigest", ma);
        result.put("bodyDigest", mb);
        return result;
    }

    @RequestMapping(value={"/insure/litigationInvoice"})
    public WebResponse litigationInvoice(@RequestBody StanderRequest request) {
        try {
            StanderResponse resp = this.apisBusinessService.execute(request.getHeader().getBussinessType(), request);
            logger.warn(JSON.toJSONString((Object)request.getLitigationInvoiceRequest()));
            return WebResponse.builder().success(Boolean.valueOf(true)).result((Serializable)resp).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).code(ChannelErrorCodeEnum.ERR_C10002.getKey()).build();
        }
        catch (ApisBusinessException e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(e.getMessage() == null ? ChannelErrorCodeEnum.ERR_C10006.getValue() : e.getMessage()).code(e.getErrorCode() == null ? ChannelErrorCodeEnum.ERR_C10006.getKey() : e.getErrorCode()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
        catch (Exception e) {
            return WebResponse.builder().success(Boolean.valueOf(false)).result(null).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).code(ChannelErrorCodeEnum.ERR_C10006.getKey()).businessKey(request.getHeader() == null ? "" : request.getHeader().getBusinessKey()).bussinessType(request.getHeader() == null ? "" : request.getHeader().getBussinessType()).build();
        }
    }

    public void saveLitigationPushLog(CommentNotifyResponseDTO request) {
        QueryWrapper pushLogQueryWrapper = new QueryWrapper();
        pushLogQueryWrapper.eq((Object)"policy_ref", (Object)request.getPolicyRef());
        int count = this.apisBusiLitigationPushLogMapper.selectCount((Wrapper)pushLogQueryWrapper);
        if (count <= 0) {
            ApisBusiLitigationPushLog log = new ApisBusiLitigationPushLog(request);
            this.apisBusiLitigationPushLogMapper.insert((Object)log);
        }
    }
}

