/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.web;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.PaymentServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.PaymentGatewayUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.JDAZAesUtils;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.SDAesUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentGatewayChannelDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.InsuredInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PaymentNotifyMessageRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PaymentNotifyToAgentDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PolicyInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.SignContractNotifyRequest;
import com.jdaz.sinosoftgz.coreapi.common.utils.CodeConvertUtil;
import com.sinosoftgz.starter.rocketmq.utils.RocketMqUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PaymentGatewayController {
    private Logger log = LoggerFactory.getLogger(PaymentGatewayController.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private CodeConvertUtil codeConvertUtils;
    @Autowired
    private PaymentServiceImpl paymentService;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    RocketMqUtils rocketMqUtils;
    @Value(value="${payment.successPaySignConstant}")
    private String successPaySignConstant;

    @RequestMapping(value={"/paymentgateway/payment", "/paymentgateway_tls/payment", "/paymentgateway_tls_test/payment", "/paymentgateway_test/payment"})
    public void paymentGateway(PaymentGatewayChannelDTO channelDTO, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.paymentService.paymentGateway(channelDTO, request, response);
    }

    @RequestMapping(value={"/paymentgateway/payment/insure/payReturnCallBack"})
    public void payReturnCallBack(String payAppNo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.log.warn("\u540c\u6b65\u56de\u8c03\u5f00\u59cb\uff0cpayAppNo = {}", (Object)payAppNo);
        this.paymentService.payReturnCallBack(payAppNo, request, response);
    }

    @RequestMapping(value={"/paymentgateway/payment/insure/payNotifyCallBack"})
    @ResponseBody
    public Object payNotifyCallBack(@org.springframework.web.bind.annotation.RequestBody PaymentNotifyMessageRequestDTO paymentNotifyMessageRequestDTO, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.paymentService.payNotifyCallBack(paymentNotifyMessageRequestDTO, request, response);
    }

    @RequestMapping(value={"/paymentgateway/payment/signContractNotify"})
    @ResponseBody
    public Object signContractNotify(@org.springframework.web.bind.annotation.RequestBody SignContractNotifyRequest signContractNotifyRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.paymentService.signContractNotify(signContractNotifyRequest, request, response);
    }

    @RequestMapping(value={"/paymentgateway/payment/insure/wrapPaymentUrl"})
    @ResponseBody
    public Object wrapPaymentUrl(@org.springframework.web.bind.annotation.RequestBody PaymentGatewayChannelDTO channelDTO, HttpServletRequest request, HttpServletResponse response) {
        return this.paymentService.wrapPaymentUrl(channelDTO, request, response);
    }

    @RequestMapping(value={"/IG_ePolicy/IG_eLink/insure/executePayment/{paramsStr}"})
    public void executePayment(@PathVariable String paramsStr, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.paymentService.executePayment(paramsStr, request, response);
    }

    @RequestMapping(value={"/insure/paymentGateway/test"})
    public String test2(HttpServletResponse response, HttpServletRequest request) {
        return "";
    }

    @RequestMapping(value={"/insure/test/return"})
    @ResponseBody
    public String testReturn() {
        this.log.warn("\u6d4b\u8bd5\u540c\u6b65\u8fd4\u56de\uff01");
        return "";
    }

    @RequestMapping(value={"/insure/test/notify"})
    @ResponseBody
    public String testNotify(HttpServletRequest request, HttpServletResponse response) {
        Map map = request.getParameterMap();
        this.log.warn("\u63a5\u6536\u53c2\u6570\uff1a{}", (Object)map.toString());
        this.log.warn("\u6d4b\u8bd5\u5f02\u6b65\u8fd4\u56de\uff01");
        return "";
    }

    @RequestMapping(value={"/insure/test/SDAES"})
    @ResponseBody
    public String sdAES(@RequestParam(value="type") String type, @RequestParam(value="aesKey") String aesKey, @RequestParam(value="dtKey") String dtKey, HttpServletRequest request, HttpServletResponse response) {
        try {
            String result = "\u975e\u6cd5\u53c2\u6570";
            String content = IoUtil.read((InputStream)request.getInputStream(), (String)"UTF-8");
            this.log.warn("\u63a5\u6536\u53c2\u6570\uff1atype:{} ,aesKey:{},dtKey:{}", new Object[]{type, aesKey, dtKey});
            this.log.warn("\u63a5\u6536\u5185\u5bb9\uff1a{}", (Object)content);
            String seed = SDAesUtils.des3EncodeCbc((String)aesKey, (String)dtKey);
            this.log.warn("seed: {}", (Object)seed);
            if ("2".equals(type)) {
                result = SDAesUtils.decryptBase64((String)seed, (String)content);
            } else if ("1".equals(type)) {
                result = SDAesUtils.encryptBase64((String)seed, (String)content);
            }
            return result;
        }
        catch (Exception e) {
            this.log.error("sdAES error: ", (Throwable)e);
            return e.getMessage();
        }
    }

    @RequestMapping(value={"/insure/test/jdazAes"})
    @ResponseBody
    public String jdazAes(@RequestParam(value="type") String type, @RequestParam(value="userCode") String userCode, @RequestParam(value="publicKey") String publicKey, HttpServletRequest request) {
        try {
            String result = "\u975e\u6cd5\u53c2\u6570";
            String content = IoUtil.read((InputStream)request.getInputStream(), (String)"UTF-8");
            this.log.warn("\u63a5\u6536\u53c2\u6570\uff1atype:{} ,userCode:{},publicKey:{}", new Object[]{type, userCode, publicKey});
            this.log.warn("\u63a5\u6536\u5185\u5bb9\uff1a{}", (Object)content);
            String seed = JDAZAesUtils.des3EncodeCbc((String)userCode, (String)publicKey);
            this.log.warn("seed: {}", (Object)seed);
            if ("1".equals(type)) {
                result = JDAZAesUtils.encryptBase64((String)seed, (String)content);
            } else if ("2".equals(type)) {
                result = JDAZAesUtils.decryptBase64((String)seed, (String)content);
            }
            return result;
        }
        catch (Exception e) {
            this.log.error("jdazAes error: ", (Throwable)e);
            return e.getMessage();
        }
    }

    @RequestMapping(value={"/insure/test/code"})
    @ResponseBody
    public Object testCode(@RequestParam(value="key") String key, HttpServletRequest request, HttpServletResponse response) {
        Map map = this.codeConvertUtils.getCodeData(key);
        this.log.warn("\u63a5\u6536redis\uff1a{}", (Object)map.toString());
        return map;
    }

    @RequestMapping(value={"/insure/test/deleteRedis"})
    @ResponseBody
    public Object testDeleteRedis(@RequestParam(value="key") String key) {
        Set sets = this.redisTemplate.keys((Object)key);
        if (sets.size() > 0) {
            this.redisTemplate.delete((Collection)sets);
        }
        for (String string : sets) {
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("message", "\u5220\u9664\uff08" + key + "\uff09\u4e3a\u524d\u7f00\u7684\u6570\u636e\u6210\u529f");
        map.put("size", sets.size());
        return map;
    }

    @RequestMapping(value={"/insure/test/testRedis"})
    @ResponseBody
    public Object testRedis(@RequestParam(value="status") String status) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.redisTemplate.hasKey((Object)"order:2020004190959001").booleanValue() && "02".equals(this.redisTemplate.opsForHash().get((Object)"order:2020004190959001", (Object)"status").toString())) {
            result.put("status", this.redisTemplate.opsForHash().get((Object)"order:2020004190959001", (Object)"status").toString());
            result.put("result", "\u524d\u4e00\u4e2a\u8ba2\u5355\u53f7\u30102020004190959001\u3011\u8bf7\u6c42\u6b63\u5728\u5904\u7406");
            return result;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderNo", "2020004190959001");
        map.put("status", status);
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        hashOperations.putAll((Object)"order:2020004190959001", map);
        this.redisTemplate.expire((Object)"order:2020004190959001", 20L, TimeUnit.SECONDS);
        result = map;
        return result;
    }

    @RequestMapping(value={"/insure/test/testRocket"})
    @ResponseBody
    public WebResponse testRocketMQ() {
        HashMap map = new HashMap();
        WebResponse webResponse = WebResponse.builder().success(Boolean.valueOf(false)).code("-1").build();
        try {
            String str = "\n\n{\n    \"header\":{\n            \"bussinessType\":\"quotePrice\",\n            \"channelCode\":\"BA100465\",\n            \"userCode\":\"BA100465_01\",\n            \"businessKey\":\"a0504f43-de25-453a-beaf-17073d52a7ec\"\n    },\n    \"quotePriceServiceRequest\":{\n        \"requestBody\":{\n            \"quotePrice\":{\n                \"main\":{\n                    \"mainPolicyNo\":\"\",\n                    \"orderNo\":\"SD159296287276758079102-8735\",\n                    \"inputDate\":\"20200624145523\",\n                    \"startDate\":\"20200625000000\",\n                    \"endDate\":\"20210624235959\",\n                    \"outRemark\":\"\",\n                    \"sumPremium\":\"1136.00\",\n                    \"sumQuantity\":\"1\",\n                    \"handlerCode\":\"\",\n                    \"calcType\":\"\",\n                    \"outPaymentType\":\"\",\n                    \"accountCode\":\"\",\n                    \"policyRef\":\"P8611BD2007000200060259\",\n                    \"renewalType\":\"\"\n                },\n                \"renewal\":{\n                    \"autoTransRenewFlag\":\"\",\n                    \"bankName\":\"\",\n                    \"account\":\"\"\n                },\n                \"appliClient\":{\n                        \"insuredType\":\"1\",\n                        \"insuredName\":\"\u6295\u4fdd\u4eba873546\",\n                        \"identifyType\":\"01\",\n                        \"identifyNumber\":\"441424199006225144\",\n                        \"birthday\":\"\",\n                        \"mobile\":\"\",\n                        \"email\":\"\",\n                        \"insuredAddress\":\"\",\n                        \"reqFaPiao\":\"\",\n                        \"reqMail\":\"\",\n                        \"mailType\":\"\",\n                        \"reqElecFaPiao\":\"\",\n                        \"invoiceTitle\":\"\",\n                        \"phAddress\":\"\"\n                 },\n                \"sales\":{\n                    \"agentCode\":\"BA100465\",\n                    \"channelSalesName\":\"\",\n                    \"channelSalesLicenseNo\":\"\",\n                    \"groupNo\":\"\"\n                },\n                \"riskInfo\":{\n                    \"abroadDrive\":\"\",\n                    \"travelLine\":\"\",\n                    \"flightNumber\":\"\",\n                    \"AirlineNo\":\"\",\n                    \"originAirport\":\"\",\n                    \"destAirport\":\"\",\n                    \"flightDate\":\"\",\n                    \"returnFlightDate\":\"\",\n                    \"orgnizationName\":\"\",\n                    \"ReportTime\":\"\",\n                    \"IsInsured\":\"\"\n                },\n                \"fLThyroidDTO\":{\n                    \"serialNumber\":\"\"\n                },\n                \"payPlanList\":[\n                            \n                                {\n                                    \"payTimes\":1,\n                                    \"planFee\":3.00\n                                },\n                            \n                                {\n                                    \"payTimes\":2,\n                                    \"planFee\":103.00\n                                },\n                            \n                                {\n                                    \"payTimes\":3,\n                                    \"planFee\":103.00\n                                },\n                            \n                                {\n                                    \"payTimes\":4,\n                                    \"planFee\":103.00\n                                },\n                            \n                                {\n                                    \"payTimes\":5,\n                                    \"planFee\":103.00\n                                },\n                            \n                                {\n                                    \"payTimes\":6,\n                                    \"planFee\":103.00\n                                },\n                            \n                                {\n                                    \"payTimes\":7,\n                                    \"planFee\":103.00\n                                },\n                            \n                                {\n                                    \"payTimes\":8,\n                                    \"planFee\":103.00\n                                },\n                            \n                                {\n                                    \"payTimes\":9,\n                                    \"planFee\":103.00\n                                },\n                            \n                                {\n                                    \"payTimes\":10,\n                                    \"planFee\":103.00\n                                },\n                            \n                                {\n                                    \"payTimes\":11,\n                                    \"planFee\":103.00\n                                },\n                            \n                                {\n                                    \"payTimes\":12,\n                                    \"planFee\":103.00\n                                }\n                            \n                ],\n                \"coverage\":{\n                    \"itemList\":[{\n                                   \"goodsCode\":\"JJDAFA(SD)(F3)\"\n                               }],\n                    \"InsuredIdvList\":[\n                            \n                        {\n\n                             \"insuredIDCache\":\"441424195708290313\",\n                             \"applyDate\":\"\",\n                             \"socialSecurityFlag\":\"\",\n                             \"identifyType\":\"01\",\n                             \"identifyNumber\":\"441424195708290313\",\n                             \"email\":\"\",\n                             \"sex\":\"\",\n                             \"benefitModeCode\":\"\",\n                             \"benefitOrder\":\"\",\n                             \"insuredType\":\"20\",\n                             \"insuredName\":\"\u88ab\u4fdd\u9669\u4eba8735461\",\n                             \"birthday\":\"19570829000000\",\n                             \"mobile\":\"\",\n                             \"beneficiary\":[\n                                         \n                              ],\n                             \"occupationCode\":\"\",\n                             \"relationToAppnt\":\"03\",\n                             \"insuredAddress\":\"\",\n                             \"resideAddressId\":\"\",\n                             \"uwID\":\"\",\n                             \"linkerName\":\"\",\n                             \"linkerPhone\":\"\",\n                             \"questionAnswers\":[\n                                             \n                             ]\n                        }\n                            \n                    ]\n                }\n            }\n\n        }\n    }\n\n}";
            String destination = "apis-async-quotePrice:quotePrice";
            SendResult sendResult = this.rocketMqUtils.syncSendQueue(destination, (Object)str);
            if (SendStatus.SEND_OK == sendResult.getSendStatus()) {
                this.log.warn("\u6d88\u606f\u53d1\u9001\u6210\u529f\uff01");
                String string = sendResult.getMsgId();
            }
            webResponse.setCode("1");
            webResponse.setSuccess(Boolean.valueOf(true));
        }
        catch (Exception e) {
            this.log.error("error: ", (Throwable)e);
        }
        return webResponse;
    }

    @RequestMapping(value={"/insure/test/testPaymentGateway"})
    @CrossOrigin
    @ResponseBody
    public void testPaymentGateway(@org.springframework.web.bind.annotation.RequestBody PaymentGatewayChannelDTO channelDTO, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("agencyCode", channelDTO.getAgencyCode());
        map.put("notifyUrl", channelDTO.getNotifyUrl());
        map.put("paymentMethod", channelDTO.getPaymentMethod());
        map.put("policyRef", channelDTO.getPolicyRef());
        map.put("returnUrl", channelDTO.getReturnUrl());
        map.put("totalPremium", channelDTO.getTotalPremium().toString());
        String content = PaymentGatewayUtil.createLinkString(map) + this.successPaySignConstant;
        String sign = SecureUtil.md5((String)content);
        String url = "http://apis-proxy/paymentgateway/payment";
        OkHttpClient client = OkHttpUtils.getSslHttpsClient();
        FormBody.Builder builder = new FormBody.Builder();
        if (ObjectUtil.isNotEmpty((Object)channelDTO.getPolicyList())) {
            int ind = 0;
            for (PolicyInfoDTO policyInfoDTO : channelDTO.getPolicyList()) {
                builder.add("policyList[" + ind + "].policyRef", policyInfoDTO.getPolicyRef());
                builder.add("policyList[" + ind + "].premium", policyInfoDTO.getPremium().toString());
                if (ObjectUtil.isNotEmpty((Object)policyInfoDTO.getInsuredInfos())) {
                    int insInd = 0;
                    for (InsuredInfoDTO insuredInfoDTO : policyInfoDTO.getInsuredInfos()) {
                        builder.add("policyList[" + ind + "].insuredInfos[" + insInd + "].name", insuredInfoDTO.getName());
                        builder.add("policyList[" + ind + "].insuredInfos[" + insInd + "].identifyType", insuredInfoDTO.getIdentifyType());
                        builder.add("policyList[" + ind + "].insuredInfos[" + insInd + "].identifyNo", insuredInfoDTO.getIdentifyNo());
                        ++insInd;
                    }
                }
                ++ind;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)channelDTO.getEndorsePayFlag())) {
            builder.add("endorsePayFlag", channelDTO.getEndorsePayFlag());
        }
        if (StringUtils.isNotBlank((CharSequence)channelDTO.getEntrustPayFlag())) {
            builder.add("entrustPayFlag", channelDTO.getEntrustPayFlag());
        }
        if (StringUtils.isNotBlank((CharSequence)channelDTO.getOrderNo())) {
            builder.add("orderNo", channelDTO.getOrderNo());
        }
        FormBody requestBody = builder.add("policyRef", channelDTO.getPolicyRef()).add("agencyCode", channelDTO.getAgencyCode()).add("totalPremium", channelDTO.getTotalPremium().toString()).add("paymentMethod", channelDTO.getPaymentMethod()).add("notifyUrl", channelDTO.getNotifyUrl()).add("returnUrl", channelDTO.getReturnUrl()).add("sign", sign).build();
        Request req = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        try {
            Response resp = client.newCall(req).execute();
            String respStr = resp.body().string();
            this.log.warn(respStr);
            response.getWriter().print(respStr);
            response.getWriter().flush();
        }
        catch (IOException e) {
            this.log.error("error: ", (Throwable)e);
        }
    }

    @RequestMapping(value={"/insure/test/testPaymentAsyncCallback"})
    public void testPaymentAsyncCallbackNotify(PaymentNotifyToAgentDTO paymentNotifyToAgentDTO) {
        this.log.warn("\u652f\u4ed8\u5f02\u6b65\u56de\u8c03\u901a\u77e5\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)paymentNotifyToAgentDTO));
    }

    @RequestMapping(value={"/insure/test/testPaymentReturnCallback"})
    public void testPaymentReturnCallBack(PaymentNotifyToAgentDTO paymentNotifyToAgentDTO) {
        this.log.warn("\u652f\u4ed8\u5f02\u6b65\u56de\u8c03\u901a\u77e5\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)paymentNotifyToAgentDTO));
    }
}

