/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.web;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CallApiService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CommonsValidateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.ExecutorUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.jms.LitigationOffLineInsureTopicsListener;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.RiskManagementService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.EPolicyDownServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BusinessUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.EmailCommonUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.LitigationUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.web.TestLocalhost;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CommonsExecutorRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskManagemengCheckRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ZYBXRiskManagementRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.EPolicyDownRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.EPolicyDownServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CommonsValidateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.RiskManagemengCheckResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ZYBXAllowanceCheckDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ZYBXCommonsResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiGuaranteeOffLineOrderLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiEmailSendLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiGuaranteeOffLineOrderLogService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TestControllerCL {
    private static final Logger log = LoggerFactory.getLogger(TestControllerCL.class);
    @Autowired
    private EPolicyDownServiceImpl ePolicyDownService;
    @Autowired
    private ApisBusiChannelOrderMapper apisBusiChannelOrderMapper;
    @Autowired
    private EmailCommonUtil emailCommonUtil;
    @Autowired
    private ApisBusiEmailSendLogMapper emailSendLogMapper;
    @Autowired
    private ApisBusiGuaranteeOffLineOrderLogService apisBusiGuaranteeOffLineOrderLogService;
    @Autowired
    private LitigationUtils litigationUtils;
    @Autowired
    private CallApiService callApiService;
    @Autowired
    private ExecutorUtil executorUtil;
    @Autowired
    private CommonsValidateUtil commonsValidateUtil;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    QuotePriceValidate quotePriceValidate;
    @Autowired
    private RiskManagementService riskManagementService;
    @Autowired
    private LitigationOffLineInsureTopicsListener litigationOffLineInsureTopicsListener;
    @Autowired
    BusinessUtils businessUtils;

    @GetMapping(value={"/insure/bdbh"})
    public Object bdbh(@RequestParam String businessNo, @RequestParam String userCode, @RequestParam String channelCode) {
        StanderRequest request = new StanderRequest();
        StanderHeader header = StanderHeader.builder().userCode(userCode).channelCode(channelCode).build();
        request.setHeader(header);
        EPolicyDownServiceRequest serviceRequest = EPolicyDownServiceRequest.builder().requestBody(EPolicyDownRequestDTO.builder().businessNo(businessNo).build()).build();
        request.setEPolicyDownServiceRequest(serviceRequest);
        WebResponse response = this.ePolicyDownService.down(request, null, null);
        HashMap hs = (HashMap)response.getResult();
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.eq((Object)"policy_no", (Object)businessNo);
        orderQueryWrapper.eq((Object)"deleted", (Object)0);
        ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusiChannelOrderMapper.selectOne((Wrapper)orderQueryWrapper);
        String bh = this.ePolicyDownService.getElectronicGuaranteeUrl(order.getProposalNo());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("\u4fdd\u5355", hs.get("url").toString());
        map.put("\u4fdd\u51fd", bh);
        return map;
    }

    @GetMapping(value={"insure/xxtb"})
    public void xxtb(@RequestBody Map<String, String> map) {
        this.litigationOffLineInsureTopicsListener.onMessage(map.get("message"));
    }

    @RequestMapping(value={"insure/pushPolicyToHighCourt"})
    public String pushPolicyToHighCourt(String policyNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.le((Object)"policy_no", (Object)policyNo);
        List list = this.apisBusiGuaranteeOffLineOrderLogService.list((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)list)) {
            ApisBusiGuaranteeOffLineOrderLog offLineOrder = (ApisBusiGuaranteeOffLineOrderLog)list.get(0);
            this.litigationUtils.pushPolicyToHighCourt(offLineOrder);
            if ("1".equals(offLineOrder.getPushStatus())) {
                return "\u6210\u529f";
            }
            return "\u5931\u8d25:" + offLineOrder.getErrMsg();
        }
        return "\u6ca1\u6709\u627e\u5230\u8bb0\u5f55";
    }

    @GetMapping(value={"insure/down"})
    public String down(@RequestBody Map<String, String> map) {
        return OkHttpUtils.getBase64EncodeByUrl((String)map.get("url"));
    }

    @PostMapping(value={"/insure/accident"})
    public ZYBXCommonsResponseDTO accident(@RequestBody ZYBXRiskManagementRequestDTO request) {
        log.warn("api: insure/accident,request = {}", (Object)request);
        ZYBXCommonsResponseDTO responseDTO = (ZYBXCommonsResponseDTO)this.callApiService.callApi(request.getUrl(), (Object)request, ZYBXCommonsResponseDTO.class);
        log.warn("accident\u63a5\u53e3\u54cd\u5e94\uff1a{}", (Object)responseDTO);
        return responseDTO;
    }

    @PostMapping(value={"/insure/supplementaryMedicalCheck"})
    public ZYBXCommonsResponseDTO supplementaryMedicalCheck(@RequestBody ZYBXRiskManagementRequestDTO request) {
        log.warn("api: insure/supplementaryMedicalCheck,request = {}", (Object)request);
        ZYBXCommonsResponseDTO checkDTO = (ZYBXCommonsResponseDTO)this.callApiService.callApi(request.getUrl(), (Object)request, ZYBXCommonsResponseDTO.class);
        log.warn("supplementaryMedicalCheck\u63a5\u53e3\u54cd\u5e94\uff1a{}", (Object)checkDTO);
        return checkDTO;
    }

    @PostMapping(value={"/insure/majorDiseaseCheck"})
    public ZYBXCommonsResponseDTO majorDiseaseCheck(@RequestBody ZYBXRiskManagementRequestDTO request) {
        log.warn("api: insure/majorDiseaseCheck,request = {}", (Object)request);
        ZYBXCommonsResponseDTO checkDTO = (ZYBXCommonsResponseDTO)this.callApiService.callApi(request.getUrl(), (Object)request, ZYBXCommonsResponseDTO.class);
        log.warn("majorDiseaseCheck\u63a5\u53e3\u54cd\u5e94\uff1a{}", (Object)checkDTO);
        return checkDTO;
    }

    @PostMapping(value={"/insure/allowanceCheck"})
    public ZYBXCommonsResponseDTO<ZYBXAllowanceCheckDTO> allowanceCheck(@RequestBody ZYBXRiskManagementRequestDTO request) {
        log.warn("api: insure/allowanceCheck,request = {}", (Object)request);
        ZYBXCommonsResponseDTO checkDTO = (ZYBXCommonsResponseDTO)this.callApiService.callApi(request.getUrl(), (Object)request, ZYBXCommonsResponseDTO.class);
        log.warn("allowanceCheck\u63a5\u53e3\u54cd\u5e94\uff1a {}", (Object)checkDTO);
        return checkDTO;
    }

    @PostMapping(value={"/concurrent"})
    public Object concurrent(@RequestBody ZYBXRiskManagementRequestDTO request) {
        ArrayList<CommonsExecutorRequestDTO> requestList = new ArrayList<CommonsExecutorRequestDTO>();
        int len = 3;
        for (int i = 0; i < len; ++i) {
            requestList.add(new CommonsExecutorRequestDTO(request.getUrl(), (Object)request, ZYBXCommonsResponseDTO.class));
        }
        try {
            return this.executorUtil.callApi(requestList);
        }
        catch (ApisBusinessException e) {
            log.error("error: ", (Throwable)e);
            return "";
        }
    }

    @PostMapping(value={"/insure/testLocalhost"})
    public String testLocalhost(@RequestBody StanderRequest request) {
        String result;
        try {
            request = this.dataCompletion(request);
            this.commonsValidateUtil.executorValidate(request, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
            result = "\u4e0d\u62e6\u622a";
        }
        catch (ApisBusinessException e) {
            log.warn("\u51fa\u5355\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            result = "\u547d\u4e2d\u98ce\u63a7";
        }
        return result;
    }

    @PostMapping(value={"/testLocalhostPost"})
    public CommonsValidateResponseDTO testLocalhostPost(@RequestBody TestLocalhost request) {
        CommonsValidateResponseDTO responseDTO = new CommonsValidateResponseDTO("0000", request.getName(), "12334");
        return responseDTO;
    }

    @GetMapping(value={"insure/sendEmailTask"})
    public void sendEmailTask() {
        QueryWrapper emailSendLogQueryWrapper = new QueryWrapper();
        emailSendLogQueryWrapper.eq((Object)"send_status", (Object)"0");
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        emailSendLogQueryWrapper.gt((Object)"create_time", (Object)cal.getTime());
        List pushLogList = this.emailSendLogMapper.selectList((Wrapper)emailSendLogQueryWrapper);
        log.warn("\u9700\u8981\u53d1\u9001\u7684\u90ae\u4ef6\u8bb0\u5f55\uff1a{}", (Object)pushLogList);
        pushLogList.forEach(p -> {
            boolean success = this.emailCommonUtil.sendEmail(p.getSubject(), p.getContent(), p.getEmailTo(), p.getEmailCc());
            if (success) {
                p.setSendStatus("1");
                p.setSendTime(new Date());
            }
            p.setSendStep(Integer.valueOf(p.getSendStep() + 1));
            p.setLastSendTime(new Date());
            p.setUpdateTime(new Date());
            this.emailSendLogMapper.updateById(p);
        });
    }

    @PostMapping(value={"insure/getBusinessNo"})
    public String getBusinessNo(@RequestBody Map<String, String> map) throws ApisBusinessException {
        long in = System.currentTimeMillis();
        String comCode = map.get("comCode");
        String riskCode = map.get("riskCode");
        String channelCode = map.get("channelCode");
        String businessNo = this.businessUtils.getBusinessNo(comCode, riskCode, channelCode);
        long out = System.currentTimeMillis() - in;
        log.warn("\u751f\u6210\u4fdd\u5355\u53f7\uff1a{}\uff0c\u8017\u65f6\uff1a{}", (Object)businessNo, (Object)out);
        return businessNo;
    }

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        request.getQuotePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"quotePriceServiceRequest");
        this.dataCompletionUtil.verifyRepeatRequest(request);
        this.dataCompletionUtil.dataCompletion(request);
        log.warn("\u6570\u636e\u8865\u5168\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.quotePriceValidate.validateRquest(request);
        log.warn("\u51fa\u5355\u89c4\u5219\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.dataCompletionUtil.settleInsuredFlag(request);
        this.dataCompletionUtil.calculateTotalPremium(request);
        log.warn("\u4fdd\u8d39\u8ba1\u7b97\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().setPlanList(null);
        this.dataCompletionUtil.riskDataCompletion(request);
        return request;
    }

    @PostMapping(value={"/IG_ePolicy/IG_eLink/insure/riskManagement"})
    public RiskManagemengCheckResponseDTO riskManagement(@RequestBody RiskManagemengCheckRequestDTO requestDTO) {
        log.warn("riskManagement\u6d4b\u8bd5\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)requestDTO));
        RiskManagemengCheckResponseDTO responseDTO = (RiskManagemengCheckResponseDTO)this.riskManagementService.riskManagementSend(requestDTO.getUrl(), (Object)requestDTO, RiskManagemengCheckResponseDTO.class);
        log.warn("riskManagement\u6d4b\u8bd5\u63a5\u53e3\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)responseDTO));
        return responseDTO;
    }
}

