/*
 * Decompiled with CFR 0.152.
 */
package ins.platform.rocketmq.consumer;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import ins.platform.rocketmq.vo.SysUserVo;
import ins.platform.rocketmq.vo.User;
import java.util.Date;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@RocketMQMessageListener(topic="user-broker", consumerGroup="apis_user_consumer", consumeMode=ConsumeMode.ORDERLY)
public class SysUserConsumer
implements RocketMQListener<User> {
    private static final Logger log = LoggerFactory.getLogger(SysUserConsumer.class);
    @Autowired
    ApisChannelUserService apisChannelUserService;

    public void onMessage(User user) {
        log.warn("get user message from mq :{}", (Object)user);
        if (user != null && user.getSysUser() != null && user.getSysUser().getUserType() != null && "3".equals(user.getSysUser().getUserType().trim())) {
            SysUserVo sysUserVo = user.getSysUser();
            String userCode = sysUserVo.getUserCode();
            ApisChannelUser queryArgs = new ApisChannelUser();
            queryArgs.setUserCode(userCode);
            QueryWrapper userQueryWrapper = new QueryWrapper((Object)queryArgs);
            ApisChannelUser channelUser = (ApisChannelUser)this.apisChannelUserService.getOne((Wrapper)userQueryWrapper);
            if (channelUser == null) {
                channelUser = new ApisChannelUser();
                channelUser.setCreator("system mq");
                channelUser.setCreateTime(new Date());
                channelUser.setUserCode(sysUserVo.getUserCode());
                channelUser.setChannelName(sysUserVo.getChannelCode());
                channelUser.setOperateCode(sysUserVo.getUserCode());
                channelUser.setMakeCom(sysUserVo.getComCode());
            } else {
                channelUser.setModifier("system mq");
                channelUser.setUpdateTime(new Date());
            }
            channelUser.setUserName(sysUserVo.getUserName());
            channelUser.setComCode(sysUserVo.getComCode());
            channelUser.setChannelCode(sysUserVo.getChannelCode());
            if (!(sysUserVo.getValidInd() != null && !sysUserVo.getValidInd().trim().equals("1") || user.getOperType() != null && "DELETE".equals(user.getOperType().trim()))) {
                channelUser.setDeleted(Integer.valueOf(0));
            } else {
                channelUser.setDeleted(Integer.valueOf(1));
                channelUser.setDeleteTime(new Date());
            }
            channelUser.setRemark("update by mq @" + new Date().toString());
            this.apisChannelUserService.saveOrUpdate((Object)channelUser);
        }
    }
}

