/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.jdhapp.aop;

import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.annotation.RequiredAuth;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.expection.ReqRespTypeException;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.rest.resp.JdhStanderResponse;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import com.jdaz.sinosoftgz.apis.constants.JdhErrorCodeEnum;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ReqExtractAspect {
    private static final Logger log = LoggerFactory.getLogger(ReqExtractAspect.class);
    private static final String CLASS_METHOD_SPLIT = "#";

    @Around(value="@annotation(requiredAuth)")
    public Object around(ProceedingJoinPoint jp, RequiredAuth requiredAuth) throws Throwable {
        String methodName = jp.getSignature().getName();
        String className = jp.getSignature().getDeclaringType().getSimpleName();
        String classMethodName = className + CLASS_METHOD_SPLIT + methodName;
        Object request = Arrays.stream(jp.getArgs()).filter(e -> e instanceof HttpServletRequest).findFirst().orElse(null);
        if (ObjectUtils.isEmpty(request) || !(request instanceof HttpServletRequest)) {
            log.error("\u65b9\u6cd5\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u5f02\u5e38\uff1a{}", (Object)classMethodName, request);
            throw new ReqRespTypeException((ErrorCode)JdhErrorCodeEnum.ERR_B1002);
        }
        log.warn("\u4eac\u4e1c\u5065\u5eb7\u9700\u6c42->\u4eac\u4e1c\u5b89\u8054request\u65b9\u6cd5\uff1a{}", (Object)classMethodName);
        String uuid = UUID.fastUUID().toString().replaceAll("-", "");
        log.warn("\u4eac\u4e1c\u5065\u5eb7\u8bf7\u6c42\uff0cUUID\u4e3a\uff1a{}", (Object)uuid);
        ((HttpServletRequest)request).setAttribute("UUID", (Object)uuid);
        Object response = jp.proceed();
        if (ObjectUtils.isEmpty((Object)response) || !(response instanceof JdhStanderResponse)) {
            log.error("\u65b9\u6cd5\uff1a{}\uff0c \u54cd\u5e94\u53c2\u6570\u7c7b\u578b\u5f02\u5e38\uff1a{}", (Object)classMethodName, ObjectUtils.isEmpty((Object)response) ? null : response.getClass());
            throw new ReqRespTypeException((ErrorCode)JdhErrorCodeEnum.ERR_B1002);
        }
        JdhStanderResponse res = (JdhStanderResponse)response;
        res.getReponse().setUuid(uuid);
        log.warn("\u4eac\u4e1c\u5065\u5eb7->\u4eac\u4e1c\u5b89\u8054response\u65b9\u6cd5\uff1a{}\uff0c \u54cd\u5e94\uff1a{}", (Object)classMethodName, (Object)JSON.toJSONString((Object)res));
        return res;
    }
}

