/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.jdhapp.expection;

import com.jdaz.sinosoftgz.apis.business.app.jdhapp.expection.AuthException;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.expection.ReqRespTypeException;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.rest.resp.JdhResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.constants.AnalysisErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import com.jdaz.sinosoftgz.apis.constants.JdhErrorCodeEnum;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionAdvice.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public JdhResponse<Object> badRequestException(MethodArgumentNotValidException e) {
        BindingResult bindingResult = e.getBindingResult();
        LinkedHashMap errorMap = new LinkedHashMap();
        bindingResult.getFieldErrors().forEach(fieldError -> errorMap.put(fieldError.getField(), fieldError.getDefaultMessage()));
        log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1a{}", errorMap);
        return this.makeJdhResponse((ErrorCode)AnalysisErrorCodeEnum.ERR_B010006, errorMap);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public JdhResponse<Object> badRequestException(IllegalArgumentException e) {
        return this.makeJdhResponse((ErrorCode)JdhErrorCodeEnum.ERR_B1004, null);
    }

    @ExceptionHandler(value={AuthException.class})
    public JdhResponse<Object> handleAuthException(AuthException e) {
        return this.makeJdhResponse((ApisBusinessException)e);
    }

    @ExceptionHandler(value={ReqRespTypeException.class})
    public JdhResponse<Object> handleReqRespTypeException(ReqRespTypeException e) {
        return this.makeJdhResponse((ApisBusinessException)e);
    }

    private JdhResponse<Object> makeJdhResponse(ApisBusinessException e) {
        return this.makeJdhResponse(e.getErrorCode(), e.getMessage(), null);
    }

    private JdhResponse<Object> makeJdhResponse(ErrorCode errorCode, Object responseData) {
        return this.makeJdhResponse(errorCode.getKey(), errorCode.getValue(), responseData);
    }

    private JdhResponse<Object> makeJdhResponse(String resultCode, String resultMsg, Object responseData) {
        JdhResponse jdhResponse = new JdhResponse();
        jdhResponse.setCode(resultCode);
        jdhResponse.setErrMsg(resultMsg);
        return jdhResponse;
    }
}

