/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.jdhapp.job;

import com.jdaz.sinosoftgz.apis.business.app.jdhapp.util.JdhClaimDrugInvoiceBusinessUtil;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="scheduling", name={"enabled"}, havingValue="true")
public class Task {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private JdhClaimDrugInvoiceBusinessUtil jdhClaimDrugInvoiceBusinessUtil;
    private Integer maxPushTimes = 3;

    @Scheduled(cron="0 0 3 * * ? ")
    public void excuteJdhInvoice() {
        if (this.lock("JDH_CLAIM_INVOICE")) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord("JDH_CLAIM_INVOICE", this.maxPushTimes);
                log.warn("\u5b9a\u65f6\u4e0a\u4f20\u53d1\u7968Job\u4efb\u52a1\u5f00\u542f\uff0c\u672c\u6b21\u9700\u8981\u4e0a\u4f20\u7684\u53d1\u7968\u6570\u91cf\u4e3a\uff1a{}", (Object)taskList.size());
                taskList.forEach(t -> this.jdhClaimDrugInvoiceBusinessUtil.upLoadMedia(t));
            }
            catch (Exception e) {
                log.error("excuteJdhInvoice error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey("JDH_CLAIM_INVOICE");
            }
        }
    }

    public boolean lock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)key, 10L, TimeUnit.MINUTES);
    }

    public void deleteByKey(String key) {
        this.redisTemplate.delete((Object)key);
    }
}

