/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.jdhapp.rest.resp;

import com.jdaz.sinosoftgz.apis.business.app.jdhapp.rest.resp.JdhResponse;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import com.jdaz.sinosoftgz.apis.constants.JdhErrorCodeEnum;
import java.io.Serializable;

public class JdhResponse<T>
implements Serializable {
    private String uuid;
    private String code;
    private String errMsg;
    private T data;

    public static <T> JdhResponse<T> success(T responseData) {
        JdhResponse jdhResponse = new JdhResponse();
        jdhResponse.setCode(JdhErrorCodeEnum.ERR_B0000.getKey());
        jdhResponse.setErrMsg(JdhErrorCodeEnum.ERR_B0000.getValue());
        jdhResponse.setData(responseData);
        return jdhResponse;
    }

    public static <T> JdhResponse<T> success(T responseData, ErrorCode errorCode) {
        JdhResponse jdhResponse = new JdhResponse();
        jdhResponse.setCode(errorCode.getKey());
        jdhResponse.setErrMsg(errorCode.getValue());
        jdhResponse.setData(responseData);
        return jdhResponse;
    }

    public static <T> JdhResponse<T> fail() {
        JdhResponse jdhResponse = new JdhResponse();
        jdhResponse.setCode(JdhErrorCodeEnum.ERR_B1002.getKey());
        jdhResponse.setErrMsg(JdhErrorCodeEnum.ERR_B1002.getValue());
        return jdhResponse;
    }

    public static <T> JdhResponse<T> fail(ErrorCode errorCode) {
        JdhResponse jdhResponse = new JdhResponse();
        jdhResponse.setCode(errorCode.getKey());
        jdhResponse.setErrMsg(errorCode.getValue());
        return jdhResponse;
    }

    public static <T> JdhResponse<T> fail(String key, String value) {
        JdhResponse jdhResponse = new JdhResponse();
        jdhResponse.setCode(key);
        jdhResponse.setErrMsg(value);
        return jdhResponse;
    }

    public static <T> JdhResponse<T> fail(String errMsg) {
        JdhResponse jdhResponse = new JdhResponse();
        jdhResponse.setCode(JdhErrorCodeEnum.ERR_B1003.getKey());
        jdhResponse.setErrMsg(errMsg);
        return jdhResponse;
    }

    public static <T> JdhResponseBuilder<T> builder() {
        return new JdhResponseBuilder();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getCode() {
        return this.code;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public T getData() {
        return (T)this.data;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdhResponse)) {
            return false;
        }
        JdhResponse other = (JdhResponse)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdhResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "JdhResponse(uuid=" + this.getUuid() + ", code=" + this.getCode() + ", errMsg=" + this.getErrMsg() + ", data=" + this.getData() + ")";
    }

    public JdhResponse(String uuid, String code, String errMsg, T data) {
        this.uuid = uuid;
        this.code = code;
        this.errMsg = errMsg;
        this.data = data;
    }

    public JdhResponse() {
    }
}

