/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.jdhapp.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.expection.ReqRespTypeException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BaseApisParamUtil {
    private static final Logger log = LoggerFactory.getLogger(BaseApisParamUtil.class);

    public static boolean isCoreResStatusSuccess(StanderResponse standerResponse, String proName) throws ReqRespTypeException {
        if (standerResponse == null || StrUtil.isEmpty((CharSequence)proName)) {
            log.error("isCoreResStatusSuccess\u65b9\u6cd5\u5165\u53c2\u5f02\u5e38, standerResponse:{}, proName:{}", (Object)standerResponse, (Object)proName);
            return false;
        }
        ResponseHeadDTO apisToCoreResHead = BaseApisParamUtil.getApisToCoreResHead((StanderResponse)standerResponse, (String)proName);
        return apisToCoreResHead != null && apisToCoreResHead.getStatus() == 1;
    }

    public static boolean isCoreResSuccess(StanderResponse standerResponse, String proName) throws ReqRespTypeException {
        return BaseApisParamUtil.isCoreResStatusSuccess((StanderResponse)standerResponse, (String)proName) && ObjectUtil.isNotEmpty((Object)BaseApisParamUtil.getApisToCoreResBody((StanderResponse)standerResponse, (String)proName));
    }

    public static void verificationResponse(StanderResponse standerResponse, String proName) throws ReqRespTypeException {
        if (!BaseApisParamUtil.isCoreResSuccess((StanderResponse)standerResponse, (String)proName)) {
            ResponseHeadDTO apisToCoreResHead = BaseApisParamUtil.getApisToCoreResHead((StanderResponse)standerResponse, (String)proName);
            if (ObjectUtils.isNotEmpty((Object)apisToCoreResHead)) {
                log.error(apisToCoreResHead.getAppMessage());
                throw new ReqRespTypeException(apisToCoreResHead.getAppMessage(), apisToCoreResHead.getAppCode());
            }
            log.error(ErrorNullValueCodeEnum.ERR_N00002.getValue() + ":{}", (Object)proName);
            throw new ReqRespTypeException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
    }

    public static void verificationRequest(StanderRequest standerRequest, String proName) throws ReqRespTypeException {
        if (ObjectUtils.isEmpty((Object)BaseApisParamUtil.getApisToCoreReqBody((StanderRequest)standerRequest, (String)proName))) {
            log.error(ErrorNullValueCodeEnum.ERR_N00001.getValue() + ":{}" + proName);
            throw new ReqRespTypeException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
    }

    public static void verificationRequest(StanderRequest standerRequest, String proName, ErrorCode errorEnum) throws ReqRespTypeException {
        if (ObjectUtils.isEmpty((Object)BaseApisParamUtil.getApisToCoreReqBody((StanderRequest)standerRequest, (String)proName))) {
            log.error(errorEnum.getValue() + ":{}" + proName);
            throw new ReqRespTypeException(errorEnum.getKey(), errorEnum.getValue());
        }
    }

    public static boolean isAllFieldEmptyExceptSpec(Object object, String ... strings) {
        return BaseApisParamUtil.isAllFieldEmptyExceptSpec((Object)object, new HashSet<String>(Arrays.asList(strings)));
    }

    public static <T extends ErrorCode> void checkFieldThrowExp(Object object, HashMap<String, String> proMap, T errCode) throws ReqRespTypeException {
        HashSet emptyFieldName = ObjectUtil.isEmpty((Object)object) ? proMap.keySet() : BaseApisParamUtil.getEmptyFieldName((Object)object, proMap.keySet());
        if (emptyFieldName.size() == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(errCode.getValue());
        stringBuilder.append("[");
        boolean isFirst = true;
        for (String fieldName : emptyFieldName) {
            if (isFirst) {
                stringBuilder.append(proMap.get(fieldName));
                isFirst = false;
                continue;
            }
            stringBuilder.append(",").append(proMap.get(fieldName));
        }
        stringBuilder.append("] \u4e0d\u80fd\u4e3a\u7a7a");
        throw new ReqRespTypeException(stringBuilder.toString(), errCode.getKey());
    }

    private static Object getProperty(Object object, String proName) throws ReqRespTypeException {
        if (object == null || StringUtils.isEmpty((CharSequence)proName)) {
            log.error("getProperty\u65b9\u6cd5\u5165\u53c2\u5f02\u5e38, object:{}, proName:{}", object, (Object)proName);
            throw new ReqRespTypeException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
        Class<?> aClass = object.getClass();
        PropertyDescriptor propertyDp = BeanUtils.getPropertyDescriptor(aClass, (String)proName);
        assert (propertyDp != null);
        Method readMethod = propertyDp.getReadMethod();
        if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
            readMethod.setAccessible(true);
        }
        try {
            return readMethod.invoke(object, new Object[0]);
        }
        catch (Throwable ex) {
            log.error("\u83b7\u53d6{}\u7c7b\u4e2d\u7684{}\u5c5e\u6027\u65f6\u53d1\u751f\u5f02\u5e38", (Object)aClass.getName(), (Object)proName);
            log.error("\u5f02\u5e38\u5806\u6808", ex);
            return null;
        }
    }

    private static Object getApisToCoreReqBody(StanderRequest standerRequest, String proName) throws ReqRespTypeException {
        if (standerRequest == null || StrUtil.isEmpty((CharSequence)proName)) {
            return null;
        }
        Object serviceRequest = BaseApisParamUtil.getProperty((Object)standerRequest, (String)proName);
        if (ObjectUtils.isEmpty((Object)serviceRequest)) {
            return serviceRequest;
        }
        return BaseApisParamUtil.getProperty((Object)serviceRequest, (String)"requestBody");
    }

    private static ResponseHeadDTO getApisToCoreResHead(StanderResponse standerResponse, String proName) throws ReqRespTypeException {
        Object serviceResponse = BaseApisParamUtil.getProperty((Object)standerResponse, (String)proName);
        Object obj = BaseApisParamUtil.getProperty((Object)serviceResponse, (String)"responseHead");
        if (obj instanceof ResponseHeadDTO) {
            return (ResponseHeadDTO)obj;
        }
        return null;
    }

    private static Object getApisToCoreResBody(StanderResponse standerResponse, String proName) throws ReqRespTypeException {
        Object serviceResponse = BaseApisParamUtil.getProperty((Object)standerResponse, (String)proName);
        if (ObjectUtils.isEmpty((Object)serviceResponse)) {
            return serviceResponse;
        }
        return BaseApisParamUtil.getProperty((Object)serviceResponse, (String)"responseBody");
    }

    private static boolean isAllFieldEmptyExceptSpec(Object target, Set<String> specSet) {
        PropertyDescriptor[] targetPds;
        Class<?> actualEditable = target.getClass();
        for (PropertyDescriptor targetPd : targetPds = BeanUtils.getPropertyDescriptors(actualEditable)) {
            try {
                Object value;
                Method readMethod = targetPd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if (!ObjectUtil.isNotEmpty((Object)(value = readMethod.invoke(target, new Object[0]))) || specSet.contains(targetPd.getName()) || readMethod.getName().contains("Class")) continue;
                return false;
            }
            catch (Throwable ex) {
                log.error("\u51fd\u6570 isAllFieldEmptyExceptSpec \u51fa\u9519, \u5bf9\u8c61\u7c7b\u578b:{}, \u5b57\u6bb5:{}", (Object)target.getClass().getName(), (Object)targetPd.getName());
                log.error("\u5f02\u5e38\u5806\u6808", ex);
                return false;
            }
        }
        return true;
    }

    private static HashSet<String> getEmptyFieldName(Object target, Set<String> specSet) {
        Assert.notNull((Object)target, (String)"object must not be null");
        Class<?> actualEditable = target.getClass();
        HashSet<String> stringHashSet = new HashSet<String>();
        for (String curName : specSet) {
            try {
                Object value;
                PropertyDescriptor targetPd = BeanUtils.getPropertyDescriptor(actualEditable, (String)curName);
                if (targetPd == null) continue;
                Method readMethod = targetPd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if (!ObjectUtil.isEmpty((Object)(value = readMethod.invoke(target, new Object[0])))) continue;
                stringHashSet.add(targetPd.getName());
            }
            catch (Throwable ex) {
                log.error("\u51fd\u6570getEmptyFieldNameNew\u51fa\u9519, \u5bf9\u8c61\u7c7b\u578b:{}, \u5b57\u6bb5:{}", (Object)target.getClass().getName(), (Object)curName);
                log.error("\u5f02\u5e38\u5806\u6808", ex);
                stringHashSet.add(curName);
            }
        }
        return stringHashSet;
    }
}

