/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.jdhapp.util;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.expection.ReqRespTypeException;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.util.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ImgBatchUploadServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiReqmsgLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiReqmsgLogService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiProperties;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiServProperties;
import com.jdaz.sinosoftgz.coreapi.common.factory.CoreDtoConverterFactory;
import com.jdaz.sinosoftgz.coreapi.common.handler.CoreDtoConverter;
import com.jdaz.sinosoftgz.coreapi.h5img.MediaUploadApi;
import com.sinosoft.image.client.dto.ImgBatchUploadMetaDTO;
import com.sinosoft.image.client.dto.ImgBusiDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClaimMediaUtil {
    private static final Logger log = LoggerFactory.getLogger(ClaimMediaUtil.class);
    @Autowired
    CoreApiProperties coreApiProperties;
    @Autowired
    MediaUploadApi mediaUploadApi;
    @Autowired
    ApisBusiReqmsgLogService apisBusiReqmsgLogService;
    private final String SER_PROPERTIES_BATCH_UPLOAD_FILE = "batchUploadFile";
    @Autowired
    CoreDtoConverterFactory coreDtoConverterFactory;

    public void mediaExcute(Map<String, String> collectMap, String mediaCode, String mediaCodeName) throws ReqRespTypeException {
        for (Map.Entry<String, String> entry : collectMap.entrySet()) {
            String url = entry.getKey();
            String fileName = entry.getValue();
            String base64Str = OkHttpUtils.getBase64EncodeByUrl((String)url);
            log.warn("\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6587\u4ef6\u540d:{}", (Object)fileName);
            if (StringUtils.isEmpty((CharSequence)base64Str)) {
                log.error("\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,url:{}", (Object)url);
                continue;
            }
            String defaultClaimCode = "99930";
            String defaultImageCode = "999";
            ImgMetaDTO imgMetaDTO = ImgMetaDTO.builder().fileOrgName(fileName).imgType(mediaCode).imgTypeName(mediaCodeName).fileContentWithBase64Encode(base64Str).build();
            ArrayList<ImgMetaDTO> tarList = new ArrayList<ImgMetaDTO>();
            tarList.add(imgMetaDTO);
            StanderRequest request = StanderRequest.builder().build();
            request.setRequestHead(RequestHeadDTO.initRequestHead());
            ImgBatchUploadServiceRequest imgBatchUploadServiceRequest = ImgBatchUploadServiceRequest.builder().build();
            ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = ImgBatchUploadRequestDTO.builder().build();
            imgBatchUploadServiceRequest.setRequestBody(imgBatchUploadRequestDTO);
            request.setImgBatchUploadServiceRequest(imgBatchUploadServiceRequest);
            request.getImgBatchUploadServiceRequest().getRequestBody().setImgList(tarList);
            this.imgBatchUpload(request, request.getInforSupplementServiceRequest().getBody().getRegistNo());
            System.out.println("key = " + entry.getKey() + ", value = " + entry.getValue());
        }
    }

    public ClaimMediaCommitResult imgBatchUpload(StanderRequest request, String businessNo) throws ReqRespTypeException {
        long time = System.currentTimeMillis();
        Optional properties = this.coreApiProperties.getServProperties("batchUploadFile");
        if (!properties.isPresent()) {
            throw new ReqRespTypeException(ErrorBisCodeEnum.ERR_B80001.getValue(), ErrorBisCodeEnum.ERR_B80001.getKey());
        }
        com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = this.imgBatchUploadRequestBeforeProcess(request, properties, businessNo);
        ClaimMediaCommitResult responseDTO = this.mediaUploadApi.batchUpload(((CoreApiServProperties)properties.get()).getUrl(), imgBatchUploadRequestDTO, null);
        if (ObjectUtil.isEmpty((Object)responseDTO) || ObjectUtil.isEmpty((Object)responseDTO.getHeadDto())) {
            throw new ReqRespTypeException(ErrorBisCodeEnum.ERR_B80002.getValue(), ErrorBisCodeEnum.ERR_B80002.getKey());
        }
        if (responseDTO.getHeadDto().getStatus() < 0) {
            throw new ReqRespTypeException("\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u5931\u8d25\uff1a" + responseDTO.getHeadDto().getErrorMessage(), responseDTO.getHeadDto().getErrorCode());
        }
        ImgBatchUploadServiceResponse imgBatchUploadResponse = ImgBatchUploadServiceResponse.builder().build();
        imgBatchUploadResponse.setImgNodes(responseDTO.getImgNodes());
        int successSize = 0;
        try {
            successSize = responseDTO.getImgNodeList().size();
        }
        catch (NullPointerException e) {
            log.warn("\u5f71\u50cf\u8fd4\u56de\u7684nodeList\u4e3a\u7a7a");
        }
        log.warn("\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u54cd\u5e94\u62a5\u6587\u6210\u529f\u6570:{}", (Object)successSize);
        this.insertImgBatchUploadLog(request, responseDTO);
        return responseDTO;
    }

    private com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO imgBatchUploadRequestBeforeProcess(StanderRequest request, Optional<CoreApiServProperties> properties, String businessNo) {
        com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = new com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO();
        com.sinosoft.image.client.dto.RequestHeadDTO requestHeadDTO = new com.sinosoft.image.client.dto.RequestHeadDTO();
        requestHeadDTO.setSeqNo(UUID.randomUUID().toString().replace("-", ""));
        requestHeadDTO.setRequestTime(new Date());
        requestHeadDTO.setOptComCode("apis");
        requestHeadDTO.setOptUserCode("apis");
        requestHeadDTO.setOptUserName("apis");
        imgBatchUploadRequestDTO.setHeadDto(requestHeadDTO);
        ImgBusiDTO imgBusiDTO = new ImgBusiDTO();
        imgBusiDTO.setAppCode("CL");
        imgBusiDTO.setClassCode("CLA");
        imgBusiDTO.setBusinessNo(businessNo);
        imgBusiDTO.setBusiComCode("apis");
        imgBatchUploadRequestDTO.setBusiDto(imgBusiDTO);
        List imgBatchUploadMetaDTOS = this.compensateImgBatchUploadMeta(request);
        imgBatchUploadRequestDTO.setUploadMetas(imgBatchUploadMetaDTOS);
        requestHeadDTO.setConsumerID(properties.get().getUser());
        requestHeadDTO.setConsumerPWD(properties.get().getUserPwd());
        return imgBatchUploadRequestDTO;
    }

    public List<ImgBatchUploadMetaDTO> compensateImgBatchUploadMeta(StanderRequest request) {
        ArrayList<ImgBatchUploadMetaDTO> uploadMetaDTOList = new ArrayList<ImgBatchUploadMetaDTO>();
        try {
            log.warn("\u8fdb\u5165\u7ec4\u88c5\u56fe\u7247\u65b9\u6cd5");
            List imgMetaList = request.getImgBatchUploadServiceRequest().getRequestBody().getImgList();
            for (ImgMetaDTO imgMeta : imgMetaList) {
                ImgBatchUploadMetaDTO imgBatchUploadMetaDTO = new ImgBatchUploadMetaDTO();
                imgBatchUploadMetaDTO.setBase64FileContent(imgMeta.getFileContentWithBase64Encode());
                imgBatchUploadMetaDTO.setFileURL(imgMeta.getFileUrl());
                if (ObjectUtil.isEmpty((Object)imgMeta.getIsCovered())) {
                    imgBatchUploadMetaDTO.setCovered(true);
                } else {
                    imgBatchUploadMetaDTO.setCovered(imgMeta.getIsCovered().booleanValue());
                }
                if (ObjectUtil.isEmpty((Object)imgMeta.getFileOrgName())) {
                    if (ObjectUtil.isNotEmpty((Object)imgMeta.getFileName()) && ObjectUtil.isNotEmpty((Object)imgMeta.getExtendName())) {
                        imgBatchUploadMetaDTO.setFileOrgName(imgMeta.getFileName() + "." + imgMeta.getExtendName());
                    }
                } else {
                    imgBatchUploadMetaDTO.setFileOrgName(imgMeta.getFileOrgName());
                }
                if (ObjectUtil.isEmpty((Object)imgMeta.getImgType())) {
                    imgBatchUploadMetaDTO.setImgType("|999|");
                } else {
                    imgBatchUploadMetaDTO.setImgType("|" + imgMeta.getImgType() + "|");
                }
                if (ObjectUtil.isEmpty((Object)imgMeta.getImgTypeName())) {
                    imgBatchUploadMetaDTO.setImgTypeName("|\u5176\u4ed6|");
                } else {
                    imgBatchUploadMetaDTO.setImgTypeName("|" + imgMeta.getImgTypeName() + "|");
                }
                uploadMetaDTOList.add(imgBatchUploadMetaDTO);
            }
        }
        catch (Exception e) {
            log.error("\u7406\u8d54\u4e0a\u4f20\u5f71\u50cf\u5f02\u5e38,{}", (Throwable)e);
        }
        return uploadMetaDTOList;
    }

    private void insertImgBatchUploadLog(StanderRequest request, ClaimMediaCommitResult responseDTO) throws ReqRespTypeException {
        String orderNo = request.getImgBatchUploadServiceRequest().getRequestBody().getOrderNo();
        try {
            CoreDtoConverter converter = this.coreDtoConverterFactory.get("JSON");
            String api = "imgBatchUpload";
            String bodyStr = converter.toPacketStr((Object)responseDTO);
            ApisBusiReqmsgLog apisBusiReqmsgLog = new ApisBusiReqmsgLog();
            apisBusiReqmsgLog.setApiCode(api);
            apisBusiReqmsgLog.setLogContent(bodyStr);
            apisBusiReqmsgLog.setLogType("2");
            apisBusiReqmsgLog.setOrderNo(orderNo);
            apisBusiReqmsgLog.setCreator(request.getHeader().getUserCode());
            this.apisBusiReqmsgLogService.save((Object)apisBusiReqmsgLog);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u5f71\u50cf\u4e0a\u4f20\u62a5\u6587\u65f6\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)orderNo, (Object)e);
            throw new ReqRespTypeException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
    }
}

