/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.jdhapp.util;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.expection.ReqRespTypeException;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.rest.req.IcdInfoDto;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.rest.req.JdhClaimQuestionRequest;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.util.PolicyBusinessUtil;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.util.jdh.AesUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.ClaimOpenBillRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.ClaimOpenBillServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.CollectInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.CollectguideInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.CompensateInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.LossHealthInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.PayPersonInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RegistDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RegistDamageInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RegistDamagePersonDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RegistInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimOpenBillServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import com.jdaz.sinosoftgz.apis.constants.JdhErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimOpenBillApi;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class JdhClaimQuestionBusinessUtil {
    private static final Logger log = LoggerFactory.getLogger(JdhClaimQuestionBusinessUtil.class);
    @Autowired
    CoreClaimOpenBillApi coreClaimsApi;
    @Autowired
    private ApisChannelCodeMapper apisChannelCodeMapper;
    @Autowired
    private PolicyBusinessUtil policyBusinessUtil;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    private ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Value(value="${sign.jdh.aesIvStr}")
    private String aesIvStr;
    @Value(value="${sign.jdh.aesKey}")
    private String aesKey;
    public static String AGENCE_CODE = "AC600002";

    public void saveClaimQuestion(JdhClaimQuestionRequest jdhClaimQuestionRequest) throws ReqRespTypeException {
        this.validata(jdhClaimQuestionRequest);
        if (!jdhClaimQuestionRequest.getUuid().contains("\u6d4b\u8bd5")) {
            String idNumber = AesUtil.decrypt((String)jdhClaimQuestionRequest.getPatientCardId(), (String)this.aesKey, (String)this.aesIvStr);
            jdhClaimQuestionRequest.setPatientCardId(idNumber);
            log.warn("\u4eac\u4e1c\u5065\u5eb7\u89e3\u5bc6\u540e\u8eab\u4efd\u8bc1\u53f7\u4e3a\uff1a{}", (Object)idNumber);
        }
        log.warn("\u4eac\u4e1c\u5065\u5eb7\u4fdd\u9669\u4fe1\u606f\u540c\u6b65\u63a5\u6536\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)jdhClaimQuestionRequest));
        StanderRequest request = StanderRequest.builder().build();
        this.dataComplete(request, jdhClaimQuestionRequest);
        log.warn("\u4eac\u4e1c\u5065\u5eb7\uff0c\u95ee\u8bca\u4fe1\u606f\u3002\u8865\u5168\u540e\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)request));
        StanderResponse response = this.callClaimCore(request);
        if (!this.isExistRegist(response.getClaimOpenBillServiceResponse())) {
            this.saveRecord(request, response.getClaimOpenBillServiceResponse(), jdhClaimQuestionRequest);
        }
    }

    private void saveRecord(StanderRequest request, ClaimOpenBillServiceResponse claimOpenBillServiceResponse, JdhClaimQuestionRequest jdhClaimQuestionRequest) {
        ApisBusiRequestRegist apisBusiRequestRegist = new ApisBusiRequestRegist();
        ClaimOpenBillRequestDTO claimOpenBillRequestDTO = request.getClaimOpenBillServiceRequest().getBody();
        apisBusiRequestRegist.setRequestId(String.valueOf(jdhClaimQuestionRequest.getDiagId()));
        apisBusiRequestRegist.setPolicyNo(claimOpenBillRequestDTO.getPolicyNo());
        apisBusiRequestRegist.setRegistNo(claimOpenBillServiceResponse.getBody().getRegistNo());
        apisBusiRequestRegist.setDamageResult(claimOpenBillRequestDTO.getDamageResult());
        apisBusiRequestRegist.setDamageTime(claimOpenBillRequestDTO.getRegist().getRegistDamageInfo().getDamageTime());
        apisBusiRequestRegist.setCurrency("RMB");
        apisBusiRequestRegist.setSumRealPay(((CompensateInfoDTO)claimOpenBillRequestDTO.getCompensateInfoList().get(0)).getSumRealPay());
        apisBusiRequestRegist.setUserCode(AGENCE_CODE);
        apisBusiRequestRegist.setChannelCode(AGENCE_CODE);
        apisBusiRequestRegist.setChannelType(claimOpenBillRequestDTO.getReportType());
        this.apisBusiRequestRegistService.save((Object)apisBusiRequestRegist);
    }

    private boolean isExistRegist(ClaimOpenBillServiceResponse claimOpenBillServiceResponse) {
        ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRegistNo(claimOpenBillServiceResponse.getBody().getRegistNo());
        return ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist);
    }

    private void dataComplete(StanderRequest request, JdhClaimQuestionRequest jdhClaimQuestionRequest) throws ReqRespTypeException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        BigDecimal sumPremium = this.getPremium(jdhClaimQuestionRequest.getPartnerPolicyNo());
        try {
            request.setClaimOpenBillServiceRequest(ClaimOpenBillServiceRequest.builder().head(RequestHeadDTO.initRequestHead()).body(ClaimOpenBillRequestDTO.builder().externalID(jdhClaimQuestionRequest.getUuid()).reportType("19").step("endcase").damageResult("07").status("1").policyNo(jdhClaimQuestionRequest.getPartnerPolicyNo()).claimTime(simpleDateFormat.parse(jdhClaimQuestionRequest.getDiagCreateDate())).endCaseTime(simpleDateFormat.parse(jdhClaimQuestionRequest.getDiagCreateDate())).regist(this.getRegistDto(jdhClaimQuestionRequest, sumPremium)).compensateInfoList(this.getCompensateList(jdhClaimQuestionRequest, sumPremium)).collectInfo(this.getCollectInfo(jdhClaimQuestionRequest)).build()).build());
            request.getClaimOpenBillServiceRequest().getHead().setTransID(String.valueOf(jdhClaimQuestionRequest.getDiagId()));
        }
        catch (ParseException e) {
            log.error("\u4eac\u4e1c\u5065\u5eb7\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a{}", (Throwable)e);
            throw new ReqRespTypeException((ErrorCode)JdhErrorCodeEnum.ERR_B1002);
        }
    }

    private CollectInfoDTO getCollectInfo(JdhClaimQuestionRequest jdhClaimQuestionRequest) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CollectInfoDTO dto = CollectInfoDTO.builder().claimApplyTime(simpleDateFormat.parse(jdhClaimQuestionRequest.getDiagCreateDate())).notifyTime(simpleDateFormat.parse(jdhClaimQuestionRequest.getDiagCreateDate())).source("1").status("4").collectguideInfo(this.getCollectguideInfoDTO(jdhClaimQuestionRequest)).build();
        return dto;
    }

    private List<CollectguideInfoDTO> getCollectguideInfoDTO(JdhClaimQuestionRequest jdhClaimQuestionRequest) throws ParseException {
        ArrayList<CollectguideInfoDTO> list = new ArrayList<CollectguideInfoDTO>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CollectguideInfoDTO collectguideInfoDTO = CollectguideInfoDTO.builder().docCode("999").endDate(simpleDateFormat.parse(jdhClaimQuestionRequest.getDiagCreateDate())).docName("\u5176\u4ed6").build();
        list.add(collectguideInfoDTO);
        return list;
    }

    private List<CompensateInfoDTO> getCompensateList(JdhClaimQuestionRequest jdhClaimQuestionRequest, BigDecimal sumPremium) throws ReqRespTypeException, ParseException {
        ArrayList<CompensateInfoDTO> list = new ArrayList<CompensateInfoDTO>();
        CompensateInfoDTO dto = CompensateInfoDTO.builder().caseType("0").underwriteFlag("3").compensateType("1").sumRealPay(sumPremium.multiply(new BigDecimal(0.78)).setScale(2, 4)).lossHealthInfo(this.getLossHealthInfo(sumPremium)).payPersonInfo(this.getPayPersonInfo(jdhClaimQuestionRequest, sumPremium)).build();
        list.add(dto);
        return list;
    }

    private List<PayPersonInfoDTO> getPayPersonInfo(JdhClaimQuestionRequest jdhClaimQuestionRequest, BigDecimal sum) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<PayPersonInfoDTO> list = new ArrayList<PayPersonInfoDTO>();
        PayPersonInfoDTO dto = PayPersonInfoDTO.builder().certifyType("74").certifyNo("91321311MA20F5K389").payObjectKind("04").payeeName("\u5bbf\u8fc1\u4eac\u4e1c\u627f\u5065\u4fe1\u606f\u6280\u672f\u6709\u9650\u516c\u53f8").bankCode("104100000004").nationFlag("1").payeeNationality("\u4e2d\u56fd").payeeFee(sum.multiply(new BigDecimal(0.78)).setScale(2, 4)).bankName("\u4e2d\u56fd\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8\u5bbf\u8fc1\u5bbf\u8c6b\u652f\u884c").accountNo("466374042915").payment("02").payObjectType("2").otherCause("13").payNowFlag("1").thirdPartyPayTime(simpleDateFormat.parse(jdhClaimQuestionRequest.getDiagCreateDate())).build();
        list.add(dto);
        return list;
    }

    private List<LossHealthInfoDTO> getLossHealthInfo(BigDecimal sum) {
        ArrayList<LossHealthInfoDTO> list = new ArrayList<LossHealthInfoDTO>();
        LossHealthInfoDTO dto = LossHealthInfoDTO.builder().currencyL("RMB").payRate(new BigDecimal(100)).sumCalcPay(sum.multiply(new BigDecimal(0.78)).setScale(2, 4)).currencyP("RMB").sumRealPay(sum.multiply(new BigDecimal(0.78)).setScale(2, 4)).build();
        list.add(dto);
        return list;
    }

    private BigDecimal getPremium(String policyNo) throws ReqRespTypeException {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"policy_no", (Object)policyNo);
        queryWrapper.eq((Object)"deleted", (Object)0);
        ApisBusiChannelOrder apisBusiChannelOrder = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
        if (ObjectUtils.isNotEmpty((Object)apisBusiChannelOrder) && ObjectUtils.isNotEmpty((Object)apisBusiChannelOrder.getPremium())) {
            return apisBusiChannelOrder.getPremium();
        }
        PolicyDetailResponse policyDetailResponse = this.policyBusinessUtil.getPolicyDetail(policyNo);
        PolicyDTO dto = policyDetailResponse.getResponseBody().getPolicy();
        return new BigDecimal(dto.getMain().getSumPremium());
    }

    private RegistDTO getRegistDto(JdhClaimQuestionRequest jdhClaimQuestionRequest, BigDecimal sumPremium) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String value = this.apisChannelCodeMapper.getCoreValue(null, "hospital", jdhClaimQuestionRequest.getHospitalCode());
        String icdCode = ((IcdInfoDto)JSONArray.parseArray((String)jdhClaimQuestionRequest.getIcd10Str(), IcdInfoDto.class).get(0)).getIcd();
        String icdValue = this.apisChannelCodeMapper.getCoreValue(null, "ICD10", icdCode);
        RegistDTO dto = RegistDTO.builder().registInfo(RegistInfoDTO.builder().reportTime(new Date()).reportType("19").reportChannel(AGENCE_CODE).reportorName(jdhClaimQuestionRequest.getPatientName()).reportorRelation("00").build()).registDamageInfo(RegistDamageInfoDTO.builder().damageTime(simpleDateFormat.parse(jdhClaimQuestionRequest.getDiagCreateDate())).damageReasonType("1").damageCode(ObjectUtils.isEmpty((Object)icdValue) ? "Z87.8" : icdCode).damageResult("07").nationFlag("1").provinceCode("999999").countryCode("999999").countyName("\u5168\u4e2d\u56fd").provinceName("\u5168\u4e2d\u56fd").countyCode("999999").countyName("\u5168\u4e2d\u56fd").cityCode("999999").cityName("\u5168\u4e2d\u56fd").accidentAddress("\u4e2d\u56fd\u5883\u5185").damageRemark(jdhClaimQuestionRequest.getDiseaseDesc()).currency("RMB").reportedLoss(sumPremium.multiply(new BigDecimal(0.78)).setScale(2, 4)).hospitalCode(ObjectUtils.isEmpty((Object)value) ? "9999999" : jdhClaimQuestionRequest.getHospitalCode()).hospitalName(ObjectUtils.isEmpty((Object)value) ? "\u672c\u4ee3\u7801\u8868\u4e2d\u4e0d\u5b58\u5728\u7684\u5176\u4ed6\u533b\u9662" : value).diagnosis(jdhClaimQuestionRequest.getPossible()).build()).registDamagePersonInfo(RegistDamagePersonDTO.builder().damagePersonName(jdhClaimQuestionRequest.getPatientName()).identifyType("01").identifyNo(jdhClaimQuestionRequest.getPatientCardId()).reportorRelation("00").build()).build();
        return dto;
    }

    private StanderResponse callClaimCore(StanderRequest request) throws ReqRespTypeException {
        StanderResponse claimOpenBillServiceResponse = this.coreClaimsApi.claimsOpenBill(request);
        try {
            if (ObjectUtils.isNotEmpty((Object)claimOpenBillServiceResponse.getClaimOpenBillServiceResponse().getHead().getErrorCode())) {
                throw new ReqRespTypeException(claimOpenBillServiceResponse.getClaimOpenBillServiceResponse().getHead().getErrorMessage(), claimOpenBillServiceResponse.getClaimOpenBillServiceResponse().getHead().getErrorCode());
            }
        }
        catch (NullPointerException e) {
            throw new ReqRespTypeException((ErrorCode)JdhErrorCodeEnum.ERR_B1006);
        }
        return claimOpenBillServiceResponse;
    }

    public void validata(JdhClaimQuestionRequest jdhClaimQuestionRequest) throws ReqRespTypeException {
        List list = jdhClaimQuestionRequest.getNotNullName();
        String[] fieldNames = JdhClaimQuestionBusinessUtil.getFiledName((Object)jdhClaimQuestionRequest);
        for (int j = 0; j < fieldNames.length; ++j) {
            Object value;
            String name = fieldNames[j];
            if (!list.contains(name) || (value = JdhClaimQuestionBusinessUtil.getFieldValueByName((String)name, (Object)jdhClaimQuestionRequest)) != null) continue;
            throw new ReqRespTypeException(JdhErrorCodeEnum.ERR_B1005.getValue().replaceAll("XX", name), JdhErrorCodeEnum.ERR_B1005.getKey());
        }
    }

    private static String[] getFiledName(Object o) {
        Field[] fields = o.getClass().getDeclaredFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    private static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }
}

