/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.jdhapp.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.expection.ReqRespTypeException;
import com.jdaz.sinosoftgz.apis.business.app.jdhapp.util.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.HashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PolicyBusinessUtil {
    private static final Logger log = LoggerFactory.getLogger(PolicyBusinessUtil.class);
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    CoreInsureApi coreInsureApi;
    private static final String IS_POLICYSTATUS_FALG = "Y";

    public PolicyDetailResponse getPolicyDetail(String policyNo) throws ReqRespTypeException {
        PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().build();
        policyDetailServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        policyDetailServiceRequest.setRequestBody(PolicyDetailRequestDTO.builder().policyNo(policyNo).businessNature2("all").operateCode("all").build());
        StanderRequest request = StanderRequest.builder().policyDetailServiceRequest(policyDetailServiceRequest).build();
        StanderResponse standerResponse = this.execute(request);
        BaseApisParamUtil.verificationResponse((StanderResponse)standerResponse, (String)"policyDetailResponse");
        return standerResponse.getPolicyDetailResponse();
    }

    public StanderResponse execute(StanderRequest request) throws ReqRespTypeException {
        ApisBusiChannelOrder apisBusinessChannelOrder;
        QueryWrapper queryWrapper;
        this.requestCheck(request);
        StanderResponse standerResponse = null;
        boolean isQueryDetail = true;
        if (ObjectUtil.isNotEmpty((Object)request.getHeader()) && "kuayuePolicyDetail".equals(request.getHeader().getBussinessType())) {
            if (StrUtil.isNotBlank((CharSequence)request.getPolicyDetailServiceRequest().getRequestBody().getKuayueApplyNo())) {
                ApisBusiChannelOrder apisBusiChannelOrderQuery = new ApisBusiChannelOrder();
                apisBusiChannelOrderQuery.setProposalNo(request.getPolicyDetailServiceRequest().getRequestBody().getKuayueApplyNo());
                apisBusiChannelOrderQuery.setAgentCode(request.getHeader().getChannelCode());
                queryWrapper = new QueryWrapper((Object)apisBusiChannelOrderQuery);
                apisBusinessChannelOrder = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
                if (null != apisBusinessChannelOrder && StrUtil.isNotBlank((CharSequence)apisBusinessChannelOrder.getPolicyNo())) {
                    request.getPolicyDetailServiceRequest().getRequestBody().setPolicyNo(apisBusinessChannelOrder.getPolicyNo());
                } else {
                    isQueryDetail = false;
                }
            } else {
                isQueryDetail = false;
            }
        }
        if (isQueryDetail) {
            if (StringUtils.isNotEmpty((CharSequence)request.getPolicyDetailServiceRequest().getRequestBody().getIsStatusQueryFlag()) && request.getPolicyDetailServiceRequest().getRequestBody().getIsStatusQueryFlag().equals(IS_POLICYSTATUS_FALG)) {
                standerResponse = this.coreInsureApi.policyDetail(request);
                if (standerResponse.getPolicyDetailResponse().getResponseHead().getStatus() == 0 && ObjectUtils.isEmpty((Object)standerResponse.getPolicyDetailResponse().getResponseBody())) {
                    ApisBusiChannelOrder apisBusinessChannelOrderExample = new ApisBusiChannelOrder();
                    apisBusinessChannelOrderExample.setPolicyNo(request.getPolicyDetailServiceRequest().getRequestBody().getPolicyNo());
                    apisBusinessChannelOrderExample.setAgentCode(request.getHeader().getChannelCode());
                    queryWrapper = new QueryWrapper((Object)apisBusinessChannelOrderExample);
                    apisBusinessChannelOrder = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
                    if (apisBusinessChannelOrder != null && !"04".equals(apisBusinessChannelOrder.getStatus())) {
                        PolicyDetailResponseDTO responseDTO = PolicyDetailResponseDTO.builder().policy(PolicyDTO.builder().main(MainDTO.builder().build()).build()).build();
                        standerResponse.getPolicyDetailResponse().setResponseBody(responseDTO);
                        standerResponse.getPolicyDetailResponse().getResponseBody().getPolicy().getMain().setPolicyStatus("60");
                        standerResponse.getPolicyDetailResponse().getResponseBody().getPolicy().getMain().setPolicyNo(apisBusinessChannelOrder.getPolicyNo());
                        standerResponse.getPolicyDetailResponse().getResponseHead().setStatus(CommonConstant.FccbResponseCode.SUCCESS.intValue());
                    }
                }
            } else {
                long startTime = System.currentTimeMillis();
                standerResponse = this.coreInsureApi.policyDetail(request);
                log.warn("\u7eed\u4fdd\u67e5\u8be2\u4fdd\u5355\u8be6\u60c5\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
            }
        }
        return standerResponse;
    }

    private void requestCheck(StanderRequest request) throws ReqRespTypeException {
        PolicyDetailRequestDTO policyDetailRequestDTO = request.getPolicyDetailServiceRequest().getRequestBody();
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>(16);
        if (ObjectUtil.isEmpty((Object)request.getHeader()) || !"kuayuePolicyDetail".equals(request.getHeader().getBussinessType())) {
            stringStringHashMap.put("policyNo", "\u4fdd\u9669\u5355\u53f7");
        }
        stringStringHashMap.put("businessNature2", "\u9500\u552e\u6e20\u9053");
        stringStringHashMap.put("operateCode", "\u64cd\u4f5c\u5458");
        BaseApisParamUtil.checkFieldThrowExp((Object)policyDetailRequestDTO, stringStringHashMap, (ErrorCode)ErrorNullValueCodeEnum.ERR_N51000);
    }
}

